/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Properties;
import oracle.opatch.BackupFailureException;
import oracle.opatch.Bug;
import oracle.opatch.ExitOPatchException;
import oracle.opatch.Help;
import oracle.opatch.InitReadMeAction;
import oracle.opatch.InitScriptAction;
import oracle.opatch.OPatchACL;
import oracle.opatch.OPatchActionExecutor;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchExternalFactory;
import oracle.opatch.OPatchSDK;
import oracle.opatch.OPatchSession;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OPatchStateManagerFactory;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchObject;
import oracle.opatch.PatchObjectUtil;
import oracle.opatch.PatchmdXml;
import oracle.opatch.PostReadMeAction;
import oracle.opatch.PostScriptAction;
import oracle.opatch.PreReadMeAction;
import oracle.opatch.PreScriptAction;
import oracle.opatch.PrereqFailedException;
import oracle.opatch.Rac;
import oracle.opatch.RacFileCreator;
import oracle.opatch.RacProcessor;
import oracle.opatch.Rollbackable;
import oracle.opatch.Rules;
import oracle.opatch.SQLUtilities;
import oracle.opatch.StringResource;
import oracle.opatch.SystemCall;
import oracle.opatch.ipm.IIPMRWServices;
import oracle.opatch.ipm.IPM;
import oracle.opatch.ipm.IPMUtil;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchutil.cleanuphome.InactivePatchesUtil;
import oracle.opatch.wrappers.WrapperFactory;

public class RollbackSession
extends OPatchSession
implements Help {
    protected static String sessionName = "RollbackSession";
    private static boolean calledFromUtil = false;
    private PatchObject NROLLBACK_PATCHOBJECT = null;

    protected RollbackSession(String name, boolean readOnly) {
        super(name, readOnly);
    }

    private static void backupPatchActionsAndCreateRestoreFile(String oracleHomePath, PatchObject patchObject) {
        RollbackSession.backupPatchActionsAndCreateRestoreFile(oracleHomePath, patchObject, false, patchObject);
    }

    protected void generateRacFiles(String oracleHomePath, PatchObject patchObject, String cookedPatchID, String patchID) throws IOException {
        StringBuffer buff = new StringBuffer("RollbackSession::backupPatchActionsAndCreateRestoreFile() ");
        buff.append("generates rac-affected file list to be used during RAC process, if there is RAC.");
        OLogger.debug(buff);
        boolean createRacFile = OPatchEnv.isCreateRacFile();
        if (!createRacFile) {
            buff = new StringBuffer("Users request no RAC file generation.  Do not create files.");
            OLogger.verbose(this, buff);
            return;
        }
        String ouiPatchXML = IPMUtil.getOuiPatchXMLLocation(StringResource.getLiteralOracleHome());
        boolean apply = false;
        boolean rollback = true;
        boolean auto_rb = false;
        try {
            patchObject.createFP(this, oracleHomePath, cookedPatchID, patchID, ouiPatchXML);
        }
        catch (IOException e2) {
            buff = new StringBuffer(" PatchObject::createRacCopyFile(): ");
            buff.append(e2.getMessage());
            OLogger.debug(buff);
            RuntimeException re = new RuntimeException(buff.toString());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        try {
            patchObject.createRC(this, oracleHomePath, cookedPatchID, patchID);
        }
        catch (IOException e3) {
            buff = new StringBuffer(" PatchObject::createRCFile(): ");
            buff.append(e3.getMessage());
            OLogger.debug(buff);
            RuntimeException re = new RuntimeException(buff.toString());
            re.setStackTrace(e3.getStackTrace());
            throw re;
        }
        catch (RuntimeException e4) {
            buff = new StringBuffer(" PatchObject::createRCFile(): ");
            buff.append(e4.getMessage());
            OLogger.debug(buff);
            RuntimeException re = new RuntimeException(buff.toString());
            re.setStackTrace(e4.getStackTrace());
            throw re;
        }
        try {
            String patchStorage = OPatchEnv.getPatchStorageDirectoryPath(StringResource.getLiteralOracleHome(), cookedPatchID);
            buff = new StringBuffer("RollbackSession:: calling PatchObject to create the DP list: ");
            buff.append("patchStorage=\"");
            buff.append(patchStorage);
            buff.append("\"");
            OLogger.debug(buff);
            patchObject.createDP(this, oracleHomePath, cookedPatchID, patchID, patchStorage);
        }
        catch (IOException e5) {
            buff = new StringBuffer("   PatchObject::createRacDP() throws IOException: ");
            buff.append(e5.getMessage());
            OLogger.debug(buff);
            throw new IOException(buff.toString(), e5);
        }
        try {
            patchObject.createFR(this, oracleHomePath, cookedPatchID, patchID);
        }
        catch (IOException e6) {
            buff = new StringBuffer(" PatchObject::createRacRemoveFile(): ");
            buff.append(e6.getMessage());
            OLogger.debug(buff);
            IOException io = new IOException(buff.toString());
            io.setStackTrace(e6.getStackTrace());
            throw io;
        }
        try {
            String oneOffs = OPatchEnv.getPatchFilemapInfoLoc(StringResource.getLiteralOracleHome(), patchID);
            String patchStorage = OPatchEnv.getPatchStorageDirectoryPath(StringResource.getLiteralOracleHome(), cookedPatchID);
            buff = new StringBuffer("RollbackSession:: calling PatchObject to list dirs. ");
            buff.append("into a file for later RAC removal: \"");
            buff.append(oneOffs);
            buff.append("\"");
            OLogger.debug(buff);
            patchObject.createDR(this, oracleHomePath, cookedPatchID, patchID, oneOffs, patchStorage);
        }
        catch (IOException e7) {
            buff = new StringBuffer(" PatchObject::createRacRemoveDir(): ");
            buff.append(e7.getMessage());
            OLogger.debug(buff);
            IOException io = new IOException(buff.toString());
            io.setStackTrace(e7.getStackTrace());
            throw io;
        }
        buff = new StringBuffer("RollbackSession:: creating the FP and DP final");
        OLogger.debug(buff);
        RacFileCreator.createFpDpFrDrRcFinal(oracleHomePath, cookedPatchID, patchID);
        RacFileCreator.createRacModeFile(oracleHomePath, cookedPatchID, apply, rollback, auto_rb);
    }

    protected static void backupPatchActionsAndCreateRestoreFile(String oracleHomePath, PatchObject patchObject, boolean calledFromApply, PatchObject applyPatchObject) throws RuntimeException {
        block26: {
            StringBuffer buff = new StringBuffer("RollbackSession::backupPatchActionsAndCreateRestoreFile()");
            buff.append(" Oracle Home = ");
            buff.append(oracleHomePath);
            buff.append(" Patch Object =\n");
            buff.append(patchObject.toString());
            OLogger.debug(buff);
            if (!patchObject.shouldCreateRestoreFile()) {
                buff = new StringBuffer("RollbackSession skips creating the restore file ");
                buff.append("per PatchObject's request.");
                OLogger.debug(buff);
                if (Rules.SystemWrite_continue()) {
                    patchObject.backupForRestore(oracleHomePath, sessionName, applyPatchObject);
                }
                return;
            }
            String patchID = patchObject.getPatchID();
            String cookedPatchID = patchObject.getCookedPatchID();
            if (calledFromApply) {
                cookedPatchID = applyPatchObject.getCookedPatchID();
            }
            String patchLocation = patchObject.getPatchLocation();
            boolean ignoreBackupError = false;
            if (!calledFromApply) {
                String backupPath = OPatchEnv.getBackupDirectoryPath(oracleHomePath, cookedPatchID);
                boolean debug = true;
                Path dir = WrapperFactory.getNioServiceWrapper().getPath(backupPath, new String[0]);
                if (Files.exists(dir, new LinkOption[0])) {
                    SystemCall.deleteRecurse(oracleHomePath, cookedPatchID, dir, debug);
                }
                OPatchEnv.setupPatchRestore(oracleHomePath, cookedPatchID);
                boolean createRacFile = OPatchEnv.isCreateRacFile();
                if (!createRacFile) {
                    buff = new StringBuffer("Users request no RAC file generation.  Do not clean up sub-dir 'rac'.");
                    OLogger.verbose(null, buff);
                } else {
                    String racPath = OPatchEnv.getPatchStorageRacDirectoryPath(oracleHomePath, cookedPatchID);
                    dir = WrapperFactory.getNioServiceWrapper().getPath(racPath, new String[0]);
                    if (Files.exists(dir, new LinkOption[0])) {
                        SystemCall.deleteRecurse(oracleHomePath, cookedPatchID, dir, debug);
                    }
                }
                try {
                    buff = new StringBuffer("RollbackSession creates the restore file.");
                    OLogger.debug(buff);
                    OPatchEnv.createRestoreFile(oracleHomePath, cookedPatchID);
                }
                catch (IOException e2) {
                    OLogger.warn("OUI-67066");
                    RuntimeException re = new RuntimeException(e2.getMessage());
                    re.setStackTrace(e2.getStackTrace());
                    throw re;
                }
                if (Rules.OUIWrite_continue()) {
                    Path dstFile;
                    Path srcFile;
                    String contentsXMLDst;
                    String contentsXMLSrc;
                    block25: {
                        buff = new StringBuffer("RollbackSession: back up Oracle Home inventory");
                        OLogger.log(OLogger.FINE, buff.toString());
                        String backupDir = OPatchEnv.getBackupDirectoryPath(oracleHomePath, cookedPatchID);
                        String oneOffsSrc = IPMUtil.getOneoffsLocation(oracleHomePath);
                        String oneOffsDst = IPMUtil.getOneoffsLocation(backupDir);
                        contentsXMLSrc = IPMUtil.getCompsXMLLocation(oracleHomePath);
                        contentsXMLDst = IPMUtil.getCompsXMLLocation(backupDir);
                        buff = new StringBuffer("RollbackSession: back up Oracle Home Inventory oneoffs");
                        OLogger.log(OLogger.FINE, buff.toString());
                        srcFile = WrapperFactory.getNioServiceWrapper().getPath(oneOffsSrc, new String[0]);
                        dstFile = WrapperFactory.getNioServiceWrapper().getPath(oneOffsDst, new String[0]);
                        if (Files.exists(srcFile, new LinkOption[0])) {
                            try {
                                if (!Files.exists(dstFile, new LinkOption[0])) {
                                    buff = new StringBuffer("Creating directory \"");
                                    buff.append(dstFile.toString());
                                    buff.append("\"");
                                    OLogger.log(OLogger.FINEST, buff.toString());
                                    try {
                                        Files.createDirectories(dstFile, new FileAttribute[0]);
                                    }
                                    catch (IOException e3) {
                                        OLogger.debug(e3.getMessage());
                                    }
                                }
                                SystemCall.backupRecurse(srcFile, dstFile, debug);
                            }
                            catch (RuntimeException e4) {
                                OPatchStateManagerFactory.getInstance().setErrorCode(46);
                                OLogger.error("OUI-67083", new Object[]{sessionName, oneOffsSrc});
                                buff = new StringBuffer(OLogger.getString("OUI-67083", new Object[]{sessionName, oneOffsSrc}));
                                ignoreBackupError = OPatchEnv.proceedWithOperationDefaultNo(buff);
                                if (ignoreBackupError) break block25;
                                throw e4;
                            }
                        }
                    }
                    if (!OPatchEnv.isNextGen()) {
                        buff = new StringBuffer("RollbackSession: back up Oracle Home Inventory comps.xml");
                        OLogger.log(OLogger.FINE, buff.toString());
                        srcFile = WrapperFactory.getNioServiceWrapper().getPath(contentsXMLSrc, new String[0]);
                        dstFile = WrapperFactory.getNioServiceWrapper().getPath(contentsXMLDst, new String[0]);
                        if (Files.exists(srcFile, new LinkOption[0])) {
                            try {
                                SystemCall.backupFile(srcFile, dstFile);
                            }
                            catch (RuntimeException e5) {
                                OPatchStateManagerFactory.getInstance().setErrorCode(47);
                                OLogger.error("OUI-67083", new Object[]{sessionName, contentsXMLSrc});
                                buff = new StringBuffer(OLogger.getString("OUI-67083", new Object[]{sessionName, contentsXMLSrc}));
                                ignoreBackupError = OPatchEnv.proceedWithOperationDefaultNo(buff);
                                if (ignoreBackupError) break block26;
                                throw e5;
                            }
                        }
                    }
                }
            }
        }
        if (Rules.SystemWrite_continue()) {
            try {
                patchObject.backupForRestore(oracleHomePath, sessionName, applyPatchObject);
            }
            catch (RuntimeException e6) {
                OPatchStateManagerFactory.getInstance().setErrorCode(49);
                throw e6;
            }
        }
        if (Rules.SystemWrite_continue()) {
            OPatchSessionHelper.setupRLibBackupDir(oracleHomePath, patchObject.getCookedPatchID());
        }
    }

    protected void autoRollback(String oracleHomePath, IIPMRWServices rwServices, PatchObject patchObject, String localNode, boolean calledFromApply, PatchObject applyPatchObject) throws RuntimeException, Error {
        StringBuffer buff = new StringBuffer("RollbackSession::autoRollback()");
        OLogger.debug(buff);
        OPatchEnv.setNeedConflictMapReload(true);
        boolean invRead = Rules.OUIRead_continue();
        boolean invWrite = Rules.OUIWrite_continue();
        boolean systemWrite = Rules.SystemWrite_continue();
        if (patchObject == null) {
            RuntimeException re = new RuntimeException("PatchObject is NULL");
            throw re;
        }
        if (invWrite && !rwServices.isInventoryLoaded()) {
            throw new RuntimeException("Inventory is NULL");
        }
        String patchID = patchObject.getPatchID();
        boolean noPrePost = patchObject.isAllPrePostDisabled();
        if (!calledFromUtil && !OPatchEnv.isRunSql()) {
            Properties p2 = OPatchSessionHelper.getSqlPropertyFromFile(oracleHomePath, patchObject.getCookedPatchID());
            boolean propSqlValue = false;
            if (p2 != null) {
                propSqlValue = Boolean.valueOf(p2.getProperty("RUNSQL"));
            }
            if (propSqlValue) {
                boolean shouldErrorOut = Rules.shouldTryToErrorOutOnRunSql();
                String sType = "";
                sType = calledFromApply ? "auto-rollback" : "rollback";
                if (shouldErrorOut) {
                    String runSqlValidation = OLogger.getString("OUI-67267", new Object[]{patchID, sType});
                    OLogger.println(runSqlValidation);
                    throw new RuntimeException(runSqlValidation);
                }
                OLogger.warn("OUI-67268", new Object[]{patchID, sType});
            }
        }
        if (calledFromApply) {
            buff = new StringBuffer("AutoRollbackSession: Rolling back patch ID '");
            buff.append(patchID);
            buff.append("'");
            OLogger.log(OLogger.FINE, buff.toString());
        }
        buff = new StringBuffer("   rolling back patch ID ");
        buff.append(patchID);
        OLogger.debug(buff);
        OneOffEntry[] oneOffs = new OneOffEntry[]{};
        oneOffs = rwServices.getInstalledPatches();
        if (applyPatchObject != null) {
            boolean patchPresent = false;
            for (int i2 = 0; i2 < oneOffs.length; ++i2) {
                if (!oneOffs[i2].getID().equals(patchID)) continue;
                patchPresent = true;
                break;
            }
            if (!patchPresent) {
                OneOffEntry[] inactiveOneOffs = rwServices.getInactivePatches();
                boolean patchMatcheswithInactive = false;
                OLogger.printlnOnLog("INFO : Checking if patch is part of inactive list to perform deleteInactive");
                for (int i3 = 0; i3 < inactiveOneOffs.length; ++i3) {
                    OneOffEntry inactive = inactiveOneOffs[i3];
                    String inactiveID = inactive.getID();
                    if (!inactiveID.equals(patchID)) continue;
                    patchMatcheswithInactive = true;
                    OLogger.printlnOnLog("INFO : Patch " + patchID + " is part of Inactive list");
                    break;
                }
                if (patchMatcheswithInactive) {
                    InactivePatchesUtil inactivePatchesUtil = new InactivePatchesUtil();
                    if (OPatchEnv.isReport()) {
                        OLogger.printlnOnLog("INFO : No need to run deleteInactive as it is report mode");
                    } else {
                        try {
                            OLogger.printlnOnLog("INFO : Delete the patch " + patchID + " from Inventory");
                            inactivePatchesUtil.deletePatch(patchID);
                            OLogger.printlnOnLog("INFO : Success -> Inactive patch " + patchID + " is removed");
                        }
                        catch (Throwable throwable) {
                            OLogger.printlnOnLog("SEVERE : Unable to deleteInactive patch " + patchID);
                            throwable.printStackTrace();
                        }
                    }
                } else {
                    throw new RuntimeException(OLogger.getString("OUI-67201", new Object[]{patchID}));
                }
            }
        }
        if (systemWrite || invWrite) {
            OPatchSession.setOracleHomeHasBeenModified(this);
        }
        OPatchStateManagerFactory.getInstance().setCurrentState("Pre-script processing");
        if (noPrePost) {
            buff = new StringBuffer("   Pre actions of this patch ");
            buff.append(patchObject.getPatchID());
            buff.append(" have been disabled. They will not be invoked.");
            OLogger.debug(buff);
        } else {
            patchObject.getPreReadMeAction().process();
            String topLevelOperation = calledFromApply ? "apply" : "rollback";
            String topLevelPatchID = !calledFromApply ? patchObject.getPatchID() : applyPatchObject.getPatchID();
            buff = new StringBuffer("   Process PreScriptAction() ");
            OLogger.debug(buff);
            PreScriptAction preScript = patchObject.getPreScriptAction();
            String preArg = OPatchSessionHelper.getPreScriptActionArgumentForRollBack(patchObject.getPatchID());
            int preReturnVal = preScript.process(preArg, topLevelOperation, topLevelPatchID);
            OLogger.justlog(OLogger.INFO, "Rollback preScript for patch " + patchObject.getPatchID() + " processed.");
            if (preReturnVal != 0) {
                String preMsg = OLogger.getString("OUI-67133", new Object[]{"PRE", Integer.toString(preReturnVal)});
                OLogger.warn("OUI-67133", new Object[]{"PRE", Integer.toString(preReturnVal)});
                if (!Rules.shouldContinueInCaseOfPrePostError("")) {
                    RuntimeException preRe = new RuntimeException(preMsg);
                    throw preRe;
                }
            }
        }
        OPatchStateManagerFactory.getInstance().setCurrentState("Patch Oracle Home for rollback");
        this.rollback(oracleHomePath, patchObject, rwServices, calledFromApply, applyPatchObject);
        if (invWrite) {
            try {
                buff = new StringBuffer("Verifying if inventory updation has gone fine....");
                OLogger.log(OLogger.FINE, buff.toString());
                buff = new StringBuffer("   reload() inventory ");
                OLogger.debug(buff);
                boolean found = false;
                String rollbackedPatchID = patchObject.getTripletPatchID();
                if (!OPatchEnv.isCUPSupported()) {
                    rwServices.reloadInventory();
                    oneOffs = rwServices.getInstalledPatches();
                    for (int i4 = 0; i4 < oneOffs.length; ++i4) {
                        OneOffEntry oneOff = oneOffs[i4];
                        if (!rollbackedPatchID.equalsIgnoreCase(oneOff.getTripletID()) || !Rules.SystemWrite_continue()) continue;
                        found = true;
                        break;
                    }
                }
                if (found) {
                    OLogger.debug(new StringBuffer("RollbackSession: rollback of the patch went w/o error."));
                    OLogger.debug(new StringBuffer("However, OPatch finds the just-rollbacked patch in the reloaded inventory."));
                    OLogger.error("OUI-67023", new Object[]{rollbackedPatchID});
                    throw new RuntimeException("RollbackSession::autoRollback() failed");
                }
                OLogger.log(OLogger.FINEST, "Rollback goes thru OK for sure.");
                buff = new StringBuffer("Inventory is updated with the patch details.");
                OLogger.log(OLogger.FINE, buff.toString());
            }
            catch (RuntimeException e2) {
                throw e2;
            }
            finally {
                buff = new StringBuffer("RollbackSession::autoRollback() done.");
                buff.append("  Now executing post actions, ignore errors");
                OLogger.debug(buff);
            }
        }
        OPatchStateManagerFactory.getInstance().setCurrentState("Post-script processing");
        if (noPrePost) {
            buff = new StringBuffer("   Pre/Post actions of this patch ");
            buff.append(patchObject.getPatchID());
            buff.append(" have been disabled. They will not be invoked.");
            OLogger.debug(buff);
        } else {
            patchObject.getPostReadMeAction().process();
            PostScriptAction postScriptAction = patchObject.getPostScriptAction();
            String postArg = OPatchSessionHelper.getPostScriptActionArgumentForRollBack(patchObject.getPatchID());
            String topLevelOperation = calledFromApply ? "apply" : "rollback";
            String topLevelPatchID = !calledFromApply ? patchObject.getPatchID() : applyPatchObject.getPatchID();
            int postReturnVal = patchObject.getPostScriptAction().process(postArg, topLevelOperation, topLevelPatchID);
            if (postReturnVal != 0) {
                String postMsg = OLogger.getString("OUI-67133", new Object[]{"POST", Integer.toString(postReturnVal)});
                OLogger.warn("OUI-67133", new Object[]{"POST", Integer.toString(postReturnVal)});
                if (!Rules.shouldContinueInCaseOfPrePostError("")) {
                    OPatchStateManagerFactory.getInstance().setErrorCode(201);
                    RuntimeException postRe = new RuntimeException(postMsg);
                    throw postRe;
                }
            }
        }
        if (!calledFromApply) {
            PatchObject[] poArray = new PatchObject[]{patchObject};
            try {
                RollbackSession.autoRollbackDelayedActions(calledFromApply, poArray, oracleHomePath);
            }
            catch (Exception e3) {
                throw new RuntimeException(e3);
            }
        }
        buff = new StringBuffer("autoRollback() done ");
        OLogger.debug(buff);
    }

    protected OPatchSessionHelper.LocalInfo processLocal(String oracleHomePath, String patchLocation, String patchID, boolean local, boolean minDowntime, boolean allNode, boolean silent) throws RuntimeException, Error {
        boolean shouldPromptForStartup;
        boolean createInterimInventoryFile = true;
        String msg = null;
        IIPMRWServices rwServices = IPM.INSTANCE.getRWServices();
        PatchObject patchObject = null;
        StringBuffer buff = new StringBuffer("RollbackSession::processLocal()");
        String localNode = "local system";
        OLogger.debug(buff);
        boolean isShutdown = true;
        String thisSystem = "local system";
        Rac.RacType racType = null;
        Rules.RacPatchOrder order = null;
        String[] remoteNodes = new String[]{};
        boolean rolling = false;
        boolean invRead = Rules.OUIRead_continue();
        boolean invWrite = Rules.OUIWrite_continue();
        boolean systemWrite = Rules.SystemWrite_continue();
        String cookedID = "";
        RacProcessor.MinDowntimeNodeSelection selects = null;
        Rac rac = OPatchExternalFactory.getRac(oracleHomePath);
        try {
            StringBuffer ts;
            RuntimeException re;
            if (invRead) {
                boolean compMissing = false;
                OLogger.debug(new StringBuffer("RollbackSession::processLocal(): load the inventory"));
                try {
                    rwServices = this.loadInventory(oracleHomePath, patchID);
                    OPatchEnv.setDesiredHome(rwServices.isDesiredHome());
                    PatchObject po = PatchObject.getInstance(oracleHomePath, patchID);
                    if (po != null && po.getPatchInventory().mayBeTranslation() && !OPatchEnv.isOPatchSDKMode()) {
                        OneOffEntry oneoff = rwServices.getLatestTranslationPatch(po.getOriginalPatchID(), po.getPatchInventory().getPatchLanguage());
                        if (oneoff != null) {
                            patchID = oneoff.getID();
                        }
                        po.setOneOffEntryObj(oneoff);
                    }
                    racType = rac.getInstance(rwServices);
                    order = Rules.getRacPatchOrder(racType, local, rolling, minDowntime, allNode, silent);
                    localNode = racType.getLocalNode();
                    remoteNodes = racType.getRemoteNodes();
                    OPatchEnv.setLocalNode(localNode);
                }
                catch (RuntimeException e2) {
                    throw e2;
                }
                catch (Exception e3) {
                    throw new RuntimeException(e3);
                }
            } else {
                buff = new StringBuffer("RollBackSession::processLocal(): getting racType with null homeInfo...:\n");
                OLogger.debug(buff);
                racType = rac.getInstance(null);
            }
            if (!calledFromUtil) {
                RollbackSession.validateConnectStringNodes(localNode, remoteNodes);
            }
            try {
                String cookedPatchID;
                try {
                    if (this.NROLLBACK_PATCHOBJECT == null) {
                        createInterimInventoryFile = true;
                        buff = new StringBuffer("RollbackSession::processLocal() : loading patch object from the home");
                        OLogger.debug(buff);
                        patchObject = PatchObjectUtil.loadPatch(oracleHomePath, patchID);
                        OPatchSession.setSessionPatchObject(patchObject);
                        PatchObject[] objArr = new PatchObject[]{patchObject};
                        OPatchSessionHelper.checkMinOPatchVersions(objArr);
                    } else {
                        createInterimInventoryFile = false;
                        buff = new StringBuffer("RollbackSession::processLocal() : using PatchObject from N-Rollback");
                        OLogger.debug(buff);
                        patchObject = this.NROLLBACK_PATCHOBJECT;
                    }
                    StringBuffer tBuf = new StringBuffer();
                    Bug[] bugsToFix = patchObject.getBugsToFix();
                    for (int nBugs = 0; nBugs < bugsToFix.length; ++nBugs) {
                        Bug b2 = bugsToFix[nBugs];
                        tBuf.append("   ");
                        tBuf.append(b2.getBugID());
                        tBuf.append(": ");
                        tBuf.append(b2.getDesc());
                        tBuf.append("\n");
                    }
                    msg = OLogger.getString("OUI-67216", new Object[]{patchObject.getPatchID(), tBuf.toString()});
                    OLogger.verbose(this, new StringBuffer(msg));
                }
                catch (RuntimeException e4) {
                    throw e4;
                }
                catch (Throwable t) {
                    OLogger.error("OUI-67100", new Object[]{sessionName, patchLocation});
                    if (!invRead) {
                        OLogger.warn("OUI-67101");
                    }
                    re = new RuntimeException(t.getMessage());
                    re.setStackTrace(t.getStackTrace());
                    throw re;
                }
                rolling = patchObject.isRolling();
                if (!patchObject.isRollBackable() && !OPatchEnv.isForce()) {
                    OLogger.error("OUI-67018", new Object[]{patchObject.getPatchID()});
                    throw new RuntimeException(OLogger.getString("OUI-67018", new Object[]{patchObject.getPatchID()}));
                }
                patchID = patchObject.getPatchID();
                isShutdown = patchObject.isShutdown();
                cookedID = cookedPatchID = patchObject.getCookedPatchID();
                OPatchEnv.initCookedPatchID(cookedPatchID);
                boolean patchStorageCreated = OPatchEnv.setupPatchStorage(oracleHomePath, cookedPatchID);
                if (!patchStorageCreated) {
                    msg = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath, cookedPatchID);
                    buff = new StringBuffer("RollbackSession was not able to create the patch_storage area: ");
                    buff.append(msg);
                    OLogger.debug(buff);
                    OLogger.error("OUI-67082", new Object[]{"RollbackSession::processLocal(): RollbackSession", msg});
                    throw new RuntimeException(OLogger.getString("OUI-67082", new Object[]{"RollbackSession::processLocal(): RollbackSession", msg}));
                }
                String prevAppliedPatchLocation = OPatchEnv.getPatchBackupDirectoryPath(oracleHomePath, cookedPatchID);
                String preReadMeLoc = PatchObject.getPreReadMeFilePath(prevAppliedPatchLocation);
                String postReadMeLoc = PatchObject.getPostReadMeFilePath(prevAppliedPatchLocation);
                String initReadMeLoc = PatchObject.getInitReadMeFilePath(prevAppliedPatchLocation);
                String initScriptLoc = PatchObject.getInitScriptFilePath(prevAppliedPatchLocation);
                String preScriptLoc = PatchObject.getPreScriptFilePath(prevAppliedPatchLocation);
                String postScriptLoc = PatchObject.getPostScriptFilePath(prevAppliedPatchLocation);
                patchObject.setPreReadMeAction(new PreReadMeAction(preReadMeLoc));
                patchObject.setPostReadMeAction(new PostReadMeAction(postReadMeLoc));
                patchObject.setInitReadMeAction(new InitReadMeAction(initReadMeLoc));
                patchObject.setInitScriptAction(new InitScriptAction(initScriptLoc));
                patchObject.setPreScriptAction(new PreScriptAction(preScriptLoc));
                patchObject.setPostScriptAction(new PostScriptAction(postScriptLoc));
                OPatchStateManagerFactory.getInstance().setCurrentState("Init-script processing");
                boolean noPrePost = patchObject.isAllPrePostDisabled();
                if (noPrePost) {
                    buff = new StringBuffer("   Init scripts of this patch ");
                    buff.append(patchObject.getPatchID());
                    buff.append(" have been disabled. They will not be invoked.");
                    OLogger.debug(buff);
                } else {
                    buff = new StringBuffer("   Process InitReadMeAction() ");
                    OLogger.debug(buff);
                    patchObject.getInitReadMeAction().process();
                    InitScriptAction initScript = patchObject.getInitScriptAction();
                    StringBuffer tmpSb = new StringBuffer("-rollback");
                    tmpSb.append(" ");
                    tmpSb.append(patchObject.getPatchID());
                    tmpSb.append(" ");
                    tmpSb.append(OPatchEnv.getInitopt());
                    ts = new StringBuffer("Start the Rollback initScript at ");
                    OLogger.logTime(ts);
                    int initReturnVal = initScript.process(tmpSb.toString(), "rollback", patchObject.getPatchID());
                    ts = new StringBuffer("Finish the Rollback initScript at ");
                    OLogger.logTime(ts);
                    if (initReturnVal != 0) {
                        OLogger.error("OUI-67133", new Object[]{"INIT", Integer.toString(initReturnVal)});
                        RuntimeException preRe = new RuntimeException("Init Script failed.");
                        throw preRe;
                    }
                }
                if (!calledFromUtil) {
                    OPatchStateManagerFactory.getInstance().setCurrentState("Prerequisite for rollback");
                    PatchObject[] rbPatchObject = new PatchObject[]{patchObject};
                    if (OPatchEnv.isRunSql() || rbPatchObject[0].isOnlinePatch()) {
                        OPatchSessionHelper.loadRACRelatedLibFile();
                    }
                    OPatchSessionHelper.runRollbackPrereqs(oracleHomePath, rbPatchObject);
                }
                OPatchSessionHelper.constructJarActionTree(patchObject, oracleHomePath);
                OPatchSessionHelper.clubArchiveActions(patchObject);
            }
            catch (PrereqFailedException e5) {
                throw e5;
            }
            catch (ExitOPatchException e6) {
                throw e6;
            }
            catch (Throwable t) {
                buff = new StringBuffer("RollbackSession failed to prepare the system. ");
                buff.append(t.getMessage());
                OLogger.debug(buff);
                re = new RuntimeException(buff.toString());
                re.setStackTrace(t.getStackTrace());
                throw re;
            }
            OPatchStateManagerFactory.getInstance().printFollowingStates(oracleHomePath, new PatchObject[]{patchObject}, rwServices);
            if (Rules.shouldNotSupportAutoRollback(racType, patchObject)) {
                msg = "Rules.shouldNotSupportAutoRollback() says we should not support auto-rb";
                OLogger.debug(new StringBuffer(msg));
                msg = OLogger.getString("OUI-67148");
                throw new RuntimeException(msg);
            }
            try {
                boolean shouldPromptForShutdown = patchObject.shouldPromptForShutdown();
                if (shouldPromptForShutdown) {
                    buff = new StringBuffer("RollbackSession: processes shutdown logics.");
                    OLogger.debug(buff);
                    selects = RacProcessor.shutDownLogicsForProcessLocal(sessionName, oracleHomePath, racType, order, localNode, remoteNodes, isShutdown, patchObject.getShutdownMsg());
                } else {
                    buff = new StringBuffer("RollbackSession: skips shutdown logics ");
                    buff.append("per PatchObject's request or Oracle Home is a Stand Alone Home");
                    OLogger.debug(buff);
                    String[] firstSet = new String[]{};
                    String[] leftNodes = new String[]{};
                    selects = new RacProcessor.MinDowntimeNodeSelection(firstSet, leftNodes);
                }
                if (systemWrite || invWrite) {
                    String[] patchIDs = new String[]{patchObject.getPatchID()};
                    String[] triggeredPatchIDs = null;
                    OPatchSessionHelper.createSessionProperties(oracleHomePath, this.getSessionName(), patchObject.getCookedPatchID(), patchIDs, triggeredPatchIDs);
                }
                OPatchStateManagerFactory.getInstance().setCurrentState("Back up for restore");
                OLogger.justlog(OLogger.INFO, "Backing up patch " + patchObject.getPatchID() + " for restore");
                if (!calledFromUtil || patchObject.isSqlRelatedActions()) {
                    try {
                        RollbackSession.backupPatchActionsAndCreateRestoreFile(oracleHomePath, patchObject);
                    }
                    catch (Throwable t) {
                        BackupFailureException b1 = new BackupFailureException("Backup for restore failed. No Actions", t.getCause());
                        b1.setStackTrace(t.getStackTrace());
                        b1.setRestoreFailure();
                        throw b1;
                    }
                }
                ts = new StringBuffer("Finish backing up system for restore at ");
                OLogger.logTime(ts);
                OLogger.justlog(OLogger.INFO, "Finished backing up patch " + patchObject.getPatchID() + " for restore");
                OPatchStateManagerFactory.getInstance().setCurrentState("Patch Oracle Home");
                if (OPatchEnv.isRunSql()) {
                    OLogger.debug(new StringBuffer("Rollback Session::Shutting down database after backup up for restore"));
                    SQLUtilities.shutdownAllDB(oracleHomePath);
                }
                try {
                    String cookedPatchID = patchObject.getCookedPatchID();
                    buff = new StringBuffer("RollbackSession generates Fp, Dp, Fr and Dr files.");
                    OLogger.debug(buff);
                    if (allNode) {
                        this.generateRacFiles(oracleHomePath, patchObject, cookedPatchID, patchID);
                    }
                    buff = new StringBuffer("RollbackSession generates MPfinal.");
                    OLogger.debug(buff);
                    PatchObject[] allPatches = new PatchObject[]{patchObject};
                    if (allNode) {
                        OPatchSessionHelper.createMPFinal(oracleHomePath, cookedPatchID, allPatches);
                    }
                }
                catch (IOException e7) {
                    buff = new StringBuffer("RollbackSession failed to generate RAC-related listed files : ");
                    buff.append(e7.getMessage());
                    OLogger.debug(buff);
                    RuntimeException re2 = new RuntimeException(buff.toString());
                    re2.setStackTrace(e7.getStackTrace());
                    throw re2;
                }
                if (createInterimInventoryFile) {
                    Path frInterim;
                    String sInterim = OPatchEnv.getInterimInventoryFileLoc(oracleHomePath);
                    String rInterim = OPatchEnv.getRecordInventoryFileLoc(oracleHomePath);
                    Path fInterim = WrapperFactory.getNioServiceWrapper().getPath(sInterim, new String[0]);
                    if (Files.exists(fInterim, new LinkOption[0])) {
                        Files.delete(fInterim);
                    }
                    if (Files.exists(frInterim = WrapperFactory.getNioServiceWrapper().getPath(rInterim, new String[0]), new LinkOption[0])) {
                        Files.delete(frInterim);
                    }
                    BufferedWriter fw = null;
                    BufferedWriter interimWrite = null;
                    try {
                        OPatchSessionHelper.writeRecordedEntries(fInterim, "rollback", rwServices);
                        OPatchSessionHelper.writeRecordedEntries(frInterim, "rollback", rwServices);
                        fw = Files.newBufferedWriter(fInterim, Charset.forName("UTF-8"), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
                        interimWrite = new BufferedWriter(fw);
                        String comment = "# rollback: list of patches to be rolled back.\n";
                        interimWrite.write(comment);
                        StringBuffer line = new StringBuffer();
                        line.append(patchID).append(":rollback:");
                        Bug[] bugs = patchObject.getBugsToFix();
                        for (int j2 = 0; j2 < bugs.length; ++j2) {
                            String bID = bugs[j2].getBugID();
                            line.append(bID);
                            if (j2 >= bugs.length - 1) continue;
                            line.append(",");
                        }
                        line.append("\n");
                        interimWrite.write(line.toString());
                        interimWrite.flush();
                        interimWrite.close();
                        fw.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                boolean calledFromApply = false;
                this.autoRollback(oracleHomePath, rwServices, patchObject, localNode, calledFromApply, null);
            }
            catch (ExitOPatchException e8) {
                if (e8.isSysmodFailed()) {
                    if (!OPatchSession.isOracleHomeHasBeenModified()) {
                        buff = new StringBuffer("Oracle Home is not modified. ");
                        buff.append(e8.getMessage());
                        OLogger.debug(buff);
                        ExitOPatchException re1 = new ExitOPatchException(buff.toString());
                        re1.setStackTrace(e8.getStackTrace());
                        throw re1;
                    }
                    String tmpS = OLogger.getString("OUI-67218", new Object[]{"RollbackSession", e8.getMessage()});
                    throw new Error(tmpS);
                }
                throw e8;
            }
            catch (BackupFailureException e9) {
                if (e9.isRestoreFailure()) {
                    buff = new StringBuffer("RollbackSession failed to prepare the system. ");
                    buff.append(e9.getMessage());
                    OLogger.debug(buff);
                    RuntimeException re2 = new RuntimeException(buff.toString());
                    re2.setStackTrace(e9.getStackTrace());
                    throw re2;
                }
                String tmpS = OLogger.getString("OUI-67218", new Object[]{"RollbackSession", e9.getMessage()});
                throw new Error(tmpS);
            }
            catch (Throwable t) {
                if (!OPatchSession.isOracleHomeHasBeenModified()) {
                    buff = new StringBuffer("RollbackSession failed but Oracle Home has not been modified.");
                    OLogger.debug(buff);
                    RuntimeException re2 = new RuntimeException(buff.toString());
                    re2.setStackTrace(t.getStackTrace());
                    throw re2;
                }
                String tmpS = OLogger.getString("OUI-67218", new Object[]{"RollbackSession", t.getMessage()});
                OLogger.debug(tmpS);
                RuntimeException re2 = new RuntimeException(tmpS);
                re2.setStackTrace(t.getStackTrace());
                throw re2;
            }
        }
        catch (RuntimeException t) {
            throw t;
        }
        catch (Error e10) {
            throw e10;
        }
        if (!calledFromUtil) {
            String originalPatchLoc;
            PatchmdXml rollbackSql;
            String rollbackSqlPath;
            OPatchStateManagerFactory.getInstance().setCurrentState("Run custom SQL file");
            PatchObject[] pArray = new PatchObject[]{patchObject};
            Properties onlineProp = OPatchSessionHelper.getOnlinePropertyFromFile(oracleHomePath);
            OPatchSessionHelper.removeOnlineRollbackSids(onlineProp, pArray, OPatchEnv.getLocalNode(), oracleHomePath);
            if (OPatchEnv.isRunSql() && patchObject.isSqlRelatedActions()) {
                OPatchSessionHelper.removeSidFromSqlPropertyFile(oracleHomePath, patchObject.getCookedPatchID());
            }
            if ((rollbackSqlPath = (rollbackSql = new PatchmdXml(oracleHomePath, originalPatchLoc = OPatchEnv.getPatchBackupDirectoryPath(oracleHomePath, patchObject.getCookedPatchID()), false, patchObject.getAllIncludedCopyActions(), patchObject.getPatchID())).getSqlPath()) != null && !rollbackSqlPath.equals("") && OPatchEnv.isRunSql()) {
                try {
                    OLogger.println(OLogger.getString("OUI-67272", new Object[]{"rollback", rollbackSqlPath, patchObject.getPatchID()}));
                    OPatchSessionHelper.runSqlScript(rollbackSqlPath, patchObject.getPatchInventory().isSqlMigrate());
                }
                catch (RuntimeException e11) {
                    OLogger.printStackTrace(e11);
                    OLogger.printlnOnLog(OLogger.INFO, e11.getMessage());
                    OLogger.warn(OLogger.getString("OUI-67273", new Object[]{"rollback", rollbackSqlPath, patchObject.getPatchID()}));
                }
            }
            try {
                OPatchSession.runCustomScript();
            }
            catch (RuntimeException e12) {
                OLogger.printStackTrace(e12);
                OLogger.printlnOnLog(OLogger.INFO, e12.getMessage());
                OLogger.warn("OUI-67266", new Object[]{OPatchEnv.getSqlScriptFilePath()});
            }
        }
        if (shouldPromptForStartup = patchObject.shouldPromptForStartup()) {
            buff = new StringBuffer("RollbackSession: processes startup logics.");
            OLogger.debug(buff);
            RacProcessor.startupLogicsForProcessLocal(racType, order, localNode, remoteNodes, isShutdown);
        } else {
            buff = new StringBuffer("RollbackSession: skips startup logics ");
            buff.append("per PatchObject's request.");
            OLogger.debug(buff);
        }
        boolean needRollback = false;
        OPatchSessionHelper.LocalInfo localInfo = new OPatchSessionHelper.LocalInfo(rwServices, patchObject, needRollback, racType, selects);
        return localInfo;
    }

    private IIPMRWServices loadInventory(String oracleHomePath, String patchID) throws RuntimeException {
        RuntimeException re = null;
        IIPMRWServices rwServices = IPM.INSTANCE.getRWServices();
        boolean ohError = true;
        try {
            rwServices.lock(oracleHomePath);
            rwServices.loadInventory(oracleHomePath);
            ohError = false;
        }
        catch (NullPointerException e2) {
            OPatchStateManagerFactory.getInstance().setErrorCode(22);
            String msg = OLogger.getString("OUI-67064", new Object[]{oracleHomePath});
            re = new RuntimeException(msg);
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        catch (IllegalArgumentException e3) {
            OPatchStateManagerFactory.getInstance().setErrorCode(22);
            String msg = OLogger.getString("OUI-67064", new Object[]{oracleHomePath});
            re = new RuntimeException(msg);
            re.setStackTrace(e3.getStackTrace());
            throw re;
        }
        catch (SecurityException e4) {
            OPatchStateManagerFactory.getInstance().setErrorCode(22);
            String msg = OLogger.getString("OUI-67064", new Object[]{oracleHomePath});
            re = new RuntimeException(msg);
            re.setStackTrace(e4.getStackTrace());
            throw re;
        }
        catch (Throwable t) {
            OPatchStateManagerFactory.getInstance().setErrorCode(22);
            String msg = OLogger.getString("OUI-67064", new Object[]{oracleHomePath});
            re = new RuntimeException(msg);
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
        if (ohError) {
            throw new RuntimeException("RollbackSession::loadInventory() fails to load inventory object");
        }
        boolean patchInstalled = false;
        OneOffEntry[] inactiveOneOffs = rwServices.getInactivePatches();
        for (int i2 = 0; i2 < inactiveOneOffs.length; ++i2) {
            OneOffEntry inactive = inactiveOneOffs[i2];
            String inactiveID = inactive.getID();
            if (inactiveOneOffs[i2].getIsComposite() || !inactiveID.equalsIgnoreCase(patchID)) continue;
            OPatchStateManagerFactory.getInstance().setErrorCode(28);
            String msg = OLogger.getString("OUI-67637", new Object[]{patchID});
            re = new RuntimeException(msg);
            if (OPatchEnv.isReport()) {
                patchInstalled = true;
                continue;
            }
            throw re;
        }
        OneOffEntry[] oneOffs = rwServices.getInstalledPatches();
        for (int i3 = 0; i3 < oneOffs.length; ++i3) {
            OneOffEntry oneOff = oneOffs[i3];
            String ID = oneOff.getID();
            if (!ID.equalsIgnoreCase(patchID)) continue;
            patchInstalled = true;
            break;
        }
        OneOffEntry[] inactivePsuTrain = rwServices.getInactivePSUTrain();
        for (int i4 = 0; i4 < inactivePsuTrain.length; ++i4) {
            OneOffEntry oneOff = inactivePsuTrain[i4];
            String ID = oneOff.getID();
            if (!ID.equalsIgnoreCase(patchID)) continue;
            patchInstalled = true;
            break;
        }
        if (!patchInstalled) {
            OPatchStateManagerFactory.getInstance().setErrorCode(29);
            String msg = OLogger.getString("OUI-67109", new Object[]{patchID});
            re = new RuntimeException(msg);
            throw re;
        }
        return rwServices;
    }

    private void rollback(String oracleHomePath, PatchObject patchObject, IIPMRWServices rwServices, boolean calledFromApply, PatchObject applyPatchObject) throws RuntimeException {
        StringBuffer buff = new StringBuffer("RollbackSession::rollback()");
        OLogger.debug(buff);
        try {
            StringBuffer ts;
            boolean cont = Rules.SystemWrite_continue();
            OPatchEnv.setPortalPatchID(patchObject.getPatchID());
            OLogger.debug(new StringBuffer("RollbackSession::rollback(): starting system modification"));
            try {
                ts = new StringBuffer("Start modifying the system at ");
                OLogger.logTime(ts);
                this.modifySystem(oracleHomePath, patchObject, calledFromApply, applyPatchObject);
                ts = new StringBuffer("Finish modifying the system at ");
                OLogger.logTime(ts);
            }
            catch (RuntimeException e2) {
                OLogger.debug(new StringBuffer("RollbackSession::rollback() gets error from modifySystem()"));
                throw e2;
            }
            if (!OPatchEnv.isCASFlow()) {
                RollbackSession.runPatchgen(oracleHomePath, patchObject.getPatchID(), false, false);
            }
            if (cont = Rules.OUIWrite_continue()) {
                OPatchStateManagerFactory.getInstance().setCurrentState("Update Inventory for rollback");
                OLogger.debug(new StringBuffer("RollbackSession::rollback(): remove one-off entry from inventory."));
                if (patchObject.getPatchInventory().isMiniPatchSet()) {
                    OLogger.info("OUI-67616", new Object[]{sessionName, patchObject.getPatchID()});
                } else {
                    OLogger.info("OUI-67120", new Object[]{sessionName, patchObject.getPatchID()});
                }
                rwServices.remove(patchObject);
            } else {
                OLogger.debug(new StringBuffer("REPORT: skip one-off entry creation"));
                OLogger.info("OUI-67165", new Object[]{sessionName});
            }
            cont = Rules.OUIWrite_continue();
            if (cont) {
                OLogger.debug(new StringBuffer("RollbackSession::rollback(): save one-off entry to inventory"));
                String node = null;
                if (calledFromApply) {
                    patchObject.disableRegenerateLibrary();
                }
                OPatchSessionHelper.runLibraryRegeneration(patchObject, oracleHomePath, calledFromApply);
                ts = new StringBuffer("Start removing patch from inventory at ");
                OLogger.logTime(ts);
                rwServices.deletePatch(node, patchObject);
                ts = new StringBuffer("Finish removing patch from inventory at ");
                OLogger.logTime(ts);
            } else {
                OLogger.debug(new StringBuffer("REPORT: skip saving one-off to inventory"));
            }
        }
        catch (Throwable t) {
            OPatchStateManagerFactory.getInstance().setErrorCode(120);
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
    }

    private void modifySystem(String oracleHomePath, PatchObject patchObject, boolean calledFromApply, PatchObject applyPatchObject) throws RuntimeException {
        StringBuffer buff = new StringBuffer("RollbackSession::modifySystem(): ");
        OLogger.debug(buff);
        OPatchActionExecutor.getInstance().runRollback(oracleHomePath, patchObject, calledFromApply, applyPatchObject);
    }

    protected static void autoRollbackDelayedActions(boolean calledFromApply, PatchObject[] r_patchObjectList, String oracleHomePath) throws RuntimeException, Exception {
        StringBuffer errorBuff = new StringBuffer();
        StringBuffer buff = new StringBuffer("RollbackSession::autoRollbackDelayedActions()");
        OLogger.debug(buff);
        boolean errorFlag = false;
        boolean oneTimePrint = false;
        String mode = "";
        try {
            if (OPatchEnv.isRunSql()) {
                StringBuffer patchIDs = new StringBuffer(" ");
                boolean isWarnForRunSql = false;
                for (int i2 = 0; i2 < r_patchObjectList.length; ++i2) {
                    boolean isApplied;
                    Properties sqlProp;
                    String sqlResult;
                    PatchObject rbPo = r_patchObjectList[i2];
                    if (rbPo == null) {
                        throw new RuntimeException("Rollback PatchObject is null");
                    }
                    if (!rbPo.isSqlRelatedActions() || (sqlResult = (sqlProp = OPatchSessionHelper.getSqlPropertyFromFile(oracleHomePath, rbPo.getCookedPatchID())).getProperty("RUNSQL")) == null || (isApplied = Boolean.valueOf(sqlResult).booleanValue())) continue;
                    patchIDs.append(rbPo.getPatchID());
                    patchIDs.append(" ");
                    isWarnForRunSql = true;
                }
                if (isWarnForRunSql) {
                    OLogger.warn("OUI-67285", new Object[]{patchIDs.toString()});
                }
            }
            for (int i3 = 0; i3 < r_patchObjectList.length; ++i3) {
                PatchObject rbPo = r_patchObjectList[i3];
                if (rbPo == null) {
                    throw new RuntimeException("Rollback PatchObject is null");
                }
                String delayedCookedID = rbPo.getCookedPatchID();
                ArrayList pActions = rbPo.getDelayedExecutionActions();
                if (!oneTimePrint) {
                    mode = calledFromApply ? "auto-rollback" : "rollback";
                    if (pActions.size() != 0) {
                        String msg = OLogger.getString("OUI-67269", new Object[]{mode});
                        OLogger.println(msg);
                        oneTimePrint = true;
                    }
                }
                for (int j2 = 0; j2 < pActions.size(); ++j2) {
                    PatchAction pa = (PatchAction)pActions.get(j2);
                    if (!(pa instanceof PatchAction) || !(pa instanceof Rollbackable)) continue;
                    Rollbackable ra = (Rollbackable)((Object)pa);
                    buff = new StringBuffer();
                    buff.append(ra.getRollbackDescription(oracleHomePath));
                    OLogger.info("OUI-67124", new Object[]{buff.toString()});
                    try {
                        ra.rollback(oracleHomePath, delayedCookedID);
                        continue;
                    }
                    catch (RuntimeException e2) {
                        pa.setRollbackFailed();
                        errorBuff.append(e2.getMessage());
                        errorBuff.append("\n");
                        errorFlag = true;
                    }
                }
            }
            if (errorFlag) {
                OLogger.println("\nThe following actions have failed:");
                OLogger.warn("OUI-67124", new Object[]{errorBuff.toString()});
                StringBuffer emptyBuff = new StringBuffer("");
                if (!OPatchEnv.proceedWithOperationDefaultNo(emptyBuff)) {
                    RuntimeException e3 = new RuntimeException(errorBuff.toString());
                    throw e3;
                }
            }
        }
        catch (Exception e4) {
            throw e4;
        }
        finally {
            OLogger.debug(new StringBuffer("Shutting down database after " + mode + " of delayed actions"));
            SQLUtilities.shutdownAllDB(oracleHomePath);
        }
    }

    protected void processRemote(String oracleHomePath, Rac.RacType racType, IIPMRWServices rwServices, PatchObject patchObject, RacProcessor.MinDowntimeNodeSelection selects) throws RuntimeException, Error {
        StringBuffer buff = new StringBuffer("RollbackSession::processRemote()");
        Rac rac = OPatchExternalFactory.getRac(oracleHomePath);
        OLogger.debug(buff);
        OPatchSessionHelper.loadRACRelatedLibFile();
        String cookedPatchID = patchObject.getCookedPatchID();
        if (Rules.OUIRead_continue() && !rwServices.isInventoryLoaded()) {
            buff.append(" needs a non-null Inventory and patchObject");
            OLogger.debug(buff);
            throw new RuntimeException(buff.toString());
        }
        if (!rac.shouldPropagate(racType) && !rac.shouldRemoteRun(racType)) {
            buff = new StringBuffer(" not a RAC system, no-op for RollbackSession::processRemote()");
            OLogger.debug(buff);
        } else {
            buff = new StringBuffer("RollbackSession::processRemote() will roll back the patch on the following nodes: ");
            String localNode = racType.getLocalNode();
            String[] remoteNodes = racType.getRemoteNodes();
            if (remoteNodes != null) {
                for (int i2 = 0; i2 < remoteNodes.length; ++i2) {
                    String node = remoteNodes[i2];
                    buff.append(" (node ");
                    buff.append(node);
                    buff.append(")");
                }
            }
            buff.append(".  RAC mode is: ");
            buff.append(racType.getDetail());
            boolean local = OPatchEnv.isLocal();
            boolean minDT = OPatchEnv.isMinDowntime();
            boolean rolling = patchObject.isRolling();
            boolean shutdown = patchObject.isShutdown();
            boolean allNode = OPatchEnv.isAllNode();
            boolean silent = OPatchEnv.isSilent();
            Rules.RacPatchOrder order = Rules.getRacPatchOrder(racType, local, rolling, minDT, allNode, silent);
            buff.append(".  Applying order is: ");
            buff.append(order.toString());
            OLogger.debug(buff);
            try {
                String FP = null;
                String DP = null;
                String FR = null;
                String DR = null;
                String MP = null;
                String RC = null;
                String patchStorageRac = "";
                try {
                    patchStorageRac = OPatchEnv.getPatchStorageRacDirectoryPath(oracleHomePath, cookedPatchID);
                    RacFileCreator.checkPsRac(patchStorageRac);
                    FP = RacFileCreator.getFPFinalName(patchStorageRac);
                    DP = RacFileCreator.getDPFinalName(patchStorageRac);
                    FR = RacFileCreator.getFRFinalName(patchStorageRac);
                    DR = RacFileCreator.getDRFinalName(patchStorageRac);
                    MP = RacFileCreator.getMPFinalName(patchStorageRac);
                    RC = RacFileCreator.getRCFinalName(patchStorageRac);
                }
                catch (IOException e2) {
                    RuntimeException re = new RuntimeException(e2.getMessage());
                    re.setStackTrace(e2.getStackTrace());
                    throw re;
                }
                StringBuffer report = new StringBuffer("OPatch will use the following files to patch remote nodes:\n");
                if (FP != null) {
                    report.append("   \"");
                    report.append(FP);
                    report.append("\"\n");
                }
                if (RC != null) {
                    report.append("   \"");
                    report.append(RC);
                    report.append("\"\n");
                }
                if (DP != null) {
                    report.append("   \"");
                    report.append(DP);
                    report.append("\"\n");
                }
                if (FR != null) {
                    report.append("   \"");
                    report.append(FR);
                    report.append("\"\n");
                }
                if (DR != null) {
                    report.append("   \"");
                    report.append(DR);
                    report.append("\"\n");
                }
                if (MP != null) {
                    report.append("   \"");
                    report.append(MP);
                    report.append("\"\n");
                }
                OLogger.verbose(this, report);
                boolean apply = false;
                boolean rollback = true;
                boolean autoRollBack = false;
                PatchObject[] patchObjects = new PatchObject[]{patchObject};
                RacProcessor.patchRemoteNodes(oracleHomePath, remoteNodes, order, FP, DP, FR, DR, MP, RC, shutdown, sessionName, selects, apply, rollback, autoRollBack, patchStorageRac, patchObject.getShutdownMsg(), patchObjects, null, localNode, rac.shouldPropagate(racType), rac.shouldRemoteRun(racType));
            }
            catch (RuntimeException e3) {
                throw e3;
            }
            catch (Error e4) {
                throw e4;
            }
        }
    }

    protected void process(String patchLocation, String patchID, String oracleHomePath) throws RuntimeException, Error {
        StringBuffer buff = new StringBuffer("RollbackSession::process(): PatchLocation = ");
        buff.append(patchLocation);
        buff.append(", patch ID = ");
        buff.append(patchID);
        buff.append(", Oracle Home = ");
        buff.append(oracleHomePath);
        OLogger.debug(buff);
        buff = new StringBuffer("Patch Location in Inventory    : ");
        buff.append(patchLocation);
        OLogger.verbose(this, buff);
        OneOffEntry oneoff = null;
        PatchObject initialPo = null;
        boolean doRestore = false;
        Rac rac = OPatchExternalFactory.getRac(oracleHomePath);
        boolean isEsysPatch = false;
        isEsysPatch = OPatchSessionHelper.checkIsEsysPatch(patchLocation);
        if (isEsysPatch) {
            throw new RuntimeException(OLogger.getString("OUI-68011"));
        }
        try {
            String cookedPatchID = "";
            oneoff = OPatchSDK.getOneOffEntryWithoutInventoryLoad(oracleHomePath, patchID);
            initialPo = PatchObject.getInstance(oracleHomePath, patchID);
            cookedPatchID = oneoff.getCookedPatchID();
            if (initialPo != null && initialPo.getPatchType().equals("snowball")) {
                throw new RuntimeException(OLogger.getString("OUI-67656"));
            }
            OPatchStateManagerFactory.getInstance().printMandatoryStates(oracleHomePath, new PatchObject[]{initialPo});
            OPatchStateManagerFactory.getInstance().setCurrentState("Oracle Home discovery");
            buff = new StringBuffer("Patch Location in Storage area : ");
            buff.append(OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath, cookedPatchID));
            buff.append("\n");
            OLogger.verbose(this, buff);
        }
        catch (Exception e2) {
            OPatchStateManagerFactory.getInstance().setErrorCode(27);
            OLogger.debug(new StringBuffer("Could not get the patch rollback area"));
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        StringBuffer ts = new StringBuffer("Starting Rollback Session at ");
        OLogger.logTime(ts);
        IIPMRWServices rwServices = null;
        PatchObject patchObject = null;
        try {
            boolean local = OPatchEnv.isLocal();
            boolean allNode = OPatchEnv.isAllNode();
            boolean minDowntime = OPatchEnv.isMinDowntime();
            boolean silent = OPatchEnv.isSilent();
            if (oneoff.isMiniPatchSet()) {
                OLogger.info("OUI-67615", new Object[]{sessionName, patchID, oracleHomePath});
            } else {
                OLogger.info("OUI-67087", new Object[]{sessionName, initialPo.getOriginalPatchID(), oracleHomePath});
            }
            ts = new StringBuffer("Starting to roll back patch from local system at ");
            OLogger.logTime(ts);
            OPatchSessionHelper.LocalInfo localInfo = this.processLocal(oracleHomePath, patchLocation, patchID, local, minDowntime, allNode, silent);
            ts = new StringBuffer("Finish rolling back patch from local system at ");
            OLogger.logTime(ts);
            OPatchStateManagerFactory.getInstance().setCurrentState("RAC propagation");
            rwServices = (IIPMRWServices)localInfo.getReadServices();
            patchObject = localInfo.getPatchObject();
            Rac.RacType racType = localInfo.getRacType();
            if (!racType.getCrsDownPrompt().equals("")) {
                OLogger.warn("OUI-68010", new Object[]{"rollback", "apply", racType.getCrsDownPrompt()});
            }
            RacProcessor.MinDowntimeNodeSelection selects = localInfo.getSelection();
            try {
                if (rac.shouldPropagate(racType)) {
                    ts = new StringBuffer("Starting to remove patch from ");
                    ts.append("remote nodes at ");
                    OLogger.logTime(ts);
                    this.processRemote(oracleHomePath, racType, rwServices, patchObject, selects);
                    ts = new StringBuffer("Finish removing patch from remote nodes at ");
                    OLogger.logTime(ts);
                    if (Rules.shouldWarnAboutRemoteRelink(oracleHomePath, patchObject)) {
                        String remoteMakeCommands = patchObject.getListOfMakeCmdsOnRemoteNodes(oracleHomePath);
                        String[] nodes = racType.getRemoteNodes();
                        String nodesString = RacProcessor.getNodesString(nodes);
                        OLogger.info("OUI-67151", new Object[]{nodesString, remoteMakeCommands});
                    }
                }
            }
            catch (Throwable t) {
                String msg = t.getMessage();
                buff = new StringBuffer("RollbackSession::process(): processRemote() failed.");
                buff.append("  Do not restore local system.  Ask users to roll back patch ");
                buff.append("on remote node(s) using -local.  Error is: \"");
                buff.append(msg);
                buff.append("\"");
                OLogger.debug(buff);
                msg = OLogger.error("OUI-67081", new Object[]{msg});
                RuntimeException e3 = new RuntimeException(msg);
                e3.setStackTrace(t.getStackTrace());
                throw e3;
            }
        }
        catch (RuntimeException e4) {
            throw e4;
        }
        catch (Error e5) {
            doRestore = true;
            throw e5;
        }
        finally {
            if (!(doRestore || calledFromUtil || OPatchEnv.isDelayCleanUp())) {
                OPatchSessionHelper.cleanup(oracleHomePath);
            }
        }
        buff = new StringBuffer("RollbackSession::process() done");
        OLogger.debug(buff);
    }

    protected void process(String patchLocation, String patchID, String oracleHomePath, PatchObject patchObject) throws RuntimeException, Error {
        StringBuffer buff = new StringBuffer("RollbackSession::process() ");
        buff.append("with a given PatchObject");
        OLogger.debug(buff);
        try {
            this.NROLLBACK_PATCHOBJECT = patchObject;
            calledFromUtil = true;
            this.process(patchLocation, patchID, oracleHomePath);
            this.NROLLBACK_PATCHOBJECT = null;
            calledFromUtil = false;
        }
        catch (RuntimeException e2) {
            throw e2;
        }
        catch (Error e3) {
            throw e3;
        }
    }

    @Override
    public boolean helpPresent() {
        return true;
    }

    @Override
    public void displayHelp() {
        StringBuffer helpM = new StringBuffer("\n");
        String helpFile = "";
        helpFile = "rollback_help.txt";
        try {
            String thisLine;
            InputStream is = this.getClass().getResourceAsStream(helpFile);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((thisLine = br.readLine()) != null) {
                helpM.append(thisLine);
                helpM.append("\n");
            }
            OLogger.println(helpM.toString());
            br.close();
            is.close();
        }
        catch (Exception e2) {
            String msg = OLogger.getString("OUI-67108", new Object[]{helpFile});
            OLogger.println(msg);
        }
    }

    public static void main(String[] args) {
        String oracleHomePath = "C:\\oracle\\product\\10.1.0\\Db_1";
        String patch = "0118482";
        StringBuffer buff = new StringBuffer(oracleHomePath);
        buff.append(File.separator);
        buff.append("inventory");
        buff.append(File.separator);
        buff.append("oneoffs");
        buff.append(File.separator);
        buff.append(patch);
        String patchLocation = buff.toString();
        String patchID = "0118483";
        oracleHomePath = "C:\\oracle\\10g";
        OPatchEnv.setReport(true);
        if (!OPatchEnv.isWindows()) {
            oracleHomePath = "/home/dsaha/phi/db_phi1";
            patchLocation = "/net/usunrat08/private/phnguyen/OPatch/Code/OPatch/0118483";
        }
        String ouiLocation = oracleHomePath + File.separator + "oui";
        System.setProperty("oracle.installer.startup_location", ouiLocation);
        System.setProperty("oracle.installer.oui_loc", ouiLocation);
        RollbackSession rbs = OPatchSession.ROLLBACK;
        try {
            OPatchACL.invokeOLogger(rbs, "setDebug", new Object[]{true});
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        rbs.process(patchLocation, patchID, oracleHomePath);
    }
}

