/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import oracle.opatch.BusyFileProcessor;
import oracle.opatch.CopyAction;
import oracle.opatch.OPatchACL;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchProperty;
import oracle.opatch.OUIReplacer;
import oracle.opatch.ReaderThread;
import oracle.opatch.Rules;
import oracle.opatch.StdoutStatus;
import oracle.opatch.StringResource;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.wrappers.WrapperFactory;
import oracle.sysman.oii.oiix.OiixFileOps;

public class SystemCall {
    private static final long ONE_MB = 0x40000000L;
    private static final long FILE_COPY_BUFFER_SIZE = 0x780000000L;
    static Thread mainThread = Thread.currentThread();
    private static String suCommandPath = null;

    private static void fastCopy(Path srcFile, Path destFile) throws IOException {
        AbstractInterruptibleChannel input = null;
        AbstractInterruptibleChannel output = null;
        SeekableByteChannel sInput = null;
        Channel sOutput = null;
        try {
            sInput = Files.newByteChannel(srcFile, new OpenOption[0]);
            sOutput = Files.newByteChannel(destFile, EnumSet.of(StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING), new FileAttribute[0]);
            input = (FileChannel)sInput;
            output = (FileChannel)sOutput;
            long size = ((FileChannel)input).size();
            long count = 0L;
            for (long pos = 0L; pos < size; pos += ((FileChannel)output).transferFrom((ReadableByteChannel)((Object)input), pos, count)) {
                count = size - pos > 0x780000000L ? 0x780000000L : size - pos;
            }
        }
        catch (Exception e2) {
            OLogger.log("Failed to copy " + srcFile.toString() + " to destination " + destFile.toString() + "\n Reason=" + e2.toString(), new Object[0]);
            throw e2;
        }
        finally {
            output.close();
            sOutput.close();
            input.close();
            sInput.close();
        }
        OLogger.debug("The size of srcFile " + srcFile.toString() + " is: " + Files.size(srcFile));
        OLogger.debug("The size of destFile " + destFile.toString() + " is: " + Files.size(destFile));
        if (Files.size(srcFile) != Files.size(destFile)) {
            throw new IOException("Failed to copy full contents from '" + srcFile + "' to '" + destFile + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void oldCopy(Path src, Path dst) throws IOException {
        InputStream in = Files.newInputStream(src, new OpenOption[0]);
        OutputStream out = Files.newOutputStream(dst, new OpenOption[0]);
        try {
            int len;
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        finally {
            in.close();
            out.close();
        }
    }

    private static ExecReturn MkDirs(String dirsPath) {
        String[] cmd = new String[]{"mkdir -p on Unix, mkdir on Windows using Java File::mkdirs()"};
        ExecReturn ret = new ExecReturn(cmd);
        boolean cont = Rules.SystemWrite_continue();
        if (!cont) {
            Path test = WrapperFactory.getNioServiceWrapper().getPath(dirsPath, new String[0]);
            if (!Files.exists(test, new LinkOption[0])) {
                if (OPatchEnv.isWindows()) {
                    StringBuffer tmp = new StringBuffer("REPORT: mkdir ");
                    tmp.append(dirsPath);
                    OLogger.log(OLogger.FINE, tmp.toString());
                } else {
                    StringBuffer tmp = new StringBuffer("REPORT: mkdir -p ");
                    tmp.append(dirsPath);
                    OLogger.log(OLogger.FINE, tmp.toString());
                }
            }
            ret.setErrorMessage("");
            ret.setNormalMessage("Ops. not executed because no system mod. is requested");
            ret.setReturnCode(0);
            return ret;
        }
        Path dirs = WrapperFactory.getNioServiceWrapper().getPath(dirsPath, new String[0]);
        ret.setReturnCode(0);
        try {
            Files.createDirectories(dirs, new FileAttribute[0]);
        }
        catch (Exception e2) {
            ret.setReturnCode(-1);
        }
        if (!Files.exists(dirs, new LinkOption[0])) {
            ret.setReturnCode(-1);
            StringBuffer tmp = new StringBuffer("mkdir fails for ");
            tmp.append(dirs.toAbsolutePath().toString());
            ret.setErrorMessage(tmp.toString());
            ret.setNormalMessage("");
        }
        return ret;
    }

    public static ExecReturn runtimeExec(String systemCommand) {
        String[] systemCommands = new String[]{systemCommand};
        String runDir = null;
        return SystemCall.runtimeExec(systemCommands, runDir);
    }

    public static ExecReturn runtimeExec(String[] systemCommand, String runDir) {
        String[] envp = null;
        return SystemCall.runtimeExec(systemCommand, envp, runDir);
    }

    public static ExecReturn runtimeExec(String[] systemCommand, String[] envp, String runDir) {
        return SystemCall.runtimeExec(systemCommand, envp, runDir, null, false);
    }

    public static ExecReturn runtimeExec(String[] systemCommand, String[] envp, String runDir, String inputString, boolean coroutineLogging) {
        ExecReturn ret = null;
        StringBuffer buff = new StringBuffer();
        boolean passEnvp = true;
        Properties opatchProperty = OPatchEnv.getOPatchProperties();
        String ohValue = "";
        try {
            ohValue = OPatchEnv.getOracleHome();
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
            ohValue = "";
        }
        String pathValue = opatchProperty.getProperty("OPatch.PATH");
        String[] specialEnvp = new String[2];
        buff = new StringBuffer("ORACLE_HOME");
        buff.append("=");
        buff.append(ohValue);
        specialEnvp[0] = buff.toString();
        buff = new StringBuffer("PATH");
        buff.append("=");
        buff.append(pathValue);
        specialEnvp[1] = buff.toString();
        if (systemCommand == null) {
            String[] tmp = new String[]{"Null Command given by caller"};
            ret = new ExecReturn(tmp);
            ret.setErrorMessage("");
            ret.setNormalMessage("");
            ret.setReturnCode(0);
            return ret;
        }
        ret = new ExecReturn(systemCommand);
        if (envp != null) {
            for (int eIter = 0; eIter < envp.length; ++eIter) {
                String src = envp[eIter];
                int index = src.indexOf("=");
                int len = src.length();
                String key = src.substring(0, index);
                String value = src.substring(index + 1, len);
                buff = new StringBuffer("Setting env with key=\"");
                buff.append(key);
                buff.append(", value=\"");
                buff.append(value);
                buff.append("\"");
                OLogger.debug(buff);
                OUIReplacer.setEnv(key, value);
            }
        }
        if (ohValue != null && !ohValue.equals("")) {
            OUIReplacer.setEnv("ORACLE_HOME", ohValue);
        }
        if (pathValue != null && !pathValue.equals("")) {
            OUIReplacer.setEnv("PATH", pathValue);
        }
        String opatchTestOUIEnvApi = "TRUE";
        OUIReplacer.setEnv("OPATCH_TEST_ENV_API", opatchTestOUIEnvApi);
        String opatchTestOUIEnvApiRead = OUIReplacer.getEnv("OPATCH_TEST_ENV_API");
        if (opatchTestOUIEnvApi.equals(opatchTestOUIEnvApiRead)) {
            passEnvp = false;
        }
        if (passEnvp) {
            Properties p2 = OPatchEnv.getEnvInfo();
            if (p2 != null) {
                Enumeration<?> e3 = p2.propertyNames();
                int arrayCount = 0;
                int count = 0;
                String[] newEnvp = null;
                if (envp != null) {
                    arrayCount = envp.length;
                }
                if (specialEnvp != null) {
                    arrayCount += specialEnvp.length;
                }
                newEnvp = new String[arrayCount += p2.size()];
                while (e3.hasMoreElements()) {
                    String key = "";
                    try {
                        key = (String)e3.nextElement();
                    }
                    catch (Exception excep) {
                        continue;
                    }
                    String value = "";
                    value = key.trim().equals("ORACLE_HOME") && ohValue != null && !ohValue.equals("") ? ohValue : (key.trim().equals("PATH") && pathValue != null && !pathValue.equals("") ? pathValue : p2.getProperty(key));
                    if (value == null) {
                        StringBuffer valueBuff = new StringBuffer("");
                        value = valueBuff.toString();
                    }
                    StringBuffer input = new StringBuffer(key);
                    input.append("=");
                    input.append(value);
                    newEnvp[count++] = input.toString();
                }
                if (envp != null) {
                    for (int i2 = 0; i2 < envp.length; ++i2) {
                        newEnvp[count++] = envp[i2];
                    }
                }
                if (specialEnvp != null) {
                    for (int i3 = 0; i3 < specialEnvp.length; ++i3) {
                        newEnvp[count++] = specialEnvp[i3];
                    }
                }
                envp = newEnvp;
            } else {
                passEnvp = true;
            }
        }
        int retValue = -1;
        try {
            Process process = null;
            if (coroutineLogging) {
                OPatchACL.invokeOLogger(new SystemCall(), "closeDiskLogFile", null);
            }
            if (runDir != null) {
                Path tmpF = Paths.get(runDir, new String[0]);
                process = passEnvp ? SystemCall.exec(systemCommand, envp, tmpF) : SystemCall.exec(systemCommand, null, tmpF);
            } else {
                process = passEnvp ? SystemCall.exec(systemCommand, envp) : SystemCall.exec(systemCommand);
            }
            InputStreamReader errorStream = new InputStreamReader(process.getErrorStream());
            InputStreamReader inputStream = new InputStreamReader(process.getInputStream());
            ReaderThread rerror = new ReaderThread(errorStream, "ErrorStream");
            ReaderThread rinput = new ReaderThread(inputStream, "InputStream");
            OLogger.debug(new StringBuffer("SystemCall:RuntimeExec(cmds, runDir): GOING to start thread to read Input Stream"));
            rinput.start();
            OLogger.debug(new StringBuffer("SystemCall:RuntimeExec(cmds, runDir): Started thread to read Input Stream"));
            OLogger.debug(new StringBuffer("SystemCall:RuntimeExec(cmds, runDir): GOING to start thread to read Error Stream"));
            rerror.start();
            OLogger.debug(new StringBuffer("SystemCall:RuntimeExec(cmds, runDir): Started thread to read Error Stream"));
            if (inputString != null) {
                OLogger.debug(new StringBuffer("SystemCall:RuntimeExec(cmds, runDir): Piping inputString to stdin"));
                PrintWriter pw = new PrintWriter(process.getOutputStream());
                pw.print(inputString);
                pw.print(System.getProperty("line.separator"));
                pw.flush();
            }
            OLogger.debug(new StringBuffer("SystemCall:RuntimeExec(cmds, runDir): GOING into process.waitFor()"));
            retValue = process.waitFor();
            OLogger.debug(new StringBuffer("SystemCall:RuntimeExec(cmds, runDir): process.waitFor() is OVER"));
            try {
                rerror.join();
                OLogger.debug(new StringBuffer("SystemCall:RuntimeExec(cmds, runDir): Error stream thread joined successfully"));
                rinput.join();
                OLogger.debug(new StringBuffer("SystemCall:RuntimeExec(cmds, runDir): Input stream thread joined successfully"));
                ret.setNormalMessage(rinput.outputString);
                ret.setErrorMessage(rerror.outputString);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ret.setReturnCode(retValue);
        }
        catch (Throwable t) {
            ret.setErrorMessage(t.getMessage());
            ret.setNormalMessage(t.getMessage());
            ret.setReturnCode(-1);
        }
        return ret;
    }

    private static Process exec(String[] systemCommand, String[] envp, Path tmpF) throws IOException {
        Runtime runTime = Runtime.getRuntime();
        if (systemCommand.length == 1) {
            return runTime.exec(systemCommand[0], envp, tmpF.toFile());
        }
        return runTime.exec(systemCommand, envp, tmpF.toFile());
    }

    private static Process exec(String[] systemCommand, String[] envp) throws IOException {
        Runtime runTime = Runtime.getRuntime();
        if (systemCommand.length == 1) {
            return runTime.exec(systemCommand[0], envp);
        }
        return runTime.exec(systemCommand, envp);
    }

    private static Process exec(String[] systemCommand) throws IOException {
        Runtime runTime = Runtime.getRuntime();
        if (systemCommand.length == 1) {
            return runTime.exec(systemCommand[0]);
        }
        return runTime.exec(systemCommand);
    }

    public static void checkSuCommand() {
        if (suCommandPath != null) {
            return;
        }
        if (Files.exists(WrapperFactory.getNioServiceWrapper().getPath(StringResource.BIN_PATH + File.separator + "su", new String[0]), new LinkOption[0])) {
            suCommandPath = StringResource.BIN_PATH + File.separator + "su";
        } else if (Files.exists(WrapperFactory.getNioServiceWrapper().getPath(StringResource.BIN_PATH + File.separator + "su", new String[0]), new LinkOption[0])) {
            suCommandPath = StringResource.USR_BIN_PATH + File.separator + "su";
        } else {
            ExecReturn ret = SystemCall.runtimeExec("which su");
            if (ret.isOK()) {
                suCommandPath = "su";
            } else {
                RuntimeException re = new RuntimeException("'su' command could not be found in system path environment, command execution will be failed.");
                throw re;
            }
        }
    }

    public static ExecReturn process(String command) {
        return SystemCall.process(command, null);
    }

    public static ExecReturn process(String command, String username) {
        ExecReturn ret = null;
        StringBuffer buff = new StringBuffer();
        Properties opatchProperty = OPatchEnv.getOPatchProperties();
        String ohValue = "";
        try {
            ohValue = OPatchEnv.getOracleHome();
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
            ohValue = "";
        }
        String pathValue = opatchProperty.getProperty("OPatch.PATH");
        String[] specialEnvp = new String[2];
        buff = new StringBuffer("ORACLE_HOME");
        buff.append("=");
        buff.append(ohValue);
        specialEnvp[0] = buff.toString();
        buff = new StringBuffer("PATH");
        buff.append("=");
        buff.append(pathValue);
        specialEnvp[1] = buff.toString();
        if (ohValue != null && !ohValue.equals("")) {
            OUIReplacer.setEnv("ORACLE_HOME", ohValue);
        }
        if (pathValue != null && !pathValue.equals("")) {
            OUIReplacer.setEnv("PATH", pathValue);
        }
        if (suCommandPath == null) {
            SystemCall.checkSuCommand();
        }
        if (command == null) {
            String[] tmp = new String[]{"Null Command given by caller"};
            ret = new ExecReturn(tmp);
            ret.setErrorMessage("");
            ret.setNormalMessage("");
            ret.setReturnCode(0);
            return ret;
        }
        ArrayList<String> cmds = new ArrayList<String>();
        if (username != null) {
            cmds.add(suCommandPath);
            cmds.add(username);
            cmds.add("-m");
            cmds.add("-c");
            cmds.add(command);
        } else {
            cmds.addAll(Arrays.asList(command.split("\\s")));
        }
        ret = new ExecReturn(cmds.toArray(new String[cmds.size()]));
        ProcessBuilder pb = new ProcessBuilder(cmds);
        int retValue = -1;
        try {
            Process process = pb.start();
            InputStreamReader errorStream = new InputStreamReader(process.getErrorStream());
            InputStreamReader inputStream = new InputStreamReader(process.getInputStream());
            ReaderThread rerror = new ReaderThread(errorStream, "ErrorStream");
            ReaderThread rinput = new ReaderThread(inputStream, "InputStream");
            OLogger.debug(new StringBuffer("SystemCall:process(cmds, username): GOING to start thread to read Input Stream"));
            rinput.start();
            OLogger.debug(new StringBuffer("SystemCall:process(cmds, username): Started thread to read Input Stream"));
            OLogger.debug(new StringBuffer("SystemCall:process(cmds, username): GOING to start thread to read Error Stream"));
            rerror.start();
            OLogger.debug(new StringBuffer("SystemCall:process(cmds, username): Started thread to read Error Stream"));
            OLogger.debug(new StringBuffer("SystemCall:process(cmds, username): GOING into process.waitFor()"));
            retValue = process.waitFor();
            OLogger.debug(new StringBuffer("SystemCall:process(cmds, username): process.waitFor() is OVER"));
            try {
                rerror.join();
                OLogger.debug(new StringBuffer("SystemCall:process(cmds, username): Error stream thread joined successfully"));
                rinput.join();
                OLogger.debug(new StringBuffer("SystemCall:process(cmds, username): Input stream thread joined successfully"));
                ret.setNormalMessage(rinput.outputString);
                ret.setErrorMessage(rerror.outputString);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ret.setReturnCode(retValue);
        }
        catch (Throwable t) {
            ret.setErrorMessage(t.getMessage());
            ret.setNormalMessage(t.getMessage());
            ret.setReturnCode(-1);
        }
        return ret;
    }

    public static void copyFile(Path src, Path dst) throws RuntimeException {
        SystemCall.copyFile(src, dst, null);
    }

    public static void copyFile(Path src, Path dst, CopyAction copyAction) throws RuntimeException {
        StringBuffer tmp = new StringBuffer("SystemCall::copyFile()");
        Path srcPath = src;
        Path dstPath = dst;
        boolean updateTimeStamp = false;
        boolean retainPermission = false;
        if (copyAction != null) {
            updateTimeStamp = copyAction.isUpdateTimeStamp();
            retainPermission = copyAction.isRetainPermission();
        }
        boolean dstNotExist = false;
        if (dst.equals("") || !Files.exists(dst, new LinkOption[0])) {
            dstNotExist = true;
            try {
                Files.createDirectories(dst.getParent(), new FileAttribute[0]);
                Files.createFile(dst, new FileAttribute[0]);
            }
            catch (Exception e2) {
                RuntimeException re = new RuntimeException(e2.getMessage());
                re.setStackTrace(e2.getStackTrace());
                throw re;
            }
        }
        OLogger.debug(tmp);
        tmp.append(": copy file ");
        tmp.append(srcPath);
        tmp.append(" to ");
        tmp.append(dstPath);
        OLogger.debug(tmp);
        int finalPerm = 0;
        String patchMode = copyAction != null ? copyAction.getPermission() : "";
        boolean noRetain = false;
        try {
            block43: {
                boolean usePatchMode;
                if (!OPatchEnv.isWindows()) {
                    if (retainPermission && !dstNotExist) {
                        try {
                            finalPerm = OUIReplacer.getPermission(dst.toString());
                        }
                        catch (RuntimeException e3) {
                            tmp = new StringBuffer("Getting permission of destination file \"");
                            tmp.append(dst.toString());
                            tmp.append("\" failed. ");
                            OLogger.debug(tmp.toString());
                            OLogger.warn("OUI-67729", new Object[]{dst.toString()});
                        }
                    } else {
                        noRetain = true;
                        finalPerm = OUIReplacer.getPermission(src.toString());
                    }
                }
                if (BusyFileProcessor.canDoRenameCopy(dst)) {
                    Path renameFile = WrapperFactory.getNioServiceWrapper().getPath(dst.toAbsolutePath().toString() + ".bk", new String[0]);
                    boolean renameResult = true;
                    try {
                        Files.move(dst, renameFile, new CopyOption[0]);
                    }
                    catch (Exception e4) {
                        renameResult = false;
                    }
                    if (renameResult) {
                        try {
                            Files.deleteIfExists(renameFile);
                        }
                        catch (Exception exception) {
                            OLogger.log("Failed to delete backup file \" {0} \"" + new Object[]{renameFile.toAbsolutePath().toString()}, new Object[0]);
                        }
                    }
                    OLogger.log("Rename File \"{0}\" to \"{1}\"", dst.toAbsolutePath().toString(), renameFile.toAbsolutePath().toString());
                }
                boolean bl = usePatchMode = noRetain && !"".equals(patchMode);
                if (!OPatchEnv.isWindows() && !Files.isWritable(dst) && usePatchMode) {
                    try {
                        OUIReplacer.setPermission(dst.toString(), patchMode);
                    }
                    catch (RuntimeException e5) {
                        tmp = new StringBuffer("Changing permission of file \"");
                        tmp.append(src.toString());
                        tmp.append("\" failed.");
                        OLogger.debug(tmp.toString());
                        OLogger.warn("OUI-67740", new Object[]{dst.toString()});
                    }
                }
                SystemCall.fastCopy(src, dst);
                if (!OPatchEnv.isWindows()) {
                    String errType = null;
                    try {
                        if (usePatchMode) {
                            errType = "OUI-67740";
                            OUIReplacer.setPermission(dst.toString(), patchMode);
                        } else {
                            errType = "OUI-67729";
                            OUIReplacer.changePermission(dst.toString(), finalPerm);
                        }
                    }
                    catch (RuntimeException e6) {
                        if (!retainPermission) break block43;
                        tmp = new StringBuffer("Changing permission of file \"");
                        tmp.append(src.toString());
                        tmp.append("\" failed.");
                        OLogger.debug(tmp.toString());
                        OLogger.warn(errType, new Object[]{dst.toString()});
                    }
                }
            }
            if (!updateTimeStamp) {
                FileTime time = Files.getLastModifiedTime(src, new LinkOption[0]);
                Files.setLastModifiedTime(dst, time);
            }
        }
        catch (Throwable t) {
            tmp = new StringBuffer("SystemCall::copyFile() failed, ");
            tmp.append(t.getMessage());
            OLogger.debug(tmp);
            if (OPatchEnv.isAIXPlatform() || OPatchEnv.isHPUXPlatform()) {
                if (!dstNotExist) {
                    if (OPatchEnv.isAIXPlatform()) {
                        try {
                            Files.deleteIfExists(dst);
                        }
                        catch (IOException e7) {
                            OLogger.debug(e7.getMessage());
                        }
                    } else {
                        Path renameFile = WrapperFactory.getNioServiceWrapper().getPath(dst.toAbsolutePath().toString() + ".bk", new String[0]);
                        boolean renameResult = true;
                        try {
                            Files.move(dst, renameFile, new CopyOption[0]);
                        }
                        catch (Exception e8) {
                            renameResult = false;
                        }
                        if (renameResult) {
                            try {
                                Files.deleteIfExists(renameFile);
                            }
                            catch (Exception exception) {
                                OLogger.log("Failed to delete backup file \" {0} \"" + new Object[]{renameFile.toAbsolutePath().toString()}, new Object[0]);
                            }
                        }
                    }
                }
                try {
                    block44: {
                        int len;
                        InputStream in = Files.newInputStream(src, new OpenOption[0]);
                        OutputStream out = Files.newOutputStream(dst, new OpenOption[0]);
                        byte[] buf = new byte[1024];
                        while ((len = in.read(buf)) > 0) {
                            out.write(buf, 0, len);
                        }
                        in.close();
                        out.close();
                        try {
                            OUIReplacer.changePermission(dst.toString(), finalPerm);
                        }
                        catch (RuntimeException e9) {
                            if (!retainPermission) break block44;
                            tmp = new StringBuffer("Changing permission of file \"");
                            tmp.append(src.toString());
                            tmp.append("\" failed.");
                            OLogger.debug(tmp.toString());
                            OLogger.warn("OUI-67729", new Object[]{dst.toString()});
                        }
                    }
                    if (!updateTimeStamp) {
                        FileTime time = Files.getLastModifiedTime(src, new LinkOption[0]);
                        Files.setLastModifiedTime(dst, time);
                    }
                }
                catch (Throwable th) {
                    RuntimeException re = new RuntimeException(th.getMessage());
                    re.setStackTrace(th.getStackTrace());
                    throw re;
                }
            }
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
    }

    public static void backupFile(Path src, Path dst) throws RuntimeException {
        StringBuffer tmp = new StringBuffer("SystemCall::backupFile()");
        Path srcPath = src;
        Path dstPath = dst;
        if (!Files.exists(dst, new LinkOption[0])) {
            try {
                Files.createDirectories(dst.getParent(), new FileAttribute[0]);
                Files.createFile(dst, new FileAttribute[0]);
            }
            catch (Exception e2) {
                RuntimeException re = new RuntimeException(e2.getMessage());
                re.setStackTrace(e2.getStackTrace());
                throw re;
            }
        }
        OLogger.debug(tmp);
        tmp.append(": back up file ");
        tmp.append(srcPath);
        tmp.append(" to ");
        tmp.append(dstPath);
        OLogger.debug(tmp);
        try {
            SystemCall.fastCopy(src, dst);
            if (!OPatchEnv.isWindows()) {
                int perm = OUIReplacer.getPermission(src.toString());
                OUIReplacer.changePermission(dst.toString(), perm);
            }
            FileTime time = Files.getLastModifiedTime(src, new LinkOption[0]);
            Files.setLastModifiedTime(dst, time);
        }
        catch (Throwable t) {
            tmp = new StringBuffer("SystemCall::backupFile() failed, ");
            tmp.append(t.getMessage());
            OLogger.debug(tmp);
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
    }

    protected static void copyInventoryFile(Path src, Path dst) throws RuntimeException {
        StringBuffer tmp = new StringBuffer("SystemCall::copyInventoryFile()");
        OLogger.debug(tmp);
        Path srcPath = src;
        Path dstPath = dst;
        tmp.append(": copy file ");
        tmp.append(srcPath);
        tmp.append(" to ");
        tmp.append(dstPath);
        OLogger.debug(tmp);
        try {
            SystemCall.fastCopy(src, dst);
            if (!OPatchEnv.isWindows()) {
                int perm = OUIReplacer.getPermission(src.toString());
                OUIReplacer.changePermission(dst.toString(), perm);
            }
            FileTime time = Files.getLastModifiedTime(src, new LinkOption[0]);
            Files.setLastModifiedTime(dst, time);
        }
        catch (Throwable t) {
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
    }

    public static boolean chownRecurse(String dir, String owner, String group) {
        if (OPatchEnv.isWindows()) {
            return true;
        }
        Path top = WrapperFactory.getNioServiceWrapper().getPath(dir, new String[0]);
        try {
            OiixFileOps.chown((String)dir, (String)owner, (String)group);
        }
        catch (IOException e2) {
            return false;
        }
        if (Files.isRegularFile(top, new LinkOption[0])) {
            return true;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(top);){
            for (Path entry : stream) {
                SystemCall.chownRecurse(entry.toAbsolutePath().toString(), owner, group);
            }
        }
        catch (IOException e3) {
            OLogger.debug(e3.getMessage());
        }
        return true;
    }

    public static void copyRecurse(Path src, Path dst, boolean debug) throws RuntimeException {
        SystemCall.copyRecurse(src, dst, debug, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean copyRecurseForRestore(Path src, Path dst, boolean debug, boolean errorOut) throws RuntimeException {
        boolean errorHasHappened;
        StringBuffer tmpSb;
        block32: {
            boolean cont;
            StringBuffer tmp = new StringBuffer("SystemCall::copyRecurseForRestore()");
            tmpSb = null;
            String srcPath = src.toString();
            String dstPath = dst.toString();
            errorHasHappened = false;
            if (debug) {
                tmp.append(": from ");
                tmp.append(srcPath);
                tmp.append(" to ");
                tmp.append(dstPath);
                OLogger.debug(tmp);
            }
            if (!(cont = true)) {
                if (!debug) return errorHasHappened;
                tmp = new StringBuffer("REPORT: Users request no system modification, skip recursive copy from ");
                tmp.append(srcPath);
                tmp.append("  to  ");
                tmp.append(dstPath);
                OLogger.log(OLogger.FINE, tmp.toString());
                return errorHasHappened;
            }
            try {
                if (!Files.isDirectory(src, new LinkOption[0]) && !Files.isDirectory(dst, new LinkOption[0])) {
                    if (!OPatchEnv.isWindows() && Files.exists(dst, new LinkOption[0]) && !Files.isWritable(dst)) {
                        OUIReplacer.setPermission(dst.toString(), "0755");
                    }
                    SystemCall.copyFile(src, dst);
                    return errorHasHappened;
                }
                if (!Files.isDirectory(src, new LinkOption[0]) && Files.isDirectory(dst, new LinkOption[0])) {
                    tmpSb = new StringBuffer(dst.toString());
                    tmpSb.append(File.separator);
                    tmpSb.append(src.getFileName().toString());
                    Path tmpFile = WrapperFactory.getNioServiceWrapper().getPath(tmpSb.toString(), new String[0]);
                    if (!OPatchEnv.isWindows() && Files.exists(tmpFile, new LinkOption[0]) && !Files.isWritable(tmpFile)) {
                        OUIReplacer.setPermission(tmpFile.toString(), "0755");
                    }
                    SystemCall.copyFile(src, tmpFile);
                    return errorHasHappened;
                }
            }
            catch (Throwable e2) {
                errorHasHappened = true;
                if (!errorOut) break block32;
                RuntimeException re = new RuntimeException(e2.getMessage());
                re.setStackTrace(e2.getStackTrace());
                throw re;
            }
        }
        if (Files.isDirectory(src, new LinkOption[0]) && !Files.isDirectory(dst, new LinkOption[0])) {
            return errorHasHappened;
        }
        if (!Files.isDirectory(src, new LinkOption[0])) return errorHasHappened;
        if (!Files.isDirectory(dst, new LinkOption[0])) return errorHasHappened;
        Path tmpF = null;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(src);){
            Iterator<Path> iterator = stream.iterator();
            while (iterator.hasNext()) {
                Path entry = iterator.next();
                if (Files.isDirectory(entry, new LinkOption[0])) {
                    tmpSb = new StringBuffer(dst.toString());
                    tmpSb.append(File.separator);
                    tmpSb.append(entry.getFileName().toString());
                    tmpF = WrapperFactory.getNioServiceWrapper().getPath(tmpSb.toString(), new String[0]);
                    boolean createDirResult = true;
                    try {
                        Files.createDirectories(tmpF, new FileAttribute[0]);
                    }
                    catch (Exception e3) {
                        createDirResult = false;
                    }
                    if (!Files.exists(tmpF, new LinkOption[0]) && !createDirResult) {
                        boolean bl = errorHasHappened;
                        return bl;
                    }
                } else {
                    tmpF = dst;
                }
                boolean retVal = SystemCall.copyRecurseForRestore(entry, tmpF, false, errorOut);
                errorHasHappened = errorHasHappened ? true : retVal;
            }
            return errorHasHappened;
        }
        catch (IOException e4) {
            OLogger.debug(e4.getMessage());
        }
        return errorHasHappened;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean copyRecurse(Path src, Path dst, boolean debug, boolean errorOut) throws RuntimeException {
        boolean errorHasHappened;
        StringBuffer tmpSb;
        block31: {
            boolean cont;
            StringBuffer tmp = new StringBuffer("SystemCall::copyRecurse()");
            tmpSb = null;
            String srcPath = src.toString();
            String dstPath = dst.toString();
            errorHasHappened = false;
            if (debug) {
                tmp.append(": from ");
                tmp.append(srcPath);
                tmp.append(" to ");
                tmp.append(dstPath);
                OLogger.debug(tmp);
            }
            if (!(cont = true)) {
                if (!debug) return errorHasHappened;
                tmp = new StringBuffer("REPORT: Users request no system modification, skip recursive copy from ");
                tmp.append(srcPath);
                tmp.append("  to  ");
                tmp.append(dstPath);
                OLogger.log(OLogger.FINE, tmp.toString());
                return errorHasHappened;
            }
            try {
                if (!Files.isDirectory(src, new LinkOption[0]) && !Files.isDirectory(dst, new LinkOption[0])) {
                    SystemCall.copyFile(src, dst);
                    return errorHasHappened;
                }
                if (!Files.isDirectory(src, new LinkOption[0]) && Files.isDirectory(dst, new LinkOption[0])) {
                    tmpSb = new StringBuffer(dst.toString());
                    tmpSb.append(File.separator);
                    tmpSb.append(src.getFileName().toString());
                    SystemCall.copyFile(src, WrapperFactory.getNioServiceWrapper().getPath(tmpSb.toString(), new String[0]));
                    return errorHasHappened;
                }
            }
            catch (Throwable e2) {
                errorHasHappened = true;
                if (!errorOut) break block31;
                RuntimeException re = new RuntimeException(e2.getMessage());
                re.setStackTrace(e2.getStackTrace());
                throw re;
            }
        }
        if (Files.isDirectory(src, new LinkOption[0]) && !Files.isDirectory(dst, new LinkOption[0])) {
            return errorHasHappened;
        }
        if (!Files.isDirectory(src, new LinkOption[0])) return errorHasHappened;
        if (!Files.isDirectory(dst, new LinkOption[0])) return errorHasHappened;
        Path tmpF = null;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(src);){
            Iterator<Path> iterator = stream.iterator();
            while (iterator.hasNext()) {
                Path entry = iterator.next();
                if (Files.isDirectory(entry, new LinkOption[0])) {
                    tmpSb = new StringBuffer(dst.toString());
                    tmpSb.append(File.separator);
                    tmpSb.append(entry.getFileName().toString());
                    tmpF = WrapperFactory.getNioServiceWrapper().getPath(tmpSb.toString(), new String[0]);
                    if (!Files.exists(tmpF, new LinkOption[0])) {
                        try {
                            Files.createDirectories(tmpF, new FileAttribute[0]);
                        }
                        catch (IOException e3) {
                            boolean bl = errorHasHappened;
                            if (stream == null) return bl;
                            if (var12_15 == null) {
                                stream.close();
                                return bl;
                            }
                            try {
                                stream.close();
                                return bl;
                            }
                            catch (Throwable throwable) {
                                var12_15.addSuppressed(throwable);
                                return bl;
                            }
                        }
                    }
                } else {
                    tmpF = dst;
                }
                boolean retVal = SystemCall.copyRecurse(entry, tmpF, false, errorOut);
                errorHasHappened = errorHasHappened ? true : retVal;
            }
            return errorHasHappened;
        }
        catch (IOException e4) {
            OLogger.debug(e4.getMessage());
            return true;
        }
    }

    protected static void backupRecurse(Path src, Path dst, boolean debug) throws RuntimeException {
        StringBuffer tmp = new StringBuffer("SystemCall::backupRecurse()");
        StringBuffer tmpSb = null;
        String srcPath = src.toString();
        String dstPath = dst.toString();
        if (debug) {
            tmp.append(": from ");
            tmp.append(srcPath);
            tmp.append(" to ");
            tmp.append(dstPath);
            OLogger.debug(tmp);
        }
        if (!Files.isDirectory(src, new LinkOption[0]) && !Files.isDirectory(dst, new LinkOption[0])) {
            SystemCall.copyFile(src, dst);
            return;
        }
        if (!Files.isDirectory(src, new LinkOption[0]) && Files.isDirectory(dst, new LinkOption[0])) {
            tmpSb = new StringBuffer(dst.toString());
            tmpSb.append(File.separator);
            tmpSb.append(src.getFileName().toString());
            SystemCall.copyFile(src, WrapperFactory.getNioServiceWrapper().getPath(tmpSb.toString(), new String[0]));
            return;
        }
        if (Files.isDirectory(src, new LinkOption[0]) && !Files.isDirectory(dst, new LinkOption[0])) {
            return;
        }
        if (Files.isDirectory(src, new LinkOption[0]) && Files.isDirectory(dst, new LinkOption[0])) {
            Path tmpF = null;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(src);){
                for (Path entry : stream) {
                    if (Files.isDirectory(entry, new LinkOption[0])) {
                        tmpSb = new StringBuffer(dst.toString());
                        tmpSb.append(File.separator);
                        tmpSb.append(entry.getFileName().toString());
                        tmpF = WrapperFactory.getNioServiceWrapper().getPath(tmpSb.toString(), new String[0]);
                        if (!Files.exists(tmpF, new LinkOption[0])) {
                            try {
                                Files.createDirectories(tmpF, new FileAttribute[0]);
                            }
                            catch (IOException e2) {
                                if (stream != null) {
                                    if (var9_10 != null) {
                                        try {
                                            stream.close();
                                        }
                                        catch (Throwable throwable) {
                                            var9_10.addSuppressed(throwable);
                                        }
                                    } else {
                                        stream.close();
                                    }
                                }
                                return;
                            }
                        }
                    } else {
                        tmpF = dst;
                    }
                    SystemCall.copyRecurse(entry, tmpF, false);
                }
            }
            catch (IOException e3) {
                OLogger.debug(e3.getMessage());
            }
            return;
        }
    }

    protected static void deleteRecurse(String oracleHomePath, String cookedPatchID, Path src, boolean debug) throws RuntimeException {
        StringBuffer tmp = new StringBuffer("SystemCall::deleteRecurse(): ");
        tmp.append(src.toString());
        if (debug) {
            OLogger.debug(tmp);
        }
        String srcPath = src.toAbsolutePath().normalize().toString();
        String patchStorage = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath, cookedPatchID);
        Path patchStorateFile = WrapperFactory.getNioServiceWrapper().getPath(patchStorage, new String[0]);
        StringBuffer strCheck = new StringBuffer(patchStorateFile.toAbsolutePath().normalize().toString());
        if (debug) {
            tmp = new StringBuffer("SystemCall::deleteRecurse() check if the dir. to be deleted is ");
            tmp.append("a sub-directory of ");
            tmp.append(strCheck.toString());
            OLogger.debug(tmp);
        }
        if (!srcPath.startsWith(strCheck.toString())) {
            if (debug) {
                tmp = new StringBuffer("SystemCall::deleteRecurse() is called to delete ");
                tmp.append("some dir. outside OH/.patch_storage/<ID>.  Ignore delete request.");
                OLogger.debug(tmp);
            }
            return;
        }
        SystemCall.deleteRecurse(src, debug);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteRecurse(Path src, boolean debug) {
        StringBuffer tmp = new StringBuffer("SystemCall::deleteRecurse(): ");
        tmp.append(src.toString());
        if (debug) {
            OLogger.debug(tmp);
        }
        StringBuffer tmpSb = null;
        if (!Files.exists(src, new LinkOption[0])) {
            return;
        }
        if (!Files.isDirectory(src, new LinkOption[0])) {
            try {
                Files.deleteIfExists(src);
            }
            catch (IOException e2) {
                OLogger.debug(e2.getMessage());
            }
            return;
        }
        if (Files.isDirectory(src, new LinkOption[0])) {
            DirectoryStream<Path> stream = null;
            try {
                stream = Files.newDirectoryStream(src);
                Path tmpF = null;
                for (Path entry : stream) {
                    tmpSb = new StringBuffer(src.toString());
                    tmpSb.append(File.separator);
                    tmpSb.append(entry.getFileName().toString());
                    tmpF = WrapperFactory.getNioServiceWrapper().getPath(tmpSb.toString(), new String[0]);
                    SystemCall.deleteRecurse(tmpF, debug);
                }
            }
            catch (IOException e3) {
                OLogger.debug(e3.getMessage());
            }
            finally {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e4) {
                    OLogger.debug(e4.getMessage());
                }
            }
            try {
                Files.deleteIfExists(src);
            }
            catch (IOException e5) {
                OLogger.debug(e5.getMessage());
            }
            return;
        }
    }

    protected static void touch(String filePath) {
        StringBuffer buff = new StringBuffer("SystemCall::touch(");
        buff.append(filePath);
        buff.append(")");
        OLogger.debug(buff);
        Path file = WrapperFactory.getNioServiceWrapper().getPath(filePath, new String[0]);
        if (Files.exists(file, new LinkOption[0]) && Files.isWritable(file) && Files.isRegularFile(file, new LinkOption[0])) {
            FileTime lastModTime = null;
            try {
                lastModTime = Files.getLastModifiedTime(file, new LinkOption[0]);
            }
            catch (IOException e1) {
                OLogger.debug(e1.getMessage());
            }
            Date date = new Date(lastModTime.toMillis());
            buff = new StringBuffer(filePath);
            buff.append(" old time: ");
            buff.append(date.toString());
            OLogger.debug(buff);
            long newModTime = System.currentTimeMillis();
            FileTime ft = FileTime.fromMillis(newModTime);
            boolean setTimeResult = true;
            try {
                Files.setLastModifiedTime(file, ft);
            }
            catch (IOException e2) {
                setTimeResult = false;
            }
            if (!setTimeResult) {
                OLogger.error("SystemCaller::touch(): Can't change modified time of file" + filePath);
            } else {
                Date newDate = new Date(ft.toMillis());
                buff = new StringBuffer(filePath);
                buff.append(" new time: ");
                buff.append(newDate.toString());
                OLogger.debug(buff);
            }
        }
    }

    protected static ExecReturn runArchive(String oracleHomePath, String src, String dst) {
        boolean cont = Rules.SystemWrite_continue();
        OPatchProperty opp = new OPatchProperty();
        StringBuffer archiveCommand = null;
        try {
            archiveCommand = new StringBuffer(opp.getArchiveCommand());
        }
        catch (Exception exception) {
            // empty catch block
        }
        archiveCommand.append(" -rc");
        archiveCommand.append(" ");
        archiveCommand.append(dst);
        archiveCommand.append(" ");
        archiveCommand.append(src);
        String cmd = archiveCommand.toString();
        StringBuffer buff = new StringBuffer("SystemCall::runArchive(), set archive command to \"");
        buff.append(cmd);
        buff.append("\"");
        OLogger.debug(buff);
        OLogger.log(OLogger.FINE, "Executing '" + cmd + "'");
        String[] cmds = new String[]{cmd};
        ExecReturn ret = new ExecReturn(cmds);
        if (OPatchEnv.isWindows()) {
            StringBuffer winCmd = new StringBuffer("SystemCall::runArchive() on Windows: skip invoking \"");
            winCmd.append(buff.toString());
            winCmd.append("\"");
            OLogger.debug(winCmd);
            return ret;
        }
        if (cont) {
            buff = new StringBuffer("SystemCall::runArchive() on Unix, invoking \"");
            buff.append(cmd);
            buff.append("\"");
            OLogger.debug(buff);
            ret = SystemCall.runtimeExec(cmd);
        } else {
            buff = new StringBuffer("REPORT: skip invoking \"");
            buff.append(cmd);
            buff.append("\"");
            OLogger.log(OLogger.FINEST, buff.toString());
        }
        return ret;
    }

    protected static ExecReturn runMake(StdoutStatus caller, String makeCmd, String runDirPath) throws RuntimeException {
        boolean cont = Rules.SystemWrite_continue();
        StringBuffer buff = new StringBuffer("SystemCall::runMake(): \"");
        buff.append(makeCmd);
        buff.append("\" under \"");
        buff.append(runDirPath);
        buff.append("\"");
        OLogger.debug(buff);
        String[] cmds = new String[]{makeCmd};
        ExecReturn ret = new ExecReturn(cmds);
        OLogger.debug(buff);
        if (cont) {
            ret = SystemCall.runtimeExec(cmds, runDirPath);
            caller.printStdout(ret);
        } else {
            buff = new StringBuffer("REPORT: skip invoking \"");
            buff.append(makeCmd);
            buff.append("\"");
            OLogger.log(OLogger.FINEST, buff.toString());
        }
        return ret;
    }

    protected static ExecReturn runPatchGen(String patchgenCmd) {
        boolean cont = Rules.SystemWrite_continue();
        StringBuffer buff = new StringBuffer("SystemCall::runPatchGen(): \"");
        buff.append(patchgenCmd);
        buff.append("\"");
        OLogger.debug(buff);
        String[] cmds = new String[]{patchgenCmd.toString()};
        ExecReturn ret = new ExecReturn(cmds);
        OLogger.debug(buff);
        if (cont) {
            ret = SystemCall.runtimeExec(patchgenCmd.toString());
        } else {
            buff = new StringBuffer("REPORT: skip invoking \"");
            buff.append(patchgenCmd.toString());
            buff.append("\"");
            OLogger.log(OLogger.FINEST, buff.toString());
        }
        return ret;
    }

    public static boolean createNewFile(String filePath) throws RuntimeException {
        Path newFile = WrapperFactory.getNioServiceWrapper().getPath(filePath, new String[0]);
        String parentDirName = newFile.getParent().toString();
        Path parentFile = WrapperFactory.getNioServiceWrapper().getPath(parentDirName, new String[0]);
        if (!Files.exists(newFile, new LinkOption[0])) {
            try {
                if (!Files.exists(parentFile, new LinkOption[0])) {
                    boolean ok = true;
                    try {
                        Files.createDirectories(parentFile, new FileAttribute[0]);
                    }
                    catch (Exception e2) {
                        ok = false;
                    }
                    if (!ok) {
                        StringBuffer buff = new StringBuffer("SystemCall::createNewFile(String) cannot mkdirs on ");
                        buff.append(parentFile);
                        OLogger.debug(buff);
                        throw new RuntimeException(buff.toString());
                    }
                }
                Files.createFile(newFile, new FileAttribute[0]);
                return true;
            }
            catch (Exception e3) {
                StringBuffer buff = new StringBuffer("SystemCall::createNewFile(String) failed to create file  ");
                buff.append(filePath);
                OLogger.debug(buff);
                throw new RuntimeException(buff.toString(), e3);
            }
        }
        return false;
    }

    public static boolean isClusterwareUp(String oracleHomePath) {
        return SystemCall.isClusterwareUp(oracleHomePath, null);
    }

    public static boolean isClusterwareUp(String oracleHomePath, String nodeName) {
        ExecReturn rt;
        boolean isUp = false;
        String crsCmd = oracleHomePath + File.separator + StringResource.CRS_STACK_CHECK_COMMAND;
        if (nodeName != null) {
            crsCmd = crsCmd + " -n " + nodeName;
        }
        if ((rt = SystemCall.runtimeExec(crsCmd)).isOK()) {
            String msg = rt.getNormalMessage();
            boolean all = true;
            for (int i2 = 0; i2 < StringResource.CRS_STACK_UP_MSGS.length; ++i2) {
                if (msg.contains(StringResource.CRS_STACK_UP_MSGS[i2])) continue;
                all = false;
            }
            if (all) {
                isUp = true;
            }
        }
        return isUp;
    }

    public static boolean isDatabaseUp(String oracleHomePath, String nodeName) {
        String[] env;
        boolean isUp = false;
        String stfile = oracleHomePath + File.separator + StringResource.HOME_STATUS_FILE;
        Path statf = WrapperFactory.getNioServiceWrapper().getPath(stfile, new String[0]);
        if (Files.exists(statf, new LinkOption[0])) {
            try {
                Files.delete(statf);
            }
            catch (IOException e2) {
                OLogger.debug(e2.getMessage());
            }
        }
        String srvctlCmd = oracleHomePath + File.separator + StringResource.HOME_STATUS_COMMAND;
        srvctlCmd = nodeName != null && !nodeName.equals("") ? srvctlCmd + " -o " + oracleHomePath + " -s " + stfile + " -n " + nodeName : srvctlCmd + " -o " + oracleHomePath + " -s " + stfile;
        String[] cmds = new String[]{srvctlCmd};
        ExecReturn rt = SystemCall.runtimeExec(cmds, env = new String[]{"ORACLE_HOME=" + oracleHomePath}, null, null, false);
        if (rt.isOK() && !rt.getNormalMessage().equals("")) {
            isUp = true;
        }
        return isUp;
    }

    public static boolean isDBInstanceUp(String oracleHome, String dbname, String nodename) {
        boolean up = false;
        StringBuffer command = new StringBuffer(oracleHome);
        command.append(File.separator).append(StringResource.INSTANCE_STATUS_COMMAND);
        command.append(" -db ").append(dbname);
        command.append(" -node ").append(nodename);
        String[] cmds = new String[]{command.toString()};
        String[] env = new String[]{"ORACLE_HOME=" + oracleHome};
        ExecReturn rt = SystemCall.runtimeExec(cmds, env, null, null, false);
        if (rt.isOK()) {
            int index = rt.getNormalMessage().indexOf("not running");
            if (index < 0) {
                up = true;
            }
        } else {
            OLogger.debug("ERROR: " + rt.getErrorMessage());
        }
        return up;
    }

    public static void setOPatchLogOutput(boolean value) {
        ReaderThread.printOnLog = value;
    }

    public static void setConsoleOutput(boolean value) {
        ReaderThread.printConsole = value;
    }

    public static void breakHardLink(Path srcFile) {
        Path dstFile = WrapperFactory.getNioServiceWrapper().getPath(srcFile.toAbsolutePath().toString() + ".hltemp", new String[0]);
        SystemCall.copyFile(srcFile, dstFile);
        try {
            Files.deleteIfExists(srcFile);
            Files.move(dstFile, srcFile, new CopyOption[0]);
        }
        catch (IOException e2) {
            OLogger.debug(e2.getMessage());
        }
    }

    public static class ExecReturn {
        String[] systemCommand;
        String errorMessage;
        String normalMessage;
        int retCode;
        boolean ok;

        public ExecReturn(String[] cmd) {
            this.systemCommand = cmd;
            this.errorMessage = "";
            this.normalMessage = "";
            this.retCode = 0;
            this.ok = true;
        }

        public String getCommand() {
            if (this.systemCommand != null) {
                StringBuffer cmd = new StringBuffer();
                for (int i2 = 0; i2 < this.systemCommand.length; ++i2) {
                    cmd.append(this.systemCommand[i2]);
                    cmd.append("\n");
                }
                return cmd.toString();
            }
            return "Command not intialized";
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public String getNormalMessage() {
            return this.normalMessage;
        }

        public int getReturnCode() {
            return this.retCode;
        }

        public boolean isOK() {
            return this.ok;
        }

        protected void setErrorMessage(String msg) {
            this.errorMessage = msg;
        }

        protected void setNormalMessage(String msg) {
            this.normalMessage = msg;
        }

        protected void setReturnCode(int c2) {
            this.retCode = c2;
            this.ok = this.retCode == 0;
        }

        public String toString() {
            StringBuffer buff = new StringBuffer("[SystemCall.ExecReturn: ");
            buff.append("systemCommand= (");
            if (this.systemCommand == null) {
                buff.append("null");
            } else {
                for (int i2 = 0; i2 < this.systemCommand.length; ++i2) {
                    String cmd = this.systemCommand[i2];
                    if (cmd == null) continue;
                    buff.append("\"");
                    buff.append(cmd);
                    buff.append("\"");
                    if (i2 == this.systemCommand.length - 1) continue;
                    buff.append(", ");
                }
                buff.append(")");
            }
            buff.append(", errMsg= ");
            buff.append(this.errorMessage);
            buff.append(", normalMsg= ");
            buff.append(this.normalMessage);
            buff.append(", return code= ");
            buff.append(this.retCode);
            buff.append(", exec. ok= ");
            buff.append(this.ok);
            buff.append("]");
            return buff.toString();
        }
    }
}

