/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.opatch.OPatchACL;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OUIReplacer;
import oracle.opatch.SystemCall;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.wrappers.WrapperFactory;

public class Uname {
    protected static final int UNDEFINED_PLATFORM_ID = 0;
    private static final String WINDOWS_NT_OS_NAME = "Windows NT";
    private static final String WINDOWS_64_OS_NAME = "Windows 64-bit";
    private static final String WINDOWS_2000_OS_NAME = "Windows 2000";
    private static final String WINDOWS_XP_64_OS_NAME = "Windows XP";
    private static final String WINDOWS_95_OS_NAME = "Windows 95";
    private static final String WINDOWS_ME_OS_NAME = "Windows Me";
    private static final String WINDOWS_2003_OS_NAME = "Windows 2003";
    private static final String WINDOWS_98_OS_NAME = "Windows 98";
    private static final String LINUX_OS_NAME = "Linux";
    private static final String LINUX_S390_OS_NAME = "Linux";
    private static final String HP_IA64_OS_NAME = "HP-UX";
    private static final String LINUX_IA64_OS_NAME = "Linux";
    private static final String SOLARIS_OS_NAME = "Solaris";
    private static final String SUNOS_OS_NAME = "SunOS";
    private static final String DEC_ALPHA_NT_OS_NAME = "Windows NT";
    private static final String SOLARIS_INTEL_OS_NAME = "Solaris";
    private static final String SIEMENS_NIXDORF_OS_NAME = "SINIX-Y";
    private static final String SIEMENS_PYRAMID_OS_NAME = "ReliantUNIX-M";
    private static final String DIGITAL_UNIX_OS_NAME = "OSF1";
    private static final String AIX_OS_NAME = "AIX";
    private static final String SEQUENT_OS_NAME = "DYNIX/ptx";
    private static final String UNIXWARE_OS_NAME = "UnixWare";
    private static final String DEC_ALPHA_VMS_OS_NAME = "OpenVMS";
    private static final String DATA_GENERAL_OS_NAME = "DG/UX";
    private static final String HP_UX_OS_NAME = "HP-UX";
    private static final String Z_OS_OS_NAME = "z/OS";
    private static final String NETWARE_411_OS_NAME = "NetWare 4.11";
    private static final String NETWARE_500_OS_NAME = "NetWare 5.00";
    private static final String NEC_UX_4800_OS_NAME = "UX/4800";
    private static final String HITACHI_OS_NAME = "HI-UX/WE2";
    private static final String SGI_OS_NAME = "Irix";
    private static final String NCOS_OS_NAME = "NCOS";
    private static final String INTEL_MAC_OS_NAME = "Mac OS X";

    protected static boolean invalidPlatformID(int ARUID) {
        return ARUID == 0;
    }

    private static int getSolaris(String osName, String oracleHomePath) {
        int ID = 453;
        StringBuffer buff = new StringBuffer("Uname::getSolaris(), default to ");
        buff.append(ID);
        OLogger.debug(buff);
        try {
            buff = new StringBuffer("   preparing to invoke \"/bin/isainfo\"");
            OLogger.debug(buff);
            String cmd = "/bin/isainfo";
            SystemCall.ExecReturn ret = SystemCall.runtimeExec(cmd);
            if (ret.isOK()) {
                String output = ret.getNormalMessage();
                buff = new StringBuffer("   parsing output=\"");
                buff.append(output);
                buff.append("\"");
                OLogger.debug(buff);
                StringBuffer S23 = new StringBuffer("(.*)(");
                S23.append("sparcv9");
                S23.append(")(.*)");
                Pattern sol23 = Pattern.compile(S23.toString());
                buff = new StringBuffer("   checking pattern \"");
                buff.append(S23.toString());
                buff.append("\"");
                OLogger.debug(buff);
                Matcher m2 = sol23.matcher(output);
                if (m2.find()) {
                    ID = 23;
                    buff = new StringBuffer("   matching pattern \"");
                    buff.append(S23.toString());
                    buff.append("\", setting ID to ");
                    buff.append(ID);
                    buff.append(", then looking into OH/lib and OH/lib32");
                    OLogger.debug(buff);
                    StringBuffer ohLib = new StringBuffer(oracleHomePath);
                    ohLib.append(File.separator);
                    String lib = ohLib.toString() + "lib";
                    String lib32 = ohLib.toString() + "lib32";
                    Path fLib = WrapperFactory.getNioServiceWrapper().getPath(lib, new String[0]);
                    Path fLib32 = WrapperFactory.getNioServiceWrapper().getPath(lib32, new String[0]);
                    if (Files.exists(fLib, new LinkOption[0]) && !Files.exists(fLib32, new LinkOption[0])) {
                        ID = 453;
                        buff = new StringBuffer("     OH/lib is there and OH/lib32 not there, set ID to ");
                        buff.append(ID);
                        OLogger.debug(buff);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ID;
    }

    private static int getWin(String osName) {
        String sample_w2000 = "Microsoft Windows 2000 [Version 5.00.2195]";
        String sample_w215 = "Microsoft Windows [Version 5.00.2195]";
        boolean is64bit = false;
        is64bit = System.getProperty("os.name").contains("Windows") ? System.getenv("ProgramFiles(x86)") != null : System.getProperty("os.arch").indexOf("64") != -1;
        int ID = is64bit ? 233 : 912;
        StringBuffer buff = new StringBuffer("Uname::getWin(), default to ");
        buff.append(ID);
        OLogger.debug(buff);
        try {
            String cmd = "cmd /C ver";
            buff = new StringBuffer("   invoking \"");
            buff.append(cmd);
            buff.append("\"");
            OLogger.debug(buff);
            SystemCall.ExecReturn ret = SystemCall.runtimeExec(cmd);
            if (ret.isOK()) {
                String output = ret.getNormalMessage();
                buff = new StringBuffer("   parsing output=\"");
                buff.append(output);
                buff.append("\"");
                OLogger.debug(buff);
                StringBuffer w2000 = new StringBuffer("(.*)(");
                w2000.append("Microsoft Windows 2000");
                w2000.append(")(.*)");
                Pattern p2 = Pattern.compile(w2000.toString());
                Matcher m2 = p2.matcher(output);
                buff = new StringBuffer("   checking pattern \"");
                buff.append(w2000.toString());
                buff.append("\"");
                OLogger.debug(buff);
                if (m2.find()) {
                    ID = 100;
                    buff = new StringBuffer("   matching pattern \"");
                    buff.append(w2000.toString());
                    buff.append("\", setting ID to ");
                    buff.append(ID);
                    OLogger.debug(buff);
                    return ID;
                }
                StringBuffer winV6 = new StringBuffer("(.*)(");
                winV6.append("Microsoft Windows \\[Version 6");
                winV6.append(")(.*)");
                p2 = Pattern.compile(winV6.toString());
                m2 = p2.matcher(output);
                buff = new StringBuffer("   checking pattern \"");
                buff.append(winV6.toString());
                buff.append("\"");
                OLogger.debug(buff);
                if (m2.find()) {
                    ID = 233;
                    buff = new StringBuffer("   matching pattern \"");
                    buff.append(winV6.toString());
                    buff.append("\", setting ID to ");
                    buff.append(ID);
                    OLogger.debug(buff);
                    return ID;
                }
                StringBuffer winXp = new StringBuffer("(.*)(");
                winXp.append("Microsoft Windows XP \\[Version 5");
                winXp.append(")(.*)");
                p2 = Pattern.compile(winXp.toString());
                m2 = p2.matcher(output);
                buff = new StringBuffer("   checking pattern \"");
                buff.append(winXp.toString());
                buff.append("\"");
                OLogger.debug(buff);
                if (m2.find()) {
                    ID = 207;
                    buff = new StringBuffer("   matching pattern \"");
                    buff.append(winXp.toString());
                    buff.append("\", setting ID to ");
                    buff.append(ID);
                    OLogger.debug(buff);
                    return ID;
                }
                StringBuffer wTerminalServer = new StringBuffer("(.*)(");
                wTerminalServer.append("Microsoft Windows NT Terminal Server");
                wTerminalServer.append(")(.*)");
                p2 = Pattern.compile(wTerminalServer.toString());
                m2 = p2.matcher(output);
                buff = new StringBuffer("   checking pattern \"");
                buff.append(wTerminalServer.toString());
                buff.append("\"");
                OLogger.debug(buff);
                if (m2.find()) {
                    ID = 175;
                    buff = new StringBuffer("   matching pattern \"");
                    buff.append(wTerminalServer.toString());
                    buff.append("\", setting ID to ");
                    buff.append(ID);
                    OLogger.debug(buff);
                    return ID;
                }
                StringBuffer wNT40 = new StringBuffer("(.*)(");
                wNT40.append("Windows NT Version 4.0");
                wNT40.append(")(.*)");
                p2 = Pattern.compile(wNT40.toString());
                m2 = p2.matcher(output);
                buff = new StringBuffer("   checking pattern \"");
                buff.append(wNT40.toString());
                buff.append("\"");
                OLogger.debug(buff);
                if (m2.find()) {
                    ID = 912;
                    buff = new StringBuffer("   matching pattern \"");
                    buff.append(wNT40.toString());
                    buff.append("\", setting ID to ");
                    buff.append(ID);
                    OLogger.debug(buff);
                    return ID;
                }
                StringBuffer w98 = new StringBuffer("(.*)(");
                w98.append("Microsoft Windows 98");
                w98.append(")(.*)");
                p2 = Pattern.compile(w98.toString());
                m2 = p2.matcher(output);
                buff = new StringBuffer("   checking pattern \"");
                buff.append(w98.toString());
                buff.append("\"");
                OLogger.debug(buff);
                if (m2.find()) {
                    ID = 50;
                    buff = new StringBuffer("   matching pattern \"");
                    buff.append(w98.toString());
                    buff.append("\", setting ID to ");
                    buff.append(ID);
                    OLogger.debug(buff);
                    return ID;
                }
                StringBuffer w215 = new StringBuffer("(.*)(");
                w215.append("Microsoft Windows \\[Version 5");
                w215.append(")(.*)");
                p2 = Pattern.compile(w215.toString());
                m2 = p2.matcher(output);
                buff = new StringBuffer("   checking pattern \"");
                buff.append(w215.toString());
                buff.append("\"");
                OLogger.debug(buff);
                if (m2.find()) {
                    String processor;
                    ID = 215;
                    buff = new StringBuffer("   matching pattern \"");
                    buff.append(w215.toString());
                    buff.append("\", setting ID to ");
                    buff.append(ID);
                    buff.append(" then look for \"ia64\" from system property PROCESSOR_IDENTIFIER...");
                    OLogger.debug(buff);
                    Properties prop = System.getProperties();
                    if (prop != null && (processor = prop.getProperty("PROCESSOR_IDENTIFIER")) != null) {
                        buff = new StringBuffer("     PROCESSOR_IDENTIFIER=");
                        buff.append(processor);
                        OLogger.debug(buff);
                        if (processor.indexOf("ia64") != -1) {
                            ID = 208;
                            buff = new StringBuffer("     setting ID to ");
                            buff.append(ID);
                            OLogger.debug(buff);
                        }
                    }
                    return ID;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ID;
    }

    private static int getHpUX(String osName) {
        int ID = 59;
        String sample1_59 = "HP-UX haha4 B.11.11 U 9000/800";
        String sample2_64 = "HP-UX jphs B.11.22 U ia64 1195119863";
        StringBuffer buff = new StringBuffer("Uname::getHpUX(), default to ");
        buff.append(ID);
        try {
            buff = new StringBuffer("   preparing to invoke \"uname -a\"");
            OLogger.debug(buff);
            String cmd = "uname -a";
            SystemCall.ExecReturn ret = SystemCall.runtimeExec(cmd);
            if (ret.isOK()) {
                String output = ret.getNormalMessage();
                buff = new StringBuffer("   parsing output=\"");
                buff.append(output);
                buff.append("\"");
                OLogger.debug(buff);
                StringBuffer h197 = new StringBuffer("(.*)(");
                h197.append("ia64");
                h197.append(")(.*)");
                Pattern p2 = Pattern.compile(h197.toString());
                Matcher m2 = p2.matcher(output);
                buff = new StringBuffer("   checking pattern \"");
                buff.append(h197.toString());
                buff.append("\"");
                OLogger.debug(buff);
                if (m2.find()) {
                    ID = 197;
                    buff = new StringBuffer("   matching pattern \"");
                    buff.append(h197.toString());
                    buff.append("\", setting ID to ");
                    buff.append(ID);
                    OLogger.debug(buff);
                    return ID;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ID;
    }

    private static int getAix(String osName) {
        int ID = 212;
        StringBuffer buff = new StringBuffer("Uname::getAix(), default to ");
        buff.append(ID);
        OLogger.debug(buff);
        try {
            buff = new StringBuffer("   preparing to run \"uname -v\"");
            OLogger.debug(buff);
            String cmd = "uname -v";
            SystemCall.ExecReturn ret = SystemCall.runtimeExec(cmd);
            if (ret.isOK()) {
                String output = ret.getNormalMessage();
                buff = new StringBuffer("   parsing output=\"");
                buff.append(output);
                buff.append("\"");
                OLogger.debug(buff);
                StringBuffer a38 = new StringBuffer("(.*)(");
                a38.append("4");
                a38.append(")(.*)");
                Pattern p2 = Pattern.compile(a38.toString());
                Matcher m2 = p2.matcher(output);
                buff = new StringBuffer("   checking pattern \"");
                buff.append(a38.toString());
                buff.append("\"");
                OLogger.debug(buff);
                if (m2.find()) {
                    ID = 38;
                    buff = new StringBuffer("   matches pattern \"");
                    buff.append(a38.toString());
                    buff.append("\", setting ID to ");
                    buff.append(ID);
                    OLogger.debug(buff);
                    return ID;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ID;
    }

    private static int getLinux(String osName) {
        String sample1_214 = "Linux rmtdcial1 2.4.18-e.37smp #1 SMP Tue Aug 5 16:54:40 EDT 2003 ia64 unknown";
        String sample2_214 = "Linux pinn.oracle 2.4.21-9.EL #1 SMP Thu Jan 8 16:45:40 EST 2004 ia64 ia64 ia64 GNU/Linux";
        int ID = 46;
        StringBuffer buff = new StringBuffer("Uname::getLinux(), default to 46");
        OLogger.debug(buff);
        try {
            String cmd = "uname -a";
            buff = new StringBuffer("   preparing to call \"uname -a\"");
            OLogger.debug(buff);
            SystemCall.ExecReturn ret = SystemCall.runtimeExec(cmd);
            if (ret.isOK()) {
                buff = new StringBuffer("   called OK, parsing output=\"");
                String output = ret.getNormalMessage();
                buff.append(output);
                buff.append("\"");
                OLogger.debug(buff);
                StringBuffer L211 = new StringBuffer("(.*)(");
                L211.append("390");
                L211.append(")(.*)");
                Pattern linux211 = Pattern.compile(L211.toString());
                StringBuffer L214 = new StringBuffer("(.*)(");
                L214.append("ia64");
                L214.append(")(.*)");
                Pattern linux214 = Pattern.compile(L214.toString());
                StringBuffer L226 = new StringBuffer("(.*)(");
                L226.append("x86_64");
                L226.append(")(.*)");
                Pattern linux226 = Pattern.compile(L226.toString());
                Matcher m2 = linux211.matcher(output);
                buff = new StringBuffer("   checking pattern \"");
                buff.append(L211.toString());
                buff.append("\"");
                OLogger.debug(buff);
                if (m2.find()) {
                    ID = 211;
                    buff = new StringBuffer("   matching pattern \"");
                    buff.append(L211.toString());
                    buff.append("\", set ID to ");
                    buff.append(ID);
                    OLogger.debug(buff);
                    return ID;
                }
                buff = new StringBuffer("   checking pattern \"");
                buff.append(L214.toString());
                buff.append("\"");
                OLogger.debug(buff);
                m2 = linux214.matcher(output);
                if (m2.find()) {
                    ID = 214;
                    buff = new StringBuffer("   matching pattern \"");
                    buff.append(L214.toString());
                    buff.append("\", set ID to ");
                    buff.append(ID);
                    OLogger.debug(buff);
                    return ID;
                }
                buff = new StringBuffer("   checking pattern \"");
                buff.append(L226.toString());
                buff.append("\"");
                OLogger.debug(buff);
                m2 = linux226.matcher(output);
                if (m2.find()) {
                    ID = 226;
                    buff = new StringBuffer("   matching pattern \"");
                    buff.append(L226.toString());
                    buff.append("\", set ID to ");
                    buff.append(ID);
                    OLogger.debug(buff);
                    return ID;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ID;
    }

    private static int getDecOsf(String osName) {
        int ID = 87;
        return ID;
    }

    protected static int getOSID(String osName, String oracleHomePath) {
        StringBuffer buff = new StringBuffer("UName::getOSID() with osName=");
        buff.append(osName);
        OLogger.debug(buff);
        int ID = 0;
        boolean isWindows = OPatchEnv.isWindows();
        if (osName.equalsIgnoreCase("Solaris") || osName.equalsIgnoreCase(SUNOS_OS_NAME)) {
            ID = Uname.getSolaris(osName, oracleHomePath);
        } else if (isWindows) {
            ID = Uname.getWin(osName);
        } else if (osName.equalsIgnoreCase("HP-UX")) {
            ID = Uname.getHpUX(osName);
        } else if (osName.equalsIgnoreCase(AIX_OS_NAME)) {
            ID = Uname.getAix(osName);
        } else if (osName.equalsIgnoreCase("Linux")) {
            ID = Uname.getLinux(osName);
        } else if (osName.equalsIgnoreCase(DIGITAL_UNIX_OS_NAME)) {
            ID = Uname.getDecOsf(osName);
        } else if (osName.equalsIgnoreCase(INTEL_MAC_OS_NAME)) {
            ID = 293;
        }
        return ID;
    }

    protected static int getOSID(String oracleHomePath) {
        String osName = OUIReplacer.Platform.getCurrentPlatformOSName();
        OLogger.debug(new StringBuffer("OS Name is : " + osName));
        if ((osName.equalsIgnoreCase("Solaris") || osName.equalsIgnoreCase(SUNOS_OS_NAME)) && (oracleHomePath == null || oracleHomePath.equals(""))) {
            OLogger.println("Enter path to ORACLE_HOME:");
            oracleHomePath = OPatchEnv.waitForUserInput();
        }
        StringBuffer buff = new StringBuffer("Uname::getOSID() on ");
        buff.append(oracleHomePath);
        OLogger.debug(buff);
        int aruID = Uname.getOSID(osName, oracleHomePath);
        return aruID;
    }

    public static void main(String[] args) {
        String oracleHomePath = "";
        Properties prop = System.getProperties();
        if (prop != null) {
            String debug = prop.getProperty("OPatch.DEBUG");
            OLogger.println("debug = " + debug);
            if (debug != null && debug.equalsIgnoreCase("true")) {
                try {
                    OPatchACL.invokeOLogger(new Uname(), "setDebug", new Object[]{true});
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
        int ID = Uname.getOSID(oracleHomePath);
        OLogger.println("UName() returns " + ID);
    }
}

