/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.LogManager;
import oracle.opatch.Help;
import oracle.opatch.OPatch;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSession;
import oracle.opatch.OneOffEntry;
import oracle.opatch.UtilSession;
import oracle.opatch.ipm.IIPMRWServices;
import oracle.opatch.opatchcommon.opatchpatch.CompositePatch;
import oracle.opatch.opatchcommon.opatchpatch.CpuPatch;
import oracle.opatch.opatchcommon.opatchpatch.OPatchPatch;
import oracle.opatch.opatchcommon.opatchpatch.OneoffPatch;
import oracle.opatch.opatchcommon.opatchpatch.SystemPatch;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.PrereqAPI;
import oracle.opatch.opatchsdk.OPatchPatchFactory;
import oracle.opatch.opatchsdk.patchrepresentation.InvalidPatchPackageException;
import oracle.opatch.opatchsdk.patchrepresentation.PatchType;
import oracle.opatch.opatchsdk.patchrepresentation.PatchVariant;
import oracle.opatch.opatchutil.OUSession;
import oracle.opatch.patchsdk.PatchPackageException;
import oracle.opatch.wrappers.WrapperFactory;

public class UpdateSession
extends OPatchSession
implements Help {
    private List<OPatchPatch> opatchPatchList = new ArrayList<OPatchPatch>();

    UpdateSession(String name, boolean readOnly) {
        super(name, readOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void process(String oracleHomePath) {
        LogManager.getLogManager().reset();
        this.opatchPatchList = this.getSwLibraryPatches(OPatchEnv.getSwLibraryDir());
        if (this.opatchPatchList.isEmpty()) {
            System.out.println("There's no patch to be installed inside the software library directory.");
        } else {
            System.out.println("OPatch is installing the following patches:");
            System.out.println(this.getInputPatchInfo());
        }
        OutputStream fos = null;
        try {
            fos = Files.newOutputStream(WrapperFactory.getNioServiceWrapper().getPath(OPatchEnv.getLogFileNameAndLocation(OPatchEnv.getOracleHome()), new String[0]), new OpenOption[0]);
        }
        catch (NoSuchElementException e2) {
            OLogger.debug(e2.getMessage());
        }
        catch (IOException e3) {
            OLogger.debug(e3.getMessage());
        }
        Iterator<OPatchPatch> iterator = this.opatchPatchList.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.printMessageAndExit();
                return;
            }
            OPatchPatch patch = iterator.next();
            if (fos != null) {
                System.setOut(new PrintStream(fos));
            }
            System.out.println("\nPatch(es) to be processed: " + patch.getPatchLoc());
            try {
                patch.setLogFileStream(fos);
                patch.install();
                continue;
            }
            catch (Exception rwServices) {
                continue;
            }
            catch (Error rwServices) {
                continue;
            }
            catch (Throwable rwServices) {
                continue;
            }
            finally {
                OPatchEnv.setPatchloc("");
                OUSession.resetPHBaseDir();
                try {
                    IIPMRWServices rwServices = UtilSession.getRWServices(oracleHomePath);
                    if (!rwServices.isLocked() || oracleHomePath == null) continue;
                    rwServices.release();
                }
                catch (Throwable rwServices) {}
                continue;
            }
            break;
        }
    }

    private void printMessageAndExit() {
        Set<String> installedPatchIDs = this.getInstalledPatchIDs();
        if (installedPatchIDs == null) {
            System.out.println("\nError occurred during software library update.");
            System.out.println("Please refer to the log files for details.");
            OPatch.exit(1);
        }
        boolean isAllPatchInHome = true;
        StringBuilder sb = new StringBuilder();
        for (OPatchPatch opatchPatch : this.opatchPatchList) {
            if (opatchPatch.isPatchInHome(installedPatchIDs)) continue;
            isAllPatchInHome = false;
            sb.append(opatchPatch.getUnsuccessPatchInfo());
        }
        if (isAllPatchInHome) {
            System.out.println("\nZOP-1000");
            OPatch.exit(0);
        } else {
            System.out.println("\nZOP-1002: " + sb.toString());
            OPatch.exit(1);
        }
    }

    public List<OPatchPatch> getSwLibraryPatches(String swLibraryDir) {
        try (DirectoryStream<Path> swLibraryFiles2 = Files.newDirectoryStream(WrapperFactory.getNioServiceWrapper().getPath(swLibraryDir, new String[0]));){
            for (Path f2 : swLibraryFiles2) {
                OPatchPatch opatchPatch;
                if (!Files.isDirectory(f2, new LinkOption[0]) || !Files.isReadable(f2)) continue;
                PatchVariant pv = OPatchPatchFactory.getPatchInstance((String)f2.toAbsolutePath().toString());
                if (pv == null) {
                    List<PatchVariant> subPatchVariants = null;
                    try {
                        subPatchVariants = this.getValidSingletonVariant(Files.newDirectoryStream(f2));
                        if (subPatchVariants.size() <= 0) continue;
                        CpuPatch cpuPatch = new CpuPatch();
                        cpuPatch.setPatchVariants(subPatchVariants);
                        cpuPatch.setPatchLoc(f2.toAbsolutePath().toString());
                        for (PatchVariant spv : subPatchVariants) {
                            cpuPatch.addPatchUnitId(spv.getPatchID());
                        }
                        cpuPatch.setPatchId(null);
                        this.opatchPatchList.add(cpuPatch);
                    }
                    catch (IOException e2) {
                        OLogger.debug(e2.getMessage());
                    }
                    continue;
                }
                PatchType pt = pv.getPatchType();
                switch (pt) {
                    case COMPOSITE: {
                        opatchPatch = new CompositePatch();
                        opatchPatch.setPatchVariants(Arrays.asList(pv));
                        opatchPatch.addPatchUnitId(pv.getPatchID());
                        break;
                    }
                    case SINGLETON: {
                        opatchPatch = new OneoffPatch();
                        opatchPatch.setPatchVariants(Arrays.asList(pv));
                        opatchPatch.addPatchUnitId(pv.getPatchID());
                        break;
                    }
                    case ENGSYSTEM: {
                        opatchPatch = new SystemPatch();
                        List<PatchVariant> subPatchVariants = null;
                        try {
                            PatchVariant spv;
                            subPatchVariants = this.getValidSingletonVariant(Files.newDirectoryStream(f2));
                            spv = subPatchVariants.iterator();
                            while (spv.hasNext()) {
                                PatchVariant spv2 = spv.next();
                                opatchPatch.addPatchUnitId(spv2.getPatchID());
                            }
                            opatchPatch.setPatchVariants(subPatchVariants);
                        }
                        catch (IOException e3) {
                            e3.printStackTrace();
                        }
                        break;
                    }
                    default: {
                        opatchPatch = null;
                    }
                }
                opatchPatch.setPatchLoc(f2.toAbsolutePath().toString());
                opatchPatch.setPatchId(pv.getPatchID());
                this.opatchPatchList.add(opatchPatch);
            }
        }
        catch (PatchPackageException swLibraryFiles2) {
        }
        catch (InvalidPatchPackageException swLibraryFiles2) {
        }
        catch (IOException e1) {
            OLogger.debug(e1.getMessage());
        }
        return this.opatchPatchList;
    }

    private List<PatchVariant> getValidSingletonVariant(DirectoryStream<Path> systemSubDirs) {
        ArrayList<PatchVariant> res = new ArrayList<PatchVariant>();
        for (Path subDir : systemSubDirs) {
            try {
                PatchVariant subPv = OPatchPatchFactory.getPatchInstance((String)subDir.toAbsolutePath().toString());
                if (subPv == null || subPv.getPatchType() != PatchType.SINGLETON) continue;
                res.add(subPv);
            }
            catch (PatchPackageException patchPackageException) {
            }
            catch (InvalidPatchPackageException invalidPatchPackageException) {}
        }
        return res;
    }

    private String getInputPatchInfo() {
        StringBuilder sb = new StringBuilder();
        for (OPatchPatch opatchPatch : this.opatchPatchList) {
            sb.append(opatchPatch.getPatchInfo());
        }
        return sb.toString();
    }

    private Set<String> getInstalledPatchIDs() {
        OneOffEntry[] oneOffs = null;
        try {
            oneOffs = PrereqAPI.getInstalledOneOff(OPatchEnv.getOracleHome());
        }
        catch (Throwable e2) {
            return null;
        }
        HashSet<String> res = new HashSet<String>();
        for (OneOffEntry oneoff : oneOffs) {
            res.add(oneoff.getID());
        }
        return res;
    }
}

