/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedReader;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchObject;
import oracle.opatch.wrappers.WrapperFactory;

public class XMLConverter {
    private static String[] s_quot = new String[]{"&quot;", "\""};
    private static String[] s_amp = new String[]{"&amp;", "&"};
    private static String[] s_lt = new String[]{"&lt;", "<"};
    private static String[] s_gt = new String[]{"&gt;", ">"};
    private static String[] s_apos = new String[]{"&apos;", "'"};
    private static String[] s_ldquo = new String[]{"&ldquo;", "\u201c"};
    private static String[] s_rdquo = new String[]{"&rdquo;", "\u201d"};
    private static String[][] xmlSpecialStrings = new String[][]{s_amp, s_quot, s_lt, s_gt, s_apos, s_ldquo, s_rdquo};
    private static String fileSeparator = File.separator;
    private static HashMap<Character, String> specialStringsMap = new HashMap();

    protected static String getXMLString(String s) {
        StringBuilder result = new StringBuilder(s.length() + 256);
        for (int i2 = 0; i2 < s.length(); ++i2) {
            Character c2 = Character.valueOf(s.charAt(i2));
            String replacement = specialStringsMap.get(c2);
            if (replacement != null) {
                result.append(replacement);
                continue;
            }
            result.append(c2);
        }
        return result.toString();
    }

    public static void main(String[] args) {
        String patchLoc = "U:\\OPatch\\Code\\Rewrite\\Patches";
        patchLoc = patchLoc + "\\1313986_test";
        String makeFile = "U:\\tmp\\make.txt";
        try {
            PatchObject patchObject = PatchObject.getInstance(patchLoc);
            String src = patchLoc + fileSeparator + "etc" + fileSeparator + "config" + fileSeparator + "actions";
            Path srcFile = WrapperFactory.getNioServiceWrapper().getPath(src, new String[0]);
            BufferedReader fr = Files.newBufferedReader(srcFile, Charset.forName("UTF-8"));
            BufferedReader br = new BufferedReader(fr);
            String[] rawActionEntry = patchObject.getRawActionEntry();
            String beginOneoff = rawActionEntry[0];
            String endOneoff = rawActionEntry[1];
            PatchComponent[] incComponents = patchObject.getIncludedPatchComponents();
            for (int i2 = 0; i2 < incComponents.length; ++i2) {
                PatchComponent incComponent = incComponents[i2];
                PatchAction[] appliedActions = patchObject.getPatchActionsForComponent(incComponent);
                String[] rawCmpEntry = incComponent.getRawActionEntry();
                String beginComp = "";
                String endComp = "";
                if (rawCmpEntry == null || rawCmpEntry[0] == null || rawCmpEntry[1] == null) continue;
                beginComp = rawCmpEntry[0];
                endComp = rawCmpEntry[1];
                for (int j2 = 0; j2 < appliedActions.length; ++j2) {
                    PatchAction action = appliedActions[j2];
                    String rawEntry = action.getRawActionEntry();
                    System.out.println(rawEntry);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        for (int i2 = 0; i2 < xmlSpecialStrings.length; ++i2) {
            String beReplaced = xmlSpecialStrings[i2][1];
            String replacement = xmlSpecialStrings[i2][0];
            specialStringsMap.put(Character.valueOf(beReplaced.charAt(0)), replacement);
        }
    }
}

