/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.cas;

import java.nio.file.Path;
import java.util.Map;
import oracle.opatch.OPatchEnv;
import oracle.opatch.cas.OPatchCASException;
import oracle.opatch.cas.OPatchPatchKey;
import oracle.opatch.cas.client.CASClientFactory;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.util.perfmonitor.MethodTracker;
import oracle.opatch.util.perfmonitor.MethodTrackerObj;
import oracle.opatch.util.perfmonitor.TrackerTags;
import oracle.opatch.wrappers.WrapperFactory;

public class CASFileServices {
    private String ohPath;

    public void initialize(String oh) {
        this.initialize(oh, false);
    }

    public void initialize(String oh, boolean isCasDirectlyPatching) {
        try {
            this.ohPath = WrapperFactory.getNioServiceWrapper().getPath(oh, new String[0]).toString();
            Path customLogPath = null;
            String customLogDir = OPatchEnv.getCustomLogDir();
            if (customLogDir != null && !customLogDir.equals("")) {
                customLogPath = WrapperFactory.getNioServiceWrapper().getPath(customLogDir, new String[0]).resolve("opatch-cas");
            }
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Loading CAS libraries");
            if (!isCasDirectlyPatching) {
                boolean isDBHome = OPatchEnv.isDBHome(oh);
                if (isDBHome) {
                    OLogger.justlog(OLogger.INFO, "Recording Root ownership for DB home");
                    if (OPatchEnv.isFullDBCasRepo()) {
                        OLogger.justlog(OLogger.INFO, "CAS File Service for DB home not supported ");
                    } else {
                        OLogger.justlog(OLogger.INFO, " CAS File Service for DB home not supported");
                    }
                } else {
                    CASClientFactory.getCASClient().initializeCASService(this.ohPath, ".cas", customLogPath);
                }
            } else {
                CASClientFactory.getCASClient().initializeCASService(this.ohPath, ".cas", customLogPath);
            }
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS library loaded");
        }
        catch (Throwable t) {
            OLogger.println("Failed to initialize OPatch/CAS (.cas). OPatch cannot proceed.\n");
            OLogger.printStackTrace(t);
            RuntimeException re = new RuntimeException(t.getMessage());
            throw re;
        }
    }

    public void cleanup() {
        try {
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - data store cleanup started");
            CASClientFactory.getCASClient().cleanupCASService();
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - data store cleanup completed");
        }
        catch (Throwable t) {
            OLogger.println("Failed to clean up CAS store. OPatch cannot proceed.\n");
            OLogger.printStackTrace(t);
            RuntimeException re = new RuntimeException(t.getMessage());
            throw re;
        }
    }

    public void build() throws Throwable {
        MethodTrackerObj trackerObj = MethodTracker.getTracker(TrackerTags.INITIALIZE_CAS);
        trackerObj.start();
        try {
            CASClientFactory.getCASClient().buildCASStore();
        }
        finally {
            trackerObj.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(String shadowDir, Map<Path, String> copy, Map<Path, String> hardlink) {
        MethodTrackerObj trackerObj = MethodTracker.getTracker(TrackerTags.CAS_CREATING_SHADOW_BRANCH);
        trackerObj.start();
        String branchKey = OPatchEnv.getBranchKey();
        try {
            CASClientFactory.getCASClient().createShadowOH(shadowDir, branchKey, copy, hardlink);
        }
        catch (OPatchCASException e2) {
            e2.printStackTrace();
        }
        finally {
            trackerObj.end();
        }
    }

    public void destroy() throws OPatchCASException {
        MethodTrackerObj trackerObj = MethodTracker.getTracker(TrackerTags.CAS_DESTROYING_SHADOW_BRANCH);
        trackerObj.start();
        String branchKey = OPatchEnv.getBranchKey();
        try {
            CASClientFactory.getCASClient().destroyShadowOH(branchKey, false);
        }
        finally {
            trackerObj.end();
        }
    }

    public void begin(OPatchPatchKey opKey) {
        MethodTrackerObj trackerObj = MethodTracker.getTracker(TrackerTags.CAS_APPLYING_PATCH_TO_SH);
        trackerObj.start();
        String branchKey = OPatchEnv.getBranchKey();
        try {
            CASClientFactory.getCASClient().beginPatchBranch(branchKey, opKey.getKey());
        }
        catch (Throwable t) {
            OLogger.println("Failed to begin the patch transaction to shadow home. OPatch cannot proceed.\n");
            OLogger.printStackTrace(t);
            RuntimeException re = new RuntimeException(t.getMessage());
            throw re;
        }
        finally {
            trackerObj.end();
        }
    }

    public void end(OPatchPatchKey opKey, Map<Path, String> remove, boolean endSession) {
        MethodTrackerObj trackerObj = MethodTracker.getTracker(TrackerTags.CAS_COMMITTING_PATCH_TO_SH);
        trackerObj.start();
        try {
            CASClientFactory.getCASClient().endPatchBranch(opKey.getKey(), remove, endSession);
        }
        catch (Throwable t) {
            OLogger.println("Failed to end the patch transaction to shadow home. OPatch cannot proceed.\n");
            OLogger.printStackTrace(t);
            RuntimeException re = new RuntimeException(t.getMessage());
            throw re;
        }
        finally {
            trackerObj.end();
        }
    }
}

