/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.conflicttextualinterpreter.cbcc;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import oracle.opatch.PatchObject;
import oracle.opatch.conflicttextualinterpreter.ConflictMapBuilder;
import oracle.opatch.conflicttextualinterpreter.Patch;
import oracle.opatch.conflicttextualinterpreter.cbcc.Cbcc;
import oracle.opatch.conflicttextualinterpreter.cbcc.CbccException;
import oracle.opatch.conflicttextualinterpreter.cbcc.CbccNoOpException;
import oracle.opatch.conflicttextualinterpreter.cbcc.CbccPatch;
import oracle.opatch.conflicttextualinterpreter.cbcc.CbccPatchImpl;
import oracle.opatch.conflicttextualinterpreter.cbcc.CbccResult;
import oracle.opatch.conflicttextualinterpreter.cbcc.CbccResultImpl;
import oracle.opatch.conflicttextualinterpreter.cbcc.FileMapping;
import oracle.opatch.opatchlogger.OLogger;

public class CbccEngine
implements Cbcc {
    private static CbccEngine engine = null;
    private CbccResult result = new CbccResultImpl();

    public static CbccEngine getInstance() {
        if (engine == null) {
            engine = new CbccEngine(null);
        }
        return engine;
    }

    private CbccEngine(ConflictMapBuilder conflictMapBuilder) {
    }

    @Override
    public boolean checkCbccPatch(CbccPatch patch) {
        return patch != null && patch.isCbccEnabled();
    }

    @Override
    public boolean checkCbccPatches(List<CbccPatch> patches) {
        for (CbccPatch patch : patches) {
            if (this.checkCbccPatch(patch)) continue;
            return false;
        }
        OLogger.debug("Patches are cbcc-enabled.");
        return true;
    }

    public boolean checkCbccPatch(String filename, CbccPatch patch) {
        if (patch != null && !patch.isCbccEnabled()) {
            return false;
        }
        FileMapping fileMap = patch.getFilesMap();
        return fileMap.hasFile(filename);
    }

    public boolean checkCbccPatches(String filename, List<CbccPatch> patches) {
        for (CbccPatch patch : patches) {
            if (this.checkCbccPatch(filename, patch)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean checkSameContent(String filename, CbccPatch p1, CbccPatch p2) {
        OLogger.debug("CheckSameContent() - file: " + filename + " in Patch (" + p1.getPatchId() + ") and (" + p2.getPatchId() + ")");
        String checksumInP1 = p1.getChecksum(filename);
        String checksumInP2 = p2.getChecksum(filename);
        if (checksumInP1 == null || checksumInP2 == null) {
            OLogger.debug("Null checksum: " + checksumInP1 + ", " + checksumInP2);
            return false;
        }
        if (checksumInP1.compareTo(checksumInP2) == 0) {
            OLogger.debug("same content: " + checksumInP1);
            return true;
        }
        OLogger.debug("Different content: " + checksumInP1 + " != " + checksumInP2);
        return false;
    }

    @Override
    public boolean checkSameFileSet(String filename, CbccPatch p1, CbccPatch p2) throws CbccException {
        OLogger.debug("checkSameFileSet() - file: " + filename + " in Patch (" + p1.getPatchId() + ") and (" + p2.getPatchId() + ")");
        ArrayList<String> p1Bugs = new ArrayList<String>(p1.getBugs(filename));
        ArrayList<String> p2Bugs = new ArrayList<String>(p2.getBugs(filename));
        p1Bugs.retainAll(p2Bugs);
        if (p1Bugs.isEmpty()) {
            OLogger.debug("No same bug in patches.");
            throw new CbccNoOpException("Different Bugs. No-op");
        }
        for (String bug : p1Bugs) {
            Set<String> fileSet = p1.getFilesMap().getUnresolvedSymbolFiles(bug);
            try {
                if (!p2.hasSameFileSet(bug, fileSet)) {
                    OLogger.debug("Not same fileset for bug (" + bug + ")");
                    return false;
                }
                OLogger.debug("Bug (" + bug + ") in patches has same fileset.");
            }
            catch (CbccException e2) {
                OLogger.debug(e2.getMessage());
                OLogger.debug("No same bug in patches.");
                throw new CbccException("No-op");
            }
        }
        return true;
    }

    @Override
    public boolean hasCbccResolved(String filename) {
        try {
            return this.result.hasResolvedSameFile(filename);
        }
        catch (CbccException e2) {
            OLogger.debug(e2.getMessage());
            return false;
        }
    }

    @Override
    public CbccResult getResult() {
        return this.result;
    }

    public void resolve(String commonFile, CbccPatch cbccP1, CbccPatch cbccP2) throws CbccException {
        OLogger.justlog(OLogger.INFO, "Common File: " + commonFile + ", in patch (" + cbccP1.getPatchId() + ") and (" + cbccP2.getPatchId() + ")");
        ArrayList<CbccPatch> patches = new ArrayList<CbccPatch>();
        patches.add(cbccP1);
        patches.add(cbccP2);
        boolean allCbccPatches = this.checkCbccPatches(patches);
        if (!allCbccPatches) {
            OLogger.justlog(OLogger.INFO, "Not all patches are cbcc enabled");
            throw new CbccException("Not all patches are cbcc enabled");
        }
        boolean sameContent = this.checkSameContent(commonFile, cbccP1, cbccP2);
        if (!sameContent) {
            OLogger.justlog(OLogger.INFO, "Not same content file");
            throw new CbccException("Not same content file");
        }
        try {
            boolean sameFileset = this.checkSameFileSet(commonFile, cbccP1, cbccP2);
            if (!sameFileset) {
                OLogger.debug("Bugs have different files set");
                throw new CbccException("Bugs have different files set");
            }
        }
        catch (CbccNoOpException sameFileset) {
        }
        catch (CbccException ex) {
            throw ex;
        }
        this.result.add(cbccP1.getPatch().getOneOffEntry().getPatchObject(), commonFile);
        this.result.add(cbccP2.getPatch().getOneOffEntry().getPatchObject(), commonFile);
        OLogger.justlog(OLogger.INFO, this.result.toString());
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Require:  <abs-path-oracle-home>  <abs-path-patch-location");
            System.exit(0);
        }
        String oracleHomePath = args[0];
        String patchLocation = args[1];
        boolean inOH = false;
        try {
            PatchObject patchObj = PatchObject.getInstance(patchLocation);
            Patch patch = new Patch(patchObj.toOneOffEntry(oracleHomePath), inOH);
            CbccPatchImpl cbccPatch = new CbccPatchImpl(patch);
            System.out.println("CBCC Patch: " + ((Object)cbccPatch).toString());
        }
        catch (IllegalAccessException e2) {
            e2.printStackTrace();
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
    }
}

