/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.conflicttextualinterpreter.selectbetterpatch;

import java.util.ArrayList;
import java.util.HashMap;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OneOffEntry;
import oracle.opatch.conflicttextualinterpreter.selectbetterpatch.ISelectBetterPatchEngine;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.ICheckPatchPrereqEngine;

public class SelectBetterPatchOneOffEngine
implements ISelectBetterPatchEngine {
    @Override
    public OneOffEntry selectBetterPatchAmongPatches(OneOffEntry[] pIs) throws Throwable {
        StringBuffer buff = new StringBuffer("SelectBetterPatchEngine:SelectBetterPatchAmongPatches");
        OLogger.debug(buff);
        buff.setLength(0);
        if (pIs == null || pIs.length == 0) {
            String msg = "Empty List of incoming patches.";
            buff.append(msg);
            return null;
        }
        String[] upis = new String[pIs.length];
        for (int i2 = 0; i2 < pIs.length; ++i2) {
            upis[i2] = pIs[i2].getPSENumber();
        }
        int bestPtr = this.getBiggestUPI(upis);
        if (bestPtr != -1) {
            OneOffEntry best = pIs[bestPtr];
            buff.append("Best patch is: [ ");
            buff.append(pIs[bestPtr].getID()).append(" ].\n");
            buff.append("Its UPI/Temp UPI is: ");
            buff.append(upis[bestPtr]).append(". ");
            OLogger.debug(buff);
            return best;
        }
        return null;
    }

    @Override
    public ICheckPatchPrereqEngine.Result selectBetterPatchAgainstOh(OneOffEntry poh, OneOffEntry pi, HashMap<ICheckPatchPrereqEngine.Result, ArrayList<OneOffEntry>> res) {
        StringBuffer buff = new StringBuffer("SelectBetterPatchEngine:selectBetterPatchAgainstOh");
        String uidPi = this.norm(pi.getPSENumber());
        String idPi = this.norm(pi.getID());
        ICheckPatchPrereqEngine.Result result = ICheckPatchPrereqEngine.Result.DIFF;
        OLogger.debug(buff);
        if (poh == null) {
            buff.setLength(0);
            if (!OPatchEnv.getSessionType().equalsIgnoreCase("prereq")) {
                OLogger.debug(buff.append("PREREQ_CHECK_NO_DUPLICATE_PATCH_FOUND_IN_OH [PASS] Pi [").append(idPi).append("]"));
            } else {
                OLogger.debug(buff.append("PREREQ_CHECK_NO_IDENTICAL_PATCH_FOUND_IN_OH [PASS] Pi [").append(idPi).append("]"));
            }
            res.get((Object)ICheckPatchPrereqEngine.Result.DIFF).add(pi);
        } else {
            String uidPoh = this.norm(poh.getPSENumber());
            if (uidPi.equals(uidPoh) && !"".equals(uidPi)) {
                if (!pi.isOnlinePatch() && poh.isOnlinePatch()) {
                    res.get((Object)ICheckPatchPrereqEngine.Result.BETTER).add(pi);
                    result = ICheckPatchPrereqEngine.Result.BETTER;
                } else {
                    buff.setLength(0);
                    if (!OPatchEnv.getSessionType().equalsIgnoreCase("prereq")) {
                        OLogger.debug(buff.append("PREREQ_CHECK_DUPLICATE_PATCH_FOUND_IN_OH [WARN] Pi [").append(idPi).append("]\n").append("PI_IS_SAME_AS_POH"));
                    } else {
                        OLogger.debug(buff.append("PREREQ_CHECK_IDENTICAL_PATCH_FOUND_IN_OH [WARN] Pi [").append(idPi).append("]\n").append("PI_IS_SAME_AS_POH"));
                    }
                    res.get((Object)ICheckPatchPrereqEngine.Result.SAME).add(pi);
                    result = ICheckPatchPrereqEngine.Result.SAME;
                }
            } else if (this.compareUPI(uidPoh, uidPi) > 0L) {
                buff.setLength(0);
                if (!OPatchEnv.getSessionType().equalsIgnoreCase("prereq")) {
                    OLogger.debug(buff.append("PREREQ_CHECK_DUPLICATE_PATCH_FOUND_IN_OH [EXIT] Pi [").append(idPi).append("]\n").append("PI_IS_WORSE_THAN_POH"));
                } else {
                    OLogger.debug(buff.append("PREREQ_CHECK_IDENTICAL_PATCH_FOUND_IN_OH [EXIT] Pi [").append(idPi).append("]\n").append("PI_IS_WORSE_THAN_POH"));
                }
                res.get((Object)ICheckPatchPrereqEngine.Result.WORSE).add(pi);
                result = ICheckPatchPrereqEngine.Result.WORSE;
            } else if (this.compareUPI(uidPoh, uidPi) < 0L) {
                buff.setLength(0);
                if (!OPatchEnv.getSessionType().equalsIgnoreCase("prereq")) {
                    OLogger.debug(buff.append("PREREQ_CHECK_DUPLICATE_PATCH_FOUND_IN_OH [WARN] Pi [").append(idPi).append("]\n").append("PI_IS_BETTER_THAN_POH"));
                } else {
                    OLogger.debug(buff.append("PREREQ_CHECK_IDENTICAL_PATCH_FOUND_IN_OH [WARN] Pi [").append(idPi).append("]\n").append("PI_IS_BETTER_THAN_POH"));
                }
                res.get((Object)ICheckPatchPrereqEngine.Result.BETTER).add(pi);
                result = ICheckPatchPrereqEngine.Result.BETTER;
            }
        }
        return result;
    }

    private int getBiggestUPI(String[] upis) {
        int i2;
        if (upis == null || upis.length == 0) {
            return -1;
        }
        boolean noUPI = true;
        long[] upiLongs = new long[upis.length];
        for (i2 = 0; i2 < upis.length; ++i2) {
            upiLongs[i2] = Long.parseLong(upis[i2]);
            if (upiLongs[i2] <= 0L) continue;
            noUPI = false;
        }
        if (noUPI) {
            for (i2 = 0; i2 < upiLongs.length; ++i2) {
                upiLongs[i2] = upiLongs[i2] * -1L;
            }
        }
        long max = upiLongs[0];
        int maxPtr = 0;
        for (int i3 = 1; i3 < upiLongs.length; ++i3) {
            long cur = upiLongs[i3];
            if (cur <= max) continue;
            max = cur;
            maxPtr = i3;
        }
        return maxPtr;
    }

    private long compareUPI(String upi1, String upi2) {
        long u1 = Long.parseLong(upi1);
        long u2 = Long.parseLong(upi2);
        if (u1 < 0L && u2 < 0L) {
            u1 *= -1L;
            u2 *= -1L;
        }
        return u1 - u2;
    }

    private String norm(String s) {
        return s == null ? "" : s.trim();
    }
}

