/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.cup;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.glcm.opatch.common.api.ComponentCheckResult;
import oracle.glcm.opatch.common.api.Patch;
import oracle.glcm.opatch.common.api.PatchCheckResults;
import oracle.glcm.opatch.common.api.PatchInventory;
import oracle.glcm.opatch.common.api.PatchSubType;
import oracle.glcm.opatch.common.api.install.ComponentInfo;
import oracle.glcm.opatch.common.api.install.HomeOperationsException;
import oracle.glcm.opatch.common.api.install.HomeOperationsExt;
import oracle.glcm.opatch.common.api.install.InventoryComponentInfo;
import oracle.glcm.opatch.common.api.install.PatchComponentInfo;
import oracle.glcm.opatch.common.api.install.PatchInfo;
import oracle.opatch.OPatchEnv;
import oracle.opatch.PatchObject;
import oracle.opatch.cup.CUPFileHandler;
import oracle.opatch.cup.CUPPatchComponent;
import oracle.opatch.cup.UninstallValidation;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.wrappers.PatchComponentInfoWrapper;

public class CUPAdapter {
    protected static Map<String, Set<InventoryComponentInfo>> inventoryComponents = new HashMap<String, Set<InventoryComponentInfo>>();
    protected static Map<PatchObject, List<CUPPatchComponent>> cupComponentMap = new HashMap<PatchObject, List<CUPPatchComponent>>();
    protected static Map<String, Map<String, List<InventoryComponentInfo>>> rollbackInventoryComponents = new HashMap<String, Map<String, List<InventoryComponentInfo>>>();
    HomeOperationsExt homeOp = null;
    PatchObject patchObj = null;
    Set<ComponentInfo> compsInfoInInventoryApply = null;
    Set<InventoryComponentInfo> compsInfoInInventoryApply2 = null;
    Map<String, List<ComponentInfo>> compsInfoInInventoryRollback = null;
    Map<String, List<InventoryComponentInfo>> compsInfoInInventoryRollback2 = null;

    public CUPAdapter(PatchObject patchObj) {
        this.patchObj = patchObj;
    }

    public CUPAdapter(HomeOperationsExt homeOp, PatchObject patchObj) {
        this.homeOp = homeOp;
        this.patchObj = patchObj;
    }

    public List<CUPPatchComponent> getCUPPatchComponentList() {
        if (OPatchEnv.isCUP2Supported()) {
            if (cupComponentMap.containsKey(this.patchObj)) {
                return cupComponentMap.get(this.patchObj);
            }
            CUPFileHandler cupFileHandler = new CUPFileHandler();
            List<CUPPatchComponent> cupCompList = cupFileHandler.getCUPPatchComponentList(this.patchObj);
            cupComponentMap.put(this.patchObj, cupCompList);
            return cupCompList;
        }
        return new ArrayList<CUPPatchComponent>();
    }

    public Set<ComponentInfo> getApplyInventoryComponents(Set<PatchComponentInfoWrapper> patchComponents) throws HomeOperationsException {
        if (OPatchEnv.isCUP2Supported()) {
            HashSet<PatchComponentInfo> patchCompInfos = new HashSet<PatchComponentInfo>(patchComponents.size());
            for (PatchComponentInfoWrapper patchCompInfo : patchComponents) {
                patchCompInfos.add(patchCompInfo.getPatchComponentInfo());
            }
            String patchUPI = this.patchObj.getPatchUniqID();
            String cacheKey = patchUPI + "_" + this.patchObj.getPatchID();
            if (inventoryComponents.containsKey(cacheKey)) {
                this.compsInfoInInventoryApply2 = inventoryComponents.get(cacheKey);
                OLogger.justlog(OLogger.INFO, "Just got inventory component info from cache for apply.");
            } else {
                OLogger.justlog(OLogger.INFO, "Before calling NG api HomeOperations.getApplyInventoryComponents()");
                this.compsInfoInInventoryApply2 = this.homeOp.getApplyInventoryComponents(patchUPI, patchCompInfos);
                inventoryComponents.put(cacheKey, this.compsInfoInInventoryApply2);
                OLogger.justlog(OLogger.INFO, "After Calling NG api HomeOperations.getApplyInventoryComponents()");
            }
            this.compsInfoInInventoryApply = new HashSet<ComponentInfo>();
            for (InventoryComponentInfo compInfo : this.compsInfoInInventoryApply2) {
                this.compsInfoInInventoryApply.add((ComponentInfo)compInfo);
                OLogger.justlog(OLogger.INFO, "getApplyInventoryComponents():comp name:" + compInfo.getName());
            }
        } else {
            HashSet<PatchComponentInfo> compInfos = new HashSet<PatchComponentInfo>(patchComponents.size());
            for (PatchComponentInfoWrapper patchCompInfo : patchComponents) {
                compInfos.add(patchCompInfo.getPatchComponentInfo());
            }
            this.compsInfoInInventoryApply = this.homeOp.getPatchComponentsInOHForApply(compInfos);
        }
        return this.compsInfoInInventoryApply;
    }

    public Map<String, List<ComponentInfo>> getRollbackInventoryComponents() throws HomeOperationsException {
        String patchUPI = this.patchObj.getPatchUniqID();
        String cacheKey = patchUPI + "_" + this.patchObj.getPatchID();
        if (OPatchEnv.isCUP2Supported()) {
            if (rollbackInventoryComponents.containsKey(cacheKey)) {
                this.compsInfoInInventoryRollback2 = rollbackInventoryComponents.get(cacheKey);
                OLogger.justlog(OLogger.INFO, "Just got rollback inventory component info from cache for rollback.");
            } else {
                OLogger.justlog(OLogger.INFO, "Before calling NG api homeOp.getRollbackInventoryComponents()");
                try {
                    this.compsInfoInInventoryRollback2 = this.homeOp.getRollbackInventoryComponents(Arrays.asList(patchUPI));
                }
                catch (HomeOperationsException e2) {
                    StringWriter errors = new StringWriter();
                    e2.printStackTrace(new PrintWriter(errors));
                    OLogger.justlog(OLogger.SEVERE, errors.toString());
                    throw e2;
                }
                rollbackInventoryComponents.put(cacheKey, this.compsInfoInInventoryRollback2);
                OLogger.justlog(OLogger.INFO, "After calling NG api homeOp.getRollbackInventoryComponents()");
            }
            this.compsInfoInInventoryRollback = new HashMap<String, List<ComponentInfo>>();
            for (Map.Entry<String, List<InventoryComponentInfo>> entry : this.compsInfoInInventoryRollback2.entrySet()) {
                String akey = entry.getKey();
                List<InventoryComponentInfo> iCIList = entry.getValue();
                ArrayList<InventoryComponentInfo> compInfoList = new ArrayList<InventoryComponentInfo>();
                for (InventoryComponentInfo iCI : iCIList) {
                    compInfoList.add(iCI);
                    OLogger.justlog(OLogger.INFO, "getRollbackInventoryComponents(), comp name: " + iCI.getName());
                }
                this.compsInfoInInventoryRollback.put(akey, compInfoList);
            }
        } else {
            this.compsInfoInInventoryRollback = this.homeOp.getPatchComponentsInOHForRollback(Arrays.asList(patchUPI));
        }
        return this.compsInfoInInventoryRollback;
    }

    public PatchInfo createPatchInfoObj(PatchInfo.Builder builder, Map<String, ComponentCheckResult> tempMapResults) {
        PatchInfo patchInfoObj = null;
        if (OPatchEnv.isCUP2Supported()) {
            Date date = this.patchObj.getOneOffEntryObj().getAppliedDate();
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            ArrayList invComponents = null;
            String cacheKey = this.patchObj.getPatchUniqID() + "_" + this.patchObj.getPatchID();
            if (inventoryComponents.containsKey(cacheKey)) {
                invComponents = new ArrayList(inventoryComponents.get(cacheKey));
                OLogger.justlog(OLogger.INFO, "PatchInfoObj: inventotyComponentInfo list: " + invComponents);
                for (InventoryComponentInfo invComp : invComponents) {
                    String key = invComp.getName() + invComp.getVersion();
                    if (!tempMapResults.containsKey(key)) continue;
                    invComp.setComponentCheckResult(tempMapResults.get(key));
                    CUPPatchComponent.addBackupFiles(cupComponentMap.get(this.patchObj), invComp);
                    CUPPatchComponent.addAffectedFiles(cupComponentMap.get(this.patchObj), invComp);
                }
            }
            patchInfoObj = builder.appliedDate(cal).inventoryComponents(invComponents).build();
        }
        return patchInfoObj;
    }

    private ComponentCheckResult checkResultForCUP2(Patch patch, PatchCheckResults results, Set<InventoryComponentInfo> compsInfoInInventory, boolean isApply) {
        ComponentCheckResult metaDataCheckResult = null;
        if (!OPatchEnv.isCUP2Supported() || !patch.getPatchSubType().equals((Object)PatchSubType.UPGRADE)) {
            return metaDataCheckResult;
        }
        ArrayList<PatchInventory.Component> uninstallComponentList = new ArrayList<PatchInventory.Component>();
        for (InventoryComponentInfo newInvComponentInfo : compsInfoInInventory) {
            InventoryComponentInfo.Action type = newInvComponentInfo.getAction();
            if (!this.isUninstallComponent(type, isApply)) continue;
            uninstallComponentList.add(newInvComponentInfo.getComponentCheckResult().getComponent());
        }
        UninstallValidation validation = UninstallValidation.createInstance(uninstallComponentList);
        for (InventoryComponentInfo newInvComponentInfo : compsInfoInInventory) {
            InventoryComponentInfo.Action type = newInvComponentInfo.getAction();
            ComponentCheckResult resultFromOUI = newInvComponentInfo.getComponentCheckResult();
            ComponentCheckResult result = null;
            boolean isInstall = false;
            if ("oracle.nextgen.metadata".equals(newInvComponentInfo.getName())) {
                metaDataCheckResult = resultFromOUI;
            } else if (type.isAdd() || type.isRemove()) {
                if (this.isUninstallComponent(type, isApply)) {
                    ComponentCheckResult resultFromOPatch = validation.checkUninstall(newInvComponentInfo.getComponentCheckResult().getComponent());
                    result = resultFromOUI.getResult().isHigherPrecedence(resultFromOPatch.getResult()) ? resultFromOUI : resultFromOPatch;
                } else {
                    result = resultFromOUI;
                }
                isInstall = true;
            }
            if (!isInstall) continue;
            OLogger.justlog(OLogger.INFO, "CUP: InventoryComponentInfo:" + result.getComponent() + " type: " + type + " resultFromOUI :" + result.getResult() + "details:" + result.getDetails());
            results.setResult(result.getComponent(), result.getResult(), result.getDetails());
        }
        return metaDataCheckResult;
    }

    private boolean isUninstallComponent(InventoryComponentInfo.Action type, boolean isApply) {
        if (type.isRemove() && isApply) {
            return true;
        }
        return type.isAdd() && !isApply;
    }

    public ComponentCheckResult checkResultForApplyCUP2(Patch patch, PatchCheckResults results) {
        ComponentCheckResult metaDataCheckResult = null;
        metaDataCheckResult = this.checkResultForCUP2(patch, results, this.compsInfoInInventoryApply2, true);
        if (OPatchEnv.isCUP2Supported()) {
            CUPFileHandler cupFileHandler = new CUPFileHandler();
            cupFileHandler.addConflictCheckFiles(patch, this.compsInfoInInventoryApply2);
        }
        return metaDataCheckResult;
    }

    public ComponentCheckResult checkResultForRollbackCUP2(Patch patch, PatchCheckResults results) {
        HashSet<InventoryComponentInfo> rollbackInvenotyCompsSet;
        ComponentCheckResult metaDataCheckResult = null;
        if (this.compsInfoInInventoryRollback2 != null) {
            List<InventoryComponentInfo> rollbackInvenotyCompsList = this.compsInfoInInventoryRollback2.get(patch.getPatchUpi());
            rollbackInvenotyCompsSet = new HashSet<InventoryComponentInfo>(rollbackInvenotyCompsList);
        } else {
            rollbackInvenotyCompsSet = new HashSet<InventoryComponentInfo>();
        }
        metaDataCheckResult = this.checkResultForCUP2(patch, results, rollbackInvenotyCompsSet, false);
        return metaDataCheckResult;
    }

    public static void clear() {
        if (inventoryComponents != null) {
            inventoryComponents.clear();
        }
        if (cupComponentMap != null) {
            cupComponentMap.clear();
        }
        UninstallValidation.clear();
        CUPFileHandler.clear();
    }
}

