/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.cup;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import oracle.glcm.opatch.common.api.PatchInventory;
import oracle.glcm.opatch.common.api.install.FileState;
import oracle.glcm.opatch.common.api.install.InventoryComponentInfo;
import oracle.opatch.OPatchEnv;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchObject;
import oracle.opatch.SystemCall;
import oracle.opatch.cup.CUPAdapter;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.wrappers.WrapperFactory;

public class CUPPatchComponent
extends PatchComponent {
    String compName;
    String version;
    List<String> affectedFiles = null;
    Map<FileState, List<String>> fileStateMap = null;
    PatchObject patchObject = null;
    String backupPathForRollback;
    String backupPathForRestore;

    public CUPPatchComponent(PatchInventory.Component comp) {
        super(comp.getName(), comp.getVersion(), true);
    }

    public CUPPatchComponent(String compName, String version, List<String> filelist, Map<FileState, List<String>> fileStateMap, PatchObject patchobj) {
        this.compName = compName;
        this.version = version;
        this.affectedFiles = filelist;
        this.fileStateMap = fileStateMap;
        this.patchObject = patchobj;
        if (patchobj != null) {
            String oracleHomePath = OPatchEnv.getOracleHome();
            this.backupPathForRollback = OPatchEnv.getRollbackDirectoryPath(oracleHomePath, patchobj.getCookedPatchID());
            this.backupPathForRestore = OPatchEnv.getBackupDirectoryPath(oracleHomePath, patchobj.getCookedPatchID());
        }
    }

    public static void addBackupFiles(List<CUPPatchComponent> cupPatchComponents, InventoryComponentInfo invComp) {
        Map backupMap;
        InventoryComponentInfo.Action action = invComp.getAction();
        if ((action.isAdd() || action.isRemove()) && ((backupMap = invComp.getBackupFiles()) == null || backupMap.isEmpty())) {
            String name = invComp.getName();
            String version = invComp.getVersion();
            for (CUPPatchComponent cupPatchComp : cupPatchComponents) {
                if (!cupPatchComp.compName.equals(name) || !cupPatchComp.version.equals(version)) continue;
                for (String fileName : cupPatchComp.affectedFiles) {
                    Path homeFile = cupPatchComp.getOracleHomeFile(fileName);
                    Path backupFile = cupPatchComp.getBackupFile(fileName);
                    WrapperFactory.getCommonApiWrapper().addBackupFile(invComp, homeFile, backupFile);
                }
            }
        }
    }

    public static void addAffectedFiles(List<CUPPatchComponent> cupPatchComponents, InventoryComponentInfo invComp) {
        Map map;
        InventoryComponentInfo.Action action = invComp.getAction();
        if ((action.isAdd() || action.isRemove()) && ((map = invComp.getAffectedFiles()) == null || map.isEmpty())) {
            String name = invComp.getName();
            String version = invComp.getVersion();
            for (CUPPatchComponent cupPatchComp : cupPatchComponents) {
                if (!cupPatchComp.compName.equals(name) || !cupPatchComp.version.equals(version)) continue;
                for (Map.Entry<FileState, List<String>> entry : cupPatchComp.fileStateMap.entrySet()) {
                    for (String fileName : entry.getValue()) {
                        Path homeFile = cupPatchComp.getOracleHomeFile(fileName);
                        WrapperFactory.getCommonApiWrapper().addAffectedFile(invComp, entry.getKey(), homeFile);
                    }
                }
            }
        }
    }

    public void backupForRollback() {
        for (String fileName : this.affectedFiles) {
            Path srcFile = this.getOracleHomeFile(fileName);
            Path dstFile = this.getBackupFile(fileName);
            if (!Files.exists(srcFile, new LinkOption[0])) {
                if (!Files.exists(dstFile, new LinkOption[0])) continue;
                OLogger.debug("CUP:backupForRollback(): delete exist file" + dstFile);
                try {
                    Files.delete(dstFile);
                }
                catch (IOException e2) {
                    OLogger.debug(e2.getMessage());
                }
                continue;
            }
            if (Files.isDirectory(srcFile, new LinkOption[0])) {
                OLogger.justlog(OLogger.WARNING, "CUP: backupForRollback(): will not back up directory: " + srcFile);
                continue;
            }
            Path parentFile = dstFile.getParent();
            if (!Files.exists(parentFile, new LinkOption[0])) {
                try {
                    Files.createDirectory(parentFile, new FileAttribute[0]);
                }
                catch (IOException e3) {
                    OLogger.debug(e3.getMessage());
                }
            }
            OLogger.debug("CUP:backupForRollback(): backup from " + srcFile + " to " + dstFile);
            SystemCall.backupFile(srcFile, dstFile);
        }
    }

    public void rollback() {
        OLogger.justlog(OLogger.INFO, "CUP2: CUPPatchComponent.rollback() compName: " + this.getCompName() + " version: " + this.getVersion());
        for (String fileName : this.affectedFiles) {
            Path srcFile = this.getBackupFile(fileName);
            Path dstFile = this.getOracleHomeFile(fileName);
            if (Files.exists(srcFile, new LinkOption[0])) {
                OLogger.justlog(OLogger.INFO, "CUP2: rollback() from : " + srcFile + " to : " + dstFile);
                SystemCall.copyFile(srcFile, dstFile);
                continue;
            }
            if (!Files.exists(dstFile, new LinkOption[0]) || !Files.isWritable(dstFile)) continue;
            OLogger.justlog(OLogger.INFO, "CUP2: rollback() delete : " + dstFile);
            try {
                Files.delete(dstFile);
            }
            catch (IOException e2) {
                OLogger.debug(e2.getMessage());
            }
        }
    }

    public void backupForRestore() {
        for (String fileName : this.affectedFiles) {
            Path srcFile = this.getOracleHomeFile(fileName);
            Path dstFile = this.getBackupFileForRestore(fileName);
            if (!Files.exists(srcFile, new LinkOption[0]) || !Files.isReadable(srcFile)) {
                if (!Files.exists(dstFile, new LinkOption[0])) continue;
                OLogger.debug("CUP:backupForRestore(): delete exist file" + dstFile);
                try {
                    Files.delete(dstFile);
                }
                catch (IOException e2) {
                    OLogger.debug(e2.getMessage());
                }
                continue;
            }
            if (Files.isDirectory(srcFile, new LinkOption[0])) {
                OLogger.justlog(OLogger.WARNING, "CUP: backupForRestore(): will not back up directory: " + srcFile);
                continue;
            }
            Path parentFile = dstFile.getParent();
            if (!Files.exists(parentFile, new LinkOption[0])) {
                try {
                    Files.createDirectories(parentFile, new FileAttribute[0]);
                }
                catch (IOException e3) {
                    OLogger.debug(e3.getMessage());
                }
            }
            OLogger.debug("CUP:backupForRestore(): backup from " + srcFile + " to " + dstFile);
            SystemCall.backupFile(srcFile, dstFile);
        }
    }

    public void restore() {
        OLogger.justlog(OLogger.INFO, "CUP2: CUPPatchComponent.restore() compName: " + this.getCompName() + " version: " + this.getVersion());
        for (String fileName : this.affectedFiles) {
            Path srcFile = this.getBackupFileForRestore(fileName);
            Path dstFile = this.getOracleHomeFile(fileName);
            if (!Files.exists(srcFile, new LinkOption[0])) continue;
            OLogger.justlog(OLogger.INFO, "CUP2: restore() from : " + srcFile + " to : " + dstFile);
            SystemCall.copyFile(srcFile, dstFile);
        }
    }

    public static void restore(PatchObject[] pos) {
        for (PatchObject po : pos) {
            CUPAdapter cupAdapter = new CUPAdapter(po);
            for (CUPPatchComponent cupComponent : cupAdapter.getCUPPatchComponentList()) {
                cupComponent.restore();
            }
        }
    }

    public String getCompName() {
        return this.compName;
    }

    public void setCompName(String compName) {
        this.compName = compName;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    private Path getOracleHomeFile(String fileName) {
        String oracleHome = OPatchEnv.getOracleHome();
        return WrapperFactory.getNioServiceWrapper().getPath(oracleHome + File.separator + fileName, new String[0]);
    }

    private Path getBackupFile(String fileName) {
        return WrapperFactory.getNioServiceWrapper().getPath(this.backupPathForRollback + File.separator + fileName, new String[0]);
    }

    private Path getBackupFileForRestore(String fileName) {
        return WrapperFactory.getNioServiceWrapper().getPath(this.backupPathForRestore + File.separator + fileName, new String[0]);
    }

    public Map<FileState, List<String>> getFileMap() {
        return this.fileStateMap;
    }

    public void cleanBackupForRestore() {
    }
}

