/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.diag;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.StringTokenizer;
import oracle.opatch.wrappers.WrapperFactory;

public class OPatchErrorUtil {
    private static final String UPDATE_FILE_INSTRUCTION = "You can get the latest messsage file from My Oracle Support using patch 16609471";
    private static final String SYNTAX_ERROR = "Syntax Error... ";
    private static final String DISPLAY_HELP = "Please use the option 'operr -help' to get correct syntax";
    private static final String INVALID_MSG_FILE = "Invalid message file. You can get the latest messsage file from My Oracle Support using patch 16609471";
    public static final String HELP_OPERR_FILE = "operr_help.txt";
    public static final String OPERR_MESSAGE_FILE = "operr.txt";
    public static final String OPERR_VERSION_FILE = "operr_version.txt";
    static boolean hasExFile = false;

    public static void main(String[] args) {
        OPatchErrorUtil operr = new OPatchErrorUtil();
        int argsNum = args.length;
        int exitCode = 0;
        boolean hasExitCode = false;
        String messageFile = null;
        boolean displayVersion = false;
        for (int i2 = 0; i2 < args.length; ++i2) {
            if (args[i2].equals("-h") || args[i2].equals("-help")) {
                operr.displayHelp();
                System.exit(0);
                continue;
            }
            if (args[i2].equals("-v") || args[i2].equals("-version") || args[i2].equals("version")) {
                displayVersion = true;
                continue;
            }
            if (args[i2].equals("-f")) {
                if (i2 + 1 >= args.length) {
                    System.out.println("Syntax Error... No message file specified.\nPlease use the option 'operr -help' to get correct syntax");
                    System.exit(0);
                }
                hasExFile = true;
                messageFile = args[i2 + 1];
                ++i2;
                continue;
            }
            if (args[i2].equals("-jre") || args[i2].equals("-jdk") || args[i2].equals("-oh")) {
                ++i2;
                continue;
            }
            if (displayVersion || hasExitCode) continue;
            try {
                hasExitCode = true;
                exitCode = Integer.parseInt(args[i2]);
                continue;
            }
            catch (Throwable t) {
                System.out.println("Syntax Error... Invalid error code: " + args[i2] + " .\n" + DISPLAY_HELP);
                System.exit(0);
            }
        }
        String errorMsg = "";
        String actionMsg = "";
        if (argsNum == 0) {
            operr.displayHelp();
            System.exit(0);
        }
        if (!hasExFile) {
            messageFile = OPERR_MESSAGE_FILE;
        }
        if (!displayVersion && !hasExitCode) {
            System.out.println("Syntax Error... No error code specified.\nPlease use the option 'operr -help' to get correct syntax");
            System.exit(0);
        }
        try {
            if (displayVersion) {
                String version = operr.queryVersion(messageFile);
                String operrVersion = operr.getOperrVersion();
                if (version.equals("")) {
                    System.out.println(INVALID_MSG_FILE);
                } else {
                    System.out.println("operr version is " + operrVersion);
                    System.out.println("Message file version is " + version);
                }
                System.exit(0);
            }
            errorMsg = operr.queryErrorMessage(exitCode, messageFile);
            actionMsg = operr.queryActionMessage(exitCode, messageFile);
        }
        catch (IOException e2) {
            System.out.println("The message file " + messageFile + " does not exist or not readable.\nPlease check the arguments and try again.");
            System.exit(0);
        }
        catch (Exception ex) {
            System.out.println(INVALID_MSG_FILE);
            System.exit(0);
        }
        if (errorMsg.equals("") | actionMsg.equals("")) {
            System.out.println("Undefined error code.");
        } else {
            System.out.println("Error code:\t" + exitCode);
            StringBuffer errorMessage = new StringBuffer("Error message:\t");
            errorMessage.append(errorMsg);
            System.out.println(errorMessage.toString());
            StringBuffer recommendBuff = new StringBuffer("Recommended actions: \t");
            recommendBuff.append(actionMsg);
            System.out.println(recommendBuff.toString());
        }
        if (!hasExFile) {
            System.out.println(UPDATE_FILE_INSTRUCTION);
        }
        System.exit(0);
    }

    public String queryVersion(String filePath) throws IOException, Exception {
        return this.queryMessage(MessageType._VERSION, 0, filePath);
    }

    public String queryErrorMessage(int errorCode, String filePath) throws IOException, Exception {
        return this.queryMessage(MessageType._ERROR_MSG, errorCode, filePath);
    }

    public String queryActionMessage(int errorCode, String filePath) throws IOException, Exception {
        return this.queryMessage(MessageType._ACTION, errorCode, filePath);
    }

    private String queryMessage(MessageType type, int errorCode, String filePath) throws IOException, Exception {
        StringBuffer message = new StringBuffer();
        String key = "";
        Path path = WrapperFactory.getNioServiceWrapper().getPath(filePath, new String[0]);
        InputStream is = null;
        is = hasExFile ? Files.newInputStream(path, new OpenOption[0]) : this.getClass().getResourceAsStream(filePath);
        BufferedReader br = Files.newBufferedReader(path, Charset.forName("UTF-8"));
        String entry = null;
        boolean getCode = false;
        boolean getMessage = false;
        try {
            while ((entry = br.readLine()) != null) {
                String errorCodeStr;
                StringTokenizer st = new StringTokenizer(entry, ":");
                if (getMessage) {
                    if (entry.indexOf(":") != -1) {
                        break;
                    }
                    message.append("\n" + entry);
                    continue;
                }
                if (entry.indexOf(":") == -1 || !st.hasMoreTokens()) continue;
                key = st.nextToken();
                if (key.equals(MessageType._VERSION.toString()) && type.equals((Object)MessageType._VERSION) && st.hasMoreTokens()) {
                    message.append(st.nextToken());
                    break;
                }
                if (key.equals(MessageType._ERROR_CODE.toString()) && st.hasMoreTokens() && errorCode == Integer.parseInt(errorCodeStr = st.nextToken())) {
                    getCode = true;
                }
                if (!getCode) continue;
                if (key.equals(MessageType._ACTION.toString()) && type.equals((Object)MessageType._ACTION) && st.hasMoreTokens()) {
                    int index = entry.indexOf(":", entry.indexOf(type.toString()) + 1);
                    message.append(entry.substring(index + 1, entry.length()));
                    getMessage = true;
                }
                if (!key.equals(MessageType._ERROR_MSG.toString()) || !type.equals((Object)MessageType._ERROR_MSG) || !st.hasMoreTokens()) continue;
                int index = entry.indexOf(":", entry.indexOf(type.toString()) + 1);
                message.append(entry.substring(index + 1, entry.length()));
                getMessage = true;
            }
        }
        catch (Exception e2) {
            throw e2;
        }
        finally {
            try {
                br.close();
            }
            catch (IOException iOException) {}
        }
        return message.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getOperrVersion() {
        InputStream is = this.getClass().getResourceAsStream(OPERR_VERSION_FILE);
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        try {
            String entry = null;
            while (true) {
                if ((entry = br.readLine()) != null) {
                    StringTokenizer st = new StringTokenizer(entry, ":");
                    if (!st.hasMoreTokens() || !st.nextToken().equals("OPERR_VERSION") || !st.hasMoreTokens()) continue;
                    String string = st.nextToken();
                    return string;
                    continue;
                }
                break;
            }
        }
        catch (IOException e2) {
            String string = "";
            return string;
        }
        finally {
            try {
                br.close();
            }
            catch (IOException iOException) {}
        }
        return "";
    }

    private void displayHelp() {
        StringBuffer helpM = new StringBuffer("");
        String helpFile = HELP_OPERR_FILE;
        try {
            String thisLine;
            InputStream is = this.getClass().getResourceAsStream(helpFile);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((thisLine = br.readLine()) != null) {
                helpM.append(thisLine);
                helpM.append("\n");
            }
            System.out.println(helpM.toString());
            br.close();
            is.close();
        }
        catch (Exception e2) {
            System.out.println("Cannot locate help file " + helpFile + " within the package.");
        }
    }

    public static enum MessageType {
        _ERROR_CODE,
        _ERROR_MSG,
        _ACTION,
        _VERSION;

    }
}

