/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.ipm;

import com.oracle.cie.gdr.external.DirectoryMap;
import com.oracle.cie.gdr.external.Distribution;
import com.oracle.cie.gdr.external.Mapping;
import com.oracle.cie.gdr.external.OracleHomeInventory;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import oracle.glcm.opatch.common.api.BasePatchFactory;
import oracle.glcm.opatch.common.api.ComponentCheckResult;
import oracle.glcm.opatch.common.api.Patch;
import oracle.glcm.opatch.common.api.PatchCheckResults;
import oracle.glcm.opatch.common.api.PatchInventory;
import oracle.glcm.opatch.common.api.PatchSubType;
import oracle.glcm.opatch.common.api.Result;
import oracle.glcm.opatch.common.api.SessionMode;
import oracle.glcm.opatch.common.api.install.ComponentInfo;
import oracle.glcm.opatch.common.api.install.HomeOperationsException;
import oracle.glcm.opatch.common.api.install.HomeOperationsExt;
import oracle.glcm.opatch.common.api.install.HomeOperationsFactory;
import oracle.opatch.ArchiveAction;
import oracle.opatch.Bug;
import oracle.opatch.CopyAction;
import oracle.opatch.ICustomizedActionResults;
import oracle.opatch.JarAction;
import oracle.opatch.JarActionEntity;
import oracle.opatch.NGOUIInventoryFactory;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSDK;
import oracle.opatch.OUIReplacer;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchComponentCheckResult;
import oracle.opatch.PatchComponentCheckResultImpl;
import oracle.opatch.PatchComponentMissing;
import oracle.opatch.PatchComponentMissingLang;
import oracle.opatch.PatchComponentMissingProductDirectories;
import oracle.opatch.PatchComponentMissingSymbol;
import oracle.opatch.PatchComponentVersionMismatch;
import oracle.opatch.PatchInventory;
import oracle.opatch.PatchObject;
import oracle.opatch.PatchingModel;
import oracle.opatch.Platform;
import oracle.opatch.UpdateComponent;
import oracle.opatch.conflicttextualinterpreter.IPatch;
import oracle.opatch.conflicttextualinterpreter.NPatchRelations;
import oracle.opatch.cup.CUPAdapter;
import oracle.opatch.cup.CUPPatchComponent;
import oracle.opatch.ipm.CookedInventory;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.ipm.IPMUtil;
import oracle.opatch.ipm.InstalledComponent;
import oracle.opatch.ipm.OHILock;
import oracle.opatch.ipm.RawInventory;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchutil.CommonAPIUtil;
import oracle.opatch.patchlevel.PatchLevel;
import oracle.opatch.patchlevel.PatchLevelFactory;
import oracle.opatch.patchlevel.PatchLevelRelation;
import oracle.opatch.wrappers.PatchComponentInfoWrapper;
import oracle.opatch.wrappers.WrapperFactory;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiFileMapFileEntry;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallOneoffInvEntry;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiReleaseLevels;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiix.OiixLanguage;

class IPMReadServices
implements IIPMReadServices {
    private static IPMReadServices instance = null;
    private static String fileSeparator = File.separator;
    protected static OHILock lock = null;
    protected static RawInventory rawInventory = null;
    protected static CookedInventory cookedInventory = null;
    private static HomeOperationsExt homeOperations = null;
    private static Boolean batchmode = null;
    private static String localnode = "";
    protected static Map<String, PatchCheckResults> applyPatchCheckResultsMap = new HashMap<String, PatchCheckResults>();
    protected static Map<String, PatchCheckResults> rollbackPatchCheckResultsMap = new HashMap<String, PatchCheckResults>();
    protected static Map<String, Map<PatchComponent, PatchComponentCheckResult>> applyAnalyzedPatches = new HashMap<String, Map<PatchComponent, PatchComponentCheckResult>>();
    protected static Map<String, Map<PatchComponent, PatchComponentCheckResult>> rollbackAnalyzedPatches = new HashMap<String, Map<PatchComponent, PatchComponentCheckResult>>();

    protected IPMReadServices() {
    }

    protected static synchronized IPMReadServices getInstance() {
        if (instance == null) {
            instance = new IPMReadServices();
        }
        return instance;
    }

    @Override
    public void lock(String oracleHomePath) throws RuntimeException {
        if (lock != null) {
            OLogger.debug(new StringBuffer("IPMReadServices::init() IIPMReadServices has been already initialized"));
        } else {
            try {
                lock = OHILock.lock(oracleHomePath, true);
            }
            catch (Throwable e2) {
                OLogger.debug(new StringBuffer("Unable to acquire OHI Read Lock: "));
                RuntimeException re = new RuntimeException(e2.getMessage());
                re.setStackTrace(e2.getStackTrace());
                throw re;
            }
        }
    }

    @Override
    public void release() {
        if (lock != null) {
            lock.release();
            lock = null;
        }
    }

    @Override
    public void destroy() {
        this.release();
        if (cookedInventory != null) {
            cookedInventory.clearInventory();
            cookedInventory = null;
        }
        if (rawInventory != null) {
            rawInventory.clearInventory();
            rawInventory = null;
        }
        if (applyPatchCheckResultsMap != null) {
            applyPatchCheckResultsMap.clear();
        }
        if (rollbackPatchCheckResultsMap != null) {
            rollbackPatchCheckResultsMap.clear();
        }
        if (applyAnalyzedPatches != null) {
            applyAnalyzedPatches.clear();
        }
        if (rollbackAnalyzedPatches != null) {
            rollbackAnalyzedPatches.clear();
        }
        instance = null;
        CUPAdapter.clear();
    }

    public boolean getBatchMode() {
        if (batchmode == null) {
            batchmode = OPatchEnv.isNextGen() ? Boolean.valueOf(homeOperations.isMethodImplemented("processPatches")) : Boolean.valueOf(false);
            OLogger.justlog(OLogger.INFO, "Is batchMode enable? " + batchmode);
        }
        return batchmode;
    }

    private boolean isLockedAsRO() {
        return lock != null && !lock.isWriterLock();
    }

    @Override
    public boolean isLocked() {
        return lock != null;
    }

    protected CookedInventory getCookedInventory() throws RuntimeException {
        StringBuffer buff = new StringBuffer("IPMReadServices::getCookedInventory()");
        OLogger.debug(buff);
        if (cookedInventory == null) {
            try {
                if (rawInventory == null) {
                    if (this.isLocked()) {
                        rawInventory = RawInventory.getInstance(lock.getOracleHomePath(), lock.getCurrentOUISession(), false);
                        PatchingModel.returnModelCode(lock.getOracleHomePath());
                    } else {
                        throw new RuntimeException("IPMReadServices or IPMRWServices has not been initialized");
                    }
                }
                cookedInventory = CookedInventory.getInstance(rawInventory);
            }
            catch (Throwable t) {
                buff = new StringBuffer("IPMReadServices::getCookedInventory() gets an error: ");
                buff.append(t.getMessage());
                OLogger.debug(buff);
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                throw re;
            }
        }
        return cookedInventory;
    }

    protected RawInventory getRawInventory() {
        StringBuffer buff = new StringBuffer("IPMReadServices::getRawInventory()");
        OLogger.debug(buff);
        if (rawInventory == null) {
            if (this.isLocked()) {
                try {
                    rawInventory = RawInventory.getInstance(lock.getOracleHomePath(), lock.getCurrentOUISession(), false);
                    PatchingModel.returnModelCode(lock.getOracleHomePath());
                }
                catch (Throwable t) {
                    buff = new StringBuffer("IPMReadServices::getRawInventory() gets an error: ");
                    buff.append(t.getMessage());
                    OLogger.debug(buff);
                    RuntimeException re = new RuntimeException(t.getMessage());
                    re.setStackTrace(t.getStackTrace());
                    throw re;
                }
            } else {
                throw new RuntimeException("IPMReadServices or IPMRWServices has not been initialized");
            }
        }
        return rawInventory;
    }

    @Override
    public void reloadInventory() throws RuntimeException {
        StringBuffer buff = new StringBuffer("IPMReadServices::clear()");
        OLogger.debug(buff);
        rawInventory = this.getRawInventory().reload();
        cookedInventory = this.getCookedInventory().reload(rawInventory);
        applyPatchCheckResultsMap.clear();
        applyPatchCheckResultsMap = new HashMap<String, PatchCheckResults>();
        rollbackPatchCheckResultsMap.clear();
        rollbackPatchCheckResultsMap = new HashMap<String, PatchCheckResults>();
        applyAnalyzedPatches.clear();
        applyAnalyzedPatches = new HashMap<String, Map<PatchComponent, PatchComponentCheckResult>>();
        rollbackAnalyzedPatches.clear();
        rollbackAnalyzedPatches = new HashMap<String, Map<PatchComponent, PatchComponentCheckResult>>();
    }

    @Override
    public boolean isInInventory(OneOffEntry entry) {
        return false;
    }

    @Override
    @Deprecated
    public void haveComponents(UpdateComponent[] componentsToCheck) throws RuntimeException {
    }

    @Override
    @Deprecated
    public PatchComponent[] haveComponents(PatchComponent[] componentsToCheck) throws RuntimeException {
        StringBuffer buff = new StringBuffer("IPMReadServices::haveComponents()");
        OLogger.debug(buff);
        if (componentsToCheck == null) {
            buff.append(" gets a null parameter componentsToCheck");
            OLogger.debug(buff);
            throw new RuntimeException(buff.toString());
        }
        if (componentsToCheck.length == 0) {
            buff.append(" gets an empty list.  Nothing to do, return empty list back.");
            OLogger.debug(buff);
            return componentsToCheck;
        }
        int size = componentsToCheck.length;
        PatchComponent[] presentComponents = new PatchComponent[size];
        buff = new StringBuffer("  there are ");
        buff.append(size);
        buff.append(" components to check.");
        OLogger.debug(buff);
        for (int i2 = 0; i2 < size; ++i2) {
            PatchComponentMissing missingPC;
            PatchComponent pc = componentsToCheck[i2];
            if (pc == null) {
                buff = new StringBuffer("IPMReadServices::haveComponents() gets a null entry inside array componentsToCheck");
                OLogger.debug(buff);
                throw new RuntimeException(buff.toString());
            }
            String compName = pc.getID();
            String searchVersion = pc.getVersion();
            boolean required = pc.isRequired();
            buff = new StringBuffer("  Patch Component (component to check) is \"");
            buff.append(compName);
            buff.append("\", \"");
            buff.append(searchVersion);
            buff.append("\", required = \"");
            buff.append(required);
            buff.append("\"");
            OLogger.debug(buff);
            OiiiCompInstallID refCid = new OiiiCompInstallID(compName, new OiiiVersion(searchVersion), OUIReplacer.Platform.getCurrentPlatformVector(), new OiiiVersion("0.0.0.0.0"), 1, 2, OiiiReleaseLevels.DefaultReleaseLevel());
            OiiiVersion oVersion = null;
            Vector oLang = new Vector();
            int oracleHomeIndex = this.getIndex();
            Vector compEntries = this.getRawInventory().getCompInvEntries(compName, oracleHomeIndex);
            if (compEntries == null) {
                buff = new StringBuffer("IPMReadServices::haveComponents() : ");
                buff.append("the home has no inventory");
                OLogger.debug(buff);
                throw new RuntimeException(buff.toString());
            }
            if (compEntries.size() == 0) {
                missingPC = new PatchComponentMissing(compName, searchVersion, required);
                presentComponents[i2] = missingPC;
                continue;
            }
            buff = new StringBuffer("IPMReadServices::haveComponents() : ");
            buff.append("getRawInventory().getCompInvEntries() on \"");
            buff.append(compName);
            buff.append("\", homeIndex = \"");
            buff.append(oracleHomeIndex);
            buff.append("\" returns ");
            buff.append(compEntries.size());
            buff.append(" components.");
            OLogger.debug(buff);
            for (int j2 = 0; j2 < compEntries.size(); ++j2) {
                OiiiVersion comVersion = null;
                OiiiVersion orgVersion = null;
                OiiiCompInstallID id = null;
                OiiiInstallCompInvEntry cie = (OiiiInstallCompInvEntry)compEntries.elementAt(j2);
                if (cie != null) {
                    id = cie.getCompInstallID();
                    oLang = cie.getLanguages();
                    if (id != null) {
                        orgVersion = id.getVersion();
                        buff = new StringBuffer("    \nProcess installed component \"");
                        buff.append(id.getName());
                        buff.append("\", version \"");
                        if (IPMReadServices.checkIfMiniPatchsetFunctional()) {
                            if (cie.getPatchInvEntry() != null) {
                                comVersion = id.getVersion();
                                buff.append(comVersion);
                            } else {
                                comVersion = cie.getHighestCompVersion();
                                id.setVersion(comVersion);
                                buff.append(comVersion);
                            }
                        } else {
                            comVersion = id.getVersion();
                            buff.append(comVersion.getVerString());
                        }
                        buff.append("\"");
                        OLogger.debug(buff);
                        if (id.getCompType() == 1 || id.getCompType() == 2) {
                            buff = new StringBuffer("    Check installed product: ");
                            buff.append("name=\"");
                            buff.append(id.getName());
                            buff.append("\", ver=\"");
                            buff.append(comVersion);
                            buff.append("\"");
                            OLogger.debug(buff);
                            buff = new StringBuffer("    Installed Comp >< Patch Comp: \n");
                            buff.append("      Installed Comp Version later than Patch Comp = ");
                            buff.append(comVersion.laterThan(refCid.getVersion()));
                            buff.append("\n");
                            buff.append("      Installed Comp can replace Patch Comp = ");
                            buff.append(id.canReplace(refCid, OUIReplacer.Platform.getCurrentPlatform()));
                            OLogger.debug(buff);
                            boolean installedIDEqualOrLater = comVersion.equals(refCid.getVersion()) || comVersion.laterThan(refCid.getVersion());
                            buff = new StringBuffer("      Install Comp Version equals ");
                            buff.append("or is later than Patch Comp: ");
                            buff.append(installedIDEqualOrLater);
                            OLogger.debug(buff);
                            if (installedIDEqualOrLater && id.canReplace(refCid, OUIReplacer.Platform.getCurrentPlatform()) && (oVersion == null || cie.getVersion().laterThan(oVersion))) {
                                buff = new StringBuffer("    Found a laterThan ");
                                buff.append("(or the same) of \"");
                                buff.append(searchVersion);
                                buff.append("\" as \"");
                                buff.append(cie.getVersion());
                                buff.append("\".  Save this version \"");
                                oVersion = comVersion;
                                buff.append(oVersion);
                                buff.append("\"");
                                OLogger.debug(buff);
                            }
                        } else {
                            buff = new StringBuffer("   It's not of type OiiiCompType.COMPONENT or OiiiCompType.COMPONENT, skip.");
                            OLogger.debug(buff);
                        }
                    } else {
                        buff = new StringBuffer("IPMReadServices::haveComponents() ");
                        buff.append("got a null OiiiCompInstallID from InstalledComponent entry.");
                        OLogger.debug(buff);
                    }
                } else {
                    buff = new StringBuffer("IPMReadServices::haveComponents() ");
                    buff.append("got a null OiiiCompInvEntry cie entry.");
                    OLogger.debug(buff);
                }
                id.setVersion(orgVersion);
            }
            if (oVersion != null) {
                String foundVersion = oVersion.getVerString();
                if (searchVersion.equals(foundVersion)) {
                    boolean isSnowBall;
                    buff = new StringBuffer("inventoryHasThisComponent(): component/version found");
                    buff.append("\nBut, let's check if it is language compatible");
                    OLogger.debug(buff);
                    Vector patchLangs = OiixLanguage.strToVect((String)pc.getLanguage());
                    boolean bl = isSnowBall = PatchingModel.returnModelCode(this.getRawInventory().getOracleHomePath()) == 2;
                    if (patchLangs != null && patchLangs.size() != 0 && isSnowBall) {
                        if (oLang.containsAll(patchLangs)) {
                            presentComponents[i2] = pc;
                            continue;
                        }
                        PatchComponentMissingLang missingLangPC = new PatchComponentMissingLang(compName, foundVersion, required, pc.getLanguage(), oLang);
                        presentComponents[i2] = missingLangPC;
                        continue;
                    }
                    if (pc.hasSymbol()) {
                        boolean symbolExists = false;
                        Set<String> productDirectories = this.getProductDirectories(pc.getSymbolName());
                        if (productDirectories != null && !productDirectories.isEmpty()) {
                            symbolExists = true;
                        }
                        if (!symbolExists) {
                            PatchComponentMissingSymbol missingSymbol = new PatchComponentMissingSymbol(compName, searchVersion, pc.getSymbolName(), required);
                            presentComponents[i2] = missingSymbol;
                            continue;
                        }
                        if (pc.getProductDirectories(this.getRawInventory().getOracleHomePath()) == null || pc.getProductDirectories(this.getRawInventory().getOracleHomePath()).length == 0) {
                            PatchComponentMissingProductDirectories missingPD = new PatchComponentMissingProductDirectories(compName, searchVersion, pc.getSymbolName(), required);
                            presentComponents[i2] = missingPD;
                            continue;
                        }
                    }
                    presentComponents[i2] = pc;
                    continue;
                }
                buff = new StringBuffer("inventoryHasThisComponent() found the component with higher version: ");
                buff.append("searchVersion = \"");
                buff.append(searchVersion);
                buff.append("\", foundVersion = \"");
                buff.append(foundVersion);
                buff.append("\" --> declare not found then.");
                PatchComponentVersionMismatch higherPC = new PatchComponentVersionMismatch(compName, searchVersion, foundVersion, required);
                presentComponents[i2] = higherPC;
                continue;
            }
            missingPC = new PatchComponentMissing(compName, searchVersion, required);
            presentComponents[i2] = missingPC;
        }
        return presentComponents;
    }

    private Map<PatchComponent, PatchComponentCheckResult> getPatchComponentExtraCheckResults(List<PatchComponent> patchComponents) {
        HashMap<PatchComponent, PatchComponentCheckResult> result = new HashMap<PatchComponent, PatchComponentCheckResult>();
        if (patchComponents == null || patchComponents.size() == 0) {
            return result;
        }
        for (PatchComponent pc : patchComponents) {
            boolean isSnowBall;
            String compName = pc.getID();
            boolean required = pc.isRequired();
            PatchComponentCheckResultImpl pcResult = new PatchComponentCheckResultImpl(pc);
            if (compName.equals("oracle.nextgen.metadata")) {
                pcResult.setResult(Result.PROCESS_COMPONENT);
                pcResult.setDetails(OLogger.getString("OUI-67405", new Object[]{pc.getID(), pc.getVersion()}));
                result.put(pc, pcResult);
                continue;
            }
            Vector oLang = new Vector();
            int oracleHomeIndex = this.getIndex();
            OiiiVersion oVersion = new OiiiVersion(pc.getVersion());
            Vector compEntries = this.getRawInventory().getCompInvEntries(compName, oVersion, oracleHomeIndex);
            if (compEntries == null) {
                throw new RuntimeException("home has no inventory");
            }
            if (compEntries.size() == 0) {
                if (pc.isRequired()) {
                    pcResult.setResult(Result.ERR_NOT_FOUND);
                    pcResult.setDetails(OLogger.getString("OUI-67402", new Object[]{pc.getID(), pc.getVersion()}));
                } else {
                    pcResult.setResult(Result.IGNORE_NOT_FOUND);
                    pcResult.setDetails(OLogger.getString("OUI-67403", new Object[]{pc.getID(), pc.getVersion()}));
                }
                result.put(pc, pcResult);
                continue;
            }
            oLang = ((OiiiInstallCompInvEntry)compEntries.elementAt(0)).getLanguages();
            Vector patchLangs = OiixLanguage.strToVect((String)pc.getLanguage());
            boolean bl = isSnowBall = PatchingModel.returnModelCode(this.getRawInventory().getOracleHomePath()) == 2;
            if (patchLangs != null && patchLangs.size() != 0 && isSnowBall) {
                if (oLang.containsAll(patchLangs)) {
                    pcResult.setResult(Result.PROCESS_COMPONENT);
                    pcResult.setDetails(OLogger.getString("OUI-67405", new Object[]{pc.getID(), pc.getVersion()}));
                    result.put(pc, pcResult);
                    continue;
                }
                if (required) {
                    pcResult.setResult(Result.ERR_NOT_FOUND);
                    pcResult.setDetails(OLogger.getString("OUI-67402", new Object[]{pc.getID(), pc.getVersion()}));
                } else {
                    pcResult.setResult(Result.IGNORE_NOT_FOUND);
                    pcResult.setDetails(OLogger.getString("OUI-67403", new Object[]{pc.getID(), pc.getVersion()}));
                }
                pcResult.setDetails("");
                result.put(pc, pcResult);
                continue;
            }
            if (pc.hasSymbol()) {
                boolean symbolExists = false;
                Set<String> productDirectories = this.getProductDirectories(pc.getSymbolName());
                if (productDirectories != null && !productDirectories.isEmpty()) {
                    symbolExists = true;
                }
                if (!symbolExists) {
                    if (required) {
                        pcResult.setResult(Result.ERR_NOT_FOUND);
                        pcResult.setDetails(OLogger.getString("OUI-67402", new Object[]{pc.getID(), pc.getVersion()}));
                    } else {
                        pcResult.setResult(Result.IGNORE_NOT_FOUND);
                        pcResult.setDetails(OLogger.getString("OUI-67403", new Object[]{pc.getID(), pc.getVersion()}));
                    }
                    pcResult.setDetails("");
                    result.put(pc, pcResult);
                    continue;
                }
                if (pc.getProductDirectories(this.getRawInventory().getOracleHomePath()) == null || pc.getProductDirectories(this.getRawInventory().getOracleHomePath()).length == 0) {
                    if (required) {
                        pcResult.setResult(Result.ERR_NOT_FOUND);
                        pcResult.setDetails(OLogger.getString("OUI-67402", new Object[]{pc.getID(), pc.getVersion()}));
                    } else {
                        pcResult.setResult(Result.IGNORE_NOT_FOUND);
                        pcResult.setDetails(OLogger.getString("OUI-67403", new Object[]{pc.getID(), pc.getVersion()}));
                    }
                    pcResult.setDetails("");
                    result.put(pc, pcResult);
                    continue;
                }
            }
            pcResult.setResult(Result.PROCESS_COMPONENT);
            pcResult.setDetails(OLogger.getString("OUI-67405", new Object[]{pc.getID(), pc.getVersion()}));
            result.put(pc, pcResult);
        }
        return result;
    }

    private Map<PatchComponent, PatchComponentCheckResult> getPatchComponentCheckResults(List<PatchComponent> patchComponents) {
        HashMap<PatchComponent, PatchComponentCheckResult> result = new HashMap<PatchComponent, PatchComponentCheckResult>();
        ArrayList<PatchComponent> extraProcessComps = new ArrayList<PatchComponent>();
        if (patchComponents == null || patchComponents.size() == 0) {
            return result;
        }
        for (PatchComponent pc : patchComponents) {
            String compName = pc.getID();
            String searchVersion = pc.getVersion();
            boolean required = pc.isRequired();
            PatchComponentCheckResultImpl pcResult = new PatchComponentCheckResultImpl(pc);
            if (compName.equals("oracle.nextgen.metadata")) {
                pcResult.setResult(Result.PROCESS_COMPONENT);
                pcResult.setDetails(OLogger.getString("OUI-67405", new Object[]{pc.getID(), pc.getVersion()}));
                result.put(pc, pcResult);
                continue;
            }
            OiiiCompInstallID refCid = new OiiiCompInstallID(compName, new OiiiVersion(searchVersion), OUIReplacer.Platform.getCurrentPlatformVector(), new OiiiVersion("0.0.0.0.0"), 1, 2, OiiiReleaseLevels.DefaultReleaseLevel());
            OiiiVersion oVersion = null;
            Vector oLang = new Vector();
            int oracleHomeIndex = this.getIndex();
            Vector compEntries = this.getRawInventory().getCompInvEntries(compName, oracleHomeIndex);
            if (compEntries == null) {
                throw new RuntimeException("Home has no inventory");
            }
            if (compEntries.size() == 0) {
                if (pc.isRequired()) {
                    pcResult.setResult(Result.ERR_NOT_FOUND);
                    pcResult.setDetails(OLogger.getString("OUI-67402", new Object[]{pc.getID(), pc.getVersion()}));
                } else {
                    pcResult.setResult(Result.IGNORE_NOT_FOUND);
                    pcResult.setDetails(OLogger.getString("OUI-67403", new Object[]{pc.getID(), pc.getVersion()}));
                }
                result.put(pc, pcResult);
                continue;
            }
            for (int j2 = 0; j2 < compEntries.size(); ++j2) {
                OiiiVersion comVersion = null;
                OiiiVersion orgVersion = null;
                OiiiCompInstallID id = null;
                OiiiInstallCompInvEntry cie = (OiiiInstallCompInvEntry)compEntries.elementAt(j2);
                if (cie != null) {
                    id = cie.getCompInstallID();
                    oLang = cie.getLanguages();
                    if (id != null) {
                        orgVersion = id.getVersion();
                        if (IPMReadServices.checkIfMiniPatchsetFunctional()) {
                            if (cie.getPatchInvEntry() != null) {
                                comVersion = id.getVersion();
                            } else {
                                comVersion = cie.getHighestCompVersion();
                                id.setVersion(comVersion);
                            }
                        } else {
                            comVersion = id.getVersion();
                        }
                        if (id.getCompType() == 1 || id.getCompType() == 2) {
                            boolean installedIDEqualOrLater;
                            boolean bl = installedIDEqualOrLater = comVersion.equals(refCid.getVersion()) || comVersion.laterThan(refCid.getVersion());
                            if (installedIDEqualOrLater && id.canReplace(refCid, OUIReplacer.Platform.getCurrentPlatform()) && (oVersion == null || cie.getVersion().laterThan(oVersion))) {
                                oVersion = comVersion;
                            }
                        }
                    }
                }
                id.setVersion(orgVersion);
            }
            if (oVersion != null) {
                String foundVersion = oVersion.getVerString();
                if (searchVersion.equals(foundVersion)) {
                    extraProcessComps.add(pc);
                    continue;
                }
                pcResult.setResult(Result.VERSION_MISMATCH);
                pcResult.setDetails(OLogger.getString("OUI-67404", new Object[]{pc.getID(), foundVersion, searchVersion}));
                result.put(pc, pcResult);
                continue;
            }
            if (required) {
                pcResult.setResult(Result.ERR_NOT_FOUND);
                pcResult.setDetails(OLogger.getString("OUI-67402", new Object[]{pc.getID(), pc.getVersion()}));
            } else {
                pcResult.setResult(Result.IGNORE_NOT_FOUND);
                pcResult.setDetails(OLogger.getString("OUI-67403", new Object[]{pc.getID(), pc.getVersion()}));
            }
            result.put(pc, pcResult);
        }
        result.putAll(this.getPatchComponentExtraCheckResults(extraProcessComps));
        return result;
    }

    protected PatchCheckResults getPatchCheckResults(PatchObject patchObject, boolean rollback) throws RuntimeException {
        PatchCheckResults result = null;
        String cachekey = patchObject.getPatchUniqID() + "_" + patchObject.getPatchID();
        PatchCheckResults patchCheckResults = result = rollback ? rollbackPatchCheckResultsMap.get(cachekey) : applyPatchCheckResultsMap.get(cachekey);
        if (result != null) {
            return result;
        }
        result = this.getPatchCheckResultsCUP(patchObject, rollback);
        if (rollback) {
            rollbackPatchCheckResultsMap.put(cachekey, result);
        } else {
            applyPatchCheckResultsMap.put(cachekey, result);
        }
        return result;
    }

    private PatchCheckResults getPatchCheckResultsCUP(PatchObject patchObj, boolean rollback) {
        PatchCheckResults result = null;
        OLogger.debug("IPMReadServices:getPatchCheckResults");
        Patch patchObject = null;
        try {
            patchObject = CommonAPIUtil.getInstance().getCommonAPIPatch(patchObj);
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
        Set<PatchComponentInfoWrapper> compsInPatch = null;
        if (!rollback) {
            compsInPatch = this.getCompsInfoInPatch(patchObject, patchObj);
            OLogger.debug("IPMReadServices:getPatchCheckResults, got " + compsInPatch.size() + " ComponentInfo in patch " + patchObject.getPatchId());
        }
        HomeOperationsExt homeOp = this.getHomeOperations();
        Set<ComponentInfo> compsInfoInInventoryApply = null;
        Map<Object, Object> compsInInventoryRollback = new HashMap();
        try {
            homeOp.initialize(SessionMode.READ);
            CUPAdapter cupAdapter = new CUPAdapter(homeOp, patchObj);
            if (!rollback) {
                compsInfoInInventoryApply = cupAdapter.getApplyInventoryComponents(compsInPatch);
                OLogger.debug("IPMReadServices:getPatchCheckResults, got " + compsInfoInInventoryApply.size() + " ComponentInfo in inventory for apply");
                result = this.getPatchCheckResultsForApply(patchObject, cupAdapter, compsInfoInInventoryApply);
            } else {
                compsInInventoryRollback = cupAdapter.getRollbackInventoryComponents();
                OLogger.debug("IPMReadServices:getPatchCheckResults, got " + compsInInventoryRollback.size() + " ComponentInfo in inventory for rollback");
                result = this.getPatchCheckResultsForRollback(patchObject, cupAdapter, (List)compsInInventoryRollback.get(patchObject.getPatchUpi()));
            }
            homeOp.close();
        }
        catch (HomeOperationsException e2) {
            throw new RuntimeException("IMPReadService:getPatchCheckResultsCUPs, failed to get ComponentInfo from inventory " + e2.getMessage());
        }
        return result;
    }

    private PatchCheckResults getPatchCheckResultsForApply(Patch patch, CUPAdapter adpter, Set<ComponentInfo> compsInfoInInventoryApply) {
        PatchCheckResults results = BasePatchFactory.instance().getPatchCheckResults(patch);
        OLogger.debug("IPMReadServices:getPatchCheckResultsForApply begin");
        PatchSubType patchSubType = patch.getPatchSubType();
        List patchComponents = patch.getComponents();
        if (patchComponents != null && !patchComponents.isEmpty()) {
            PatchInventory.Component metaDataComponent = null;
            ComponentCheckResult metaDataComponentResult = null;
            boolean componentsWillBeProcessed = false;
            metaDataComponentResult = adpter.checkResultForApplyCUP2(patch, results);
            for (PatchInventory.Component patchComponent : patchComponents) {
                String details = "";
                if ("oracle.nextgen.metadata".equals(patchComponent.getName())) {
                    metaDataComponent = patchComponent;
                } else {
                    Result result;
                    List<ComponentInfo> matchedNameInstalledComponents = this.getMatchingComponentInInventory(patchComponent.getName(), compsInfoInInventoryApply);
                    if (matchedNameInstalledComponents.isEmpty()) {
                        if (patchComponent.isRequired().booleanValue()) {
                            result = Result.ERR_NOT_FOUND;
                            details = "Required component: " + patchComponent.getName() + " is not installed in oracle home";
                        } else {
                            result = Result.IGNORE_NOT_FOUND;
                            details = "Optional component: " + patchComponent.getName() + " is not installed in oracle home";
                        }
                    } else {
                        ArrayList<Result> componentResults = new ArrayList<Result>();
                        for (ComponentInfo compInfoInv : matchedNameInstalledComponents) {
                            componentResults.add(this.getResultBasedOnVersionAndPatchLevel(patchComponent, compInfoInv, patchSubType));
                        }
                        Result componentCheckResult = Result.getHighLevelResult(componentResults);
                        ComponentInfo compRef = matchedNameInstalledComponents.get(componentResults.indexOf(componentCheckResult));
                        if (componentCheckResult.isVersionMismatch()) {
                            if (patchComponent.isRequired().booleanValue()) {
                                result = componentCheckResult;
                                details = "Required component: " + patchComponent.getName() + " version:" + patchComponent.getVersion() + " patch level: " + patchComponent.getPatchLevel() + " mismatched with OH version: " + compRef.getVersion() + " and patch level: " + compRef.getPatchLevel();
                            } else {
                                result = Result.IGNORE_NOT_FOUND;
                                details = "Optional component: " + patchComponent.getName() + " version:" + patchComponent.getVersion() + " patch level: " + patchComponent.getPatchLevel() + " mismatched with OH version: " + compRef.getVersion() + " and patch level: " + compRef.getPatchLevel();
                            }
                        } else if (componentCheckResult.isProcessingNotRequired()) {
                            result = componentCheckResult;
                            details = "Component: " + patchComponent.getName() + " version:" + patchComponent.getVersion() + " patch level: " + patchComponent.getPatchLevel() + " is not required to process";
                        } else {
                            result = componentCheckResult;
                            details = "Component: " + patchComponent.getName() + " version:" + patchComponent.getVersion() + " patch level: " + patchComponent.getPatchLevel() + " is required to process";
                        }
                    }
                    if (!componentsWillBeProcessed && result.isProcessComponent()) {
                        componentsWillBeProcessed = true;
                    }
                    results.setResult(patchComponent, result, details);
                }
                OLogger.debug("PMReadServices:getPatchCheckResultsForApply " + details);
            }
            this.setMetaDataComponentResult(results, metaDataComponent, metaDataComponentResult, componentsWillBeProcessed);
        }
        return results;
    }

    private PatchCheckResults getPatchCheckResultsForRollback(Patch patch, CUPAdapter adpter, List<ComponentInfo> compsInInventoryRollback) {
        PatchCheckResults results = BasePatchFactory.instance().getPatchCheckResults(patch);
        OLogger.debug("IPMReadServices:getPatchCheckResultsForRollback begin");
        PatchSubType patchSubType = patch.getPatchSubType();
        List patchComponents = patch.getComponents();
        if (patchComponents != null && !patchComponents.isEmpty()) {
            PatchInventory.Component metaDataComponent = null;
            boolean componentsWillBeProcessed = false;
            ComponentCheckResult metaDataComponentResult = null;
            if (OPatchEnv.isCUP2Supported()) {
                metaDataComponentResult = adpter.checkResultForRollbackCUP2(patch, results);
            }
            for (PatchInventory.Component patchComponent : patchComponents) {
                String details = "";
                if ("oracle.nextgen.metadata".equals(patchComponent.getName())) {
                    metaDataComponent = patchComponent;
                } else {
                    Result result;
                    List<ComponentInfo> matchedNameInstalledComponents;
                    HashSet<ComponentInfo> compsInInventoryRollbackSet = null;
                    if (compsInInventoryRollback != null) {
                        compsInInventoryRollbackSet = new HashSet<ComponentInfo>(compsInInventoryRollback);
                    }
                    if ((matchedNameInstalledComponents = this.getMatchingComponentInInventory(patchComponent.getName(), compsInInventoryRollbackSet)).isEmpty()) {
                        if (patchComponent.isRequired().booleanValue()) {
                            result = Result.ERR_NOT_FOUND;
                            details = "Required component: " + patchComponent.getName() + " is not installed in oracle home";
                        } else {
                            result = Result.IGNORE_NOT_FOUND;
                            details = "Optional component: " + patchComponent.getName() + " is not installed in oracle home";
                        }
                    } else {
                        ComponentInfo matched = this.checkVersionAndPatchLevelForRollback(patchComponent, patchSubType, matchedNameInstalledComponents);
                        if (matched != null) {
                            if (patchSubType == PatchSubType.UPGRADE) {
                                if (matched.getRefCount() > 1) {
                                    result = Result.PROCESSING_NOT_REQUIRED;
                                    details = "The matched component " + patchComponent.getName() + " in CUP will not be rolled back, due do refcount > 1 ";
                                } else {
                                    result = Result.PROCESS_COMPONENT;
                                    details = "The matched component " + patchComponent.getName() + " in CUP will be rolled back, due do refcount = 1 ";
                                }
                            } else {
                                result = Result.PROCESS_COMPONENT;
                                details = "The matched component " + patchComponent.getName() + " in PLO/SDO will be rolled back ";
                            }
                        } else {
                            result = Result.VERSION_MISMATCH;
                            details = "No component in OH matched with component in patch for name,version, patch level";
                        }
                    }
                    if (!componentsWillBeProcessed && result.isProcessComponent()) {
                        componentsWillBeProcessed = true;
                    }
                    results.setResult(patchComponent, result, details);
                }
                OLogger.debug("PMReadServices:getPatchCheckResultsForRollback " + details);
            }
            this.setMetaDataComponentResult(results, metaDataComponent, metaDataComponentResult, componentsWillBeProcessed);
        }
        return results;
    }

    private void setMetaDataComponentResult(PatchCheckResults results, PatchInventory.Component metaDataComponent, ComponentCheckResult metaDataComponentResult, boolean componentsWillBeProcessed) {
        if (metaDataComponent != null) {
            Result resultFromOui;
            Result metaDataResult = null;
            String details = null;
            metaDataResult = componentsWillBeProcessed ? Result.PROCESS_COMPONENT : Result.PROCESSING_NOT_REQUIRED;
            if (metaDataComponentResult != null && metaDataComponentResult.getResult() != null && (resultFromOui = metaDataComponentResult.getResult()).isHigherPrecedence(metaDataResult)) {
                metaDataResult = resultFromOui;
                details = metaDataComponentResult.getDetails();
                OLogger.justlog(OLogger.WARNING, "MetaData Result: " + metaDataResult + "Details: " + details);
            }
            results.setResult(metaDataComponent, metaDataResult, details);
        }
    }

    private ComponentInfo checkVersionAndPatchLevelForRollback(PatchInventory.Component patchComponent, PatchSubType patchSubType, List<ComponentInfo> matchedNameInstalledComponents) {
        for (ComponentInfo c2 : matchedNameInstalledComponents) {
            PatchLevel plInPatch = PatchLevelFactory.createPatchLevelInstance(patchComponent.getPatchLevel());
            PatchLevel plInInv = PatchLevelFactory.createPatchLevelInstance(c2.getPatchLevel());
            if (!patchComponent.getVersion().equalsIgnoreCase(c2.getVersion())) continue;
            if (plInPatch != null && plInInv != null) {
                PatchLevelRelation plCompare = plInPatch.compare(plInInv);
                if (patchSubType == PatchSubType.UPGRADE && plCompare == PatchLevelRelation.SAME) {
                    return c2;
                }
                if (patchSubType != PatchSubType.UPDATE || plCompare != PatchLevelRelation.SAME && plCompare != PatchLevelRelation.LOWER) continue;
                return c2;
            }
            return c2;
        }
        return null;
    }

    private Result getResultBasedOnVersionAndPatchLevel(PatchInventory.Component patchComponent, ComponentInfo compInfoInv, PatchSubType patchSubType) {
        OLogger.debug("PMReadServices:getResultBasedOnVersionAndPatchLevel begin");
        Result result = Result.VERSION_MISMATCH;
        String compVersionInPatch = patchComponent.getVersion();
        if (compVersionInPatch.equals(compInfoInv.getVersion())) {
            String patchComponentPL = patchComponent.getPatchLevel();
            String compInfoInvPL = compInfoInv.getPatchLevel();
            if (compInfoInvPL == null || compInfoInvPL.equalsIgnoreCase("")) {
                if (patchSubType == PatchSubType.UPDATE) {
                    result = Result.VERSION_MISMATCH;
                    OLogger.debug("PMReadServices:getResultBasedOnVersionAndPatchLevel, PLO cannot be applied on top of component without patch level");
                } else {
                    return Result.PROCESS_COMPONENT;
                }
            }
            if (patchComponentPL == null || patchComponentPL.equalsIgnoreCase("")) {
                return Result.PROCESS_COMPONENT;
            }
            PatchLevel plInPatch = PatchLevelFactory.createPatchLevelInstance(patchComponent.getPatchLevel());
            PatchLevel plInInv = PatchLevelFactory.createPatchLevelInstance(compInfoInv.getPatchLevel());
            PatchLevelRelation plCompare = plInPatch.compare(plInInv);
            if (patchSubType == PatchSubType.UPGRADE) {
                if (plCompare == PatchLevelRelation.HIGHER || plCompare == PatchLevelRelation.DIFFERENT_BRANCH) {
                    result = Result.PROCESS_COMPONENT;
                    OLogger.debug("PMReadServices:getResultBasedOnVersionAndPatchLevel, component in CUP has higher or different branch patch level, go to process");
                } else if (plCompare == PatchLevelRelation.SAME) {
                    result = Result.PROCESSING_NOT_REQUIRED;
                    OLogger.debug("PMReadServices:getResultBasedOnVersionAndPatchLevel, component in CUP has the same patch level, process not required");
                } else {
                    result = Result.VERSION_MISMATCH;
                    OLogger.debug("PMReadServices:getResultBasedOnVersionAndPatchLevel, component in CUP has the lower patch level, error!");
                }
            } else if (patchSubType == PatchSubType.UPDATE) {
                if (plCompare == PatchLevelRelation.SAME || plCompare == PatchLevelRelation.LOWER) {
                    result = Result.PROCESS_COMPONENT;
                    OLogger.debug("PMReadServices:getResultBasedOnVersionAndPatchLevel, component in PLO has the same or lower patch level, go to process");
                } else {
                    result = Result.VERSION_MISMATCH;
                    OLogger.debug("PMReadServices:getResultBasedOnVersionAndPatchLevel, component in PLO has the higher or different patch level, error!");
                }
            }
        } else {
            result = Result.VERSION_MISMATCH;
            OLogger.debug("PMReadServices:getResultBasedOnVersionAndPatchLevel, component's version is not matched, error!");
        }
        return result;
    }

    private List<ComponentInfo> getMatchingComponentInInventory(String name, Set<ComponentInfo> components) {
        ArrayList<ComponentInfo> matches = new ArrayList<ComponentInfo>();
        if (name != null && components != null) {
            for (ComponentInfo comp : components) {
                if (comp == null || !name.equals(comp.getName())) continue;
                matches.add(comp);
            }
        }
        return matches;
    }

    private Set<PatchComponentInfoWrapper> getCompsInfoInPatch(Patch patchObjectInCommonAPI, PatchObject patchObject) {
        HashSet<PatchComponentInfoWrapper> result = new HashSet<PatchComponentInfoWrapper>();
        if (patchObjectInCommonAPI == null) {
            return result;
        }
        List compsInPatch = patchObjectInCommonAPI.getComponents();
        HomeOperationsFactory homeOpFactory = HomeOperationsFactory.getInstance();
        for (PatchInventory.Component c2 : compsInPatch) {
            ComponentInfo compInfoObj = homeOpFactory.getComponentInfo(c2.getName(), c2.getVersion());
            Map<Path, Path> patchFilesMap = this.getPatchFilesPath(patchObject, compInfoObj);
            result.add(WrapperFactory.getCommonApiWrapper().getPatchComponentInfoWrapper(compInfoObj, patchFilesMap));
        }
        return result;
    }

    private Map<Path, Path> getPatchFilesPath(PatchObject patchObject, ComponentInfo compInfoObj) {
        ICustomizedActionResults result;
        HashMap<Path, Path> patchFilesMap = new HashMap<Path, Path>();
        String patchlocation = patchObject.getPatchLocation();
        String oracleHomePath = OPatchEnv.getOracleHome();
        for (PatchComponent pc : patchObject.getPatchComponents()) {
            boolean matchedName = pc.getName().equals(compInfoObj.getName());
            boolean matchedVersion = pc.getVersion().equals(compInfoObj.getVersion());
            if (!matchedName || !matchedVersion) continue;
            for (PatchAction action : pc.getAllActions()) {
                ArrayList targetFiles = action.getFilesTouched(oracleHomePath);
                String source = "";
                if (action instanceof CopyAction) {
                    source = ((CopyAction)action).getSourceFile(patchlocation);
                }
                if (action instanceof JarAction) {
                    source = ((JarAction)action).getSourceFile(patchlocation);
                }
                Path ohFile = null;
                if (action instanceof JarActionEntity) {
                    String jarTouched = action.getParentFilePath(oracleHomePath);
                    ohFile = WrapperFactory.getNioServiceWrapper().getPath(jarTouched, new String[0]);
                } else {
                    String[] touchfile;
                    if (targetFiles == null || targetFiles.isEmpty() || (touchfile = (String[])targetFiles.get(0)) == null || touchfile.length <= 1 || touchfile[1].equals("")) continue;
                    ohFile = WrapperFactory.getNioServiceWrapper().getPath(touchfile[1], new String[0]);
                }
                patchFilesMap.put(ohFile, WrapperFactory.getNioServiceWrapper().getPath(source, new String[0]));
            }
        }
        if (patchObject.isSparseCopy() && (result = OPatchEnv.getMSIDCustomResults().get(patchObject.getPatchUniqID())) != null) {
            for (String file : result.getAddedFiles()) {
                patchFilesMap.put(WrapperFactory.getNioServiceWrapper().getPath(file, new String[0]), WrapperFactory.getNioServiceWrapper().getPath("", new String[0]));
            }
            for (String file : result.getRemoveFiles()) {
                patchFilesMap.put(WrapperFactory.getNioServiceWrapper().getPath(file, new String[0]), WrapperFactory.getNioServiceWrapper().getPath("", new String[0]));
            }
        }
        return patchFilesMap;
    }

    @Override
    public Map<PatchComponent, PatchComponentCheckResult> analyzePatchComponents(PatchObject patchObject, boolean rollback) {
        Map<PatchComponent, PatchComponentCheckResult> result;
        String cachekey = patchObject.getPatchUniqID() + "_" + patchObject.getPatchID();
        Map<PatchComponent, PatchComponentCheckResult> map = result = rollback ? rollbackAnalyzedPatches.get(cachekey) : applyAnalyzedPatches.get(cachekey);
        if (result != null) {
            return result;
        }
        result = new HashMap<PatchComponent, PatchComponentCheckResult>();
        if (OPatchEnv.isCUPSupported() && !OPatchEnv.isSnowBall()) {
            PatchCheckResults pcr = this.getPatchCheckResults(patchObject, rollback);
            Map ccr = pcr.getComponentCheckResults();
            ArrayList<PatchComponent> processComps = new ArrayList<PatchComponent>();
            HashMap<String, ArrayList<PatchComponent>> lookupMap = new HashMap<String, ArrayList<PatchComponent>>();
            for (PatchComponent pc : patchObject.getPatchComponents()) {
                ArrayList<PatchComponent> pcs = (ArrayList<PatchComponent>)lookupMap.get(pc.getName() + "_" + pc.getVersion());
                if (pcs == null) {
                    pcs = new ArrayList<PatchComponent>();
                    pcs.add(pc);
                    lookupMap.put(pc.getName() + "_" + pc.getVersion(), pcs);
                    continue;
                }
                pcs.add(pc);
            }
            for (Map.Entry entry : ccr.entrySet()) {
                PatchInventory.Component comp = (PatchInventory.Component)entry.getKey();
                List pcs = (List)lookupMap.get(comp.getName() + "_" + comp.getVersion());
                ComponentCheckResult cResult = (ComponentCheckResult)entry.getValue();
                if (pcs != null) {
                    if (cResult.getResult().isProcessComponent()) {
                        processComps.addAll(pcs);
                        continue;
                    }
                    for (PatchComponent pc : pcs) {
                        result.put(pc, this.toPatchComponentCheckResult(cResult, pc));
                    }
                    continue;
                }
                CUPPatchComponent cupComponent = new CUPPatchComponent(comp);
                result.put(cupComponent, this.toPatchComponentCheckResult(cResult, cupComponent));
            }
            Map<PatchComponent, PatchComponentCheckResult> furtherProcessedComps = this.getPatchComponentExtraCheckResults(processComps);
            result.putAll(furtherProcessedComps);
        } else {
            PatchComponent[] pcs = patchObject.getPatchComponents();
            if (pcs != null) {
                List<PatchComponent> pcsAsList = Arrays.asList(pcs);
                result = this.getPatchComponentCheckResults(pcsAsList);
            }
        }
        if (rollback) {
            rollbackAnalyzedPatches.put(cachekey, result);
        } else {
            applyAnalyzedPatches.put(cachekey, result);
        }
        return result;
    }

    private PatchComponentCheckResult toPatchComponentCheckResult(ComponentCheckResult cResult, PatchComponent pc) {
        PatchComponentCheckResultImpl pcResult = new PatchComponentCheckResultImpl(pc);
        pcResult.setResult(cResult.getResult());
        if (pcResult.getResult().isNotEvaluated()) {
            pcResult.setDetails(OLogger.getString("OUI-67401", new Object[]{pc.getID(), pc.getVersion()}));
        } else if (pcResult.getResult().isErrNotFound()) {
            pcResult.setDetails(OLogger.getString("OUI-67402", new Object[]{pc.getID(), pc.getVersion()}));
        } else if (pcResult.getResult().isIgnoreNotFound()) {
            pcResult.setDetails(OLogger.getString("OUI-67403", new Object[]{pc.getID(), pc.getVersion()}));
        } else if (pcResult.getResult().isProcessComponent()) {
            pcResult.setDetails(OLogger.getString("OUI-67405", new Object[]{pc.getID(), pc.getVersion()}));
        } else if (pcResult.getResult().isProcessingNotRequired()) {
            pcResult.setDetails(OLogger.getString("OUI-67406", new Object[]{pc.getID(), pc.getVersion()}));
        } else if (pcResult.getResult().isMetaDataError()) {
            pcResult.setDetails(cResult.getDetails());
        } else {
            pcResult.setDetails(OLogger.getString("OUI-67404", new Object[]{pc.getID(), pc.getVersion()}));
        }
        return pcResult;
    }

    @Override
    public Map<PatchComponent, PatchComponentCheckResult> analyzeRequiredPatchComponents(PatchObject patchObject, boolean rollback) {
        Map<PatchComponent, PatchComponentCheckResult> analyzed = this.analyzePatchComponents(patchObject, rollback);
        HashMap<PatchComponent, PatchComponentCheckResult> result = new HashMap<PatchComponent, PatchComponentCheckResult>();
        for (Map.Entry<PatchComponent, PatchComponentCheckResult> entry : analyzed.entrySet()) {
            if (!entry.getKey().isRequired()) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    @Override
    public Map<PatchComponent, PatchComponentCheckResult> analyzeOptionalPatchComponents(PatchObject patchObject, boolean rollback) {
        Map<PatchComponent, PatchComponentCheckResult> analyzed = this.analyzePatchComponents(patchObject, rollback);
        HashMap<PatchComponent, PatchComponentCheckResult> result = new HashMap<PatchComponent, PatchComponentCheckResult>();
        for (Map.Entry<PatchComponent, PatchComponentCheckResult> entry : analyzed.entrySet()) {
            if (entry.getKey().isRequired()) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    @Override
    public Map<PatchObject, Map<PatchComponent, PatchComponentCheckResult>> analyzePatchComponents(List<PatchObject> patchObjs, boolean rollback) {
        HashMap<PatchObject, Map<PatchComponent, PatchComponentCheckResult>> result = new HashMap<PatchObject, Map<PatchComponent, PatchComponentCheckResult>>();
        if (patchObjs == null || patchObjs.size() == 0) {
            return result;
        }
        for (PatchObject patchObj : patchObjs) {
            result.put(patchObj, this.analyzePatchComponents(patchObj, rollback));
        }
        return result;
    }

    private Set<String> getProductDirectories(String symbol) throws RuntimeException {
        Collection distributions;
        StringBuffer buff = new StringBuffer("IPMReadServices::getProductDirectories()");
        HashSet<String> productDirectories = new HashSet<String>();
        OracleHomeInventory gdrInv = null;
        try {
            gdrInv = NGOUIInventoryFactory.getOracleHomeInventory(this.getRawInventory().getOracleHomePath());
        }
        catch (Exception e2) {
            buff = new StringBuffer("IPMReadServices::getProductDirectories() can't get the GDR inventory.");
            OLogger.debug(buff);
            throw new RuntimeException(buff.toString(), e2);
        }
        try {
            distributions = gdrInv.getInstalledDistributions();
        }
        catch (Exception e3) {
            buff = new StringBuffer("IPMReadServices::getProductDirectories() failed to get installed distributions.");
            OLogger.debug(buff);
            throw new RuntimeException(buff.toString(), e3);
        }
        for (Distribution distribution : distributions) {
            List mappings;
            DirectoryMap directoryMap = distribution.getDirectoryMap();
            try {
                mappings = directoryMap.getMappings(new String[]{symbol});
            }
            catch (Exception e4) {
                buff = new StringBuffer("IPMReadServices::getProductDirectories() failed to get symbol mappings.");
                OLogger.debug(buff);
                throw new RuntimeException(buff.toString(), e4);
            }
            if (mappings == null || mappings.isEmpty()) continue;
            for (Mapping mapping : mappings) {
                productDirectories.add(mapping.getDirectory());
            }
        }
        return productDirectories;
    }

    @Override
    public OneOffEntry[] getInstalledPatches() throws RuntimeException {
        return this.getCookedInventory().getInstalledPatches();
    }

    @Override
    public OneOffEntry[] getAllInstalledPatches() throws RuntimeException {
        return this.getCookedInventory().getAllInstalledPatches();
    }

    @Override
    public OneOffEntry[] getInactivePatches() throws RuntimeException {
        return this.getCookedInventory().getInactivePatches();
    }

    @Override
    public InstalledComponent[] getInstalledComponents() throws RuntimeException {
        return this.getCookedInventory().getInstalledComponents();
    }

    @Override
    public InstalledComponent[] getTopLevelInstalledComponents() throws RuntimeException {
        return this.getCookedInventory().getTopLevelInstalledComponents();
    }

    @Override
    public boolean isDesiredHome() throws RuntimeException {
        return this.getCookedInventory().isDesiredHome();
    }

    @Override
    public InstalledComponent[] getNextGenInstalledDistributions() {
        return this.getCookedInventory().getNextGenInstalledDistributions();
    }

    @Override
    public InstalledComponent[] getNextGenInstalledComponents() {
        return this.getCookedInventory().getNextGenInstalledComponents();
    }

    @Override
    public Vector getHomes() throws RuntimeException {
        return this.getRawInventory().getHomes();
    }

    @Override
    public String getGUID(String oracleHomePath) throws RuntimeException {
        return this.getRawInventory().getGUID(oracleHomePath);
    }

    @Override
    public OPatchSDK.OracleHome[] getOracleHomes() throws RuntimeException {
        return this.getRawInventory().getOracleHomes();
    }

    @Override
    public boolean isOracleHomeInfoExist() throws RuntimeException {
        return this.getRawInventory().isOracleHomeInfoExist();
    }

    @Override
    public boolean isCRSHome() throws RuntimeException {
        return this.getRawInventory().isCRSHome();
    }

    @Override
    public String getOracleHomeName() throws RuntimeException {
        return this.getRawInventory().getOracleHomeName();
    }

    @Override
    public String getLocalNode() throws RuntimeException {
        int dotPos;
        if (!localnode.equals("")) {
            return localnode;
        }
        localnode = IPMUtil.getLocalHostName(false);
        if (!localnode.equals("") && (dotPos = localnode.indexOf(46)) != -1) {
            localnode = localnode.substring(0, dotPos);
        }
        return localnode;
    }

    @Override
    public Integer getARUID() throws RuntimeException {
        return this.getRawInventory().getARUID();
    }

    @Override
    public String getARUIDDescription() throws RuntimeException {
        return this.getRawInventory().getARUIDDescription();
    }

    @Override
    public String getLocation() throws RuntimeException {
        return this.getRawInventory().getLocation();
    }

    protected Integer getIndex() throws RuntimeException {
        this.getRawInventory();
        return RawInventory.getIndex();
    }

    @Override
    public String getAdditionalOracleHomeProperty(String propertyName) throws RuntimeException {
        return this.getRawInventory().getAdditionalOracleHomeProperty(propertyName);
    }

    @Override
    public boolean isCRSHomePresent() throws RuntimeException {
        OiiiOracleHomeInfo home = this.getCRSHome();
        return home != null;
    }

    @Override
    public String findCRSHomeLocation() throws RuntimeException {
        OiiiOracleHomeInfo home = this.getCRSHome();
        if (home != null) {
            return home.getLocation();
        }
        return null;
    }

    @Override
    public String findCRSHomeName() throws RuntimeException {
        OiiiOracleHomeInfo home = this.getCRSHome();
        if (home != null) {
            return home.getName();
        }
        return null;
    }

    private OiiiOracleHomeInfo getCRSHome() {
        Vector homes = this.getHomes();
        for (int i2 = 0; i2 < homes.size(); ++i2) {
            OiiiOracleHomeInfo home = (OiiiOracleHomeInfo)homes.get(i2);
            if (!home.isCRSHome()) continue;
            return home;
        }
        return null;
    }

    @Override
    public String findGridHomeLocation() throws RuntimeException {
        Vector homes = this.getHomes();
        for (int i2 = 0; i2 < homes.size(); ++i2) {
            OiiiOracleHomeInfo home = (OiiiOracleHomeInfo)homes.get(i2);
            if (!IPMUtil.isGridHome(home.getLocation())) continue;
            return home.getLocation();
        }
        return null;
    }

    @Override
    public boolean isGridHome(String oracleHomePath) throws RuntimeException {
        Vector homes = this.getHomes();
        for (Object home : homes) {
            OiiiOracleHomeInfo oh = (OiiiOracleHomeInfo)home;
            if (!oh.getLocation().equals(oracleHomePath) || !IPMUtil.isGridHome(oracleHomePath)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getOracleHomePath() throws RuntimeException {
        return this.getRawInventory().getOracleHomePath();
    }

    @Override
    public String getXMLInvLocation(String patchID) throws RuntimeException {
        return this.getRawInventory().getXMLInvLocation(patchID);
    }

    @Override
    public OneOffEntry getLatestTranslationPatch(String patchID, String language) throws RuntimeException {
        OneOffEntry[] oneoffList = this.getInstalledPatches();
        for (int i2 = 0; i2 < oneoffList.length; ++i2) {
            String origPatchID = oneoffList[i2].getPatchID();
            String oneOffLanguage = oneoffList[i2].getPatchLanguage();
            if (!oneoffList[i2].couldBeTranslation() || !oneOffLanguage.equals(language) || !origPatchID.equals(patchID)) continue;
            return oneoffList[i2];
        }
        return null;
    }

    private static boolean checkIfMiniPatchsetFunctional() {
        if (OPatchEnv.isNextGen()) {
            return false;
        }
        try {
            Class<?> chkClass = Class.forName("oracle.sysman.oii.oiii.OiiiInstallMiniPatchsetInvEntry");
            if (chkClass != null) {
                chkClass = Class.forName("oracle.sysman.oii.oiii.OiiiInstallInventory");
                Method[] methods = chkClass.getMethods();
                boolean foundFlag = false;
                for (int i2 = 0; i2 < methods.length; ++i2) {
                    if (!methods[i2].getName().equals("isComponentInPatchSetUpdate")) continue;
                    foundFlag = true;
                    break;
                }
                return foundFlag;
            }
            return false;
        }
        catch (ClassNotFoundException e2) {
            return false;
        }
    }

    @Override
    public OneOffEntry getPatchFromInv(String patchID, String upi) throws RuntimeException {
        OneOffEntry[] oneoffList = this.getInstalledPatches();
        for (int i2 = 0; i2 < oneoffList.length; ++i2) {
            if (!oneoffList[i2].getPSENumber().equals(upi) || !oneoffList[i2].getID().equals(patchID)) continue;
            return oneoffList[i2];
        }
        return null;
    }

    @Override
    public void populatePatchInventoryAndComps(String oracleHome, String patchID, PatchInventory patchInventory, LinkedList compsList) throws RuntimeException {
        OiiiInstallOneoffInvEntry oEntry = null;
        try {
            oEntry = this.getRawInventory().getOneoffInvEntry(patchID, new Vector(), "", this.getRawInventory().getOracleHomeName());
        }
        catch (Exception e2) {
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        Vector bugsFixedVector = oEntry.getBugs();
        for (int bIter = 0; bIter < bugsFixedVector.size(); ++bIter) {
            Bug bug = new Bug((String)bugsFixedVector.get(bIter), "No description available.");
            patchInventory.bugsToFix.add(bug);
        }
        patchInventory.patchID = patchID;
        patchInventory.setCreationTime("", "", "", "", "");
        patchInventory.setRawCreationDate("");
        patchInventory.setFormatCreationDate("");
        Platform platform = new Platform("Generic", "0");
        patchInventory.supportedPlatforms.add(platform);
        Vector files = oEntry.getFilesPatched();
        PatchComponent patchComp = new PatchComponent("Unknown", "0.0", true);
        for (int j2 = 0; j2 < files.size(); ++j2) {
            OiiiFileMapFileEntry entry = (OiiiFileMapFileEntry)files.get(j2);
            String child = entry.getFilePath();
            String parent = entry.getOwnerFilePath();
            String parentDirPath = entry.getParentDirPath();
            StringBuffer buff = null;
            if (parent != null) {
                buff = new StringBuffer("Processing entry - Parent :");
                buff.append(parent);
                buff.append("   child :\n");
                buff.append(child);
                OLogger.debug(buff);
                if (parent.endsWith(fileSeparator)) {
                    parent = parent.substring(0, parent.length() - 1);
                }
                int index = parent.lastIndexOf(fileSeparator);
                String name = "";
                String path = "";
                if (index != -1) {
                    name = parent.substring(index + 1);
                    path = parent.substring(oracleHome.length(), index);
                }
                if (!child.startsWith(fileSeparator)) {
                    child = fileSeparator + child;
                }
                String childName = path + fileSeparator + name + child;
                try {
                    buff = new StringBuffer("Adding entry; ");
                    buff.append("name: \"");
                    buff.append(name);
                    buff.append("\" path: \"");
                    buff.append(path);
                    buff.append("\" child: \"");
                    buff.append(childName);
                    buff.append("\"\n");
                    OLogger.printlnOnLog(buff.toString());
                    if (childName.endsWith("o") && name.endsWith("a")) {
                        ArchiveAction aa = new ArchiveAction(null, name, path, childName, j2);
                        aa.setBuiltFrom101Home(true);
                        patchComp.archiveList.add(aa);
                        continue;
                    }
                    JarAction ja = new JarAction(null, name, path, childName, j2);
                    ja.setBuiltFrom101Home(true);
                    patchComp.jarList.add(ja);
                    continue;
                }
                catch (Exception e3) {
                    RuntimeException re = new RuntimeException(e3.getMessage());
                    re.setStackTrace(e3.getStackTrace());
                    throw re;
                }
            }
            if (parentDirPath != null) {
                int index;
                buff = new StringBuffer("Processing entry - ParentDirPath : ");
                buff.append(parentDirPath);
                buff.append("   child : ");
                buff.append(child);
                OLogger.debug(buff);
                String name = "";
                String path = parentDirPath;
                if (child.endsWith(fileSeparator)) {
                    child = child.substring(0, child.length() - 1);
                }
                if ((index = child.lastIndexOf(fileSeparator)) != -1) {
                    name = child.substring(index + 1);
                }
                String fileName = path + fileSeparator + name;
                try {
                    buff = new StringBuffer("Adding entry; ");
                    buff.append("name: \"");
                    buff.append(name);
                    buff.append("\" path: \"");
                    buff.append(path);
                    buff.append("\" fileName: \"");
                    buff.append(fileName);
                    buff.append("\"\n");
                    OLogger.printlnOnLog(buff.toString());
                    CopyAction ca = new CopyAction(null, name, path, fileName, j2);
                    ca.setBuiltFrom101Home(true);
                    patchComp.copyList.add(ca);
                    continue;
                }
                catch (Exception e4) {
                    RuntimeException re = new RuntimeException(e4.getMessage());
                    re.setStackTrace(e4.getStackTrace());
                    throw re;
                }
            }
            RuntimeException re = new RuntimeException("Unable to get the files touched entry properly.");
            throw re;
        }
        compsList.add(patchComp);
    }

    @Override
    public boolean isInventoryLoaded() {
        return rawInventory != null;
    }

    @Override
    public void loadInventory(String oracleHomePath) throws RuntimeException {
        if (rawInventory != null && !this.getOracleHomePath().equals(oracleHomePath)) {
            StringBuffer buff = new StringBuffer("IPMReadServices::loadInventory() is called for different OH");
            OLogger.debug(buff);
            rawInventory = null;
            cookedInventory = null;
            if (applyPatchCheckResultsMap != null) {
                applyPatchCheckResultsMap.clear();
                applyPatchCheckResultsMap = new HashMap<String, PatchCheckResults>();
            }
            if (rollbackPatchCheckResultsMap != null) {
                rollbackPatchCheckResultsMap.clear();
                rollbackPatchCheckResultsMap = new HashMap<String, PatchCheckResults>();
            }
            if (applyAnalyzedPatches != null) {
                applyAnalyzedPatches.clear();
                applyAnalyzedPatches = new HashMap<String, Map<PatchComponent, PatchComponentCheckResult>>();
            }
            if (rollbackAnalyzedPatches != null) {
                rollbackAnalyzedPatches.clear();
                rollbackAnalyzedPatches = new HashMap<String, Map<PatchComponent, PatchComponentCheckResult>>();
            }
        }
        this.getRawInventory();
    }

    @Override
    public OneOffEntry[] getInactivePSUTrain() throws RuntimeException {
        return this.getCookedInventory().getInactivePSUTrain();
    }

    @Override
    public OneOffEntry[] getInstalledPatchesIncludeInactive() throws RuntimeException {
        return this.getCookedInventory().getInstalledPatchesIncludeInactive();
    }

    public static void destroyObject() {
        applyAnalyzedPatches.clear();
        applyPatchCheckResultsMap.clear();
        rollbackAnalyzedPatches.clear();
        rollbackPatchCheckResultsMap.clear();
        cookedInventory = null;
        rawInventory = null;
        instance = null;
        CUPAdapter.clear();
    }

    @Override
    public HomeOperationsExt getHomeOperations() {
        return homeOperations;
    }

    @Override
    public void setHomeOperations(HomeOperationsExt homeOp) {
        homeOperations = homeOp;
    }

    @Override
    public HashMap<IPatch, NPatchRelations> getRelationsMap() throws RuntimeException {
        CookedInventory cook = this.getCookedInventory();
        return cook.getRelationsMap();
    }
}

