/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.ipm;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import oracle.opatch.OPatchEnv;
import oracle.opatch.ipm.OUIInventorySession;
import oracle.opatch.ipm.OUISessionManager;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.wrappers.WrapperFactory;
import oracle.sysman.nextgen.inventory.OracleHomeInventoryHelper;

public class OHILock {
    private static OHILock instance = null;
    private static OUIInventorySession ouiSession = null;
    private static String instanceOHPath = null;
    private boolean isWriterLock = false;
    private static boolean isNextGen = false;

    private OHILock(String oracleHomePath, OUIInventorySession iSession, boolean isNG, boolean isWriter) {
        instanceOHPath = oracleHomePath;
        ouiSession = iSession;
        isNextGen = isNG;
        this.isWriterLock = isWriter;
    }

    public static OHILock lock(String oracleHomePath, boolean isReadOnly) throws Throwable {
        if (OHILock.isOracleHomeValid(oracleHomePath)) {
            OUIInventorySession iSession = null;
            boolean isNextGen = OHILock.isNextGenLockSupported();
            boolean isWriter = false;
            if (isReadOnly) {
                iSession = OHILock.grabReaderLock(oracleHomePath, isNextGen);
            } else {
                iSession = OHILock.grabWriterLock(oracleHomePath, isNextGen);
                isWriter = true;
            }
            instance = new OHILock(oracleHomePath, iSession, isNextGen, isWriter);
        }
        return instance;
    }

    private static OUIInventorySession grabReaderLock(String oracleHomePath, boolean isNextGen) throws Throwable {
        if (isNextGen) {
            try {
                OracleHomeInventoryHelper.grabReaderLock((String)oracleHomePath);
            }
            catch (Throwable e2) {
                OLogger.debug(new StringBuffer("OHILock::grabReaderLock() unable to acquire OHI RO lock."));
                throw e2;
            }
        }
        ouiSession = OUISessionManager.getOUIInventorySession(true, OPatchEnv.getCallerVersion(), oracleHomePath);
        return ouiSession;
    }

    private static OUIInventorySession grabWriterLock(String oracleHomePath, boolean isNextGen) throws Throwable {
        if (isNextGen) {
            try {
                OracleHomeInventoryHelper.grabWriterLock((String)oracleHomePath);
                ouiSession = OUISessionManager.getOUIInventorySession(true, OPatchEnv.getCallerVersion(), oracleHomePath);
                OLogger.printlnOnLog("[LOCK INFO] : OHILOCK GRABWRITERLOCK USING NGAPI ORACLEHOMEINVENTORYHELPER.GRABWRITERLOCK()");
            }
            catch (Throwable e2) {
                OLogger.debug(new StringBuffer("OHILock::grabReaderLock() unable to acquire OHI RW lock."));
                throw e2;
            }
        } else {
            ouiSession = OUISessionManager.getOUIInventorySession(false, OPatchEnv.getCallerVersion(), oracleHomePath);
        }
        return ouiSession;
    }

    public void release() {
        if (instance != null) {
            if (isNextGen) {
                if (this.isWriterLock) {
                    OLogger.printlnOnLog("[LOCK INFO] : OHILOCK RELEASEWRITERLOCK ");
                    OracleHomeInventoryHelper.releaseWriterLock((String)instanceOHPath);
                } else {
                    OracleHomeInventoryHelper.releaseReaderLock((String)instanceOHPath);
                }
            }
            OUISessionManager.endSavedSession();
            ouiSession = null;
            instanceOHPath = null;
        }
    }

    protected OUIInventorySession getCurrentOUISession() {
        return ouiSession;
    }

    protected String getOracleHomePath() {
        return instanceOHPath;
    }

    protected boolean isWriterLock() {
        return this.isWriterLock;
    }

    private static boolean isOracleHomeValid(String oracleHomePath) throws NullPointerException, IllegalArgumentException {
        if (oracleHomePath == null || oracleHomePath.equals("")) {
            throw new NullPointerException("OHILocker::isOracleHomeValid() got a null oracleHomePath");
        }
        Path testHome = WrapperFactory.getNioServiceWrapper().getPath(oracleHomePath, new String[0]);
        if (!Files.exists(testHome, new LinkOption[0])) {
            throw new IllegalArgumentException("The given Oracle Home path \"" + oracleHomePath + "\" does not exist.");
        }
        return true;
    }

    private static boolean isNextGenLockSupported() {
        if (OPatchEnv.isNextGen()) {
            try {
                Class<?> chkClass = Class.forName("oracle.sysman.nextgen.inventory.OracleHomeInventoryHelper");
                return true;
            }
            catch (ClassNotFoundException e2) {
                return false;
            }
        }
        return false;
    }
}

