/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.ipm;

import java.io.IOException;
import oracle.opatch.OPatchEnv;
import oracle.opatch.ROSessionException;
import oracle.opatch.RWSessionException;
import oracle.opatch.ipm.OUIInventorySession;
import oracle.opatch.opatchlogger.OLogger;
import oracle.sysman.oii.oiii.OiiiInventoryDoesNotExistException;
import oracle.sysman.oii.oiit.OiitTargetLockNotAvailableException;

public class OUISessionManager {
    private static OUISessionManager instance = null;
    private static OUIInventorySession inventorySession = null;
    private static boolean isROinit = false;
    private static boolean isRWinit = false;

    private OUISessionManager() {
    }

    private static void instantiate(boolean isReadOnly, String opatchVersion, String oracleHomePath) throws NullPointerException, RuntimeException {
        StringBuffer msg = new StringBuffer("OUISessionManager::instantiate()");
        OLogger.debug(msg);
        OUIInventorySession invSession = OUISessionManager.setupCISession(isReadOnly, opatchVersion, oracleHomePath);
        if (invSession == null) {
            msg = new StringBuffer("OUISessionManager::instantiate() gets a null OUIInventorySession object");
            OLogger.debug(msg);
            NullPointerException e2 = new NullPointerException(msg.toString());
            throw e2;
        }
        OUISessionManager.setInventorySession(invSession);
    }

    private static OUIInventorySession createAndInitCISession(boolean isReadOnly, String opatchVersion, String oracleHomePath) throws OiiiInventoryDoesNotExistException, OiitTargetLockNotAvailableException, IOException, Exception, Throwable {
        StringBuffer buff = new StringBuffer("OUISessionManager::createAndInitCISession()");
        OLogger.debug(buff);
        OUIInventorySession invSession = null;
        try {
            buff = new StringBuffer("OUISessionManager::createAndInitCISession() instantiates a OUIInventorySession obj.");
            OLogger.debug(buff);
            invSession = new OUIInventorySession(opatchVersion);
            buff = new StringBuffer("OUISessionManager::createAndInitCISession() init the session");
            OLogger.debug(buff);
            if (isReadOnly) {
                if (OUISessionManager.isReadLocklessSupported(opatchVersion)) {
                    try {
                        OLogger.debug(new StringBuffer("OUISessionManager::createAndInitCISession() sets up READ-ONLY LOCKLESS session"));
                        invSession.initSession(2);
                    }
                    catch (RuntimeException ex) {
                        OLogger.debug(new StringBuffer("Exception in setting LOCKLESS session. OUISessionManager::createAndInitCISession() sets up READ-ONLY session"));
                        invSession.initSession(0);
                    }
                } else {
                    OLogger.debug(new StringBuffer("OUISessionManager::createAndInitCISession() sets up READ-ONLY session"));
                    invSession.initSession(0);
                }
                OUISessionManager.setROinit(true);
            } else {
                if (OPatchEnv.isParallelPatching()) {
                    OLogger.debug(new StringBuffer("OUISessionManager::createAndInitCISession() sets up OPATCH READ-WRITE session"));
                    invSession.initOPatchWriteSession(oracleHomePath);
                } else {
                    OLogger.debug(new StringBuffer("OUISessionManager::createAndInitCISession() sets up READ-WRITE session"));
                    invSession.initSession(1);
                }
                OUISessionManager.setRWinit(true);
            }
        }
        catch (OiiiInventoryDoesNotExistException e2) {
            OLogger.debug(new StringBuffer("OUISessionManager::createAndInitCISession() throws OiiiInventoryDoesNotExistException"));
            throw e2;
        }
        catch (OiitTargetLockNotAvailableException e3) {
            OLogger.debug(new StringBuffer("OUISessionManager::createAndInitCISession() throws OiitTargetLockNotAvailableException"));
            throw e3;
        }
        catch (IOException e4) {
            OLogger.debug(new StringBuffer("OUISessionManager::createAndInitCISession() throws IOException"));
            throw e4;
        }
        catch (Exception e5) {
            OLogger.debug(new StringBuffer("OUISessionManager::createAndInitCISession() throws Exception"));
            throw e5;
        }
        catch (Throwable e6) {
            OLogger.debug(new StringBuffer("OUISessionManager::createAndInitCISession() throws Throwable"));
            throw e6;
        }
        finally {
            OLogger.debug(new StringBuffer("OUISessionManager::createAndInitCISession() done"));
        }
        return invSession;
    }

    private static OUIInventorySession setupCISession(boolean readOnly, String opatchVersion, String oracleHomePath) throws RuntimeException {
        OUIInventorySession invSession = null;
        int retry = OPatchEnv.getRetry();
        int delay = OPatchEnv.getDelay();
        boolean isRetry = OPatchEnv.isRetry();
        StringBuffer buff = new StringBuffer("setupCISession()");
        if (OUISessionManager.getInventorySession() == null) {
            if (isRetry) {
                buff.append(": ");
                buff.append("OUISessionManager::setupCISession() will retry ");
                buff.append(retry);
                buff.append(" times with ");
                buff.append(delay);
                buff.append("-second interval to get an Inventory lock.");
                OLogger.debug(buff);
            } else {
                OLogger.debug(new StringBuffer("OUISessionManager::setupCISession() has no retry getting an Inventory lock."));
            }
            int count = 0;
            String question = OLogger.getString("OUI-67126");
            long startTime = System.currentTimeMillis();
            int maxWait = OPatchEnv.getMaxLockingWait();
            do {
                try {
                    buff = new StringBuffer("OUISessionManager::setupCISession() try round # ");
                    buff.append(++count);
                    OLogger.debug(buff);
                    invSession = OUISessionManager.createAndInitCISession(readOnly, opatchVersion, oracleHomePath);
                    if (invSession == null) continue;
                    OLogger.debug(new StringBuffer("OUISessionManager::setupCISession() set up session OK"));
                    break;
                }
                catch (OiiiInventoryDoesNotExistException e2) {
                    String msg = OLogger.getString("OUI-67131");
                    RuntimeException re = new RuntimeException(msg);
                    re.setStackTrace(e2.getStackTrace());
                    throw re;
                }
                catch (UnsupportedOperationException e3) {
                    RuntimeException re = new RuntimeException(e3.getMessage());
                    re.setStackTrace(e3.getStackTrace());
                    throw re;
                }
                catch (Exception e4) {
                    if (isRetry) {
                        if (--retry < 0) {
                            isRetry = false;
                            RuntimeException re = new RuntimeException(e4.getMessage());
                            re.setStackTrace(e4.getStackTrace());
                            throw re;
                        }
                        long now = System.currentTimeMillis();
                        int sofarInSecond = (int)((now - startTime) / 1000L);
                        buff = new StringBuffer("  locking starts at ");
                        buff.append(startTime);
                        buff.append(", now is ");
                        buff.append(now);
                        buff.append(", ");
                        buff.append(sofarInSecond);
                        buff.append(" seconds has gone by.");
                        OLogger.debug(buff);
                        if (sofarInSecond >= maxWait) {
                            buff = new StringBuffer("Cannot lock inventory.  Total retry time has exceeded ");
                            buff.append(maxWait);
                            buff.append(" seconds allowed.");
                            RuntimeException re = new RuntimeException(buff.toString());
                            re.setStackTrace(e4.getStackTrace());
                            buff.append(" Locking started at ");
                            buff.append(startTime);
                            buff.append(" and now is ");
                            buff.append(now);
                            buff.append(" (");
                            buff.append(sofarInSecond);
                            buff.append(" seconds has passed)");
                            OLogger.debug(buff);
                            throw re;
                        }
                        buff = new StringBuffer(question);
                        boolean proceed = OPatchEnv.proceedWithOperationDefaultYes(buff);
                        if (!proceed) {
                            String msg = OLogger.getString("OUI-67127");
                            RuntimeException re = new RuntimeException(msg);
                            throw re;
                        }
                        OLogger.info("OUI-67220");
                        try {
                            buff = new StringBuffer("OUISessionManager::load() failed to set up Session.  Gonna sleep for ");
                            buff.append(delay);
                            buff.append(" seconds.");
                            OLogger.debug(buff);
                            Thread.sleep(delay * 1000);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    RuntimeException re = new RuntimeException(e4.getMessage());
                    re.setStackTrace(e4.getStackTrace());
                    throw re;
                }
                catch (Throwable t) {
                    RuntimeException re = new RuntimeException(t.getMessage());
                    re.setStackTrace(t.getStackTrace());
                    throw re;
                }
            } while (isRetry);
        }
        if (invSession == null) {
            RuntimeException re = new RuntimeException("Null inventorySession from createCISession()");
            throw re;
        }
        return invSession;
    }

    public static synchronized OUIInventorySession getOUIInventorySession(boolean readOnly, String opatchVersion, String oracleHomePath) throws RuntimeException, ROSessionException, RWSessionException {
        StringBuffer buff = new StringBuffer("OUISessionManager::getInventorySession()");
        OLogger.debug(buff);
        buff = new StringBuffer("Caller Details: \n");
        buff.append("\tCaller Name : ");
        buff.append("OPatch");
        buff.append("\tCaller Version : ");
        buff.append(opatchVersion);
        buff.append("\tRequested Read-only access : ");
        buff.append(readOnly);
        OLogger.debug(buff);
        if (instance == null) {
            instance = new OUISessionManager();
        }
        if (readOnly) {
            if (OUISessionManager.getInventorySession() == null) {
                OUISessionManager.instantiate(readOnly, opatchVersion, oracleHomePath);
            } else if (OUISessionManager.isRWinit()) {
                RWSessionException re = new RWSessionException("Read-Write session is in progress");
                throw re;
            }
        } else if (OUISessionManager.getInventorySession() == null) {
            OUISessionManager.instantiate(readOnly, opatchVersion, oracleHomePath);
        } else {
            if (OUISessionManager.isROinit()) {
                ROSessionException re = new ROSessionException("Read-Only session is in progress");
                throw re;
            }
            if (OUISessionManager.isRWinit()) {
                RWSessionException re = new RWSessionException("Read-Write session is in progress");
                throw re;
            }
        }
        return OUISessionManager.getInventorySession();
    }

    public static void endSavedSession() {
        StringBuffer buff = new StringBuffer("OUISessionManager::endSavedSession()");
        OLogger.debug(buff);
        if (instance != null && OUISessionManager.getInventorySession() != null) {
            OLogger.debug(new StringBuffer("OUISessionManager::endSavedSession() end saved session"));
            OLogger.debug(buff);
            OUISessionManager.getInventorySession().endSession();
            OUISessionManager.setInventorySession(null);
            OUISessionManager.setROinit(false);
            OUISessionManager.setRWinit(false);
        }
    }

    private static boolean isReadLocklessSupported(String opatchVersion) {
        int i2;
        if ("n/a".equals(opatchVersion)) {
            return false;
        }
        String[] version = opatchVersion.split("\\.");
        String[] versionRef = new String[]{"12", "2"};
        boolean bigger = false;
        for (i2 = 0; i2 < 1 && version[i2].equals(versionRef[i2]); ++i2) {
        }
        int result = Integer.valueOf(version[i2]).compareTo(Integer.valueOf(versionRef[i2]));
        if (result >= 0) {
            bigger = true;
        }
        return bigger;
    }

    public static OUIInventorySession getInventorySession() {
        return inventorySession;
    }

    public static void setInventorySession(OUIInventorySession invSession) {
        inventorySession = invSession;
    }

    public static boolean isRWinit() {
        return isRWinit;
    }

    public static void setRWinit(boolean isRWinit) {
        OUISessionManager.isRWinit = isRWinit;
    }

    public static boolean isROinit() {
        return isROinit;
    }

    public static void setROinit(boolean isROinit) {
        OUISessionManager.isROinit = isROinit;
    }
}

