/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.ipm;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.opatch.HeapMemory;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSDK;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchingModel;
import oracle.opatch.ipm.IPMUtil;
import oracle.opatch.ipm.OUIInventorySession;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.wrappers.WrapperFactory;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInstallOneoffInvEntry;
import oracle.sysman.oii.oiii.OiiiOneoffException;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiix.OiixLanguage;

public class RawInventory {
    private static RawInventory instance = null;
    private static String fileSeparator = File.separator;
    private static String instanceOHPath = null;
    private static OiiiInstallInventory installInventory = null;
    private static OiiiInstallAreaControl installAreaControl = null;
    private static OiiiOracleHomeInfo oracleHomeInfo = null;
    private static Vector rawInstalledProducts = null;
    private static Vector rawOneOffList = null;
    private static final int LANG_DEFINED = 1;
    private static final int UID_DEFINED = 2;
    private static final int LANG_UID_DEFINED = 3;
    private static final int NO_LANG_UID_DEFINED = 4;

    private RawInventory(String oracleHomePath, OiiiInstallAreaControl iAreaControl, OiiiInstallInventory inventory, OiiiOracleHomeInfo homeInfo) {
        instanceOHPath = oracleHomePath;
        installInventory = inventory;
        oracleHomeInfo = homeInfo;
        installAreaControl = iAreaControl;
    }

    protected static synchronized RawInventory getInstance(String oracleHomePath, OUIInventorySession ouiSession, boolean forceReload) throws NullPointerException, Throwable {
        if (oracleHomePath == null || oracleHomePath.equals("")) {
            throw new NullPointerException("RawInventory::getInstance() got a null oracleHomePath");
        }
        if (instance == null || !oracleHomePath.equals(instanceOHPath) || forceReload) {
            Path testHome = WrapperFactory.getNioServiceWrapper().getPath(oracleHomePath, new String[0]);
            if (!Files.exists(testHome, new LinkOption[0])) {
                throw new IllegalArgumentException("The given Oracle Home path \"" + oracleHomePath + "\" does not exist.");
            }
            instance = RawInventory.init(oracleHomePath, ouiSession);
        }
        return instance;
    }

    private static RawInventory init(String oracleHomePath, OUIInventorySession ouiSession) throws Throwable {
        RawInventory newInstance = null;
        StringBuffer buff = new StringBuffer("RawInventory::init()");
        OLogger.debug(buff);
        OiiiInstallAreaControl installAreaControl = null;
        OiiiInstallInventory inventory = null;
        try {
            if (ouiSession == null) {
                StringBuffer msg = new StringBuffer("CentralInventory::init() gets a null OUIInventorySession object");
                OLogger.debug(msg);
                NullPointerException e2 = new NullPointerException(msg.toString());
                throw e2;
            }
            OLogger.debug(new StringBuffer("CentralInventory::init() gets OiiiInstallAreaControl object"));
            installAreaControl = ouiSession.getInstallAreaControl();
            if (installAreaControl == null) {
                StringBuffer msg = new StringBuffer("CentralInventory::init() gets a null OiiiInstallAreaControl object");
                OLogger.debug(msg);
                NullPointerException e3 = new NullPointerException(msg.toString());
                throw e3;
            }
            OLogger.debug(new StringBuffer("CentralInventory::init() gets OiiiInstallInventory object"));
            inventory = installAreaControl.getInstallInventory();
            if (inventory == null) {
                StringBuffer msg = new StringBuffer("CentralInventory::init() gets a null OiiiInstallInventory object");
                NullPointerException e4 = new NullPointerException(msg.toString());
                OLogger.debug(msg);
                throw e4;
            }
            if (inventory.getHomes().isEmpty()) {
                String message = OLogger.getString("OUI-67131");
                RuntimeException re = new RuntimeException(message);
                OLogger.debug(message);
                throw re;
            }
            OLogger.debug(new StringBuffer("RawInventory::init() gets OiiiOracleHomeInfo object"));
            OiiiOracleHomeInfo OHInfo = inventory.getHomeWithLocation(oracleHomePath);
            Vector compList = inventory.getTopLevelComps(OHInfo.getIndex());
            String version = ((OiiiCompInstallID)compList.get(0)).getVersion().getVerString();
            if (version != "" && version != null) {
                OPatchEnv.setOHDBVersion(version);
            }
            newInstance = new RawInventory(oracleHomePath, installAreaControl, inventory, OHInfo);
            if (OHInfo == null) {
                StringBuffer msg = new StringBuffer("RawInventory::init() unable to load OiiiOracleHomeInfo, and there is no retry supported.");
                OLogger.debug(msg);
                RawInventory.printListOfHomes(oracleHomePath);
            }
            buff.append(" gets RawInventory object");
            OLogger.debug(buff);
            RawInventory.loadRawInventory(inventory);
            OLogger.debug(new StringBuffer("RawInventory::init() construction done"));
            return newInstance;
        }
        catch (Throwable t) {
            buff = new StringBuffer("RawInventory::createInventoryObj() gets an error: ");
            buff.append(t.getMessage());
            OLogger.debug(buff);
            throw t;
        }
    }

    public RawInventory reload() throws NullPointerException {
        RawInventory.loadRawInventory(RawInventory.getInstallInvObject());
        return instance;
    }

    private static void loadRawInventory(OiiiInstallInventory inventory) throws NullPointerException {
        StringBuffer buff = new StringBuffer("RawInventory::loadRawInventory()");
        OLogger.debug(buff);
        OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Loading raw inventory");
        if (inventory == null) {
            throw new NullPointerException("RawInventory gets null InstallInventory");
        }
        if (RawInventory.getOracleHomeInfo() == null) {
            throw new NullPointerException("RawInventory gets null OracleHomeInfo");
        }
        buff.append(" gets a Vector of all product entries");
        OLogger.debug(buff);
        int homeIndex = RawInventory.getOracleHomeInfo().getIndex();
        rawInstalledProducts = inventory.getAllCompsVect(homeIndex);
        OLogger.printlnOnLog("[OPSR-MEMORY] Loaded all components from inventory. Heap memory in use: " + HeapMemory.getHeapUsedMB() + " (MB)");
        if (rawInstalledProducts == null) {
            NullPointerException e2 = new NullPointerException("RawInventory gets a null Vector of installed products");
            throw e2;
        }
        OLogger.debug(new StringBuffer("RawInventory::load() gets a Vector of all one-off entries"));
        rawOneOffList = RawInventory.getAllOneoffInvEntries();
        if (rawOneOffList == null) {
            NullPointerException e3 = new NullPointerException("RawInventory gets a null Vector of one-off entries");
            throw e3;
        }
        OLogger.printlnOnLog("[OPSR-MEMORY] Loaded all one offs from inventory. Heap memory in use: " + HeapMemory.getHeapUsedMB() + " (MB)");
        OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Raw inventory loaded successfully");
    }

    public static void checkOpatchCompatibleDB(String oh, String version) {
        OiiiVersion verCompare = new OiiiVersion(version);
        OiiiVersion baseVer = new OiiiVersion("12.2.0.1.0");
        if (verCompare.equals(baseVer) || verCompare.laterThan(baseVer)) {
            System.out.println("its greater than 12.2.0.1.0");
        } else {
            System.out.println("Its not matching");
        }
    }

    public Vector getRawInstalledProducts() {
        return rawInstalledProducts;
    }

    public Vector getRawOneOffList() {
        return rawOneOffList;
    }

    public String getOracleHomePath() {
        return instanceOHPath;
    }

    private static OiiiOracleHomeInfo getOracleHomeInfo() {
        return oracleHomeInfo;
    }

    private static OiiiInstallInventory getInstallInvObject() {
        return installInventory;
    }

    private OiiiInstallAreaControl getInstallAreaControl() {
        return installAreaControl;
    }

    protected void saveInstallInventory() throws IOException, OiifbCancelException {
        this.getInstallAreaControl().saveInstallInventory();
    }

    protected boolean updateCompVersion(String intComponent, OiiiVersion oVer, Integer homeIndex) {
        return RawInventory.getInstallInvObject().updateCompVersion(intComponent, oVer, homeIndex.intValue());
    }

    protected void removeOneoffInvEntry(OiiiInstallOneoffInvEntry entry) throws OiiiOneoffException {
        RawInventory.getInstallInvObject().removeOneoffInvEntry(entry);
    }

    protected static void printListOfHomes(String oracleHomePath) throws Throwable {
        StringBuffer buff = new StringBuffer("printListOfHomes()");
        StringBuffer tmp = new StringBuffer("RawInventory::init() gets a null OiiiOracleHomeInfo object");
        OLogger.debug(tmp);
        try {
            OLogger.debug(new StringBuffer("RawInventory::printListOfHomes() tries to print a list of Oracle Homes on this system"));
            Vector homes = RawInventory.getInstallInvObject().getHomes();
            if (homes != null) {
                Iterator iter = homes.iterator();
                buff = new StringBuffer("RawInventory::printListOfHomes() Your Oracle Home path: \"");
                buff.append(oracleHomePath);
                buff.append("\"");
                OLogger.debug(buff);
                buff = new StringBuffer("List of Homes on this system:\n");
                StringBuffer eachHome = null;
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    if (obj instanceof OiiiOracleHomeInfo) {
                        OiiiOracleHomeInfo home = (OiiiOracleHomeInfo)obj;
                        if (home != null) {
                            String homeName = home.getName();
                            String homeLoc = home.getLocation();
                            eachHome = new StringBuffer("\n  Home name= ");
                            eachHome.append(homeName);
                            eachHome.append(", Location= \"");
                            eachHome.append(homeLoc);
                            eachHome.append("\"");
                            buff.append(eachHome);
                            continue;
                        }
                        OLogger.debug(new StringBuffer("RawInventory::printListOfHomes() gets a null OiiiOracleHomeInfo object from list of homes"));
                        continue;
                    }
                    OLogger.debug(new StringBuffer("RawInventory::printListOfHomes() gets an object NOT of type OiiiOracleHomeInfo"));
                }
            } else {
                OLogger.debug(new StringBuffer("RawInventory::printListOfHomes() gets a null Vector of Oracle Homes on this system"));
            }
        }
        catch (Throwable t) {
            OLogger.debug(new StringBuffer("RawInventory::printListOfHomes() cannot print the list of Oracle Homes on this system"));
            throw t;
        }
        OLogger.println(buff.toString());
    }

    public String getGUID(String oracleHomePath) throws RuntimeException {
        StringBuffer buff = new StringBuffer("RawInventory::getGUID()");
        OLogger.debug(buff);
        try {
            OLogger.printlnOnLogAndVerbose("Given Oracle Home is : " + oracleHomePath);
            if (RawInventory.getInstallInvObject() == null) {
                throw new RuntimeException("The Oracle Home Inventory object to get Oracle Home details is null.");
            }
            Vector homes = this.getHomes();
            if (homes != null) {
                for (Object obj : homes) {
                    String homeLoc;
                    OiiiOracleHomeInfo home;
                    if (!(obj instanceof OiiiOracleHomeInfo) || (home = (OiiiOracleHomeInfo)obj) == null || home.getGUID() == null || !(homeLoc = home.getLocation()).equals(oracleHomePath)) continue;
                    OLogger.printlnOnLogAndVerbose("Home matched... GUID found");
                    return home.getGUID();
                }
            }
        }
        catch (Throwable t) {
            OLogger.printlnOnLogAndVerbose("Exception occurred : " + t.getMessage());
            throw new RuntimeException(t);
        }
        return "";
    }

    public OPatchSDK.OracleHome[] getOracleHomes() {
        StringBuffer buff = new StringBuffer("RawInventory::getOracleHomes()");
        OLogger.debug(buff);
        Vector homeList = new Vector();
        OPatchSDK.OracleHome[] oracleHomes = new OPatchSDK.OracleHome[]{};
        try {
            homeList = this.getInstallInvObject().getHomes();
            if (homeList != null) {
                int size = homeList.size();
                oracleHomes = new OPatchSDK.OracleHome[size];
                for (int i2 = 0; i2 < size; ++i2) {
                    OPatchSDK.OracleHome oh;
                    Object obj = homeList.get(i2);
                    if (!(obj instanceof OiiiOracleHomeInfo)) {
                        buff = new StringBuffer("  error, object not of type OiiiOracleHomeInfo");
                        OLogger.debug(buff);
                        return new OPatchSDK.OracleHome[0];
                    }
                    OiiiOracleHomeInfo homeInfo = (OiiiOracleHomeInfo)obj;
                    String name = homeInfo.getName();
                    String loc = homeInfo.getLocation();
                    int index = homeInfo.getIndex();
                    oracleHomes[i2] = oh = new OPatchSDK.OracleHome(name, loc, index);
                }
            }
        }
        catch (Throwable t) {
            buff.append(", got exception while calling installInventory.getHomes()");
            OLogger.debug(buff);
        }
        return oracleHomes;
    }

    public Vector getHomes() {
        return RawInventory.getInstallInvObject().getHomes();
    }

    public Vector getCompInvEntries(String compName, Integer ohIndex) {
        return RawInventory.getInstallInvObject().getCompInvEntries(compName, ohIndex.intValue());
    }

    public Vector getCompInvEntries(String compName, OiiiVersion version, Integer ohIndex) {
        return RawInventory.getInstallInvObject().getCompInvEntries(compName, version, ohIndex.intValue());
    }

    public PatchComponent AddBugsToFixAndFilesToPatchComponent(PatchComponent patchComp) throws RuntimeException {
        return patchComp;
    }

    public Vector<OiiiCompInstallID> getTopLevelComps() {
        return RawInventory.getInstallInvObject().getTopLevelComps(RawInventory.getIndex().intValue());
    }

    OiiiInstallOneoffInvEntry getOneoffInvEntry(String patchID, Vector langs, String uniquePatchID, String oracleHomeName) throws OiiiOneoffException {
        int methodToInvoke;
        boolean uid = false;
        boolean lang = false;
        if (langs != null && langs.size() != 0) {
            lang = true;
        }
        if (uniquePatchID != null && !uniquePatchID.equals("")) {
            uid = true;
        }
        if ((methodToInvoke = this.chooseOUIEntryMethodToInvoke(lang, uid)) == 1 || methodToInvoke == 3) {
            return RawInventory.getInstallInvObject().getOneoffInvEntry(patchID, langs, uniquePatchID, RawInventory.getInstallInvObject().getHomeWithLocation(oracleHomeName).getIndex());
        }
        return RawInventory.getInstallInvObject().getOneoffInvEntry(patchID, oracleHomeName);
    }

    public OiiiInstallOneoffInvEntry getOneoffInvEntry(String patchID, Vector langs, String uniquePatchID, int oracleHomeIndex, String oracleHomePath) throws OiiiOneoffException {
        boolean uid = false;
        boolean lang = false;
        if (langs != null && langs.size() != 0) {
            lang = true;
        }
        if (uniquePatchID != null && !uniquePatchID.equals("")) {
            uid = true;
        }
        int methodToInvoke = this.chooseOUIEntryMethodToInvoke(lang, uid);
        OiiiInstallOneoffInvEntry entry = null;
        if (methodToInvoke == 1 || methodToInvoke == 3 || methodToInvoke == 2) {
            boolean isSnowBall;
            entry = RawInventory.getInstallInvObject().getOneoffInvEntry(patchID, langs, uniquePatchID, oracleHomeIndex);
            boolean bl = isSnowBall = PatchingModel.returnModelCode(oracleHomePath) == 2;
            if (entry == null && !isSnowBall) {
                entry = RawInventory.getInstallInvObject().getOneoffInvEntry(patchID, oracleHomeIndex);
            }
        } else {
            entry = RawInventory.getInstallInvObject().getOneoffInvEntry(patchID, oracleHomeIndex);
        }
        return entry;
    }

    protected OiiiInstallOneoffInvEntry createOneoffInvEntry(String patchID, Vector bugsToFix, boolean isRollBackable, String oracleHomeName, String uniquePatchID, String patchDescription, Vector langs, int oracleHomeIndex, Vector subsetPatches) throws OiiiOneoffException {
        int methodToInvoke;
        OiiiInstallOneoffInvEntry retEntry = null;
        boolean lang = false;
        boolean uid = false;
        if (langs != null && langs.size() != 0) {
            lang = true;
        }
        if (uniquePatchID != null && !uniquePatchID.equals("")) {
            uid = true;
        }
        retEntry = (methodToInvoke = this.chooseOUIEntryMethodToInvoke(lang, uid)) == 1 || methodToInvoke == 2 || methodToInvoke == 3 ? RawInventory.createOneoffInvEntry(patchID, bugsToFix, isRollBackable, langs, uniquePatchID, oracleHomeIndex) : RawInventory.getInstallInvObject().createOneoffInvEntry(patchID, bugsToFix, isRollBackable, oracleHomeName);
        if (IPMUtil.canGetDescForInvEntry() && patchDescription != null && !patchDescription.equals("")) {
            retEntry.setDescription(patchDescription);
        }
        if (IPMUtil.canSetSubsetPatchesForInvEntry() && subsetPatches != null && subsetPatches.size() != 0) {
            retEntry.setSupersededOneOffsList(subsetPatches);
        }
        return retEntry;
    }

    private static OiiiInstallOneoffInvEntry createOneoffInvEntry(String patchID, Vector bugsToFix, boolean isRollBackable, Vector langs, String uniquePatchID, int oracleHomeIndex) throws OiiiOneoffException {
        return RawInventory.getInstallInvObject().createOneoffInvEntry(patchID, bugsToFix, new Vector(), isRollBackable, langs, uniquePatchID, oracleHomeIndex);
    }

    protected void addOneoffInvEntry(OiiiInstallOneoffInvEntry entry, String oracleHomeName) throws OiiiOneoffException {
        Vector langs;
        if (IPMUtil.canGetLangsForInvEntry() && (langs = entry.getLangs()) != null && langs.size() != 0) {
            String uniqID;
            String relPath = "oneoffs" + fileSeparator + entry.getID() + "_" + OiixLanguage.vectToStr((Vector)entry.getLangs());
            relPath = IPMUtil.canGetUniqueIDForInvEntry() ? ((uniqID = entry.getUniqID()) == null || uniqID.equals("") ? relPath + fileSeparator : relPath + "_" + uniqID + fileSeparator) : relPath + fileSeparator;
            entry.setXmlInventoryLocation(relPath);
        }
        RawInventory.getInstallInvObject().addOneoffInvEntry(entry, oracleHomeName);
    }

    private int chooseOUIEntryMethodToInvoke(boolean langDefined, boolean uidDefined) {
        try {
            if (!langDefined && !uidDefined) {
                return 4;
            }
            boolean lang = false;
            boolean uid = false;
            Class<?> chkClass = Class.forName("oracle.sysman.oii.oiii.OiiiOneoffInvEntry");
            if (chkClass != null) {
                Method[] methods = chkClass.getMethods();
                for (int i2 = 0; i2 < methods.length; ++i2) {
                    if (methods[i2].getName().equals("setLangs")) {
                        lang = true;
                    }
                    if (!methods[i2].getName().equals("setUniqID")) continue;
                    uid = true;
                }
                if (lang && uid) {
                    return 3;
                }
                if (lang) {
                    return 1;
                }
                if (uid) {
                    return 2;
                }
                return 4;
            }
            return 4;
        }
        catch (ClassNotFoundException e2) {
            return 4;
        }
    }

    public static boolean isInstallInventoryExist() {
        return RawInventory.getInstallInvObject() != null;
    }

    public boolean isOracleHomeInfoExist() {
        return RawInventory.getOracleHomeInfo() != null;
    }

    protected boolean isCRSHome() {
        return RawInventory.getOracleHomeInfo().isCRSHome();
    }

    protected String getOracleHomeName() {
        return RawInventory.getOracleHomeInfo().getName();
    }

    protected String getLocalNode() {
        return RawInventory.getOracleHomeInfo().getLocalNode();
    }

    protected Integer getARUID() {
        return RawInventory.getOracleHomeInfo().getARUID();
    }

    protected String getARUIDDescription() {
        return RawInventory.getOracleHomeInfo().getARUIDDescription();
    }

    protected String getLocation() {
        return RawInventory.getOracleHomeInfo().getLocation();
    }

    protected static Integer getIndex() {
        return RawInventory.getOracleHomeInfo().getIndex();
    }

    protected String getAdditionalOracleHomeProperty(String propertyName) {
        return RawInventory.getOracleHomeInfo().getAdditionalOracleHomeProperty(propertyName);
    }

    protected String getXMLInvLocation(String patchID) {
        ArrayList<OiiiInstallOneoffInvEntry> entryList = new ArrayList<OiiiInstallOneoffInvEntry>();
        try {
            OLogger.debug("Call getOneoffInvEntry() to get patches with specified patchid.");
            Method method = RawInventory.getInstallInvObject().getClass().getMethod("getOneoffInvEntry", String.class, String.class, List.class);
            method.invoke((Object)RawInventory.getInstallInvObject(), patchID, this.getOracleHomeName(), entryList);
        }
        catch (NoSuchMethodException ex) {
            OLogger.debug("Use old oui API getAllOneoffInvEntries().");
            Vector allEntryList = RawInventory.getAllOneoffInvEntries();
            for (OiiiInstallOneoffInvEntry rawEntry : allEntryList) {
                OiiiInstallOneoffInvEntry entry = rawEntry;
                if (!entry.getID().toString().equals(patchID)) continue;
                if (IPMUtil.canGetLangsForInvEntry()) {
                    if (entry.getLangs() == null || entry.getLangs().size() == 0) {
                        entryList.add(entry);
                        continue;
                    }
                    String lang = OiixLanguage.vectToStr((Vector)entry.getLangs());
                    if (!lang.contains("en")) continue;
                    entryList.add(entry);
                    continue;
                }
                entryList.add(entry);
            }
        }
        catch (Exception e2) {
            throw new RuntimeException(e2.getMessage(), e2);
        }
        if (entryList.isEmpty()) {
            return null;
        }
        Collections.sort(entryList, new Comparator<OiiiInstallOneoffInvEntry>(){

            @Override
            public int compare(OiiiInstallOneoffInvEntry entry1, OiiiInstallOneoffInvEntry entry2) {
                return entry1.getTimestamp().compareTo(entry2.getTimestamp());
            }
        });
        OiiiInstallOneoffInvEntry oEntry = (OiiiInstallOneoffInvEntry)entryList.get(entryList.size() - 1);
        if (oEntry == null) {
            throw new RuntimeException("Patch ID \"" + patchID + "\" does not exist in comps.xml");
        }
        return oEntry.getXMLInvLocation();
    }

    protected static Vector getAllOneoffInvEntries() {
        try {
            return RawInventory.getInstallInvObject().getAllOneoffInvEntries(RawInventory.getIndex().intValue(), false);
        }
        catch (Throwable t) {
            return RawInventory.getInstallInvObject().getAllOneoffInvEntries(RawInventory.getIndex().intValue());
        }
    }

    protected void clearInventory() {
        instance = null;
        installInventory = null;
        installAreaControl = null;
        oracleHomeInfo = null;
    }

    public static void destroyObject() {
        installInventory = null;
        installAreaControl = null;
        oracleHomeInfo = null;
        if (rawInstalledProducts != null) {
            rawInstalledProducts.clear();
        }
        if (rawOneOffList != null) {
            rawOneOffList.clear();
        }
        if (instance != null) {
            instance = null;
        }
    }
}

