/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchactions;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.opatch.ConflictDetectable;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OUIReplacer;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchObjectUtil;
import oracle.opatch.RemoteShellPropagate;
import oracle.opatch.Restorable;
import oracle.opatch.Rules;
import oracle.opatch.SystemCall;
import oracle.opatch.Verifiable;
import oracle.opatch.ZipUtilities;
import oracle.opatch.opatchactions.OrderedPatchAction;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.ConflictHandler;
import oracle.opatch.opatchutil.DeltaFileProcessor;
import oracle.opatch.opatchutil.OUSession;
import oracle.opatch.opatchutil.obfuscation.ObfuscationUtil;
import oracle.opatch.wrappers.WrapperFactory;

public class DeleteAction
extends OrderedPatchAction
implements Restorable,
RemoteShellPropagate,
ConflictDetectable,
Verifiable {
    private String nonApplicableDesc;
    private String nonRollbackableDesc;
    private String backupForRollbackFailureDesc;
    private String deleteName;
    private String path;
    private boolean isReq = true;
    private String fileName;
    private boolean isDir = false;
    private boolean isOneway = false;
    private String fileVersion = "";
    private boolean backupZip = false;
    private boolean rawIsDirectory = false;
    private boolean opatchBinary = false;
    private boolean hasFileVersion = false;
    private boolean snowBallDeleteAction = false;
    private static HashMap copyFileVer = new HashMap();
    private static HashMap<String, List<String>> iDeleteActVer = new HashMap();
    private static HashMap<String, List<String>> envDeleteActVer = new HashMap();
    private static HashMap<String, List<String>> doneDeleteFileVer = new HashMap();

    public DeleteAction(PatchComponent pc, String deleteName, String path, boolean isReq, String fileName, boolean isDir, String fileVersion, boolean hasFileVersion, boolean isOneway, boolean backupZip, int lineNumber) throws NullPointerException, Exception {
        super(pc, lineNumber);
        if (path == null) {
            String errMsg = "The delete action is null";
            if (path == null) {
                errMsg = errMsg + "The delete path is null";
            }
            NullPointerException ne = new NullPointerException(errMsg);
            throw ne;
        }
        this.deleteName = deleteName;
        String tmp = PatchObjectUtil.filterString(path);
        this.path = OPatchEnv.stringPool.getValue(tmp);
        this.isReq = isReq;
        this.fileName = tmp = PatchObjectUtil.getPlatformDependentPath(fileName);
        this.isDir = isDir;
        this.isOneway = isOneway;
        this.fileVersion = fileVersion;
        this.hasFileVersion = hasFileVersion;
        this.backupZip = backupZip;
    }

    public String getDeleteName() {
        return this.deleteName;
    }

    public String getPath() {
        return this.path;
    }

    public boolean getIsReq() {
        return this.isReq;
    }

    public boolean getIsDir() {
        return this.isDir;
    }

    public boolean getRawIsDirectory() {
        return this.rawIsDirectory;
    }

    public boolean getIsOneway() {
        return this.isOneway;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileVersion() {
        return this.fileVersion;
    }

    public boolean isHasFileVersion() {
        return this.hasFileVersion;
    }

    public boolean isSnowBallDeleteAction() {
        return this.snowBallDeleteAction;
    }

    public boolean needBackupZip() {
        return this.backupZip;
    }

    public void setSnowBallDeleteAction(boolean snowBallDeleteAction) {
        this.snowBallDeleteAction = snowBallDeleteAction;
    }

    public static void setCopyFileVer(HashMap copyFileVer) {
        DeleteAction.copyFileVer = copyFileVer;
    }

    public void setRawIsDirectory(boolean isDir) {
        this.rawIsDirectory = isDir;
    }

    public static HashMap getCopyFileVer() {
        return copyFileVer;
    }

    public static void setiDeleteActVer(HashMap<String, List<String>> iDeleteActVer) {
        DeleteAction.iDeleteActVer = iDeleteActVer;
    }

    public static void setEnvDeleteActVer(HashMap<String, List<String>> envDeleteActVer) {
        DeleteAction.envDeleteActVer = envDeleteActVer;
    }

    public static HashMap<String, List<String>> getDoneDeleteActVer() {
        return doneDeleteFileVer;
    }

    public String getBackupRollbackPath(String oracleHomePath, String cookedPatchID) {
        StringBuffer path = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
        path.append(File.separator);
        path.append(this.fileName);
        return path.toString();
    }

    public void setOPatchBinary(boolean value) {
        this.opatchBinary = value;
    }

    public boolean isOPatchBinary() {
        return this.opatchBinary;
    }

    @Override
    public boolean verify(String oracleHomePath, String patchLocation) throws IOException {
        StringBuffer buff = new StringBuffer("DeleteAction::verify()");
        OLogger.debug(buff);
        String dst = this.getParentFilePath(oracleHomePath);
        if (this.isReq) {
            Path dstFile = WrapperFactory.getNioServiceWrapper().getPath(dst, new String[0]);
            buff = new StringBuffer("\n Check if file exists in OH");
            buff.append("\n file path = " + dst);
            OLogger.log(OLogger.FINE, buff.toString());
            if (!Files.exists(dstFile, new LinkOption[0])) {
                buff = new StringBuffer("Destination file \"");
                buff.append(dst);
                buff.append("\" does not exist.  Can't verify.");
                OLogger.log(OLogger.WARNING, buff.toString());
                return false;
            }
            if (!Files.isWritable(dstFile)) {
                buff = new StringBuffer("Destination file \"");
                buff.append(dst);
                buff.append("\" does not have write permission.  Can't delete.");
                OLogger.log(OLogger.WARNING, buff.toString());
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean conflictDetectable(String oracleHomePath) {
        StringBuffer buff = new StringBuffer("DeleteAction::conflictDetectable()  ");
        String dst = this.getParentFilePath(oracleHomePath);
        boolean tmpB = dst != null && !dst.equals("");
        buff.append(tmpB);
        OLogger.debug(buff);
        return tmpB;
    }

    @Override
    public String checkConflict(String oracleHomePath, OneOffEntry[] oneoffs) throws RuntimeException {
        return ConflictHandler.checkCommonConflict(oracleHomePath, oneoffs, this);
    }

    @Override
    public String[] filesTouched(String oracleHomePath) throws RuntimeException {
        String dst = this.getParentFilePath(oracleHomePath);
        String[] filesList = new String[]{dst};
        return filesList;
    }

    @Override
    public String getFilePathToPropagate(String oracleHomePath) throws RuntimeException {
        return this.getParentFilePath(oracleHomePath);
    }

    @Override
    public boolean applicable(String oracleHomePath, String patchLocation) {
        if (this.isOPatchBinary()) {
            oracleHomePath = OPatchEnv.getOracleHome();
        }
        StringBuffer buff = new StringBuffer("DeleteAction::appliacable()");
        OLogger.debug(buff);
        String dst = this.getParentFilePath(oracleHomePath);
        buff = new StringBuffer("   Action details: dst = \"");
        buff.append(dst);
        buff.append("\"");
        OLogger.debug(buff);
        Path dstFile = WrapperFactory.getNioServiceWrapper().getPath(dst, new String[0]);
        Path parentFile = dstFile.getParent();
        if (Files.exists(parentFile, new LinkOption[0]) && !Files.isReadable(parentFile)) {
            buff = new StringBuffer("DeleteAction : Directory is not readable: \"");
            buff.append(parentFile);
            buff.append("\"");
            this.nonApplicableDesc = buff.toString();
            return false;
        }
        if (!Files.exists(parentFile, new LinkOption[0]) && this.isReq) {
            buff = new StringBuffer("DeleteAction : Directory does not exist: \"");
            buff.append(parentFile);
            buff.append("\"");
            this.nonApplicableDesc = buff.toString();
            return false;
        }
        if (OPatchEnv.isWindows() && Files.exists(parentFile, new LinkOption[0]) && !Files.isWritable(parentFile)) {
            buff = new StringBuffer("DeleteAction : Directory is not writeable: \"");
            buff.append(parentFile);
            buff.append("\"");
            buff.append("\nIt can not execute in windows.");
            this.nonApplicableDesc = buff.toString();
            return false;
        }
        if (Files.exists(dstFile, new LinkOption[0]) && !OPatchSessionHelper.CanWrite(oracleHomePath, dstFile)) {
            buff = new StringBuffer("DeleteAction : Destination File \"");
            buff.append(dst);
            buff.append("\" is not writeable.");
            this.nonApplicableDesc = buff.toString();
            return false;
        }
        if (this.isReq && !Files.exists(dstFile, new LinkOption[0])) {
            buff = new StringBuffer("DeleteAction : Destination File \"");
            buff.append(dst);
            buff.append("\" does not exists.");
            this.nonApplicableDesc = buff.toString();
            return false;
        }
        return true;
    }

    @Override
    public void apply(String oracleHomePath, String patchLocation) throws RuntimeException {
        if (this.isOPatchBinary()) {
            oracleHomePath = OPatchEnv.getOracleHome();
        }
        StringBuffer buff = new StringBuffer("DeleteAction:: apply()");
        OLogger.debug(buff);
        String dst = this.getParentFilePath(oracleHomePath);
        buff = new StringBuffer(" DeleteAction: dst=\"");
        buff.append(dst);
        buff.append("\"");
        OLogger.verbose(this, buff);
        Path dstFile = WrapperFactory.getNioServiceWrapper().getPath(dst, new String[0]);
        Path parentFile = dstFile.getParent();
        boolean cont = Rules.SystemWrite_continue();
        boolean optionFileExist = true;
        String srcVer = "";
        String destVer = "";
        try {
            boolean doCopy = true;
            boolean intra = false;
            DirectoryStream<Path> subFiles = null;
            try {
                subFiles = Files.newDirectoryStream(dstFile);
            }
            catch (IOException e2) {
                OLogger.debug(e2.getMessage());
            }
            if (!this.isHasFileVersion()) {
                doCopy = true;
            } else if (!this.isSnowBallDeleteAction()) {
                OLogger.debug("This delete action is not part of snowball patch");
                doCopy = true;
            } else {
                OLogger.debug("This delete has file version & is a snowball delete");
                if (OPatchEnv.isFATwoPhase()) {
                    List<String> verList = envDeleteActVer.get(this.getFileName());
                    if (verList == null || !verList.contains(this.getFileVersion())) {
                        srcVer = this.getFileVersion();
                        List<String> iVerList = iDeleteActVer.get(this.getFileName());
                        if (iVerList != null && !iVerList.contains(srcVer)) {
                            intra = true;
                            destVer = iVerList.toString();
                        }
                        if (!intra) {
                            destVer = (String)copyFileVer.get(this.getFileName());
                        }
                        doCopy = false;
                        this.setApplyFailed();
                    } else {
                        srcVer = this.getFileVersion();
                        destVer = (String)copyFileVer.get(this.getFileName());
                        if (destVer != null) {
                            if (srcVer.startsWith("le")) {
                                String updateVer;
                                int retVal;
                                if (!(srcVer.equals("lemax.version") || (retVal = OPatchSessionHelper.isGreaterDecimal(destVer, updateVer = srcVer.substring(2))) != 0 && retVal != 1)) {
                                    doCopy = false;
                                    this.setApplyFailed();
                                }
                            } else {
                                int retVal = OPatchSessionHelper.isGreaterDecimal(destVer, srcVer);
                                if (retVal == -1 || retVal == 1) {
                                    doCopy = false;
                                    this.setApplyFailed();
                                }
                            }
                        }
                    }
                } else if (copyFileVer.containsKey(this.getFileName())) {
                    srcVer = this.getFileVersion();
                    destVer = (String)copyFileVer.get(this.getFileName());
                    OLogger.printlnOnLogAndVerbose("To be Applied Version : " + srcVer);
                    OLogger.printlnOnLogAndVerbose("Present Highest Version in OH : " + destVer);
                    if (srcVer.startsWith("le")) {
                        if (!srcVer.equals("lemax.version")) {
                            String updateSrcValue = srcVer.substring(2);
                            int retVal = OPatchSessionHelper.isGreaterDecimal(updateSrcValue, destVer);
                            if (retVal == 1) {
                                doCopy = true;
                            } else {
                                doCopy = false;
                                this.setApplyFailed();
                            }
                        }
                    } else {
                        int retVal = OPatchSessionHelper.isGreaterDecimal(srcVer, destVer);
                        if (retVal == 0) {
                            doCopy = true;
                        } else {
                            doCopy = false;
                            this.setApplyFailed();
                        }
                    }
                } else {
                    destVer = "0.0";
                    srcVer = this.getFileVersion();
                    doCopy = true;
                }
            }
            if (this.isSnowBallDeleteAction() && Files.isDirectory(dstFile, new LinkOption[0]) && subFiles.iterator().hasNext()) {
                OLogger.debug("The directory " + dstFile + " is not empty, so skip deleting this directory");
                doCopy = false;
                this.setApplyFailed();
            }
            try {
                if (subFiles != null) {
                    subFiles.close();
                }
            }
            catch (IOException e3) {
                OLogger.debug(e3.getMessage());
            }
            if (doCopy) {
                if (this.isHasFileVersion() && this.isSnowBallDeleteAction()) {
                    OLogger.info("OUI-67662", new Object[]{this.getParentFilePath(oracleHomePath)});
                    if (!OPatchEnv.isFATwoPhase()) {
                        List<String> verList = doneDeleteFileVer.get(this.getFileName());
                        if (verList == null) {
                            verList = new ArrayList<String>();
                            verList.add(this.fileVersion);
                            doneDeleteFileVer.put(this.fileName, verList);
                        } else {
                            verList.add(this.fileName);
                        }
                    }
                } else if (!this.isReq && !Files.exists(dstFile, new LinkOption[0])) {
                    optionFileExist = false;
                } else {
                    OLogger.onlyLogInfo("OUI-67007", new Object[]{this.getParentFilePath(oracleHomePath)});
                }
                if (cont) {
                    if (!Files.exists(dstFile, new LinkOption[0]) && !Files.isDirectory(dstFile, new LinkOption[0])) {
                        try {
                            Files.delete(dstFile);
                        }
                        catch (Exception e4) {
                            buff = new StringBuffer("This exception will be ignore for special symlink case");
                            OLogger.justlog(OLogger.INFO, buff.toString());
                        }
                    } else {
                        SystemCall.deleteRecurse(dstFile, true);
                    }
                    boolean isDelete = Files.exists(dstFile, new LinkOption[0]);
                    DeltaFileProcessor deltaFileProcessor = OUSession.getDeltaFileProcessor();
                    if (!isDelete && !optionFileExist) {
                        buff = new StringBuffer("DeleteAction:skip deleting file: \"");
                        buff.append(dst);
                        OLogger.justlog(OLogger.WARNING, buff.toString());
                    } else if (!isDelete && optionFileExist) {
                        deltaFileProcessor.addNApplyDeltaFiles(dst, this);
                        buff = new StringBuffer("DeleteAction: delete file: \"");
                        buff.append(dst);
                        buff.append("\" successful.");
                        OLogger.justlog(OLogger.INFO, buff.toString());
                    } else {
                        buff = new StringBuffer("DeleteAction: delete file: \"");
                        buff.append(dst);
                        buff.append("\" failed.");
                        this.setApplyFailed();
                        OLogger.justlog(OLogger.WARNING, buff.toString());
                    }
                    if (OPatchEnv.isFATwoPhase()) {
                        envDeleteActVer.remove(this.getFileName());
                    }
                } else {
                    buff = new StringBuffer("DeleteAction::apply() skips deleting the file ");
                    buff.append(dst);
                    buff.append(" in the Oracle home");
                    OLogger.debug(buff);
                }
            } else if (intra) {
                OLogger.println(OLogger.getString("OUI-67664", new Object[]{this.getParentFilePath(oracleHomePath), srcVer, destVer}));
            } else if (!Files.isDirectory(dstFile, new LinkOption[0])) {
                OLogger.println(OLogger.getString("OUI-67663", new Object[]{this.getParentFilePath(oracleHomePath), srcVer, destVer}));
            }
        }
        catch (RuntimeException e5) {
            OLogger.printStackTrace(e5);
            StringBuffer buffer = new StringBuffer("Delete Action: file \"");
            buffer.append(dst);
            buffer.append("\"");
            buffer.append(" delete failed");
            throw new RuntimeException(buffer.toString());
        }
        buff = new StringBuffer("  DeleteAction done.");
        OLogger.verbose(this, buff);
    }

    @Override
    public String getApplicableDesc(String oracleHomePath, String owningComponent) {
        String dst = this.getParentFilePath(oracleHomePath);
        String src = this.getSourceFile();
        String desc = this.nonApplicableDesc + "\n" + OLogger.getString("OUI-67006", new Object[]{owningComponent, dst});
        return desc;
    }

    @Override
    public String getApplyDescription(String oracleHomePath) {
        return "Delete the file from OH corresponding to  the patch.";
    }

    @Override
    public boolean rollbackable(String oracleHomePath, String cookedPatchID) {
        if (this.isOPatchBinary()) {
            oracleHomePath = OPatchEnv.getOracleHome();
        }
        StringBuffer buff = new StringBuffer("DeleteAction::rollbackable()");
        OLogger.debug(buff);
        if (this.isOneway) {
            buff = new StringBuffer("IsOneway=true,return");
            OLogger.debug(buff);
            return true;
        }
        StringBuffer path = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
        path.append(File.separator);
        path.append(this.fileName);
        String src = path.toString();
        String dst = this.getParentFilePath(oracleHomePath);
        buff = new StringBuffer("src = \"");
        buff.append(src);
        buff.append("\", dst = \"");
        buff.append(dst);
        buff.append("\"");
        OLogger.debug(buff);
        Path srcFile = WrapperFactory.getNioServiceWrapper().getPath(src, new String[0]);
        Path dstFile = WrapperFactory.getNioServiceWrapper().getPath(dst, new String[0]);
        if (Files.exists(srcFile, new LinkOption[0]) && !Files.isReadable(srcFile)) {
            buff = new StringBuffer("Delete Action: Source file \"");
            buff.append(srcFile.toAbsolutePath().toString());
            buff.append("\" is not readable.");
            this.nonRollbackableDesc = buff.toString();
            return false;
        }
        String psCookedPatchIDPath = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath, cookedPatchID);
        boolean isPSExist = this.checkPatchStorageExist(psCookedPatchIDPath);
        if (!isPSExist) {
            buff = new StringBuffer("Delete Action: Directory \"");
            buff.append(WrapperFactory.getNioServiceWrapper().getPath(psCookedPatchIDPath, new String[0]).toAbsolutePath().toString());
            buff.append("\" does not exists or is not readable. ");
            this.nonRollbackableDesc = buff.toString();
            return false;
        }
        Path parentFile = dstFile.getParent();
        if (!Files.exists(parentFile, new LinkOption[0]) && Files.exists(srcFile, new LinkOption[0])) {
            try {
                Files.createDirectories(parentFile, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!Files.exists(parentFile, new LinkOption[0]) && Files.exists(srcFile, new LinkOption[0])) {
            buff = new StringBuffer("Delete Action: ");
            buff.append("Cannot mkdirs on \"");
            try {
                buff.append(parentFile.toRealPath(new LinkOption[0]).toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            buff.append("\".");
            this.nonRollbackableDesc = buff.toString();
            return false;
        }
        if (Files.exists(parentFile, new LinkOption[0]) && !Files.isReadable(parentFile)) {
            buff = new StringBuffer("Delete Action: parent dir \"");
            try {
                buff.append(parentFile.toRealPath(new LinkOption[0]).toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            buff.append("\" does not have read permission.");
            this.nonRollbackableDesc = buff.toString();
            return false;
        }
        buff = new StringBuffer("DeleteAction::rollbackable() return true");
        OLogger.debug(buff);
        return true;
    }

    @Override
    public void rollback(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        if (this.isOPatchBinary()) {
            oracleHomePath = OPatchEnv.getOracleHome();
        }
        if (this.isOneway) {
            StringBuffer buff = new StringBuffer("IsOneway=true,return");
            OLogger.debug(buff);
            return;
        }
        boolean isContainsSymlinks = false;
        if (this.getPatchObject().getContainsSymlinks()) {
            isContainsSymlinks = true;
            OLogger.debug("DeleteAction::rollback() contains_symlinks is set to " + isContainsSymlinks);
        }
        StringBuffer buff = new StringBuffer("DeleteAction::rollback()");
        OLogger.debug(buff);
        buff = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
        buff.append(File.separator);
        buff.append(this.fileName);
        String src = buff.toString();
        String dst = this.getParentFilePath(oracleHomePath);
        Boolean isSymLinkFile = false;
        Path srcFile = WrapperFactory.getNioServiceWrapper().getPath(src, new String[0]);
        Path dstFile = WrapperFactory.getNioServiceWrapper().getPath(dst, new String[0]);
        boolean cont = Rules.SystemWrite_continue();
        buff = new StringBuffer(" DeleteAction: src=\"");
        buff.append(src);
        buff.append("\", dst=\"");
        buff.append(dst);
        buff.append("\"");
        OLogger.verbose(this, buff);
        if (Files.exists(srcFile, new LinkOption[0]) && Files.isDirectory(srcFile, new LinkOption[0]) && this.backupZip && this.isDir) {
            try {
                this.deleteDirs(srcFile);
            }
            catch (IOException e2) {
                OLogger.justlog(OLogger.INFO, "Failed to delete directory:" + srcFile);
            }
        }
        try {
            if (Files.exists(srcFile, new LinkOption[0])) {
                if (!Files.isDirectory(srcFile, new LinkOption[0])) {
                    isSymLinkFile = isContainsSymlinks && Files.isSymbolicLink(dstFile) ? Boolean.valueOf(true) : Boolean.valueOf(false);
                    if (Files.isReadable(srcFile) && !isSymLinkFile.booleanValue()) {
                        SystemCall.copyFile(srcFile, dstFile);
                    } else if (isSymLinkFile.booleanValue()) {
                        OLogger.justlog(OLogger.INFO, "contains_symlinks set to " + isContainsSymlinks + ". Skip copying symlink file: " + srcFile + " to " + dstFile);
                    } else {
                        OLogger.justlog(OLogger.SEVERE, "File:" + src + " in PS is not readable.");
                    }
                } else if (!this.backupZip) {
                    // empty if block
                }
            } else {
                String srcObf = null;
                if (this.rawIsDirectory) {
                    if (this.backupZip) {
                        Path srcZip = WrapperFactory.getNioServiceWrapper().getPath(src + "+", new String[0]);
                        if (!Files.exists(srcZip, new LinkOption[0])) {
                            srcZip = WrapperFactory.getNioServiceWrapper().getPath(src + ".zip", new String[0]);
                        }
                        if (Files.exists(srcZip, new LinkOption[0])) {
                            if (cont) {
                                ZipUtilities.unzip(srcZip.toString(), srcZip.getParent().toString());
                            }
                        } else {
                            OLogger.justlog(OLogger.SEVERE, "File:" + srcZip.toFile() + " in PS does not exists.");
                        }
                    }
                } else {
                    boolean isFileObf = false;
                    boolean foundBackup = false;
                    srcObf = ObfuscationUtil.ObfFileName(src);
                    if (srcObf != src) {
                        isFileObf = true;
                    }
                    Path srcObfPath = WrapperFactory.getNioServiceWrapper().getPath(srcObf, new String[0]);
                    if (isFileObf && Files.exists(srcObfPath, new LinkOption[0])) {
                        foundBackup = true;
                        isSymLinkFile = isContainsSymlinks && Files.isSymbolicLink(dstFile) ? Boolean.valueOf(true) : Boolean.valueOf(false);
                        if (Files.isReadable(srcObfPath) && !isSymLinkFile.booleanValue()) {
                            ObfuscationUtil.deObfuscateFileContent(srcObfPath, dstFile, false);
                        } else if (isSymLinkFile.booleanValue()) {
                            OLogger.justlog(OLogger.INFO, "contains_symlinks set to " + isContainsSymlinks + ". Skip deobfuscating and writing symlink file: " + srcObfPath + " to " + dstFile);
                        } else {
                            OLogger.justlog(OLogger.SEVERE, "File:" + srcObf + " in PS is not readable.");
                        }
                    }
                    if (!foundBackup) {
                        Path srcZip = WrapperFactory.getNioServiceWrapper().getPath(src + "+", new String[0]);
                        if (!Files.exists(srcZip, new LinkOption[0])) {
                            srcZip = WrapperFactory.getNioServiceWrapper().getPath(src + ".zip", new String[0]);
                        }
                        if (Files.exists(srcZip, new LinkOption[0])) {
                            ZipUtilities.unzip(srcZip.toString(), srcZip.getParent().toString());
                            if (!Files.exists(srcFile, new LinkOption[0])) {
                                if (isFileObf && Files.exists(srcObfPath, new LinkOption[0])) {
                                    foundBackup = true;
                                    isSymLinkFile = isContainsSymlinks && Files.isSymbolicLink(dstFile) ? Boolean.valueOf(true) : Boolean.valueOf(false);
                                    if (!isSymLinkFile.booleanValue()) {
                                        ObfuscationUtil.deObfuscateFileContent(srcObfPath, dstFile, false);
                                    } else {
                                        OLogger.justlog(OLogger.INFO, "contains_symlinks set to " + isContainsSymlinks + ". Skip deobfuscating and writing symlink zip file: " + srcObfPath + " to " + dstFile);
                                    }
                                } else {
                                    OLogger.justlog(OLogger.INFO, "File:" + srcObfPath.toString() + " in PS is not found yet. Clear file is: " + src);
                                }
                            } else {
                                foundBackup = true;
                                isSymLinkFile = isContainsSymlinks && Files.isSymbolicLink(dstFile) ? Boolean.valueOf(true) : Boolean.valueOf(false);
                                if (!isSymLinkFile.booleanValue()) {
                                    SystemCall.copyFile(srcFile, dstFile);
                                } else {
                                    OLogger.justlog(OLogger.INFO, "contains_symlinks set to " + isContainsSymlinks + ". Skip copying symlink zip file: " + srcFile + " to " + dstFile);
                                }
                            }
                        } else {
                            OLogger.justlog(OLogger.INFO, "File:" + srcZip.toString() + " in PS does not exists.");
                        }
                    }
                    if (!foundBackup) {
                        srcObf = ObfuscationUtil.ObfFileName_old(src);
                        srcObfPath = WrapperFactory.getNioServiceWrapper().getPath(srcObf, new String[0]);
                        if (Files.exists(srcObfPath, new LinkOption[0])) {
                            foundBackup = true;
                            isSymLinkFile = isContainsSymlinks && Files.isSymbolicLink(dstFile) ? Boolean.valueOf(true) : Boolean.valueOf(false);
                            if (Files.isReadable(srcObfPath) && !isSymLinkFile.booleanValue()) {
                                ObfuscationUtil.deObfuscateFileContent(srcObfPath, dstFile, false);
                            } else if (isSymLinkFile.booleanValue()) {
                                OLogger.justlog(OLogger.INFO, "contains_symlinks set to " + isContainsSymlinks + ". Skip deobfuscating and writing symlink zip file: " + srcObfPath + " to " + dstFile);
                            } else {
                                OLogger.justlog(OLogger.SEVERE, "File:" + srcObf + " in PS is not readable.");
                            }
                        }
                    }
                    if (!foundBackup) {
                        OLogger.justlog(OLogger.INFO, "File:" + src + " was not backed up in PS  for rollback.");
                    }
                }
            }
        }
        catch (RuntimeException e3) {
            OLogger.printStackTrace(e3);
            String warnMsg = OLogger.getString("OUI-67204", new Object[]{src, dst, ""});
            buff = new StringBuffer("DeleteAction::rollback() failed: \"");
            buff.append(e3.getMessage());
            buff.append("\"");
            OLogger.debug(buff);
            RuntimeException re = new RuntimeException(warnMsg);
            re.setStackTrace(e3.getStackTrace());
            throw re;
        }
        buff = new StringBuffer(" DeleteAction done");
        OLogger.verbose(this, buff);
    }

    @Override
    public String getRollbackScriptEntry(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        StringBuffer buff = new StringBuffer("DeleteAction::getRollbackScriptEntry()");
        OLogger.debug(buff);
        String source = this.getParentFilePath(oracleHomePath);
        StringBuffer path = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
        path.append(File.separator);
        path.append(this.fileName);
        String dst = path.toString();
        boolean isWindow = OPatchEnv.isWindows();
        StringBuffer rollbackStr = new StringBuffer("\n");
        Path dstFile = WrapperFactory.getNioServiceWrapper().getPath(dst, new String[0]);
        if (Files.exists(dstFile, new LinkOption[0])) {
            if (isWindow) {
                rollbackStr.append("copy /Y ");
            } else {
                rollbackStr.append("\\cp -f ");
            }
            rollbackStr.append(dst);
            rollbackStr.append(" ");
            rollbackStr.append(source);
            return rollbackStr.toString();
        }
        rollbackStr.append(source);
        return rollbackStr.toString();
    }

    @Override
    public void backupForRollback(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        String dst;
        if (this.getPatchObject().isNotRollBackable()) {
            StringBuffer buff = new StringBuffer("DeleteAction::backupForRollback() not done because the patch is not rollbackable");
            OLogger.debug(buff);
            return;
        }
        if (this.isOPatchBinary()) {
            oracleHomePath = OPatchEnv.getOracleHome();
        }
        if (this.isOneway) {
            StringBuffer buff = new StringBuffer("IsOneway=true,return");
            OLogger.debug(buff);
            return;
        }
        StringBuffer buff = new StringBuffer("DeleteAction::backupForRollback()");
        OLogger.debug(buff);
        String src = this.getParentFilePath(oracleHomePath);
        StringBuffer path = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
        path.append(File.separator);
        path.append(this.fileName);
        String dstNonObf = dst = path.toString();
        String dstObf = null;
        boolean isFileObf = false;
        if (OPatchEnv.isObfuscatePsEnable() && (dstObf = ObfuscationUtil.ObfFileName(dst)) != dst) {
            isFileObf = true;
        }
        Path srcFile = WrapperFactory.getNioServiceWrapper().getPath(src, new String[0]);
        Path dstFile = null;
        dstFile = isFileObf ? WrapperFactory.getNioServiceWrapper().getPath(dstObf, new String[0]) : WrapperFactory.getNioServiceWrapper().getPath(dst, new String[0]);
        buff = new StringBuffer("DeleteAction::backupForRollback() : ");
        buff.append(", src = \"");
        buff.append(src);
        buff.append("\", dst = \"");
        buff.append(dst);
        buff.append("\"");
        OLogger.debug(buff);
        if (!Files.exists(srcFile, new LinkOption[0])) {
            if (this.isReq) {
                buff = new StringBuffer("DeleteAction::backupForRollback() : source ");
                buff.append(", src = \"");
                buff.append(src);
                buff.append("\" does not exist, will not back it up.");
                buff.append(dst);
                buff.append("\"");
                OLogger.debug(buff);
                buff = new StringBuffer("DeleteAction::backupForRollback(): source file \"");
                buff.append(src);
                buff.append("\" not exist, so not creating ");
                buff.append(src);
                buff.append(" in the backup area. ");
                OLogger.debug(buff);
                if (Files.exists(dstFile, new LinkOption[0])) {
                    try {
                        Files.delete(dstFile);
                    }
                    catch (Exception e2) {
                        OLogger.debug(e2.getMessage());
                    }
                }
                throw new RuntimeException("DeleteAction: file need to backup for rollback does not exist.");
            }
        } else {
            Path jarParentPath = dstFile.getParent();
            boolean ok = true;
            if (!Files.exists(jarParentPath, new LinkOption[0])) {
                try {
                    Files.createDirectories(jarParentPath, new FileAttribute[0]);
                }
                catch (Exception e3) {
                    ok = false;
                }
                if (!ok) {
                    buff = new StringBuffer("DeleteAction::backupForRollback(): cannot mkdirs on ");
                    buff.append(jarParentPath.toString());
                    OLogger.debug(buff);
                    throw new RuntimeException(buff.toString());
                }
            }
            if (this.getRawIsDirectory()) {
                if (this.backupZip) {
                    if (Files.isDirectory(srcFile, new LinkOption[0])) {
                        if (this.isDir) {
                            try {
                                ZipUtilities.compressZip(dstNonObf + "+", dstNonObf);
                                try {
                                    this.deleteDirs(Paths.get(dstNonObf, new String[0]));
                                }
                                catch (Exception e4) {
                                    OLogger.justlog(OLogger.INFO, "Failed to delete temporary dir:" + dstNonObf + " in patch storage");
                                }
                            }
                            catch (Exception e5) {
                                throw new RuntimeException(e5.getMessage());
                            }
                        }
                    } else if (isFileObf) {
                        ObfuscationUtil.obfuscateFileContent(srcFile, dstFile, false);
                    } else {
                        SystemCall.backupFile(srcFile, dstFile);
                    }
                } else if (!Files.isDirectory(srcFile, new LinkOption[0])) {
                    if (isFileObf) {
                        ObfuscationUtil.obfuscateFileContent(srcFile, dstFile, false);
                    } else {
                        SystemCall.backupFile(srcFile, dstFile);
                    }
                }
            } else if (!Files.isDirectory(srcFile, new LinkOption[0])) {
                try {
                    if (this.deleteName.length() > 254) {
                        OLogger.justlog(OLogger.INFO, "File:" + this.deleteName + " is too long to be backed up in zip for rollback. Backup_in_zip is turned off");
                        this.backupZip = false;
                    }
                    if (isFileObf) {
                        ObfuscationUtil.obfuscateFileContent(srcFile, dstFile, false);
                        if (this.backupZip) {
                            ZipUtilities.compressZip(dstNonObf + "+", dstObf);
                            Files.delete(dstFile);
                        }
                    } else {
                        SystemCall.backupFile(srcFile, dstFile);
                        if (this.backupZip) {
                            ZipUtilities.compressZip(dst + "+", src);
                            Files.delete(dstFile);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public String getSourceFile() {
        if (this.deleteName == "") {
            return this.path;
        }
        return this.deleteName;
    }

    @Override
    public String getRollbackableDesc(String oracleHomePath, String owningComponent) {
        String src = this.getSourceFile();
        String dst = this.getParentFilePath(oracleHomePath);
        String desc = this.nonRollbackableDesc + "\n" + OLogger.getString("OUI-67152", new Object[]{owningComponent, src, dst});
        return desc;
    }

    @Override
    public String getBackupForRollbackDesc(String oracleHomePath) {
        return this.backupForRollbackFailureDesc;
    }

    @Override
    public String getRollbackDescription(String oracleHomePath) {
        return "Copy the delete file from backup to ORACLE_HOME.";
    }

    @Override
    public boolean restorable(String oracleHomePath, String cookedPatchID) {
        StringBuffer buff = new StringBuffer("DeleteAction::restorable()");
        OLogger.debug(buff);
        String source = this.getParentFilePath(oracleHomePath);
        String backupDir = OPatchEnv.getBackupDirectoryPath(oracleHomePath, cookedPatchID);
        StringBuffer path = new StringBuffer(backupDir);
        path.append(File.separator);
        path.append(this.path);
        path.append(File.separator);
        path.append(this.deleteName);
        String dst = path.toString();
        buff = new StringBuffer("  Action details: src = \"");
        buff.append(source);
        buff.append("\", dst = \"");
        buff.append(dst);
        buff.append("\"");
        OLogger.debug(buff);
        Path srcFile = WrapperFactory.getNioServiceWrapper().getPath(source, new String[0]);
        Path dstFile = WrapperFactory.getNioServiceWrapper().getPath(dst, new String[0]);
        if (Files.exists(srcFile, new LinkOption[0]) && !Files.isReadable(srcFile)) {
            return false;
        }
        Path parentFile = dstFile.getParent();
        if (!Files.exists(parentFile, new LinkOption[0])) {
            try {
                Files.createDirectories(parentFile, new FileAttribute[0]);
            }
            catch (Exception e2) {
                OLogger.debug(e2.getMessage());
            }
        }
        return Files.exists(parentFile, new LinkOption[0]) && Files.isWritable(parentFile);
    }

    @Override
    public void backupForRestore(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        StringBuffer buff = new StringBuffer("DeleteAction::backupForRestore()");
        OLogger.debug(buff);
        String source = this.getParentFilePath(oracleHomePath);
        buff = new StringBuffer(OPatchEnv.getBackupDirectoryPath(oracleHomePath, cookedPatchID));
        buff.append(File.separator);
        buff.append(this.path);
        buff.append(File.separator);
        buff.append(this.deleteName);
        String dst = buff.toString();
        Path srcFile = WrapperFactory.getNioServiceWrapper().getPath(source, new String[0]);
        if (!Files.exists(srcFile, new LinkOption[0])) {
            buff = new StringBuffer("DeleteAction::backupForRestore(): source file \"");
            buff.append(source);
            buff.append("\"");
            buff.append(" does not exist.");
            OLogger.debug(buff);
            return;
        }
        Path dstFile = WrapperFactory.getNioServiceWrapper().getPath(dst, new String[0]);
        try {
            if (PatchObjectUtil.checkCreateSimlink(this, OPatchEnv.getAutoRollbackList())) {
                StringBuffer temp = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
                temp.append(File.separator);
                temp.append(this.fileName);
                String target = temp.toString();
                String simlinkLoc = dst;
                buff = new StringBuffer("DeleteAction::backForRestore(): create simlink \"");
                buff.append(simlinkLoc);
                buff.append("\" to \"");
                buff.append(target);
                buff.append("\"");
                OLogger.debug(buff);
                OLogger.printlnOnLog("Creating simlink at \"" + simlinkLoc + "\" to \"" + target + "\"");
                OUIReplacer.createSimlink(target, simlinkLoc);
                return;
            }
        }
        catch (Throwable t) {
            OLogger.printlnOnLog("Exception occured while trying to create simlink, so reverting back to previous way of copying the file");
            OLogger.printlnOnLog("Details are : " + t.getMessage());
        }
        try {
            buff = new StringBuffer("DeleteAction::backupForRestore(): back up \"");
            buff.append(source);
            buff.append("\" to \"");
            buff.append(dst);
            buff.append("\"");
            OLogger.debug(buff);
            if (Files.isDirectory(srcFile, new LinkOption[0])) {
                return;
            }
            SystemCall.backupFile(srcFile, dstFile);
        }
        catch (Throwable t) {
            RuntimeException e2 = new RuntimeException(t.getMessage());
            e2.setStackTrace(t.getStackTrace());
            throw e2;
        }
    }

    @Override
    public void restore(String oracleHomePath, String sessionID, boolean apply, boolean rollback, String cookedPatchID) throws RuntimeException {
        StringBuffer buff = new StringBuffer("DeleteAction::restore()");
        OLogger.debug(buff);
        buff = new StringBuffer(OPatchEnv.getBackupDirectoryPath(oracleHomePath, sessionID));
        buff.append(File.separator);
        buff.append(this.fileName);
        String src = buff.toString();
        String dst = this.getParentFilePath(oracleHomePath);
        Path srcFile = WrapperFactory.getNioServiceWrapper().getPath(src, new String[0]);
        Path dstFile = WrapperFactory.getNioServiceWrapper().getPath(dst, new String[0]);
        buff = new StringBuffer("DeleteAction::restore(): restore file from \"");
        buff.append(src);
        buff.append("\" to \"");
        buff.append(dst);
        buff.append("\"");
        OLogger.debug(buff);
        SystemCall.copyFile(srcFile, dstFile);
    }

    @Override
    public String getBackupForRestoreDesc(String oracleHomePath, String cookedPatchID) {
        StringBuffer buff = new StringBuffer();
        buff.append(this.getParentFilePath(oracleHomePath));
        return buff.toString();
    }

    @Override
    public String getChildPath() {
        return "";
    }

    @Override
    public boolean isNewFile(String oracleHomePath, String cookedPatchID, boolean beforeApply) {
        StringBuffer buff = null;
        if (beforeApply) {
            Path deleteFile = WrapperFactory.getNioServiceWrapper().getPath(this.getParentFilePath(oracleHomePath), new String[0]);
            if (Files.exists(deleteFile, new LinkOption[0])) {
                buff = new StringBuffer("File \"");
                buff.append(deleteFile.toString());
                buff.append("\" is not a new file.\n");
                OLogger.debug(buff);
                return false;
            }
            buff = new StringBuffer("File \"");
            buff.append(deleteFile.toString());
            buff.append("\" is a new file, it's not correct for delete action.\n");
            OLogger.debug(buff);
            return true;
        }
        StringBuffer tmpFile = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
        tmpFile.append(File.separator);
        tmpFile.append(this.fileName);
        Path deleteFile = WrapperFactory.getNioServiceWrapper().getPath(tmpFile.toString(), new String[0]);
        if (!Files.exists(deleteFile, new LinkOption[0])) {
            buff = new StringBuffer("File \"");
            buff.append(deleteFile.toString());
            buff.append("\" is not present, so its a new file.\n");
            OLogger.debug(buff);
            return true;
        }
        buff = new StringBuffer("File \"");
        buff.append(deleteFile.toString());
        buff.append("\" is present, so its not a new file.\n");
        OLogger.debug(buff);
        return false;
    }

    @Override
    public String getParentFilePath(String oracleHomePath) {
        StringBuffer buff = new StringBuffer(this.getParentDirPath(oracleHomePath));
        if (this.deleteName != "") {
            buff.append(File.separator);
            buff.append(this.deleteName);
        }
        return buff.toString();
    }

    public String getParentDirPath(String oracleHomePath) {
        if (oracleHomePath == null) {
            oracleHomePath = File.separator;
        }
        StringBuffer buff = new StringBuffer(oracleHomePath);
        buff.append(File.separator);
        buff.append(this.path);
        return buff.toString();
    }

    @Override
    public String getActionName() {
        return "DeleteAction";
    }

    @Override
    public String getActionDesc() {
        return "Delete a file from OH. ";
    }

    public String getRelativePath() {
        return this.path + File.separator + this.deleteName;
    }

    @Override
    public ArrayList getFilesTouched(String oracleHomePath) {
        String[] s = new String[]{this.getSourceFile(), this.getParentFilePath(oracleHomePath)};
        ArrayList<String[]> a2 = new ArrayList<String[]>();
        a2.add(s);
        return a2;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("[DeleteAction: deleteName=\"");
        buff.append(this.deleteName);
        buff.append("\", path=\"");
        buff.append(this.path);
        buff.append("\", fileName=\"");
        buff.append(this.fileName);
        buff.append("\", isReq=\"");
        buff.append(this.isReq);
        buff.append("\", lineNumber=\"");
        buff.append(this.lineNumber);
        buff.append("\", parentPath=\"");
        buff.append(this.getParentFilePath("%ORACLE_HOME%"));
        buff.append("\", opatchBinary=\"");
        buff.append(this.opatchBinary);
        buff.append("\", rawDeleteAction=\"");
        buff.append(this.getRawActionEntry());
        buff.append("\"]");
        return buff.toString();
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.fileName.length();
        result = 37 * result + this.deleteName.length();
        result = 37 * result + this.path.length();
        return result;
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 instanceof DeleteAction) {
            String myFileName = this.getFileName();
            String myPath = this.getPath();
            String myDeleteName = this.getDeleteName();
            DeleteAction it = (DeleteAction)o2;
            String itFileName = it.getFileName();
            String itPath = it.getPath();
            String itDeleteName = it.getDeleteName();
            if (myFileName.equals(itFileName) && myPath.equals(itPath) && myDeleteName.equals(itDeleteName)) {
                return true;
            }
        }
        return false;
    }

    private void deleteDirs(Path dstFile) throws IOException {
        if (Files.isDirectory(dstFile, new LinkOption[0])) {
            File[] files;
            for (File file : files = dstFile.toFile().listFiles()) {
                if (!file.isDirectory()) {
                    file.delete();
                    continue;
                }
                this.deleteDirs(file.toPath());
            }
            Files.delete(dstFile);
        }
    }
}

