/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchactions;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OUIReplacer;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchObjectUtil;
import oracle.opatch.Rules;
import oracle.opatch.SystemCall;
import oracle.opatch.opatchactions.OrderedPatchAction;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.wrappers.WrapperFactory;

public class portalAction
extends OrderedPatchAction {
    private String portalPatchRelativeLocation = "";
    private String portalAbsLocation = "";
    private String nonApplicableDesc = "";
    private String nonRollbackableDesc = "";
    private static StringBuffer setupErrorMessage;
    private static boolean isSetupError;

    private portalAction() {
    }

    public portalAction(PatchComponent pc, ArrayList argNames, ArrayList argValues, Integer lineNumber) throws RuntimeException, NullPointerException, Exception {
        super(pc, lineNumber);
        if (argNames == null || argValues == null) {
            throw new RuntimeException("Argument inputs are NULL for portal action");
        }
        if (argNames.size() != argValues.size()) {
            throw new RuntimeException("Argument names and their values don't match numerically for portal action.");
        }
        String patchFilesLocation = "";
        for (int i2 = 0; i2 < argNames.size(); ++i2) {
            String argName = (String)argNames.get(i2);
            String argValue = (String)argValues.get(i2);
            if (argName.equals("patch_name")) {
                this.portalPatchRelativeLocation = argValue;
            }
            if (!argName.equals("PATCH_FILES_LOCATION_TAG")) continue;
            patchFilesLocation = argValue;
        }
        if (this.portalPatchRelativeLocation == null || this.portalPatchRelativeLocation.equals("")) {
            StringBuffer errMsg = new StringBuffer("The portal action is null");
            errMsg.append("\n");
            errMsg.append("The portal patch name is null");
            NullPointerException ne = new NullPointerException(errMsg.toString());
            throw ne;
        }
        String portalFilePath = "";
        portalFilePath = PatchObjectUtil.getPlatformDependentPath(this.portalPatchRelativeLocation);
        if (portalFilePath != null && !portalFilePath.equals("")) {
            this.portalPatchRelativeLocation = portalFilePath;
        }
        StringBuffer loc = new StringBuffer(patchFilesLocation);
        loc.append(File.separator);
        loc.append(this.portalPatchRelativeLocation);
        this.portalAbsLocation = loc.toString();
    }

    protected String getPortalPatchLocation() {
        return this.portalPatchRelativeLocation;
    }

    protected String getPortalAbsoluteLocation() {
        return this.portalAbsLocation;
    }

    protected String getAbsolutePortalPatchLocation(String patchLocation) {
        StringBuffer absPortalLoc = new StringBuffer(patchLocation);
        absPortalLoc.append(File.separator);
        absPortalLoc.append("files");
        absPortalLoc.append(File.separator);
        absPortalLoc.append(this.getPortalPatchLocation());
        return absPortalLoc.toString();
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("   Patch the portal repository home with ");
        String patchLoc = OPatchEnv.getPatchloc();
        buff.append("\"" + this.getAbsolutePortalPatchLocation(patchLoc) + "\"");
        return buff.toString();
    }

    public static String getRunDirectory(String ptlPatchLoc) {
        String ptlCmd = portalAction.getPtlCommand();
        String[] parts = ptlPatchLoc.split(File.separator);
        StringBuffer buff = new StringBuffer("");
        for (int i2 = 0; i2 < parts.length; ++i2) {
            if (parts[i2].equals(ptlCmd)) continue;
            buff.append(parts[i2]);
            if (i2 + 1 >= parts.length || parts[i2 + 1].equals(ptlCmd)) continue;
            buff.append(File.separator);
        }
        return buff.toString();
    }

    private static String getPtlCommand() {
        StringBuffer buff = new StringBuffer("ptlpatch");
        buff.append(".csh");
        return buff.toString();
    }

    public static String getCshLocation(String ptlLocation) {
        String cshLoc;
        block4: {
            cshLoc = "csh";
            BufferedReader bRead = null;
            String inputLine = "";
            try {
                bRead = Files.newBufferedReader(WrapperFactory.getNioServiceWrapper().getPath(ptlLocation, new String[0]), Charset.forName("UTF-8"));
                while ((inputLine = bRead.readLine()) != null) {
                    if (!(inputLine = inputLine.trim()).startsWith("#!")) continue;
                    String[] parts = inputLine.split("\\s+");
                    for (int i2 = 0; i2 < parts.length; ++i2) {
                        if (!parts[i2].startsWith("#!")) continue;
                        cshLoc = parts[i2].replaceFirst("#!", "");
                        break block4;
                    }
                    break;
                }
            }
            catch (IOException e2) {
                OLogger.printStackTrace(e2);
                return cshLoc;
            }
        }
        return cshLoc;
    }

    @Override
    public boolean applicable(String oracleHomePath, String patchLocation) {
        StringBuffer buff = new StringBuffer("portalAction::applicable()");
        OLogger.debug(buff);
        if (!Rules.SystemWrite_continue()) {
            return true;
        }
        String absPortalLoc = this.getAbsolutePortalPatchLocation(patchLocation);
        Path f2 = WrapperFactory.getNioServiceWrapper().getPath(absPortalLoc, new String[0]);
        if (!Files.exists(f2, new LinkOption[0])) {
            buff = new StringBuffer("The patch bundle for portal repository patching \"" + absPortalLoc + "\"");
            buff.append(" does not exist.");
            this.nonApplicableDesc = buff.toString();
            return false;
        }
        String ptlPatchToolLoc = "";
        try {
            ptlPatchToolLoc = OPatchSessionHelper.getPtlToolLocation();
        }
        catch (Exception e2) {
            buff = new StringBuffer("The ptlpatch tool to apply the patch could not be accessed.");
            buff.append("\n");
            buff.append(e2.getMessage());
            OLogger.printStackTrace(e2);
            this.nonApplicableDesc = buff.toString();
            return false;
        }
        f2 = WrapperFactory.getNioServiceWrapper().getPath(ptlPatchToolLoc, new String[0]);
        if (!Files.exists(f2, new LinkOption[0])) {
            buff = new StringBuffer("The ptlpatch tool to apply the patch does not exist \"" + ptlPatchToolLoc + "\"");
            this.nonApplicableDesc = buff.toString();
            return false;
        }
        return true;
    }

    @Override
    public void apply(String oracleHomePath, String patchLocation) throws RuntimeException {
        StringBuffer buff = new StringBuffer("portalAction::apply()");
        OLogger.debug(buff);
        if (!Rules.SystemWrite_continue()) {
            return;
        }
        String errorMsg = this.getApplyFailureDescription();
        StringBuffer runCmd = new StringBuffer();
        SystemCall.ExecReturn ret = null;
        String ptlLocation = "";
        try {
            ptlLocation = OPatchSessionHelper.getPtlToolLocation();
            runCmd.append(ptlLocation);
        }
        catch (Exception exception) {
            // empty catch block
        }
        runCmd.append(" -z ");
        runCmd.append(this.getAbsolutePortalPatchLocation(patchLocation));
        runCmd.append(" -s ");
        runCmd.append(OPatchEnv.getPtlSchema());
        runCmd.append(" -p ");
        runCmd.append(OPatchEnv.getPtlPassword());
        runCmd.append(" -c ");
        runCmd.append(OPatchEnv.getPtlConnect());
        String runDir = portalAction.getRunDirectory(ptlLocation);
        String[] cmd = new String[1];
        if (!OPatchEnv.isWindows()) {
            String cshLoc = portalAction.getCshLocation(ptlLocation);
            cmd[0] = cshLoc + " " + runCmd.toString();
            ret = SystemCall.runtimeExec(cmd, runDir);
        } else {
            cmd[0] = "cmd /C \"" + runCmd.toString() + "\"";
            ret = SystemCall.runtimeExec(cmd, runDir);
        }
        if (!ret.isOK()) {
            buff = new StringBuffer(errorMsg);
            buff.append("\n");
            buff.append("Failure in ptlpatch tool script execution (for APPLY), Message reported:");
            buff.append("\n");
            buff.append(ret.getNormalMessage());
            buff.append("\n");
            buff.append(ret.getErrorMessage());
            OLogger.printlnOnLog(OLogger.INFO, buff.toString());
            buff = new StringBuffer(OLogger.getString("OUI-67524", new Object[]{"apply"}));
            throw new RuntimeException(buff.toString());
        }
    }

    @Override
    public String getApplicableDesc(String oracleHomePath, String owningComponent) {
        String desc = OLogger.getString("OUI-67522", new Object[]{this.nonApplicableDesc, owningComponent, this.getPortalAbsoluteLocation()});
        return desc;
    }

    @Override
    public String getApplyDescription(String oracleHomePath) {
        return "Applying the portal repository patch \"" + this.getPortalAbsoluteLocation() + "\"";
    }

    private String getApplyFailureDescription() {
        StringBuffer failureMsg = new StringBuffer("Apply of portal respository patch failed for");
        failureMsg.append(" \"" + this.getPortalAbsoluteLocation() + "\"");
        return failureMsg.toString();
    }

    @Override
    public boolean rollbackable(String oracleHomePath, String cookedPatchID) {
        StringBuffer buff = new StringBuffer("portalAction::rollbackable()");
        OLogger.debug(buff);
        if (!Rules.SystemWrite_continue()) {
            return true;
        }
        String ptlPatchToolLoc = "";
        try {
            ptlPatchToolLoc = OPatchSessionHelper.getPtlToolLocation();
        }
        catch (Exception e2) {
            buff = new StringBuffer("The ptlpatch tool to rollback the patch could not be accessed.");
            buff.append("\n");
            buff.append(e2.getMessage());
            OLogger.printStackTrace(e2);
            this.nonRollbackableDesc = buff.toString();
            return false;
        }
        Path f2 = WrapperFactory.getNioServiceWrapper().getPath(ptlPatchToolLoc, new String[0]);
        if (!Files.exists(f2, new LinkOption[0])) {
            buff = new StringBuffer("The ptlpatch tool to rollback the patch does not exist \"" + ptlPatchToolLoc + "\"");
            this.nonRollbackableDesc = buff.toString();
            return false;
        }
        return true;
    }

    @Override
    public void rollback(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        StringBuffer buff = new StringBuffer("portalAction::rollback()");
        OLogger.debug(buff);
        if (!Rules.SystemWrite_continue()) {
            return;
        }
        StringBuffer runCmd = new StringBuffer();
        SystemCall.ExecReturn ret = null;
        String ptlLocation = "";
        try {
            ptlLocation = OPatchSessionHelper.getPtlToolLocation();
            runCmd.append(ptlLocation);
        }
        catch (Exception exception) {
            // empty catch block
        }
        runCmd.append(" ");
        runCmd.append("-deinstall");
        runCmd.append(" -b ");
        runCmd.append(OPatchEnv.getPortalPatchID());
        runCmd.append(" -s ");
        runCmd.append(OPatchEnv.getPtlSchema());
        runCmd.append(" -p ");
        runCmd.append(OPatchEnv.getPtlPassword());
        runCmd.append(" -c ");
        runCmd.append(OPatchEnv.getPtlConnect());
        String runDir = portalAction.getRunDirectory(ptlLocation);
        String[] cmd = new String[1];
        if (!OPatchEnv.isWindows()) {
            String cshLoc = portalAction.getCshLocation(ptlLocation);
            cmd[0] = cshLoc + " " + runCmd.toString();
            ret = SystemCall.runtimeExec(cmd, runDir);
        } else {
            cmd[0] = "cmd /C \"" + runCmd.toString() + "\"";
            ret = SystemCall.runtimeExec(cmd, runDir);
        }
        if (!ret.isOK()) {
            buff = new StringBuffer("Failure in ptlpatch tool script execution (for ROLLBACK), Message reported:");
            buff.append("\n");
            buff.append(ret.getNormalMessage());
            buff.append("\n");
            buff.append(ret.getErrorMessage());
            OLogger.printlnOnLog(OLogger.INFO, buff.toString());
            buff = new StringBuffer(OLogger.getString("OUI-67524", new Object[]{"rollback"}));
            throw new RuntimeException(buff.toString());
        }
    }

    @Override
    public String getRollbackScriptEntry(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        return "";
    }

    @Override
    public void backupForRollback(String oracleHomePath, String cookedPatchID) throws RuntimeException {
    }

    @Override
    public String getRollbackableDesc(String oracleHomePath, String owningComponent) {
        String desc = OLogger.getString("OUI-67523", new Object[]{this.nonRollbackableDesc, owningComponent, OPatchEnv.getPortalPatchID()});
        return desc;
    }

    @Override
    public String getBackupForRollbackDesc(String oracleHomePath) {
        return "";
    }

    @Override
    public String getRollbackDescription(String oracleHomePath) {
        return "Rolling back the portal repository patch \"" + OPatchEnv.getPortalPatchID() + "\"";
    }

    @Override
    public boolean isNewFile(String oracleHomePath, String cookedPatchID, boolean beforeApply) {
        return false;
    }

    @Override
    public String getChildPath() {
        return "";
    }

    @Override
    public String getParentFilePath(String oracleHomePath) {
        return "";
    }

    @Override
    public String getActionName() {
        return "";
    }

    @Override
    public String getActionDesc() {
        return "";
    }

    @Override
    public int getBackupForRollbackFileNumber(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        return 0;
    }

    static {
        block16: {
            setupErrorMessage = new StringBuffer();
            isSetupError = false;
            try {
                OLogger.debug(new StringBuffer("Setting perl related environment variables for portal action..."));
                String oracleHome = "";
                String msg = "";
                oracleHome = OUIReplacer.getEnv("ORACLE_HOME");
                if (oracleHome == null || oracleHome.equals("")) {
                    isSetupError = true;
                    msg = "Oracle Home environment value is not set";
                    setupErrorMessage.append(msg);
                    setupErrorMessage.append("\n");
                    OLogger.debug(setupErrorMessage);
                    break block16;
                }
                StringBuffer ldLibPath = new StringBuffer(oracleHome);
                ldLibPath.append(File.separator);
                ldLibPath.append("oui");
                ldLibPath.append(File.separator);
                ldLibPath.append("lib");
                Path fld = WrapperFactory.getNioServiceWrapper().getPath(ldLibPath.toString(), new String[0]);
                if (Files.exists(fld, new LinkOption[0]) && Files.isDirectory(fld, new LinkOption[0])) {
                    OUIReplacer.setEnv("LD_LIBRARY_PATH", ldLibPath.toString(), true);
                } else {
                    isSetupError = true;
                    msg = "Unable to set the environment variable \"LD_LIBRARY_PATH\" properly";
                    setupErrorMessage.append(msg);
                    setupErrorMessage.append("\n");
                    OLogger.debug(setupErrorMessage);
                }
                String APACHE = "Apache";
                String BIN = "bin";
                String PERL = "perl";
                String LIB = "lib";
                boolean apache = false;
                StringBuffer testPerlFile = new StringBuffer(oracleHome);
                StringBuffer testApacheFile = new StringBuffer(oracleHome);
                StringBuffer remain = new StringBuffer();
                remain.append(File.separator);
                remain.append(PERL);
                remain.append(File.separator);
                remain.append(BIN);
                remain.append(File.separator);
                remain.append(PERL);
                testApacheFile.append(File.separator);
                testApacheFile.append(APACHE);
                testPerlFile.append(remain);
                testApacheFile.append(remain);
                Path f1 = WrapperFactory.getNioServiceWrapper().getPath(testPerlFile.toString(), new String[0]);
                Path f2 = WrapperFactory.getNioServiceWrapper().getPath(testApacheFile.toString(), new String[0]);
                if (Files.exists(f1, new LinkOption[0]) && Files.isRegularFile(f1, new LinkOption[0])) {
                    OUIReplacer.setEnv("PERL_BIN", testPerlFile.toString());
                } else if (Files.exists(f2, new LinkOption[0]) && Files.isRegularFile(f2, new LinkOption[0])) {
                    OUIReplacer.setEnv("PERL_BIN", testApacheFile.toString());
                    apache = true;
                } else {
                    isSetupError = true;
                    msg = "Unable to set the environment variable \"PERL_BIN\" properly";
                    setupErrorMessage.append(msg);
                    setupErrorMessage.append("\n");
                    OLogger.debug(setupErrorMessage);
                }
                StringBuffer common = new StringBuffer(oracleHome);
                if (apache) {
                    common.append(File.separator);
                    common.append(APACHE);
                }
                common.append(File.separator);
                common.append(PERL);
                common.append(File.separator);
                common.append(LIB);
                Path fLib = WrapperFactory.getNioServiceWrapper().getPath(common.toString(), new String[0]);
                if (Files.isDirectory(fLib, new LinkOption[0])) {
                    findPerlLibDir myFilter = new findPerlLibDir();
                    try {
                        DirectoryStream<Path> directoryStream = Files.newDirectoryStream(fLib, myFilter);
                    }
                    catch (Exception e2) {
                        isSetupError = true;
                        msg = "Unable to get the recent library of perl";
                        setupErrorMessage.append(msg);
                        setupErrorMessage.append("\n");
                        setupErrorMessage.append(e2.getMessage());
                        OLogger.debug(setupErrorMessage);
                    }
                    String libDirName = findPerlLibDir.getAcceptedString();
                    if (libDirName == null || libDirName.equals("")) {
                        isSetupError = true;
                        msg = "Unable to get the recent library of perl";
                        setupErrorMessage.append(msg);
                        setupErrorMessage.append("\n");
                        OLogger.debug(setupErrorMessage);
                    } else {
                        common.append(File.separator);
                        common.append(libDirName);
                        OUIReplacer.setEnv("PERL5LIB", common.toString());
                    }
                } else {
                    isSetupError = true;
                    msg = "The library path of perl is not a directory";
                    setupErrorMessage.append(msg);
                    setupErrorMessage.append("\n");
                    OLogger.debug(setupErrorMessage);
                }
                String ldOutput = OUIReplacer.getEnv("LD_LIBRARY_PATH");
                String binOutput = OUIReplacer.getEnv("PERL_BIN");
                String libOutput = OUIReplacer.getEnv("PERL5LIB");
                OLogger.debug(new StringBuffer("LD_LIBRARY_PATH = " + ldOutput));
                OLogger.debug(new StringBuffer("PERL_BIN = " + binOutput));
                OLogger.debug(new StringBuffer("PERL5LIB = " + libOutput));
            }
            catch (Exception e3) {
                String excepMsg = "";
                isSetupError = true;
                excepMsg = "Unable to setup perl envrionment variables for portal action";
                setupErrorMessage.append(excepMsg);
                setupErrorMessage.append("\n");
                setupErrorMessage.append(e3.getMessage());
                OLogger.debug(setupErrorMessage);
            }
        }
    }

    static class findPerlLibDir
    implements DirectoryStream.Filter<Path> {
        private static String currentAccepted = "";
        private static ArrayList tokenInt = new ArrayList();

        findPerlLibDir() {
        }

        protected static String getAcceptedString() {
            return currentAccepted;
        }

        @Override
        public boolean accept(Path entry) {
            String name = entry.getFileName().toString();
            if (Files.isDirectory(entry, new LinkOption[0])) {
                Pattern p1 = Pattern.compile("\\.");
                Pattern p2 = Pattern.compile("\\d+[\\.\\d+]*");
                Matcher m2 = null;
                boolean matched = false;
                m2 = p2.matcher(name);
                matched = m2.matches();
                if (matched) {
                    String[] portions = p1.split(name);
                    if (tokenInt.size() == 0) {
                        findPerlLibDir.setIntList(portions);
                        currentAccepted = name;
                        return true;
                    }
                    for (int i2 = 0; i2 < portions.length; ++i2) {
                        int x = Integer.parseInt(portions[i2]);
                        int y = -1;
                        Integer bY = null;
                        try {
                            bY = (Integer)tokenInt.get(i2);
                        }
                        catch (IndexOutOfBoundsException e2) {
                            findPerlLibDir.setIntList(portions);
                            currentAccepted = name;
                            return true;
                        }
                        y = bY;
                        if (x <= y) continue;
                        findPerlLibDir.setIntList(portions);
                        currentAccepted = name;
                        return true;
                    }
                    return true;
                }
                return false;
            }
            return false;
        }

        private static void setIntList(String[] portion) {
            tokenInt = new ArrayList();
            try {
                for (int j2 = 0; j2 < portion.length; ++j2) {
                    tokenInt.add(new Integer(Integer.parseInt(portion[j2])));
                }
            }
            catch (NumberFormatException e2) {
                OLogger.printStackTrace(e2);
                tokenInt = new ArrayList();
            }
        }
    }
}

