/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchfafmw;

import oracle.opatch.opatchfafmw.Domain;
import oracle.opatch.opatchfafmw.FMWContext;
import oracle.opatch.opatchfafmw.Logger;
import oracle.opatch.opatchfafmw.OPatchStepAdapter;
import oracle.opatch.opatchfafmw.Operation;
import oracle.opatch.opatchsdk.OPatchFAStep;

final class CheckAdminServer
implements Operation {
    CheckAdminServer() {
    }

    @Override
    public void run(FMWContext c2) {
        OPatchStepAdapter prereqStep = null;
        Domain d2 = null;
        try {
            d2 = c2.getDomain();
            d2.setupJMXConnection();
        }
        catch (Throwable e2) {
            String errorMsg = "Error in connecting to Admin Server.";
            if (e2 instanceof ClassNotFoundException || e2 instanceof NoClassDefFoundError) {
                errorMsg = errorMsg + " Class \"" + e2.getMessage() + "\" is not found. Please check if runtime classpaths are properly set.";
            }
            prereqStep = new OPatchStepAdapter(OPatchFAStep.CHECK_ADMIN_SERVER_AVAILABLE);
            prereqStep.setSuccess(false);
            prereqStep.setStepDescription("Check if Admin Server is available");
            prereqStep.setErrorMessage(errorMsg);
            prereqStep.setExceptionObject(new RuntimeException(e2));
            c2.getContextBuilder().setFailedPrereqStep(prereqStep);
            throw new RuntimeException(e2);
        }
        String state = "";
        try {
            state = d2.getAdminServerState();
            Logger.logi("State of the admin server \"" + d2.getAdminServerName() + "\" is : " + state);
        }
        catch (Throwable e3) {
            String errorMsg = "Not able to get the state of Admin Server.";
            if (e3 instanceof ClassNotFoundException || e3 instanceof NoClassDefFoundError) {
                errorMsg = errorMsg + " Class \"" + e3.getMessage() + "\" is not found. Please check if runtime classpaths are properly set.";
            }
            prereqStep = new OPatchStepAdapter(OPatchFAStep.CHECK_ADMIN_SERVER_STATE);
            prereqStep.setSuccess(false);
            prereqStep.setStepDescription("Check the state of Admin Server.");
            prereqStep.setErrorMessage(errorMsg);
            prereqStep.setExceptionObject(new RuntimeException(e3));
            c2.getContextBuilder().setFailedPrereqStep(prereqStep);
            throw new RuntimeException(e3);
        }
        if (state == null) {
            state = "";
        }
        if (state == null || !state.equals("RUNNING")) {
            prereqStep = new OPatchStepAdapter(OPatchFAStep.CHECK_ADMIN_SERVER_STATE);
            prereqStep.setSuccess(false);
            prereqStep.setStepDescription("Check the state of Admin Server.");
            String errorMsg = "The Admin Server state is \"" + state + "\"i. The desired state should be 'RUNNING'.";
            prereqStep.setErrorMessage(errorMsg);
            c2.getContextBuilder().setFailedPrereqStep(prereqStep);
            throw new RuntimeException(errorMsg);
        }
    }
}

