/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchfafmw;

import java.io.File;
import java.nio.file.Path;
import java.util.Properties;
import oracle.as.biapps.patch.framework.opatch.OpatchEntryPoint;
import oracle.opatch.opatchfafmw.BIP;
import oracle.opatch.opatchfafmw.FMWContext;
import oracle.opatch.opatchfafmw.Logger;
import oracle.opatch.opatchfafmw.OPatchStepAdapter;
import oracle.opatch.opatchfafmw.Operation;
import oracle.opatch.opatchsdk.OPatchFAStep;
import oracle.opatch.wrappers.WrapperFactory;

final class DeployBIP
implements Operation {
    DeployBIP() {
    }

    @Override
    public void run(FMWContext c2) {
        String oh = c2.getOracleHome();
        String patchLoc = c2.getPatchLocation();
        String patchID = c2.getPatchID();
        String errorMsg = "";
        String[] copyListRelativeToOracleHome = new String[c2.getBIP().size()];
        String biHome = "";
        Logger.logi("[BIP] BIP Deploy List: ");
        int count = 0;
        for (BIP bi : c2.getBIP()) {
            copyListRelativeToOracleHome[count] = bi.getRelativePath();
            biHome = bi.getBIHome();
            Logger.logi(bi.toString());
            ++count;
        }
        for (int i2 = 0; i2 < count; ++i2) {
            Logger.logi("Copy path relative to OH: " + copyListRelativeToOracleHome[i2]);
        }
        Logger.logi("[BIP] Oracle home : " + oh);
        Logger.logi("[BIP] Patch archive root : " + patchLoc);
        Logger.logi("[BIP] Patch ID : " + patchID);
        Properties p2 = c2.getInterviewProperties();
        if (p2 == null) {
            Logger.logi("[BIP] Since property object is null, there are no interview elements defined in automation.xml");
        }
        Path oracleHome = WrapperFactory.getNioServiceWrapper().getPath(oh, new String[0]);
        Path explodedPatchArchiveRoot = WrapperFactory.getNioServiceWrapper().getPath(patchLoc, new String[0]);
        Path biHomeObj = WrapperFactory.getNioServiceWrapper().getPath(biHome, new String[0]);
        OPatchStepAdapter bipDeployStep = new OPatchStepAdapter(OPatchFAStep.BIP_DEPLOY);
        bipDeployStep.setStepDescription("Deploy BIP");
        try {
            OpatchEntryPoint.deploy((File)biHomeObj.toFile(), (File)explodedPatchArchiveRoot.toFile(), (String[])copyListRelativeToOracleHome, (String)patchID, (Properties)p2);
            bipDeployStep.setSuccess(true);
            c2.getContextBuilder().addExecutionStep(bipDeployStep);
        }
        catch (Throwable t) {
            errorMsg = "Error in deploying BIP. ";
            if (t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError) {
                errorMsg = errorMsg + " Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set.";
            }
            RuntimeException re = new RuntimeException(t);
            bipDeployStep.setSuccess(false);
            bipDeployStep.setErrorMessage(errorMsg);
            bipDeployStep.setExceptionObject(re);
            c2.getContextBuilder().addExecutionStep(bipDeployStep);
            Logger.logi("[BIP DEPLOY ERROR] " + re.getMessage());
            Logger.loge(re);
            throw re;
        }
    }
}

