/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchfafmw;

import java.util.Hashtable;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import oracle.opatch.opatchfafmw.Logger;
import oracle.opatch.opatchfafmw.Util;
import oracle.opatch.opatchfafmw.rb.RB;
import weblogic.management.jmx.MBeanServerInvocationHandler;
import weblogic.management.mbeanservers.domainruntime.DomainRuntimeServiceMBean;

class JMXConnection {
    protected static final String DOMAIN_RUNTIME = "weblogic.management.mbeanservers.domainruntime";
    protected static final String SERVER_RUNTIME = "weblogic.management.mbeanservers.runtime";
    protected static final String EDIT_DOMAIN = "weblogic.management.mbeanservers.edit";
    private static JMXConnector domainConnector;
    private static MBeanServerConnection mbs;

    private JMXConnection() {
    }

    protected static JMXConnector getConnector(String protocol, String host, int port, String username, String password, String jndiName) {
        JMXServiceURL serviceURL = null;
        try {
            serviceURL = new JMXServiceURL(protocol, host, port, "/jndi/" + jndiName);
        }
        catch (Exception e2) {
            Logger.loge(e2);
            Logger.error(RB.Entry.MALFORMED_JMX_SERVICE_URL, new Object[0]);
        }
        JMXConnector connector = null;
        Hashtable<String, Object> h2 = new Hashtable<String, Object>();
        h2.put("java.naming.security.principal", username);
        h2.put("java.naming.security.credentials", password);
        h2.put("jmx.remote.protocol.provider.pkgs", "weblogic.management.remote");
        h2.put("jmx.remote.x.request.waiting.timeout", new Long(600000L));
        try {
            connector = JMXConnectorFactory.connect(serviceURL, h2);
        }
        catch (Exception e3) {
            Logger.loge(e3);
            Logger.error(RB.Entry.ERROR_IN_CONNECTING_TO_URL, protocol + "://" + host + ":" + port, username);
        }
        return connector;
    }

    protected static MBeanServerConnection getConnection(JMXConnector connector) {
        MBeanServerConnection connection = null;
        try {
            connection = connector.getMBeanServerConnection();
        }
        catch (Exception e2) {
            Logger.loge(e2);
            Logger.error(RB.Entry.ERROR_IN_GETTING_MBEAN_SERVER_CONNECTION, new Object[0]);
        }
        return connection;
    }

    static JMXConnector getConnector(String protocol, String host, int port, String username, String password) {
        JMXConnector connector = JMXConnection.getConnector(protocol, host, port, username, password, DOMAIN_RUNTIME);
        return connector;
    }

    static DomainRuntimeServiceMBean getDomainRuntimeService(String protocol, String host, int port, String username, String password) {
        domainConnector = JMXConnection.getConnector(protocol, host, port, username, password, DOMAIN_RUNTIME);
        mbs = JMXConnection.getConnection(domainConnector);
        DomainRuntimeServiceMBean drsMBean = null;
        try {
            drsMBean = (DomainRuntimeServiceMBean)MBeanServerInvocationHandler.newProxyInstance((MBeanServerConnection)mbs, (ObjectName)new ObjectName(DomainRuntimeServiceMBean.OBJECT_NAME));
        }
        catch (Exception e2) {
            Logger.loge(e2);
            Logger.error(RB.Entry.ERROR_IN_GETTING_DRS, new Object[0]);
        }
        return drsMBean;
    }

    static MBeanServerConnection getJMXConnection() {
        if (mbs != null) {
            return mbs;
        }
        return null;
    }

    static String getHomeGUID(String protocol, String host, int port, String username, String password) {
        JMXConnector jc = null;
        String homeGUID = null;
        try {
            jc = JMXConnection.getConnector(protocol, host, port, username, password, SERVER_RUNTIME);
            MBeanServerConnection mbs = JMXConnection.getConnection(jc);
            ObjectName on = new ObjectName("oracle.jrf.server:name=JRFService,type=oracle.jrf.JRFServerScopedServiceMBean");
            homeGUID = (String)mbs.getAttribute(on, "CommonComponentsHomeGUID");
        }
        catch (Exception e2) {
            Logger.loge(e2);
        }
        JMXConnection.closeConnector(jc);
        homeGUID = Util.norm(homeGUID);
        if (Logger.debug) {
            Logger.debug("HomeGUID [" + host + "][" + port + "] :" + homeGUID);
        }
        return homeGUID;
    }

    static void close() {
        JMXConnection.closeConnector(domainConnector);
    }

    protected static void closeConnector(JMXConnector connector) {
        if (connector == null) {
            return;
        }
        final class CloseHandler
        extends Thread {
            final /* synthetic */ JMXConnector val$connector;

            CloseHandler(JMXConnector jMXConnector) {
                this.val$connector = jMXConnector;
            }

            @Override
            public void run() {
                try {
                    if (Logger.debug) {
                        Logger.debug("Closing JMX Connection ...");
                    }
                    this.val$connector.close();
                    if (Logger.debug) {
                        Logger.debug("JMX Connection Closed.");
                    }
                }
                catch (Exception e2) {
                    Logger.loge(e2);
                }
            }
        }
        CloseHandler ch = new CloseHandler(connector);
        ch.start();
        try {
            ch.join(60000L);
        }
        catch (Exception e2) {
            Logger.loge(e2);
        }
    }
}

