/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchfafmw;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.opatch.OPatchSDK;
import oracle.opatch.fmwclient.FMWClient;
import oracle.opatch.opatchfafmw.Logger;
import oracle.opatch.opatchfafmw.TargetList;
import oracle.opatch.opatchfafmw.Util;
import oracle.opatch.opatchsdk.OPatchJEELifecycleAction;

class LifecycleOpThread
extends Thread {
    private final boolean start;
    List myClients;
    List myActionObjs;
    String oracleHome;
    String timestamp;

    LifecycleOpThread(boolean start, String oh, String timestamp) {
        this.start = start;
        this.oracleHome = oh;
        this.timestamp = timestamp;
        this.myClients = new ArrayList(5);
        this.myActionObjs = new ArrayList(5);
    }

    void addClient(FMWClient client) {
        this.myClients.add(client);
    }

    void addAction(OPatchJEELifecycleAction action) {
        this.myActionObjs.add(action);
    }

    @Override
    public void run() {
        OPatchSDK.setEnableConsoleLater(true);
        for (int i2 = 0; i2 < this.myClients.size(); ++i2) {
            this.runMyClient((FMWClient)this.myClients.get(i2), (OPatchJEELifecycleAction)this.myActionObjs.get(i2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runMyClient(FMWClient client, OPatchJEELifecycleAction action) {
        try {
            TargetList targetList;
            Set<String> targets;
            Iterator<String> iterator;
            String domain = "";
            String serverName = "";
            if (client.getDomain() != null) {
                domain = Util.norm(client.getDomain().getDomainName());
            }
            if (client.getTarget() != null && (iterator = (targets = (targetList = client.getTarget()).getTargets()).iterator()).hasNext()) {
                String target;
                serverName = target = iterator.next();
            }
            String logfile = "";
            logfile = this.start ? OPatchSDK.initLogFile(this.oracleHome, this.timestamp, "Start_Server_" + serverName + "_" + domain, false) : OPatchSDK.initLogFile(this.oracleHome, this.timestamp, "Stop_Server_" + serverName + "_" + domain, false);
            action.setLogFile(logfile);
            client.setLogFile(logfile);
            Logger.logm("Thread name=\"" + Thread.currentThread().getName() + "\", Server name=\"" + serverName + "\", Domain name=\"" + domain + "\", Please monitor the log file: \"" + logfile + "\"");
            Logger.log("Server name=\"" + serverName + "\", Domain name=\"" + domain + "\"");
            client.setTimeoutFlag(false);
            if (this.start) {
                client.startNServer();
            } else {
                client.stopNServer();
            }
        }
        catch (Throwable t) {
            RuntimeException re = new RuntimeException(t);
            Logger.loge(re);
        }
        finally {
            Logger.close();
        }
    }
}

