/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchfafmw;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import oracle.opatch.opatchfafmw.Logger;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.wrappers.WrapperFactory;

class Util {
    private Util() {
    }

    static String norm(String s) {
        return s == null ? "" : s.trim();
    }

    static boolean existFile(String s) {
        Path f2 = WrapperFactory.getNioServiceWrapper().getPath(s, new String[0]);
        return Files.exists(f2, new LinkOption[0]);
    }

    static void deleteFile(String s) {
        Path f2 = WrapperFactory.getNioServiceWrapper().getPath(s, new String[0]);
        if (Files.exists(f2, new LinkOption[0])) {
            try {
                Files.delete(f2);
            }
            catch (IOException e2) {
                OLogger.debug(e2.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean copyFile(String in, String out) {
        InputStream input = null;
        OutputStream output = null;
        try {
            int length;
            input = Files.newInputStream(WrapperFactory.getNioServiceWrapper().getPath(in, new String[0]), new OpenOption[0]);
            output = Files.newOutputStream(WrapperFactory.getNioServiceWrapper().getPath(out, new String[0]), new OpenOption[0]);
            byte[] buffer = new byte[1024];
            while ((length = input.read(buffer)) > 0) {
                output.write(buffer, 0, length);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e2) {
            Logger.loge("File " + in + " could not be copied to the temporary location " + out);
            Logger.loge(e2);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
                if (output != null) {
                    output.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    static String getTempLocation(String loc, String compName) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'_'HH-mm-ssa");
        String formattedDate = dateFormatter.format(new Date());
        StringBuffer sb = new StringBuffer();
        String mainDir = "compositeScratchArea";
        sb.append(loc).append(System.getProperty("file.separator")).append(mainDir).append(System.getProperty("file.separator")).append(compName).append(formattedDate);
        Path f2 = WrapperFactory.getNioServiceWrapper().getPath(sb.toString(), new String[0]);
        if (!Files.exists(f2, new LinkOption[0])) {
            try {
                Files.createDirectories(f2, new FileAttribute[0]);
            }
            catch (IOException e2) {
                OLogger.debug(e2.getMessage());
            }
        }
        return sb.toString();
    }
}

