/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchlogger;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class OLoggerACL {
    private static final Map<String, Class<?>> primitiveClazz = new HashMap();
    private static final String INTEGER = "Integer";
    private static final String BYTE = "Byte";
    private static final String CHARACTOR = "Charactor";
    private static final String SHORT = "Short";
    private static final String LONG = "Long";
    private static final String FLOAT = "Float";
    private static final String DOUBLE = "Double";
    private static final String BOOLEAN = "Boolean";

    public static Object invokeOLogger(Object caller, String method, Object[] args) throws IllegalAccessException {
        String callerName = caller.getClass().getName();
        String packageName = "";
        if (callerName.lastIndexOf(".") != -1) {
            packageName = callerName.substring(0, callerName.lastIndexOf("."));
        }
        if (packageName.equals("oracle.opatch") || packageName.equals("oracle.opatch.opatchsdk") || packageName.equals("oracle.opatch.gi") || packageName.equals("oracle.opatch.opatchutil")) {
            try {
                Class<?> ologger = Class.forName("oracle.opatch.opatchlogger.OLogger");
                Class[] argTypes = new Class[]{};
                if (args != null) {
                    argTypes = new Class[args.length];
                    for (int i2 = 0; i2 < args.length; ++i2) {
                        argTypes[i2] = args[i2].getClass();
                        String className = argTypes[i2].getName();
                        Class<?> primitiveClass = primitiveClazz.get(className = className.substring(className.lastIndexOf(".") + 1));
                        if (primitiveClass == null) continue;
                        argTypes[i2] = primitiveClass;
                    }
                }
                Method desiredMethod = null;
                Method[] methods = ologger.getDeclaredMethods();
                for (int i3 = 0; i3 < methods.length; ++i3) {
                    if (!methods[i3].getName().equals(method)) continue;
                    Class<?>[] pTypes = methods[i3].getParameterTypes();
                    boolean paraApplicable = true;
                    if (pTypes.length == argTypes.length) {
                        for (int j2 = 0; j2 < pTypes.length; ++j2) {
                            if (pTypes[j2].isAssignableFrom(argTypes[j2])) continue;
                            paraApplicable = false;
                            break;
                        }
                    } else {
                        paraApplicable = false;
                    }
                    if (!paraApplicable) continue;
                    desiredMethod = methods[i3];
                }
                if (desiredMethod == null) {
                    String argsFormat = "";
                    for (int i4 = 0; i4 < argTypes.length; ++i4) {
                        argsFormat = argsFormat + argTypes[i4].getName();
                        if (i4 == argTypes.length - 1) continue;
                        argsFormat = argsFormat + " ,";
                    }
                    throw new NoSuchMethodException("The method " + method + "(" + argsFormat + ") does not exist in OLogger.");
                }
                Object result = desiredMethod.invoke(ologger, args);
                return result;
            }
            catch (SecurityException e2) {
                throw new IllegalAccessException(e2.getMessage());
            }
            catch (NoSuchMethodException e3) {
                throw new IllegalAccessException(e3.getMessage());
            }
            catch (IllegalArgumentException e4) {
                throw new IllegalAccessException(e4.getMessage());
            }
            catch (InvocationTargetException e5) {
                String excepMsg = e5.getMessage();
                Throwable t = e5;
                while (((Throwable)t).getCause() != null) {
                    excepMsg = ((Throwable)t).getCause().getMessage();
                    t = ((Throwable)t).getCause();
                }
                throw new IllegalAccessException(excepMsg);
            }
            catch (ClassNotFoundException e6) {
                throw new IllegalAccessException(e6.getMessage());
            }
            catch (Throwable t) {
                throw new IllegalAccessException("Exception occurs on OLogger method execution : " + t.getMessage());
            }
        }
        throw new IllegalAccessException("Permission denied. Access is available only for class in package oracle.opatch, oracle.opatch.gi and oracle.opatch.opatchutil");
    }

    static {
        primitiveClazz.put(INTEGER, Integer.TYPE);
        primitiveClazz.put(BYTE, Byte.TYPE);
        primitiveClazz.put(CHARACTOR, Character.TYPE);
        primitiveClazz.put(SHORT, Short.TYPE);
        primitiveClazz.put(LONG, Long.TYPE);
        primitiveClazz.put(FLOAT, Float.TYPE);
        primitiveClazz.put(DOUBLE, Double.TYPE);
        primitiveClazz.put(BOOLEAN, Boolean.TYPE);
    }
}

