/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchprereq;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchingModel;
import oracle.opatch.opatchprereq.ConflictOutput;
import oracle.opatch.opatchprereq.PrereqResult;

public class ConflictMatrixOutput
extends ConflictOutput {
    ConflictedPatch[][] oneOffMatrix = new ConflictedPatch[0][0];
    private ConflictMatrixOutput compositeMatrix = null;

    public void setCompositeMatrix(ConflictMatrixOutput compositeMatrix) {
        this.compositeMatrix = compositeMatrix;
    }

    protected ConflictMatrixOutput() {
    }

    protected ConflictMatrixOutput(int row, int column) {
        this.oneOffMatrix = new ConflictedPatch[row][column];
        for (int i2 = 0; i2 < row; ++i2) {
            for (int j2 = 0; j2 < column; ++j2) {
                this.oneOffMatrix[i2][j2] = new ConflictedPatch();
            }
        }
    }

    protected void add(int row, int column, String[] details, ConflictType type) {
        this.oneOffMatrix[row][column].set(details, type);
        this.setResult(PrereqResult.ExecuteStatus.FAILED);
    }

    public ConflictType getConflictType(int row, int column) {
        return this.oneOffMatrix[row][column].getConflictType();
    }

    protected void setConflictType(int row, int column, ConflictType type) {
        this.oneOffMatrix[row][column].setConflictType(type);
    }

    public String[] getDetails(int row, int column) {
        return this.oneOffMatrix[row][column].getDetails();
    }

    public String getRowPatchID(int row, int column) {
        return this.oneOffMatrix[row][column].getRowID();
    }

    public String getColumnPatchID(int row, int column) {
        return this.oneOffMatrix[row][column].getColID();
    }

    protected void setRowPatchID(int row, int column, String rowPID) {
        this.oneOffMatrix[row][column].setRowID(rowPID);
    }

    protected void setColumnPatchID(int row, int column, String colPID) {
        this.oneOffMatrix[row][column].setColID(colPID);
    }

    public int getRowLength() {
        return this.oneOffMatrix.length;
    }

    public int getColumnLength() {
        return this.oneOffMatrix != null && this.oneOffMatrix.length > 0 ? this.oneOffMatrix[0].length : 0;
    }

    public void setRowPatchType(int row, int column, PatchType type) {
        this.oneOffMatrix[row][column].setRowType(type);
    }

    public PatchType getRowPatchType(int row, int column) {
        return this.oneOffMatrix[row][column].getRowType();
    }

    public void setColumnPatchType(int row, int column, PatchType type) {
        this.oneOffMatrix[row][column].setColType(type);
    }

    public PatchType getColumnPatchType(int row, int column) {
        return this.oneOffMatrix[row][column].getColType();
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer(super.toString());
        buff.append(this.getConflictDetailsString());
        return buff.toString();
    }

    public ArrayList<String> getListOfWorsePatches() {
        ArrayList<String> worsePatches = new ArrayList<String>();
        int rowLength = this.getRowLength();
        int colLength = this.getColumnLength();
        for (int i2 = 0; i2 < rowLength; ++i2) {
            for (int j2 = 0; j2 < colLength; ++j2) {
                if (this.getConflictType(i2, j2) != ConflictType.WORSER_PATCH && this.getConflictType(i2, j2) != ConflictType.IDENTICAL_PATCH) continue;
                worsePatches.add(this.getRowPatchID(i2, 0));
            }
        }
        return worsePatches;
    }

    public String getConflictDetailsString() {
        int rowLength = this.getRowLength();
        int colLength = this.getColumnLength();
        int patchingModel = PatchingModel.returnModelCode(OPatchEnv.getOracleHome());
        if (patchingModel == 2 && rowLength * colLength > 64) {
            return "";
        }
        HashSet<String> canGo = new HashSet<String>();
        for (OneOffEntry canGoPatch : this.getListOfPatchesThatCanGoNow()) {
            canGo.add(canGoPatch.getID());
        }
        HashSet<String> duplicateCanNotGo = new HashSet<String>();
        for (int i2 = 0; i2 < rowLength; ++i2) {
            for (int j2 = 0; j2 < colLength; ++j2) {
                if (this.getConflictType(i2, j2) != ConflictType.WORSER_PATCH && this.getConflictType(i2, j2) != ConflictType.IDENTICAL_PATCH || canGo.contains(this.getRowPatchID(i2, 0))) continue;
                duplicateCanNotGo.add(this.getRowPatchID(i2, 0));
            }
        }
        StringBuffer buff = new StringBuffer();
        StringBuffer header = new StringBuffer();
        StringBuffer compositeOutput = new StringBuffer();
        if (this.compositeMatrix != null) {
            compositeOutput.append(this.compositeMatrix.getCombinedCompositeOutput(duplicateCanNotGo));
            header.append("\n\nDetail Conflicts/Supersets for each patch are:");
        } else {
            header.append("\nConflicts/Supersets for each patch are:");
        }
        boolean needHeader = false;
        for (int i3 = 0; i3 < rowLength; ++i3) {
            StringBuffer tBuf = new StringBuffer("\n\n" + (Object)((Object)this.getRowPatchType(i3, 0)) + " : " + this.getRowPatchID(i3, 0));
            if (OPatchEnv.getSessionType().equals("util") && duplicateCanNotGo.contains(this.getRowPatchID(i3, 0))) continue;
            boolean hasSomething = false;
            for (int j3 = 0; j3 < colLength; ++j3) {
                int k2;
                String[] detail;
                if (this.getConflictType(i3, j3) == ConflictType.BUG_SUPERSET) {
                    detail = this.getDetails(i3, j3);
                    if (detail == null || detail.length <= 0) continue;
                    needHeader = true;
                    if (this.getColumnPatchType(i3, j3).equals((Object)PatchType.SUBPATCH)) {
                        tBuf.append("\n\n\tBug Superset of " + (Object)((Object)PatchType.SUBPATCH) + " " + this.getColumnPatchID(i3, j3));
                    } else {
                        tBuf.append("\n\n\tBug Superset of " + this.getColumnPatchID(i3, j3));
                    }
                    tBuf.append("\n\tSuper set bugs are:\n\t");
                    tBuf.append(detail[0]);
                    for (k2 = 1; k2 < detail.length; ++k2) {
                        tBuf.append(", " + detail[k2]);
                    }
                    hasSomething = true;
                    continue;
                }
                if (this.getConflictType(i3, j3) == ConflictType.BUG_SUBSET) {
                    detail = this.getDetails(i3, j3);
                    if (detail == null || detail.length <= 0) continue;
                    needHeader = true;
                    if (this.getColumnPatchType(i3, j3).equals((Object)PatchType.SUBPATCH)) {
                        tBuf.append("\n\n\tBug SubSet of " + (Object)((Object)PatchType.SUBPATCH) + " " + this.getColumnPatchID(i3, j3));
                    } else {
                        tBuf.append("\n\n\tBug SubSet of " + this.getColumnPatchID(i3, j3));
                    }
                    tBuf.append("\n\tSubset bugs are:\n\t");
                    tBuf.append(detail[0]);
                    for (k2 = 1; k2 < detail.length; ++k2) {
                        tBuf.append(", " + detail[k2]);
                    }
                    hasSomething = true;
                    continue;
                }
                if (this.getConflictType(i3, j3) == ConflictType.BUG_CONFLICT) {
                    needHeader = true;
                    if (this.getColumnPatchType(i3, j3).equals((Object)PatchType.SUBPATCH)) {
                        tBuf.append("\n\n\tBug Conflict with " + (Object)((Object)PatchType.SUBPATCH) + " " + this.getColumnPatchID(i3, j3));
                    } else {
                        tBuf.append("\n\n\tBug Conflict with " + this.getColumnPatchID(i3, j3));
                    }
                    tBuf.append("\n\tConflicting bugs are:\n\t");
                    detail = this.getDetails(i3, j3);
                    tBuf.append(detail[0]);
                    for (k2 = 1; k2 < detail.length; ++k2) {
                        tBuf.append(", " + detail[k2]);
                    }
                    hasSomething = true;
                    continue;
                }
                if (this.getConflictType(i3, j3) == ConflictType.GENERIC_CONFLICT) {
                    needHeader = true;
                    if (this.getColumnPatchType(i3, j3).equals((Object)PatchType.SUBPATCH)) {
                        tBuf.append("\n\n\tConflict with " + (Object)((Object)PatchType.SUBPATCH) + " " + this.getColumnPatchID(i3, j3));
                    } else {
                        tBuf.append("\n\n\tConflict with " + this.getColumnPatchID(i3, j3));
                    }
                    tBuf.append("\n\tConflict details:\n\t");
                    detail = this.getDetails(i3, j3);
                    tBuf.append(detail[0]);
                    for (k2 = 1; k2 < detail.length; ++k2) {
                        tBuf.append("\n\t" + detail[k2]);
                    }
                    hasSomething = true;
                    continue;
                }
                if (this.getConflictType(i3, j3) == ConflictType.WORSER_PATCH) {
                    hasSomething = false;
                    if (!this.getColumnPatchType(i3, j3).equals((Object)PatchType.SUBPATCH)) continue;
                    continue;
                }
                if (this.getConflictType(i3, j3) == ConflictType.BETTER_PATCH) {
                    needHeader = true;
                    hasSomething = true;
                    if (this.getColumnPatchType(i3, j3).equals((Object)PatchType.SUBPATCH)) {
                        tBuf.append("\n\n\tBetter duplicate of " + (Object)((Object)PatchType.SUBPATCH) + " " + this.getColumnPatchID(i3, j3));
                        continue;
                    }
                    tBuf.append("\n\n\tBetter duplicate of " + this.getColumnPatchID(i3, j3));
                    continue;
                }
                if (this.getConflictType(i3, j3) != ConflictType.IDENTICAL_PATCH) continue;
                needHeader = true;
                if (OPatchEnv.getSessionType().equals("apply")) continue;
                hasSomething = true;
                tBuf.append("\n\n\tIdentical duplicate of " + this.getColumnPatchID(i3, j3));
            }
            if (!hasSomething) continue;
            buff.append(tBuf.toString());
        }
        if (needHeader) {
            compositeOutput.append(header);
        }
        compositeOutput.append(buff);
        return compositeOutput.toString();
    }

    public String getCombinedCompositeLogOutput() {
        StringBuffer buff = new StringBuffer("");
        int rowLength = this.getRowLength();
        int colLength = this.getColumnLength();
        ArrayList<String> supersetIDs = new ArrayList<String>();
        ArrayList<String> subsetIDs = new ArrayList<String>();
        for (int i2 = 0; i2 < rowLength; ++i2) {
            int z;
            StringBuffer tBuf = new StringBuffer("Composite Patch " + this.getRowPatchID(i2, 0));
            boolean hasSomething = false;
            for (int j2 = 0; j2 < colLength; ++j2) {
                if (this.getConflictType(i2, j2) == ConflictType.BUG_SUPERSET) {
                    supersetIDs.add(this.getColumnPatchID(i2, j2));
                    hasSomething = true;
                    continue;
                }
                if (this.getConflictType(i2, j2) != ConflictType.BUG_SUBSET) continue;
                subsetIDs.add(this.getColumnPatchID(i2, j2));
                hasSomething = true;
            }
            if (!hasSomething) continue;
            String patchList = "";
            if (supersetIDs.size() > 0) {
                for (z = 0; z < supersetIDs.size(); ++z) {
                    patchList = patchList + "," + supersetIDs.get(z);
                }
                patchList = patchList.substring(1);
                tBuf.append(" is a bug superset of " + patchList + " in OH.");
            } else if (subsetIDs.size() > 0) {
                for (z = 0; z < subsetIDs.size(); ++z) {
                    patchList = patchList + "," + subsetIDs.get(z);
                }
                patchList = patchList.substring(1);
                tBuf.append(" is a bug subset of " + patchList + " in OH.");
                tBuf.append("\n All of the fixes contained in patch " + this.getRowPatchID(i2, 0) + " are already present in the Oracle Home.");
                tBuf.append("\n Patch " + this.getRowPatchID(i2, 0) + " not applied.");
            }
            buff.append(tBuf.toString());
        }
        return buff.toString();
    }

    public HashSet getCombinedCompositeConflictPatches() {
        HashSet<String> conflictPatches = new HashSet<String>();
        int rowLength = this.getRowLength();
        int colLength = this.getColumnLength();
        for (int i2 = 0; i2 < rowLength; ++i2) {
            for (int j2 = 0; j2 < colLength; ++j2) {
                if (this.getConflictType(i2, j2) != ConflictType.GENERIC_CONFLICT && this.getConflictType(i2, j2) != ConflictType.BUG_CONFLICT) continue;
                conflictPatches.add(this.getColumnPatchID(i2, j2));
            }
        }
        return conflictPatches;
    }

    public String getSubPatchConflictDetailsString(HashSet conflictingPatches, String compositePatchID) {
        String installedPatchesString = "";
        Iterator it = conflictingPatches.iterator();
        while (it.hasNext()) {
            installedPatchesString = installedPatchesString + ", " + it.next();
        }
        if (installedPatchesString != "") {
            installedPatchesString = installedPatchesString.substring(1);
        }
        StringBuffer buff = new StringBuffer("\nComposite Patch " + compositePatchID + " conflicts with installed patch(es) " + installedPatchesString);
        buff.append("\n\nConflict Description:");
        buff.append("\nHere are the specific sub-patches of composite patch " + compositePatchID + " that conflict with " + installedPatchesString);
        int rowLength = this.getRowLength();
        int colLength = this.getColumnLength();
        String[] conflictingOhs = new String[colLength];
        int count = 0;
        for (int i2 = 0; i2 < rowLength; ++i2) {
            StringBuffer tBuf = new StringBuffer("\n\nSub-Patch " + this.getRowPatchID(i2, 0));
            tBuf.append(" conflicts with ");
            boolean hasSomething = false;
            for (int j2 = 0; j2 < colLength; ++j2) {
                String patchInOH = this.getColumnPatchID(i2, j2);
                if (!conflictingPatches.contains(patchInOH) || this.getConflictType(i2, j2) != ConflictType.BUG_CONFLICT && this.getConflictType(i2, j2) != ConflictType.GENERIC_CONFLICT) continue;
                conflictingOhs[count] = patchInOH;
                ++count;
                hasSomething = true;
            }
            for (int k2 = 0; k2 < count; ++k2) {
                if (k2 != count - 1) {
                    tBuf.append(conflictingOhs[k2] + ", ");
                    continue;
                }
                tBuf.append(conflictingOhs[k2]);
            }
            if (hasSomething) {
                buff.append(tBuf.toString());
            }
            count = 0;
        }
        return buff.toString();
    }

    public String getSubPatchConflictDetailsSubString(HashSet conflictingPatches, String compositePatchID) {
        String installedPatchesString = "";
        Iterator it = conflictingPatches.iterator();
        while (it.hasNext()) {
            installedPatchesString = installedPatchesString + ", " + it.next();
        }
        if (installedPatchesString != "") {
            installedPatchesString = installedPatchesString.substring(1);
        }
        StringBuffer buff = new StringBuffer("\nHere are the specific sub-patches of composite patch " + compositePatchID + " that conflict with " + installedPatchesString);
        int rowLength = this.getRowLength();
        int colLength = this.getColumnLength();
        String[] conflictingOhs = new String[colLength];
        int count = 0;
        for (int i2 = 0; i2 < rowLength; ++i2) {
            StringBuffer tBuf = new StringBuffer("\n\nSub-Patch " + this.getRowPatchID(i2, 0));
            tBuf.append(" conflicts with ");
            boolean hasSomething = false;
            for (int j2 = 0; j2 < colLength; ++j2) {
                String patchInOH = this.getColumnPatchID(i2, j2);
                if (!conflictingPatches.contains(patchInOH) || this.getConflictType(i2, j2) != ConflictType.BUG_CONFLICT && this.getConflictType(i2, j2) != ConflictType.GENERIC_CONFLICT) continue;
                conflictingOhs[count] = patchInOH;
                ++count;
                hasSomething = true;
            }
            for (int k2 = 0; k2 < count; ++k2) {
                if (k2 != count - 1) {
                    tBuf.append(conflictingOhs[k2] + ", ");
                    continue;
                }
                tBuf.append(conflictingOhs[k2]);
            }
            if (hasSomething) {
                buff.append(tBuf.toString());
            }
            count = 0;
        }
        return buff.toString();
    }

    public String getCombinedCompositeOutput(HashSet<String> filteredPatches) {
        StringBuffer buff = new StringBuffer();
        StringBuffer header = new StringBuffer();
        header.append("\nWhole composite patch Conflicts/Supersets are:");
        int rowLength = this.getRowLength();
        int colLength = this.getColumnLength();
        boolean needHeader = false;
        for (int i2 = 0; i2 < rowLength; ++i2) {
            StringBuffer tBuf = new StringBuffer("\n\n" + (Object)((Object)this.getRowPatchType(i2, 0)) + " : " + this.getRowPatchID(i2, 0));
            if (!OPatchEnv.getSessionType().equals("prereq") && filteredPatches.contains(this.getColumnPatchID(i2, 0))) continue;
            needHeader = true;
            boolean hasSomething = false;
            for (int j2 = 0; j2 < colLength; ++j2) {
                if (this.getConflictType(i2, j2) == ConflictType.BUG_SUPERSET) {
                    if (this.getColumnPatchType(i2, j2).equals((Object)PatchType.COMPOSITE)) {
                        tBuf.append("\n\n\tBug Superset of " + (Object)((Object)PatchType.COMPOSITE) + " " + this.getColumnPatchID(i2, j2));
                    } else {
                        tBuf.append("\n\n\tBug Superset of " + this.getColumnPatchID(i2, j2));
                    }
                    hasSomething = true;
                    continue;
                }
                if (this.getConflictType(i2, j2) == ConflictType.BUG_SUBSET) {
                    if (this.getColumnPatchType(i2, j2).equals((Object)PatchType.COMPOSITE)) {
                        tBuf.append("\n\n\tBug SubSet of " + (Object)((Object)PatchType.COMPOSITE) + " " + this.getColumnPatchID(i2, j2));
                    } else {
                        tBuf.append("\n\n\tBug SubSet of " + this.getColumnPatchID(i2, j2));
                    }
                    hasSomething = true;
                    continue;
                }
                if (this.getConflictType(i2, j2) == ConflictType.BUG_CONFLICT) {
                    if (this.getColumnPatchType(i2, j2).equals((Object)PatchType.COMPOSITE)) {
                        tBuf.append("\n\n\tBug Conflict with " + (Object)((Object)PatchType.COMPOSITE) + " " + this.getColumnPatchID(i2, j2));
                    } else {
                        tBuf.append("\n\n\tBug Conflict with " + this.getColumnPatchID(i2, j2));
                    }
                    hasSomething = true;
                    continue;
                }
                if (this.getConflictType(i2, j2) != ConflictType.GENERIC_CONFLICT) continue;
                if (this.getColumnPatchType(i2, j2).equals((Object)PatchType.COMPOSITE)) {
                    tBuf.append("\n\n\tConflict with " + (Object)((Object)PatchType.COMPOSITE) + " " + this.getColumnPatchID(i2, j2));
                } else {
                    tBuf.append("\n\n\tConflict with " + this.getColumnPatchID(i2, j2));
                }
                hasSomething = true;
            }
            if (!hasSomething) continue;
            buff.append(tBuf.toString());
        }
        if (needHeader) {
            header.append(buff);
            buff = new StringBuffer(header);
        }
        return buff.toString();
    }

    class ConflictedPatch {
        String[] details = new String[0];
        String rowID = "";
        String colID = "";
        PatchType rowType = PatchType.ONEOFF;
        PatchType colType = PatchType.ONEOFF;
        ConflictType typeOfConflict = ConflictType.NO_CONFLICT;

        ConflictedPatch() {
        }

        protected void set(String[] conflictDetail, ConflictType type) {
            this.details = conflictDetail;
            this.typeOfConflict = type;
        }

        protected String[] getDetails() {
            return this.details;
        }

        protected ConflictType getConflictType() {
            return this.typeOfConflict;
        }

        protected void setConflictType(ConflictType type) {
            this.typeOfConflict = type;
        }

        protected String getRowID() {
            return this.rowID;
        }

        protected String getColID() {
            return this.colID;
        }

        protected void setRowID(String id) {
            this.rowID = id;
        }

        protected void setColID(String id) {
            this.colID = id;
        }

        protected PatchType getRowType() {
            return this.rowType;
        }

        protected void setRowType(PatchType patchType) {
            this.rowType = patchType;
        }

        protected PatchType getColType() {
            return this.colType;
        }

        protected void setColType(PatchType patchType) {
            this.colType = patchType;
        }
    }

    public static enum PatchType {
        ONEOFF("Patch"),
        SUBPATCH("Sub-Patch"),
        COMPOSITE("Composite Patch");

        private String _name;

        private PatchType(String name) {
            this._name = name;
        }

        public String toString() {
            return this._name;
        }
    }

    public static class ConflictType {
        int state;
        public static ConflictType NO_CONFLICT = new ConflictType(0);
        public static ConflictType BUG_SUPERSET = new ConflictType(1);
        public static ConflictType BUG_SUBSET = new ConflictType(2);
        public static ConflictType BUG_CONFLICT = new ConflictType(3);
        public static ConflictType GENERIC_CONFLICT = new ConflictType(4);
        public static ConflictType IDENTICAL_PATCH = new ConflictType(5);
        public static ConflictType WORSER_PATCH = new ConflictType(6);
        public static ConflictType BETTER_PATCH = new ConflictType(6);

        private ConflictType() {
        }

        public ConflictType(int state) {
            this.state = state;
        }
    }
}

