/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchprereq;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.zip.ZipFile;
import oracle.opatch.CompositePatchObject;
import oracle.opatch.ExitOPatchException;
import oracle.opatch.OPatchACL;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchException;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OneOffEntry;
import oracle.opatch.OnlinePatchProcessor;
import oracle.opatch.PatchObject;
import oracle.opatch.SymbolFailureException;
import oracle.opatch.ZipUtilities;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.CheckNoOpPatchesOption;
import oracle.opatch.opatchprereq.ConflictMatrixOutput;
import oracle.opatch.opatchprereq.ConflictOutput;
import oracle.opatch.opatchprereq.PrereqAPI;
import oracle.opatch.opatchprereq.PrereqResource;
import oracle.opatch.opatchprereq.PrereqResult;
import oracle.opatch.opatchsdk.OPatchAnalysisReport;
import oracle.opatch.opatchsdk.OPatchContext;
import oracle.opatch.opatchsdk.OPatchPatchPrereq;
import oracle.opatch.opatchutil.OPatchUtilHelper;
import oracle.opatch.opatchutil.OUSession;
import oracle.opatch.wrappers.WrapperFactory;

public class PQSession {
    private static String patchBaseDir;
    private static String patchBaseFile;
    private static boolean baseDir;
    private static boolean phBaseFile;
    public static final int PREREQ_PASSED = 0;
    public static final int PREREQ_FAILED = 1;
    public static final int UNKNOWN_ERROR = 2;
    private static OneOffEntry[] pi;
    public static Map<String, Boolean> isCompositeMap;

    private PQSession() {
    }

    protected static boolean isBaseDirProvided() {
        return baseDir;
    }

    protected static void setBaseDirProvided() {
        baseDir = true;
    }

    protected static void unsetBaseDirProvided() {
        baseDir = false;
    }

    public static String getPatchBaseDir() {
        return patchBaseDir;
    }

    protected static void setPatchBaseDir(String patchLocation) {
        patchBaseDir = patchLocation;
    }

    protected static boolean isPatchBaseFileProvided() {
        return phBaseFile;
    }

    public static String getPatchBaseFile() {
        return patchBaseFile;
    }

    protected static void setPatchBaseFileProvided() {
        phBaseFile = true;
    }

    protected static void unsetPatchBaseFileProvided() {
        phBaseFile = false;
    }

    private static String getOraInstLocation() {
        return OPatchEnv.getInvPtrLoc();
    }

    private static void printTheResult(PrereqResult obj, String prereq) {
        if (obj == null || prereq == null) {
            return;
        }
        if (obj.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED) {
            OLogger.println("\nPrereq " + prereq + " is not executed.");
            OLogger.println(obj.toString());
            OPatchEnv.setOpatchExitCode(2);
        } else if (obj.getResult() == PrereqResult.ExecuteStatus.FAILED) {
            OLogger.println("\nPrereq " + prereq + " failed.");
            OLogger.println(obj.toString());
        } else {
            OLogger.println("\nPrereq " + prereq + " passed.");
        }
    }

    private static PrereqResult printNotExecutedAndReturnResObj(String prereqName, boolean hasNoPatchLoc) {
        PrereqResult resObj = new PrereqResult();
        if (hasNoPatchLoc) {
            resObj.addDetail("No patch location specified.");
        }
        resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
        PQSession.printTheResult(resObj, "\"" + prereqName + "\"");
        return resObj;
    }

    private static PrereqResult printNotExecutedAndReturnResObjPatchID(String prereqName) {
        PrereqResult resObj = new PrereqResult();
        resObj.addDetail("No patchID specified.");
        resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
        PQSession.printTheResult(resObj, "\"" + prereqName + "\"");
        return resObj;
    }

    protected static String getSessionName() {
        return "OPatchPrereq";
    }

    protected static String getSessionVersion() {
        return OPatchEnv.getCallerVersion();
    }

    public static void defaultOption(String oracleHomePath) {
        throw new RuntimeException("\nPlease specify the prereq to be executed. Please refer 'opatch prereq -help' for details.");
    }

    public static void defaultArgument(String arg) {
        OLogger.println("PQSession::defaultArgument(), arg = " + arg);
    }

    public static void checkoraclehome(String oracleHomePath) {
        PrereqResult resObj = PrereqAPI.checkOracleHome(oracleHomePath);
        PQSession.printTheResult(resObj, "\"checkOracleHome\"");
    }

    public static void checkjdk(String oracleHomePath) {
        PrereqResult resObj = PrereqAPI.checkJDK(oracleHomePath);
        PQSession.printTheResult(resObj, "\"checkJDK\"");
    }

    public static void checkouiversioncompatible(String oracleHomePath) {
        PrereqResult resObj = PrereqAPI.checkOUIVersionCompatible(oracleHomePath);
        PQSession.printTheResult(resObj, "\"checkOUIVersionCompatible\"");
    }

    public static void checkopatchcompatibleagainstoh(String oracleHomePath, List<PatchObject> patchObjects) {
        PrereqResult resObj = PrereqAPI.checkOPatchCompatibleAgainstOH(oracleHomePath, patchObjects);
        PQSession.printTheResult(resObj, "\"checkOPatchCompatibleAgainstOH\"");
    }

    public static PrereqResult checkopatchcompatibleagainstohAndPrint(String oracleHomePath, List<PatchObject> pos) {
        String patchLocation = OPatchEnv.getPatchloc();
        String[] patchLocs = null;
        PrereqResult resObj = null;
        if (PQSession.isBaseDirProvided() || PQSession.isPatchBaseFileProvided()) {
            try {
                patchLocs = PQSession.parseBaseDirListFile();
                patchLocs = PQSession.handleCompositeCases(patchLocs, PQSession.getPatchBaseDir());
            }
            catch (FileNotFoundException e2) {
                OLogger.println("File not found: " + PQSession.getPatchBaseFile());
                resObj = new PrereqResult();
                resObj.addDetail(e2.getMessage());
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                PQSession.printTheResult(resObj, "\"checkOPatchCompatibleAgainstOH\"");
                return resObj;
            }
            catch (IOException e3) {
                OLogger.println("IOException occured: " + e3.getMessage());
                resObj = new PrereqResult();
                resObj.addDetail(e3.getMessage());
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                PQSession.printTheResult(resObj, "\"checkOPatchCompatibleAgainstOH\"");
                return resObj;
            }
        } else if (patchLocation != null && !patchLocation.equals("")) {
            patchLocs = new String[]{patchLocation};
            try {
                patchLocs = PQSession.handleCompositeCases(patchLocs, PQSession.getPatchBaseDir());
            }
            catch (FileNotFoundException e4) {
                OLogger.println("File not found: " + PQSession.getPatchBaseFile());
                resObj = new PrereqResult();
                resObj.addDetail(e4.getMessage());
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                PQSession.printTheResult(resObj, "\"checkOPatchCompatibleAgainstOH\"");
                return resObj;
            }
            catch (IOException e5) {
                OLogger.println("IOException occured: " + e5.getMessage());
                resObj = new PrereqResult();
                resObj.addDetail(e5.getMessage());
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                PQSession.printTheResult(resObj, "\"checkOPatchCompatibleAgainstOH\"");
                OLogger.printStackTrace(e5);
                return resObj;
            }
        } else if (OPatchEnv.isUserSuppliedPatchIDs()) {
            int i2;
            String[] patchIDs = OPatchEnv.getUserSuppliedPatchIDs();
            ArrayList<String> patchList = new ArrayList<String>();
            for (i2 = 0; i2 < patchIDs.length; ++i2) {
                String patchID = patchIDs[i2];
                try {
                    PatchObject po = PatchObject.getInstance(oracleHomePath, patchID);
                    patchList.add(po.getPatchLocation());
                    continue;
                }
                catch (Exception e6) {
                    resObj = new PrereqResult();
                    resObj.addDetail(e6.getMessage());
                    resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                    PQSession.printTheResult(resObj, "\"checkOPatchCompatibleAgainstOH\"");
                    return resObj;
                }
            }
            patchLocs = new String[patchList.size()];
            for (i2 = 0; i2 < patchLocs.length; ++i2) {
                patchLocs[i2] = (String)patchList.get(i2);
            }
        } else {
            return PQSession.printNotExecutedAndReturnResObj("checkOPatchCompatibleAgainstOH", true);
        }
        PatchObject[] pObjects = new PatchObject[patchLocs.length];
        if (pos != null) {
            pObjects = pos.toArray(new PatchObject[patchLocs.length]);
        } else {
            for (int i3 = 0; i3 < patchLocs.length; ++i3) {
                try {
                    pObjects[i3] = PatchObject.getInstance(patchLocs[i3]);
                    continue;
                }
                catch (Exception e7) {
                    OLogger.println("Prereq \"checkOPatchCompatibleAgainstOH\" not executed");
                    String msg = "Unable to create Patch Object.\nException occured : " + e7.getMessage();
                    OLogger.println(msg);
                    resObj.addDetail(msg);
                    resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                    PQSession.printTheResult(resObj, "\"checkOPatchCompatibleAgainstOH\"");
                }
            }
        }
        resObj = PrereqAPI.checkOPatchCompatibleAgainstOH(oracleHomePath, Arrays.asList(pObjects));
        PQSession.printTheResult(resObj, "\"checkOPatchCompatibleAgainstOH\"");
        return resObj;
    }

    public static void checkfusionappscompatible(String oracleHomePath) {
        PQSession.checkFusionAppsCompatibleAndPrint(oracleHomePath);
    }

    public static PrereqResult checkFusionAppsCompatibleAndPrint(String oracleHomePath) {
        PrereqResult resObj = PrereqAPI.checkFusionAppsCompatible(oracleHomePath);
        PQSession.printTheResult(resObj, "\"checkFusionAppsCompatible\"");
        return resObj;
    }

    public static void checkminimumopatchversion(String oracleHomePath) {
        PQSession.checkMinimumOpatchVersionAndPrint(oracleHomePath);
    }

    public static PrereqResult checkMinimumOpatchVersionAndPrint(String oracleHomePath) {
        return PQSession.checkMinimumOpatchVersionAndPrint(oracleHomePath, null);
    }

    public static PrereqResult checkMinimumOpatchVersionAndPrint(String oracleHomePath, List<PatchObject> pos) {
        String patchLocation = OPatchEnv.getPatchloc();
        String[] patchLocs = null;
        PrereqResult resObj = null;
        if (PQSession.isBaseDirProvided() || PQSession.isPatchBaseFileProvided()) {
            try {
                patchLocs = PQSession.parseBaseDirListFile();
                patchLocs = PQSession.handleCompositeCases(patchLocs, PQSession.getPatchBaseDir());
            }
            catch (FileNotFoundException e2) {
                OLogger.println("File not found: " + PQSession.getPatchBaseFile());
                resObj = new PrereqResult();
                resObj.addDetail(e2.getMessage());
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                PQSession.printTheResult(resObj, "\"checkMinimumOPatchVersion\"");
                return resObj;
            }
            catch (IOException e3) {
                OLogger.println("IOException occured: " + e3.getMessage());
                resObj = new PrereqResult();
                resObj.addDetail(e3.getMessage());
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                PQSession.printTheResult(resObj, "\"checkMinimumOPatchVersion\"");
                return resObj;
            }
        } else if (patchLocation != null && !patchLocation.equals("")) {
            patchLocs = new String[]{patchLocation};
            try {
                patchLocs = PQSession.handleCompositeCases(patchLocs, PQSession.getPatchBaseDir());
            }
            catch (FileNotFoundException e4) {
                OLogger.println("File not found: " + PQSession.getPatchBaseFile());
                resObj = new PrereqResult();
                resObj.addDetail(e4.getMessage());
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                PQSession.printTheResult(resObj, "\"checkMinimumOPatchVersion\"");
                return resObj;
            }
            catch (IOException e5) {
                OLogger.println("IOException occured: " + e5.getMessage());
                resObj = new PrereqResult();
                resObj.addDetail(e5.getMessage());
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                PQSession.printTheResult(resObj, "\"checkMinimumOPatchVersion\"");
                OLogger.printStackTrace(e5);
                return resObj;
            }
        } else if (OPatchEnv.isUserSuppliedPatchIDs()) {
            int i2;
            String[] patchIDs = OPatchEnv.getUserSuppliedPatchIDs();
            ArrayList<String> patchList = new ArrayList<String>();
            for (i2 = 0; i2 < patchIDs.length; ++i2) {
                String patchID = patchIDs[i2];
                try {
                    PatchObject po = PatchObject.getInstance(oracleHomePath, patchID);
                    patchList.add(po.getPatchLocation());
                    continue;
                }
                catch (Exception e6) {
                    resObj = new PrereqResult();
                    resObj.addDetail(e6.getMessage());
                    resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                    PQSession.printTheResult(resObj, "\"checkMinimumOPatchVersion\"");
                    return resObj;
                }
            }
            patchLocs = new String[patchList.size()];
            for (i2 = 0; i2 < patchLocs.length; ++i2) {
                patchLocs[i2] = (String)patchList.get(i2);
            }
        } else {
            return PQSession.printNotExecutedAndReturnResObj("checkMinimumOPatchVersion", true);
        }
        PatchObject[] pObjects = new PatchObject[patchLocs.length];
        if (pos != null) {
            pObjects = pos.toArray(new PatchObject[patchLocs.length]);
        } else {
            for (int i3 = 0; i3 < patchLocs.length; ++i3) {
                try {
                    pObjects[i3] = PatchObject.getInstance(patchLocs[i3]);
                    continue;
                }
                catch (Exception e7) {
                    OLogger.println("Prereq \"checkMinimumOPatchVersion\" not executed");
                    String msg = "Unable to create Patch Object.\nException occured : " + e7.getMessage();
                    OLogger.println(msg);
                    resObj.addDetail(msg);
                    resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                    PQSession.printTheResult(resObj, "\"checkMinimumOPatchVersion\"");
                }
            }
        }
        resObj = PrereqAPI.checkOPatchMinVersionRequirement(oracleHomePath, pObjects);
        PQSession.printTheResult(resObj, "\"checkMinimumOPatchVersion\"");
        return resObj;
    }

    public static void checkautorollback(String oracleHomePath) {
        PQSession.checkAutoRollback(oracleHomePath);
    }

    public static PrereqResult checkAutoRollback(String oracleHomePath, List<PatchObject> pos) {
        int i2;
        String patchLocation = OPatchEnv.getPatchloc();
        String[] patchLocs = null;
        PrereqResult resObj = null;
        if (PQSession.isBaseDirProvided() || PQSession.isPatchBaseFileProvided()) {
            try {
                patchLocs = PQSession.parseBaseDirListFile();
            }
            catch (FileNotFoundException e2) {
                OLogger.println("File not found: " + PQSession.getPatchBaseFile());
                return PQSession.printNotExecutedAndReturnResObj("checkAutoRollback", false);
            }
            catch (IOException e3) {
                OLogger.println("IOException occured: " + e3.getMessage());
                OLogger.printStackTrace(e3);
                return PQSession.printNotExecutedAndReturnResObj("checkAutoRollback", false);
            }
        } else if (patchLocation != null && !patchLocation.equals("")) {
            patchLocs = new String[]{patchLocation};
        } else if (OPatchEnv.isUserSuppliedPatchIDs()) {
            String[] patchIDs = OPatchEnv.getUserSuppliedPatchIDs();
            ArrayList<String> patchList = new ArrayList<String>();
            for (i2 = 0; i2 < patchIDs.length; ++i2) {
                String patchID = patchIDs[i2];
                try {
                    PatchObject po = PatchObject.getInstance(oracleHomePath, patchID);
                    patchList.add(po.getPatchLocation());
                    continue;
                }
                catch (Exception e4) {
                    resObj = new PrereqResult();
                    resObj.addDetail(e4.getMessage());
                    resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                    PQSession.printTheResult(resObj, "\"checkAutoRollback\"");
                    return resObj;
                }
            }
            patchLocs = new String[patchList.size()];
            for (i2 = 0; i2 < patchLocs.length; ++i2) {
                patchLocs[i2] = (String)patchList.get(i2);
            }
        } else {
            return PQSession.printNotExecutedAndReturnResObj("checkAutoRollback", true);
        }
        PatchObject[] pObjects = new PatchObject[patchLocs.length];
        if (pos != null) {
            pObjects = pos.toArray(new PatchObject[patchLocs.length]);
        } else {
            for (int i3 = 0; i3 < patchLocs.length; ++i3) {
                try {
                    pObjects[i3] = PatchObject.getInstance(patchLocs[i3]);
                    continue;
                }
                catch (Exception e5) {
                    OLogger.println("Prereq \"checkAutoRollback\" not executed");
                    String msg = "Unable to create Patch Object.\nException occured : " + e5.getMessage();
                    OLogger.println(msg);
                    resObj = new PrereqResult();
                    resObj.addDetail(msg);
                    resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                    OLogger.printStackTrace(e5);
                    PQSession.printTheResult(resObj, "\"checkAutoRollback\"");
                }
            }
        }
        ArrayList<OneOffEntry> patchesToApply = new ArrayList<OneOffEntry>();
        for (i2 = 0; i2 < pObjects.length; ++i2) {
            if (pObjects[i2] == null) continue;
            patchesToApply.add(pObjects[i2].toOneOffEntry(oracleHomePath));
        }
        OneOffEntry[] patchesToApplys = new OneOffEntry[patchesToApply.size()];
        patchesToApply.toArray(patchesToApplys);
        resObj = PrereqAPI.checkAutoRollbackPatches(oracleHomePath, patchesToApplys);
        PQSession.printTheResult(resObj, "\"checkAutoRollback\"");
        return resObj;
    }

    public static PrereqResult checkAutoRollback(String oracleHomePath) {
        return PQSession.checkAutoRollback(oracleHomePath, null);
    }

    public static void checkcomponents(String oracleHomePath) throws Exception {
        PQSession.checkComponentsAndPrint(oracleHomePath);
    }

    public static ArrayList checkComponentsAndPrint(String oracleHomePath) throws Exception {
        return PQSession.checkComponentsAndPrint(oracleHomePath, null);
    }

    public static ArrayList checkComponentsAndPrint(String oracleHomePath, List<PatchObject> pos) throws Exception {
        PrereqResult resObj = null;
        String[] patchLocs = null;
        ArrayList<PrereqResult> resultsArray = new ArrayList<PrereqResult>();
        if (PQSession.isBaseDirProvided() || PQSession.isPatchBaseFileProvided()) {
            try {
                patchLocs = PQSession.parseBaseDirListFile();
                patchLocs = PQSession.handleCompositeCases(patchLocs, PQSession.getPatchBaseDir());
            }
            catch (Exception e2) {
                OLogger.println("Prereq \"checkComponents\" not executed.");
                OLogger.printStackTrace(e2);
                throw e2;
            }
        } else {
            patchLocs = new String[]{OPatchEnv.getPatchloc()};
            if (patchLocs[0] == null || patchLocs[0].equals("")) {
                resObj = PQSession.printNotExecutedAndReturnResObj("checkComponents", true);
                return new ArrayList<PrereqResult>(Arrays.asList(resObj));
            }
            if (PQSession.isComposite(patchLocs[0])) {
                PQSession.setBaseDirProvided();
                PQSession.setPatchBaseDir(patchLocs[0]);
                patchLocs = PQSession.parseBaseDirListFile();
            }
        }
        if (patchLocs == null || patchLocs.length == 0) {
            resObj = PQSession.printNotExecutedAndReturnResObj("checkComponents", true);
            return new ArrayList<PrereqResult>(Arrays.asList(resObj));
        }
        if (pos == null) {
            for (int i2 = 0; i2 < patchLocs.length; ++i2) {
                ArrayList<String> filteredSet = new ArrayList<String>();
                try {
                    PatchObject[] pObj = new PatchObject[]{PatchObject.getInstance(patchLocs[i2])};
                    if (filteredSet.contains(pObj[0].getPatchID())) continue;
                    filteredSet.add(pObj[0].getPatchID());
                    resObj = PrereqAPI.checkComponents(oracleHomePath, pObj);
                    resultsArray.add(resObj);
                    PQSession.printTheResult(resObj, "\"checkComponents\" for patch " + pObj[0].getPatchID());
                    continue;
                }
                catch (Exception e3) {
                    resObj = PQSession.printNotExecutedAndReturnResObj("checkComponents", true);
                    resultsArray.add(resObj);
                }
            }
        } else {
            for (PatchObject pObj : pos) {
                ArrayList<String> filteredSet = new ArrayList<String>();
                try {
                    if (filteredSet.contains(pObj.getPatchID())) continue;
                    filteredSet.add(pObj.getPatchID());
                    resObj = PrereqAPI.checkComponents(oracleHomePath, new PatchObject[]{pObj});
                    resultsArray.add(resObj);
                    PQSession.printTheResult(resObj, "\"checkComponents\" for patch " + pObj.getPatchID());
                }
                catch (Exception e4) {
                    resObj = PQSession.printNotExecutedAndReturnResObj("checkComponents", true);
                    resultsArray.add(resObj);
                }
            }
        }
        return resultsArray;
    }

    public static void checkfileversions(String oracleHomePath) {
        PQSession.checkFileVersionsAndPrint(oracleHomePath);
    }

    public static PrereqResult checkFileVersionsAndPrint(String oracleHomePath) {
        return PQSession.checkFileVersionsAndPrint(oracleHomePath, null);
    }

    public static PrereqResult checkFileVersionsAndPrint(String oracleHomePath, List<PatchObject> pos) {
        String patchLocation = OPatchEnv.getPatchloc();
        String[] patchLocs = null;
        if (PQSession.isBaseDirProvided() || PQSession.isPatchBaseFileProvided()) {
            try {
                patchLocs = PQSession.parseBaseDirListFile();
                patchLocs = PQSession.handleCompositeCases(patchLocs, PQSession.getPatchBaseDir());
            }
            catch (FileNotFoundException e2) {
                OLogger.println("File not found: " + PQSession.getPatchBaseFile());
                return PQSession.printNotExecutedAndReturnResObj("checkFileVersions", false);
            }
            catch (IOException e3) {
                OLogger.println("IOException occured: " + e3.getMessage());
                OLogger.printStackTrace(e3);
                return PQSession.printNotExecutedAndReturnResObj("checkFileVersions", false);
            }
            catch (OPatchException e4) {
                OLogger.println("OPatchException occured: " + e4.getMessage());
                OLogger.printStackTrace(e4);
                return PQSession.printNotExecutedAndReturnResObj("checkFileVersions", false);
            }
        } else if (patchLocation != null && !patchLocation.equals("")) {
            patchLocs = new String[]{patchLocation};
            try {
                patchLocs = PQSession.handleCompositeCases(patchLocs, PQSession.getPatchBaseDir());
            }
            catch (FileNotFoundException e5) {
                OLogger.println("File not found: " + PQSession.getPatchBaseFile());
                return PQSession.printNotExecutedAndReturnResObj("checkFileVersions", false);
            }
            catch (IOException e6) {
                OLogger.println("IOException occured: " + e6.getMessage());
                OLogger.printStackTrace(e6);
                return PQSession.printNotExecutedAndReturnResObj("checkFileVersions", false);
            }
        } else {
            return PQSession.printNotExecutedAndReturnResObj("checkFileVersions", true);
        }
        PatchObject[] pObjects = new PatchObject[patchLocs.length];
        if (pos == null) {
            for (int i2 = 0; i2 < patchLocs.length; ++i2) {
                try {
                    pObjects[i2] = PatchObject.getInstance(patchLocs[i2]);
                    continue;
                }
                catch (Exception e7) {
                    return PQSession.printNotExecutedAndReturnResObj("checkFileVersions", true);
                }
            }
        } else {
            pObjects = pos.toArray(new PatchObject[patchLocs.length]);
        }
        Vector NoOpPatches = new Vector();
        OLogger.println("\nThis prereq checks if the copy actions of Fusion Applications patch(es) have alleast one\nor more file version(s) greater than the version(s) installed in the Oracle Home.\n");
        PrereqResult resObj = PrereqAPI.checkFileVersions(oracleHomePath, pObjects, NoOpPatches);
        PQSession.printTheResult(resObj, "\"checkFileVersions\"");
        if (NoOpPatches.size() != 0) {
            OLogger.println("\nThe final list of no-op. patches (whose copy actions would be skipped) are : " + NoOpPatches.toString());
        }
        return resObj;
    }

    public static void checkoneoffsuperset(String oracleHomePath) {
        PQSession.checkOneoffSupersetAndPrint(oracleHomePath);
    }

    public static PrereqResult checkOneoffSupersetAndPrint(String oracleHomePath) {
        return PQSession.checkOneoffSupersetAndPrint(oracleHomePath, null);
    }

    public static PrereqResult checkOneoffSupersetAndPrint(String oracleHomePath, List<PatchObject> pos) {
        String patchLocation = OPatchEnv.getPatchloc();
        String[] patchLocs = null;
        if (PQSession.isBaseDirProvided() || PQSession.isPatchBaseFileProvided()) {
            try {
                patchLocs = PQSession.parseBaseDirListFile();
                patchLocs = PQSession.handleCompositeCases(patchLocs, PQSession.getPatchBaseDir());
            }
            catch (FileNotFoundException e2) {
                OLogger.println("File not found: " + PQSession.getPatchBaseFile());
                return PQSession.printNotExecutedAndReturnResObj("checkOneoffSuperset", false);
            }
            catch (IOException e3) {
                OLogger.println("IOException occured: " + e3.getMessage());
                OLogger.printStackTrace(e3);
                return PQSession.printNotExecutedAndReturnResObj("checkOneoffSuperset", false);
            }
            catch (OPatchException e4) {
                OLogger.println("OPatchException occured: " + e4.getMessage());
                OLogger.printStackTrace(e4);
                return PQSession.printNotExecutedAndReturnResObj("checkOneoffSuperset", false);
            }
        } else if (patchLocation != null && !patchLocation.equals("")) {
            patchLocs = new String[]{patchLocation};
        } else {
            return PQSession.printNotExecutedAndReturnResObj("checkOneoffSuperset", true);
        }
        if (PQSession.isComposite(patchLocs[0])) {
            throw new OPatchException(OLogger.getString("S_OPATCH_PREREQ_COMPOSITE_NOT_SUPPORTED_ERROR", new Object[0]));
        }
        PatchObject[] pObjects = new PatchObject[patchLocs.length];
        if (pos != null) {
            pObjects = pos.toArray(new PatchObject[patchLocs.length]);
        } else {
            for (int i2 = 0; i2 < patchLocs.length; ++i2) {
                try {
                    pObjects[i2] = PatchObject.getInstance(patchLocs[i2]);
                    continue;
                }
                catch (Exception e5) {
                    return PQSession.printNotExecutedAndReturnResObj("checkOneoffSuperset", true);
                }
            }
        }
        OLogger.println("\nThis prereq checks if the given input Fusion Applications patch list are all candidates\nfor one-off (or) singleton supersets. This prereq does not do anychecks among the input patch list.");
        PrereqResult resObj = PrereqAPI.checkOneOffSuperset(oracleHomePath, pObjects);
        PQSession.printTheResult(resObj, "\"checkOneOffSuperset\"");
        return resObj;
    }

    public static void checkpatchingmodel(String oracleHomePath) {
        PQSession.checkPatchingModelAndPrint(oracleHomePath);
    }

    public static PrereqResult checkPatchingModelAndPrint(String oracleHomePath) {
        return PQSession.checkPatchingModelAndPrint(oracleHomePath, null);
    }

    public static PrereqResult checkPatchingModelAndPrint(String oracleHomePath, List<PatchObject> pos) {
        String patchLocation = OPatchEnv.getPatchloc();
        String[] patchLocs = null;
        if (PQSession.isBaseDirProvided() || PQSession.isPatchBaseFileProvided()) {
            try {
                patchLocs = PQSession.parseBaseDirListFile();
                patchLocs = PQSession.handleCompositeCases(patchLocs, PQSession.getPatchBaseDir());
            }
            catch (FileNotFoundException e2) {
                OLogger.println("File not found: " + PQSession.getPatchBaseFile());
                return PQSession.printNotExecutedAndReturnResObj("checkPatchingModel", false);
            }
            catch (IOException e3) {
                OLogger.println("IOException occured: " + e3.getMessage());
                OLogger.printStackTrace(e3);
                return PQSession.printNotExecutedAndReturnResObj("checkPatchingModel", false);
            }
            catch (OPatchException e4) {
                OLogger.println("OPatchException occured: " + e4.getMessage());
                OLogger.printStackTrace(e4);
                return PQSession.printNotExecutedAndReturnResObj("checkPatchingModel", false);
            }
        } else if (patchLocation != null && !patchLocation.equals("")) {
            patchLocs = new String[]{patchLocation};
            try {
                patchLocs = PQSession.handleCompositeCases(patchLocs, PQSession.getPatchBaseDir());
            }
            catch (FileNotFoundException e5) {
                OLogger.println("File not found: " + PQSession.getPatchBaseFile());
                return PQSession.printNotExecutedAndReturnResObj("checkPatchingModel", false);
            }
            catch (IOException e6) {
                OLogger.println("IOException occured: " + e6.getMessage());
                OLogger.printStackTrace(e6);
                return PQSession.printNotExecutedAndReturnResObj("checkPatchingModel", false);
            }
        } else {
            return PQSession.printNotExecutedAndReturnResObj("checkPatchingModel", true);
        }
        if (patchLocs == null || patchLocs.length == 0) {
            return PQSession.printNotExecutedAndReturnResObj("checkPatchingModel", true);
        }
        PatchObject[] pObjects = new PatchObject[patchLocs.length];
        if (pos != null) {
            pObjects = pos.toArray(new PatchObject[patchLocs.length]);
        } else {
            for (int i2 = 0; i2 < patchLocs.length; ++i2) {
                try {
                    pObjects[i2] = PatchObject.getInstance(patchLocs[i2]);
                    continue;
                }
                catch (Exception e7) {
                    OLogger.println("Prereq \"checkPatchingModel\" not executed");
                    OLogger.println("Unable to create Patch Object.\nException occured : " + e7.getMessage());
                    OLogger.printStackTrace(e7);
                }
            }
        }
        PrereqResult resObj = PrereqAPI.checkPatchingModel(oracleHomePath, pObjects);
        PQSession.printTheResult(resObj, "\"checkPatchingModel\"");
        return resObj;
    }

    public static PrereqResult checkIfRequiredDeleteActionExistAndPrint(String oracleHomePath, List<PatchObject> pos) {
        String patchLocation = OPatchEnv.getPatchloc();
        String[] patchLocs = null;
        if (PQSession.isBaseDirProvided() || PQSession.isPatchBaseFileProvided()) {
            try {
                patchLocs = PQSession.parseBaseDirListFile();
                patchLocs = PQSession.handleCompositeCases(patchLocs, PQSession.getPatchBaseDir());
            }
            catch (FileNotFoundException e2) {
                OLogger.println("File not found: " + PQSession.getPatchBaseFile());
                return PQSession.printNotExecutedAndReturnResObj("checkIfRequiredDelteActionExist", false);
            }
            catch (IOException e3) {
                OLogger.println("IOException occured: " + e3.getMessage());
                OLogger.printStackTrace(e3);
                return PQSession.printNotExecutedAndReturnResObj("checkIfRequiredDelteActionExist", false);
            }
            catch (OPatchException e4) {
                OLogger.println("OPatchException occured: " + e4.getMessage());
                OLogger.printStackTrace(e4);
                return PQSession.printNotExecutedAndReturnResObj("checkIfRequiredDelteActionExist", false);
            }
        } else if (patchLocation != null && !patchLocation.equals("")) {
            patchLocs = new String[]{patchLocation};
            try {
                patchLocs = PQSession.handleCompositeCases(patchLocs, PQSession.getPatchBaseDir());
            }
            catch (FileNotFoundException e5) {
                OLogger.println("File not found: " + PQSession.getPatchBaseFile());
                return PQSession.printNotExecutedAndReturnResObj("checkIfRequiredDelteActionExist", false);
            }
            catch (IOException e6) {
                OLogger.println("IOException occured: " + e6.getMessage());
                OLogger.printStackTrace(e6);
                return PQSession.printNotExecutedAndReturnResObj("checkIfRequiredDelteActionExist", false);
            }
        } else {
            return PQSession.printNotExecutedAndReturnResObj("checkIfRequiredDelteActionExist", true);
        }
        if (patchLocs == null || patchLocs.length == 0) {
            return PQSession.printNotExecutedAndReturnResObj("checkIfRequiredDelteActionExist", true);
        }
        PatchObject[] pObjects = new PatchObject[patchLocs.length];
        if (pos != null) {
            pObjects = pos.toArray(new PatchObject[patchLocs.length]);
        } else {
            for (int i2 = 0; i2 < patchLocs.length; ++i2) {
                try {
                    pObjects[i2] = PatchObject.getInstance(patchLocs[i2]);
                    continue;
                }
                catch (Exception e7) {
                    OLogger.println("Prereq \"checkIfRequiredDelteActionExist\" not executed");
                    OLogger.println("Unable to create Patch Object.\nException occured : " + e7.getMessage());
                    OLogger.printStackTrace(e7);
                }
            }
        }
        PrereqResult resObj = PrereqAPI.checkIfRequiredDeleteActionExist(oracleHomePath, pObjects);
        PQSession.printTheResult(resObj, "\"checkIfRequiredDelteActionExist\"");
        return resObj;
    }

    public static void checkfornooppatches(String oracleHomePath) {
        PQSession.checkForNooppatchesAndPrint(oracleHomePath);
    }

    public static void checkfornooppatches(String oracleHomePath, CheckNoOpPatchesOption option) {
        PQSession.checkForNooppatchesAndPrint(oracleHomePath, option);
    }

    public static PrereqResult checkForNooppatchesAndPrint(String oracleHomePath, CheckNoOpPatchesOption option) {
        return PQSession.checkForNooppatchesAndPrint(oracleHomePath, option, null);
    }

    public static PrereqResult checkForNooppatchesAndPrint(String oracleHomePath, CheckNoOpPatchesOption option, List<PatchObject> pos) {
        String patchLocation = OPatchEnv.getPatchloc();
        String[] patchLocs = null;
        if (PQSession.isBaseDirProvided() || PQSession.isPatchBaseFileProvided()) {
            try {
                patchLocs = PQSession.parseBaseDirListFile();
                patchLocs = PQSession.handleCompositeCases(patchLocs, PQSession.getPatchBaseDir());
            }
            catch (FileNotFoundException e2) {
                OLogger.println("File not found: " + PQSession.getPatchBaseFile());
                return PQSession.printNotExecutedAndReturnResObj("checkForNoopPatches", false);
            }
            catch (IOException e3) {
                OLogger.println("IOException occured: " + e3.getMessage());
                OLogger.printStackTrace(e3);
                return PQSession.printNotExecutedAndReturnResObj("checkForNoopPatches", false);
            }
            catch (OPatchException e4) {
                OLogger.println("OPatchException occured: " + e4.getMessage());
                OLogger.printStackTrace(e4);
                return PQSession.printNotExecutedAndReturnResObj("checkForNoopPatches", false);
            }
        } else if (patchLocation != null && !patchLocation.equals("")) {
            patchLocs = new String[]{patchLocation};
            try {
                patchLocs = PQSession.handleCompositeCases(patchLocs, PQSession.getPatchBaseDir());
            }
            catch (FileNotFoundException e5) {
                OLogger.println("File not found: " + PQSession.getPatchBaseFile());
                return PQSession.printNotExecutedAndReturnResObj("checkForNoopPatches", false);
            }
            catch (IOException e6) {
                OLogger.println("IOException occured: " + e6.getMessage());
                OLogger.printStackTrace(e6);
                return PQSession.printNotExecutedAndReturnResObj("checkForNoopPatches", false);
            }
        } else {
            return PQSession.printNotExecutedAndReturnResObj("checkForNoopPatches", true);
        }
        PatchObject[] pObjects = new PatchObject[patchLocs.length];
        if (pos != null) {
            pObjects = pos.toArray(new PatchObject[patchLocs.length]);
        } else {
            for (int i2 = 0; i2 < patchLocs.length; ++i2) {
                try {
                    pObjects[i2] = PatchObject.getInstance(patchLocs[i2]);
                    continue;
                }
                catch (Exception e7) {
                    OLogger.println("Prereq \"checkForNoOppatches\" not executed");
                    OLogger.println("Unable to create Patch Object.\nException occured : " + e7.getMessage());
                    OLogger.printStackTrace(e7);
                }
            }
        }
        Vector NoOpPatches = new Vector();
        OLogger.println("\nThis prereq checks if any of the patch(es) in the input patch list is a no-op. patch.");
        OLogger.println("This prereq would fail if there are no-op. patch(es).");
        PrereqResult resObj = PrereqAPI.checkNoOpPatches(oracleHomePath, pObjects, NoOpPatches);
        PQSession.printTheResult(resObj, "\"checkForNoOpPatches\"");
        Vector details = resObj.getResultDetails();
        if (option == CheckNoOpPatchesOption.IF_ALL_NO_OPS) {
            PrereqResult resObj_a = new PrereqResult();
            if (NoOpPatches.size() == pObjects.length && NoOpPatches.size() > 0) {
                resObj_a.setResult(PrereqResult.ExecuteStatus.PASSED);
            } else {
                resObj_a.setResult(PrereqResult.ExecuteStatus.FAILED);
                resObj_a.addDetail(details);
            }
            OLogger.println("\nThe final list of no-op. patches are : " + NoOpPatches.toString());
            return resObj_a;
        }
        if (option == CheckNoOpPatchesOption.IF_SOME_NO_OPS) {
            PrereqResult resObj_a = new PrereqResult();
            if (NoOpPatches.size() < pObjects.length && NoOpPatches.size() > 0) {
                resObj_a.setResult(PrereqResult.ExecuteStatus.PASSED);
            } else {
                resObj_a.setResult(PrereqResult.ExecuteStatus.FAILED);
                resObj_a.addDetail(details);
            }
            OLogger.println("\nThe final list of no-op. patches are : " + NoOpPatches.toString());
            return resObj_a;
        }
        if (NoOpPatches.size() != 0) {
            OLogger.println("\nThe final list of no-op. patches are : " + NoOpPatches.toString());
            if (OPatchEnv.isContinueOnPrereqFailure()) {
                for (int i3 = 0; i3 < NoOpPatches.size(); ++i3) {
                    String patchId = (String)NoOpPatches.elementAt(i3);
                    OUSession.addPrereqResultForPatchesToReport(patchId, OPatchPatchPrereq.CHECK_NO_OPERATION_PATCHES, resObj, OPatchAnalysisReport.PrereqStatusForPatch.SKIP);
                }
            }
        }
        return resObj;
    }

    public static PrereqResult checkForNooppatchesAndPrint(String oracleHomePath) {
        List<PatchObject> pos = null;
        return PQSession.checkForNooppatchesAndPrint(oracleHomePath, pos);
    }

    public static PrereqResult checkForNooppatchesAndPrint(String oracleHomePath, List<PatchObject> pos) {
        String patchLocation = OPatchEnv.getPatchloc();
        String[] patchLocs = null;
        if (PQSession.isBaseDirProvided() || PQSession.isPatchBaseFileProvided()) {
            try {
                patchLocs = PQSession.parseBaseDirListFile();
                patchLocs = PQSession.handleCompositeCases(patchLocs, PQSession.getPatchBaseDir());
            }
            catch (FileNotFoundException e2) {
                OLogger.println("File not found: " + PQSession.getPatchBaseFile());
                return PQSession.printNotExecutedAndReturnResObj("checkForNoopPatches", false);
            }
            catch (IOException e3) {
                OLogger.println("IOException occured: " + e3.getMessage());
                OLogger.printStackTrace(e3);
                return PQSession.printNotExecutedAndReturnResObj("checkForNoopPatches", false);
            }
            catch (OPatchException e4) {
                OLogger.println("OPatchException occured: " + e4.getMessage());
                OLogger.printStackTrace(e4);
                return PQSession.printNotExecutedAndReturnResObj("checkForNoopPatches", false);
            }
        } else if (patchLocation != null && !patchLocation.equals("")) {
            patchLocs = new String[]{patchLocation};
            try {
                patchLocs = PQSession.handleCompositeCases(patchLocs, PQSession.getPatchBaseDir());
            }
            catch (FileNotFoundException e5) {
                OLogger.println("File not found: " + PQSession.getPatchBaseFile());
                return PQSession.printNotExecutedAndReturnResObj("checkForNoopPatches", false);
            }
            catch (IOException e6) {
                OLogger.println("IOException occured: " + e6.getMessage());
                OLogger.printStackTrace(e6);
                return PQSession.printNotExecutedAndReturnResObj("checkForNoopPatches", false);
            }
        } else {
            return PQSession.printNotExecutedAndReturnResObj("checkForNoopPatches", true);
        }
        PatchObject[] pObjects = new PatchObject[patchLocs.length];
        if (pos == null) {
            for (int i2 = 0; i2 < patchLocs.length; ++i2) {
                try {
                    pObjects[i2] = PatchObject.getInstance(patchLocs[i2]);
                    continue;
                }
                catch (Exception e7) {
                    OLogger.println("Prereq \"checkForNoOppatches\" not executed");
                    OLogger.println("Unable to create Patch Object.\nException occured : " + e7.getMessage());
                    OLogger.printStackTrace(e7);
                }
            }
        } else {
            pObjects = pos.toArray(new PatchObject[patchLocs.length]);
        }
        Vector NoOpPatches = new Vector();
        OLogger.println("\nThis prereq checks if any of the patch(es) in the input patch list is a no-op. patch.");
        OLogger.println("This prereq would fail if there are no-op. patch(es).");
        PrereqResult resObj = PrereqAPI.checkNoOpPatches(oracleHomePath, pObjects, NoOpPatches);
        PQSession.printTheResult(resObj, "\"checkForNoOpPatches\"");
        if (NoOpPatches.size() != 0) {
            OLogger.println("\nThe final list of no-op. patches are : " + NoOpPatches.toString());
        }
        return resObj;
    }

    public static void checkforidenticalpatchinoraclehome(String oracleHomePath) throws Exception {
        PQSession.checkForIdenticalPatchInOracleHomeAndPrint(oracleHomePath);
    }

    public static PrereqResult checkForIdenticalPatchInOracleHomeAndPrint(String oracleHomePath) throws Exception {
        return PQSession.checkForIdenticalPatchInOracleHomeAndPrint(oracleHomePath, null);
    }

    public static PrereqResult checkForIdenticalPatchInOracleHomeAndPrint(String oracleHomePath, List<PatchObject> pos) throws Exception {
        PrereqResult resObj = null;
        String[] patchLocs = null;
        if (PQSession.isBaseDirProvided() || PQSession.isPatchBaseFileProvided()) {
            try {
                patchLocs = PQSession.parseBaseDirListFile();
                patchLocs = PQSession.handleCompositeCases(patchLocs, PQSession.getPatchBaseDir());
            }
            catch (Exception e2) {
                OLogger.println("Prereq \"checkForIdenticalPatchInOracleHome\" not executed.");
                OLogger.printStackTrace(e2);
                throw e2;
            }
        } else {
            patchLocs = new String[]{OPatchEnv.getPatchloc()};
            if (patchLocs[0] == null || patchLocs[0].equals("")) {
                return PQSession.printNotExecutedAndReturnResObj("checkForIdenticalPatchInOracleHome", true);
            }
            patchLocs = PQSession.handleCompositeCases(patchLocs, PQSession.getPatchBaseDir());
        }
        ArrayList<OneOffEntry> oneOffsList = new ArrayList<OneOffEntry>();
        if (pos == null) {
            for (int i2 = 0; i2 < patchLocs.length; ++i2) {
                ArrayList<String> filteredSet = new ArrayList<String>();
                try {
                    PatchObject pObj = null;
                    pObj = PatchObject.getInstance(patchLocs[i2]);
                    if (filteredSet.contains(pObj.getPatchID())) continue;
                    oneOffsList.add(pObj.toOneOffEntry(oracleHomePath));
                    filteredSet.add(pObj.getPatchID());
                    continue;
                }
                catch (Exception e3) {
                    OLogger.println("\nPrereq \"checkForIdenticalPatchInOracleHome\" not executed");
                    OLogger.println("Unable to create Patch Object. Check if the given patch location \"" + patchLocs[i2] + "\"is correct.");
                    OLogger.printStackTrace(e3);
                }
            }
        } else {
            for (PatchObject pObj : pos) {
                ArrayList<String> filteredSet = new ArrayList<String>();
                try {
                    if (filteredSet.contains(pObj.getPatchID())) continue;
                    oneOffsList.add(pObj.toOneOffEntry(oracleHomePath));
                    filteredSet.add(pObj.getPatchID());
                }
                catch (Exception e4) {
                    OLogger.println("\nPrereq \"checkForIdenticalPatchInOracleHome\" not executed");
                    OLogger.println("Unable to create Patch Object. Exception occured: \n" + e4.getMessage());
                    OLogger.printStackTrace(e4);
                }
            }
        }
        OneOffEntry[] oneoffs = new OneOffEntry[oneOffsList.size()];
        oneOffsList.toArray(oneoffs);
        try {
            resObj = PrereqAPI.checkIdenticalPatch(oracleHomePath, new ArrayList(), oneoffs);
            PQSession.printTheResult(resObj, "\"checkForIdenticalPatchInOracleHome\"");
        }
        catch (ExitOPatchException e5) {
            resObj = new PrereqResult();
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            resObj.addDetail(e5.getMessage());
            PQSession.printTheResult(resObj, "\"checkForIdenticalPatchInOracleHome\"");
        }
        catch (Exception e6) {
            OLogger.println("\nPrereq \"checkForIdenticalPatchInOracleHome\" not executed due to errors.");
            OLogger.printStackTrace(e6);
            OLogger.println("\nPlease refer log file for more details.");
            return PQSession.printNotExecutedAndReturnResObj("checkForIdenticalPatchInOracleHome", false);
        }
        return resObj;
    }

    public static void checkpatchsetupdatecompatible(String oracleHomePath) {
        PrereqResult resObj = PQSession.checkPatchsetUpdateCompatibleAndPrint(oracleHomePath);
    }

    public static PrereqResult checkPatchsetUpdateCompatibleAndPrint(String oracleHomePath) {
        return PQSession.checkPatchsetUpdateCompatibleAndPrint(oracleHomePath, null);
    }

    public static PrereqResult checkPatchsetUpdateCompatibleAndPrint(String oracleHomePath, List<PatchObject> pos) {
        String patchLocation = OPatchEnv.getPatchloc();
        String[] patchLocs = null;
        if (PQSession.isBaseDirProvided() || PQSession.isPatchBaseFileProvided()) {
            try {
                patchLocs = PQSession.parseBaseDirListFile();
                patchLocs = PQSession.handleCompositeCases(patchLocs, PQSession.getPatchBaseDir());
            }
            catch (FileNotFoundException e2) {
                OLogger.println("File not found: " + PQSession.getPatchBaseFile());
                OLogger.printStackTrace(e2);
                return PQSession.printNotExecutedAndReturnResObj("checkPatchsetUpdateCompatible", false);
            }
            catch (IOException e3) {
                OLogger.println("IOException occured: " + e3.getMessage());
                OLogger.printStackTrace(e3);
                return PQSession.printNotExecutedAndReturnResObj("checkPatchsetUpdateCompatible", false);
            }
            catch (OPatchException e4) {
                OLogger.println("OPatchException occurred: " + e4.getMessage());
                OLogger.printStackTrace(e4);
                return PQSession.printNotExecutedAndReturnResObj("checkPatchsetUpdateCompatible", false);
            }
        } else if (patchLocation != null && !patchLocation.equals("")) {
            patchLocs = new String[]{patchLocation};
            try {
                patchLocs = PQSession.handleCompositeCases(patchLocs, PQSession.getPatchBaseDir());
            }
            catch (FileNotFoundException e5) {
                OLogger.println("File not found: " + PQSession.getPatchBaseFile());
                OLogger.printStackTrace(e5);
                return PQSession.printNotExecutedAndReturnResObj("checkPatchsetUpdateCompatible", false);
            }
            catch (IOException e6) {
                OLogger.println("IOException occured: " + e6.getMessage());
                OLogger.printStackTrace(e6);
                return PQSession.printNotExecutedAndReturnResObj("checkPatchsetUpdateCompatible", false);
            }
        } else {
            return PQSession.printNotExecutedAndReturnResObj("checkPatchsetUpdateCompatible", true);
        }
        PatchObject[] pObjects = new PatchObject[patchLocs.length];
        if (pos != null) {
            pObjects = pos.toArray(new PatchObject[patchLocs.length]);
        } else {
            for (int i2 = 0; i2 < patchLocs.length; ++i2) {
                try {
                    pObjects[i2] = PatchObject.getInstance(patchLocs[i2]);
                    continue;
                }
                catch (Exception e7) {
                    OLogger.println("Prereq \"checkPatchsetUpdateCompatible\" not executed");
                    OLogger.println("Unable to create Patch Object.\nException occured : " + e7.getMessage());
                }
            }
        }
        PrereqResult resObj = PrereqAPI.checkPatchsetUpdateCompatible(oracleHomePath, pObjects);
        PQSession.printTheResult(resObj, "\"checkPatchsetUpdateCompatible\"");
        return resObj;
    }

    public static void checkpatchsetupdatecomponents(String oracleHomePath) {
        PrereqResult resObj = PQSession.checkPatchsetUpdateComponentsAndPrint(oracleHomePath);
    }

    public static PrereqResult checkPatchsetUpdateComponentsAndPrint(String oracleHomePath) {
        return PQSession.checkPatchsetUpdateComponentsAndPrint(oracleHomePath, null);
    }

    public static PrereqResult checkPatchsetUpdateComponentsAndPrint(String oracleHomePath, List<PatchObject> pos) {
        String patchLocation = OPatchEnv.getPatchloc();
        String[] patchLocs = null;
        if (PQSession.isBaseDirProvided() || PQSession.isPatchBaseFileProvided()) {
            try {
                patchLocs = PQSession.parseBaseDirListFile();
                patchLocs = PQSession.handleCompositeCases(patchLocs, PQSession.getPatchBaseDir());
            }
            catch (FileNotFoundException e2) {
                OLogger.println("File not found: " + PQSession.getPatchBaseFile());
                return PQSession.printNotExecutedAndReturnResObj("checkPatchsetUpdateComponents", false);
            }
            catch (IOException e3) {
                OLogger.println("IOException occured: " + e3.getMessage());
                OLogger.printStackTrace(e3);
                return PQSession.printNotExecutedAndReturnResObj("checkPatchsetUpdateComponents", false);
            }
            catch (OPatchException e4) {
                OLogger.println("OPatchException occured: " + e4.getMessage());
                OLogger.printStackTrace(e4);
                return PQSession.printNotExecutedAndReturnResObj("checkPatchsetUpdateComponents", false);
            }
        } else if (patchLocation != null && !patchLocation.equals("")) {
            patchLocs = new String[]{patchLocation};
            try {
                patchLocs = PQSession.handleCompositeCases(patchLocs, PQSession.getPatchBaseDir());
            }
            catch (FileNotFoundException e5) {
                OLogger.println("File not found: " + PQSession.getPatchBaseFile());
                return PQSession.printNotExecutedAndReturnResObj("checkPatchsetUpdateComponents", false);
            }
            catch (IOException e6) {
                OLogger.println("IOException occured: " + e6.getMessage());
                OLogger.printStackTrace(e6);
                return PQSession.printNotExecutedAndReturnResObj("checkPatchsetUpdateComponents", false);
            }
        } else {
            return PQSession.printNotExecutedAndReturnResObj("checkPatchsetUpdateComponents", true);
        }
        PatchObject[] pObjects = new PatchObject[patchLocs.length];
        if (pos != null) {
            pObjects = pos.toArray(new PatchObject[patchLocs.length]);
        } else {
            for (int i2 = 0; i2 < patchLocs.length; ++i2) {
                try {
                    pObjects[i2] = PatchObject.getInstance(patchLocs[i2]);
                    continue;
                }
                catch (Exception e7) {
                    OLogger.println("Prereq \"checkPatchsetUpdateComponents\" not executed");
                    OLogger.println("Unable to create Patch Object.\nException occurred : " + e7.getMessage());
                }
            }
        }
        PrereqResult resObj = PrereqAPI.checkPatchsetUpdateComponents(oracleHomePath, pObjects);
        PQSession.printTheResult(resObj, "\"checkPatchsetUpdateComponents\"");
        return resObj;
    }

    public static void checkapplicableproduct(String oracleHomePath) {
        ArrayList resultsArray = PQSession.checkApplicableProductAndPrint(oracleHomePath);
    }

    public static ArrayList checkApplicableProductAndPrint(String oracleHomePath) {
        String patchLocation = OPatchEnv.getPatchloc();
        String[] patchLocs = null;
        ArrayList<PrereqResult> resultsArray = new ArrayList<PrereqResult>();
        if (PQSession.isBaseDirProvided() || PQSession.isPatchBaseFileProvided()) {
            try {
                patchLocs = PQSession.parseBaseDirListFile();
                patchLocs = PQSession.handleCompositeCases(patchLocs, PQSession.getPatchBaseDir());
            }
            catch (FileNotFoundException e2) {
                OLogger.println("File not found: " + PQSession.getPatchBaseFile());
                PrereqResult resObj = new PrereqResult();
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                return new ArrayList<PrereqResult>(Arrays.asList(resObj));
            }
            catch (IOException e3) {
                OLogger.println("IOException occured: " + e3.getMessage());
                PrereqResult resObj = PQSession.printNotExecutedAndReturnResObj("checkApplicableProduct", false);
                OLogger.printStackTrace(e3);
                return new ArrayList<PrereqResult>(Arrays.asList(resObj));
            }
            catch (OPatchException e4) {
                OLogger.println("OPatchException occured: " + e4.getMessage());
                PrereqResult resObj = PQSession.printNotExecutedAndReturnResObj("checkApplicableProduct", false);
                OLogger.printStackTrace(e4);
                return new ArrayList<PrereqResult>(Arrays.asList(resObj));
            }
        } else if (patchLocation != null && !patchLocation.equals("")) {
            patchLocs = new String[]{patchLocation};
            try {
                patchLocs = PQSession.handleCompositeCases(patchLocs, PQSession.getPatchBaseDir());
            }
            catch (FileNotFoundException e5) {
                OLogger.println("File not found: " + PQSession.getPatchBaseFile());
                PrereqResult resObj = PQSession.printNotExecutedAndReturnResObj("checkApplicableProduct", false);
                return new ArrayList<PrereqResult>(Arrays.asList(resObj));
            }
            catch (IOException e6) {
                OLogger.println("IOException occured: " + e6.getMessage());
                PrereqResult resObj = PQSession.printNotExecutedAndReturnResObj("checkApplicableProduct", false);
                OLogger.printStackTrace(e6);
                return new ArrayList<PrereqResult>(Arrays.asList(resObj));
            }
        } else {
            PrereqResult resObj = PQSession.printNotExecutedAndReturnResObj("checkApplicableProduct", true);
            return new ArrayList<PrereqResult>(Arrays.asList(resObj));
        }
        for (int i2 = 0; i2 < patchLocs.length; ++i2) {
            ArrayList<String> filteredSet = new ArrayList<String>();
            try {
                PatchObject pObj = PatchObject.getInstance(patchLocs[i2]);
                if (filteredSet.contains(pObj.getPatchID())) continue;
                filteredSet.add(pObj.getPatchID());
                PrereqResult resObj = PrereqAPI.checkApplicableProduct(oracleHomePath, pObj);
                resultsArray.add(resObj);
                PQSession.printTheResult(resObj, "\"checkApplicableProduct\" for patch " + pObj.getPatchID());
                continue;
            }
            catch (Exception e7) {
                OLogger.println("Prereq \"checkApplicableProduct\" not executed");
                OLogger.println("Unable to create Patch Object.\nException occured : " + e7.getMessage());
                OLogger.printStackTrace(e7);
            }
        }
        return resultsArray;
    }

    public static void checkouilocation(String oracleHomePath) {
        PrereqResult resObj = PrereqAPI.checkOUILocation(oracleHomePath);
        PQSession.printTheResult(resObj, "\"checkOUILocation\"");
    }

    public static void checkorainstlocation(String oracleHomePath) {
        PrereqResult resObj = PrereqAPI.checkOraInstLocation(PQSession.getOraInstLocation());
        PQSession.printTheResult(resObj, "\"checkOraInstLocation\"");
    }

    public static void checkcentralinventorylocation(String oracleHomePath) {
        PrereqResult resObj = PQSession.checkCentralInventoryLocationAndPrint();
    }

    public static PrereqResult checkCentralInventoryLocationAndPrint() {
        String centralInventoryLoc = OPatchEnv.getCentralInvLoc();
        PrereqResult resObj = PrereqAPI.checkCentralInventoryLocation(centralInventoryLoc);
        PQSession.printTheResult(resObj, "\"checkCentralInventoryLocation\"");
        return resObj;
    }

    public static void checkpatchapplicableoncurrentplatform(String oracleHomePath) throws Exception {
        ArrayList resultsArray = PQSession.checkPatchApplicableOnCurrentPlatformAndPrint(oracleHomePath);
    }

    public static ArrayList checkPatchApplicableOnCurrentPlatformAndPrint(String oracleHomePath) throws Exception {
        PrereqResult resObj = null;
        String[] patchLocs = null;
        ArrayList<PrereqResult> resultsArray = new ArrayList<PrereqResult>();
        if (PQSession.isBaseDirProvided() || PQSession.isPatchBaseFileProvided()) {
            try {
                patchLocs = PQSession.parseBaseDirListFile();
                patchLocs = PQSession.handleCompositeCases(patchLocs, PQSession.getPatchBaseDir());
            }
            catch (Exception e2) {
                OLogger.println("Prereq \"checkPatchApplicableOnCurrentPlatform\" not executed.");
                OLogger.printStackTrace(e2);
                throw e2;
            }
        } else {
            patchLocs = new String[]{OPatchEnv.getPatchloc()};
            if (patchLocs[0] == null || patchLocs[0].equals("")) {
                resObj = PQSession.printNotExecutedAndReturnResObj("checkPatchApplicableOnCurrentPlatform", false);
                return new ArrayList<PrereqResult>(Arrays.asList(resObj));
            }
            patchLocs = PQSession.handleCompositeCases(patchLocs, PQSession.getPatchBaseDir());
        }
        for (int i2 = 0; i2 < patchLocs.length; ++i2) {
            ArrayList<String> filteredSet = new ArrayList<String>();
            try {
                PatchObject[] pObj = new PatchObject[]{PatchObject.getInstance(patchLocs[i2])};
                if (filteredSet.contains(pObj[0].getPatchID())) continue;
                filteredSet.add(pObj[0].getPatchID());
                resObj = PrereqAPI.checkPatchApplicableOnCurrentPlatform(oracleHomePath, pObj);
                resultsArray.add(resObj);
                PQSession.printTheResult(resObj, "\"checkPatchApplicableOnCurrentPlatform\" for patch " + pObj[0].getPatchID());
                continue;
            }
            catch (Exception e3) {
                resObj = PQSession.printNotExecutedAndReturnResObj("checkPatchApplicableOnCurrentPlatform", true);
                resultsArray.add(resObj);
            }
        }
        return resultsArray;
    }

    public static void checkpatchshiphome(String oracleHomePath) throws Exception {
        ArrayList resultsArray = PQSession.checkPatchShipHomeAndPrint();
    }

    public static ArrayList checkPatchShipHomeAndPrint() throws Exception {
        return PQSession.checkPatchShipHomeAndPrint(null);
    }

    public static ArrayList checkPatchShipHomeAndPrint(List<PatchObject> pos) throws Exception {
        PrereqResult resObj = null;
        String[] patchLocs = null;
        ArrayList<PrereqResult> resultsArray = new ArrayList<PrereqResult>();
        if (PQSession.isBaseDirProvided() || PQSession.isPatchBaseFileProvided()) {
            try {
                patchLocs = PQSession.parseBaseDirListFile();
                patchLocs = PQSession.handleCompositeCases(patchLocs, PQSession.getPatchBaseDir());
            }
            catch (Exception e2) {
                OLogger.println("Prereq \"checkPatchShipHome\" not executed.");
                OLogger.printStackTrace(e2);
                throw e2;
            }
        } else {
            patchLocs = new String[]{OPatchEnv.getPatchloc()};
            if (patchLocs[0] == null || patchLocs[0].equals("")) {
                resObj = PQSession.printNotExecutedAndReturnResObj("checkPatchShipHome", false);
                return new ArrayList<PrereqResult>(Arrays.asList(resObj));
            }
            patchLocs = PQSession.handleCompositeCases(patchLocs, PQSession.getPatchBaseDir());
        }
        if (patchLocs == null || patchLocs.length == 0) {
            resObj = PQSession.printNotExecutedAndReturnResObj("checkPatchShipHome", true);
            return new ArrayList<PrereqResult>(Arrays.asList(resObj));
        }
        if (pos == null) {
            for (int i2 = 0; i2 < patchLocs.length; ++i2) {
                String patchID = "";
                String[] patchLocation = new String[]{patchLocs[i2]};
                resObj = PrereqAPI.checkPatchShipHome(patchLocation);
                try {
                    PatchObject pObj = PatchObject.getInstance(patchLocation[0]);
                    patchID = pObj.getPatchID();
                    if (OPatchEnv.isContinueOnPrereqFailure() && resObj.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                        OUSession.addPrereqResultForPatchesToReport(patchID, OPatchPatchPrereq.CHECK_PATCH_SHIPHOME, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
                    }
                }
                catch (Exception e3) {
                    patchID = patchLocation[0];
                }
                resultsArray.add(resObj);
                PQSession.printTheResult(resObj, "\"checkPatchShipHome\" for patch " + patchID);
            }
        } else {
            for (PatchObject pObj : pos) {
                String patchID = "";
                String patchLocation = pObj.getPatchLocation();
                resObj = PrereqAPI.checkPatchShipHome(new String[]{patchLocation});
                try {
                    patchID = pObj.getPatchID();
                    if (OPatchEnv.isContinueOnPrereqFailure() && resObj.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                        OUSession.addPrereqResultForPatchesToReport(patchID, OPatchPatchPrereq.CHECK_PATCH_SHIPHOME, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
                    }
                }
                catch (Exception e4) {
                    patchID = patchLocation;
                }
                resultsArray.add(resObj);
                PQSession.printTheResult(resObj, "\"checkPatchShipHome\" for patch " + patchID);
            }
        }
        return resultsArray;
    }

    public static void checkuseradminprivilege(String oracleHomePath) {
        PrereqResult resObj = PrereqAPI.checkUserAdminPrivilege(oracleHomePath);
        PQSession.printTheResult(resObj, "\"checkUserAdminPrivilege\"");
    }

    public static void checksystemcommandavailable(String oracleHomePath) throws Exception {
        ArrayList resultsArray = PQSession.checkSystemCommandAvailableAndPrint(oracleHomePath);
    }

    public static ArrayList checkSystemCommandAvailableAndPrint(String oracleHomePath) throws Exception {
        PrereqResult pRes;
        Vector installedPatchIDs;
        Vector notInstalledPatchIDs;
        String patchLocation = OPatchEnv.getPatchloc();
        String[] patchLocs = null;
        String[] patchID = new String[]{OPatchEnv.getRollbackPatchid()};
        Vector inPatchIDs = new Vector();
        boolean inSystem = false;
        ArrayList<PrereqResult> resultsArray = new ArrayList<PrereqResult>();
        if (PQSession.isBaseDirProvided() || PQSession.isPatchBaseFileProvided()) {
            try {
                patchLocs = PQSession.parseBaseDirListFile();
                patchLocs = PQSession.handleCompositeCases(patchLocs, PQSession.getPatchBaseDir());
            }
            catch (Exception e2) {
                OLogger.println("\nPrereq \"checkSystemCommandAvailable\" not executed.");
                OLogger.printStackTrace(e2);
                throw e2;
            }
        } else if (OPatchEnv.isUserSuppliedPatchIDs()) {
            notInstalledPatchIDs = new Vector();
            installedPatchIDs = new Vector();
            pRes = PrereqAPI.checkInstalledOneOffs(oracleHomePath, OPatchEnv.getUserSuppliedPatchIDs(), installedPatchIDs, notInstalledPatchIDs);
            if (pRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                if (installedPatchIDs.size() == 0) {
                    OLogger.println("None of the given patches are present in the Oracle Home.");
                    pRes = PQSession.printNotExecutedAndReturnResObj("checkSystemCommandAvailable", false);
                    return new ArrayList<PrereqResult>(Arrays.asList(pRes));
                }
                StringBuffer tbuf = new StringBuffer("Following patches are not installed and are skipped:\n");
                tbuf.append(notInstalledPatchIDs.toString());
                OLogger.println(tbuf.toString());
            } else if (pRes.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED) {
                PQSession.printTheResult(pRes, "\"checkSystemCommandAvailable\"");
            }
            patchLocs = new String[installedPatchIDs.size()];
            for (int i2 = 0; i2 < installedPatchIDs.size(); ++i2) {
                patchLocs[i2] = OPatchEnv.getPatchFilemapInfoLoc(oracleHomePath, (String)installedPatchIDs.elementAt(i2));
            }
            inPatchIDs = installedPatchIDs;
            inSystem = true;
        } else if (patchID[0] != null && !patchID[0].equals("")) {
            installedPatchIDs = new Vector();
            notInstalledPatchIDs = new Vector();
            pRes = PrereqAPI.checkInstalledOneOffs(oracleHomePath, patchID, installedPatchIDs, notInstalledPatchIDs);
            if (pRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                OLogger.println("Patch " + notInstalledPatchIDs.elementAt(0) + " is not present in the Oracle Home.");
                return new ArrayList<PrereqResult>(Arrays.asList(pRes));
            }
            if (pRes.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED) {
                PQSession.printTheResult(pRes, "\"checkSystemCommandAvailable\"");
            }
            patchLocs = new String[]{OPatchEnv.getPatchFilemapInfoLoc(oracleHomePath, (String)installedPatchIDs.elementAt(0))};
            inPatchIDs = installedPatchIDs;
            inSystem = true;
        } else if (patchLocation != null && !patchLocation.equals("")) {
            patchLocs = new String[]{patchLocation};
            patchLocs = PQSession.handleCompositeCases(patchLocs, PQSession.getPatchBaseDir());
        } else {
            PrereqResult pRes2 = PQSession.printNotExecutedAndReturnResObj("checkSystemCommandAvailable", true);
            return new ArrayList<PrereqResult>(Arrays.asList(pRes2));
        }
        for (int i3 = 0; i3 < patchLocs.length; ++i3) {
            ArrayList<String> filteredSet = new ArrayList<String>();
            try {
                PatchObject pObj = null;
                pObj = !inSystem ? PatchObject.getInstance(patchLocs[i3]) : PatchObject.getInstance(oracleHomePath, (String)inPatchIDs.elementAt(i3));
                if (filteredSet.contains(pObj.getPatchID())) continue;
                filteredSet.add(pObj.getPatchID());
                OneOffEntry oneOff = pObj.toOneOffEntry(oracleHomePath);
                String[] executables = pObj.getExecutables(oracleHomePath);
                PrereqResult resObj = PrereqAPI.checkSystemCommandAvailable(oracleHomePath, oneOff, executables);
                resultsArray.add(resObj);
                PQSession.printTheResult(resObj, "\"checkSystemCommandAvailable\" for patch " + pObj.getPatchID());
                continue;
            }
            catch (Exception e3) {
                OLogger.println("Prereq \"checkSystemCommandAvailable\" not executed");
                OLogger.println("Unable to create Patch Object.\nException occured : " + e3.getMessage());
                OLogger.printStackTrace(e3);
            }
        }
        return resultsArray;
    }

    public static void checkconflictamongpatches(String oracleHomePath) throws Exception {
        PrereqResult prereqResult = PQSession.checkConflictAmongPatchesAndPrint(oracleHomePath);
    }

    public static PrereqResult checkConflictAmongPatchesAndPrint(String oracleHomePath) throws Exception {
        return PQSession.checkConflictAmongPatchesAndPrint(oracleHomePath, null);
    }

    public static PrereqResult checkConflictAmongPatchesAndPrint(String oracleHomePath, List<PatchObject> patchObjects) throws Exception {
        ConflictOutput resObj = null;
        OneOffEntry[] piOneOffs = null;
        String[] patchLocs = null;
        boolean flag = false;
        ArrayList<OneOffEntry> piArr = new ArrayList<OneOffEntry>();
        try {
            if (!PQSession.isBaseDirProvided() && !PQSession.isPatchBaseFileProvided()) {
                String patchLoc = OPatchEnv.getPatchloc();
                PQSession.setBaseDirProvided();
                PQSession.setPatchBaseDir(patchLoc);
                flag = true;
            }
            patchLocs = PQSession.parseBaseDirListFile();
            patchLocs = PQSession.handleCompositeCases(patchLocs, PQSession.getPatchBaseDir());
            if (patchObjects == null) {
                for (int i2 = 0; i2 < patchLocs.length; ++i2) {
                    PatchObject po = PatchObject.getInstance(patchLocs[i2]);
                    piArr.add(po.toOneOffEntry(oracleHomePath));
                }
            } else {
                for (PatchObject po : patchObjects) {
                    piArr.add(po.toOneOffEntry(oracleHomePath));
                }
            }
            if (flag) {
                PQSession.unsetBaseDirProvided();
            }
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
            PrereqResult resObj1 = new PrereqResult();
            resObj1.addDetail("Unable to create Patch Object.\nException occured : " + e2.getMessage());
            PQSession.printTheResult(resObj1, "\"checkConflictAmongPatches\"");
            OLogger.printStackTrace(e2);
            return resObj1;
        }
        if (piArr.size() == 0) {
            PrereqResult resObj1 = new PrereqResult();
            resObj1.addDetail("No patches specified.");
            PQSession.printTheResult(resObj1, "\"checkConflictAmongPatches\"");
            return resObj1;
        }
        piOneOffs = piArr.toArray(new OneOffEntry[piArr.size()]);
        resObj = PrereqAPI.checkConflictAmongPatches(oracleHomePath, piOneOffs);
        PQSession.printTheResult(resObj, "\"checkConflictAmongPatches\"");
        return resObj == null ? new PrereqResult() : resObj;
    }

    public static void checkconflictagainstoh(String oracleHomePath) throws Exception {
        PrereqResult resObj = PQSession.checkConflictAgainstOHAndPrint(oracleHomePath);
    }

    public static PrereqResult checkConflictAgainstOHAndPrint(String oracleHomePath) throws Exception {
        return PQSession.checkConflictAgainstOHAndPrint(oracleHomePath, null);
    }

    public static PrereqResult checkConflictAgainstOHAndPrint(String oracleHomePath, List<PatchObject> pos) throws Exception {
        ConflictOutput resObj = null;
        OneOffEntry[] piOneOffs = null;
        String[] patchLocs = null;
        boolean flag = false;
        ArrayList<OneOffEntry> piArr = new ArrayList<OneOffEntry>();
        try {
            if (!PQSession.isBaseDirProvided() && !PQSession.isPatchBaseFileProvided()) {
                String patchLoc = OPatchEnv.getPatchloc();
                PQSession.setBaseDirProvided();
                PQSession.setPatchBaseDir(patchLoc);
                flag = true;
            }
            patchLocs = PQSession.parseBaseDirListFile();
            patchLocs = PQSession.handleCompositeCases(patchLocs, PQSession.getPatchBaseDir());
            if (pos == null) {
                for (int i2 = 0; i2 < patchLocs.length; ++i2) {
                    PatchObject po = PatchObject.getInstance(patchLocs[i2]);
                    piArr.add(po.toOneOffEntry(oracleHomePath));
                }
            } else {
                for (PatchObject po : pos) {
                    piArr.add(po.toOneOffEntry(oracleHomePath));
                }
            }
            if (flag) {
                PQSession.unsetBaseDirProvided();
            }
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
            PrereqResult resObj1 = new PrereqResult();
            resObj1.addDetail("Unable to create Patch Object.\nException occured : " + e2.getMessage());
            PQSession.printTheResult(resObj1, "\"checkConflictAgainstOH\"");
            OLogger.printStackTrace(e2);
            return resObj1;
        }
        if (piArr.size() == 0) {
            PrereqResult resObj1 = new PrereqResult();
            resObj1.addDetail("No patches specified.");
            PQSession.printTheResult(resObj1, "\"checkConflictAgainstOH\"");
            return resObj1;
        }
        piOneOffs = piArr.toArray(new OneOffEntry[piArr.size()]);
        resObj = PrereqAPI.checkConflictAgainstOH(oracleHomePath, piOneOffs);
        PQSession.printTheResult(resObj, "\"checkConflictAgainstOH\"");
        if (resObj == null) {
            OLogger.println("Prereq result object for conflict is null.");
        }
        return resObj == null ? new PrereqResult() : resObj;
    }

    public static void checkapplicable(String oracleHomePath) throws Exception {
        ArrayList resultsArray = PQSession.checkApplicableAndPrint(oracleHomePath);
    }

    public static ArrayList checkApplicableAndPrint(String oracleHomePath) throws Exception {
        return PQSession.checkApplicableAndPrint(oracleHomePath, null);
    }

    public static ArrayList checkApplicableAndPrint(String oracleHomePath, List<PatchObject> pos) throws Exception {
        PrereqResult resObj = null;
        String[] patchLocs = null;
        ArrayList<PrereqResult> resultsArray = new ArrayList<PrereqResult>();
        if (PQSession.isBaseDirProvided() || PQSession.isPatchBaseFileProvided()) {
            try {
                patchLocs = PQSession.parseBaseDirListFile();
                patchLocs = PQSession.handleCompositeCases(patchLocs, PQSession.getPatchBaseDir());
            }
            catch (Exception e2) {
                OLogger.println("Prereq \"checkApplicable\" not executed.");
                OLogger.printStackTrace(e2);
                throw e2;
            }
        } else {
            patchLocs = new String[]{OPatchEnv.getPatchloc()};
            if (patchLocs[0] == null || patchLocs[0].equals("")) {
                resObj = PQSession.printNotExecutedAndReturnResObj("checkApplicable", true);
                return new ArrayList<PrereqResult>(Arrays.asList(resObj));
            }
            patchLocs = PQSession.handleCompositeCases(patchLocs, PQSession.getPatchBaseDir());
        }
        if (patchLocs == null || patchLocs.length == 0) {
            resObj = PQSession.printNotExecutedAndReturnResObj("checkApplicable", true);
            return new ArrayList<PrereqResult>(Arrays.asList(resObj));
        }
        if (pos == null) {
            for (int i2 = 0; i2 < patchLocs.length; ++i2) {
                ArrayList<String> filteredSet = new ArrayList<String>();
                try {
                    PatchObject[] pObj = new PatchObject[]{PatchObject.getInstance(patchLocs[i2])};
                    if (filteredSet.contains(pObj[0].getPatchID())) continue;
                    filteredSet.add(pObj[0].getPatchID());
                    resObj = PrereqAPI.checkApplicable(oracleHomePath, pObj);
                    resultsArray.add(resObj);
                    PQSession.printTheResult(resObj, "\"checkApplicable\" for patch " + pObj[0].getPatchID());
                    continue;
                }
                catch (Exception e3) {
                    boolean hasNoPatchLoc = true;
                    if (e3 instanceof SymbolFailureException) {
                        OLogger.println(e3.getMessage());
                        hasNoPatchLoc = false;
                    }
                    resObj = PQSession.printNotExecutedAndReturnResObj("checkApplicable", hasNoPatchLoc);
                    resultsArray.add(resObj);
                }
            }
        } else {
            Iterator<PatchObject> iterator = pos.iterator();
            while (iterator.hasNext()) {
                ArrayList<String> filteredSet = new ArrayList<String>();
                PatchObject po = iterator.next();
                if (filteredSet.contains(po.getPatchID())) continue;
                filteredSet.add(po.getPatchID());
                resObj = PrereqAPI.checkApplicable(oracleHomePath, new PatchObject[]{po});
                resultsArray.add(resObj);
                PQSession.printTheResult(resObj, "\"checkApplicable\" for patch " + po.getPatchID());
            }
        }
        return resultsArray;
    }

    public static void checkrollbacksid(String oracleHomePath) {
        ArrayList resultsArray = PQSession.checkRollbackSidAndPrint(oracleHomePath);
    }

    public static ArrayList checkRollbackSidAndPrint(String oracleHomePath) {
        PrereqResult pRes;
        PrereqResult resObj = null;
        String[] patchID = new String[]{OPatchEnv.getRollbackPatchid()};
        Vector installedPatchIDs = new Vector();
        Vector notInstalledPatchIDs = new Vector();
        StringBuffer buff = new StringBuffer();
        ArrayList<PrereqResult> resultsArray = new ArrayList<PrereqResult>();
        if (OPatchEnv.isUserSuppliedPatchIDs()) {
            pRes = PrereqAPI.checkInstalledOneOffs(oracleHomePath, OPatchEnv.getUserSuppliedPatchIDs(), installedPatchIDs, notInstalledPatchIDs);
            if (pRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                if (installedPatchIDs.size() == 0) {
                    OLogger.println("None of the given patches are present in the Oracle Home.");
                    return new ArrayList<PrereqResult>(Arrays.asList(pRes));
                }
                StringBuffer tbuf = new StringBuffer("Following patches are not installed and are skipped:\n");
                tbuf.append(notInstalledPatchIDs.toString());
                OLogger.println(tbuf.toString());
            } else if (pRes.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED) {
                PQSession.printTheResult(pRes, "\"checkRollbackSid\"");
            }
        } else if (patchID[0] != null && !patchID[0].equals("")) {
            pRes = PrereqAPI.checkInstalledOneOffs(oracleHomePath, patchID, installedPatchIDs, notInstalledPatchIDs);
            if (pRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                OLogger.println("Patch " + notInstalledPatchIDs.elementAt(0) + " is not present in the Oracle Home.");
                return new ArrayList<PrereqResult>(Arrays.asList(pRes));
            }
            if (pRes.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED) {
                PQSession.printTheResult(pRes, "\"checkRollbackSid\"");
            }
        } else {
            resObj = PQSession.printNotExecutedAndReturnResObjPatchID("checkRollbackSid");
            return new ArrayList<PrereqResult>(Arrays.asList(resObj));
        }
        HashSet sidInfo = OPatchEnv.getSidInformation();
        if (sidInfo.size() == 0) {
            String[] dbSids = OPatchEnv.getDBSIDs();
            String[] dbNodes = OPatchEnv.getDBNodes();
            String localNode = OPatchEnv.getLocalNode();
            for (int i2 = 0; i2 < dbSids.length; ++i2) {
                if (!dbNodes[i2].equals(localNode) && !dbNodes[i2].equals("")) continue;
                sidInfo.add(dbSids[i2]);
            }
        }
        for (int i3 = 0; i3 < installedPatchIDs.size(); ++i3) {
            try {
                PatchObject[] pObj = new PatchObject[]{PatchObject.getInstance(oracleHomePath, (String)installedPatchIDs.elementAt(i3))};
                if (!pObj[0].isSqlRelatedActions() && !pObj[0].isOnlinePatch()) {
                    OLogger.println("Prereq \"checkRollbackSid\" is not executed for the patch \"" + pObj[0].getPatchID() + "\".");
                    OLogger.println("Patch \"" + pObj[0].getPatchID() + "\" is neither an online patch nor has sql related actions.");
                    continue;
                }
                resObj = PrereqAPI.checkRollbackSid(oracleHomePath, pObj[0], sidInfo, false);
                if (OPatchEnv.isContinueOnPrereqFailure() && resObj.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                    OUSession.addPrereqResultForPatchesToReport(pObj[0].getPatchID(), OPatchPatchPrereq.CHECK_ROLLBACK_SID, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
                }
                resultsArray.add(resObj);
                PQSession.printTheResult(resObj, "\"checkRollbackSid\" for patch " + pObj[0].getPatchID());
                continue;
            }
            catch (Exception e2) {
                OLogger.printStackTrace(e2);
                OLogger.println("\nPrereq \"checkRollbackSid\" not executed");
                OLogger.println("\nUnable to create Patch Object. Check if the given patch is present in the Oracle Home.");
            }
        }
        return resultsArray;
    }

    public static void checkrollbackable(String oracleHomePath) {
        ArrayList resultsArray = PQSession.checkRollbackableAndPrint(oracleHomePath);
    }

    public static ArrayList checkRollbackableAndPrint(String oracleHomePath) {
        return PQSession.checkRollbackableAndPrint(oracleHomePath, null);
    }

    public static ArrayList checkRollbackableAndPrint(String oracleHomePath, List<PatchObject> pos) {
        PrereqResult pRes;
        PrereqResult resObj = null;
        String[] patchID = new String[]{OPatchEnv.getRollbackPatchid()};
        Vector notInstalledPatchIDs = new Vector();
        Vector installedPatchIDs = new Vector();
        ArrayList<PrereqResult> resultsArray = new ArrayList<PrereqResult>();
        if (OPatchEnv.isUserSuppliedPatchIDs()) {
            pRes = PrereqAPI.checkInstalledOneOffs(oracleHomePath, OPatchEnv.getUserSuppliedPatchIDs(), installedPatchIDs, notInstalledPatchIDs);
            if (pRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                if (installedPatchIDs.size() == 0) {
                    OLogger.println("None of the given patches are present in the Oracle Home.");
                    return new ArrayList<PrereqResult>(Arrays.asList(pRes));
                }
                StringBuffer tbuf = new StringBuffer("Following patches are not installed and are skipped:\n");
                tbuf.append(notInstalledPatchIDs.toString());
                OLogger.println(tbuf.toString());
            } else if (pRes.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED) {
                PQSession.printTheResult(pRes, "\"checkRollbackable\"");
            }
        } else if (patchID[0] != null && !patchID[0].equals("")) {
            pRes = PrereqAPI.checkInstalledOneOffs(oracleHomePath, patchID, installedPatchIDs, notInstalledPatchIDs);
            if (pRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                OLogger.println("Patch " + notInstalledPatchIDs.elementAt(0) + " is not present in the Oracle Home.");
                return new ArrayList<PrereqResult>(Arrays.asList(pRes));
            }
            if (pRes.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED) {
                PQSession.printTheResult(pRes, "\"checkRollbackable\"");
            }
        } else {
            resObj = PQSession.printNotExecutedAndReturnResObjPatchID("checkRollbackable");
            return new ArrayList<PrereqResult>(Arrays.asList(resObj));
        }
        PrereqResult fAppsResObj = null;
        try {
            PatchObject[] fAppsPObj = new PatchObject[installedPatchIDs.size()];
            if (pos == null) {
                for (int i2 = 0; i2 < installedPatchIDs.size(); ++i2) {
                    fAppsPObj[i2] = PatchObject.getInstance(oracleHomePath, (String)installedPatchIDs.elementAt(i2));
                }
            } else {
                fAppsPObj = pos.toArray(new PatchObject[installedPatchIDs.size()]);
            }
            if ((fAppsResObj = PrereqAPI.checkRollbackableForFusionApps(oracleHomePath, fAppsPObj)).getResult() == PrereqResult.ExecuteStatus.FAILED || fAppsResObj.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED) {
                PQSession.printTheResult(fAppsResObj, "\"checkRollbackable\" on input rollback patch list");
                return new ArrayList<PrereqResult>(Arrays.asList(fAppsResObj));
            }
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
            PQSession.printTheResult(fAppsResObj, "\"checkRollbackable\" on input rollback patch list not executed.");
            OLogger.println("\nPlease refer log file for more details.");
            resObj = new PrereqResult();
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            return new ArrayList<PrereqResult>(Arrays.asList(resObj));
        }
        for (int i3 = 0; i3 < installedPatchIDs.size(); ++i3) {
            try {
                PatchObject[] pObj = new PatchObject[]{PatchObject.getInstance(oracleHomePath, (String)installedPatchIDs.elementAt(i3))};
                resObj = PrereqAPI.checkRollbackable(oracleHomePath, pObj);
                resultsArray.add(resObj);
                PQSession.printTheResult(resObj, "\"checkRollbackable\" for patch " + pObj[0].getPatchID());
                continue;
            }
            catch (Exception e3) {
                OLogger.println("\nPrereq \"checkRollbackable\" not executed");
                OLogger.println("Unable to create Patch Object. Check if the given patch is present in the Oracle Home.");
                OLogger.printStackTrace(e3);
            }
        }
        return resultsArray;
    }

    public static void checkactiveservices(String oracleHomePath) {
        PrereqResult resObj = PrereqAPI.checkActiveServices(oracleHomePath);
        PQSession.printTheResult(resObj, "\"checkActiveServices\"");
    }

    public static void checkactivefilesandexecutables(String oracleHomePath) throws Exception {
        ArrayList resultsArray = PQSession.checkActiveFilesAndExecutablesAndPrint(oracleHomePath);
    }

    public static ArrayList checkActiveFilesAndExecutablesAndPrint(String oracleHomePath) throws Exception {
        return PQSession.checkActiveFilesAndExecutablesAndPrint(oracleHomePath, null);
    }

    public static ArrayList checkActiveFilesAndExecutablesAndPrint(String oracleHomePath, List<PatchObject> pos) throws Exception {
        PrereqResult pRes;
        Vector installedPatchIDs;
        Vector notInstalledPatchIDs;
        PrereqResult resObj = null;
        String[] patchLocs = null;
        String patchLocation = OPatchEnv.getPatchloc();
        String[] patchID = new String[]{OPatchEnv.getRollbackPatchid()};
        Vector inPatchIDs = new Vector();
        boolean inSystem = false;
        ArrayList<PrereqResult> resultsArray = new ArrayList<PrereqResult>();
        if (PQSession.isBaseDirProvided() || PQSession.isPatchBaseFileProvided()) {
            try {
                patchLocs = PQSession.parseBaseDirListFile();
                patchLocs = PQSession.handleCompositeCases(patchLocs, PQSession.getPatchBaseDir());
            }
            catch (Exception e2) {
                OLogger.println("\nPrereq \"checkActiveFilesAndExecutables\" not executed.");
                OLogger.printStackTrace(e2);
                throw e2;
            }
        } else if (OPatchEnv.isUserSuppliedPatchIDs()) {
            notInstalledPatchIDs = new Vector();
            installedPatchIDs = new Vector();
            pRes = PrereqAPI.checkInstalledOneOffs(oracleHomePath, OPatchEnv.getUserSuppliedPatchIDs(), installedPatchIDs, notInstalledPatchIDs);
            if (pRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                if (installedPatchIDs.size() == 0) {
                    OLogger.println("None of the given patches are present in the Oracle Home.");
                    resObj = new PrereqResult();
                    resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                    return new ArrayList<PrereqResult>(Arrays.asList(resObj));
                }
                StringBuffer tbuf = new StringBuffer("Following patches are not installed and are skipped:\n");
                tbuf.append(notInstalledPatchIDs.toString());
                OLogger.println(tbuf.toString());
            } else if (pRes.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED) {
                PQSession.printTheResult(pRes, "\"checkActiveFilesAndExecutables\"");
            }
            patchLocs = new String[installedPatchIDs.size()];
            for (int i2 = 0; i2 < installedPatchIDs.size(); ++i2) {
                patchLocs[i2] = OPatchEnv.getPatchFilemapInfoLoc(oracleHomePath, (String)installedPatchIDs.elementAt(i2));
            }
            inPatchIDs = installedPatchIDs;
            inSystem = true;
        } else if (patchID[0] != null && !patchID[0].equals("")) {
            installedPatchIDs = new Vector();
            notInstalledPatchIDs = new Vector();
            pRes = PrereqAPI.checkInstalledOneOffs(oracleHomePath, patchID, installedPatchIDs, notInstalledPatchIDs);
            if (pRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                OLogger.println("Patch " + notInstalledPatchIDs.elementAt(0) + " is not present in the Oracle Home.");
                resObj = new PrereqResult();
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                return new ArrayList<PrereqResult>(Arrays.asList(resObj));
            }
            if (pRes.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED) {
                PQSession.printTheResult(pRes, "\"checkActiveFilesAndExecutables\"");
            }
            patchLocs = new String[]{OPatchEnv.getPatchFilemapInfoLoc(oracleHomePath, (String)installedPatchIDs.elementAt(0))};
            inPatchIDs = installedPatchIDs;
            inSystem = true;
        } else if (patchLocation != null && !patchLocation.equals("")) {
            patchLocs = new String[]{patchLocation};
            patchLocs = PQSession.handleCompositeCases(patchLocs, PQSession.getPatchBaseDir());
        } else {
            resObj = PQSession.printNotExecutedAndReturnResObj("checkActiveFilesAndExecutables", true);
            return new ArrayList<PrereqResult>(Arrays.asList(resObj));
        }
        if (patchLocs.length == 0) {
            resObj = PQSession.printNotExecutedAndReturnResObj("checkActiveFilesAndExecutables", true);
            return new ArrayList<PrereqResult>(Arrays.asList(resObj));
        }
        if (pos == null) {
            for (int i3 = 0; i3 < patchLocs.length; ++i3) {
                ArrayList<String> filteredSet = new ArrayList<String>();
                try {
                    PatchObject pObj = null;
                    pObj = !inSystem ? PatchObject.getInstance(patchLocs[i3]) : PatchObject.getInstance(oracleHomePath, (String)inPatchIDs.elementAt(i3));
                    if (filteredSet.contains(pObj.getPatchID())) continue;
                    filteredSet.add(pObj.getPatchID());
                    resObj = PrereqAPI.checkActiveFilesAndExecutables(oracleHomePath, pObj);
                    resultsArray.add(resObj);
                    PQSession.printTheResult(resObj, "\"checkActiveFilesAndExecutables\" for patch " + pObj.getPatchID());
                    continue;
                }
                catch (Exception e3) {
                    resObj = PQSession.printNotExecutedAndReturnResObj("checkActiveFilesAndExecutables", true);
                    resultsArray.add(resObj);
                }
            }
        } else {
            for (PatchObject pObj : pos) {
                ArrayList<String> filteredSet = new ArrayList<String>();
                try {
                    if (filteredSet.contains(pObj.getPatchID())) continue;
                    filteredSet.add(pObj.getPatchID());
                    resObj = PrereqAPI.checkActiveFilesAndExecutables(oracleHomePath, pObj);
                    resultsArray.add(resObj);
                    PQSession.printTheResult(resObj, "\"checkActiveFilesAndExecutables\" for patch " + pObj.getPatchID());
                }
                catch (Exception e4) {
                    resObj = PQSession.printNotExecutedAndReturnResObj("checkActiveFilesAndExecutables", true);
                    resultsArray.add(resObj);
                }
            }
        }
        return resultsArray;
    }

    public static void checkifohlockedforpatching(String oracleHomePath) {
        PrereqResult resObj = PrereqAPI.checkIfOHLockedForPatching(oracleHomePath);
        PQSession.printTheResult(resObj, "\"checkIfOHLockedForPatching\"");
    }

    public static ConflictMatrixOutput checkConflictAmongPatchesWithDetail(String oracleHomePath) throws Exception {
        return PQSession.checkConflictAmongPatchesWithDetail(oracleHomePath, null);
    }

    public static ConflictMatrixOutput checkConflictAmongPatchesWithDetail(String oracleHomePath, List<PatchObject> pos) throws Exception {
        ConflictMatrixOutput resObj = null;
        OneOffEntry[] piOneOffs = null;
        String[] patchLocs = null;
        boolean flag = false;
        ArrayList<OneOffEntry> piArr = new ArrayList<OneOffEntry>();
        try {
            if (!PQSession.isBaseDirProvided() && !PQSession.isPatchBaseFileProvided()) {
                String patchLoc = OPatchEnv.getPatchloc();
                PQSession.setBaseDirProvided();
                PQSession.setPatchBaseDir(patchLoc);
                flag = true;
            }
            patchLocs = PQSession.parseBaseDirListFile();
            patchLocs = PQSession.handleCompositeCases(patchLocs, PQSession.getPatchBaseDir());
            if (pos == null) {
                for (int i2 = 0; i2 < patchLocs.length; ++i2) {
                    PatchObject po = PatchObject.getInstance(patchLocs[i2]);
                    piArr.add(po.toOneOffEntry(oracleHomePath));
                }
            } else {
                for (PatchObject po : pos) {
                    piArr.add(po.toOneOffEntry(oracleHomePath));
                }
            }
            if (flag) {
                PQSession.unsetBaseDirProvided();
            }
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
            PrereqResult resObj1 = new PrereqResult();
            resObj1.addDetail("Unable to create Patch Object.\nException occured : " + e2.getMessage());
            PQSession.printTheResult(resObj1, "\"checkConflictAmongPatchesWithDetail\"");
            return null;
        }
        if (piArr.size() == 0) {
            PrereqResult resObj1 = new PrereqResult();
            resObj1.addDetail("No patches specified.");
            PQSession.printTheResult(resObj1, "\"checkConflictAmongPatchesWithDetail\"");
            return null;
        }
        piOneOffs = piArr.toArray(new OneOffEntry[piArr.size()]);
        resObj = PrereqAPI.checkConflictAmongPatchesWithDetail(oracleHomePath, piOneOffs);
        return resObj;
    }

    public static void checkconflictamongpatcheswithdetail(String oracleHomePath) throws Exception {
        ConflictMatrixOutput resObj = null;
        resObj = PQSession.checkConflictAmongPatchesWithDetail(oracleHomePath);
        if (resObj != null) {
            PQSession.printTheResult(resObj, "\"checkConflictAmongPatchesWithDetail\"");
        }
    }

    public static void checkconflictagainstohwithdetail(String oracleHomePath) throws Exception {
        PrereqResult prereqResult = PQSession.checkConflictAgainstOHWithDetailAndPrint(oracleHomePath);
    }

    public static void checkcentralinventoryforoh(String oracleHomePath) {
        PrereqResult resObj = PrereqAPI.checkCentralInventoryForOH(oracleHomePath);
        PQSession.printTheResult(resObj, "\"checkCentralInventoryForOH\"");
    }

    public static PrereqResult checkConflictAgainstOHWithDetailAndPrint(String oracleHomePath) throws Exception {
        return PQSession.checkConflictAgainstOHWithDetailAndPrint(oracleHomePath, null);
    }

    public static PrereqResult checkConflictAgainstOHWithDetailAndPrint(String oracleHomePath, List<PatchObject> pos) throws Exception {
        ConflictMatrixOutput resObj = null;
        OneOffEntry[] piOneOffs = null;
        String[] patchLocs = null;
        boolean flag = false;
        ArrayList<OneOffEntry> piArr = new ArrayList<OneOffEntry>();
        try {
            if (!PQSession.isBaseDirProvided() && !PQSession.isPatchBaseFileProvided()) {
                String patchLoc = OPatchEnv.getPatchloc();
                PQSession.setBaseDirProvided();
                PQSession.setPatchBaseDir(patchLoc);
                flag = true;
            }
            patchLocs = PQSession.parseBaseDirListFile();
            patchLocs = PQSession.handleCompositeCases(patchLocs, PQSession.getPatchBaseDir());
            if (pos == null) {
                for (int i2 = 0; i2 < patchLocs.length; ++i2) {
                    PatchObject po = PatchObject.getInstance(patchLocs[i2]);
                    piArr.add(po.toOneOffEntry(oracleHomePath));
                }
            } else {
                for (PatchObject po : pos) {
                    piArr.add(po.toOneOffEntry(oracleHomePath));
                }
            }
            if (flag) {
                PQSession.unsetBaseDirProvided();
            }
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
            PrereqResult resObj1 = new PrereqResult();
            resObj1.addDetail("Unable to create Patch Object.\nException occured : " + e2.getMessage());
            PQSession.printTheResult(resObj1, "\"checkConflictAgainstOHWithDetail\"");
            return resObj1;
        }
        if (piArr.size() == 0) {
            PrereqResult resObj1 = new PrereqResult();
            resObj1.addDetail("No patches specified.");
            PQSession.printTheResult(resObj1, "\"checkConflictAgainstOHWithDetail\"");
            return resObj1;
        }
        piOneOffs = piArr.toArray(new OneOffEntry[piArr.size()]);
        resObj = PrereqAPI.checkConflictAgainstOHWithDetail(oracleHomePath, piOneOffs);
        PQSession.printTheResult(resObj, "\"checkConflictAgainstOHWithDetail\"");
        return resObj == null ? new PrereqResult() : resObj;
    }

    public static void checkcentralinventoryforrwsession(String oracleHomePath) {
        PrereqResult resObj = PrereqAPI.checkCentralInventoryForRWSession(oracleHomePath);
        PQSession.printTheResult(resObj, "\"checkCentralInventoryForRWSession\"");
    }

    public static void checkrequiredlibs(String oracleHomePath) {
        PrereqResult resObj = PQSession.checkRequiredLibsAndPrint(oracleHomePath);
    }

    public static PrereqResult checkRequiredLibsAndPrint(String oracleHomePath) {
        String[] libs = PrereqResource.reqdLibs;
        PrereqResult resObj1 = PrereqAPI.checkRequiredLibs(oracleHomePath, libs);
        PQSession.printTheResult(resObj1, "\"checkRequiredLibs\"");
        if (OPatchEnv.isNextGen()) {
            OLogger.println("WARNING: [deprecation] The current behavior is to show \"Passed\" without checking");
        } else {
            String[] opLibs = PrereqResource.optionalLibs;
            PrereqResult resObj2 = PrereqAPI.checkRequiredLibs(oracleHomePath, opLibs);
            if (resObj2.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                OLogger.println("WARNING: Prereq related jar \"OraPrereq.jar\" is not found.");
                OLogger.println("So, OPatch Prereqs cannot be invoked from OUI Prereq Checker.");
            }
        }
        return resObj1;
    }

    public static void checksystemspace(String oracleHomePath) throws Exception {
        PrereqResult resObj = PQSession.checkSystemSpaceAndPrint(oracleHomePath);
    }

    public static PrereqResult checkSystemSpaceAndPrint(String oracleHomePath) throws Exception {
        return PQSession.checkSystemSpaceAndPrint(oracleHomePath, null);
    }

    public static PrereqResult checkSystemSpaceAndPrint(String oracleHomePath, List<PatchObject> pos) throws Exception {
        if (PQSession.isBaseDirProvided() || PQSession.isPatchBaseFileProvided()) {
            String[] patchLocs = null;
            try {
                patchLocs = PQSession.parseBaseDirListFile();
                patchLocs = PQSession.handleCompositeCases(patchLocs, PQSession.getPatchBaseDir());
            }
            catch (Exception e2) {
                OLogger.println("\nPrereq \"checkSystemSpace\" no executed.");
                OLogger.printStackTrace(e2);
                throw e2;
            }
            try {
                ArrayList<String> filteredSet = new ArrayList<String>();
                ArrayList<PatchObject> pObjsList = new ArrayList<PatchObject>();
                if (pos == null) {
                    for (int i2 = 0; i2 < patchLocs.length; ++i2) {
                        PatchObject pObj = PatchObject.getInstance(patchLocs[i2]);
                        if (filteredSet.contains(pObj.getPatchID())) continue;
                        filteredSet.add(pObj.getPatchID());
                        pObjsList.add(pObj);
                    }
                } else {
                    for (PatchObject pObj : pos) {
                        if (filteredSet.contains(pObj.getPatchID())) continue;
                        filteredSet.add(pObj.getPatchID());
                        pObjsList.add(pObj);
                    }
                }
                OneOffEntry[] oneOffEntries = new OneOffEntry[pObjsList.size()];
                for (int i3 = 0; i3 < pObjsList.size(); ++i3) {
                    OneOffEntry oneOff;
                    PatchObject pObj = (PatchObject)pObjsList.get(i3);
                    oneOffEntries[i3] = oneOff = pObj.toOneOffEntry(oracleHomePath);
                }
                PrereqResult resObj = PrereqAPI.checkSystemSpace(oracleHomePath, oneOffEntries, patchLocs);
                PQSession.printTheResult(resObj, "\"checkSystemSpace\"");
                return resObj;
            }
            catch (Exception e3) {
                return PQSession.printNotExecutedAndReturnResObj("checkSystemSpace", true);
            }
        }
        String[] patchLocation = new String[]{OPatchEnv.getPatchloc()};
        if (patchLocation[0].equals("") || patchLocation[0] == null) {
            return PQSession.printNotExecutedAndReturnResObj("checkSystemSpace", true);
        }
        try {
            PrereqResult resObj = null;
            if (PQSession.isComposite(patchLocation[0])) {
                OneOffEntry[] oneOffEntries = null;
                PQSession.setBaseDirProvided();
                PQSession.setPatchBaseDir(patchLocation[0]);
                String[] patchLocs = PQSession.parseBaseDirListFile();
                oneOffEntries = new OneOffEntry[patchLocs.length];
                for (int i4 = 0; i4 < patchLocs.length; ++i4) {
                    PatchObject po = PatchObject.getInstance(patchLocs[i4]);
                    oneOffEntries[i4] = po.toOneOffEntry(oracleHomePath);
                }
                resObj = PrereqAPI.checkSystemSpace(oracleHomePath, oneOffEntries, patchLocs);
            } else {
                PatchObject pObj = PatchObject.getInstance(patchLocation[0]);
                OneOffEntry[] oneOff = new OneOffEntry[]{pObj.toOneOffEntry(oracleHomePath)};
                resObj = PrereqAPI.checkSystemSpace(oracleHomePath, oneOff, patchLocation);
            }
            PQSession.printTheResult(resObj, "\"checkSystemSpace\"");
            return resObj;
        }
        catch (Exception e4) {
            return PQSession.printNotExecutedAndReturnResObj("checkSystemSpace", true);
        }
    }

    public static void checkracnodelist(String oracleHomePath) {
        PrereqResult resObj = PrereqAPI.checkRACNodeList(oracleHomePath);
        PQSession.printTheResult(resObj, "\"checkRACNodeList\"");
    }

    public static void checkforcrshomeifrac(String oracleHomePath) {
        PrereqResult resObj = PrereqAPI.checkForCRSHomeIfRAC(oracleHomePath);
        PQSession.printTheResult(resObj, "\"checkForCRSHomeIfRAC\"");
    }

    public static void checkremotecopyandremove(String oracleHomePath) {
        PrereqResult resObj = PrereqAPI.checkRemoteCopyAndRemove(oracleHomePath);
        PQSession.printTheResult(resObj, "\"checkRemoteCopyAndRemove\"");
    }

    public static void checkremotecommandinvocable(String oracleHomePath) {
        PrereqResult resObj = PrereqAPI.checkRemoteCommandInvocable(oracleHomePath);
        PQSession.printTheResult(resObj, "\"checkRemoteCommandInvocable\"");
    }

    public static void checkpatchapplydependents(String oracleHomePath) {
        ArrayList resultsArray = PQSession.checkPatchApplyDependentsAndPrint(oracleHomePath);
    }

    public static ArrayList checkPatchApplyDependentsAndPrint(String oracleHomePath) {
        return PQSession.checkPatchApplyDependentsAndPrint(oracleHomePath, null);
    }

    public static ArrayList checkPatchApplyDependentsAndPrint(String oracleHomePath, List<PatchObject> pos) {
        String patchLocation = OPatchEnv.getPatchloc();
        String[] patchLocs = null;
        ArrayList<PrereqResult> resultsArray = new ArrayList<PrereqResult>();
        if (PQSession.isBaseDirProvided() || PQSession.isPatchBaseFileProvided()) {
            try {
                patchLocs = PQSession.parseBaseDirListFile();
                patchLocs = PQSession.handleCompositeCases(patchLocs, PQSession.getPatchBaseDir());
            }
            catch (FileNotFoundException e2) {
                OLogger.println("File not found: " + PQSession.getPatchBaseFile());
                PrereqResult resObj = PQSession.printNotExecutedAndReturnResObj("checkPatchApplyDependents", false);
                OLogger.printStackTrace(e2);
                return new ArrayList<PrereqResult>(Arrays.asList(resObj));
            }
            catch (IOException e3) {
                OLogger.println("IOException occured: " + e3.getMessage());
                PrereqResult resObj = PQSession.printNotExecutedAndReturnResObj("checkPatchApplyDependents", false);
                OLogger.printStackTrace(e3);
                return new ArrayList<PrereqResult>(Arrays.asList(resObj));
            }
            catch (OPatchException e4) {
                OLogger.println("OPatchException occured: " + e4.getMessage());
                PrereqResult resObj = PQSession.printNotExecutedAndReturnResObj("checkPatchApplyDependents", false);
                OLogger.printStackTrace(e4);
                return new ArrayList<PrereqResult>(Arrays.asList(resObj));
            }
        } else if (patchLocation != null && !patchLocation.equals("")) {
            patchLocs = new String[]{patchLocation};
            try {
                patchLocs = PQSession.handleCompositeCases(patchLocs, PQSession.getPatchBaseDir());
            }
            catch (FileNotFoundException e5) {
                OLogger.println("File not found: " + PQSession.getPatchBaseFile());
                PrereqResult resObj = PQSession.printNotExecutedAndReturnResObj("checkPatchApplyDependents", false);
                return new ArrayList<PrereqResult>(Arrays.asList(resObj));
            }
            catch (IOException e6) {
                OLogger.println("IOException occured: " + e6.getMessage());
                PrereqResult resObj = PQSession.printNotExecutedAndReturnResObj("checkPatchApplyDependents", false);
                resObj.addDetail("IOException occured: " + e6.getMessage());
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                OLogger.printStackTrace(e6);
                return new ArrayList<PrereqResult>(Arrays.asList(resObj));
            }
        } else {
            OLogger.println("\nPrereq \"checkPatchApplyDependents\" not executed.");
            PrereqResult resObj = PQSession.printNotExecutedAndReturnResObj("checkPatchApplyDependents", true);
            return new ArrayList<PrereqResult>(Arrays.asList(resObj));
        }
        PatchObject[] pObjs = new PatchObject[patchLocs.length];
        if (pos != null) {
            pObjs = pos.toArray(new PatchObject[patchLocs.length]);
        } else {
            for (int i2 = 0; i2 < patchLocs.length; ++i2) {
                try {
                    pObjs[i2] = PatchObject.getInstance(patchLocs[i2]);
                    continue;
                }
                catch (Exception e7) {
                    OLogger.println("Prereq \"checkPatchApplyDependents\" not executed");
                    OLogger.println("Unable to create Patch Object.\nException occured : " + e7.getMessage());
                }
            }
        }
        try {
            OPatchSessionHelper.getWlsPatchProfile(pObjs);
        }
        catch (RuntimeException e8) {
            OLogger.printStackTrace(e8);
            PrereqResult resObj = PQSession.printNotExecutedAndReturnResObj("checkPatchApplyDependents", false);
            return new ArrayList<PrereqResult>(Arrays.asList(resObj));
        }
        int actualLength = 0;
        ArrayList<String> filteredSet = new ArrayList<String>();
        for (int i3 = 0; i3 < pObjs.length; ++i3) {
            if (filteredSet.contains(pObjs[i3].getPatchID())) continue;
            ++actualLength;
            filteredSet.add(pObjs[i3].getPatchID());
        }
        OneOffEntry[] oneOffs = new OneOffEntry[actualLength];
        int j2 = 0;
        for (int i4 = 0; i4 < pObjs.length && j2 < actualLength; ++i4) {
            if (!filteredSet.contains(pObjs[i4].getPatchID())) continue;
            oneOffs[j2++] = pObjs[i4].toOneOffEntry(oracleHomePath);
            filteredSet.remove(pObjs[i4].getPatchID());
        }
        try {
            PrereqResult resObj = PrereqAPI.checkPatchApplyDependents(oracleHomePath, oneOffs);
            resultsArray.add(resObj);
            StringBuffer resultMsg = new StringBuffer("\"checkPatchApplyDependents\" for patch ");
            for (int i5 = 0; i5 < actualLength; ++i5) {
                resultMsg.append(oneOffs[i5].getPatchID());
                if (i5 == actualLength - 1) continue;
                resultMsg.append(",");
            }
            PQSession.printTheResult(resObj, resultMsg.toString());
        }
        catch (Exception e9) {
            PrereqResult resObj = PQSession.printNotExecutedAndReturnResObj("checkPatchApplyDependents", true);
            resultsArray.add(resObj);
        }
        return resultsArray;
    }

    public static void checkpatchrollbackdependents(String oracleHomePath) {
        ArrayList resultsArray = PQSession.checkPatchRollbackDependentsAndPrint(oracleHomePath);
    }

    public static ArrayList checkPatchRollbackDependentsAndPrint(String oracleHomePath) {
        String[] patchs = null;
        ArrayList<PrereqResult> resultsArray = new ArrayList<PrereqResult>();
        if (OPatchEnv.isUserSuppliedPatchIDs()) {
            patchs = OPatchEnv.getUserSuppliedPatchIDs();
        } else {
            patchs = new String[]{OPatchEnv.getRollbackPatchid()};
            if (patchs[0] == null || patchs[0].equalsIgnoreCase("")) {
                PrereqResult resObj = PQSession.printNotExecutedAndReturnResObjPatchID("checkPatchRollbackDependents");
                return new ArrayList<PrereqResult>(Arrays.asList(resObj));
            }
        }
        StringBuffer prereqs = new StringBuffer();
        for (String prereqid : patchs) {
            prereqs.append(prereqid + ",");
        }
        String prereqids = prereqs.substring(0, prereqs.length() - 1);
        try {
            PrereqResult resObj = PrereqAPI.checkPatchRollbackDependents(oracleHomePath, patchs);
            resultsArray.add(resObj);
            PQSession.printTheResult(resObj, "\"checkPatchRollbackDependents\" for patch " + prereqids);
        }
        catch (Exception e2) {
            OLogger.println("Prereq \"checkPatchRollbackDependents\" not executed");
            OLogger.println("Unable to create Patch Object.\nException occured : " + e2.getMessage());
            OLogger.printStackTrace(e2);
        }
        return resultsArray;
    }

    public static void checkinstalledoneoffs(String oracleHomePath) {
        PrereqResult resObj = PQSession.checkInstalledOneOffsAndPrint(oracleHomePath);
    }

    public static PrereqResult checkInstalledOneOffsAndPrint(String oracleHomePath) {
        String[] patchs = null;
        if (OPatchEnv.isUserSuppliedPatchIDs()) {
            patchs = OPatchEnv.getUserSuppliedPatchIDs();
        } else {
            patchs = new String[]{OPatchEnv.getRollbackPatchid()};
            if (patchs[0] == null || patchs[0].equals("")) {
                PrereqResult resObj = PQSession.printNotExecutedAndReturnResObjPatchID("checkInstalledOneOffs");
                return resObj;
            }
        }
        Vector installedPatchIDs = new Vector();
        Vector notInstalledPatchIDs = new Vector();
        PrereqResult resObj = PrereqAPI.checkInstalledOneOffs(oracleHomePath, patchs, installedPatchIDs, notInstalledPatchIDs);
        PQSession.printTheResult(resObj, "\"checkInstalledOneOffs\"");
        return resObj == null ? new PrereqResult() : resObj;
    }

    public static void checkforinputvalues(String oracleHomePath) throws Exception {
        PQSession.checkForInputValuesAndPrint(oracleHomePath);
    }

    public static PrereqResult checkForInputValuesAndPrint(String oracleHomePath) throws Exception {
        return PQSession.checkForInputValuesAndPrint(oracleHomePath, null);
    }

    public static PrereqResult checkForInputValuesAndPrint(String oracleHomePath, List<PatchObject> pos) throws Exception {
        PrereqResult pRes;
        Vector installedPatchIDs;
        Vector notInstalledPatchIDs;
        PrereqResult resObj = null;
        String[] patchLocs = null;
        String patchLocation = OPatchEnv.getPatchloc();
        String[] patchID = new String[]{OPatchEnv.getRollbackPatchid()};
        Vector inPatchIDs = new Vector();
        boolean inSystem = false;
        PrereqResult prereqResult = PrereqAPI.checkIfSupportCasDirectlyPatching(oracleHomePath);
        if (prereqResult.getResult() == PrereqResult.ExecuteStatus.FAILED) {
            PQSession.printTheResult(prereqResult, "\"checkForInputValues\"");
            return prereqResult;
        }
        if (PQSession.isBaseDirProvided() || PQSession.isPatchBaseFileProvided()) {
            try {
                patchLocs = PQSession.parseBaseDirListFile();
                patchLocs = PQSession.handleCompositeCases(patchLocs, PQSession.getPatchBaseDir());
            }
            catch (Exception e2) {
                OLogger.println("\nPrereq \"checkForInputValues\" not executed.");
                throw e2;
            }
        } else if (OPatchEnv.isUserSuppliedPatchIDs()) {
            notInstalledPatchIDs = new Vector();
            installedPatchIDs = new Vector();
            pRes = PrereqAPI.checkInstalledOneOffs(oracleHomePath, OPatchEnv.getUserSuppliedPatchIDs(), installedPatchIDs, notInstalledPatchIDs);
            if (pRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                if (installedPatchIDs.size() == 0) {
                    OLogger.println("None of the given patches are present in the Oracle Home.");
                    return pRes;
                }
                StringBuffer tbuf = new StringBuffer("Following patches are not installed and are skipped:\n");
                tbuf.append(notInstalledPatchIDs.toString());
                OLogger.println(tbuf.toString());
            } else if (pRes.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED) {
                PQSession.printTheResult(pRes, "\"checkForInputValues\"");
            }
            patchLocs = new String[installedPatchIDs.size()];
            for (int i2 = 0; i2 < installedPatchIDs.size(); ++i2) {
                patchLocs[i2] = OPatchEnv.getPatchFilemapInfoLoc(oracleHomePath, (String)installedPatchIDs.elementAt(i2));
            }
            inPatchIDs = installedPatchIDs;
            inSystem = true;
        } else if (patchID[0] != null && !patchID[0].equals("")) {
            installedPatchIDs = new Vector();
            notInstalledPatchIDs = new Vector();
            pRes = PrereqAPI.checkInstalledOneOffs(oracleHomePath, patchID, installedPatchIDs, notInstalledPatchIDs);
            if (pRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                OLogger.println("Patch " + notInstalledPatchIDs.elementAt(0) + " is not present in the Oracle Home.");
                return pRes;
            }
            if (pRes.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED) {
                PQSession.printTheResult(pRes, "\"checkForInputValues\"");
            }
            patchLocs = new String[]{OPatchEnv.getPatchFilemapInfoLoc(oracleHomePath, (String)installedPatchIDs.elementAt(0))};
            inPatchIDs = installedPatchIDs;
            inSystem = true;
        } else if (patchLocation != null && !patchLocation.equals("")) {
            patchLocs = new String[]{patchLocation};
            patchLocs = PQSession.handleCompositeCases(patchLocs, PQSession.getPatchBaseDir());
        } else {
            return PQSession.printNotExecutedAndReturnResObj("checkForInputValues", true);
        }
        if (patchLocs.length == 0) {
            return PQSession.printNotExecutedAndReturnResObj("checkForInputValues", true);
        }
        if (patchLocs == null || patchLocs.length == 0) {
            return PQSession.printNotExecutedAndReturnResObj("checkForInputValues", true);
        }
        ArrayList<OneOffEntry> oneOffsList = new ArrayList<OneOffEntry>();
        if (pos == null) {
            for (int i3 = 0; i3 < patchLocs.length; ++i3) {
                ArrayList<String> filteredSet = new ArrayList<String>();
                try {
                    PatchObject pObj = null;
                    pObj = !inSystem ? PatchObject.getInstance(patchLocs[i3]) : PatchObject.getInstance(oracleHomePath, (String)inPatchIDs.elementAt(i3));
                    if (filteredSet.contains(pObj.getPatchID())) continue;
                    filteredSet.add(pObj.getPatchID());
                    oneOffsList.add(pObj.toOneOffEntry(oracleHomePath));
                    continue;
                }
                catch (Exception e3) {
                    OLogger.println("\nPrereq \"checkForInputValues\" not executed");
                    OLogger.println("Unable to create Patch Object.\nException occured:\n" + e3.getMessage());
                    OLogger.printStackTrace(e3);
                }
            }
        } else {
            for (PatchObject pObj : pos) {
                ArrayList<String> filteredSet = new ArrayList<String>();
                try {
                    if (filteredSet.contains(pObj.getPatchID())) continue;
                    filteredSet.add(pObj.getPatchID());
                    oneOffsList.add(pObj.toOneOffEntry(oracleHomePath));
                }
                catch (Exception e4) {
                    OLogger.println("\nPrereq \"checkForInputValues\" not executed");
                    OLogger.println("Unable to create Patch Object.\nException occured:\n" + e4.getMessage());
                    OLogger.printStackTrace(e4);
                }
            }
        }
        OneOffEntry[] oneoffs = new OneOffEntry[oneOffsList.size()];
        oneOffsList.toArray(oneoffs);
        resObj = PrereqAPI.checkForInputValues(oracleHomePath, oneoffs);
        PQSession.printTheResult(resObj, "\"checkForInputValues\"");
        return resObj;
    }

    public static PrereqResult checkConflictWithPatchsetUpdateAndPrint(String oracleHomePath) throws Exception {
        return PQSession.checkConflictWithPatchsetUpdateAndPrint(oracleHomePath, null);
    }

    public static PrereqResult checkConflictWithPatchsetUpdateAndPrint(String oracleHomePath, List<PatchObject> pos) throws Exception {
        String patchLocation = OPatchEnv.getPatchloc();
        String[] patchLocs = null;
        if (PQSession.isBaseDirProvided() || PQSession.isPatchBaseFileProvided()) {
            try {
                patchLocs = PQSession.parseBaseDirListFile();
                patchLocs = PQSession.handleCompositeCases(patchLocs, PQSession.getPatchBaseDir());
            }
            catch (FileNotFoundException e2) {
                OLogger.println("File not found: " + PQSession.getPatchBaseFile());
                return PQSession.printNotExecutedAndReturnResObj("checkConFilctWithPatchsetUpdate", false);
            }
            catch (IOException e3) {
                OLogger.println("IOException occured: " + e3.getMessage());
                OLogger.printStackTrace(e3);
                return PQSession.printNotExecutedAndReturnResObj("checkConFilctWithPatchsetUpdate", false);
            }
            catch (OPatchException e4) {
                OLogger.println("OPatchException occured: " + e4.getMessage());
                OLogger.printStackTrace(e4);
                return PQSession.printNotExecutedAndReturnResObj("checkConFilctWithPatchsetUpdate", false);
            }
        } else if (patchLocation != null && !patchLocation.equals("")) {
            patchLocs = new String[]{patchLocation};
            try {
                patchLocs = PQSession.handleCompositeCases(patchLocs, PQSession.getPatchBaseDir());
            }
            catch (FileNotFoundException e5) {
                OLogger.println("File not found: " + PQSession.getPatchBaseFile());
                return PQSession.printNotExecutedAndReturnResObj("checkConFilctWithPatchsetUpdate", false);
            }
            catch (IOException e6) {
                OLogger.println("IOException occured: " + e6.getMessage());
                OLogger.printStackTrace(e6);
                return PQSession.printNotExecutedAndReturnResObj("checkConFilctWithPatchsetUpdates", false);
            }
        } else {
            return PQSession.printNotExecutedAndReturnResObj("checkConFilctWithPatchsetUpdate", true);
        }
        ArrayList<OneOffEntry> oneOffsList = new ArrayList<OneOffEntry>();
        if (pos == null) {
            for (int i2 = 0; i2 < patchLocs.length; ++i2) {
                ArrayList<String> filteredSet = new ArrayList<String>();
                try {
                    PatchObject pObj = null;
                    pObj = PatchObject.getInstance(patchLocs[i2]);
                    if (filteredSet.contains(pObj.getPatchID())) continue;
                    filteredSet.add(pObj.getPatchID());
                    oneOffsList.add(pObj.toOneOffEntry(oracleHomePath));
                    continue;
                }
                catch (Exception e7) {
                    OLogger.println("\nPrereq \"checkConflictPatchSetUpdate\" not executed");
                    OLogger.println("Unable to create Patch Object. Check if the given patch location \"" + patchLocs[i2] + "\"is correct.");
                    OLogger.printStackTrace(e7);
                }
            }
        } else {
            for (PatchObject pObj : pos) {
                ArrayList<String> filteredSet = new ArrayList<String>();
                try {
                    if (filteredSet.contains(pObj.getPatchID())) continue;
                    filteredSet.add(pObj.getPatchID());
                    oneOffsList.add(pObj.toOneOffEntry(oracleHomePath));
                }
                catch (Exception e8) {
                    OLogger.println("\nPrereq \"checkConflictPatchSetUpdate\" not executed");
                    OLogger.println("Unable to create Patch Object.\nException occured:\n" + e8.getMessage());
                    OLogger.printStackTrace(e8);
                }
            }
        }
        OneOffEntry[] oneoffs = new OneOffEntry[oneOffsList.size()];
        oneOffsList.toArray(oneoffs);
        PatchObject[] apPatchObjects = OPatchUtilHelper.getPatchesToApply(oracleHomePath, oneoffs, "NApply");
        return PrereqAPI.checkConflictWithPatchsetUpdate(oracleHomePath, apPatchObjects, OPatchEnv.getSessionType());
    }

    public static void checkdbinstanceup(String oracleHomePath) {
        PrereqResult resObj = PrereqAPI.checkDBInstanceUp(oracleHomePath, true);
        PQSession.printTheResult(resObj, "\"checkDBInstanceUp\"");
    }

    public static PrereqResult checkdbinstanceupAndPrint(String oracleHomePath) {
        PrereqResult resObj = PrereqAPI.checkDBInstanceUp(oracleHomePath, true);
        PQSession.printTheResult(resObj, "\"checkDBInstanceUp\"");
        return resObj;
    }

    public static void runall(String oracleHomePath) throws Exception {
        PQSession.checkapplicable(oracleHomePath);
        PQSession.checkcentralinventoryforoh(oracleHomePath);
        PQSession.checkcentralinventorylocation(oracleHomePath);
        PQSession.checkconflictagainstoh(oracleHomePath);
        PQSession.checkconflictagainstohwithdetail(oracleHomePath);
        PQSession.checkconflictamongpatches(oracleHomePath);
        PQSession.checkconflictamongpatcheswithdetail(oracleHomePath);
        PQSession.checkactivefilesandexecutables(oracleHomePath);
        PQSession.checkifohlockedforpatching(oracleHomePath);
        PQSession.checkjdk(oracleHomePath);
        PQSession.checkoraclehome(oracleHomePath);
        PQSession.checkorainstlocation(oracleHomePath);
        PQSession.checkouilocation(oracleHomePath);
        PQSession.checkouiversioncompatible(oracleHomePath);
        PQSession.checkopatchcompatibleagainstoh(oracleHomePath);
        PQSession.checkpatchapplicableoncurrentplatform(oracleHomePath);
        PQSession.checkpatchshiphome(oracleHomePath);
        PQSession.checkrequiredlibs(oracleHomePath);
        PQSession.checkrollbackable(oracleHomePath);
        PQSession.checksystemcommandavailable(oracleHomePath);
        PQSession.checksystemspace(oracleHomePath);
        PQSession.checkuseradminprivilege(oracleHomePath);
        PQSession.checkracnodelist(oracleHomePath);
        PQSession.checkremotecommandinvocable(oracleHomePath);
        PQSession.checkremotecopyandremove(oracleHomePath);
    }

    private static void checkopatchcompatibleagainstoh(String oracleHomePath) {
    }

    protected static boolean isValidPatchLoc(String loc) {
        if (OPatchSessionHelper.checkIsEsysPatch(loc)) {
            return true;
        }
        boolean hasEtc = false;
        boolean hasFile = false;
        Path f2 = WrapperFactory.getNioServiceWrapper().getPath(loc, new String[0]);
        if (f2 != null && Files.exists(f2, new LinkOption[0]) && !Files.isDirectory(f2, new LinkOption[0])) {
            return false;
        }
        try (DirectoryStream<Path> streams = Files.newDirectoryStream(f2);){
            for (Path stream : streams) {
                String entry = stream.getFileName().toString();
                if (entry.indexOf("etc") != -1) {
                    hasEtc = true;
                    continue;
                }
                if (entry.indexOf("files") == -1) continue;
                hasFile = true;
            }
        }
        catch (IOException e2) {
            OLogger.debug(e2.getMessage());
        }
        return hasEtc && hasFile;
    }

    public static boolean checkEsysForPrereq() {
        String patchLoc = null;
        String[] patchLocs = null;
        if (OPatchEnv.getPatchloc() != "") {
            patchLoc = OPatchEnv.getPatchloc();
            return OPatchSessionHelper.checkIsEsysPatch(patchLoc);
        }
        if (PQSession.getPatchBaseDir() != null || PQSession.getPatchBaseFile() != null) {
            try {
                patchLocs = PQSession.parseBaseDirListFile();
            }
            catch (Exception e2) {
                OLogger.println("Unable to parse base dir or base file.");
                OLogger.printStackTrace(e2);
                return false;
            }
            for (String p2 : patchLocs) {
                if (!OPatchSessionHelper.checkIsEsysPatch(p2)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String[] parseBaseDirListFile() throws FileNotFoundException, IOException, RuntimeException {
        String[] patchLocs = null;
        Object[] tmpPatchLocs = null;
        boolean isBaseDirZipFile = false;
        if (!PQSession.isBaseDirProvided()) {
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(PQSession.getPatchBaseFile());
                if (null != zipFile) {
                    StringBuffer tBuff = new StringBuffer("The location \"");
                    tBuff.append(PQSession.getPatchBaseFile());
                    tBuff.append("\" is not a valid patch base file. ");
                    OLogger.println(tBuff.toString());
                    RuntimeException re = new RuntimeException("Invalid patch base location.");
                    throw re;
                }
            }
            catch (IOException tBuff) {
                // empty catch block
            }
            try {
                Path patchFile = WrapperFactory.getNioServiceWrapper().getPath(PQSession.getPatchBaseFile(), new String[0]);
                BufferedReader br = Files.newBufferedReader(patchFile, Charset.forName("UTF-8"));
                ArrayList<String> al = new ArrayList<String>();
                String line = br.readLine();
                while (line != null) {
                    if (!al.contains(line = line.trim()) && !line.equals("")) {
                        Path pDir = WrapperFactory.getNioServiceWrapper().getPath(line, new String[0]);
                        if (!Files.isDirectory(pDir, new LinkOption[0])) {
                            if (!line.endsWith(".zip")) {
                                StringBuffer tBuff = new StringBuffer("The location \"");
                                tBuff.append(line);
                                tBuff.append("\" is not a directory or a valid patch zip file. ");
                                OLogger.println(tBuff.toString());
                                RuntimeException re = new RuntimeException("Invalid patch location.");
                                throw re;
                            }
                            String extractLoc = OPatchEnv.getPatchUnzipLocation();
                            String topLevelDir = ZipUtilities.unzip(line, extractLoc);
                            String fullPath = extractLoc + File.separator + topLevelDir;
                            pDir = WrapperFactory.getNioServiceWrapper().getPath(fullPath, new String[0]);
                            if (!Files.exists(pDir, new LinkOption[0]) || !Files.isDirectory(pDir, new LinkOption[0])) {
                                StringBuffer tBuff = new StringBuffer("The location \"");
                                tBuff.append(line);
                                tBuff.append("\" is not a valid patch zip file. Its extraction ");
                                tBuff.append("did not create a directory.");
                                OLogger.println(tBuff.toString());
                                RuntimeException re = new RuntimeException(tBuff.toString());
                                throw re;
                            }
                            line = fullPath;
                        }
                        String loc = pDir.toAbsolutePath().toString();
                        boolean isValidPatchLoc = PQSession.isValidPatchLoc(loc);
                        boolean isComposite = PQSession.isComposite(loc);
                        if (isValidPatchLoc || isComposite) {
                            al.add(line);
                        } else {
                            DirectoryStream<Path> subDirs = null;
                            try {
                                subDirs = Files.newDirectoryStream(pDir);
                            }
                            catch (IOException e2) {
                                OLogger.debug(e2.getMessage());
                            }
                            for (Path subDir : subDirs) {
                                if (!Files.isDirectory(subDir, new LinkOption[0])) continue;
                                al.add(subDir.toString());
                            }
                        }
                    }
                    if (null == (line = br.readLine())) continue;
                    line = line.trim();
                }
                patchLocs = new String[al.size()];
                al.toArray(patchLocs);
                br.close();
            }
            catch (FileNotFoundException e3) {
                throw e3;
            }
            catch (IOException e4) {
                throw e4;
            }
        }
        String phBaseDir = PQSession.getPatchBaseDir();
        Path patchDir = WrapperFactory.getNioServiceWrapper().getPath(phBaseDir, new String[0]);
        if (!Files.isDirectory(patchDir, new LinkOption[0])) {
            if (!phBaseDir.endsWith(".zip")) {
                OLogger.println("The patch base location should be a directory or a zip file.");
                RuntimeException re = new RuntimeException("Invalid patch zip file.");
                throw re;
            }
            String extractLoc = OPatchEnv.getPatchUnzipLocation();
            isBaseDirZipFile = true;
            String topLevelDir = ZipUtilities.unzip(phBaseDir, extractLoc);
            String fullPath = extractLoc + File.separator + topLevelDir;
            patchDir = WrapperFactory.getNioServiceWrapper().getPath(fullPath, new String[0]);
            if (!Files.exists(patchDir, new LinkOption[0]) || !Files.isDirectory(patchDir, new LinkOption[0])) {
                RuntimeException re = new RuntimeException("Could not extract the given zip file");
                throw re;
            }
            patchBaseDir = fullPath;
            phBaseDir = fullPath;
        } else {
            String loc = patchDir.toAbsolutePath().toString();
            boolean isValidPatchLoc = PQSession.isValidPatchLoc(loc);
            if (isValidPatchLoc) {
                String[] singlePatch = new String[]{loc};
                OnlinePatchProcessor.handleOnlinePatch(singlePatch);
                return singlePatch;
            }
        }
        ArrayList<Object> al = new ArrayList<Object>();
        if (PQSession.isValidPatchLoc(phBaseDir)) {
            tmpPatchLocs = new String[]{};
            al.add(phBaseDir);
        } else {
            try (DirectoryStream<Path> streams = Files.newDirectoryStream(patchDir);){
                ArrayList<String> list = new ArrayList<String>();
                for (Path stream : streams) {
                    String entry = stream.toString();
                    list.add(entry);
                }
                tmpPatchLocs = new String[list.size()];
                list.toArray(tmpPatchLocs);
            }
            catch (IOException e5) {
                OLogger.debug(e5.getMessage());
            }
            Arrays.sort(tmpPatchLocs);
        }
        for (int i2 = 0; i2 < tmpPatchLocs.length; ++i2) {
            StringBuffer tBuff;
            Object pLoc = tmpPatchLocs[i2];
            Path pFile = WrapperFactory.getNioServiceWrapper().getPath((String)pLoc, new String[0]);
            if (!Files.isDirectory(pFile, new LinkOption[0]) && ((String)pLoc).endsWith(".zip")) {
                String fullPath;
                String topLevelDir;
                if (isBaseDirZipFile) {
                    topLevelDir = ZipUtilities.unzip((String)pLoc, phBaseDir);
                    fullPath = phBaseDir + File.separator + topLevelDir;
                } else {
                    String extPath = OPatchEnv.getPatchUnzipLocation();
                    topLevelDir = ZipUtilities.unzip((String)pLoc, extPath);
                    fullPath = extPath + File.separator + topLevelDir;
                }
                pFile = WrapperFactory.getNioServiceWrapper().getPath(fullPath, new String[0]);
                if (!Files.exists(pFile, new LinkOption[0]) || !Files.isDirectory(pFile, new LinkOption[0])) {
                    StringBuffer tBuff2 = new StringBuffer("The location \"");
                    tBuff2.append((String)pLoc);
                    tBuff2.append("\" is not a valid patch zip file. Its extraction ");
                    tBuff2.append("did not create a directory.");
                    OLogger.println(tBuff2.toString());
                    RuntimeException re = new RuntimeException(tBuff2.toString());
                    throw re;
                }
                al.add(fullPath);
                continue;
            }
            if (Files.isDirectory(pFile, new LinkOption[0])) {
                al.add(pLoc);
                continue;
            }
            if (!Files.isRegularFile(pFile, new LinkOption[0])) {
                tBuff = new StringBuffer("The location \"");
                tBuff.append((String)pLoc);
                tBuff.append("\" is not a directory or a valid patch zip file. ");
                OLogger.println(tBuff.toString());
                RuntimeException re = new RuntimeException("Invalid patch location.");
                throw re;
            }
            tBuff = new StringBuffer("Ignoring file \"");
            tBuff.append((String)pLoc);
            tBuff.append("\" in the patch directory. ");
            OLogger.printlnOnLog(tBuff.toString());
        }
        patchLocs = new String[al.size()];
        al.toArray(patchLocs);
        OnlinePatchProcessor.handleOnlinePatch(patchLocs);
        return patchLocs;
    }

    public static void phbasedir(String arg) {
        OLogger.debug(new StringBuffer("PQSession::phBaseDir()"));
        Path fDir = WrapperFactory.getNioServiceWrapper().getPath(arg, new String[0]);
        if (!arg.isEmpty() && Files.exists(fDir, new LinkOption[0])) {
            patchBaseDir = arg;
            baseDir = true;
        } else {
            OLogger.println("The argument \"" + arg + "\" does not exists.\n");
            try {
                OPatchACL.setArgumentError(new PQSession(), "Patch base location is not valid.");
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public static void phbasefile(String arg) {
        OLogger.debug(new StringBuffer("PQSession::phBaseFile()"));
        Path fFile = WrapperFactory.getNioServiceWrapper().getPath(arg, new String[0]);
        if (!arg.isEmpty() && Files.exists(fFile, new LinkOption[0]) && Files.isReadable(fFile)) {
            patchBaseFile = arg;
            phBaseFile = true;
        } else {
            OLogger.println("The argument \"" + arg + "\" does not exists or is not readable.\n");
            try {
                OPatchACL.setArgumentError(new PQSession(), "Patch base file is not valid.");
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public static PrereqResult checklanguage(String oracleHomePath) {
        return new PrereqResult();
    }

    public static void unsetPatchHome(Object caller) throws IllegalAccessException {
        if (!(caller instanceof OPatchContext)) {
            throw new IllegalAccessException("Permission denied. Access is available only for OPatchContext.");
        }
        baseDir = false;
        phBaseFile = false;
        patchBaseDir = "";
        patchBaseFile = "";
    }

    public static boolean isComposite(String patchLocation) {
        if (isCompositeMap.get(patchLocation) != null) {
            return isCompositeMap.get(patchLocation);
        }
        try {
            String compositeXmlLoc = CompositePatchObject.validateComposite(patchLocation);
            Path compositeXml = WrapperFactory.getNioServiceWrapper().getPath(compositeXmlLoc, new String[0]);
            if (compositeXml == null || compositeXml.toString().isEmpty()) {
                isCompositeMap.put(patchLocation, false);
                return false;
            }
            isCompositeMap.put(patchLocation, Files.exists(compositeXml, new LinkOption[0]));
            return Files.exists(compositeXml, new LinkOption[0]);
        }
        catch (Exception e2) {
            return false;
        }
    }

    public static boolean isCompositeSubPatch(String patchLocation) {
        try {
            int lastIndex = patchLocation.lastIndexOf(File.separator);
            String compositeLoc = patchLocation.substring(0, lastIndex);
            String compositeXmlLoc = CompositePatchObject.validateComposite(compositeLoc);
            Path compositeXml = WrapperFactory.getNioServiceWrapper().getPath(compositeXmlLoc, new String[0]);
            return compositeXmlLoc != null && !"".equals(compositeXmlLoc.trim()) && Files.exists(compositeXml, new LinkOption[0]);
        }
        catch (Exception e2) {
            return false;
        }
    }

    public static OneOffEntry[] getSubPatches(String patchLocation, String oracleHomePath) throws IllegalAccessException, Exception {
        OneOffEntry[] subPatchEntries = new OneOffEntry[]{};
        String[] patchLocs = new String[]{};
        PatchObject[] pos = new PatchObject[]{};
        PQSession.setBaseDirProvided();
        PQSession.setPatchBaseDir(patchLocation);
        patchLocs = PQSession.parseBaseDirListFile();
        pos = new PatchObject[patchLocs.length];
        subPatchEntries = new OneOffEntry[patchLocs.length];
        for (int i2 = 0; pos != null && i2 < pos.length; ++i2) {
            pos[i2] = PatchObject.getInstance(patchLocs[i2]);
            subPatchEntries[i2] = pos[i2].toOneOffEntry(oracleHomePath);
        }
        return subPatchEntries;
    }

    public static OneOffEntry[] createCombinedComposite(OneOffEntry[] subPatches) throws IllegalAccessException, Exception {
        if (subPatches == null || subPatches.length == 0) {
            return new OneOffEntry[0];
        }
        OneOffEntry[] oneOffEntries = new OneOffEntry[1];
        oneOffEntries[0] = subPatches[0];
        oneOffEntries[0].combineConstituent(subPatches);
        return oneOffEntries;
    }

    public static OneOffEntry[] createCombinedComposite(String patchLocation, String oracleHomePath) throws IllegalAccessException, Exception {
        OneOffEntry[] oneOffEntries = new OneOffEntry[1];
        String[] patchLocs = new String[]{};
        PatchObject[] pos = new PatchObject[]{};
        OneOffEntry[] subPatchEntries = new OneOffEntry[]{};
        PQSession.setBaseDirProvided();
        PQSession.setPatchBaseDir(patchLocation);
        patchLocs = PQSession.parseBaseDirListFile();
        String[] sortedSubPatches = CompositePatchObject.getConstituentList(CompositePatchObject.getCompositeFilePath(patchLocation));
        if (sortedSubPatches.length == patchLocs.length) {
            for (int k2 = 0; k2 < sortedSubPatches.length; ++k2) {
                patchLocs[k2] = patchLocation + File.separator + sortedSubPatches[k2];
            }
        }
        pos = new PatchObject[patchLocs.length];
        subPatchEntries = new OneOffEntry[patchLocs.length];
        for (int i2 = 0; pos != null && i2 < pos.length; ++i2) {
            pos[i2] = PatchObject.getInstance(patchLocs[i2]);
            subPatchEntries[i2] = pos[i2].toOneOffEntry(oracleHomePath);
        }
        oneOffEntries[0] = subPatchEntries[0];
        oneOffEntries[0].combineConstituent(subPatchEntries);
        return oneOffEntries;
    }

    public static ArrayList findCompositePatchLocations(String[] patchLocs) {
        ArrayList<String> compositeLocs = new ArrayList<String>();
        for (int i2 = 0; patchLocs != null && i2 < patchLocs.length; ++i2) {
            if (!PQSession.isComposite(patchLocs[i2])) continue;
            compositeLocs.add(patchLocs[i2]);
        }
        return compositeLocs;
    }

    public static String allowOnlyOneComposite(String[] patchLocs) {
        ArrayList compositeLocs = PQSession.findCompositePatchLocations(patchLocs);
        if (compositeLocs.size() == 1) {
            return (String)compositeLocs.get(0);
        }
        if (compositeLocs.size() > 1) {
            String patchList = "";
            for (int i2 = 0; compositeLocs != null && i2 < compositeLocs.size(); ++i2) {
                patchList = patchList + "\n" + (String)compositeLocs.get(i2);
            }
            throw new OPatchException(OLogger.getString("S_OPATCH_PREREQ_COMPOSITE_ERROR", new Object[]{patchList}));
        }
        return null;
    }

    public static String[] handleCompositeCases(String[] patchLocs, String phBaseDir) throws FileNotFoundException, IOException {
        String compositeLoc;
        if (!PQSession.isComposite(phBaseDir) && (compositeLoc = PQSession.allowOnlyOneComposite(patchLocs)) != null) {
            int i2;
            String[] compPatchLocs = new String[]{};
            ArrayList<String> newPatchLocs = new ArrayList<String>();
            PQSession.setPatchBaseDir(compositeLoc);
            PQSession.setBaseDirProvided();
            PQSession.unsetPatchBaseFileProvided();
            compPatchLocs = PQSession.parseBaseDirListFile();
            String[] sortedSubPatches = CompositePatchObject.getConstituentList(CompositePatchObject.getCompositeFilePath(compositeLoc));
            if (sortedSubPatches.length == compPatchLocs.length) {
                for (int k2 = 0; k2 < sortedSubPatches.length; ++k2) {
                    compPatchLocs[k2] = compositeLoc + File.separator + sortedSubPatches[k2];
                }
            }
            for (i2 = 0; patchLocs != null && i2 < patchLocs.length; ++i2) {
                if (patchLocs[i2].equals(compositeLoc)) continue;
                newPatchLocs.add(patchLocs[i2]);
            }
            for (i2 = 0; compPatchLocs != null && i2 < compPatchLocs.length; ++i2) {
                newPatchLocs.add(compPatchLocs[i2]);
            }
            patchLocs = new String[newPatchLocs.size()];
            newPatchLocs.toArray(patchLocs);
        }
        return patchLocs;
    }

    static {
        baseDir = false;
        phBaseFile = false;
        pi = null;
        isCompositeMap = new HashMap<String, Boolean>();
    }
}

