/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchprereq;

import com.oracle.cie.gdr.external.OracleHomeInventory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.cluster.database.Database;
import oracle.cluster.database.DatabaseFactory;
import oracle.cluster.database.DatabaseInstance;
import oracle.cluster.impl.database.DatabaseFactoryImpl;
import oracle.glcm.opatch.common.api.Result;
import oracle.glcm.opatch.common.api.SessionMode;
import oracle.glcm.opatch.common.api.install.HomeOperationsExt;
import oracle.glcm.opatch.common.api.install.PatchInfo;
import oracle.opatch.Applicable;
import oracle.opatch.ArchiveAction;
import oracle.opatch.BusyFileProcessor;
import oracle.opatch.CompositePatchObject;
import oracle.opatch.ConflictDetectable;
import oracle.opatch.CopyAction;
import oracle.opatch.Crs;
import oracle.opatch.DBOperations;
import oracle.opatch.ExitOPatchException;
import oracle.opatch.FVData;
import oracle.opatch.JarActionEntity;
import oracle.opatch.JarClassLoader;
import oracle.opatch.MakeAction;
import oracle.opatch.OPatch;
import oracle.opatch.OPatchACL;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchExternalFactory;
import oracle.opatch.OPatchOOPHelper;
import oracle.opatch.OPatchOverCAS;
import oracle.opatch.OPatchProperty;
import oracle.opatch.OPatchSDK;
import oracle.opatch.OPatchSession;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OPatchStateManagerFactory;
import oracle.opatch.OUIReplacer;
import oracle.opatch.OUIVersion;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchComponentCheckResult;
import oracle.opatch.PatchObject;
import oracle.opatch.PatchObjectUtil;
import oracle.opatch.PatchingFlow;
import oracle.opatch.PatchingModel;
import oracle.opatch.Platform;
import oracle.opatch.PrereqSession;
import oracle.opatch.Rac;
import oracle.opatch.RacSrvm;
import oracle.opatch.RegenerateLib;
import oracle.opatch.Rollbackable;
import oracle.opatch.Rules;
import oracle.opatch.SQLUtilities;
import oracle.opatch.StringResource;
import oracle.opatch.SystemCall;
import oracle.opatch.UpdateComponent;
import oracle.opatch.WLSPatch;
import oracle.opatch.ZOPErrorMessage;
import oracle.opatch.cas.client.CASClientFactory;
import oracle.opatch.conflicttextualinterpreter.IPatch;
import oracle.opatch.conflicttextualinterpreter.OracleHomeConflictMap;
import oracle.opatch.conflicttextualinterpreter.Patch;
import oracle.opatch.cup.CUPPatchComponent;
import oracle.opatch.ipm.HomeInventoryHelper;
import oracle.opatch.ipm.IIPMRWServices;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.ipm.IPM;
import oracle.opatch.ipm.IPMUtil;
import oracle.opatch.ipm.InstalledComponent;
import oracle.opatch.napplyhelper.NApplyDataSerializer;
import oracle.opatch.opatchactions.DeleteAction;
import oracle.opatch.opatchactions.OrderedPatchAction;
import oracle.opatch.opatchactions.hotpatchAction;
import oracle.opatch.opatchactions.portalAction;
import oracle.opatch.opatchactions.sqlAction;
import oracle.opatch.opatchactions.sqlprocAction;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.BugConflictException;
import oracle.opatch.opatchprereq.BugSubsetException;
import oracle.opatch.opatchprereq.BugSupersetException;
import oracle.opatch.opatchprereq.CheckConflictAdapter;
import oracle.opatch.opatchprereq.CheckPatchInterPrereqEngine;
import oracle.opatch.opatchprereq.ConflictHandler;
import oracle.opatch.opatchprereq.ConflictMatrixOutput;
import oracle.opatch.opatchprereq.ConflictOutput;
import oracle.opatch.opatchprereq.GenericConflictException;
import oracle.opatch.opatchprereq.NoOpPatchException;
import oracle.opatch.opatchprereq.PrereqResource;
import oracle.opatch.opatchprereq.PrereqResult;
import oracle.opatch.opatchprereq.PrereqSet;
import oracle.opatch.opatchprereq.ProcessFileVersions;
import oracle.opatch.opatchprereq.RacPrereqAPI;
import oracle.opatch.opatchsdk.OPatchAnalysisReport;
import oracle.opatch.opatchsdk.OPatchPatchPrereq;
import oracle.opatch.opatchutil.ClassPathAdder;
import oracle.opatch.opatchutil.OPatchUtilHelper;
import oracle.opatch.opatchutil.OUSession;
import oracle.opatch.opatchutil.archive.PatchArchiver;
import oracle.opatch.ops.Feature;
import oracle.opatch.ops.OPS;
import oracle.opatch.patchlevel.CheckPatchLevel;
import oracle.opatch.wrappers.WrapperFactory;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiip.osd.win32.OiipwWin32NativeCalls;
import oracle.sysman.oii.oiix.OiixPathOps;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PrereqAPI {
    static ArrayList executablesChecked = new ArrayList();
    static boolean isApplicableForGIPatching = false;
    static String fuserLoc = "";
    static List<String> patchesToApplyList;
    private static List<String> failedPatches;
    private static String opatchNoFuser;
    static boolean crsLibsLoaded;
    private static boolean twoPhase;

    private PrereqAPI() {
    }

    public static void setIsApplicableForGIPatching(boolean a2) {
        isApplicableForGIPatching = a2;
    }

    protected static boolean isTwoPhase() {
        return twoPhase;
    }

    protected static void setTwoPhase() {
        twoPhase = true;
    }

    protected static void unsetTwoPhase() {
        twoPhase = false;
    }

    public static boolean isLegacyNIOCapable(String oracleHomePath) {
        try {
            Class<?> clazz = Class.forName("oracle.sysman.oui.nioutil.NioFileWrapper");
        }
        catch (ClassNotFoundException e2) {
            OLogger.printlnOnLog("oracle.sysman.oui.nioutil.NioFileWrapper not found.");
            return false;
        }
        return true;
    }

    public static void isNextGenOracleHome(String oracleHomePath) {
        try {
            Class<?> clazz = Class.forName("com.oracle.cie.gdr.external.OracleHomeInventory");
        }
        catch (ClassNotFoundException e2) {
            System.setProperty("isNextGen", "false");
            return;
        }
        try {
            Path homeDir = WrapperFactory.getNioServiceWrapper().getPath(oracleHomePath, new String[0]);
            OracleHomeInventory ohInventory = WrapperFactory.getNextGenApiWrapper().getOracleHomeInventory(homeDir);
            Collection installedDistributions = ohInventory.getInstalledDistributions();
            if (null == installedDistributions || installedDistributions.isEmpty()) {
                System.setProperty("isNextGen", "false");
                return;
            }
        }
        catch (Throwable e3) {
            System.setProperty("isNextGen", "false");
            return;
        }
        System.setProperty("isNextGen", "true");
    }

    public static ArrayList checkCompositePrereq(OneOffEntry[] oneOffEntry, String oracleHomePath) {
        ArrayList<String> output = new ArrayList<String>();
        OneOffEntry[] OHOneOffs = null;
        try {
            OHOneOffs = PrereqAPI.getInstalledOneOff(oracleHomePath);
        }
        catch (Throwable e2) {
            OLogger.debug(new StringBuffer("Converting Throwable to RuntimeException"));
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        String[] availableOneOffs = new String[OHOneOffs.length + oneOffEntry.length];
        int index = 0;
        for (index = 0; index < OHOneOffs.length; ++index) {
            availableOneOffs[index] = OHOneOffs[index].getID();
        }
        for (index = OHOneOffs.length; index < oneOffEntry.length + OHOneOffs.length; ++index) {
            availableOneOffs[index] = oneOffEntry[index - OHOneOffs.length].getID();
        }
        for (int i2 = 0; i2 < oneOffEntry.length; ++i2) {
            String[] patchPrereqs = oneOffEntry[i2].getPrereqPatchIDs();
            if (patchPrereqs == null || patchPrereqs.length == 0) continue;
            for (int j2 = 0; j2 < patchPrereqs.length; ++j2) {
                boolean patchFound = false;
                for (int k2 = 0; k2 < availableOneOffs.length; ++k2) {
                    if (!patchPrereqs[j2].equals(availableOneOffs[k2])) continue;
                    patchFound = true;
                    break;
                }
                if (patchFound) continue;
                output.add(patchPrereqs[j2]);
            }
        }
        return output;
    }

    public static PrereqResult checkAutoRollbackPatches(String oracleHomePath, OneOffEntry[] patchesToApply) {
        PrereqSet interPatchesToBeRollback;
        boolean isComposite;
        StringBuffer dBuff;
        ConflictMatrixOutput interOutput;
        ConflictMatrixOutput intraOutput;
        PrereqSet patchesThatCanGoNow;
        PrereqSet patchesNotNeeded;
        PrereqSet patchesToBeMerged;
        PrereqResult resObj;
        block52: {
            PrereqSet patchesToApplySet;
            resObj = new PrereqResult();
            patchesToBeMerged = new PrereqSet();
            patchesNotNeeded = new PrereqSet();
            patchesThatCanGoNow = new PrereqSet();
            intraOutput = null;
            interOutput = null;
            dBuff = new StringBuffer("N-Apply: check if patchesToApply is empty.");
            OLogger.debug(dBuff);
            if (patchesToApply == null || patchesToApply.length == 0) {
                StringBuffer buff = new StringBuffer(OLogger.getString("OUI-67306", new Object[]{"UtilSession", "check"}));
                OLogger.debug(buff);
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                resObj.addDetail(buff);
                return resObj;
            }
            isComposite = false;
            int compositeCounter = 0;
            for (int i2 = 0; i2 < patchesToApply.length; ++i2) {
                if (!patchesToApply[i2].getIsComposite()) continue;
                ++compositeCounter;
            }
            if (compositeCounter == patchesToApply.length) {
                isComposite = true;
            } else if (compositeCounter > 0) {
                String error_msg = OLogger.getString("OUI-67906");
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                resObj.addDetail(error_msg);
                return resObj;
            }
            if (isComposite) {
                patchesToApply = CompositePatchObject.getConstituentsInOrder(OPatchEnv.getNApplyBaseDir(), oracleHomePath, "util");
            }
            if (OPatchSessionHelper.hasHotPatch(patchesToApplySet = new PrereqSet(patchesToApply)) && OPatchSessionHelper.hasNonHotPatch(patchesToApplySet)) {
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                resObj.addDetail(OLogger.getString("OUI-67320", new Object[]{OPatchSessionHelper.getHotPatchIDs(patchesToApplySet), OPatchSessionHelper.getNonHotPatchIDs(patchesToApplySet), "util getautorollback"}));
                return resObj;
            }
            if (OPatchSessionHelper.hasMiniPatchset(patchesToApplySet) && OPatchSessionHelper.hasNormalOneoffs(patchesToApplySet)) {
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                resObj.addDetail(OLogger.getString("OUI-67326", new Object[]{OPatchSessionHelper.getNonMiniPatchSetIDs(patchesToApplySet), OPatchSessionHelper.getMiniPatchSetIDs(patchesToApplySet), "util getautorollback"}));
                return resObj;
            }
            try {
                PatchObject[] initialApplyPatchObjects = OPatchUtilHelper.getPatchesToApply(oracleHomePath, patchesToApply, "util");
                ArrayList identicalPatches = new ArrayList();
                if (isComposite) {
                    try {
                        patchesToApply = CompositePatchObject.GetNonIdenticalPatch(patchesToApply, oracleHomePath);
                    }
                    catch (Exception e1) {
                        String errorMsg = OLogger.getString("OUI-67904");
                        resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                        resObj.addDetail(errorMsg);
                        OPatchStateManagerFactory.getInstance().setErrorCode(130);
                        return resObj;
                    }
                    if (patchesToApply.length == 0) {
                        String errorMsg = OLogger.getString("OUI-67905");
                        OPatchStateManagerFactory.getInstance().setErrorCode(56);
                        resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                        resObj.addDetail(errorMsg);
                        return resObj;
                    }
                    break block52;
                }
                try {
                    PrereqResult idPatch = PrereqAPI.checkIdenticalPatch(oracleHomePath, identicalPatches, patchesToApply);
                    if (idPatch.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                        dBuff = new StringBuffer("Prerequisite check \"CheckForIdenticalPatchInOracleHome\" failed.");
                        dBuff.append(idPatch.toString());
                        throw new ExitOPatchException(dBuff.toString());
                    }
                }
                catch (ExitOPatchException e2) {
                    if (identicalPatches.size() == patchesToApply.length) {
                        OLogger.println(e2.getMessage());
                        resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                        resObj.addDetail(e2.getMessage());
                        return resObj;
                    }
                    PrereqSet p1 = new PrereqSet(patchesToApply);
                    PrereqSet p2 = new PrereqSet(identicalPatches.toArray(new OneOffEntry[identicalPatches.size()]));
                    OLogger.printlnOnLog(OLogger.INFO, "Patches to apply -> " + p1.toString());
                    OLogger.printlnOnLog(OLogger.INFO, "Identical patches to filter -> " + p2.toString());
                    OLogger.println("\nThe following patches are identical and are skipped:");
                    OLogger.println(p2.toString());
                    p1 = p1.delete(p2);
                    patchesToApply = p1.getAllElements();
                }
            }
            catch (Exception e3) {
                OLogger.printStackTrace(e3);
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                resObj.addDetail(e3);
                return resObj;
            }
        }
        OPatchEnv.setSessionType("util");
        intraOutput = PrereqAPI.checkConflictAmongPatchesWithDetail(oracleHomePath, patchesToApply);
        PrereqResult.ExecuteStatus intraStatus = intraOutput.getResult();
        if (intraStatus == PrereqResult.ExecuteStatus.NOT_EXECUTED) {
            dBuff = new StringBuffer("CompositeApply: PrereqAPI.checkConflictAmongPatchesWithDetail() returns NOT_EXECUTED.");
            OLogger.debug(dBuff);
            dBuff = new StringBuffer("CompositeApply: calling OPatchUtilHelper.processPrereqNotExecuted");
            OLogger.debug(dBuff);
        } else if (intraStatus == PrereqResult.ExecuteStatus.FAILED) {
            if (isComposite) {
                dBuff = new StringBuffer("CompositeApply: PrereqAPI.checkConflictAmongPatchesWithDetail() returns FAILED.Check composite patch for intra-conflict amongst singletons.");
                OLogger.debug(dBuff);
                dBuff = new StringBuffer("CompositeApply: calling OPatchUtilHelper.processPrereqNotExecuted for Composite Patch");
                OLogger.debug(dBuff);
            } else {
                String id;
                String msg = "";
                int modelCode = PatchingModel.returnModelCode(oracleHomePath);
                patchesToBeMerged = new PrereqSet(intraOutput.getListOfPatchesToBeMerged());
                patchesNotNeeded = new PrereqSet(intraOutput.getListOfPatchesNotNeeded());
                patchesThatCanGoNow = new PrereqSet(intraOutput.getListOfPatchesThatCanGoNow());
                patchesToApply = patchesThatCanGoNow.getAllElements();
                if (patchesThatCanGoNow.size() == 0) {
                    dBuff = new StringBuffer("N-Apply: patchesThatCanGoNow's size = 0 ");
                    OLogger.debug(dBuff);
                    if (patchesToBeMerged.size() != 0) {
                        dBuff = new StringBuffer("N-Apply: patchesToBeMerged's size = 0 ");
                        OLogger.debug(dBuff);
                        dBuff = new StringBuffer("");
                        OLogger.println("");
                        for (int i3 = 0; i3 < patchesToBeMerged.size(); ++i3) {
                            dBuff.append("   ");
                            id = patchesToBeMerged.getElement(i3).getID();
                            dBuff.append(id);
                            if (modelCode != 2) continue;
                            if (patchesToBeMerged.getElement(i3).getPatchType().equals("snowball")) {
                                OLogger.println("Patch \"" + id + "\" is a \"" + "Fusion Applications" + "\" patch.");
                                continue;
                            }
                            if (!patchesToBeMerged.getElement(i3).getPatchType().equals("singleton")) continue;
                            OLogger.println("Patch \"" + id + "\" is a \"" + "singleton" + "\" patch.");
                        }
                        OLogger.warn("OUI-67301", new Object[]{dBuff.toString()});
                    }
                    if (patchesNotNeeded.size() != 0) {
                        dBuff = new StringBuffer("N-Apply: patchesToBeMerged's size != 0 ");
                        OLogger.debug(dBuff);
                        dBuff = new StringBuffer("");
                        for (int i4 = 0; i4 < patchesNotNeeded.size(); ++i4) {
                            dBuff.append("   ");
                            dBuff.append(patchesNotNeeded.getElement(i4).getID());
                        }
                        OLogger.warn("OUI-67302", new Object[]{dBuff.toString()});
                    }
                    msg = OLogger.getString("OUI-67305");
                    resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                    resObj.addDetail(msg);
                    return resObj;
                }
                dBuff = new StringBuffer("N-Apply: patchesThatCanGoNow's size > 0 ");
                OLogger.debug(dBuff);
                if (patchesToBeMerged.size() > 0) {
                    dBuff = new StringBuffer("N-Apply: patchesToBeMerged's size > 0 ");
                    OLogger.debug(dBuff);
                    dBuff = new StringBuffer("");
                    OLogger.println("");
                    for (int i5 = 0; i5 < patchesToBeMerged.size(); ++i5) {
                        dBuff.append("   ");
                        id = patchesToBeMerged.getElement(i5).getID();
                        dBuff.append(id);
                        if (modelCode != 2) continue;
                        if (patchesToBeMerged.getElement(i5).getPatchType().equals("snowball")) {
                            OLogger.println("Patch \"" + id + "\" is a \"" + "Fusion Applications" + "\" patch.");
                            continue;
                        }
                        if (!patchesToBeMerged.getElement(i5).getPatchType().equals("singleton")) continue;
                        OLogger.println("Patch \"" + id + "\" is a \"" + "singleton" + "\" patch.");
                    }
                    msg = OLogger.getString("OUI-67308", new Object[]{dBuff.toString()});
                    OLogger.println(msg);
                }
                if (patchesNotNeeded.size() > 0) {
                    dBuff = new StringBuffer("N-Apply: patchesNotNeeded's size > 0 ");
                    OLogger.debug(dBuff);
                    dBuff = new StringBuffer("");
                    for (int i6 = 0; i6 < patchesNotNeeded.size(); ++i6) {
                        dBuff.append("   ");
                        dBuff.append(patchesNotNeeded.getElement(i6).getID());
                    }
                    msg = "Skip these patches because they are subset of other patches in the list:" + dBuff.toString();
                    OLogger.println(msg);
                }
                dBuff = new StringBuffer("");
                for (int i7 = 0; i7 < patchesThatCanGoNow.size(); ++i7) {
                    dBuff.append("   ");
                    dBuff.append(patchesThatCanGoNow.getElement(i7).getID());
                }
                msg = "Proceed with these patches:" + dBuff.toString();
                OLogger.println(msg);
            }
        }
        OneOffEntry[] compositePatch = null;
        if (isComposite) {
            compositePatch = new OneOffEntry[]{patchesToApply[patchesToApply.length - 1]};
            compositePatch[0].combineConstituent(patchesToApply);
            interOutput = PrereqAPI.checkConflictAgainstOHWithDetail(oracleHomePath, compositePatch);
        } else {
            interOutput = PrereqAPI.checkConflictAgainstOHWithDetailSkipMissingComps(oracleHomePath, "util", patchesToApply);
        }
        PrereqResult.ExecuteStatus interStatus = interOutput.getResult();
        PrereqSet patchesToBeRolledBack = new PrereqSet();
        if (interStatus == PrereqResult.ExecuteStatus.NOT_EXECUTED) {
            int i8;
            Vector detail = interOutput.getResultDetails();
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            StringBuffer buff = new StringBuffer();
            if (detail == null || detail.size() == 0) {
                buff = new StringBuffer("Prerequisite API is not executed but no detail is available.");
                OLogger.log(OLogger.SEVERE, buff.toString());
                resObj.addDetail(buff.toString());
                return resObj;
            }
            ArrayList<String> list = new ArrayList<String>();
            for (i8 = 0; i8 < detail.size(); ++i8) {
                Object obj = detail.get(i8);
                if (obj instanceof Exception) {
                    Exception e4 = (Exception)obj;
                    buff = new StringBuffer("An exception occurred when calling Pre-req. API. Detail: ");
                    buff.append(e4.getMessage());
                    OLogger.log(OLogger.SEVERE, buff.toString());
                    resObj.addDetail(buff.toString());
                    return resObj;
                }
                if (!(obj instanceof String)) continue;
                String s = (String)obj;
                list.add(s);
            }
            buff = new StringBuffer("Pre-req. API didn't execute.  Detail: ");
            for (i8 = 0; i8 < list.size(); ++i8) {
                String s = (String)list.get(i8);
                buff.append(s);
                buff.append(", ");
            }
            OLogger.log(OLogger.SEVERE, buff.toString());
            resObj.addDetail(buff.toString());
            return resObj;
        }
        if (interStatus == PrereqResult.ExecuteStatus.FAILED) {
            PrereqSet interPatchesToBeMerged = new PrereqSet(interOutput.getListOfPatchesToBeMerged());
            PrereqSet interPatchesNotNeeded = new PrereqSet(interOutput.getListOfPatchesNotNeeded());
            PrereqSet interPatchesThatCanGoNow = new PrereqSet(interOutput.getListOfPatchesThatCanGoNow());
            PrereqSet interPatchesToBeRollback2 = new PrereqSet(interOutput.getListOfPatchesThatNeedToBeRollback());
            patchesThatCanGoNow = interPatchesThatCanGoNow;
            patchesToBeMerged = patchesToBeMerged.add(interPatchesToBeMerged);
            patchesNotNeeded = patchesNotNeeded.add(interPatchesNotNeeded);
            patchesToBeRolledBack = interPatchesToBeRollback2;
            patchesThatCanGoNow = patchesThatCanGoNow.add(interPatchesToBeMerged.delete(interPatchesToBeRollback2));
        } else {
            patchesThatCanGoNow = new PrereqSet(patchesToApply);
        }
        if (patchesToBeRolledBack.size() > 0 && !Rules.shouldSwitchONAutoRollback(oracleHomePath)) {
            OneOffEntry[] toApplyOneOffs = patchesThatCanGoNow.getAllElements();
            PrereqSet toApply = new PrereqSet(toApplyOneOffs);
            toApply.retain(patchesToBeRolledBack);
            patchesToBeRolledBack = patchesToBeRolledBack.delete(patchesNotNeeded);
            patchesToBeRolledBack = patchesToBeRolledBack.add(toApply);
        }
        if ((interPatchesToBeRollback = patchesToBeRolledBack).size() > 0) {
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            StringBuffer msg = new StringBuffer(interOutput.getConflictDetailsString() + "\n\n");
            OneOffEntry[] elements = interPatchesToBeRollback.getAllElements();
            msg.append("Following patch(es) will be rolled back: ");
            for (int i9 = 0; i9 < elements.length; ++i9) {
                msg.append(elements[i9].getID());
                msg.append(i9 == elements.length - 1 ? "" : ",");
            }
            resObj.addDetail(msg.toString());
        } else {
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        }
        return resObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrereqResult checkPatchgenCommand(String oracleHomePath) {
        StringBuffer buff = new StringBuffer("PrereqAPI::checkPatchgenCommand called");
        OLogger.debug(buff);
        PrereqResult resObj = new PrereqResult();
        IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
        boolean alreadyLocked = readServices.isLocked();
        try {
            if (!alreadyLocked) {
                readServices.lock(oracleHomePath);
            }
            if (!readServices.isDesiredHome()) {
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                buff = new StringBuffer("Command 'patchgen' comes firstly for DB oracle home with version \"12.1.0.0.0\", while current oracle home type is not applicable or version is too low.");
                resObj.addDetail(buff.toString());
                PrereqResult prereqResult = resObj;
                return prereqResult;
            }
        }
        catch (Throwable t) {
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            OLogger.debug(new StringBuffer("Throwable occurred: " + t.getMessage()));
            resObj.addDetail(t);
            PrereqResult prereqResult = resObj;
            return prereqResult;
        }
        finally {
            if (!alreadyLocked) {
                readServices.release();
            }
        }
        OPatchProperty prop = new OPatchProperty();
        String cmdPath = "";
        try {
            cmdPath = prop.getPatchgenCommand();
        }
        catch (NoSuchMethodException e2) {
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            buff = new StringBuffer("Command 'patchgen' does not exist in Oracle Home");
            resObj.addDetail(buff.toString());
            return resObj;
        }
        Path cmdFile = WrapperFactory.getNioServiceWrapper().getPath(cmdPath, new String[0]);
        if (!Files.isExecutable(cmdFile)) {
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            buff = new StringBuffer("Command \"" + cmdPath + "\" is not executable.");
            resObj.addDetail(buff.toString());
        }
        if (resObj.getResult() != PrereqResult.ExecuteStatus.FAILED) {
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        }
        return resObj;
    }

    public static PrereqResult checkApplicableProduct(String oracleHomePath, PatchObject patchObject) {
        PrereqResult resObj = new PrereqResult();
        PrereqResult standAloneResObj = new PrereqResult();
        String msg = "";
        if (patchObject == null) {
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            msg = OLogger.getString("OUI-67075");
            resObj.addDetail(msg);
            return resObj;
        }
        String patchApplicableType = patchObject.getProductType();
        StringBuffer buff = new StringBuffer("PrereqAPI::checkApplicableProduct");
        OLogger.debug(buff);
        if (!(patchApplicableType.equals("oui") || patchApplicableType.equals("saoui") || patchApplicableType.equals(""))) {
            msg = OLogger.getString("OUI-67232");
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            resObj.addDetail(msg);
        } else {
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            buff = new StringBuffer("Prereq checkApplicableProduct passed");
            OLogger.debug(buff);
        }
        return resObj;
    }

    public static PrereqResult checkApplicableForGIPatching(String oracleHomePath) {
        PrereqResult resObj;
        block10: {
            isApplicableForGIPatching = false;
            StringBuffer buff = new StringBuffer("OPatchSessionHelper::isAppliableForGIPatching() called");
            OLogger.debug(buff);
            resObj = new PrereqResult();
            OiiiVersion desiredVer = new OiiiVersion("12.1.0.0.0");
            OiiiVersion curOUIVer = new OiiiVersion(OUIVersion.getOUIVersion());
            if (desiredVer.laterThan(curOUIVer)) {
                buff = new StringBuffer("opatchauto can't be run from current Oracle Home \"" + oracleHomePath + "\" whose OUI version is prior to " + "12.1.0.0.0");
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                resObj.addDetail(buff.toString());
                return resObj;
            }
            try {
                OPatchSessionHelper.loadRACRelatedLibFile(oracleHomePath);
                OPatchSessionHelper.loadCRSRelatedLibFiles(oracleHomePath);
                if (!isApplicableForGIPatching) {
                    throw new RuntimeException("The following Oracle Home is invalid and not applicable for GI Patching:\n" + oracleHomePath);
                }
            }
            catch (Throwable t) {
                buff = new StringBuffer("Failed to load srvm jar files from Oracle Home: " + oracleHomePath);
                OLogger.debug(buff);
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                resObj.addDetail(t);
                return resObj;
            }
            Crs ins = null;
            Crs.CrsType type = null;
            try {
                ins = OPatchExternalFactory.getCrs(oracleHomePath).getInstance(oracleHomePath);
                type = ins.getCrsType();
            }
            catch (Throwable t) {
                OLogger.printlnOnLog("Throwable occurred: " + t.getMessage());
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                resObj.addDetail(t);
                return resObj;
            }
            if (ins.isGridEnv()) {
                try {
                    String crsVer = ins.getCrsVersion();
                    OiiiVersion crsCompVer = new OiiiVersion(crsVer);
                    if (desiredVer.laterThan(crsCompVer)) {
                        buff = new StringBuffer("opatchauto support starts from version \"12.1.0.0.0\", while current version of detected Grid Home is \"" + crsVer + "\".");
                        OLogger.debug(buff);
                        resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                        resObj.addDetail(buff.toString());
                        return resObj;
                    }
                    break block10;
                }
                catch (Throwable t) {
                    OLogger.printlnOnLog("Throwable occurred: " + t.getMessage());
                    resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                    resObj.addDetail(t);
                    return resObj;
                }
            }
            buff = new StringBuffer("There is no any grid infrastructure detected on current system.");
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            resObj.addDetail(buff.toString());
            return resObj;
        }
        resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        return resObj;
    }

    public static PrereqResult checkFusionAppsCompatible(String oracleHomePath) {
        StringBuffer buff = new StringBuffer("PrereqAPI::checkFusionAppsCompatible()");
        OLogger.debug(buff);
        PrereqResult resObj = new PrereqResult();
        int patchingModel = PatchingModel.returnModelCode(oracleHomePath);
        if (patchingModel == 2) {
            if (!(IPMUtil.canGetLangsForInvEntry() && IPMUtil.canGetDescForInvEntry() && IPMUtil.canGetUniqueIDForInvEntry() && IPMUtil.canSetSubsetPatchesForInvEntry())) {
                String msg = OLogger.getString("OUI-67645");
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                resObj.addDetail(msg);
                if (OPatchEnv.isContinueOnPrereqFailure()) {
                    for (String patchId : PrereqAPI.getPatchesToApplyList()) {
                        OUSession.addPrereqResultForPatchesToReport(patchId, OPatchPatchPrereq.CHECK_FUSION_APPS_COMPATIBLE, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
                    }
                }
            } else {
                resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            }
        } else {
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        }
        return resObj;
    }

    public static PrereqResult checkPatchsetUpdateCompatible(String oracleHomePath, PatchObject[] patchObjects) {
        StringBuffer buff = new StringBuffer("PrereqAPI::checkPatchsetUpdateCompatible()");
        OLogger.debug(buff);
        PrereqResult resObj = new PrereqResult();
        if (patchObjects == null) {
            buff = new StringBuffer("PatchObject Array is null");
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            resObj.addDetail(buff.toString());
            return resObj;
        }
        boolean isMiniPatchset = false;
        StringBuffer patches = new StringBuffer();
        ArrayList<String> failedPatches = new ArrayList<String>();
        for (int i2 = 0; i2 < patchObjects.length; ++i2) {
            if (!patchObjects[i2].getPatchInventory().isMiniPatchSet()) continue;
            isMiniPatchset = true;
            patches.append(" ");
            patches.append(patchObjects[i2].getPatchID());
            failedPatches.add(patchObjects[i2].getPatchID());
        }
        if (!isMiniPatchset) {
            buff = new StringBuffer("There are no Patch Set Update(s). This prereq is not applicable");
            buff.append(" for the given patches.");
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            resObj.addDetail(buff.toString());
            return resObj;
        }
        buff = new StringBuffer("\nGiven Oracle Home and the following Patch Set Update(s) are not compatible.");
        buff.append(" OPatch needs OUI support for \nPatch Set Update(s).");
        buff.append("\nThe Patch Set Update(s) are \"" + patches.toString() + "  \".");
        resObj.addDetail(buff.toString());
        resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
        if (OPatchEnv.isContinueOnPrereqFailure()) {
            for (String patchId : failedPatches) {
                OUSession.addPrereqResultForPatchesToReport(patchId, OPatchPatchPrereq.CHECK_PATCHSET_UPDATE_COMPATIBLE, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
            }
        }
        return resObj;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static PrereqResult checkRollbackSid(String oracleHomePath, PatchObject patchObject, HashSet inputSet, boolean overrideDefault) {
        StringBuffer buff;
        PrereqResult resObj;
        block16: {
            boolean proceedFurther;
            resObj = new PrereqResult();
            buff = new StringBuffer("PrereqAPI::CheckRollbackSid()");
            OLogger.debug(buff);
            if (OPatchEnv.isSnowBall()) {
                resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
                String msg = "For snowball patching model, skip checkRollbackSid \n.";
                resObj.addDetail(msg);
                buff.setLength(0);
                OLogger.debug(buff.append(msg));
                return resObj;
            }
            if (patchObject == null) {
                buff = new StringBuffer("Given patch object is null");
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                resObj.addDetail(buff.toString());
                return resObj;
            }
            boolean bl = proceedFurther = patchObject.isSqlRelatedActions() || patchObject.isOnlinePatch();
            if (!proceedFurther) {
                resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
                buff = new StringBuffer("Prereq CheckRollbackSid passed");
                OLogger.debug(buff);
                return resObj;
            }
            resObj = PrereqAPI.checkOracleHome(oracleHomePath);
            if (resObj.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED) return resObj;
            if (resObj.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                return resObj;
            }
            if (!(inputSet != null && inputSet.size() != 0 || patchObject.isOnlinePatch())) {
                buff = new StringBuffer("No SIDs found. Please provide valid SIDs to connect to database.");
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                resObj.addDetail(buff.toString());
                return resObj;
            }
            if (patchObject.isOnlinePatch()) {
                Properties onlineProp = OPatchSessionHelper.getOnlinePropertyFromFile(oracleHomePath);
                String onlineFilePath = OPatchEnv.getOnlinePropertyFilePath(oracleHomePath);
                boolean remote = true;
                OPatchSessionHelper.loadRACRelatedLibFile();
                return PrereqAPI.checkOnlinePatchRollbackSid(patchObject, inputSet, onlineProp, onlineFilePath, oracleHomePath, true, OPatchEnv.getLocalNode());
            }
            String cookedPatchID = patchObject.getCookedPatchID();
            String patchID = patchObject.getPatchID();
            String sqlPropertyFile = OPatchEnv.getSqlPropertyFilePath(oracleHomePath, cookedPatchID);
            Path f2 = WrapperFactory.getNioServiceWrapper().getPath(sqlPropertyFile, new String[0]);
            if (Files.exists(f2, new LinkOption[0])) {
                if (!Files.isReadable(f2)) {
                    buff = new StringBuffer("The sqlproperties file \"" + sqlPropertyFile + "\" is not readable");
                    resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                    resObj.addDetail(buff.toString());
                    return resObj;
                }
                Properties p2 = OPatchSessionHelper.getSqlPropertyFromFile(oracleHomePath, cookedPatchID);
                boolean sqlpropValue = Boolean.valueOf(p2.getProperty("RUNSQL"));
                if (sqlpropValue || !sqlpropValue && overrideDefault) {
                    String appliedSid = p2.getProperty("SID");
                    if (appliedSid == null || appliedSid.equals("")) {
                        resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                        buff = new StringBuffer("There are no SIDs defined to check with the input SIDs.");
                        resObj.addDetail(buff.toString());
                        OLogger.debug(buff);
                        return resObj;
                    }
                    HashSet<String> applySet = new HashSet<String>();
                    StringTokenizer strTok = new StringTokenizer(appliedSid, ",");
                    while (strTok.hasMoreTokens()) {
                        String temp = strTok.nextToken();
                        applySet.add(temp);
                    }
                    boolean leaveOut = false;
                    if (applySet.containsAll(inputSet) && !applySet.equals(inputSet)) {
                        if (OPatchEnv.getSIDSubsetValue().equals("")) {
                            OPatchEnv.setSIDSubsetValue(appliedSid);
                            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
                        }
                        leaveOut = true;
                    }
                    if (!inputSet.equals(applySet) && !leaveOut) {
                        buff = new StringBuffer(OLogger.getString("OUI-67263", new Object[]{appliedSid}));
                        OLogger.debug(buff);
                        resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                        resObj.addDetail(buff.toString());
                        return resObj;
                    }
                    break block16;
                } else {
                    buff = new StringBuffer("Since the apply of patch \"" + patchID + "\" has not used any SIDs,");
                    buff.append("\nthe rollback of \"" + patchID + "\" doesn't have any effect in using these SIDs.");
                    resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
                    resObj.addDetail(buff.toString());
                    OLogger.debug(buff);
                    return resObj;
                }
            }
            if (overrideDefault) {
                buff = new StringBuffer("There is not 'sqlproperties' file at the location ");
                buff.append("\"" + sqlPropertyFile + "\"");
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                resObj.addDetail(buff.toString());
                return resObj;
            }
        }
        resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        buff = new StringBuffer("Prereq CheckRollbackSid passed");
        OLogger.debug(buff);
        return resObj;
    }

    public static PrereqResult checkOnlinePatchRollbackSid(PatchObject po, HashSet inputSet, Properties onlineProp, String filePath, String oracleHomePath, boolean remote, String nodeName) {
        PrereqResult resObj = new PrereqResult();
        StringBuffer buff = new StringBuffer();
        if (onlineProp == null) {
            buff = new StringBuffer("\nUnable to get property values from properties file of the Online patch.\n");
            if (!nodeName.equals("")) {
                buff.append("The node name is \"" + nodeName + "\".\n");
            }
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            resObj.addDetail(buff.toString());
            return resObj;
        }
        String patchID = po.getPatchID();
        StringBuffer sidKey = new StringBuffer(patchID);
        sidKey.append("_ONLINE_SID");
        String appliedSid = onlineProp.getProperty(sidKey.toString());
        if (inputSet.size() != 0 && (appliedSid == null || appliedSid.equals(""))) {
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            buff = new StringBuffer("\nThere are no SIDs defined to check with the input SIDs.\n");
            if (!nodeName.equals("")) {
                buff.append("The node name, where failure occurred, is \"" + nodeName + "\".\n");
            }
            resObj.addDetail(buff.toString());
            OLogger.debug(buff);
            return resObj;
        }
        HashSet<String> applySet = new HashSet<String>();
        if (appliedSid != null) {
            StringTokenizer strTok = new StringTokenizer(appliedSid, ",");
            while (strTok.hasMoreTokens()) {
                String temp = strTok.nextToken();
                applySet.add(temp);
            }
        }
        boolean leaveOut = false;
        if (applySet.containsAll(inputSet) && !applySet.equals(inputSet) && inputSet.size() != 0) {
            buff = new StringBuffer(appliedSid);
            if (!nodeName.equals("")) {
                buff.append("(");
                buff.append(nodeName);
                buff.append(") ");
                appliedSid = buff.toString();
            }
            OPatchEnv.setSIDSubsetValue(appliedSid);
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            leaveOut = true;
        }
        if (!inputSet.equals(applySet)) {
            if (inputSet.size() == 0) {
                if (OPatchEnv.isOnline()) {
                    buff = new StringBuffer("\nNo input SIDs found. Please provide valid SIDs to check for rollback condition.\n");
                    if (!nodeName.equals("")) {
                        buff.append("The node name, where failure occurred, is \"" + nodeName + "\".\n");
                    }
                    resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                    resObj.addDetail(buff.toString());
                    return resObj;
                }
                resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
                return resObj;
            }
            if (!leaveOut) {
                if (applySet.size() == 0) {
                    appliedSid = "";
                }
                buff = new StringBuffer(OLogger.getString("OUI-67286", new Object[]{appliedSid}));
                if (!nodeName.equals("")) {
                    buff.append("\nThe node name, where failure occurred, is \"" + nodeName + "\".\n");
                }
                OLogger.debug(buff);
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                resObj.addDetail(buff.toString());
                return resObj;
            }
        }
        if (!remote) {
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            return resObj;
        }
        Rac.RacType racType = null;
        Rac rac = OPatchExternalFactory.getRac(oracleHomePath);
        try {
            IIPMReadServices readServices = PrereqSession.getReadServices(oracleHomePath);
            racType = rac.getInstance(readServices);
        }
        catch (Throwable e2) {
            OLogger.printStackTrace(e2);
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            resObj.addDetail(e2.getMessage());
            resObj.addDetail("\nNot able to check prereq \"CheckRollbackSid\" for online patch in RAC.\n");
        }
        String[] dbSids = OPatchEnv.getDBSIDs();
        String[] dbNodes = OPatchEnv.getDBNodes();
        String localNode = OPatchEnv.getLocalNode();
        String[] filePaths = new String[dbNodes.length];
        if (racType == Rac.RacType.NO_RAC || racType == Rac.RacType.SINGLE_NODE) {
            boolean remoteNodeCount = false;
            for (int i2 = 0; dbNodes != null && i2 < dbNodes.length; ++i2) {
                if (dbNodes[i2].equals(localNode) || dbNodes[i2].equals("")) continue;
                remoteNodeCount = true;
            }
            if (!remoteNodeCount) {
                resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
                return resObj;
            }
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            buff = new StringBuffer("\nOPatch detects single node RAC (or) no RAC system.");
            buff.append("\nUser cannot give remote node list(s) as input.\n");
            resObj.addDetail(buff.toString());
            return resObj;
        }
        for (int i3 = 0; dbNodes != null && i3 < dbNodes.length; ++i3) {
            String destOnlineFile;
            if (dbNodes[i3].equals(localNode) || dbNodes[i3].equals("")) {
                filePaths[i3] = "";
                continue;
            }
            String srcOnlineFile = OPatchEnv.getOnlinePropertyFilePath(oracleHomePath);
            buff = new StringBuffer(OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath));
            buff.append(File.separator);
            buff.append(dbNodes[i3]);
            buff.append("_");
            buff.append("OnlinePatch.properties");
            filePaths[i3] = destOnlineFile = buff.toString();
            RacSrvm racSrvm = OPatchExternalFactory.getRacSrvm(oracleHomePath);
            try {
                boolean isFileExists = racSrvm.isFileExistsOnNode(dbNodes[i3], srcOnlineFile);
                if (!isFileExists) {
                    resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                    buff = new StringBuffer("\nThe file \"" + srcOnlineFile + "\" is not present in the node \"" + dbNodes[i3] + "\".");
                    buff.append("\nNot able to get applied SIDs for this node.\n");
                    resObj.addDetail(buff.toString());
                    return resObj;
                }
                racSrvm.transferFileFromNode(dbNodes[i3], srcOnlineFile, destOnlineFile);
                continue;
            }
            catch (Exception e3) {
                OLogger.printStackTrace(e3);
                buff = new StringBuffer("Failed to execute prereq \"CheckRollbackSid\" on remote node \"" + dbNodes[i3] + "\"");
                buff.append("\nPlease refer log file for details.\n");
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                resObj.addDetail(buff.toString());
                return resObj;
            }
        }
        HashSet<String> sidInfo = null;
        for (int i4 = 0; dbNodes != null && i4 < dbNodes.length; ++i4) {
            sidInfo = new HashSet<String>();
            String nName = dbNodes[i4];
            if (nName.equals(localNode) || nName.equals("")) continue;
            for (int j2 = 0; j2 < dbSids.length; ++j2) {
                if (!dbNodes[j2].equals(nName)) continue;
                sidInfo.add(dbSids[j2]);
            }
            Path f2 = null;
            try {
                f2 = WrapperFactory.getNioServiceWrapper().getPath(filePaths[i4], new String[0]);
            }
            catch (NullPointerException e4) {
                OLogger.printStackTrace(e4);
                buff = new StringBuffer("Not able to get file \"" + filePaths[i4] + "\" in RAC mode");
                OLogger.printlnOnLog(OLogger.INFO, buff.toString());
                continue;
            }
            Properties prop = OPatchSessionHelper.getOnlinePropertyFromSpecifiedFileObj(f2, filePaths[i4]);
            resObj = PrereqAPI.checkOnlinePatchRollbackSid(po, sidInfo, prop, filePaths[i4], oracleHomePath, false, dbNodes[i4]);
            if (resObj.getResult() != PrereqResult.ExecuteStatus.FAILED) continue;
            PrereqAPI.cleanUpFiles(filePaths);
            return resObj;
        }
        PrereqAPI.cleanUpFiles(filePaths);
        resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        return resObj;
    }

    private static void cleanUpFiles(String[] filePaths) {
        StringBuffer buff = new StringBuffer();
        for (int i2 = 0; filePaths != null && i2 < filePaths.length; ++i2) {
            Path f2 = null;
            if (filePaths[i2].equals("")) continue;
            try {
                f2 = WrapperFactory.getNioServiceWrapper().getPath(filePaths[i2], new String[0]);
            }
            catch (Exception e2) {
                OLogger.printStackTrace(e2);
                continue;
            }
            boolean ok = false;
            try {
                ok = Files.deleteIfExists(f2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (ok) continue;
            buff = new StringBuffer("Unable to delete the file \"" + filePaths[i2] + "\"");
            OLogger.printlnOnLog(OLogger.INFO, buff.toString());
        }
    }

    public static PrereqResult checkOracleHome(String oracleHomePath) {
        PrereqResult resObj = new PrereqResult();
        StringBuffer buff = new StringBuffer("PrereqAPI::checkOracleHome()");
        OLogger.debug(buff);
        if (!PrereqAPI.checkPath(oracleHomePath)) {
            buff = new StringBuffer("Oracle Home Path is not correct/valid.");
            OLogger.printlnOnLog(buff.toString());
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            resObj.addDetail(buff.toString());
            return resObj;
        }
        buff = new StringBuffer("\nOracle Home path( " + oracleHomePath + " ) is valid.");
        OLogger.verbose(OPatchSession.PREREQ, buff);
        Path ohDir = WrapperFactory.getNioServiceWrapper().getPath(oracleHomePath, new String[0]);
        if (Files.isDirectory(ohDir, new LinkOption[0])) {
            if (!Files.isReadable(ohDir) || !Files.isWritable(ohDir)) {
                buff = new StringBuffer("Oracle Home is not readable/write-able.");
                OLogger.printlnOnLog(buff.toString());
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                resObj.addDetail(buff.toString());
                if (OPatchEnv.isContinueOnPrereqFailure()) {
                    for (String patchId : patchesToApplyList) {
                        OUSession.addPrereqResultForPatchesToReport(patchId, OPatchPatchPrereq.CHECK_ORACLE_HOME_SANITY, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
                    }
                }
                return resObj;
            }
        } else {
            buff = new StringBuffer("Oracle Home is not a directory.");
            OLogger.printlnOnLog(buff.toString());
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            resObj.addDetail(buff.toString());
            if (OPatchEnv.isContinueOnPrereqFailure()) {
                for (String patchId : patchesToApplyList) {
                    OUSession.addPrereqResultForPatchesToReport(patchId, OPatchPatchPrereq.CHECK_ORACLE_HOME_SANITY, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
                }
            }
            return resObj;
        }
        buff = new StringBuffer("\nOracle Home is readable and write-able.");
        OLogger.verbose(OPatchSession.PREREQ, buff);
        buff = new StringBuffer("\nChecking for inventory files...");
        OLogger.verbose(OPatchSession.PREREQ, buff);
        buff = new StringBuffer(oracleHomePath);
        buff.append(File.separator);
        buff.append(PrereqResource.getInventoryContentsXML());
        buff.append(File.separator);
        buff.append("comps.xml");
        Path compsFile = WrapperFactory.getNioServiceWrapper().getPath(buff.toString(), new String[0]);
        if (Files.exists(compsFile, new LinkOption[0])) {
            if (!Files.isReadable(compsFile)) {
                buff = new StringBuffer("File comps.xml is not readable");
                OLogger.printlnOnLog(buff.toString());
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                resObj.addDetail(buff.toString());
            }
            if (!Files.isWritable(compsFile)) {
                buff = new StringBuffer("File comps.xml is not write-able");
                OLogger.printlnOnLog(buff.toString());
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                resObj.addDetail(buff.toString());
            }
        } else {
            buff = new StringBuffer("File comps.xml does not exists.");
            OLogger.printlnOnLog(buff.toString());
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            resObj.addDetail(buff.toString());
        }
        if (resObj.getResult() != PrereqResult.ExecuteStatus.FAILED) {
            buff = new StringBuffer("\nVerified inventory files.");
            OLogger.verbose(OPatchSession.PREREQ, buff);
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            buff = new StringBuffer("Prereq checkOracleHome Passed");
            OLogger.debug(buff);
        } else if (OPatchEnv.isContinueOnPrereqFailure()) {
            for (String patchId : patchesToApplyList) {
                OUSession.addPrereqResultForPatchesToReport(patchId, OPatchPatchPrereq.CHECK_ORACLE_HOME_SANITY, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
            }
        }
        return resObj;
    }

    public static PrereqResult checkJDK(String oracleHomePath) {
        PrereqResult resObj = new PrereqResult();
        StringBuffer buff = new StringBuffer("PrereqAPI::checkJDK()");
        OLogger.debug(buff);
        if (!PrereqAPI.checkPath(oracleHomePath)) {
            buff = new StringBuffer("Oracle Home Path is not correct/valid.");
            OLogger.printlnOnLog(buff.toString());
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            resObj.addDetail(buff.toString());
            return resObj;
        }
        buff = new StringBuffer("\nOracle Home Path is valid.");
        OLogger.verbose(OPatchSession.PREREQ, buff);
        buff = new StringBuffer("\nChecking for JDK in the Oracle Home...");
        OLogger.verbose(OPatchSession.PREREQ, buff);
        String customJDKPath = System.getProperty("OPatch.JDK_HOME");
        if (customJDKPath != null && !customJDKPath.equals("")) {
            buff = new StringBuffer(customJDKPath);
        } else {
            buff = new StringBuffer(oracleHomePath);
            buff.append(File.separator);
            buff.append("jdk");
        }
        Path jdkDir = WrapperFactory.getNioServiceWrapper().getPath(buff.toString(), new String[0]);
        if (!Files.exists(jdkDir, new LinkOption[0]) || !Files.isDirectory(jdkDir, new LinkOption[0])) {
            buff = new StringBuffer("JDK directory \"" + buff.toString() + "\" is not present in the Oracle Home.");
            OLogger.printlnOnLog(buff.toString());
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            resObj.addDetail(buff.toString());
            return resObj;
        }
        if (customJDKPath != null && !customJDKPath.equals("")) {
            buff = new StringBuffer(customJDKPath);
            buff.append(File.separator);
            buff.append("bin");
        } else {
            buff = new StringBuffer(oracleHomePath);
            buff.append(File.separator);
            buff.append(PrereqResource.JDK_BIN_PATH);
        }
        Path jdkBinDir = WrapperFactory.getNioServiceWrapper().getPath(buff.toString(), new String[0]);
        if (!Files.exists(jdkBinDir, new LinkOption[0]) || !Files.isDirectory(jdkBinDir, new LinkOption[0])) {
            buff = new StringBuffer("jdk's bin directory \"" + buff.toString() + "\" does not exist in the Oracle Home.");
            OLogger.printlnOnLog(buff.toString());
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            resObj.addDetail(buff.toString());
            return resObj;
        }
        buff = new StringBuffer("\nJDK exists in the Oracle Home.");
        OLogger.verbose(OPatchSession.PREREQ, buff);
        resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        buff = new StringBuffer("Prereq checkJDK Passed");
        OLogger.debug(buff);
        return resObj;
    }

    public static PrereqResult checkJDKCompatibleOUI(String oracleHomePath) {
        PrereqResult resObj = new PrereqResult();
        StringBuffer buff = new StringBuffer("PrereqAPI::checkJDKCompareOUI()");
        OLogger.debug(buff);
        StringBuffer ouiLocation = null;
        int aruId = 0;
        String cmdOuiLocation = System.getProperty("OPatch.OUI_LOCATION");
        try {
            if (OPatchEnv.isNextGen() && ((aruId = OUIReplacer.Platform.getCurrentPlatform()) == 421 || aruId == 293 || aruId == 522)) {
                resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
                buff = new StringBuffer("Prereq checkJDKCompareOUI Skipped as platform id is " + aruId + "(MAC OSX) and not native lib is needed for NextGen environment.");
                OLogger.debug(buff);
                return resObj;
            }
        }
        catch (Throwable t) {
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            OLogger.printlnOnLog("Throwable occurred: " + t.getMessage());
            resObj.addDetail(t.getMessage());
            return resObj;
        }
        if (cmdOuiLocation == null || cmdOuiLocation.trim().length() == 0) {
            ouiLocation = new StringBuffer(oracleHomePath);
            ouiLocation.append(File.separator);
            ouiLocation.append("oui");
        } else {
            ouiLocation = new StringBuffer(cmdOuiLocation);
        }
        Path ouiLoc = WrapperFactory.getNioServiceWrapper().getPath(ouiLocation.toString(), new String[0]);
        if (!Files.exists(ouiLoc, new LinkOption[0])) {
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            buff = new StringBuffer("Prereq checkJDKCompareOUI not executed.");
            OLogger.debug(buff);
            return resObj;
        }
        String sLibraryLoc = OiixPathOps.concatPath((String)ouiLocation.toString(), (String)"lib");
        String dirName = OUIReplacer.Platform.getCurrentPlatformDirectoryName();
        sLibraryLoc = OiixPathOps.concatPath((String)sLibraryLoc, (String)dirName);
        sLibraryLoc = OiixPathOps.getNativeForm((String)sLibraryLoc);
        Path libraryLocation = WrapperFactory.getNioServiceWrapper().getPath(sLibraryLoc, new String[0]);
        if (Files.exists(libraryLocation, new LinkOption[0])) {
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            buff = new StringBuffer("Prereq checkJDKCompareOUI passed");
            OLogger.debug(buff);
        } else {
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            StringBuffer failBuff = new StringBuffer(OLogger.getString("OUI-68027", new Object[]{sLibraryLoc}));
            resObj.addDetail(failBuff.toString());
        }
        return resObj;
    }

    public static PrereqResult checkSystemSpace(String oracleHomePath, OneOffEntry[] oneOff, String[] patchLocation) {
        OneOffEntry[] installedOneOffs;
        PrereqResult resObj = new PrereqResult();
        boolean isSpaceAvailable = true;
        OiipgFileSystem pgFS = null;
        String sVolume = null;
        long spaceNeeded = 0L;
        StringBuffer buff = new StringBuffer("PrereqAPI::checkSystemSpace() ");
        OLogger.debug(buff);
        buff = new StringBuffer("\nFinding the total space needed...");
        OLogger.verbose(OPatchSession.PREREQ, buff);
        if (oneOff.length != patchLocation.length) {
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            buff = new StringBuffer("Number of oneOffs and patch locations does not match.\n");
            buff.append("Possible reasons: Duplicate patches are passed to OPatch Apply session. ");
            buff.append("Please remove the duplicate patch and retry patching");
            OLogger.printlnOnLog(buff.toString());
            resObj.addDetail(buff.toString());
            return resObj;
        }
        HashMap<String, String> patchIdLocMap = new HashMap<String, String>();
        for (int i2 = 0; i2 < oneOff.length; ++i2) {
            patchIdLocMap.put(oneOff[i2].getID(), patchLocation[i2]);
        }
        ArrayList<OneOffEntry> oneOffList = new ArrayList<OneOffEntry>(Arrays.asList(oneOff));
        try {
            installedOneOffs = PrereqAPI.getInstalledOneOff(oracleHomePath);
        }
        catch (Throwable e2) {
            installedOneOffs = new OneOffEntry[]{};
        }
        List<OneOffEntry> installedOneOffsList = Arrays.asList(installedOneOffs);
        oneOffList.removeAll(installedOneOffsList);
        for (OneOffEntry one : oneOffList) {
            PatchAction[] patchActions = one.getPatchActions();
            for (int i3 = 0; i3 < patchActions.length; ++i3) {
                PatchAction pa = patchActions[i3];
                spaceNeeded += pa.getSpaceNeeded((String)patchIdLocMap.get(one.getID()));
            }
        }
        long decimal = (spaceNeeded *= 2L) & 0xFFFFFL;
        double mg = (double)(spaceNeeded >> 20) + (double)decimal * Math.pow(2.0, -20.0);
        BigDecimal bd = new BigDecimal(mg);
        bd = bd.setScale(3, 4);
        OLogger.printlnOnLog("Space Needed : " + bd.doubleValue() + "MB");
        buff = new StringBuffer("\nTotal space needed for the patches are: ");
        buff.append(spaceNeeded);
        OLogger.verbose(OPatchSession.PREREQ, buff);
        buff = new StringBuffer("\nChecking if enough space is present on the disk...");
        OLogger.verbose(OPatchSession.PREREQ, buff);
        String opatchVersion = "";
        try {
            opatchVersion = OPatchACL.getOPatchVersion(new PrereqAPI());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!OPatchEnv.isWindows() || !opatchVersion.startsWith("12")) {
            isSpaceAvailable = OiipgFileSystem.isSpaceAvailable((long)spaceNeeded, (String)oracleHomePath);
        } else {
            Path f2;
            pgFS = new OiipgFileSystem();
            sVolume = pgFS.getVolumeName(oracleHomePath);
            if (sVolume != null && Files.exists(f2 = WrapperFactory.getNioServiceWrapper().getPath(sVolume, new String[0]), new LinkOption[0])) {
                FileStore store = null;
                try {
                    store = Files.getFileStore(f2);
                    if (store.getUnallocatedSpace() <= 0L) {
                        String curWorkDir = System.getProperty("OPatch.RUNNING_DIR");
                        if (curWorkDir == null || curWorkDir.equals("")) {
                            curWorkDir = oracleHomePath + File.separator + "OPatch";
                        }
                        String availableCmd = "cmd /C \"" + curWorkDir + File.separator + "opatch isspaceavailable -oh " + oracleHomePath + " " + "OPatch.SPACE_NEEDED" + "=" + spaceNeeded + "\"";
                        buff = new StringBuffer(" Call opatch command \"");
                        buff.append(availableCmd);
                        buff.append("\" to check system space.");
                        OLogger.printlnOnLog(buff.toString());
                        SystemCall.ExecReturn rt = SystemCall.runtimeExec(availableCmd);
                        if (rt.isOK()) {
                            String[] lines = rt.getNormalMessage().split("\n");
                            String ava = "true";
                            for (int i4 = 0; i4 < lines.length; ++i4) {
                                if (!lines[i4].startsWith("Invoking utility")) continue;
                                ava = lines[i4 + 1];
                                break;
                            }
                            isSpaceAvailable = Boolean.valueOf(ava);
                        }
                    } else {
                        isSpaceAvailable = OiipgFileSystem.isSpaceAvailable((long)spaceNeeded, (String)oracleHomePath);
                    }
                }
                catch (IOException e3) {
                    OLogger.debug(e3.getMessage());
                }
            }
        }
        if (!isSpaceAvailable) {
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            pgFS = new OiipgFileSystem();
            sVolume = pgFS.getVolumeName(oracleHomePath);
            long available = pgFS.getVolumeFreeSpace(sVolume);
            if (available >= 0L) {
                decimal = available & 0xFFFFFL;
                mg = (double)(available >> 20) + (double)decimal * Math.pow(2.0, -20.0);
                BigDecimal bda = new BigDecimal(mg);
                bda = bda.setScale(3, 4);
                OLogger.printlnOnLog("Space Usable : " + bda.doubleValue() + "MB");
            }
            buff = new StringBuffer("Required amount of space(");
            buff.append(bd.doubleValue());
            buff.append("MB) is not available.");
            OLogger.printlnOnLog(buff.toString());
            resObj.addDetail(buff.toString());
            if (OPatchEnv.isContinueOnPrereqFailure()) {
                for (String patchId : patchesToApplyList) {
                    OUSession.addPrereqResultForPatchesToReport(patchId, OPatchPatchPrereq.CHECK_SYSTEM_SPACE, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
                }
            }
            return resObj;
        }
        buff = new StringBuffer("\nRequired amount of space is availale on the disk");
        OLogger.verbose(OPatchSession.PREREQ, buff);
        resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        OLogger.debug(new StringBuffer("Prereq checkSystemSpace Passed"));
        return resObj;
    }

    public static PrereqResult checkRequiredLibs(String oracleHomePath, String[] requiredLibs) {
        if (OPatchEnv.isNextGen()) {
            PrereqResult resObj = new PrereqResult();
            StringBuffer buff = new StringBuffer("PrereqAPI::checkRequiredLibs()");
            OLogger.debug(buff);
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            buff = new StringBuffer("WARNING: [deprecation] Prereq checkRequiredLibs Passed: current behavior is to show \"Passed\" without checking");
            OLogger.debug(buff);
            return resObj;
        }
        PrereqResult resObj = new PrereqResult();
        StringBuffer buff = new StringBuffer("PrereqAPI::checkRequiredLibs()");
        OLogger.debug(buff);
        if (!PrereqAPI.checkPath(oracleHomePath)) {
            buff = new StringBuffer("Oracle Home Path is not correct/valid");
            OLogger.printlnOnLog(buff.toString());
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            resObj.addDetail(buff.toString());
            return resObj;
        }
        if (requiredLibs == null || requiredLibs.length == 0) {
            buff = new StringBuffer("Required Libs list is empty");
            OLogger.printlnOnLog(buff.toString());
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            resObj.addDetail(buff.toString());
            return resObj;
        }
        buff = new StringBuffer("\nChecking if ORACLE_HOME/oui/jlib exists...");
        OLogger.verbose(OPatchSession.PREREQ, buff);
        String cmdOuiLocation = System.getProperty("OPatch.OUI_LOCATION");
        StringBuffer ouiLocation = new StringBuffer();
        if (cmdOuiLocation != null && !cmdOuiLocation.equals("")) {
            ouiLocation.append(cmdOuiLocation);
        } else {
            ouiLocation.append(oracleHomePath);
            ouiLocation.append(File.separator);
            ouiLocation.append("oui");
        }
        StringBuffer ouiJlib = new StringBuffer(ouiLocation);
        ouiJlib.append(File.separator);
        ouiJlib.append("jlib");
        Path testOuiJlib = WrapperFactory.getNioServiceWrapper().getPath(ouiJlib.toString(), new String[0]);
        if (!Files.exists(testOuiJlib, new LinkOption[0])) {
            buff = new StringBuffer(ouiJlib.toString());
            buff.append(" directory does not exists.");
            OLogger.printlnOnLog(buff.toString());
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            resObj.addDetail(buff.toString());
            if (OPatchEnv.isContinueOnPrereqFailure()) {
                for (String patchId : patchesToApplyList) {
                    OUSession.addPrereqResultForPatchesToReport(patchId, OPatchPatchPrereq.CHECK_REQUIRED_LIBRARIES, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
                }
            }
            return resObj;
        }
        for (int i2 = 0; i2 < requiredLibs.length; ++i2) {
            String testLib = ouiJlib.toString() + File.separator + requiredLibs[i2];
            buff = new StringBuffer("\nChecking for ");
            buff.append(requiredLibs[i2] + "...");
            OLogger.verbose(OPatchSession.PREREQ, buff);
            Path fp = WrapperFactory.getNioServiceWrapper().getPath(testLib, new String[0]);
            if (Files.exists(fp, new LinkOption[0]) && !Files.isDirectory(fp, new LinkOption[0]) && Files.isReadable(fp)) continue;
            buff = new StringBuffer(testLib + " is not present/readable or is a directory.");
            OLogger.printlnOnLog(buff.toString());
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            resObj.addDetail(buff.toString());
        }
        if (resObj.getResult() != PrereqResult.ExecuteStatus.FAILED) {
            buff = new StringBuffer("\nAll the required libs are present");
            OLogger.verbose(OPatchSession.PREREQ, buff);
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            buff = new StringBuffer("Prereq checkRequiredLibs Passed");
            OLogger.debug(buff);
        } else if (OPatchEnv.isContinueOnPrereqFailure()) {
            for (String patchId : patchesToApplyList) {
                OUSession.addPrereqResultForPatchesToReport(patchId, OPatchPatchPrereq.CHECK_REQUIRED_LIBRARIES, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
            }
        }
        return resObj;
    }

    public static PrereqResult checkOUIVersionCompatible(String oracleHomePath) {
        PrereqResult resObj = new PrereqResult();
        StringBuffer buff = new StringBuffer("PrereqAPI::checkOUIVersionCompatible()");
        OLogger.debug(buff);
        boolean result = false;
        boolean calledFromOUI = Boolean.getBoolean("oracle.opatch.opatchprereq.calledFromOUI");
        OiiiVersion reqVer = null;
        OiiiVersion curVer = null;
        String curVerString = "";
        try {
            PrereqAPI.isNextGenOracleHome(oracleHomePath);
            reqVer = new OiiiVersion(OPatchSDK.getOUIVersionRequired());
            if (calledFromOUI) {
                buff = new StringBuffer(oracleHomePath);
                buff.append(File.separator);
                if (OPatchEnv.isNextGen()) {
                    buff.append(PrereqResource.OUI_JLIB_PATH);
                } else {
                    buff.append("oui").append(File.separator);
                    buff.append("jlib");
                }
                buff.append(File.separator);
                buff.append(PrereqResource.reqdLibs[0]);
                JarClassLoader jarLoader = new JarClassLoader(buff.toString());
                String propertiesFileName = jarLoader.formatPropertiesName("OUIVersion");
                InputStream in = jarLoader.getResourceAsStream(propertiesFileName);
                Properties ouiProperties = new Properties();
                if (in != null) {
                    ouiProperties.load(in);
                }
                curVerString = ouiProperties.getProperty("INSTALLER_VERSION");
            } else {
                ResourceBundle oResBundle = ResourceBundle.getBundle("OUIVersion");
                curVerString = oResBundle.getString("INSTALLER_VERSION");
            }
            curVer = new OiiiVersion(curVerString);
            if (curVer != null) {
                result = curVer.laterThan(reqVer) || curVer.equals(reqVer);
            }
        }
        catch (Throwable t) {
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            resObj.addDetail(t);
            buff = new StringBuffer("Exception occurred : " + t.getMessage());
            OLogger.printlnOnLog(buff.toString());
            return resObj;
        }
        if (result) {
            buff = new StringBuffer("\nThe required version of OUI is present in the Oracle Home.");
            OLogger.verbose(OPatchSession.PREREQ, buff);
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            buff = new StringBuffer("Prereq checkOUIVersionCompatible Passed");
            OLogger.debug(buff);
            return resObj;
        }
        buff = new StringBuffer("Required version of OUI is not present.");
        buff.append("The available version is " + curVer.getVerString());
        OLogger.printlnOnLog(buff.toString());
        resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
        resObj.addDetail(buff.toString());
        if (OPatchEnv.isContinueOnPrereqFailure()) {
            for (String patchId : patchesToApplyList) {
                OUSession.addPrereqResultForPatchesToReport(patchId, OPatchPatchPrereq.CHECK_OUI_VERSION_COMPATIBLE, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
            }
        }
        return resObj;
    }

    public static PrereqResult checkOPatchCompatibleAgainstOH(String oracleHomePath, List<PatchObject> apPatchObjects) {
        PrereqResult resObj = new PrereqResult();
        StringBuffer buff = new StringBuffer("PrereqAPI::checkOPatchCompatibleAgainstOH()");
        OLogger.debug(buff);
        boolean result = false;
        boolean skipPrereq = true;
        try {
            if (OPatchEnv.isDBHome(oracleHomePath) && !OPatchEnv.isNextGenHome() && !OPatchEnv.isCASFlow()) {
                OLogger.printlnOnLog(OLogger.INFO, "Running Prereq : checkOPatchCompatibleAgainstOH()");
                skipPrereq = false;
                boolean opatchJreExists = true;
                Path opatchJrePath = WrapperFactory.getNioServiceWrapper().getPath(oracleHomePath + File.separator + "OPatch" + File.separator + "jre", new String[0]);
                if (!Files.exists(opatchJrePath, new LinkOption[0])) {
                    opatchJreExists = false;
                }
                OiiiVersion baseVer = new OiiiVersion("23.0.0.0.0");
                OiiiVersion verCompare = new OiiiVersion(OPatchEnv.getOHDBVersion());
                OLogger.printlnOnLog(OLogger.INFO, "Base Version : " + baseVer.toString() + "\n && Current OH Version : " + verCompare.toString());
                if (verCompare.equals(baseVer) || verCompare.laterThan(baseVer)) {
                    if (!opatchJreExists) {
                        OLogger.printlnOnLog(OLogger.INFO, "Check For Higher Base Version Platforms : OPatch is compatible with current OH(Prereq pass):");
                        result = true;
                    } else {
                        OLogger.printlnOnLog(OLogger.WARNING, "Check For Higher Base Version Platforms : OPatch is not compatible with current OH.Please check proper OPatch is downloaded and unzipped(Prereq fail)");
                        OLogger.printlnOnConsole("Warning : OPatch is not compatible. Please download and use " + verCompare + " OPatch zip for the current oracle home\n");
                    }
                } else if (!verCompare.laterThan(baseVer)) {
                    if (opatchJreExists) {
                        OLogger.printlnOnLog(OLogger.INFO, "Check For Lower Base Version Platforms : OPatch is compatible with current OH(Prereq pass)");
                        result = true;
                    } else {
                        OLogger.printlnOnLog(OLogger.WARNING, "Check For Lower Base Version Platforms : OPatch is not compatible with current OH.Please check proper OPatch is downloaded and unzipped(Prereq fail)");
                        OLogger.printlnOnConsole("Warning : OPatch is not compatible. Please download and use " + verCompare + " OPatch zip for the current oracle home\n");
                    }
                }
            }
        }
        catch (Throwable t) {
            skipPrereq = true;
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            resObj.addDetail(t);
            buff = new StringBuffer("Exception occurred : " + t.getMessage());
            OLogger.printlnOnLog(buff.toString());
            return resObj;
        }
        if (skipPrereq) {
            OLogger.printlnOnLog("Prereq checkOPatchCompatibleAgainstOH SKIPPED");
            buff = new StringBuffer("DB Check conditions are not met");
            OLogger.verbose(OPatchSession.PREREQ, buff);
            resObj.setResult(PrereqResult.ExecuteStatus.SKIP);
            resObj.addDetail(buff.toString());
            buff = new StringBuffer("Prereq checkOPatchCompatibleAgainstOH SKIPPED");
            resObj.addDetail(buff.toString());
            OLogger.debug(buff);
            return resObj;
        }
        if (result) {
            OLogger.printlnOnLog("Prereq checkOPatchCompatibleAgainstOH Passed");
            buff = new StringBuffer("OPatch is compatible with OH.");
            OLogger.verbose(OPatchSession.PREREQ, buff);
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            resObj.addDetail(buff.toString());
            buff = new StringBuffer("Prereq checkOPatchCompatibleAgainstOH Passed");
            OLogger.debug(buff);
            return resObj;
        }
        OLogger.printlnOnLog("Prereq checkOPatchCompatibleAgainstOH FAILED");
        buff = new StringBuffer("OPatch is NOT compatible with OH");
        OLogger.printlnOnLog(buff.toString());
        resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
        resObj.addDetail(buff.toString());
        if (apPatchObjects.size() > 0) {
            if (OPatchEnv.isContinueOnPrereqFailure()) {
                for (PatchObject po : apPatchObjects) {
                    OUSession.addPrereqResultForPatchesToReport(po.getPatchID(), OPatchPatchPrereq.CHECK_OPATCH_OH_COMPATIBLE, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
                }
            }
        } else {
            OLogger.printlnOnLog("Prereq CheckOPatchCompatibleAgainstOH from CLI");
            OUSession.addPrereqResultToReport(OPatchPatchPrereq.CHECK_OPATCH_OH_COMPATIBLE, resObj);
        }
        return resObj;
    }

    public static PrereqResult checkOUILocation(String oracleHomePath) {
        PrereqResult resObj = new PrereqResult();
        StringBuffer buff = new StringBuffer("PrereqAPI::checkOUILocation()");
        OLogger.debug(buff);
        if (!PrereqAPI.checkPath(oracleHomePath)) {
            buff = new StringBuffer("Oracle Home Path is not correct/valid.");
            OLogger.printlnOnLog(buff.toString());
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            resObj.addDetail(buff.toString());
            return resObj;
        }
        String cmdOuiLocation = System.getProperty("OPatch.OUI_LOCATION");
        StringBuffer ouiLocation = new StringBuffer();
        if (cmdOuiLocation != null && !cmdOuiLocation.equals("")) {
            ouiLocation.append(cmdOuiLocation);
        } else {
            ouiLocation.append(oracleHomePath);
            ouiLocation.append(File.separator);
            ouiLocation.append("oui");
        }
        Path ouiPath = WrapperFactory.getNioServiceWrapper().getPath(ouiLocation.toString(), new String[0]);
        if (!Files.exists(ouiPath, new LinkOption[0]) || !Files.isDirectory(ouiPath, new LinkOption[0])) {
            buff = new StringBuffer("OUI is not present in the given Oracle Home.");
            OLogger.printlnOnLog(buff.toString());
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            resObj.addDetail(buff.toString());
            if (OPatchEnv.isContinueOnPrereqFailure()) {
                for (String patchId : patchesToApplyList) {
                    OUSession.addPrereqResultForPatchesToReport(patchId, OPatchPatchPrereq.CHECK_OUI_LOCATION, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
                }
            }
            return resObj;
        }
        buff = new StringBuffer("\nORACLE_HOME/oui exists.");
        OLogger.verbose(OPatchSession.PREREQ, buff);
        resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        buff = new StringBuffer("Prereq checkOUILocation Passed");
        OLogger.debug(buff);
        return resObj;
    }

    public static PrereqResult checkOraInstLocation(String oraInstLocation) {
        PrereqResult resObj = new PrereqResult();
        StringBuffer buff = new StringBuffer("PrereqAPI::checkOraInstLocation()");
        OLogger.debug(buff);
        if (OPatchEnv.isWindows()) {
            buff = new StringBuffer("There is no oraInst.loc file for Windows. So skipping this prereq check.");
            OLogger.printlnOnLog(buff.toString());
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            return resObj;
        }
        if (!PrereqAPI.checkPath(oraInstLocation)) {
            buff = new StringBuffer(oraInstLocation + " is not valid.");
            OLogger.printlnOnLog(buff.toString());
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            resObj.addDetail(buff.toString());
            if (OPatchEnv.isContinueOnPrereqFailure()) {
                for (String patchId : patchesToApplyList) {
                    OUSession.addPrereqResultForPatchesToReport(patchId, OPatchPatchPrereq.CHECK_CENTRAL_INVENTORY_POINTER_FILE, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
                }
            }
            return resObj;
        }
        Path oraInstFile = WrapperFactory.getNioServiceWrapper().getPath(oraInstLocation, new String[0]);
        if (Files.isDirectory(oraInstFile, new LinkOption[0]) || !Files.isReadable(oraInstFile)) {
            buff = new StringBuffer(oraInstLocation + " is not readable.");
            OLogger.printlnOnLog(buff.toString());
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            resObj.addDetail(buff.toString());
            if (OPatchEnv.isContinueOnPrereqFailure()) {
                for (String patchId : patchesToApplyList) {
                    OUSession.addPrereqResultForPatchesToReport(patchId, OPatchPatchPrereq.CHECK_CENTRAL_INVENTORY_POINTER_FILE, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
                }
            }
            return resObj;
        }
        buff = new StringBuffer("\nThe file \"");
        buff.append(oraInstLocation);
        buff.append("\" exists and is readable.");
        OLogger.verbose(OPatchSession.PREREQ, buff);
        resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        buff = new StringBuffer("Prereq checkOraInstLocation Passed");
        OLogger.debug(buff);
        return resObj;
    }

    public static PrereqResult checkCentralInventoryLocation(String centralInventoryLoc) {
        PrereqResult resObj = new PrereqResult();
        StringBuffer buff = new StringBuffer("PrereqAPI::checkCentralInventoryLocation()");
        OLogger.debug(buff);
        buff = new StringBuffer("\nChecking if the central inventory location exists...");
        OLogger.verbose(OPatchSession.PREREQ, buff);
        Path fp = WrapperFactory.getNioServiceWrapper().getPath(centralInventoryLoc, new String[0]);
        if (Files.exists(fp, new LinkOption[0])) {
            buff = new StringBuffer(centralInventoryLoc);
            buff.append(File.separator);
            buff.append("ContentsXML");
            buff.append(File.separator);
            buff.append("inventory.xml");
            Path f2 = WrapperFactory.getNioServiceWrapper().getPath(buff.toString(), new String[0]);
            buff = new StringBuffer("\nChecking for ");
            buff.append(f2.toAbsolutePath().toString());
            buff.append("...");
            OLogger.verbose(OPatchSession.PREREQ, buff);
            if (Files.exists(f2, new LinkOption[0])) {
                if (!Files.isReadable(f2)) {
                    buff = new StringBuffer(f2.toAbsolutePath().toString());
                    buff.append(" is not readable.");
                    OLogger.printlnOnLog(buff.toString());
                    resObj.addDetail(buff.toString());
                    resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                }
            } else {
                buff = new StringBuffer(f2.toAbsolutePath().toString());
                buff.append(" does not exists.");
                OLogger.debug(buff);
                resObj.addDetail(buff.toString());
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            }
        } else {
            buff = new StringBuffer("Directory does not exist : ");
            buff.append(centralInventoryLoc);
            OLogger.printlnOnLog(buff.toString());
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            resObj.addDetail(buff.toString());
        }
        if (resObj.getResult() != PrereqResult.ExecuteStatus.FAILED) {
            OLogger.debug(new StringBuffer("Prereq checkCentralInventoryLocation Passed"));
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        } else if (OPatchEnv.isContinueOnPrereqFailure()) {
            for (String patchId : patchesToApplyList) {
                OUSession.addPrereqResultForPatchesToReport(patchId, OPatchPatchPrereq.CHECK_CENTRAL_INVENTORY_LOCATION, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
            }
        }
        return resObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrereqResult checkCentralInventoryForOH(String oracleHomePath) {
        PrereqResult resObj = new PrereqResult();
        StringBuffer buff = new StringBuffer("PrereqAPI::checkCentralInventoryForOH()");
        OLogger.debug(buff);
        IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
        if (readServices.isLocked()) {
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            buff = new StringBuffer("Unable to create a RO session with the given Central Inventory.");
            buff.append("\nIt is already locked by some other instance");
            OLogger.printlnOnLog(buff.toString());
        } else {
            try {
                readServices.lock(oracleHomePath);
                if (!readServices.isInventoryLoaded()) {
                    readServices.loadInventory(oracleHomePath);
                }
                if (!readServices.isOracleHomeInfoExist()) {
                    buff = new StringBuffer(oracleHomePath);
                    buff.append(" is not registered with the given Central Inventory");
                    OLogger.printlnOnLog(buff.toString());
                    resObj.addDetail(buff.toString());
                    resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                    if (OPatchEnv.isContinueOnPrereqFailure()) {
                        for (String patchId : patchesToApplyList) {
                            OUSession.addPrereqResultForPatchesToReport(patchId, OPatchPatchPrereq.CHECK_CENTRAL_INVENTORY_FOR_ORACLE_HOME, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
                        }
                    }
                    PrereqResult prereqResult = resObj;
                    return prereqResult;
                }
                buff = new StringBuffer("\nOracle Home is registered with the given Central Inventory.");
                OLogger.verbose(OPatchSession.PREREQ, buff);
                resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
                OLogger.printlnOnLog("Prereq checkCentralInventoryForOH Passed");
                PrereqResult prereqResult = resObj;
                return prereqResult;
            }
            catch (RuntimeException e2) {
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                resObj.addDetail(e2);
                buff = new StringBuffer("Exception occurred");
                buff.append(e2.getMessage());
                OLogger.printStackTrace(e2);
                OLogger.printlnOnLog(buff.toString());
            }
            finally {
                readServices.release();
            }
        }
        return resObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrereqResult checkCentralInventoryForRWSession(String oracleHomePath) {
        PrereqResult resObj = new PrereqResult();
        StringBuffer buff = new StringBuffer("PrereqAPI::checkCentralInventoryForRWSession()");
        OLogger.debug(buff);
        buff = new StringBuffer("\nCreating a Read-Write session ...");
        OLogger.verbose(OPatchSession.PREREQ, buff);
        try {
            OPatchACL.setRetry(new PrereqAPI(), 0);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        IIPMRWServices rwServices = IPM.INSTANCE.getRWServices();
        if (rwServices.isLocked()) {
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            buff = new StringBuffer("Unable to create a RW session with the given Central Inventory.");
            buff.append("\nVerify if there are proper permissions or is it locked by some other instance?");
            OLogger.printlnOnLog(buff.toString());
            resObj.addDetail(buff.toString());
        } else {
            try {
                rwServices.lockWithoutCreatingPS(oracleHomePath);
                if (!rwServices.isInventoryLoaded()) {
                    rwServices.loadInventory(oracleHomePath);
                }
                if (!rwServices.isOracleHomeInfoExist()) {
                    buff = new StringBuffer("Unable to create a RW session with the given Central Inventory.");
                    buff.append("\nVerify if there are proper permissions or is it locked by some other instance?");
                    buff.append("\nAlso, verify if the given Central Inventory is correct.");
                    OLogger.printlnOnLog(buff.toString());
                    resObj.addDetail(buff.toString());
                    resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                } else {
                    buff = new StringBuffer("\nSession was created and got the information about the given Oracle Home.");
                    OLogger.verbose(OPatchSession.PREREQ, buff);
                    resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
                    OLogger.debug(new StringBuffer("Prereq checkCentralInventoryForRWSession Passed"));
                }
            }
            catch (RuntimeException e2) {
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                buff = new StringBuffer("Unable to create a RW session with the given Central Inventory.");
                buff.append("\nVerify if there are proper permissions or is it locked by some other instance?");
                OLogger.printlnOnLog(buff.toString());
                resObj.addDetail(buff.toString());
            }
            finally {
                rwServices.release();
            }
        }
        if (OPatchEnv.isContinueOnPrereqFailure() && resObj.getResult() == PrereqResult.ExecuteStatus.FAILED) {
            for (String patchId : patchesToApplyList) {
                OUSession.addPrereqResultForPatchesToReport(patchId, OPatchPatchPrereq.CHECK_CENTRAL_INVENTORY_FOR_READ_WRITE_SESSION, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
            }
        }
        return resObj;
    }

    public static PrereqResult checkPatchApplicableOnCurrentPlatform(String oracleHomePath, PatchObject[] patchObjects) {
        PrereqResult resObj = new PrereqResult();
        StringBuffer buff = new StringBuffer("PrereqAPI::checkPatchApplicableOnCurrentPlatform()");
        OLogger.debug(buff);
        IIPMReadServices readServices = null;
        try {
            readServices = PrereqSession.getReadServices(oracleHomePath);
        }
        catch (Throwable t) {
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            OLogger.printlnOnLog("Throwable occurred: " + t.getMessage());
            resObj.addDetail(t);
            return resObj;
        }
        resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        ArrayList<String> failedPatches = new ArrayList<String>();
        for (int pIter = 0; pIter < patchObjects.length; ++pIter) {
            int i2;
            buff = new StringBuffer("Reading the platforms for patch");
            buff.append(patchObjects[pIter].getPatchID());
            OLogger.debug(buff);
            Platform[] platforms = patchObjects[pIter].getPlatforms();
            boolean success = false;
            int aru_id = 0;
            if (platforms.length == 0) {
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                buff = new StringBuffer("List of platforms the patch (");
                buff.append(patchObjects[pIter].getPatchID());
                buff.append(" ) applicable is Empty");
                OLogger.printlnOnLog(buff.toString());
                resObj.addDetail(buff.toString());
                return resObj;
            }
            for (int i3 = 0; i3 < platforms.length; ++i3) {
                if (!platforms[i3].getID().equals(PrereqResource.GENERIC_PLATFORM_ID[0]) && !platforms[i3].getID().equals(PrereqResource.GENERIC_PLATFORM_ID[1])) continue;
                success = true;
                buff = new StringBuffer("\nGenereic Platform ID " + platforms[i3].getID());
                buff.append("is specified for patch : ");
                buff.append(patchObjects[pIter].getPatchID());
                OLogger.verbose(OPatchSession.PREREQ, buff);
                buff = new StringBuffer("Prereq checkPatchApplicableOnCurrentPlatform Passed on patch :");
                buff.append(patchObjects[pIter].getPatchID());
                OLogger.printlnOnLog(buff.toString());
                break;
            }
            if (success) continue;
            try {
                aru_id = PatchObjectUtil.getARU_ID(oracleHomePath, readServices);
            }
            catch (Throwable t) {
                aru_id = 0;
            }
            if (aru_id <= 0) {
                if (resObj.getResult() != PrereqResult.ExecuteStatus.NOT_EXECUTED) {
                    resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                    failedPatches.add(patchObjects[pIter].getPatchID());
                }
                buff = new StringBuffer("ARU_ID got for patch ( ");
                buff.append(patchObjects[pIter].getPatchID());
                buff.append(" ) is negative");
                OLogger.printlnOnLog(buff.toString());
                resObj.addDetail(buff.toString());
                continue;
            }
            boolean noFurtherCheck = true;
            StringBuffer sbAru = new StringBuffer();
            String sAru = "";
            while (noFurtherCheck) {
                sbAru = new StringBuffer();
                sbAru.append(aru_id);
                sAru = sbAru.toString();
                for (i2 = 0; i2 < platforms.length; ++i2) {
                    if (!platforms[i2].getID().equals(sAru)) continue;
                    success = true;
                    buff = new StringBuffer("\nPatch ");
                    buff.append(patchObjects[pIter].getPatchID());
                    buff.append(" : Platform ID matched is ");
                    buff.append(sAru);
                    OLogger.verbose(OPatchSession.PREREQ, buff);
                    buff = new StringBuffer("Prereq checkPatchApplicableOnCurrentPlatform Passed for patch : ");
                    buff.append(patchObjects[pIter].getPatchID());
                    OLogger.printlnOnLog(buff.toString());
                }
                noFurtherCheck = false;
            }
            if (success || aru_id <= 0 || resObj.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED) continue;
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            failedPatches.add(patchObjects[pIter].getPatchID());
            buff = new StringBuffer("Patch ( ");
            buff.append(patchObjects[pIter].getPatchID());
            buff.append(" ) is not applicable on current platform.\n");
            buff.append("Platform ID needed is : ");
            buff.append(sAru);
            buff.append("\nPlatform IDs supported by patch are: ");
            for (i2 = 0; i2 < platforms.length; ++i2) {
                buff.append(platforms[i2].getID() + " ");
            }
            OLogger.debug(buff);
            resObj.addDetail(buff.toString());
        }
        if (OPatchEnv.isContinueOnPrereqFailure()) {
            for (String patchId : failedPatches) {
                OUSession.addPrereqResultForPatchesToReport(patchId, OPatchPatchPrereq.CHECK_PATCH_APPLICABLE_ON_CURRENT_PLATFORM, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
            }
        }
        return resObj;
    }

    public static PrereqResult checkPatchShipHome(String[] patchLocation) {
        PrereqResult resObj = new PrereqResult();
        StringBuffer buff = new StringBuffer("PrereqAPI::checkPatchShipHome()");
        OLogger.debug(buff);
        for (int i2 = 0; i2 < patchLocation.length; ++i2) {
            if (!PrereqAPI.checkPath(patchLocation[i2])) {
                buff = new StringBuffer("Patch Location does not exists.");
                buff.append(patchLocation[i2]);
                OLogger.printlnOnLog(buff.toString());
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                resObj.addDetail(buff.toString());
                return resObj;
            }
            Path pLoc = WrapperFactory.getNioServiceWrapper().getPath(patchLocation[i2], new String[0]);
            if (Files.isDirectory(pLoc, new LinkOption[0])) {
                String actionsPath = PatchObject.getNonXMLActionFilePath(patchLocation[i2]);
                String xmlActionsPath = PatchObject.getActionFilePath(patchLocation[i2]);
                Path actionsFile = WrapperFactory.getNioServiceWrapper().getPath(actionsPath, new String[0]);
                Path xmlActionsFile = WrapperFactory.getNioServiceWrapper().getPath(xmlActionsPath, new String[0]);
                if (Files.exists(actionsFile, new LinkOption[0]) || Files.exists(xmlActionsFile, new LinkOption[0])) {
                    if (Files.exists(xmlActionsFile, new LinkOption[0])) {
                        actionsPath = xmlActionsPath;
                        actionsFile = xmlActionsFile;
                    }
                    if (!Files.isReadable(actionsFile)) {
                        buff = new StringBuffer(actionsPath + " is not readable");
                        OLogger.printlnOnLog(buff.toString());
                        resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                        resObj.addDetail(buff.toString());
                    } else {
                        buff = new StringBuffer("\nFile \"");
                        buff.append(actionsPath);
                        buff.append("\" is readable.");
                        OLogger.verbose(OPatchSession.PREREQ, buff);
                    }
                } else {
                    if (!Files.exists(xmlActionsFile, new LinkOption[0])) {
                        actionsPath = xmlActionsPath;
                    }
                    buff = new StringBuffer(actionsPath + " does not exists.");
                    OLogger.printlnOnLog(buff.toString());
                    resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                    resObj.addDetail(buff.toString());
                }
                String inventoryPath = PatchObject.getNonXMLInventoryFilePath(patchLocation[i2]);
                String xmlInventoryPath = PatchObject.getInventoryFilePath(patchLocation[i2]);
                Path inventoryFile = WrapperFactory.getNioServiceWrapper().getPath(inventoryPath, new String[0]);
                Path xmlInventoryFile = WrapperFactory.getNioServiceWrapper().getPath(xmlInventoryPath, new String[0]);
                if (Files.exists(inventoryFile, new LinkOption[0]) || Files.exists(xmlInventoryFile, new LinkOption[0])) {
                    if (Files.exists(xmlInventoryFile, new LinkOption[0])) {
                        inventoryPath = xmlInventoryPath;
                        inventoryFile = xmlInventoryFile;
                    }
                    if (!Files.isReadable(inventoryFile)) {
                        buff = new StringBuffer(inventoryPath + " does not exists.");
                        OLogger.printlnOnLog(buff.toString());
                        resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                        resObj.addDetail(buff.toString());
                    } else {
                        buff = new StringBuffer("\nFile \"");
                        buff.append(inventoryPath);
                        buff.append("\" is readable.");
                        OLogger.verbose(OPatchSession.PREREQ, buff);
                    }
                } else {
                    if (!Files.exists(xmlInventoryFile, new LinkOption[0])) {
                        inventoryPath = xmlInventoryPath;
                    }
                    buff = new StringBuffer(inventoryPath + " does not exists.");
                    OLogger.printlnOnLog(buff.toString());
                    resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                    resObj.addDetail(buff.toString());
                }
                if (!PrereqAPI.allFilesAreReadable(patchLocation[i2], resObj)) {
                    OLogger.printlnOnLog("Patch has files that can not be accessed");
                    resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                }
                buff = new StringBuffer(patchLocation[i2]);
                buff.append(File.separator);
                buff.append(PrereqResource.CUSTOM_SCRIPTS_PATH);
                Path pLocCustomScripts = WrapperFactory.getNioServiceWrapper().getPath(buff.toString(), new String[0]);
                if (Files.exists(pLocCustomScripts, new LinkOption[0]) && Files.isDirectory(pLocCustomScripts, new LinkOption[0])) {
                    String prePath = buff.toString() + File.separator + PrereqResource.getPreScriptFileName();
                    String postPath = buff.toString() + File.separator + PrereqResource.getPostScriptFileName();
                    Path preFile = WrapperFactory.getNioServiceWrapper().getPath(prePath, new String[0]);
                    if (Files.exists(preFile, new LinkOption[0])) {
                        if (!Files.isReadable(preFile)) {
                            buff = new StringBuffer(prePath + " is not readable");
                            OLogger.printlnOnLog(buff.toString());
                            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                            resObj.addDetail(buff);
                        } else {
                            buff = new StringBuffer("\nScript \"");
                            buff.append(prePath);
                            buff.append("\" exists and is readable.");
                            OLogger.verbose(OPatchSession.PREREQ, buff);
                        }
                    } else {
                        buff = new StringBuffer("\nThere is no pre script.");
                        buff.append(" Patch doesnot perform any pre actions.");
                        OLogger.verbose(OPatchSession.PREREQ, buff);
                        OLogger.printlnOnLog("Script does not exists : " + prePath);
                    }
                    Path postFile = WrapperFactory.getNioServiceWrapper().getPath(postPath, new String[0]);
                    if (Files.exists(postFile, new LinkOption[0])) {
                        if (!Files.isReadable(postFile)) {
                            buff = new StringBuffer(postPath + " is not readable");
                            OLogger.printlnOnLog(buff.toString());
                            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                            resObj.addDetail(buff);
                            continue;
                        }
                        buff = new StringBuffer("\nScript \"");
                        buff.append(postPath);
                        buff.append("\" exists and is readable.");
                        OLogger.verbose(OPatchSession.PREREQ, buff);
                        continue;
                    }
                    buff = new StringBuffer("\nThere is no post script.");
                    buff.append(" Patch doesnot perform any post actions.");
                    OLogger.verbose(OPatchSession.PREREQ, buff);
                    OLogger.printlnOnLog("Script does not exists : " + postPath);
                    continue;
                }
                if (!Files.exists(pLocCustomScripts, new LinkOption[0]) || Files.isDirectory(pLocCustomScripts, new LinkOption[0])) continue;
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                buff = new StringBuffer(pLocCustomScripts.toAbsolutePath().toString());
                buff.append(" path is not a directory");
                OLogger.printlnOnLog(buff.toString());
                resObj.addDetail(buff.toString());
                continue;
            }
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            buff = new StringBuffer(patchLocation[i2]);
            buff.append(" is not a valid directory");
            OLogger.printlnOnLog(buff.toString());
            resObj.addDetail(buff.toString());
        }
        if (resObj.getResult() != PrereqResult.ExecuteStatus.FAILED) {
            buff = new StringBuffer("\nSpecified Patch Shiphome is valid.");
            OLogger.verbose(OPatchSession.PREREQ, buff);
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            OLogger.debug(new StringBuffer("Prereq checkPatchShipHome Passed"));
        } else if (OPatchEnv.getSessionType().equalsIgnoreCase("prereq")) {
            ZOPErrorMessage.printErrorMessage(43);
        }
        return resObj;
    }

    private static boolean allFilesAreReadable(String patchLocation, PrereqResult resObj) {
        try {
            PrereqAPI.getAllFiles(patchLocation);
            return true;
        }
        catch (Exception e2) {
            StringBuffer buff = new StringBuffer(e2.getMessage());
            OLogger.printlnOnLog(buff.toString());
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            resObj.addDetail(buff.toString());
            return false;
        }
    }

    private static void getAllFiles(String dirPath) throws Exception {
        Path directory = WrapperFactory.getNioServiceWrapper().getPath(dirPath, new String[0]);
        DirectoryStream<Path> fList = null;
        try {
            fList = Files.newDirectoryStream(directory);
        }
        catch (IOException e2) {
            OLogger.debug(e2.getMessage());
        }
        for (Path file : fList) {
            if (Files.exists(file, new LinkOption[0]) && !Files.isReadable(file)) {
                throw new Exception("Please check patch for file permissions.");
            }
            if (!Files.isDirectory(file, new LinkOption[0])) continue;
            PrereqAPI.getAllFiles(file.toAbsolutePath().toString());
        }
    }

    public static PrereqResult checkSystemCommandAvailable(String oracleHomePath, OneOffEntry oneOff, String[] executables) {
        PrereqResult resObj = new PrereqResult();
        StringBuffer buff = new StringBuffer("PrereqAPI::checkSystemCommandAvailable()");
        OLogger.debug(buff);
        PatchAction[] actions = oneOff.getPatchActions();
        boolean needArchive = false;
        boolean needSqlplus = false;
        boolean needPtlPatch = false;
        boolean needMake = false;
        boolean needFuser = false;
        boolean needMkPatch = false;
        boolean hasSqlplus = true;
        boolean hasArchive = true;
        boolean hasPtlPatch = true;
        boolean hasMake = true;
        boolean hasFuser = true;
        boolean hasMkPatch = true;
        needFuser = Rules.shouldSearchOrInvokeFuser(executables);
        for (int i2 = 0; i2 < actions.length; ++i2) {
            PatchAction pa = actions[i2];
            if (pa instanceof ArchiveAction && !OPatchEnv.isWindows()) {
                needArchive = true;
                continue;
            }
            if (pa instanceof MakeAction && !OPatchEnv.isWindows()) {
                needMake = true;
                continue;
            }
            if (pa instanceof hotpatchAction) {
                needMkPatch = Rules.isMkPatchRequired();
                needSqlplus = true;
                continue;
            }
            if (pa instanceof sqlAction || pa instanceof sqlprocAction) {
                needSqlplus = true;
                continue;
            }
            if (!(pa instanceof portalAction)) continue;
            needPtlPatch = true;
        }
        OPatchProperty opp = new OPatchProperty();
        String cmd = "";
        boolean cmdNotFound = false;
        if (needFuser) {
            hasFuser = opp.hasFuserCommand();
            buff = new StringBuffer("\nFuser command is needed");
            OLogger.verbose(OPatchSession.PREREQ, buff);
        }
        if (needArchive) {
            hasArchive = opp.hasArchiveCommand();
            buff = new StringBuffer("\nArchive command is needed");
            OLogger.verbose(OPatchSession.PREREQ, buff);
        }
        if (needMake) {
            hasMake = opp.hasMakeCommand();
            buff = new StringBuffer("\nMake commands is needed");
            OLogger.verbose(OPatchSession.PREREQ, buff);
        }
        if (needMkPatch) {
            hasMkPatch = opp.hasMkPatchCommand();
            buff = new StringBuffer("\nMkpatch command is needed");
            OLogger.verbose(OPatchSession.PREREQ, buff);
        }
        if (needSqlplus) {
            hasSqlplus = opp.hasSqlplusCommand();
            buff = new StringBuffer("\nSqlplus command is needed");
            OLogger.verbose(OPatchSession.PREREQ, buff);
        }
        if (needPtlPatch) {
            hasPtlPatch = opp.hasPtlpatchCommand();
            buff = new StringBuffer("\nPtlpatch command is needed");
            OLogger.verbose(OPatchSession.PREREQ, buff);
        }
        buff = new StringBuffer();
        buff.append("\nPatchObject:  Patch will need to following commands:\n");
        buff.append("--------------------------------------------------------------------\n");
        buff.append("  Need    fuser   archive   make   mkpatch   sqlplus    ptlpatch\n");
        buff.append("          ");
        buff.append(needFuser);
        buff.append("    ");
        buff.append(needArchive);
        buff.append("    ");
        buff.append(needMake);
        buff.append("    ");
        buff.append(needMkPatch);
        buff.append("    ");
        buff.append(needSqlplus);
        buff.append("    ");
        buff.append(needPtlPatch);
        buff.append("\n");
        buff.append("--------------------------------------------------------------------\n");
        buff.append("  Have    fuser   archive   make   mkpatch   sqlplus    ptlpatch\n");
        buff.append("          ");
        buff.append(hasFuser);
        buff.append("    ");
        buff.append(hasArchive);
        buff.append("    ");
        buff.append(hasMake);
        buff.append("    ");
        buff.append(hasMkPatch);
        buff.append("    ");
        buff.append(hasSqlplus);
        buff.append("    ");
        buff.append(hasPtlPatch);
        buff.append("\n");
        OLogger.debug(buff);
        if (!hasFuser) {
            buff = new StringBuffer("Missing command :");
            buff.append(opp.getLiteralFuserCommand());
            OLogger.printlnOnLog(buff.toString());
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            resObj.addDetail(buff.toString());
        }
        if (!hasArchive) {
            buff = new StringBuffer("Missing command :");
            buff.append(opp.getLiteralArchiveCommand());
            OLogger.printlnOnLog(buff.toString());
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            resObj.addDetail(buff.toString());
        }
        if (!hasMake) {
            buff = new StringBuffer("Missing command :");
            buff.append(opp.getLiteralMakeCommand());
            OLogger.printlnOnLog(buff.toString());
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            resObj.addDetail(buff.toString());
        }
        if (!hasMkPatch) {
            buff = new StringBuffer("Missing command :");
            buff.append(opp.getLiteralMkPatchCommand());
            OLogger.printlnOnLog(buff.toString());
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            resObj.addDetail(buff.toString());
        }
        if (!hasSqlplus) {
            buff = new StringBuffer("Missing command :");
            buff.append(opp.getLiteralSqlplusCommand());
            OLogger.printlnOnLog(buff.toString());
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            resObj.addDetail(buff.toString());
        }
        if (!hasPtlPatch) {
            buff = new StringBuffer("Missing command :");
            buff.append(opp.getLiteralPtlpatchCommand());
            OLogger.printlnOnLog(buff.toString());
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            resObj.addDetail(buff.toString());
        }
        if (resObj.getResult() != PrereqResult.ExecuteStatus.FAILED) {
            buff = new StringBuffer("\nAll the required commands are available.");
            OLogger.verbose(OPatchSession.PREREQ, buff);
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            OLogger.debug(new StringBuffer("Prereq checkSystemCommandAvailable Passed"));
        }
        if (OPatchEnv.isContinueOnPrereqFailure() && resObj.getResult() == PrereqResult.ExecuteStatus.FAILED) {
            OUSession.addPrereqResultForPatchesToReport(oneOff.getID(), OPatchPatchPrereq.CHECK_SYSTEM_COMMANDS_AVAILABLE, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
        }
        return resObj;
    }

    public static PrereqResult checkApplicableIgnoreMisingOptionalComp(String oracleHomePath, PatchObject[] patchObjects) {
        PrereqResult resObj = new PrereqResult();
        resObj.resultValue = PrereqResult.ExecuteStatus.PASSED;
        StringBuffer buff = new StringBuffer("PrereqAPI::checkApplicableIgnoreMisingOptionalComp() checking if ");
        buff.append("each Action is applicable or not. Ignore missing optional comps.");
        OLogger.debug(buff);
        buff = new StringBuffer("");
        boolean ok = true;
        Vector missingRequiredComps = new Vector();
        ArrayList<Applicable> nonApplicableActions = new ArrayList<Applicable>();
        for (int i2 = 0; i2 < patchObjects.length; ++i2) {
            PatchAction pa;
            PatchObject patchObject = patchObjects[i2];
            String patchLocation = patchObject.getPatchLocation();
            String patchID = patchObject.getPatchID();
            buff = new StringBuffer("checkApplicableIgnoreMisingOptionalComp() ");
            buff.append("on patch ").append(patchID);
            OLogger.debug(buff);
            Vector presentComponents = new Vector();
            PrereqAPI.checkOptionalComponents(oracleHomePath, patchObject, presentComponents);
            for (Object obj : presentComponents) {
                if (!(obj instanceof PatchComponent)) continue;
                PatchComponent pc = (PatchComponent)obj;
                PatchAction[] presentPatchActions = patchObject.getPatchActionsForComponent(pc);
                for (int j2 = 0; j2 < presentPatchActions.length; ++j2) {
                    Applicable ap;
                    boolean actionApplicable;
                    pa = presentPatchActions[j2];
                    if (!(pa instanceof Applicable) || (actionApplicable = (ap = (Applicable)((Object)pa)).applicable(oracleHomePath, patchLocation))) continue;
                    nonApplicableActions.add(ap);
                }
            }
            if (nonApplicableActions.size() <= 0) continue;
            buff = new StringBuffer("\nPatch " + patchID + ":\n");
            for (int j3 = 0; j3 < nonApplicableActions.size(); ++j3) {
                Object obj = nonApplicableActions.get(j3);
                if (!(obj instanceof Applicable)) continue;
                Applicable ap = (Applicable)obj;
                String owningComp = "";
                if (obj instanceof PatchAction) {
                    pa = (PatchAction)obj;
                    owningComp = pa.getOwningComponentDesc();
                }
                String desc = ap.getApplicableDesc(oracleHomePath, owningComp);
                buff.append(desc).append("\n");
            }
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            resObj.addDetail(buff.toString());
            if (OPatchEnv.getSessionType().equalsIgnoreCase("prereq")) {
                ZOPErrorMessage.printErrorMessage(46);
            }
            OLogger.printlnOnLog(buff.toString());
        }
        return resObj;
    }

    public static PrereqResult checkComponents(String oracleHomePath, PatchObject[] patchObjects) {
        PrereqResult resObj = new PrereqResult();
        StringBuffer buff = new StringBuffer("PrereqAPI::checkComponents() checking if each Component is valid or not.");
        for (int pIter = 0; pIter < patchObjects.length; ++pIter) {
            Vector includedPatchComponents = new Vector();
            try {
                PrereqResult compResObj = PrereqAPI.checkComponents(oracleHomePath, patchObjects[pIter], includedPatchComponents);
                if (compResObj.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED) {
                    buff = new StringBuffer("Prereq checkComponents returned without execution. ");
                    OLogger.printlnOnLog(buff.toString());
                    return compResObj;
                }
                if (compResObj.getResult() != PrereqResult.ExecuteStatus.FAILED) continue;
                if (OPatchEnv.getSessionType().equalsIgnoreCase("prereq")) {
                    ZOPErrorMessage.printErrorMessage(45);
                }
                buff = new StringBuffer("Prereq checkComponents finds no component match for patch \"" + patchObjects[pIter].getPatchID() + "\" and Oracle Home \"" + oracleHomePath + "\"");
                OLogger.debug(buff.toString());
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                resObj.addDetail(compResObj.getResultDetails());
                continue;
            }
            catch (NoOpPatchException e2) {
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                resObj.addDetail("Patch \"" + patchObjects[pIter].getPatchID() + "\" is a no-op patch.");
            }
        }
        if (resObj.getResult() != PrereqResult.ExecuteStatus.FAILED) {
            buff = new StringBuffer("\nAll the patches components are installed");
            OLogger.verbose(OPatchSession.PREREQ, buff);
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            OLogger.debug(new StringBuffer("Prereq checkComponent Passed"));
        }
        return resObj;
    }

    public static PrereqResult checkFileVersionFormat(String oracleHomePath, PatchObject[] patchObjects) {
        StringBuffer buff = new StringBuffer("PrereqAPI::checkFileVersionFormat()");
        OLogger.debug(buff);
        PrereqResult checkFormatResObj = new PrereqResult();
        if (patchObjects == null) {
            checkFormatResObj.addDetail("Could not create OPatch based Patch Objects based on the input.");
            checkFormatResObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            return checkFormatResObj;
        }
        boolean errorFlag = false;
        StringBuffer errorVerFormat = new StringBuffer("[ ");
        for (int i2 = 0; i2 < patchObjects.length; ++i2) {
            String patchType = patchObjects[i2].getPatchType();
            if (!patchType.equals("snowball")) continue;
            OLogger.printlnOnLogAndVerbose("Verifying if Patch \"" + patchObjects[i2].getPatchID() + "\" has proper file versions format.");
            PatchAction[] pa = PrereqAPI.getPatchActionsForPresentComponents(oracleHomePath, OPatchEnv.getSessionType(), patchObjects[i2].toOneOffEntry(oracleHomePath));
            for (int j2 = 0; pa != null && j2 < pa.length; ++j2) {
                if (!(pa[j2] instanceof CopyAction)) continue;
                CopyAction ca = (CopyAction)pa[j2];
                String fileVer = ca.getFileVersion();
                OLogger.printlnOnLogAndVerbose("File Version of the copy action \"" + ca.getParentFilePath(oracleHomePath) + "\" is:" + fileVer);
                if (Pattern.matches("\\d+\\.\\d+", fileVer)) continue;
                errorVerFormat.append(patchObjects[i2].getPatchID() + " ");
                OLogger.printlnOnLogAndVerbose("Copy action \"" + ca.getParentFilePath(oracleHomePath) + "\" has error version format.");
                errorFlag = true;
            }
        }
        errorVerFormat.append("] ");
        if (errorFlag) {
            buff = new StringBuffer("The file version format of copy actions ");
            buff.append("is not right for the following patch(es) ");
            buff.append(errorVerFormat.toString());
            buff.append(".\nPlease contact Oracle Support for further details.");
            checkFormatResObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            checkFormatResObj.addDetail(buff.toString());
        } else {
            checkFormatResObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        }
        return checkFormatResObj;
    }

    public static Map<CopyAction, String> getCopyActionMap(String oracleHomePath) throws Throwable {
        HashMap m2 = new HashMap();
        int modelCode = PatchingModel.returnModelCode(oracleHomePath);
        if (modelCode == 2) {
            IIPMReadServices readServices = null;
            readServices = PrereqSession.getReadServices(oracleHomePath);
            if (!readServices.isInventoryLoaded()) {
                throw new RuntimeException("Unable to get a Inventory Session object");
            }
            m2 = OPatchSessionHelper.getCopyActionVer(readServices);
        } else {
            m2 = new HashMap();
        }
        return m2;
    }

    public static boolean checkFileVersion(String oracleHomePath, CopyAction copy, Map<CopyAction, String> m2) throws Throwable {
        int modelCode = PatchingModel.returnModelCode(oracleHomePath);
        if (modelCode == 2) {
            String destVer;
            String srcVer = copy.getFileVersion();
            int retVal = OPatchSessionHelper.isGreaterDecimal(srcVer, destVer = m2.get(copy));
            return retVal == 1 && retVal != 0;
        }
        return true;
    }

    public static boolean checkFileVersion(String oracleHomePath, CopyAction copy, HashMap<String, String> m2) throws Throwable {
        int modelCode = PatchingModel.returnModelCode(oracleHomePath);
        if (modelCode == 2) {
            String destVer;
            String srcVer = copy.getFileVersion();
            int retVal = OPatchSessionHelper.isGreaterDecimal(srcVer, destVer = m2.get(copy.getFilename()));
            return retVal == 1 && retVal != 0;
        }
        return true;
    }

    public static PrereqResult checkFileVersions(String oracleHomePath, PatchObject[] patchObjects, Vector store) {
        StringBuffer buff = new StringBuffer("PrereqAPI::checkFileVersions()");
        OLogger.debug(buff);
        PrereqResult resObj = new PrereqResult();
        ProcessFileVersions processor = new ProcessFileVersions();
        int modelCode = PatchingModel.returnModelCode(oracleHomePath);
        if (modelCode != 2) {
            buff = new StringBuffer("The Oracle Home \"" + oracleHomePath + "\" does not support \"" + PatchingModel.getModelType(2) + "\"");
            buff.append("\nThis prereq is not applicable for this home.");
            resObj.addDetail(buff.toString());
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            if (OPatchEnv.isFATwoPhase()) {
                processor.computeComps(patchObjects);
            }
            return resObj;
        }
        PrereqResult patchModelResObj = PrereqAPI.checkPatchingModel(oracleHomePath, patchObjects);
        if (patchModelResObj.getResult() == PrereqResult.ExecuteStatus.FAILED || patchModelResObj.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED) {
            return patchModelResObj;
        }
        if (patchObjects == null) {
            resObj.addDetail("Could not create OPatch based Patch Objects based on the input.");
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            return resObj;
        }
        Map<Object, Object> m2 = new HashMap();
        boolean fv_exist = false;
        if (OPatchEnv.isFATwoPhase()) {
            fv_exist = ProcessFileVersions.existFvOh(oracleHomePath);
        }
        if (fv_exist) {
            OLogger.printlnOnLogAndVerbose("\nCheckFileVersions: Parse cached fv_oh to get HashTable of all installed Snowball Copy Actions Filenames with their versions...");
            try {
                NApplyDataSerializer serializer = new NApplyDataSerializer();
                m2 = serializer.deserializeFileVersion(OPatchEnv.getPrereqResultFileLoc(oracleHomePath) + File.separator + "fv_oh.txt");
            }
            catch (Exception e2) {
                e2.printStackTrace();
                OLogger.printlnOnLogAndVerbose("Unable to parse cached OH files.");
                fv_exist = false;
            }
        }
        IIPMReadServices readServices = null;
        try {
            readServices = PrereqSession.getReadServices(oracleHomePath);
        }
        catch (Throwable t) {
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            OLogger.debug(new StringBuffer("Throwable occurred: " + t.getMessage()));
            resObj.addDetail(t);
            return resObj;
        }
        if (!fv_exist) {
            OLogger.printlnOnLogAndVerbose("\nCheckFileVersions: Cached fv_oh does not exist or is invalid, re-generate it.");
            if (!readServices.isInventoryLoaded()) {
                buff = new StringBuffer("Unable to get Inventory Session object");
                resObj.addDetail(buff.toString());
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                return resObj;
            }
            m2 = OPatchSessionHelper.getCopyFileVer(readServices);
        }
        Arrays.sort(patchObjects, new Comparator<PatchObject>(){

            @Override
            public int compare(PatchObject o1, PatchObject o2) {
                return o1.getPatchLocation().compareTo(o2.getPatchLocation());
            }
        });
        HashMap<String, String> m_bk = new HashMap<String, String>(m2);
        OneOffEntry[] pi = new OneOffEntry[patchObjects.length];
        for (int i2 = 0; i2 < patchObjects.length; ++i2) {
            pi[i2] = patchObjects[i2].toOneOffEntry(oracleHomePath);
        }
        FVData fvData = OPatchSessionHelper.getCopyFileVerForPi(pi);
        Map<String, String> mpi = fvData.getCopyMap();
        Map<String, List<String>> mpi_delete = fvData.getDeleteMap();
        HashMap<String, String> activeDelete = new HashMap<String, String>();
        boolean errorFlag = false;
        StringBuffer errorBuff = new StringBuffer();
        OLogger.printlnOnLogAndVerbose("\nThis Prereq will check only for copy actions (file version) of present components (mentioned by patches) in Oracle Home.");
        OLogger.printlnOnLogAndVerbose("For component & file related checks, Please use 'opatch prereq checkApplicable'.\n");
        for (int i3 = 0; i3 < patchObjects.length; ++i3) {
            String patchType = patchObjects[i3].getPatchType();
            if (!patchType.equals("snowball")) continue;
            long aiCount = 0L;
            long noOpCount = 0L;
            OLogger.printlnOnLogAndVerbose("Verifying if Patch \"" + patchObjects[i3].getPatchID() + "\" has some file versions greater than the one installed in Oracle Home and among patch(es)...");
            for (PatchComponent pc : patchObjects[i3].getIncludedPatchComponents()) {
                for (OrderedPatchAction ai : pc.getSnowballOrderedActions()) {
                    List<String> intraDelete;
                    String ohVer;
                    String value;
                    String file;
                    OrderedPatchAction act;
                    ++aiCount;
                    if (ai instanceof CopyAction) {
                        int intraVal;
                        act = (CopyAction)ai;
                        file = ((CopyAction)act).getFilename();
                        value = ((CopyAction)act).getFileVersion();
                        ohVer = (String)m2.get(file);
                        String intraVer = mpi.get(file);
                        intraDelete = mpi_delete.get(file);
                        OLogger.log(OLogger.FINE, "File for the copy action is : " + ((CopyAction)act).getParentFilePath(oracleHomePath));
                        OLogger.log(OLogger.FINE, "Source Version of the copy action is : " + value);
                        OLogger.log(OLogger.FINE, "Destination Version of the copy action is : " + (ohVer == null ? "No version available" : ohVer));
                        boolean deleteFlag = null == intraVer;
                        int retVal = OPatchSessionHelper.isGreaterDecimal(value, ohVer);
                        int n2 = intraVal = null == intraVer ? -1 : OPatchSessionHelper.isGreaterDecimal(value, intraVer);
                        if (retVal == 1 && intraVal > -1 && null != intraDelete) {
                            if (intraDelete.contains("lemax.version")) {
                                deleteFlag = true;
                            } else {
                                for (String ver : intraDelete) {
                                    if (ver.startsWith("le")) {
                                        String deleteVer = ver.substring(2);
                                        int val = OPatchSessionHelper.isGreaterDecimal(deleteVer, value);
                                        if (val != 1) continue;
                                        if (!OPatchSessionHelper.isBeingIntraDeleted(patchObjects, i3, file, value)) break;
                                        deleteFlag = true;
                                        break;
                                    }
                                    int val = OPatchSessionHelper.isGreaterDecimal(ver, value);
                                    if (val != 0) continue;
                                    if (!OPatchSessionHelper.isBeingIntraDeleted(patchObjects, i3, file, value)) break;
                                    deleteFlag = true;
                                    break;
                                }
                            }
                        }
                        if (retVal != 1 || intraVal == -1 || deleteFlag) {
                            ++noOpCount;
                            if (retVal != 1) {
                                OLogger.printlnOnLogAndVerbose("Copy action \"" + ((CopyAction)act).getParentFilePath(oracleHomePath) + "\" has version \"" + value + "\" lesser or equal to version \"" + ohVer + "\" of the same file in Oracle Home.");
                                continue;
                            }
                            if (intraVal == -1) {
                                OLogger.printlnOnLogAndVerbose("Copy action \"" + ((CopyAction)act).getParentFilePath(oracleHomePath) + "\" has version \"" + value + "\" lesser or equal to version \"" + intraVer + "\" of the same file touched by patch in Oracle Home.");
                                continue;
                            }
                            if (!deleteFlag) continue;
                            OLogger.printlnOnLogAndVerbose("Copy action \"" + ((CopyAction)act).getParentFilePath(oracleHomePath) + "\" is marked for delete.");
                            continue;
                        }
                        m2.put(file, value);
                        OLogger.printlnOnLogAndVerbose("Copy action \"" + ((CopyAction)act).getParentFilePath(oracleHomePath) + "\" from patch \"" + patchObjects[i3].getPatchID() + "\" has version \"" + value + "\" set in map as it is now the higher version.");
                        continue;
                    }
                    if (!(ai instanceof DeleteAction)) continue;
                    act = (DeleteAction)ai;
                    file = ((DeleteAction)act).getFileName();
                    value = ((DeleteAction)act).getFileVersion();
                    ohVer = (String)m2.get(file);
                    Path dstFile = WrapperFactory.getNioServiceWrapper().getPath(((DeleteAction)act).getParentFilePath(oracleHomePath), new String[0]);
                    intraDelete = mpi_delete.get(file);
                    if (ohVer != null) {
                        if (((DeleteAction)act).isHasFileVersion()) {
                            if (value.startsWith("le")) {
                                String deleteVer = value.substring(2);
                                int retVal = OPatchSessionHelper.isGreaterDecimal(deleteVer, ohVer);
                                if (retVal == 1) {
                                    buff = new StringBuffer("Delete Action " + ((DeleteAction)act).getParentFilePath(oracleHomePath) + " version is higher than --> " + ohVer + ".");
                                    buff.append("\nWe will remove the version " + ohVer + " in the oh.");
                                    OLogger.debug(buff);
                                    m2.remove(file);
                                    continue;
                                }
                                ++noOpCount;
                                OLogger.printlnOnLogAndVerbose("Delete action \"" + ((DeleteAction)act).getParentFilePath(oracleHomePath) + "\" has version \"" + value + "\" lesser than version \"" + ohVer + "\" of the same file touched by patch in Oracle Home.");
                                continue;
                            }
                            if (null != intraDelete && !intraDelete.contains(value)) {
                                ++noOpCount;
                                continue;
                            }
                            int retVal = OPatchSessionHelper.isGreaterDecimal(value, ohVer);
                            if (retVal == 0) {
                                buff = new StringBuffer("Delete Action " + ((DeleteAction)act).getParentFilePath(oracleHomePath) + " version is higher than --> " + ohVer + ".");
                                buff.append("\nWe will remove the version " + ohVer + " in the oh.");
                                OLogger.debug(buff);
                                m2.remove(file);
                                continue;
                            }
                            ++noOpCount;
                            continue;
                        }
                        m2.remove(file);
                        OLogger.printlnOnLogAndVerbose("Delete action \"" + ((DeleteAction)act).getParentFilePath(oracleHomePath) + "\" has version \"" + value + "\" match with version \"" + ohVer + "\" of the same file touched by patch in Oracle Home.");
                        continue;
                    }
                    if (!((DeleteAction)act).isHasFileVersion()) {
                        value = "lemax.version";
                    }
                    boolean actDel = false;
                    List<String> key = mpi_delete.get(file);
                    if (null != key && key.contains(value)) {
                        actDel = true;
                    }
                    String activeKey = (String)activeDelete.get(file);
                    if (patchObjects[i3].getApplicationDirs().size() > 0) {
                        activeDelete.put(file, value);
                        continue;
                    }
                    if (null != activeKey && activeKey.equals(value) || !Files.exists(dstFile, new LinkOption[0]) && !((DeleteAction)act).getIsReq()) {
                        actDel = false;
                    }
                    if (!actDel || ((DeleteAction)act).isHasFileVersion() && !value.startsWith("le")) {
                        ++noOpCount;
                        continue;
                    }
                    activeDelete.put(file, value);
                }
            }
            if (aiCount != noOpCount || aiCount == 0L) continue;
            OLogger.printlnOnLogAndVerbose("Patch \"" + patchObjects[i3].getPatchID() + "\" is a no-op. patch. based on file versions.");
            errorFlag = true;
            errorBuff.append(patchObjects[i3].getPatchID() + " ");
            store.add(patchObjects[i3].getPatchID());
        }
        if (errorFlag) {
            buff = new StringBuffer("The following no-op. \"Fusion Applications\" patch(es) have all copy version(s) less or equal to version(s) installed in\nOracle Home (or) among selected patch(es).");
            buff.append("\n " + errorBuff.toString());
            buff.append("\nPlease refer log file for more details.");
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            resObj.addDetail(buff.toString());
        }
        if (resObj.getResult() != PrereqResult.ExecuteStatus.FAILED) {
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        }
        if (OPatchEnv.isFATwoPhase()) {
            OLogger.printlnOnLog("\nCheckFileVersions: OPatch is called with two-phase patching for snowball. Serialize file/version information into disk.");
            processor.computeFV(patchObjects, oracleHomePath, m_bk, fv_exist);
            processor.computeNoOp(store);
            processor.computeComps(patchObjects);
        }
        return resObj;
    }

    public static PrereqResult checkOneOffSuperset(String oracleHomePath, PatchObject[] patchObjects) {
        StringBuffer buff = new StringBuffer("PrereqAPI::checkOneOffSuperset()");
        OLogger.debug(buff);
        PrereqResult resObj = new PrereqResult();
        int modelCode = PatchingModel.returnModelCode(oracleHomePath);
        if (modelCode != 2) {
            buff = new StringBuffer("The Oracle Home \"" + oracleHomePath + "\" does not support \"" + PatchingModel.getModelType(2) + "\"");
            buff.append("\nThis prereq is not applicable for this home.");
            resObj.addDetail(buff.toString());
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            return resObj;
        }
        PrereqResult patchModelResObj = PrereqAPI.checkPatchingModel(oracleHomePath, patchObjects);
        if (patchModelResObj.getResult() == PrereqResult.ExecuteStatus.FAILED || patchModelResObj.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED) {
            return patchModelResObj;
        }
        if (patchObjects == null) {
            resObj.addDetail("Could not create OPatch based Patch Objects based on the input.");
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            return resObj;
        }
        OneOffEntry[] inOneOffs = new OneOffEntry[patchObjects.length];
        for (int i2 = 0; i2 < patchObjects.length; ++i2) {
            try {
                inOneOffs[i2] = patchObjects[i2].toOneOffEntry(oracleHomePath);
                continue;
            }
            catch (RuntimeException e2) {
                OLogger.printStackTrace(e2);
                resObj.addDetail(e2.getMessage());
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                return resObj;
            }
        }
        OneOffEntry[] installedOneOffs = new OneOffEntry[]{};
        try {
            installedOneOffs = PrereqAPI.getInstalledOneOff(oracleHomePath);
        }
        catch (Throwable t) {
            buff = new StringBuffer("Throwable occurred: " + t.getMessage());
            OLogger.printlnOnLog(buff.toString());
            OLogger.debug(new StringBuffer("Converting Throwable to RuntimeException"));
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            resObj.addDetail(re);
            return resObj;
        }
        boolean errorFlag = false;
        StringBuffer errorBuff = new StringBuffer();
        for (int i3 = 0; i3 < inOneOffs.length; ++i3) {
            boolean isSuperset = false;
            boolean isConflict = false;
            String patchType = inOneOffs[i3].getPatchType();
            OLogger.println("Verifying if \"" + inOneOffs[i3].getID() + "\" is a one-off superset...");
            if (!patchType.equals("snowball")) {
                errorFlag = true;
                OLogger.printlnOnLogAndVerbose("Patch \"" + inOneOffs[i3].getID() + "\" is not a \"" + "Fusion Applications patch" + "\". This patch is not a one-off buster (superset).");
                errorBuff.append(inOneOffs[i3].getID() + " ");
                continue;
            }
            OneOffEntry curOneOff = inOneOffs[i3];
            for (int j2 = 0; j2 < installedOneOffs.length; ++j2) {
                String installedPatchType = installedOneOffs[j2].getPatchType();
                if (!installedPatchType.equals("singleton")) continue;
                OneOffEntry consideredOneOff = installedOneOffs[j2];
                String[] bugsFirstOneOff = curOneOff.getBugIDsFixed();
                String[] bugsThatSuperset = new String[1];
                String[] bugsThatConflict = new String[1];
                String[] filesThatConflict = new String[1];
                OneOffEntry[] toPatch = new OneOffEntry[]{consideredOneOff};
                ConflictHandler conflictHandler = new ConflictHandler(true, true, true, true);
                try {
                    if (conflictHandler.isBugSuperset(toPatch, bugsFirstOneOff, bugsThatSuperset)) {
                        isSuperset = true;
                        OLogger.printlnOnLogAndVerbose("The Fusion Applications Patch ID \"" + curOneOff.getID() + "\" supercedes the " + "singleton" + " patch \"" + consideredOneOff.getID() + "\".");
                        continue;
                    }
                    if (conflictHandler.isBugConflict(toPatch, bugsFirstOneOff, bugsThatConflict)) {
                        isConflict = true;
                        OLogger.printlnOnLogAndVerbose("The Fusion Applications Patch ID \"" + curOneOff.getID() + "\" conflicts with " + "singleton" + " patch \"" + consideredOneOff.getID() + "\".");
                        continue;
                    }
                    if (!conflictHandler.isGenericConflict(oracleHomePath, toPatch, curOneOff.getPatchActions(), filesThatConflict)) continue;
                    isConflict = true;
                    OLogger.printlnOnLogAndVerbose("The Fusion Applications Patch ID \"" + curOneOff.getID() + "\" conflicts with " + "singleton" + " patch \"" + consideredOneOff.getID() + "\".");
                    continue;
                }
                catch (Exception e3) {
                    OLogger.printStackTrace(e3);
                    resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                    resObj.addDetail(e3.getMessage());
                    return resObj;
                }
            }
            if (isSuperset && !isConflict) {
                OLogger.printlnOnLogAndVerbose("The Fusion Applications Patch ID \"" + curOneOff.getID() + "\" is a one-off superset.");
            }
            if (isConflict) {
                OLogger.printlnOnLogAndVerbose("The Fusion Applications Patch ID \"" + curOneOff.getID() + "\" is not a one-off superset as it has conflict(s) with " + "singleton" + " patch(es).");
                errorFlag = true;
                errorBuff.append(inOneOffs[i3].getID() + " ");
                continue;
            }
            if (isSuperset) continue;
            OLogger.printlnOnLogAndVerbose("The Fusion Applications Patch ID \"" + curOneOff.getID() + "\" is not a one-off superset as it does not supercede any " + "singleton" + " patch(es).");
            errorFlag = true;
            errorBuff.append(inOneOffs[i3].getID() + " ");
        }
        if (errorFlag) {
            buff = new StringBuffer("\nThe following patch(es) are not one-off superset(s).\n");
            buff.append(errorBuff.toString());
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            resObj.addDetail(buff.toString());
            resObj.addDetail("\nPlease refer log file for more details.");
        }
        if (resObj.getResult() != PrereqResult.ExecuteStatus.FAILED) {
            OLogger.println("All the given patch(es) are one-off superset(s).");
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        }
        return resObj;
    }

    public static PrereqResult checkSuppliedNodesApplicable(String oracleHomePath) {
        StringBuffer buff = new StringBuffer("PrereqAPI::checkSuppliedNodesApplicable() -> checking the internal option -supplied_nodes...");
        OLogger.debug(buff);
        PrereqResult resObj = new PrereqResult();
        String[] suppliedNodes = OPatchEnv.getUserSuppliedNodes();
        if (!OPatchEnv.isUserSuppliedNodes()) {
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            resObj.addDetail("The option '-supplied_nodes' is not specified.");
            return resObj;
        }
        String sessionName = OPatchEnv.getSessionName();
        buff = new StringBuffer(" Current session name is ");
        buff.append(sessionName);
        OLogger.debug(buff);
        if (!("apply".equalsIgnoreCase(sessionName) || "napply".equalsIgnoreCase(sessionName) || "napply".equalsIgnoreCase(OPatchEnv.getUtilOption()))) {
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            resObj.addDetail("The option '-supplied_nodes' is only for apply session.");
            return resObj;
        }
        resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        return resObj;
    }

    public static PrereqResult checkApplicable(String oracleHomePath, PatchObject[] patchObjects) {
        StringBuffer buff = new StringBuffer("PrereqAPI::checkApplicable() -> checking patching model...");
        OLogger.debug(buff);
        PrereqResult patchModelResObj = PrereqAPI.checkPatchingModel(oracleHomePath, patchObjects);
        if (patchModelResObj.getResult() == PrereqResult.ExecuteStatus.FAILED) {
            return patchModelResObj;
        }
        PrereqResult resObj = new PrereqResult();
        buff = new StringBuffer("PrereqAPI::checkApplicable() checking if each Component/Action is applicable or not");
        OLogger.debug(buff);
        boolean isStartOOP = false;
        String realOH = OPatchEnv.getOracleHome();
        ArrayList<String> failedPatches = new ArrayList<String>();
        Set<String> allJars = PrereqAPI.getAllClasspathsAndDependencies(realOH);
        try {
            boolean bl = isStartOOP = !PatchingFlow.CAS_REPO.equals((Object)OPatchEnv.getPatchingFlow()) && OPatchEnv.isNextGen() && !OPatchEnv.isRestarted() ? PrereqAPI.isRegenerationNeeded(realOH, patchObjects) : false;
            if (isStartOOP) {
                OLogger.printlnOnLog(OLogger.INFO, "regeneration is needed, startOOP set to be true");
            }
        }
        catch (Exception e1) {
            OLogger.printlnOnLog(OLogger.WARNING, "Check if library regeneration is needed with error message:" + e1.getMessage());
            OLogger.printlnOnLog(OLogger.WARNING, "Start OOP to apply the patch.");
            isStartOOP = true;
        }
        for (int pIter = 0; pIter < patchObjects.length; ++pIter) {
            PatchComponent pc;
            int i2;
            Vector includedPatchComponents = new Vector();
            try {
                PrereqResult compResObj = PrereqAPI.checkComponents(oracleHomePath, patchObjects[pIter], includedPatchComponents);
                if (compResObj.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED) {
                    buff = new StringBuffer("Prereq checkComponents returned without execution. ");
                    buff.append("So, checkApplicable returning without execution.");
                    OLogger.printlnOnLog(buff.toString());
                    return compResObj;
                }
                if (compResObj.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                    if (OPatchEnv.getSessionType().equalsIgnoreCase("prereq")) {
                        ZOPErrorMessage.printErrorMessage(45);
                    }
                    buff = new StringBuffer("Prereq checkComponents failed. ");
                    buff.append("So, checkApplicable returning without execution.");
                    OLogger.printlnOnLog(buff.toString());
                    OUSession.addPrereqResultForPatchesToReport(patchObjects[pIter].getPatchID(), OPatchPatchPrereq.CHECK_PATCH_APPLICABLE, compResObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
                    return compResObj;
                }
                compResObj = PrereqAPI.checkPatchActionsForSymbolComponent(oracleHomePath, new PatchObject[]{patchObjects[pIter]});
                if (compResObj.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED) {
                    buff = new StringBuffer("Prereq checkPatchActionsForSymbolComponent returned without execution. ");
                    buff.append("So, checkApplicable returning without execution.");
                    OLogger.printlnOnLog(buff.toString());
                    return compResObj;
                }
                if (compResObj.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                    OUSession.addPrereqResultForPatchesToReport(patchObjects[pIter].getPatchID(), OPatchPatchPrereq.CHECK_PATCH_APPLICABLE, compResObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
                    return compResObj;
                }
            }
            catch (NoOpPatchException e2) {
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                resObj.addDetail("Patch \"" + patchObjects[pIter].getPatchID() + "\" is a no-op patch.");
                OUSession.addPrereqResultForPatchesToReport(patchObjects[pIter].getPatchID(), OPatchPatchPrereq.CHECK_PATCH_APPLICABLE, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
                return resObj;
            }
            buff = new StringBuffer("\nThe patch components are applicable.");
            buff.append("\nProceeding for the patch actions checks.");
            OLogger.verbose(OPatchSession.PREREQ, buff);
            String patchLocation = patchObjects[pIter].getPatchLocation();
            PatchAction[] includedPatchActions = new PatchAction[]{};
            ArrayList<Applicable> nonApplicableActions = new ArrayList<Applicable>();
            for (i2 = 0; i2 < includedPatchComponents.size(); ++i2) {
                pc = (PatchComponent)includedPatchComponents.elementAt(i2);
                includedPatchActions = patchObjects[pIter].getPatchActionsForComponent(pc);
                for (int j2 = 0; j2 < includedPatchActions.length; ++j2) {
                    Applicable ap;
                    boolean actionApplicable;
                    PatchAction pa = includedPatchActions[j2];
                    if (pa instanceof Applicable && !(actionApplicable = (ap = (Applicable)((Object)pa)).applicable(oracleHomePath, patchLocation))) {
                        nonApplicableActions.add(ap);
                    }
                    boolean bl = isStartOOP = isStartOOP ? true : PrereqAPI.checkWhetherStartOOP(pa, realOH, allJars);
                    if (!isStartOOP || OPatchEnv.getOOPStatus() || OPatchEnv.isRestarted()) continue;
                    if (OPatchEnv.getOOPStartMode() == "") {
                        OPatchEnv.setOOPStartMode("OOP_prereq");
                    }
                    OPatchEnv.setOOPStatus(true);
                }
            }
            if (nonApplicableActions.size() > 0) {
                buff = new StringBuffer("\nPatch " + patchObjects[pIter].getPatchID() + ":\n");
                for (i2 = 0; i2 < nonApplicableActions.size(); ++i2) {
                    Object obj = nonApplicableActions.get(i2);
                    if (!(obj instanceof Applicable)) continue;
                    Applicable ap = (Applicable)obj;
                    String owningComp = "";
                    if (obj instanceof PatchAction) {
                        PatchAction pa = (PatchAction)obj;
                        owningComp = pa.getOwningComponentDesc();
                    }
                    String desc = ap.getApplicableDesc(oracleHomePath, owningComp);
                    buff.append(desc);
                    buff.append("\n");
                }
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                resObj.addDetail(buff.toString());
                failedPatches.add(patchObjects[pIter].getPatchID());
                if (OPatchEnv.getSessionType().equalsIgnoreCase("prereq")) {
                    ZOPErrorMessage.printErrorMessage(46);
                }
                OLogger.printlnOnLog(buff.toString());
            }
            if (!patchObjects[pIter].isOnlinePatch()) continue;
            for (i2 = 0; i2 < includedPatchComponents.size(); ++i2) {
                pc = (PatchComponent)includedPatchComponents.elementAt(i2);
                String pCompVersion = pc.getVersion();
                if (pCompVersion.startsWith("11")) {
                    if (!pCompVersion.startsWith("11.1") || !OPatchEnv.isWindows()) continue;
                    resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                    resObj.addDetail("Online Patches for Windows cannot support the component version specified in patch metadata.\n");
                    failedPatches.add(patchObjects[pIter].getPatchID());
                    continue;
                }
                if (!pCompVersion.startsWith("10")) continue;
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                resObj.addDetail("Online Patches cannot support the component version specified in patch metadata.\n");
                failedPatches.add(patchObjects[pIter].getPatchID());
            }
        }
        if (resObj.getResult() != PrereqResult.ExecuteStatus.FAILED) {
            buff = new StringBuffer("\nAll the patches components, actions are applicable.");
            OLogger.verbose(OPatchSession.PREREQ, buff);
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            OLogger.debug(new StringBuffer("Prereq checkApplicable Passed"));
        } else if (OPatchEnv.isContinueOnPrereqFailure()) {
            for (String patchId : failedPatches) {
                OUSession.addPrereqResultForPatchesToReport(patchId, OPatchPatchPrereq.CHECK_PATCH_APPLICABLE, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
            }
        }
        return resObj;
    }

    public static PrereqResult checkAutoRollbackablePatch(String oracleHomePath, PatchObject[] patchObjects) {
        PrereqResult resObj = new PrereqResult();
        StringBuffer buff = new StringBuffer("PrereqAPI::checkAutoRollbackablePatch()");
        OLogger.debug(buff);
        boolean notRollbackable = false;
        ArrayList<String> arrCannotAutoRollbackOneOffs = new ArrayList<String>();
        for (int rbIter = 0; rbIter < patchObjects.length; ++rbIter) {
            if (!patchObjects[rbIter].isCannotAutoRollback() && !patchObjects[rbIter].isNotRollBackable()) continue;
            arrCannotAutoRollbackOneOffs.add(patchObjects[rbIter].getPatchID());
            if (!patchObjects[rbIter].isNotRollBackable()) continue;
            notRollbackable = true;
        }
        if (arrCannotAutoRollbackOneOffs.size() > 0) {
            String r_patchIDs = "";
            for (int cannotRbIter = 0; cannotRbIter < arrCannotAutoRollbackOneOffs.size(); ++cannotRbIter) {
                r_patchIDs = r_patchIDs + arrCannotAutoRollbackOneOffs.get(cannotRbIter);
                if (cannotRbIter == arrCannotAutoRollbackOneOffs.size() - 1) continue;
                r_patchIDs = r_patchIDs + ",";
            }
            if (notRollbackable) {
                resObj.addDetail(OLogger.getString("OUI-67741", new Object[]{r_patchIDs}));
            } else {
                resObj.addDetail(OLogger.getString("OUI-67716", new Object[]{r_patchIDs}));
            }
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
        }
        if (resObj.getResult() != PrereqResult.ExecuteStatus.FAILED) {
            buff = new StringBuffer("\nAll the specified patches can be auto rolled back.");
            OLogger.verbose(OPatchSession.PREREQ, buff);
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            OLogger.debug(new StringBuffer("Prereq checkAutoRollbackablePatch Passed"));
        }
        return resObj;
    }

    public static PrereqResult checkNotRollbackable(String oracleHomePath, PatchObject[] patchObjects) {
        PrereqResult resObj = new PrereqResult();
        StringBuffer buff = new StringBuffer("PrereqAPI::checkNotRollbackablePatch()");
        OLogger.debug(buff);
        ArrayList<String> arrCannotRollbackOneOffs = new ArrayList<String>();
        for (int rbIter = 0; rbIter < patchObjects.length; ++rbIter) {
            if (!patchObjects[rbIter].isNotRollBackable()) continue;
            arrCannotRollbackOneOffs.add(patchObjects[rbIter].getPatchID());
        }
        if (arrCannotRollbackOneOffs.size() > 0) {
            String r_patchIDs = "";
            for (int cannotRbIter = 0; cannotRbIter < arrCannotRollbackOneOffs.size(); ++cannotRbIter) {
                r_patchIDs = r_patchIDs + (String)arrCannotRollbackOneOffs.get(cannotRbIter);
                if (cannotRbIter == arrCannotRollbackOneOffs.size() - 1) continue;
                r_patchIDs = r_patchIDs + ",";
            }
            resObj.addDetail(OLogger.getString("OUI-67741", new Object[]{r_patchIDs}));
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
        }
        if (resObj.getResult() != PrereqResult.ExecuteStatus.FAILED) {
            buff = new StringBuffer("\nAll the specified patches can be rolled back.");
            OLogger.verbose(OPatchSession.PREREQ, buff);
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            OLogger.debug(new StringBuffer("Prereq checkNotRollbackable Passed"));
        } else if (OPatchEnv.isContinueOnPrereqFailure()) {
            for (String patchId : arrCannotRollbackOneOffs) {
                OUSession.addPrereqResultForPatchesToReport(patchId, OPatchPatchPrereq.CHECK_ROLLBACKABLE, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
            }
        }
        return resObj;
    }

    public static PrereqResult checkRollbackable(String oracleHomePath, PatchObject[] patchObjects) {
        if (!OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS) && PrereqAPI.isPatchArchiveFilePresent(oracleHomePath)) {
            PatchArchiver patchArchiver = new PatchArchiver();
            ArrayList<String> archivedPatches = patchArchiver.isPatchArchived(oracleHomePath, patchObjects);
            if (archivedPatches != null) {
                StringBuilder patchList = new StringBuilder();
                ListIterator<String> listItr = archivedPatches.listIterator();
                while (listItr.hasNext()) {
                    patchList.append(listItr.next());
                    if (!listItr.hasNext()) continue;
                    patchList.append(",");
                }
                PrereqResult resObj = new PrereqResult();
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                StringBuilder opatch_loc = new StringBuilder();
                opatch_loc.append(oracleHomePath).append(File.separator).append("OPatch").append(File.separator).append("opatch");
                String step2Command = OPatchEnv.getOriginalCommand() != null && OPatchEnv.getOriginalCommand().length() > 0 ? "Step 2 : Resume/Rerun current Opatch operation: " + opatch_loc + " " + OPatchEnv.getOriginalCommand() : "Step 2 : Resume/Rerun current Opatch operation";
                Vector<String> details = new Vector<String>();
                details.add("***************************************************\n");
                details.add("Following patches are archived:\n");
                details.add(patchList.toString() + "\n");
                details.add("Please follow the instructions below to unarchive the patches before proceeding with current Opatch operation (as " + oracleHomePath + " owner).\n");
                details.add("Step 1: " + opatch_loc + " util unarchive -patches " + patchList.toString() + "\n");
                details.add(step2Command + "\n");
                details.add("***************************************************\n");
                resObj.setResultDetails(details);
                return resObj;
            }
            OLogger.printlnOnLog(OLogger.INFO, "Patches are not archived.");
        }
        PrereqResult resObj = new PrereqResult();
        StringBuffer buff = new StringBuffer("PrereqAPI::checkRollbackable()");
        OLogger.debug(buff);
        PrereqResult fAppsResObj = PrereqAPI.checkRollbackableForFusionApps(oracleHomePath, patchObjects);
        if (fAppsResObj.getResult() == PrereqResult.ExecuteStatus.FAILED || fAppsResObj.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED) {
            return fAppsResObj;
        }
        PrereqResult notRollbackCheck = PrereqAPI.checkNotRollbackable(oracleHomePath, patchObjects);
        if (notRollbackCheck.getResult() == PrereqResult.ExecuteStatus.FAILED) {
            return notRollbackCheck;
        }
        boolean isStartOOP = false;
        String realOH = OPatchEnv.getOracleHome();
        ArrayList<String> failedPatches = new ArrayList<String>();
        Set<String> allJars = PrereqAPI.getAllClasspathsAndDependencies(realOH);
        try {
            boolean bl = isStartOOP = !PatchingFlow.CAS_REPO.equals((Object)OPatchEnv.getPatchingFlow()) && OPatchEnv.isNextGen() && !OPatchEnv.isRestarted() ? PrereqAPI.isRegenerationNeeded(realOH, patchObjects) : false;
            if (isStartOOP) {
                OLogger.printlnOnLog(OLogger.INFO, "regeneration is needed, startOOP set to be true");
            }
        }
        catch (Exception e1) {
            OLogger.printlnOnLog(OLogger.WARNING, "Check if library regeneration is needed with error message:" + e1.getMessage());
            OLogger.printlnOnLog(OLogger.WARNING, "Start OOP to apply the patch.");
            isStartOOP = true;
        }
        for (int pobjIter = 0; pobjIter < patchObjects.length; ++pobjIter) {
            buff = new StringBuffer("\nPatch " + patchObjects[pobjIter].getPatchID() + ":\n");
            Map<PatchComponent, PatchComponentCheckResult> analyzed = null;
            if (OPatchEnv.isNextGen()) {
                try {
                    IIPMReadServices readServices = PrereqSession.getReadServices(oracleHomePath);
                    analyzed = readServices.analyzePatchComponents(patchObjects[pobjIter], true);
                }
                catch (Throwable e2) {
                    resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                    Vector<String> details = new Vector<String>();
                    details.add("Patch components cannot be analyzed " + e2.getMessage());
                    OLogger.justlog(OLogger.SEVERE, "Patch components cannot be analyzed " + e2.getMessage());
                    OLogger.printStackTrace(e2);
                    resObj.setResultDetails(details);
                    return resObj;
                }
            }
            PatchComponent[] includedPatchComponents = patchObjects[pobjIter].getIncludedPatchComponents();
            PatchAction[] includedPatchActions = new PatchAction[]{};
            ArrayList<Rollbackable> nonRollbackableActions = new ArrayList<Rollbackable>();
            String cookedPatchID = patchObjects[pobjIter].getCookedPatchID();
            for (int i2 = 0; i2 < includedPatchComponents.length; ++i2) {
                nonRollbackableActions = new ArrayList();
                PatchComponent pc = includedPatchComponents[i2];
                if (OPatchEnv.isNextGen() && analyzed != null && analyzed.get(pc).getResult().isProcessingNotRequired()) {
                    pc.setExcluded();
                    continue;
                }
                includedPatchActions = patchObjects[pobjIter].getPatchActionsForComponent(pc);
                for (int j2 = 0; j2 < includedPatchActions.length; ++j2) {
                    Rollbackable rp;
                    boolean actionRollbackable;
                    PatchAction pa = includedPatchActions[j2];
                    if (pa instanceof Rollbackable && !(actionRollbackable = (rp = (Rollbackable)((Object)pa)).rollbackable(oracleHomePath, cookedPatchID))) {
                        nonRollbackableActions.add(rp);
                        String owningComp = pa.getOwningComponentDesc();
                        String desc = rp.getRollbackableDesc(oracleHomePath, owningComp);
                        buff.append(desc);
                        buff.append("\n");
                    }
                    boolean bl = isStartOOP = isStartOOP ? true : PrereqAPI.checkWhetherStartOOP(pa, realOH, allJars);
                    if (!isStartOOP || OPatchEnv.getOOPStatus() || OPatchEnv.isRestarted()) continue;
                    if (OPatchEnv.getOOPStartMode() == "") {
                        OPatchEnv.setOOPStartMode("OOP_prereq");
                    }
                    OPatchEnv.setOOPStatus(true);
                }
            }
            boolean cupComponentError = false;
            if (OPatchEnv.isCUP2Supported() && analyzed != null && analyzed.size() > includedPatchComponents.length) {
                for (PatchComponent pc : analyzed.keySet()) {
                    PatchComponentCheckResult result;
                    if (!(pc instanceof CUPPatchComponent) || !(result = analyzed.get(pc)).getResult().isMetaDataError()) continue;
                    cupComponentError = true;
                    buff.append(result.getDetails());
                }
            }
            if (nonRollbackableActions.size() > 0 || cupComponentError) {
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                resObj.addDetail(buff.toString());
                failedPatches.add(patchObjects[pobjIter].getPatchID());
                OLogger.printlnOnLog(buff.toString());
                continue;
            }
            buff = new StringBuffer("\nPatch " + patchObjects[pobjIter].getPatchID() + ":\n");
            buff.append("All the actions are rollbackable.");
            OLogger.verbose(OPatchSession.PREREQ, buff);
        }
        if (resObj.getResult() != PrereqResult.ExecuteStatus.FAILED) {
            buff = new StringBuffer("\nAll the specified patches can be rolled back.");
            OLogger.verbose(OPatchSession.PREREQ, buff);
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            OLogger.debug(new StringBuffer("Prereq checkRollbackable Passed"));
        } else {
            if (OPatchEnv.getSessionType().equalsIgnoreCase("prereq")) {
                ZOPErrorMessage.printErrorMessage(42);
            }
            if (OPatchEnv.isContinueOnPrereqFailure()) {
                for (String patchId : failedPatches) {
                    OUSession.addPrereqResultForPatchesToReport(patchId, OPatchPatchPrereq.CHECK_ROLLBACKABLE, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
                }
            }
        }
        return resObj;
    }

    public static PrereqResult checkActiveServices(String oracleHomePath) {
        StringBuffer buff = new StringBuffer("PrereqAPI::checkActiveServices()");
        OLogger.debug(buff);
        PrereqResult resObj = new PrereqResult();
        if (PatchingFlow.CAS_REPO.equals((Object)OPatchEnv.getPatchingFlow())) {
            buff = new StringBuffer("Env is casrepo enabled, skipping prereq checkActiveServices");
            OLogger.printlnOnLog(buff.toString());
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            return resObj;
        }
        if (!OPatchEnv.isWindows()) {
            buff = new StringBuffer("OS is not Windows, skipping prereq checkActiveServices");
            OLogger.log(OLogger.INFO, buff.toString());
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            return resObj;
        }
        StringBuffer execPath = new StringBuffer(oracleHomePath);
        execPath.append(File.separator);
        execPath.append("bin");
        execPath.append(File.separator);
        execPath.append("oradim.exe");
        Path execFile = WrapperFactory.getNioServiceWrapper().getPath(execPath.toString(), new String[0]);
        if (!Files.exists(execFile, new LinkOption[0])) {
            buff = new StringBuffer("Executable \"");
            buff.append(execPath.toString());
            buff.append("\" was not found in the Oracle Home, so not checking for active services.");
            OLogger.debug(buff);
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            resObj.addDetail(buff.toString());
            return resObj;
        }
        SystemCall.ExecReturn ret = null;
        String[] systemCommand = new String[1];
        buff = new StringBuffer(execPath.toString());
        buff.append(" -ex services enum with image ");
        systemCommand[0] = buff.toString();
        buff = new StringBuffer("PrereqAPI::checkActiveServices() command to check for active services in");
        buff.append(systemCommand[0]);
        OLogger.debug(buff);
        String runDir = execFile.getParent().toString();
        buff = new StringBuffer("Invoking \"");
        buff.append(execPath);
        buff.append("\" to find active services");
        OLogger.verbose(OPatchSession.PREREQ, buff);
        String[] envp = new String[]{"ORACLE_HOME=" + oracleHomePath};
        StringBuffer ts = new StringBuffer("Start oradim command ");
        ts.append(systemCommand[0]);
        ts.append(" at ");
        OLogger.logTime(ts);
        ret = SystemCall.runtimeExec(systemCommand, envp, runDir);
        ts = new StringBuffer("Finish oradim command ");
        ts.append(systemCommand[0]);
        ts.append(" at ");
        OLogger.logTime(ts);
        buff = new StringBuffer(ret.toString());
        OLogger.debug(buff);
        if (!ret.isOK()) {
            String eMesg = ret.getErrorMessage();
            buff = new StringBuffer("Failed to execute the command.\n");
            buff.append(eMesg);
            OLogger.debug(buff);
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            resObj.addDetail(buff.toString());
            return resObj;
        }
        String nMesg = ret.getNormalMessage();
        resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        if (nMesg != null && !nMesg.equals("")) {
            String[] nMesgLines = nMesg.split("[\n\r]");
            for (int nIndex = 0; nIndex < nMesgLines.length; ++nIndex) {
                String[] lineData = nMesgLines[nIndex].split("[ \t\n\f\r]+");
                String lowerCaseOH = oracleHomePath.toLowerCase();
                String column1 = lineData[0];
                String column2 = lineData[1];
                String column3 = lineData[2].toLowerCase();
                if (column1.compareToIgnoreCase("RUNNING") != 0 || !column3.startsWith(lowerCaseOH)) continue;
                if (resObj.getResult() != PrereqResult.ExecuteStatus.FAILED) {
                    resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                    resObj.addDetail("The following services are active:\n");
                    if (OPatchEnv.isContinueOnPrereqFailure()) {
                        for (String patchId : PrereqAPI.getPatchesToApplyList()) {
                            OUSession.addPrereqResultForPatchesToReport(patchId, OPatchPatchPrereq.CHECK_WINDOWS_ACTIVE_SERVICES_FROM_ORACLE_HOME, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
                        }
                    }
                }
                resObj.addDetail(column2 + "\n");
            }
        }
        return resObj;
    }

    public static PrereqResult checkActiveFilesAndExecutables(String oracleHomePath, PatchObject pObj) {
        PrereqResult resObj = new PrereqResult();
        StringBuffer buff = new StringBuffer("PrereqAPI::checkActiveFilesAndExecutables()");
        OLogger.debug(buff);
        if (OPatchEnv.isignorePrereqSpecified() && OPatchEnv.getignorePrereq().equalsIgnoreCase(OPatchPatchPrereq.CHECK_ACTIVE_FILES_AND_EXECUTABLES.toString())) {
            OLogger.printlnOnLog("PREREQ : " + OPatchPatchPrereq.CHECK_ACTIVE_FILES_AND_EXECUTABLES + " has been skipped");
            resObj.setResult(PrereqResult.ExecuteStatus.SKIP);
            resObj.addDetail(OPatchPatchPrereq.CHECK_ACTIVE_FILES_AND_EXECUTABLES + " has been skipped");
            OUSession.addPrereqResultForPatchesToReport(pObj.getPatchID(), OPatchPatchPrereq.CHECK_ACTIVE_FILES_AND_EXECUTABLES, resObj, OPatchAnalysisReport.PrereqStatusForPatch.SKIP);
            return resObj;
        }
        String[] activeExec = new String[]{};
        ArrayList<String> opatchActiveFiles = new ArrayList<String>();
        ArrayList<String> nonOpatchActFiles = new ArrayList<String>();
        ArrayList<String> opatchActiveExecs = new ArrayList<String>();
        ArrayList<String> nonOpatchActExecs = new ArrayList<String>();
        if (OPatchEnv.isWindows()) {
            String[] activeFiles = new String[]{};
            Set<String> allJars = PrereqAPI.getAllClasspathsAndDependencies(OPatchEnv.getOracleHome());
            try {
                buff = new StringBuffer("\nChecking if the files to be patched are active...");
                OLogger.verbose(OPatchSession.PREREQ, buff);
                OneOffEntry oneOff = pObj.toOneOffEntry(oracleHomePath);
                String[][] filesTouched = oneOff.getFilesTouched(oracleHomePath);
                activeFiles = PrereqAPI.getActiveFiles(filesTouched);
                String[] executables = pObj.getExecutables(oracleHomePath);
                activeExec = PrereqAPI.getActiveExecutables(executables);
                if (activeFiles.length > 0) {
                    StringBuffer tmpNoF = new StringBuffer("\nFollowing active files/executables/libs are used by ORACLE_HOME :" + oracleHomePath + "\n");
                    StringBuffer tmpOF = new StringBuffer("\n");
                    for (int i2 = 0; i2 < activeFiles.length; ++i2) {
                        if (PrereqAPI.checkWhetherActionfileInJarList(activeFiles[i2], allJars)) {
                            opatchActiveFiles.add(activeFiles[i2]);
                            tmpOF.append(activeFiles[i2]);
                        } else {
                            nonOpatchActFiles.add(activeFiles[i2]);
                            tmpNoF.append(activeFiles[i2]);
                        }
                        if (i2 + 1 == activeFiles.length) continue;
                        tmpNoF.append("\n");
                        tmpOF.append("\n");
                    }
                    boolean continue_flow = true;
                    if (!nonOpatchActFiles.isEmpty()) {
                        Path opatchJrepath = WrapperFactory.getNioServiceWrapper().getPath(oracleHomePath + File.separator + "OPatch" + File.separator + "jre", new String[0]);
                        if (!Files.exists(opatchJrepath, new LinkOption[0])) {
                            for (String active_process : nonOpatchActFiles) {
                                if (active_process.contains("jdk")) {
                                    OLogger.printlnOnLog("Set OOP : incoming patch touches JDK -> " + active_process);
                                    OPatchEnv.setOOPStatus(true);
                                    continue_flow = false;
                                    continue;
                                }
                                continue_flow = true;
                                OLogger.printlnOnLog("OOP : non jdk process running from OH -> " + active_process);
                                break;
                            }
                        }
                        if (continue_flow) {
                            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                        }
                    }
                    resObj.addDetail(tmpNoF.toString() + tmpOF.toString());
                    OLogger.printlnOnLog(tmpNoF.toString() + tmpOF.toString());
                }
                buff = new StringBuffer("\nThere are no active files.");
                OLogger.verbose(OPatchSession.PREREQ, buff);
            }
            catch (IOException | RuntimeException e2) {
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                resObj.addDetail(e2);
                buff = new StringBuffer("Exception occurred: " + e2.getMessage());
                OLogger.printlnOnLog(buff.toString());
                return resObj;
            }
        } else {
            try {
                buff = new StringBuffer("\nInvoking fuser on the executable list...");
                OLogger.verbose(OPatchSession.PREREQ, buff);
                String[] executables = pObj.getExecutables(oracleHomePath);
                activeExec = PrereqAPI.getActiveExecutables(executables);
            }
            catch (IOException | RuntimeException e3) {
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                resObj.addDetail(e3);
                buff = new StringBuffer("Exception occurred: " + e3.getMessage());
                OLogger.printlnOnLog(buff.toString());
                return resObj;
            }
        }
        if (activeExec.length > 0) {
            StringBuffer tmpNoE = new StringBuffer("\n\nFollowing active files/executables/libs are used by ORACLE_HOME :" + oracleHomePath + "\n");
            StringBuffer tmpOE = new StringBuffer("\n");
            try {
                for (int i3 = 0; i3 < activeExec.length; ++i3) {
                    if (PrereqAPI.isActiveFileUsedByOPatch(activeExec[i3])) {
                        opatchActiveExecs.add(activeExec[i3]);
                        tmpOE.append(activeExec[i3]);
                    } else {
                        BusyFileProcessor.getActiveExecutables().add(activeExec[i3]);
                        nonOpatchActExecs.add(activeExec[i3]);
                        tmpNoE.append(activeExec[i3]);
                    }
                    if (i3 + 1 == activeExec.length) continue;
                    tmpNoE.append("\n");
                    tmpOE.append("\n");
                }
            }
            catch (RuntimeException e4) {
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                resObj.addDetail(e4);
                buff = new StringBuffer("Exception occurred: " + e4.getMessage());
                OLogger.printlnOnLog(buff.toString());
                return resObj;
            }
            if (resObj.getResult() != PrereqResult.ExecuteStatus.FAILED) {
                if (!nonOpatchActExecs.isEmpty() && BusyFileProcessor.isFileBusyPatching() && opatchActiveExecs.isEmpty()) {
                    resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
                } else if (!OPatchEnv.isOPatchSDKMode() && OLogger.isOPatchCmdLineMode() && (nonOpatchActExecs.isEmpty() && !opatchActiveExecs.isEmpty() || !nonOpatchActExecs.isEmpty() && BusyFileProcessor.isFileBusyPatching() && !opatchActiveExecs.isEmpty())) {
                    if (!OPatchEnv.getOOPStatus() && !OPatchEnv.isRestarted()) {
                        if (OPatchEnv.getOOPStartMode() == "") {
                            OPatchEnv.setOOPStartMode("OOP_prereq");
                        }
                        OPatchEnv.setOOPStatus(true);
                        resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
                    } else if (OPatchEnv.getOOPStatus() && OPatchEnv.isRestarted()) {
                        String errorMsg = "OOP is already in use.";
                        resObj.addDetail(errorMsg);
                        resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                        buff = new StringBuffer(errorMsg);
                        OLogger.verbose(OPatchSession.PREREQ, buff);
                    } else {
                        resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
                    }
                } else {
                    resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                }
            }
            resObj.addDetail(tmpNoE.toString() + tmpOE.toString());
            OLogger.printlnOnLog(tmpNoE.toString() + tmpOE.toString());
        } else {
            buff = new StringBuffer("\nThere are no active executables.");
            OLogger.verbose(OPatchSession.PREREQ, buff);
        }
        if (resObj.getResult() != PrereqResult.ExecuteStatus.FAILED) {
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            OLogger.debug(new StringBuffer("Prereq checkActiveFilesAndExecutables Passed"));
        } else {
            OUSession.addPrereqResultForPatchesToReport(pObj.getPatchID(), OPatchPatchPrereq.CHECK_ACTIVE_FILES_AND_EXECUTABLES, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
            if (OPatchEnv.isContinueOnPrereqFailure()) {
                OUSession.addPrereqResultForPatchesToReport(pObj.getPatchID(), OPatchPatchPrereq.CHECK_ACTIVE_FILES_AND_EXECUTABLES, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
            }
        }
        return resObj;
    }

    public static PrereqResult checkUserAdminPrivilege(String oracleHomePath) {
        PrereqResult resObj = new PrereqResult();
        StringBuffer buff = new StringBuffer("PrereqAPI::checkUserAdminPrivilege()");
        OLogger.debug(buff);
        boolean isRoot = false;
        try {
            isRoot = OUIReplacer.isRootAccess(oracleHomePath);
        }
        catch (Exception e1) {
            OLogger.println("Could not check if user is root. " + e1.getMessage());
            OLogger.printStackTrace(e1);
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            resObj.addDetail("Could not check if user is root user.");
            return resObj;
        }
        if (isRoot) {
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            resObj.addDetail("User has root access. OPatch cannot be executed with root access.");
            if (OPatchEnv.isContinueOnPrereqFailure()) {
                for (String patchId : PrereqAPI.getPatchesToApplyList()) {
                    OUSession.addPrereqResultForPatchesToReport(patchId, OPatchPatchPrereq.CHECK_USER_ADMIN_PRIVILEGE, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
                }
            }
        } else {
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        }
        return resObj;
    }

    public static PrereqResult checkForCRSHomeIfRAC(String oracleHomePath) {
        StringBuffer buff = new StringBuffer("PrereqAPI::checkForCRSHomeIfRAC()");
        OLogger.debug(buff);
        RacPrereqAPI racPrereqAPI = OPatchExternalFactory.getRacPrereqAPI(oracleHomePath);
        return racPrereqAPI.checkForCRSHomeIfRAC(oracleHomePath);
    }

    public static PrereqResult checkRACNodeList(String oracleHomePath) {
        StringBuffer buff = new StringBuffer("PrereqAPI::checkRACNodeList()");
        OLogger.debug(buff);
        RacPrereqAPI racPrereqAPI = OPatchExternalFactory.getRacPrereqAPI(oracleHomePath);
        return racPrereqAPI.checkRACNodeList(oracleHomePath);
    }

    public static PrereqResult checkRemoteCommandInvocable(String oracleHomePath) {
        StringBuffer buff = new StringBuffer("PrereqAPI::checkRemoteCommandInvocable()");
        OLogger.debug(buff);
        RacPrereqAPI racPrereqAPI = OPatchExternalFactory.getRacPrereqAPI(oracleHomePath);
        return racPrereqAPI.checkRemoteCommandInvocable(oracleHomePath);
    }

    public static PrereqResult checkRemoteCopyAndRemove(String oracleHomePath) {
        StringBuffer buff = new StringBuffer("PrereqAPI::checkRemoteCopyAndRemove()");
        OLogger.debug(buff);
        RacPrereqAPI racPrereqAPI = OPatchExternalFactory.getRacPrereqAPI(oracleHomePath);
        return racPrereqAPI.checkRemoteCopyAndRemove(oracleHomePath);
    }

    public static PrereqResult checkConflictWithPatchsetUpdate(String oracleHomePath, PatchObject[] patchObjs, String sessionName) {
        StringBuffer buff = new StringBuffer("PrereqAPI::checkConflictWithPatchsetUpdate()");
        OLogger.debug(buff);
        PrereqResult resObj = new PrereqResult();
        if (patchObjs == null) {
            resObj.addDetail("Got a null entry of one off object array");
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            return resObj;
        }
        OneOffEntry[] OHOneOffs = null;
        try {
            OHOneOffs = PrereqAPI.getInstalledOneOff(oracleHomePath);
        }
        catch (Throwable t) {
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            buff = new StringBuffer("Throwable Occured: " + t.getMessage());
            buff.append("\nThe throwable is converted into Exception and stored in Result Object.");
            OLogger.printlnOnLog(buff.toString());
            Exception e2 = new Exception(t.getMessage());
            e2.setStackTrace(t.getStackTrace());
            resObj.addDetail(e2);
            return resObj;
        }
        ConflictHandler conflictHandler = new ConflictHandler(true, true, true, true);
        boolean isError = false;
        StringBuffer errBuff = new StringBuffer("\n");
        for (PatchObject po : patchObjs) {
            OneOffEntry incomingPatch = po.toOneOffEntry(oracleHomePath);
            if (incomingPatch.isMiniPatchSet()) continue;
            String[] bugsToFix = incomingPatch.getBugIDsFixed();
            PatchAction[] patchActions = PrereqAPI.getAllValidPatchActions(oracleHomePath, po);
            for (int j2 = 0; j2 < OHOneOffs.length; ++j2) {
                OneOffEntry installedPatch = OHOneOffs[j2];
                if (!installedPatch.isMiniPatchSet()) continue;
                String[] bugsThatSuperset = new String[1];
                String[] bugsThatConflict = new String[1];
                String[] filesThatConflict = new String[1];
                String[] bugsThatSubset = new String[1];
                OneOffEntry[] ckList = new OneOffEntry[]{installedPatch};
                if (PrereqAPI.isOverLayOneOffs(oracleHomePath, incomingPatch, installedPatch)) continue;
                try {
                    if (conflictHandler.isBugSuperset(ckList, bugsToFix, bugsThatSuperset)) continue;
                    if (conflictHandler.isBugSubset(ckList, bugsToFix, bugsThatSubset)) {
                        isError = true;
                        errBuff.append(OLogger.getString("OUI-67614", new Object[]{incomingPatch.getID(), installedPatch.getID()}));
                        errBuff.append("\n");
                        continue;
                    }
                    if (conflictHandler.isBugConflict(ckList, bugsToFix, bugsThatConflict)) {
                        isError = true;
                        errBuff.append(OLogger.getString("OUI-67614", new Object[]{incomingPatch.getID(), installedPatch.getID()}));
                        errBuff.append("\n");
                        continue;
                    }
                    if (!conflictHandler.isGenericConflict(oracleHomePath, ckList, patchActions, filesThatConflict)) continue;
                    isError = true;
                    errBuff.append(OLogger.getString("OUI-67614", new Object[]{incomingPatch.getID(), installedPatch.getID()}));
                    errBuff.append("\n");
                    continue;
                }
                catch (Exception e3) {
                    resObj.addDetail(e3);
                    resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                    OLogger.printStackTrace(e3);
                    OLogger.printlnOnLog("Exception occurred : " + e3.getMessage());
                    return resObj;
                }
            }
        }
        if (isError) {
            resObj.addDetail(errBuff.toString());
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
        } else {
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        }
        return resObj;
    }

    public static ConflictMatrixOutput checkConflictAgainstOHWithDetailSkipMissingComps(String oracleHomePath, String sessionName, OneOffEntry[] piOneOffs) {
        CheckConflictAdapter adapter = new CheckConflictAdapter();
        ConflictMatrixOutput resObj = new ConflictMatrixOutput(piOneOffs.length, piOneOffs.length);
        OneOffEntry[] pohOneOffs = null;
        try {
            pohOneOffs = PrereqAPI.getInstalledOneOff(oracleHomePath);
            if (pohOneOffs.length != 0) {
                StringBuffer oBuf = new StringBuffer("\nList of patches in the OH :\n");
                int ohLen = pohOneOffs.length;
                for (int i2 = 0; i2 < ohLen; ++i2) {
                    oBuf.append(pohOneOffs[i2].getID());
                    if (i2 == ohLen - 1) continue;
                    oBuf.append(", ");
                }
                OLogger.debug(oBuf);
            }
        }
        catch (Throwable t) {
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            StringBuffer buff = new StringBuffer("Throwable Occured: " + t.getMessage());
            buff.append("\nThe throwable is converted into Exception and stored in Result Object.");
            OLogger.printlnOnLog(buff.toString());
            Exception e2 = new Exception(t.getMessage());
            e2.setStackTrace(t.getStackTrace());
            resObj.addDetail(e2);
            return resObj;
        }
        resObj = adapter.checkConflictAgainstOHWithDetailSkipMissingComps(oracleHomePath, piOneOffs, pohOneOffs);
        PrereqAPI.checkConflictZOPMessage(resObj, adapter);
        return resObj;
    }

    public static ConflictMatrixOutput checkConflictAgainstOHWithDetailSkipMissingComps_backup(String oracleHomePath, String sessionName, OneOffEntry[] oneOffEntry) {
        StringBuffer buff = new StringBuffer("PrereqAPI::checkConflictAgainstOHWithDetailSkipMissingComps()");
        OLogger.debug(buff);
        OneOffEntry[] OHOneOffs = null;
        ConflictMatrixOutput resObj = new ConflictMatrixOutput(1, 1);
        if (oneOffEntry.length == 0) {
            PrereqAPI.setConflictCheckingSuccess(resObj);
            return resObj;
        }
        try {
            OHOneOffs = PrereqAPI.getInstalledOneOff(oracleHomePath);
        }
        catch (Throwable t) {
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            buff = new StringBuffer("Throwable Occured: " + t.getMessage());
            buff.append("\nThe throwable is converted into Exception and stored in Result Object.");
            OLogger.printlnOnLog(buff.toString());
            Exception e2 = new Exception(t.getMessage());
            e2.setStackTrace(t.getStackTrace());
            resObj.addDetail(e2);
            return resObj;
        }
        buff = new StringBuffer("\nNumber of Oneoffs in the Oracle Home : ");
        buff.append(OHOneOffs.length);
        OLogger.verbose(OPatchSession.PREREQ, buff);
        OneOffEntry[] mergedOneOffList = null;
        int mIter = 0;
        if (Rules.shouldMergedOneOffsInHand(oracleHomePath)) {
            int oIter;
            mergedOneOffList = new OneOffEntry[oneOffEntry.length + OHOneOffs.length];
            for (oIter = 0; oIter < oneOffEntry.length; ++oIter) {
                mergedOneOffList[mIter++] = oneOffEntry[oIter];
            }
            for (oIter = 0; oIter < OHOneOffs.length; ++oIter) {
                mergedOneOffList[mIter++] = OHOneOffs[oIter];
            }
        } else {
            int oIter;
            int reqdOneOffs = 0;
            for (oIter = 0; oIter < oneOffEntry.length; ++oIter) {
                if (!oneOffEntry[oIter].getPatchType().equalsIgnoreCase("singleton")) continue;
                ++reqdOneOffs;
            }
            mergedOneOffList = new OneOffEntry[OHOneOffs.length + reqdOneOffs];
            for (oIter = 0; oIter < oneOffEntry.length; ++oIter) {
                if (!oneOffEntry[oIter].getPatchType().equalsIgnoreCase("singleton")) continue;
                mergedOneOffList[mIter++] = oneOffEntry[oIter];
            }
            for (oIter = 0; oIter < OHOneOffs.length; ++oIter) {
                mergedOneOffList[mIter++] = OHOneOffs[oIter];
            }
        }
        resObj = new ConflictMatrixOutput(oneOffEntry.length, mergedOneOffList.length);
        ConflictOutput simpleResult = PrereqAPI.checkConflictAgainstOHSkipMissingComps_backup(oracleHomePath, sessionName, oneOffEntry);
        resObj.setListOfPatchesToBeMerged(simpleResult.getListOfPatchesToBeMerged());
        resObj.setListOfPatchesThatCanGoNow(simpleResult.getListOfPatchesThatCanGoNow());
        resObj.setListOfPatchesNotNeeded(simpleResult.getListOfPatchesNotNeeded());
        resObj.setListOfPatchesThatNeedToBeRollback(simpleResult.getListOfPatchesThatNeedToBeRollback());
        String[] filesThatConflict = null;
        String[] bugsThatSuperset = null;
        String[] bugsThatConflict = null;
        String[] bugsThatSubset = null;
        OneOffEntry[] ckList = null;
        OneOffEntry newElement = null;
        PrereqSet patchesInOH = new PrereqSet(OHOneOffs);
        ConflictHandler conflictHandler = new ConflictHandler(true, true, true, true);
        boolean superset = false;
        boolean conflict = false;
        for (int i2 = 0; i2 < oneOffEntry.length; ++i2) {
            newElement = oneOffEntry[i2];
            buff = new StringBuffer("Checking conflicts for patch: ");
            buff.append(newElement.getID());
            OLogger.printlnOnLog(buff.toString());
            PatchAction[] patchActions = PrereqAPI.getPatchActionsForPresentComponents(oracleHomePath, sessionName, newElement);
            for (int j2 = 0; j2 < mergedOneOffList.length; ++j2) {
                ckList = new OneOffEntry[1];
                filesThatConflict = new String[1];
                bugsThatSuperset = new String[1];
                bugsThatConflict = new String[1];
                bugsThatSubset = new String[1];
                ckList[0] = mergedOneOffList[j2];
                String[] bugsToFix = newElement.getBugIDsFixed();
                buff = new StringBuffer("Checking conflicts/supersets for patch: ");
                buff.append(newElement.getID());
                buff.append(" with patch:");
                buff.append(mergedOneOffList[j2].getID());
                OLogger.printlnOnLog(buff.toString());
                resObj.setColumnPatchID(i2, j2, mergedOneOffList[j2].getID());
                resObj.setRowPatchID(i2, j2, newElement.getID());
                if (newElement == mergedOneOffList[j2]) {
                    resObj.setConflictType(i2, j2, ConflictMatrixOutput.ConflictType.IDENTICAL_PATCH);
                    continue;
                }
                if (patchesInOH.contains(mergedOneOffList[j2]) ? PrereqAPI.isOverLayOneOffs(oracleHomePath, newElement, mergedOneOffList[j2]) : PrereqAPI.isOverLayOneOffs(oracleHomePath, newElement, mergedOneOffList[j2]) || PrereqAPI.isOverLayOneOffs(oracleHomePath, mergedOneOffList[j2], newElement)) continue;
                try {
                    int k2;
                    if (conflictHandler.isBugSuperset(ckList, bugsToFix, bugsThatSuperset)) {
                        if (Rules.shouldErrorOnConflict(newElement, mergedOneOffList[j2], oracleHomePath)) {
                            if (bugsThatSuperset[0].endsWith(", ")) {
                                bugsThatSuperset[0] = bugsThatSuperset[0].substring(0, bugsThatSuperset[0].length() - 2);
                            }
                            String[] bugsThatSupersetList = bugsThatSuperset[0].split(",");
                            resObj.add(i2, j2, bugsThatSupersetList, ConflictMatrixOutput.ConflictType.BUG_SUPERSET);
                            buff = new StringBuffer("Patch ");
                            buff.append(newElement.getID());
                            buff.append(" is Superset of ");
                            buff.append(mergedOneOffList[j2].getID());
                            OLogger.printlnOnLog(buff.toString());
                            superset = true;
                            continue;
                        }
                        OLogger.printlnOnLogAndVerbose("Ignore the relation that patch " + newElement.getID() + " is Superset of " + mergedOneOffList[j2].getID() + " because patching model is " + "snowball");
                        continue;
                    }
                    if (conflictHandler.isBugSubset(ckList, bugsToFix, bugsThatSubset)) {
                        if (bugsThatSubset[0].endsWith(", ")) {
                            bugsThatSubset[0] = bugsThatSubset[0].substring(0, bugsThatSubset[0].length() - 2);
                        }
                        String[] bugsThatSubsetList = bugsThatSubset[0].split(",");
                        resObj.add(i2, j2, bugsThatSubsetList, ConflictMatrixOutput.ConflictType.BUG_SUBSET);
                        buff = new StringBuffer("Patch ");
                        buff.append(newElement.getID());
                        buff.append(" is Subset of ");
                        buff.append(mergedOneOffList[j2].getID());
                        OLogger.printlnOnLog(buff.toString());
                        continue;
                    }
                    if (conflictHandler.isBugConflict(ckList, bugsToFix, bugsThatConflict)) {
                        if (Rules.shouldErrorOnConflict(newElement, mergedOneOffList[j2], oracleHomePath) && !PrereqAPI.shouldIgnoreConflictSBOneOff(oneOffEntry, newElement, mergedOneOffList[j2], OHOneOffs) && !CompositePatchObject.canIgnoreConflictWithOneOff(oracleHomePath, newElement, oneOffEntry, mergedOneOffList[j2])) {
                            if (bugsThatConflict[0].endsWith(", ")) {
                                bugsThatConflict[0] = bugsThatConflict[0].substring(0, bugsThatConflict[0].length() - 2);
                            }
                            String[] bugsThatConflictList = bugsThatConflict[0].split(",");
                            resObj.add(i2, j2, bugsThatConflictList, ConflictMatrixOutput.ConflictType.BUG_CONFLICT);
                            buff = new StringBuffer("Patch ");
                            buff.append(newElement.getID());
                            buff.append(" has Bug Conflict with ");
                            buff.append(mergedOneOffList[j2].getID());
                            buff.append(". Conflicting bugs are :\n");
                            for (k2 = 0; k2 < bugsThatConflictList.length; ++k2) {
                                buff.append(bugsThatConflictList[k2]);
                                buff.append(" ");
                            }
                            OLogger.printlnOnLog(buff.toString());
                            conflict = true;
                            continue;
                        }
                        OLogger.printlnOnLogAndVerbose("Bug Conflict ignored between " + newElement.getID() + " and " + mergedOneOffList[j2].getID() + " because patching model is " + "snowball");
                        continue;
                    }
                    if (!conflictHandler.isGenericConflict(oracleHomePath, ckList, patchActions, filesThatConflict)) continue;
                    if (Rules.shouldErrorOnConflict(newElement, mergedOneOffList[j2], oracleHomePath) && !PrereqAPI.shouldIgnoreConflictSBOneOff(oneOffEntry, newElement, mergedOneOffList[j2], OHOneOffs) && !CompositePatchObject.canIgnoreConflictWithOneOff(oracleHomePath, newElement, oneOffEntry, mergedOneOffList[j2])) {
                        String[] filesThatConflictList = filesThatConflict[0].split(",");
                        resObj.add(i2, j2, filesThatConflictList, ConflictMatrixOutput.ConflictType.GENERIC_CONFLICT);
                        buff = new StringBuffer("Patch ");
                        buff.append(newElement.getID());
                        buff.append(" has Generic Conflict with ");
                        buff.append(mergedOneOffList[j2].getID());
                        buff.append(". Conflicting files are :\n");
                        for (k2 = 0; k2 < filesThatConflictList.length; ++k2) {
                            buff.append(filesThatConflictList[k2]);
                            buff.append("\n");
                        }
                        OLogger.printlnOnLog(buff.toString());
                        conflict = true;
                        continue;
                    }
                    OLogger.printlnOnLogAndVerbose("Generic Conflict ignored between " + newElement.getID() + " and " + mergedOneOffList[j2].getID() + " because patching model is " + "snowball");
                    continue;
                }
                catch (BugSupersetException e3) {
                    resObj.addDetail(e3);
                    resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                    OLogger.printlnOnLog("BugSupersetException occurred : " + e3.getMessage());
                    return resObj;
                }
                catch (BugSubsetException e4) {
                    resObj.addDetail(e4);
                    resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                    OLogger.printlnOnLog("BugSubsetException occurred : " + e4.getMessage());
                    return resObj;
                }
                catch (BugConflictException e5) {
                    resObj.addDetail(e5);
                    resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                    OLogger.printlnOnLog("BugConflictException occurred : " + e5.getMessage());
                    return resObj;
                }
                catch (GenericConflictException e6) {
                    resObj.addDetail(e6);
                    resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                    OLogger.printlnOnLog("GenericConflictException occurred : " + e6.getMessage());
                    return resObj;
                }
                catch (RuntimeException e7) {
                    resObj.addDetail(e7);
                    resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                    OLogger.printlnOnLog("FileConflictException occurred : " + e7.getMessage());
                    return resObj;
                }
            }
        }
        if (OPatchEnv.getSessionType().equals("prereq")) {
            OneOffEntry[] conflictList = resObj.getListOfPatchesToBeMerged();
            if (conflictList != null && conflictList.length != 0) {
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            } else if (resObj.getResult() != PrereqResult.ExecuteStatus.NOT_EXECUTED) {
                resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            }
        }
        if (resObj.getResult() != PrereqResult.ExecuteStatus.FAILED) {
            PrereqAPI.setConflictCheckingSuccess(resObj);
        } else if (OPatchEnv.getSessionType().equalsIgnoreCase("prereq")) {
            if (superset) {
                ZOPErrorMessage.printErrorMessage(47);
            }
            if (conflict) {
                ZOPErrorMessage.printErrorMessage(40);
            }
        }
        return resObj;
    }

    private static boolean shouldIgnoreConflictSBOneOff(OneOffEntry[] oneoffs, OneOffEntry first, OneOffEntry second, OneOffEntry[] ohOneOffs) {
        if (first.getPatchType().equalsIgnoreCase("snowball") && second.getPatchType().equalsIgnoreCase("singleton")) {
            int i2;
            int firstPosition = 0;
            int secondPosition = 0;
            for (i2 = 0; i2 < oneoffs.length; ++i2) {
                if (oneoffs[i2].equals(first)) {
                    firstPosition = i2;
                }
                if (!oneoffs[i2].equals(second)) continue;
                secondPosition = i2;
            }
            if (firstPosition > secondPosition) {
                return false;
            }
            for (i2 = 0; i2 < ohOneOffs.length; ++i2) {
                if (!ohOneOffs[i2].equals(second)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static void setConflictCheckingSuccess(ConflictMatrixOutput resObj) {
        StringBuffer buff = new StringBuffer("\nThere are no conflicts/supersets.");
        OLogger.verbose(OPatchSession.PREREQ, buff);
        resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        OLogger.debug(new StringBuffer("Prereq checkConflictAgainstOHWithDetailSkipMissingComps() Passed"));
    }

    public static ConflictMatrixOutput checkConflictAgainstOHWithDetail(String oracleHomePath, OneOffEntry[] piOneOffs) {
        ConflictMatrixOutput resObj = null;
        if (OPatchEnv.isSnowBall()) {
            resObj = new ConflictMatrixOutput();
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            String msg = "For snowball patching model, skip checkConflictAgainstOHWithDetail \n.";
            resObj.addDetail(msg);
            StringBuffer buff = new StringBuffer();
            OLogger.debug(buff.append(msg));
            return resObj;
        }
        CheckConflictAdapter adapter = new CheckConflictAdapter();
        resObj = new ConflictMatrixOutput(piOneOffs.length, piOneOffs.length);
        OneOffEntry[] pohOneOffs = null;
        try {
            pohOneOffs = PrereqAPI.getInstalledOneOff(oracleHomePath);
            if (pohOneOffs.length != 0) {
                StringBuffer oBuf = new StringBuffer("\nList of patches in the OH :\n");
                int ohLen = pohOneOffs.length;
                for (int i2 = 0; i2 < ohLen; ++i2) {
                    oBuf.append(pohOneOffs[i2].getID());
                    if (i2 == ohLen - 1) continue;
                    oBuf.append(", ");
                }
                OLogger.debug(oBuf);
            }
        }
        catch (Throwable t) {
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            StringBuffer buff = new StringBuffer("Throwable Occured: " + t.getMessage());
            buff.append("\nThe throwable is converted into Exception and stored in Result Object.");
            OLogger.printlnOnLog(buff.toString());
            Exception e2 = new Exception(t.getMessage());
            e2.setStackTrace(t.getStackTrace());
            resObj.addDetail(e2);
            return resObj;
        }
        resObj = adapter.checkConflictAgainstOHWithDetail(oracleHomePath, piOneOffs, pohOneOffs);
        if (OPatchEnv.isContinueOnPrereqFailure()) {
            for (OneOffEntry ooe : resObj.getListOfPatchesNotNeeded()) {
                PrereqResult pr = new PrereqResult();
                StringBuilder buff = new StringBuilder();
                buff.append("\nFollowing patches are not required, ");
                buff.append("as they are subset of the patches in Oracle Home or subset of the patches in the given list : \n");
                buff.append(ooe.getID()).append("\n");
                pr.addDetail(buff.toString());
                pr.setResult(PrereqResult.ExecuteStatus.PASSED);
                OUSession.addPrereqResultForPatchesToReport(ooe.getID(), OPatchPatchPrereq.CHECK_CONFLICT_AMONG_PATCHES_AND_AGAINST_ORACLE_HOME, pr, OPatchAnalysisReport.PrereqStatusForPatch.SKIP);
            }
            for (OneOffEntry ooe : resObj.getListOfPatchesToBeMerged()) {
                if (OPatchEnv.isIgnoreConflict()) continue;
                OUSession.addPrereqResultForPatchesToReport(ooe.getID(), OPatchPatchPrereq.CHECK_CONFLICT_AMONG_PATCHES_AND_AGAINST_ORACLE_HOME, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
            }
            for (OneOffEntry ooe : resObj.getListOfPatchesThatCanGoNow()) {
                OUSession.addNApplyPatchesToReport(ooe.getID());
            }
            for (OneOffEntry ooe : resObj.getListOfPatchesThatNeedToBeRollback()) {
                OUSession.addNRollbackPatchesToReport(ooe.getID(), true);
            }
        }
        PrereqAPI.checkConflictZOPMessage(resObj, adapter);
        return resObj;
    }

    public static ConflictMatrixOutput checkConflictAgainstOHWithDetail_backup(String oracleHomePath, OneOffEntry[] oneOffEntry) {
        return PrereqAPI.checkConflictAgainstOHWithDetail(oracleHomePath, oneOffEntry, true);
    }

    protected static ConflictMatrixOutput checkConflictAgainstOHWithDetail(String oracleHomePath, OneOffEntry[] oneOffEntry, boolean printZOP) {
        StringBuffer buff = new StringBuffer("PrereqAPI::checkConflictAgainstOHWithDetail()");
        OLogger.debug(buff);
        OneOffEntry[] OHOneOffs = null;
        ConflictMatrixOutput resObj = new ConflictMatrixOutput(1, 1);
        if (oneOffEntry.length == 0) {
            PrereqAPI.setConflictCheckingSuccess(resObj);
            return resObj;
        }
        try {
            OHOneOffs = PrereqAPI.getInstalledOneOff(oracleHomePath);
        }
        catch (Throwable t) {
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            buff = new StringBuffer("Throwable Occured: " + t.getMessage());
            buff.append("\nThe throwable is converted into Exception and stored in Result Object.");
            OLogger.printlnOnLog(buff.toString());
            Exception e2 = new Exception(t.getMessage());
            e2.setStackTrace(t.getStackTrace());
            resObj.addDetail(e2);
            return resObj;
        }
        buff = new StringBuffer("\nNumber of Oneoffs in the Oracle Home : ");
        buff.append(OHOneOffs.length);
        OLogger.verbose(OPatchSession.PREREQ, buff);
        OneOffEntry[] mergedOneOffList = null;
        int mIter = 0;
        if (Rules.shouldMergedOneOffsInHand(oracleHomePath)) {
            int oIter;
            mergedOneOffList = new OneOffEntry[oneOffEntry.length + OHOneOffs.length];
            for (oIter = 0; oIter < oneOffEntry.length; ++oIter) {
                mergedOneOffList[mIter++] = oneOffEntry[oIter];
            }
            for (oIter = 0; oIter < OHOneOffs.length; ++oIter) {
                mergedOneOffList[mIter++] = OHOneOffs[oIter];
            }
        } else {
            int oIter;
            int reqdOneOffs = 0;
            for (oIter = 0; oIter < oneOffEntry.length; ++oIter) {
                if (!oneOffEntry[oIter].getPatchType().equalsIgnoreCase("singleton")) continue;
                ++reqdOneOffs;
            }
            mergedOneOffList = new OneOffEntry[OHOneOffs.length + reqdOneOffs];
            for (oIter = 0; oIter < oneOffEntry.length; ++oIter) {
                if (!oneOffEntry[oIter].getPatchType().equalsIgnoreCase("singleton")) continue;
                mergedOneOffList[mIter++] = oneOffEntry[oIter];
            }
            for (oIter = 0; oIter < OHOneOffs.length; ++oIter) {
                mergedOneOffList[mIter++] = OHOneOffs[oIter];
            }
        }
        if (mergedOneOffList.length == 0) {
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            return resObj;
        }
        resObj = new ConflictMatrixOutput(oneOffEntry.length, mergedOneOffList.length);
        ConflictOutput simpleResult = PrereqAPI.checkConflictAgainstOH_backup(oracleHomePath, oneOffEntry);
        resObj.setListOfPatchesToBeMerged(simpleResult.getListOfPatchesToBeMerged());
        resObj.setListOfPatchesThatCanGoNow(simpleResult.getListOfPatchesThatCanGoNow());
        resObj.setListOfPatchesNotNeeded(simpleResult.getListOfPatchesNotNeeded());
        resObj.setListOfPatchesThatNeedToBeRollback(simpleResult.getListOfPatchesThatNeedToBeRollback());
        String[] filesThatConflict = null;
        String[] bugsThatSuperset = null;
        String[] bugsThatConflict = null;
        String[] bugsThatSubset = null;
        OneOffEntry[] ckList = null;
        OneOffEntry newElement = null;
        PrereqSet patchesInOH = new PrereqSet(OHOneOffs);
        ConflictHandler conflictHandler = new ConflictHandler(true, true, true, true);
        boolean superset = false;
        boolean conflict = false;
        ArrayList<OneOffEntry> subsetPatches = new ArrayList<OneOffEntry>();
        for (int i2 = 0; i2 < oneOffEntry.length; ++i2) {
            newElement = oneOffEntry[i2];
            buff = new StringBuffer("Checking conflicts for patch: ");
            buff.append(newElement.getID());
            OLogger.printlnOnLog(buff.toString());
            for (int j2 = 0; j2 < mergedOneOffList.length; ++j2) {
                ckList = new OneOffEntry[1];
                filesThatConflict = new String[1];
                bugsThatSuperset = new String[1];
                bugsThatConflict = new String[1];
                bugsThatSubset = new String[1];
                ckList[0] = mergedOneOffList[j2];
                String[] bugsToFix = newElement.getBugIDsFixed();
                buff = new StringBuffer("Checking conflicts/supersets for patch: ");
                buff.append(newElement.getID());
                buff.append(" with patch:");
                buff.append(mergedOneOffList[j2].getID());
                OLogger.printlnOnLog(buff.toString());
                resObj.setColumnPatchID(i2, j2, mergedOneOffList[j2].getID());
                resObj.setRowPatchID(i2, j2, newElement.getID());
                if (newElement == mergedOneOffList[j2]) {
                    resObj.setConflictType(i2, j2, ConflictMatrixOutput.ConflictType.IDENTICAL_PATCH);
                    continue;
                }
                if (patchesInOH.contains(mergedOneOffList[j2]) ? PrereqAPI.isOverLayOneOffs(oracleHomePath, newElement, mergedOneOffList[j2]) : PrereqAPI.isOverLayOneOffs(oracleHomePath, newElement, mergedOneOffList[j2]) || PrereqAPI.isOverLayOneOffs(oracleHomePath, mergedOneOffList[j2], newElement)) continue;
                try {
                    int k2;
                    if (conflictHandler.isBugSuperset(ckList, bugsToFix, bugsThatSuperset)) {
                        if (bugsThatSuperset[0].endsWith(", ")) {
                            bugsThatSuperset[0] = bugsThatSuperset[0].substring(0, bugsThatSuperset[0].length() - 2);
                        }
                        String[] bugsThatSupersetList = bugsThatSuperset[0].split(",");
                        resObj.add(i2, j2, bugsThatSupersetList, ConflictMatrixOutput.ConflictType.BUG_SUPERSET);
                        buff = new StringBuffer("Patch ");
                        buff.append(newElement.getID());
                        buff.append(" is Superset of ");
                        buff.append(mergedOneOffList[j2].getID());
                        OLogger.printlnOnLog(buff.toString());
                        superset = true;
                        continue;
                    }
                    if (conflictHandler.isBugSubset(ckList, bugsToFix, bugsThatSubset)) {
                        if (bugsThatSubset[0].endsWith(", ")) {
                            bugsThatSubset[0] = bugsThatSubset[0].substring(0, bugsThatSubset[0].length() - 2);
                        }
                        String[] bugsThatSubsetList = bugsThatSubset[0].split(",");
                        resObj.add(i2, j2, bugsThatSubsetList, ConflictMatrixOutput.ConflictType.BUG_SUBSET);
                        buff = new StringBuffer("Patch ");
                        buff.append(newElement.getID());
                        buff.append(" is Subset of ");
                        buff.append(mergedOneOffList[j2].getID());
                        OLogger.printlnOnLog(buff.toString());
                        if (subsetPatches.contains(oneOffEntry[i2])) continue;
                        subsetPatches.add(oneOffEntry[i2]);
                        continue;
                    }
                    if (conflictHandler.isBugConflict(ckList, bugsToFix, bugsThatConflict)) {
                        if (!Rules.shouldErrorOnConflict(newElement, mergedOneOffList[j2], oracleHomePath) || PrereqAPI.shouldIgnoreConflictSBOneOff(oneOffEntry, newElement, mergedOneOffList[j2], OHOneOffs) || CompositePatchObject.canIgnoreConflictWithOneOff(oracleHomePath, newElement, oneOffEntry, mergedOneOffList[j2])) continue;
                        if (bugsThatConflict[0].endsWith(", ")) {
                            bugsThatConflict[0] = bugsThatConflict[0].substring(0, bugsThatConflict[0].length() - 2);
                        }
                        String[] bugsThatConflictList = bugsThatConflict[0].split(",");
                        resObj.add(i2, j2, bugsThatConflictList, ConflictMatrixOutput.ConflictType.BUG_CONFLICT);
                        buff = new StringBuffer("Patch ");
                        buff.append(newElement.getID());
                        buff.append(" has Bug Conflict with ");
                        buff.append(mergedOneOffList[j2].getID());
                        buff.append(". Conflicting bugs are :\n");
                        for (k2 = 0; k2 < bugsThatConflictList.length; ++k2) {
                            buff.append(bugsThatConflictList[k2]);
                            buff.append(" ");
                        }
                        OLogger.printlnOnLog(buff.toString());
                        conflict = true;
                        continue;
                    }
                    if (!conflictHandler.isGenericConflict(oracleHomePath, ckList, newElement.getPatchActions(), filesThatConflict) || !Rules.shouldErrorOnConflict(newElement, mergedOneOffList[j2], oracleHomePath) || PrereqAPI.shouldIgnoreConflictSBOneOff(oneOffEntry, newElement, mergedOneOffList[j2], OHOneOffs) || CompositePatchObject.canIgnoreConflictWithOneOff(oracleHomePath, newElement, oneOffEntry, mergedOneOffList[j2])) continue;
                    String[] filesThatConflictList = filesThatConflict[0].split(",");
                    resObj.add(i2, j2, filesThatConflictList, ConflictMatrixOutput.ConflictType.GENERIC_CONFLICT);
                    buff = new StringBuffer("Patch ");
                    buff.append(newElement.getID());
                    buff.append(" has Generic Conflict with ");
                    buff.append(mergedOneOffList[j2].getID());
                    buff.append(". Conflicting files are :\n");
                    for (k2 = 0; k2 < filesThatConflictList.length; ++k2) {
                        buff.append(filesThatConflictList[k2]);
                        buff.append("\n");
                    }
                    OLogger.printlnOnLog(buff.toString());
                    conflict = true;
                    continue;
                }
                catch (BugSupersetException e3) {
                    resObj.addDetail(e3);
                    resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                    OLogger.printlnOnLog("BugSupersetException occurred : " + e3.getMessage());
                    return resObj;
                }
                catch (BugSubsetException e4) {
                    resObj.addDetail(e4);
                    resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                    OLogger.printlnOnLog("BugSubsetException occurred : " + e4.getMessage());
                    return resObj;
                }
                catch (BugConflictException e5) {
                    resObj.addDetail(e5);
                    resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                    OLogger.printlnOnLog("BugConflictException occurred : " + e5.getMessage());
                    return resObj;
                }
                catch (GenericConflictException e6) {
                    resObj.addDetail(e6);
                    resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                    OLogger.printlnOnLog("GenericConflictException occurred : " + e6.getMessage());
                    return resObj;
                }
            }
        }
        if (OPatchEnv.getSessionType().equals("prereq")) {
            OneOffEntry[] conflictList = resObj.getListOfPatchesToBeMerged();
            if (conflictList != null && conflictList.length != 0) {
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            } else if (subsetPatches.size() == oneOffEntry.length) {
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            } else if (resObj.getResult() != PrereqResult.ExecuteStatus.NOT_EXECUTED) {
                resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            }
        }
        if (resObj.getResult() != PrereqResult.ExecuteStatus.FAILED) {
            PrereqAPI.setConflictCheckingSuccess(resObj);
        } else if (OPatchEnv.getSessionType().equalsIgnoreCase("prereq") && printZOP) {
            if (superset) {
                ZOPErrorMessage.printErrorMessage(47);
            }
            if (conflict) {
                ZOPErrorMessage.printErrorMessage(40);
            }
        }
        return resObj;
    }

    public static ConflictMatrixOutput checkConflictAmongPatchesWithDetail(String oracleHomePath, OneOffEntry[] piOneOffs) {
        int modelCode = PatchingModel.returnModelCode(oracleHomePath);
        ConflictMatrixOutput resObj = null;
        if (modelCode == 2) {
            resObj = new ConflictMatrixOutput();
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            String msg = "For snowball patching model, skip checkConflictAmongPatchesWithDetail \n.";
            resObj.addDetail(msg);
            StringBuffer buff = new StringBuffer();
            OLogger.debug(buff.append(msg));
            return resObj;
        }
        CheckConflictAdapter adapter = new CheckConflictAdapter();
        resObj = adapter.checkConflictAmongPatchesWithDetail(oracleHomePath, piOneOffs);
        PrereqAPI.checkConflictZOPMessage(resObj, adapter);
        return resObj;
    }

    public static ConflictMatrixOutput checkConflictAmongPatchesWithDetail_backup(String oracleHomePath, OneOffEntry[] oneOffEntry) {
        ConflictMatrixOutput resObj = new ConflictMatrixOutput(oneOffEntry.length, oneOffEntry.length);
        StringBuffer buff = new StringBuffer("PrereqAPI::checkConflictAmongPatchesWithDetail()");
        OLogger.debug(buff);
        ConflictOutput simpleResult = PrereqAPI.checkConflictAmongPatches_backup(oracleHomePath, oneOffEntry);
        resObj.setListOfPatchesToBeMerged(simpleResult.getListOfPatchesToBeMerged());
        resObj.setListOfPatchesThatCanGoNow(simpleResult.getListOfPatchesThatCanGoNow());
        resObj.setListOfPatchesNotNeeded(simpleResult.getListOfPatchesNotNeeded());
        resObj.setListOfPatchesThatNeedToBeRollback(simpleResult.getListOfPatchesThatNeedToBeRollback());
        OneOffEntry newElement = null;
        String[] filesThatConflict = null;
        String[] bugsThatSuperset = null;
        String[] bugsThatConflict = null;
        String[] bugsThatSubset = null;
        OneOffEntry[] ckList = null;
        ConflictHandler conflictHandler = new ConflictHandler(true, true, true, true);
        boolean superset = false;
        boolean conflict = false;
        ArrayList<OneOffEntry> subsetPatches = new ArrayList<OneOffEntry>();
        for (int i2 = 0; i2 < oneOffEntry.length; ++i2) {
            newElement = oneOffEntry[i2];
            buff = new StringBuffer("Checking conflicts for patch : ");
            buff.append(newElement.getID());
            OLogger.printlnOnLog(buff.toString());
            for (int j2 = 0; j2 < oneOffEntry.length; ++j2) {
                ckList = new OneOffEntry[1];
                filesThatConflict = new String[1];
                bugsThatSuperset = new String[1];
                bugsThatConflict = new String[1];
                bugsThatSubset = new String[1];
                ckList[0] = oneOffEntry[j2];
                String[] bugsToFix = newElement.getBugIDsFixed();
                resObj.setColumnPatchID(i2, j2, oneOffEntry[j2].getID());
                resObj.setRowPatchID(i2, j2, newElement.getID());
                if (oneOffEntry[i2].equals(oneOffEntry[j2])) {
                    resObj.setConflictType(i2, j2, ConflictMatrixOutput.ConflictType.IDENTICAL_PATCH);
                    continue;
                }
                if (PrereqAPI.isOverLayOneOffs(oracleHomePath, newElement, oneOffEntry[j2]) || PrereqAPI.isOverLayOneOffs(oracleHomePath, oneOffEntry[j2], newElement)) continue;
                try {
                    int k2;
                    if (conflictHandler.isBugSuperset(ckList, bugsToFix, bugsThatSuperset)) {
                        if (!Rules.shouldErrorOnConflictAmongPatches(newElement, oneOffEntry[j2], oracleHomePath)) continue;
                        if (bugsThatSuperset[0].endsWith(", ")) {
                            bugsThatSuperset[0] = bugsThatSuperset[0].substring(0, bugsThatSuperset[0].length() - 2);
                        }
                        String[] bugsThatSupersetList = bugsThatSuperset[0].split(",");
                        resObj.add(i2, j2, bugsThatSuperset, ConflictMatrixOutput.ConflictType.BUG_SUPERSET);
                        buff = new StringBuffer("Patch ");
                        buff.append(newElement.getID());
                        buff.append(" is Superset of ");
                        buff.append(oneOffEntry[j2].getID());
                        OLogger.printlnOnLog(buff.toString());
                        superset = true;
                        continue;
                    }
                    if (conflictHandler.isBugSubset(ckList, bugsToFix, bugsThatSubset)) {
                        if (bugsThatSubset[0].endsWith(", ")) {
                            bugsThatSubset[0] = bugsThatSubset[0].substring(0, bugsThatSubset[0].length() - 2);
                        }
                        String[] bugsThatSubsetList = bugsThatSubset[0].split(",");
                        resObj.add(i2, j2, bugsThatSubset, ConflictMatrixOutput.ConflictType.BUG_SUBSET);
                        buff = new StringBuffer("Patch ");
                        buff.append(newElement.getID());
                        buff.append(" is Subset of ");
                        buff.append(oneOffEntry[j2].getID());
                        OLogger.printlnOnLog(buff.toString());
                        if (subsetPatches.contains(oneOffEntry[i2])) continue;
                        subsetPatches.add(oneOffEntry[i2]);
                        continue;
                    }
                    if (conflictHandler.isBugConflict(ckList, bugsToFix, bugsThatConflict)) {
                        if (!Rules.shouldErrorOnConflictAmongPatches(newElement, oneOffEntry[j2], oracleHomePath)) continue;
                        if (bugsThatConflict[0].endsWith(", ")) {
                            bugsThatConflict[0] = bugsThatConflict[0].substring(0, bugsThatConflict[0].length() - 2);
                        }
                        String[] bugsThatConflictList = bugsThatConflict[0].split(",");
                        resObj.add(i2, j2, bugsThatConflictList, ConflictMatrixOutput.ConflictType.BUG_CONFLICT);
                        buff = new StringBuffer("Patch ");
                        buff.append(newElement.getID());
                        buff.append(" has Bug Conflict with ");
                        buff.append(oneOffEntry[j2].getID());
                        buff.append(". Conflicting bugs are :\n");
                        for (k2 = 0; k2 < bugsThatConflictList.length; ++k2) {
                            buff.append(bugsThatConflictList[k2]);
                            buff.append(" ");
                        }
                        OLogger.printlnOnLog(buff.toString());
                        conflict = true;
                        continue;
                    }
                    if (!conflictHandler.isGenericConflict(oracleHomePath, ckList, newElement.getPatchActions(), filesThatConflict) || !Rules.shouldErrorOnConflictAmongPatches(newElement, oneOffEntry[j2], oracleHomePath)) continue;
                    String[] filesThatConflictList = filesThatConflict[0].split(",");
                    resObj.add(i2, j2, filesThatConflictList, ConflictMatrixOutput.ConflictType.GENERIC_CONFLICT);
                    buff = new StringBuffer("Patch ");
                    buff.append(newElement.getID());
                    buff.append(" has Generic Conflict with ");
                    buff.append(oneOffEntry[j2].getID());
                    buff.append(". Conflicting files are :\n");
                    for (k2 = 0; k2 < filesThatConflictList.length; ++k2) {
                        buff.append(filesThatConflictList[k2]);
                        buff.append("\n");
                    }
                    OLogger.printlnOnLog(buff.toString());
                    conflict = true;
                    continue;
                }
                catch (BugSupersetException e2) {
                    resObj.addDetail(e2);
                    resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                    OLogger.printlnOnLog("BugSupersetException occurred : " + e2.getMessage());
                    return resObj;
                }
                catch (BugSubsetException e3) {
                    resObj.addDetail(e3);
                    resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                    OLogger.printlnOnLog("BugSubsetException occurred : " + e3.getMessage());
                    return resObj;
                }
                catch (BugConflictException e4) {
                    resObj.addDetail(e4);
                    resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                    OLogger.printlnOnLog("BugConflictException occurred : " + e4.getMessage());
                    return resObj;
                }
                catch (GenericConflictException e5) {
                    resObj.addDetail(e5);
                    resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                    OLogger.printlnOnLog("GenericConflictException occurred : " + e5.getMessage());
                    return resObj;
                }
            }
        }
        if (OPatchEnv.getSessionType().equalsIgnoreCase("prereq")) {
            OneOffEntry[] conflictList = resObj.getListOfPatchesToBeMerged();
            if (conflictList != null && conflictList.length != 0) {
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            } else if (subsetPatches.size() == oneOffEntry.length) {
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            } else if (resObj.getResult() != PrereqResult.ExecuteStatus.NOT_EXECUTED) {
                resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            }
        }
        if (resObj.getResult() != PrereqResult.ExecuteStatus.FAILED) {
            buff = new StringBuffer("\nThere are no conflicts/supersets.");
            OLogger.verbose(OPatchSession.PREREQ, buff);
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            OLogger.debug(new StringBuffer("Prereq checkConflictAmongPatchesWithDetail Passed"));
        } else if (OPatchEnv.getSessionType().equalsIgnoreCase("prereq")) {
            if (superset) {
                ZOPErrorMessage.printErrorMessage(47);
            }
            if (conflict) {
                ZOPErrorMessage.printErrorMessage(40);
            }
        }
        return resObj;
    }

    public static boolean isOverLayOneOffs(String oracleHomePath, OneOffEntry newElem, OneOffEntry oldElem) {
        String[] overLayIds = newElem.getTotalOverLayPatchIDs(oracleHomePath, new OneOffEntry[0]);
        for (int i2 = 0; i2 < overLayIds.length; ++i2) {
            if (!overLayIds[i2].equals(oldElem.getID())) continue;
            return true;
        }
        return false;
    }

    public static boolean isOverLayOneOffs(OneOffEntry newElem, OneOffEntry oldElem) {
        String[] overLayIds = newElem.getOverLayPatchIDs();
        for (int i2 = 0; i2 < overLayIds.length; ++i2) {
            if (!overLayIds[i2].equals(oldElem.getID())) continue;
            return true;
        }
        return false;
    }

    public static PrereqResult checkIfOHLockedForPatching(String oracleHomePath) {
        PrereqResult resObj = new PrereqResult();
        OLogger.debug(new StringBuffer("PrereqAPI::checkIfOHLockedForPatching()"));
        StringBuffer buff = new StringBuffer(oracleHomePath);
        buff.append(File.separator);
        buff.append(".patch_storage");
        buff.append(File.separator);
        buff.append("patch_locked");
        Path lockFile = WrapperFactory.getNioServiceWrapper().getPath(buff.toString(), new String[0]);
        if (Files.exists(lockFile, new LinkOption[0])) {
            buff = new StringBuffer("Lock file exists, with contents:\n");
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            if (OPatchEnv.getSessionType().equalsIgnoreCase("prereq")) {
                ZOPErrorMessage.printErrorMessage(41);
            }
            try {
                BufferedReader br = Files.newBufferedReader(lockFile, Charset.forName("UTF-8"));
                String line = br.readLine();
                while (line != null) {
                    resObj.addDetail(line + "\n");
                    buff.append(line + "\n");
                    line = br.readLine();
                }
                OLogger.printlnOnLog(buff.toString());
            }
            catch (IOException e2) {
                resObj.addDetail(e2);
                buff = new StringBuffer("Exception occurred: ");
                buff.append(e2.getMessage());
                OLogger.printlnOnLog(buff.toString());
            }
            if (OPatchEnv.isContinueOnPrereqFailure()) {
                for (String patchId : patchesToApplyList) {
                    OUSession.addPrereqResultForPatchesToReport(patchId, OPatchPatchPrereq.CHECK_IF_ORACLE_HOME_ALREADY_LOCKED_FOR_PATCHING, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
                }
            }
            return resObj;
        }
        buff = new StringBuffer("\nOracle Home is free and can be used for patching.");
        OLogger.verbose(OPatchSession.PREREQ, buff);
        resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        OLogger.debug(new StringBuffer("Prereq checkIfOHLockedForPatching Passed"));
        return resObj;
    }

    public static ConflictOutput checkConflictAmongPatches(String oracleHomePath, OneOffEntry[] piOneOffs) {
        ConflictOutput resObj = new ConflictOutput();
        int modelCode = PatchingModel.returnModelCode(oracleHomePath);
        if (modelCode == 2) {
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            String msg = "For snowball patching model, skip checkConflictAmongPatches \n.";
            resObj.addDetail(msg);
            StringBuffer buff = new StringBuffer();
            OLogger.debug(buff.append(msg));
            return resObj;
        }
        CheckConflictAdapter adapter = new CheckConflictAdapter();
        resObj = adapter.checkConflictAmongPatches(oracleHomePath, piOneOffs);
        if (OPatchEnv.isContinueOnPrereqFailure()) {
            for (OneOffEntry ooe : resObj.getListOfPatchesToBeMerged()) {
                OUSession.addPrereqResultForPatchesToReport(ooe.getID(), OPatchPatchPrereq.CHECK_CONFLICT_AMONG_PATCHES, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
            }
            for (OneOffEntry ooe : resObj.getListOfPatchesNotNeeded()) {
                PrereqResult pr = new PrereqResult();
                StringBuilder buff = new StringBuilder();
                buff.append("\nFollowing patches are not required, ");
                buff.append("as they are subset of the patches in Oracle Home or subset of the patches in the given list : \n");
                buff.append(ooe.getID()).append("\n");
                pr.addDetail(buff.toString());
                pr.setResult(PrereqResult.ExecuteStatus.PASSED);
                OUSession.addPrereqResultForPatchesToReport(ooe.getID(), OPatchPatchPrereq.CHECK_CONFLICT_AMONG_PATCHES, pr, OPatchAnalysisReport.PrereqStatusForPatch.SKIP);
            }
        }
        return resObj;
    }

    public static ConflictOutput checkConflictAmongPatches_backup(String oracleHomePath, OneOffEntry[] oneOffEntry) {
        ConflictOutput resObj = new ConflictOutput();
        StringBuffer buff = new StringBuffer("PrereqAPI::checkConflictAmongPatches()");
        OLogger.debug(buff);
        PrereqSet[] conflictsList = new PrereqSet[oneOffEntry.length];
        PrereqSet B = new PrereqSet();
        PrereqSet C = new PrereqSet();
        PrereqSet D = new PrereqSet();
        OneOffEntry newElement = null;
        int a_Length = oneOffEntry.length;
        String[] filesThatConflict = null;
        String[] bugsThatSuperset = null;
        String[] bugsThatConflict = null;
        String[] bugsThatSubset = null;
        OneOffEntry[] ckList = null;
        boolean newElemNotNeeded = false;
        ConflictHandler conflictHandler = new ConflictHandler(true, true, true, true);
        HashMap super_sub = new HashMap();
        HashMap<OneOffEntry, Integer> indexList = new HashMap<OneOffEntry, Integer>();
        for (int j2 = 0; j2 < a_Length; ++j2) {
            newElement = oneOffEntry[j2];
            buff = new StringBuffer("Checking conflicts for patch : ");
            buff.append(newElement.getID());
            OLogger.debug(buff);
            newElemNotNeeded = false;
            conflictsList[j2] = new PrereqSet();
            OneOffEntry[] old_B = B.getAllElements();
            for (int i2 = 0; i2 < old_B.length; ++i2) {
                ckList = new OneOffEntry[1];
                filesThatConflict = new String[1];
                bugsThatSuperset = new String[1];
                bugsThatConflict = new String[1];
                bugsThatSubset = new String[1];
                ckList[0] = old_B[i2];
                String[] bugsToFix = newElement.getBugIDsFixed();
                try {
                    Integer index;
                    if (conflictHandler.isBugSuperset(ckList, bugsToFix, bugsThatSuperset)) {
                        if (Rules.shouldErrorOnConflictAmongPatches(newElement, old_B[i2], oracleHomePath)) {
                            if (!conflictHandler.isFileSuperset(ckList[0], newElement.getPatchActions())) {
                                OLogger.debug(OLogger.getString("OUI-67644", new Object[]{newElement.getID(), ckList[0].getID()}));
                            }
                            OneOffEntry subSetElement = old_B[i2];
                            D.add(subSetElement);
                            B.delete(subSetElement);
                            if (C.contains(subSetElement)) {
                                C.delete(subSetElement);
                                if (!C.contains(newElement)) {
                                    C.add(newElement);
                                }
                            }
                            PrereqAPI.updateSuperSubRelationship(super_sub, newElement, subSetElement);
                            OLogger.printlnOnLog("Patch " + newElement.getID() + " is superset of " + old_B[i2].getID());
                            continue;
                        }
                        OLogger.printlnOnLog("Bug Superset ignored between Patches \"" + newElement.getID() + "\" and \"" + old_B[i2].getID() + "\" because patching model is " + "snowball");
                        continue;
                    }
                    if (conflictHandler.isBugSubset(ckList, bugsToFix, bugsThatSubset)) {
                        D.add(newElement);
                        newElemNotNeeded = true;
                        B.delete(newElement);
                        if (C.contains(newElement)) {
                            C.delete(newElement);
                            if (!C.contains(old_B[i2])) {
                                C.add(old_B[i2]);
                            }
                        }
                        PrereqAPI.updateSuperSubRelationship(super_sub, old_B[i2], newElement);
                        OLogger.printlnOnLog("Patch " + newElement.getID() + " is subset of " + old_B[i2].getID());
                        continue;
                    }
                    if (conflictHandler.isBugConflict(ckList, bugsToFix, bugsThatConflict)) {
                        if (Rules.shouldErrorOnConflictAmongPatches(newElement, old_B[i2], oracleHomePath)) {
                            C.add(old_B[i2]);
                            C.add(newElement);
                            conflictsList[j2].add(old_B[i2]);
                            if (indexList.size() > i2 && indexList.size() != 0 && (index = (Integer)indexList.get(old_B[i2])) != null) {
                                conflictsList[index].add(newElement);
                            }
                            OLogger.printlnOnLog("Patch " + newElement.getID() + " has Bug conflict with " + old_B[i2].getID());
                            continue;
                        }
                        OLogger.printlnOnLog("Bug Conflict ignored between Patches \"" + newElement.getID() + "\" and \"" + old_B[i2].getID() + "\" because patching model is " + "snowball");
                        continue;
                    }
                    if (!conflictHandler.isGenericConflict(oracleHomePath, ckList, newElement.getPatchActions(), filesThatConflict)) continue;
                    if (Rules.shouldErrorOnConflictAmongPatches(newElement, old_B[i2], oracleHomePath)) {
                        C.add(old_B[i2]);
                        C.add(newElement);
                        conflictsList[j2].add(old_B[i2]);
                        if (indexList.size() > i2 && indexList.size() != 0 && (index = (Integer)indexList.get(old_B[i2])) != null) {
                            conflictsList[index].add(newElement);
                        }
                        OLogger.printlnOnLog("Patch " + newElement.getID() + " has Generic conflict with " + old_B[i2].getID());
                        continue;
                    }
                    OLogger.printlnOnLog("Generic Conflict ignored between Patches \"" + newElement.getID() + "\" and \"" + old_B[i2].getID() + "\" because patching model is " + "snowball");
                    continue;
                }
                catch (BugSupersetException e2) {
                    resObj.addDetail(e2);
                    resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                    OLogger.printlnOnLog("BugSupersetException occurred : " + e2.getMessage());
                    return resObj;
                }
                catch (BugSubsetException e3) {
                    resObj.addDetail(e3);
                    resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                    OLogger.printlnOnLog("BugSubsetException occurred : " + e3.getMessage());
                    return resObj;
                }
                catch (BugConflictException e4) {
                    resObj.addDetail(e4);
                    resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                    OLogger.printlnOnLog("BugConflictException occurred : " + e4.getMessage());
                    return resObj;
                }
                catch (GenericConflictException e5) {
                    resObj.addDetail(e5);
                    resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                    OLogger.printlnOnLog("GenericConflictException occurred : " + e5.getMessage());
                    return resObj;
                }
            }
            if (newElemNotNeeded) continue;
            B.add(newElement);
            indexList.put(newElement, new Integer(j2));
            OLogger.debug(new StringBuffer("Patch " + newElement.getID() + " is not subset of any other patch processed till now"));
        }
        if (C.size() == 1) {
            B.add(C.getElement(0));
            C.delete(0);
        }
        PrereqAPI.updateConflictRelationships(super_sub, oneOffEntry, new OneOffEntry[0], conflictsList, C);
        resObj.update(B.delete(C), C, D);
        resObj = PrereqAPI.processOverLay(oneOffEntry, resObj, conflictsList, oracleHomePath);
        if (OPatchEnv.getSessionType().equalsIgnoreCase("prereq")) {
            OneOffEntry[] conflictList = resObj.getListOfPatchesToBeMerged();
            if (conflictList != null && conflictList.length != 0) {
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            } else if (resObj.getResult() != PrereqResult.ExecuteStatus.NOT_EXECUTED) {
                resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            }
        }
        return resObj;
    }

    public static ConflictOutput checkConflictAgainstOH(String oracleHomePath, OneOffEntry[] piOneOffs) {
        CheckConflictAdapter adapter = new CheckConflictAdapter();
        OneOffEntry[] pohOneOffs = null;
        try {
            pohOneOffs = PrereqAPI.getInstalledOneOff(oracleHomePath);
            if (pohOneOffs.length != 0) {
                StringBuffer oBuf = new StringBuffer("\nList of patches in the OH :\n");
                int ohLen = pohOneOffs.length;
                for (int i2 = 0; i2 < ohLen; ++i2) {
                    oBuf.append(pohOneOffs[i2].getID());
                    if (i2 == ohLen - 1) continue;
                    oBuf.append(", ");
                }
                OLogger.debug(oBuf);
            }
        }
        catch (Throwable t) {
            ConflictOutput neResObj = new ConflictOutput();
            neResObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            StringBuffer buff = new StringBuffer("Throwable Occured: " + t.getMessage());
            buff.append("\nThe throwable is converted into Exception and stored in Result Object.");
            OLogger.printlnOnLog(buff.toString());
            Exception e2 = new Exception(t.getMessage());
            e2.setStackTrace(t.getStackTrace());
            neResObj.addDetail(e2);
            return neResObj;
        }
        ConflictMatrixOutput resObj = new ConflictMatrixOutput(piOneOffs.length, piOneOffs.length);
        resObj = adapter.checkConflictAgainstOHWithDetail(oracleHomePath, piOneOffs, pohOneOffs);
        PrereqAPI.checkConflictZOPMessage(resObj, adapter);
        return resObj;
    }

    public static ConflictOutput checkConflictAgainstOH_backup(String oracleHomePath, OneOffEntry[] oneOffEntry) {
        int i2;
        StringBuffer buff = new StringBuffer("PrereqAPI::checkConflictAgainstOH()");
        OLogger.debug(buff);
        OneOffEntry newElement = null;
        OneOffEntry[] OHOneOffs = null;
        ConflictOutput resObj = new ConflictOutput();
        try {
            OHOneOffs = PrereqAPI.getInstalledOneOff(oracleHomePath);
            if (OHOneOffs.length != 0) {
                StringBuffer oBuf = new StringBuffer("\nList of patches in the OH :\n");
                int ohLen = OHOneOffs.length;
                for (i2 = 0; i2 < ohLen; ++i2) {
                    oBuf.append(OHOneOffs[i2].getID());
                    if (i2 == ohLen - 1) continue;
                    oBuf.append(", ");
                }
                OLogger.debug(oBuf);
            }
        }
        catch (Throwable t) {
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            buff = new StringBuffer("Throwable Occured: " + t.getMessage());
            buff.append("\nThe throwable is converted into Exception and stored in Result Object.");
            OLogger.printlnOnLog(buff.toString());
            Exception e2 = new Exception(t.getMessage());
            e2.setStackTrace(t.getStackTrace());
            resObj.addDetail(e2);
            return resObj;
        }
        if (oneOffEntry.length != 0) {
            StringBuffer tBuf = new StringBuffer("\nList of patches on which the InterConflict prereq runs are :\n");
            int oLen = oneOffEntry.length;
            for (i2 = 0; i2 < oLen; ++i2) {
                tBuf.append(oneOffEntry[i2].getID());
                if (i2 == oLen - 1) continue;
                tBuf.append(", ");
            }
            OLogger.debug(tBuf);
        }
        PrereqSet patchesInOH = new PrereqSet(OHOneOffs);
        PrereqSet[] conflictsList = new PrereqSet[oneOffEntry.length];
        PrereqSet B = new PrereqSet(OHOneOffs);
        B = B.add(new PrereqSet(oneOffEntry));
        PrereqSet C = new PrereqSet();
        PrereqSet D = new PrereqSet();
        PrereqSet R = new PrereqSet();
        int a_Length = oneOffEntry.length;
        String[] filesThatConflict = null;
        String[] bugsThatSuperset = null;
        String[] bugsThatConflict = null;
        String[] bugsThatSubset = null;
        OneOffEntry[] ckList = null;
        boolean newElemNotNeeded = false;
        ConflictHandler conflictHandler = new ConflictHandler(true, true, true, true);
        HashMap super_sub = new HashMap();
        HashMap<OneOffEntry, Integer> indexList = new HashMap<OneOffEntry, Integer>();
        for (int j2 = 0; j2 < a_Length; ++j2) {
            newElement = oneOffEntry[j2];
            newElemNotNeeded = false;
            conflictsList[j2] = new PrereqSet();
            OneOffEntry[] old_B = B.getAllElements();
            for (int i3 = 0; i3 < old_B.length; ++i3) {
                if (old_B[i3] == newElement) continue;
                ckList = new OneOffEntry[1];
                filesThatConflict = new String[1];
                bugsThatSuperset = new String[1];
                bugsThatConflict = new String[1];
                bugsThatSubset = new String[1];
                ckList[0] = old_B[i3];
                String[] bugsToFix = newElement.getBugIDsFixed();
                try {
                    Integer index;
                    PrereqSet oneOffEntrySet;
                    if (conflictHandler.isBugSuperset(ckList, bugsToFix, bugsThatSuperset)) {
                        if (!conflictHandler.isFileSuperset(ckList[0], newElement.getPatchActions())) {
                            OLogger.debug(OLogger.getString("OUI-67644", new Object[]{newElement.getID(), ckList[0].getID()}));
                        }
                        OneOffEntry subSetElement = old_B[i3];
                        B.delete(subSetElement);
                        if (patchesInOH.contains(subSetElement)) {
                            R.add(subSetElement);
                        }
                        if (C.contains(subSetElement)) {
                            C.delete(subSetElement);
                            C.add(newElement);
                        }
                        PrereqAPI.updateSuperSubRelationship(super_sub, newElement, subSetElement);
                        if (patchesInOH.contains(subSetElement) && subSetElement.getTripletID().equals(newElement.getTripletID())) {
                            patchesInOH.delete(subSetElement);
                        } else {
                            D.add(subSetElement);
                        }
                        OLogger.printlnOnLog("Patch " + newElement.getID() + " is superset of " + old_B[i3].getID());
                        continue;
                    }
                    if (conflictHandler.isBugSubset(ckList, bugsToFix, bugsThatSubset)) {
                        D.add(newElement);
                        newElemNotNeeded = true;
                        B.delete(newElement);
                        if (C.contains(newElement)) {
                            C.delete(newElement);
                            if (!C.contains(old_B[i3])) {
                                C.add(old_B[i3]);
                            }
                        }
                        PrereqAPI.updateSuperSubRelationship(super_sub, old_B[i3], newElement);
                        if (patchesInOH.contains(newElement) && newElement.getID().equals(old_B[i3].getID())) {
                            patchesInOH.delete(newElement);
                        } else {
                            D.add(newElement);
                        }
                        OLogger.printlnOnLog("Patch " + newElement.getID() + " is subset of " + old_B[i3].getID());
                        continue;
                    }
                    if (conflictHandler.isBugConflict(ckList, bugsToFix, bugsThatConflict)) {
                        if (Rules.shouldErrorOnConflict(newElement, old_B[i3], oracleHomePath) && !CompositePatchObject.canIgnoreConflictWithOneOff(oracleHomePath, newElement, oneOffEntry, old_B[i3])) {
                            oneOffEntrySet = new PrereqSet(oneOffEntry);
                            if (oneOffEntrySet.contains(newElement) && oneOffEntrySet.contains(old_B[i3]) && !B.contains(newElement)) {
                                C.add(newElement);
                                C.add(old_B[i3]);
                            } else {
                                C.add(old_B[i3]);
                                C.add(newElement);
                            }
                            if (patchesInOH.contains(old_B[i3])) {
                                R.add(old_B[i3]);
                            }
                            conflictsList[j2].add(old_B[i3]);
                            if (indexList.size() > i3 && indexList.size() != 0 && (index = (Integer)indexList.get(old_B[i3])) != null) {
                                conflictsList[index].add(newElement);
                            }
                            OLogger.printlnOnLog("Patch " + newElement.getID() + " has Bug Conflict with " + old_B[i3].getID());
                            continue;
                        }
                        OLogger.printlnOnLog("Bug Conflict ignored between Patches \"" + newElement.getID() + "\" and \"" + old_B[i3].getID() + "\"");
                        continue;
                    }
                    if (!conflictHandler.isGenericConflict(oracleHomePath, ckList, newElement.getPatchActions(), filesThatConflict)) continue;
                    if (Rules.shouldErrorOnConflict(newElement, old_B[i3], oracleHomePath) && !CompositePatchObject.canIgnoreConflictWithOneOff(oracleHomePath, newElement, oneOffEntry, old_B[i3])) {
                        oneOffEntrySet = new PrereqSet(oneOffEntry);
                        if (oneOffEntrySet.contains(newElement) && oneOffEntrySet.contains(old_B[i3]) && !C.contains(newElement)) {
                            C.add(newElement);
                            C.add(old_B[i3]);
                        } else {
                            C.add(old_B[i3]);
                            C.add(newElement);
                        }
                        if (patchesInOH.contains(old_B[i3])) {
                            R.add(old_B[i3]);
                        }
                        conflictsList[j2].add(old_B[i3]);
                        if (indexList.size() > i3 && indexList.size() != 0 && (index = (Integer)indexList.get(old_B[i3])) != null) {
                            conflictsList[index].add(newElement);
                        }
                        OLogger.printlnOnLog("Patch " + newElement.getID() + " has Generic Conflict with " + old_B[i3].getID());
                        continue;
                    }
                    OLogger.printlnOnLog("Generic Conflict ignored between Patches \"" + newElement.getID() + "\" and \"" + old_B[i3].getID() + "\"");
                    continue;
                }
                catch (BugSupersetException e3) {
                    resObj.addDetail(e3);
                    resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                    OLogger.printlnOnLog("BugSupersetException occurred : " + e3.getMessage());
                    return resObj;
                }
                catch (BugSubsetException e4) {
                    resObj.addDetail(e4);
                    resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                    OLogger.printlnOnLog("BugSubsetException occurred : " + e4.getMessage());
                    return resObj;
                }
                catch (BugConflictException e5) {
                    resObj.addDetail(e5);
                    resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                    OLogger.printlnOnLog("BugConflictException occurred : " + e5.getMessage());
                    return resObj;
                }
                catch (GenericConflictException e6) {
                    resObj.addDetail(e6);
                    resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                    OLogger.printlnOnLog("GenericConflictException occurred : " + e6.getMessage());
                    return resObj;
                }
            }
            if (newElemNotNeeded) continue;
            B.add(newElement);
            indexList.put(newElement, new Integer(j2));
            OLogger.printlnOnLog("Patch " + newElement.getID() + " is not subset of any other patch processed till now");
        }
        if (C.size() == 1) {
            B.add(C.getElement(0));
            C.delete(0);
        }
        PrereqAPI.updateConflictRelationships(super_sub, oneOffEntry, OHOneOffs, conflictsList, C);
        PrereqSet tmp = B.delete(patchesInOH);
        resObj.update(tmp.delete(C), C, D, R);
        resObj = PrereqAPI.processOverLay(oneOffEntry, resObj, conflictsList, oracleHomePath);
        if (OPatchEnv.getSessionType().equals("prereq")) {
            OneOffEntry[] conflictList = resObj.getListOfPatchesToBeMerged();
            if (conflictList != null && conflictList.length != 0) {
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            } else if (resObj.getResult() != PrereqResult.ExecuteStatus.NOT_EXECUTED) {
                resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            }
        }
        return resObj;
    }

    public static PatchAction[] getAllValidPatchActions(String oracleHomePath, PatchObject patchObject) {
        StringBuffer buff = new StringBuffer("PrereqAPI::getAllValid");
        PatchAction[] patchActions = new PatchAction[]{};
        try {
            IIPMReadServices readServices = PrereqSession.getReadServices(oracleHomePath);
            ArrayList<PatchAction> patchActionsList = new ArrayList<PatchAction>();
            Map<PatchComponent, PatchComponentCheckResult> analyzed = readServices.analyzePatchComponents(patchObject, OPatchEnv.isNRollback());
            for (PatchComponent pc : patchObject.getPatchComponents()) {
                PatchComponentCheckResult pcCheckResult = analyzed.get(pc);
                if (!pcCheckResult.getResult().isProcessComponent()) continue;
                for (PatchAction pa : pc.getAllActions()) {
                    if (pa instanceof MakeAction) continue;
                    patchActionsList.add(pa);
                }
            }
            int len = patchActionsList.size();
            PatchAction[] presentActions = new PatchAction[len];
            patchActionsList.toArray(presentActions);
            patchActions = presentActions;
            buff = new StringBuffer("  Use PatchActions belong to above ");
            buff.append("PatchComponent for file-conflict check.");
            OLogger.debug(buff);
        }
        catch (Throwable t) {
            buff = new StringBuffer("  Not able to get patch object. ");
            buff.append("Return all PatchActions for all components: ");
            buff.append(t.getMessage());
            OLogger.debug(buff);
        }
        return patchActions;
    }

    public static PatchAction[] getPatchActionsForPresentComponents(String oracleHomePath, String sessionName, OneOffEntry oneOffEntry) {
        StringBuffer buff = new StringBuffer("getPatchActionsForPresentComponents(): ");
        buff.append("return PatchAction[] for present components.");
        OLogger.debug(buff);
        PatchAction[] result = new PatchAction[]{};
        try {
            IIPMReadServices readServices = PrereqSession.getReadServices(oracleHomePath);
            OneOffEntry[] tmpEntries = new OneOffEntry[]{oneOffEntry};
            PatchObject[] pos = OPatchUtilHelper.getPatchesToApply(oracleHomePath, tmpEntries, sessionName);
            PatchObject patchObjectToApply = pos[0];
            ArrayList<PatchAction> patchActionsList = new ArrayList<PatchAction>();
            Map<PatchComponent, PatchComponentCheckResult> analyzedPC = readServices.analyzePatchComponents(patchObjectToApply, OPatchEnv.isNRollback());
            for (Map.Entry<PatchComponent, PatchComponentCheckResult> entry : analyzedPC.entrySet()) {
                if (entry.getValue().getResult().isProcessComponent()) {
                    PatchComponent pc = entry.getKey();
                    for (PatchAction pa : pc.getAllActions()) {
                        if (pa instanceof MakeAction) continue;
                        patchActionsList.add(pa);
                    }
                    continue;
                }
                if (!OPatchEnv.isCUPSupported() && !entry.getValue().getResult().isVersionMismatch()) continue;
                return result;
            }
            buff = new StringBuffer("  Use PatchActions belong to above ");
            buff.append("PatchComponent for file-conflict check.");
            OLogger.debug(buff);
            return patchActionsList.toArray(new PatchAction[patchActionsList.size()]);
        }
        catch (Throwable t) {
            buff = new StringBuffer("  Not able to get patch object. ");
            buff.append("Return all PatchActions for all components: ");
            buff.append(t.getMessage());
            OLogger.debug(buff);
            return result;
        }
    }

    public static ConflictOutput checkConflictAgainstOHSkipMissingComps(String oracleHomePath, String sessionName, OneOffEntry[] piOneOffs) {
        CheckConflictAdapter adapter = new CheckConflictAdapter();
        ConflictOutput resObj = new ConflictOutput();
        OneOffEntry[] pohOneOffs = null;
        try {
            pohOneOffs = PrereqAPI.getInstalledOneOff(oracleHomePath);
            if (pohOneOffs.length != 0) {
                StringBuffer oBuf = new StringBuffer("\nList of patches in the OH :\n");
                int ohLen = pohOneOffs.length;
                for (int i2 = 0; i2 < ohLen; ++i2) {
                    oBuf.append(pohOneOffs[i2].getID());
                    if (i2 == ohLen - 1) continue;
                    oBuf.append(", ");
                }
                OLogger.debug(oBuf);
            }
        }
        catch (Throwable t) {
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            StringBuffer buff = new StringBuffer("Throwable Occured: " + t.getMessage());
            buff.append("\nThe throwable is converted into Exception and stored in Result Object.");
            OLogger.printlnOnLog(buff.toString());
            Exception e2 = new Exception(t.getMessage());
            e2.setStackTrace(t.getStackTrace());
            resObj.addDetail(e2);
            return resObj;
        }
        resObj = adapter.checkConflictAgainstOHSkipMissingComps(oracleHomePath, piOneOffs, pohOneOffs);
        return resObj;
    }

    public static ConflictOutput checkConflictAgainstOHSkipMissingComps_backup(String oracleHomePath, String sessionName, OneOffEntry[] oneOffEntry) {
        StringBuffer buff = new StringBuffer("PrereqAPI:checkConflictAgainstOHSkipMissingComps()");
        OLogger.debug(buff);
        OneOffEntry newElement = null;
        OneOffEntry[] OHOneOffs = null;
        ConflictOutput resObj = new ConflictOutput();
        try {
            OHOneOffs = PrereqAPI.getInstalledOneOff(oracleHomePath);
        }
        catch (Throwable t) {
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            buff = new StringBuffer("Throwable Occured: " + t.getMessage());
            buff.append("\nThe throwable is converted into Exception and stored in Result Object.");
            OLogger.printlnOnLog(buff.toString());
            Exception e2 = new Exception(t.getMessage());
            e2.setStackTrace(t.getStackTrace());
            resObj.addDetail(e2);
            return resObj;
        }
        if (oneOffEntry.length != 0) {
            StringBuffer tBuf = new StringBuffer("\nList of patches on which the InterConflict prereq runs are :\n");
            int oLen = oneOffEntry.length;
            for (int i2 = 0; i2 < oLen; ++i2) {
                tBuf.append(oneOffEntry[i2].getID());
                if (i2 == oLen - 1) continue;
                tBuf.append(", ");
            }
            OLogger.debug(tBuf);
        }
        PrereqSet patchesInOH = new PrereqSet(OHOneOffs);
        PrereqSet[] conflictsList = new PrereqSet[oneOffEntry.length];
        PrereqSet B = new PrereqSet(OHOneOffs);
        PrereqSet C = new PrereqSet();
        PrereqSet D = new PrereqSet();
        PrereqSet R = new PrereqSet();
        int a_Length = oneOffEntry.length;
        String[] filesThatConflict = null;
        String[] bugsThatSuperset = null;
        String[] bugsThatConflict = null;
        String[] bugsThatSubset = null;
        OneOffEntry[] ckList = null;
        boolean newElemNotNeeded = false;
        ConflictHandler conflictHandler = new ConflictHandler(true, true, true, true);
        HashMap super_sub = new HashMap();
        HashMap<OneOffEntry, Integer> indexList = new HashMap<OneOffEntry, Integer>();
        for (int j2 = 0; j2 < a_Length; ++j2) {
            newElement = oneOffEntry[j2];
            newElemNotNeeded = false;
            PatchAction[] patchActions = PrereqAPI.getPatchActionsForPresentComponents(oracleHomePath, sessionName, newElement);
            conflictsList[j2] = new PrereqSet();
            OneOffEntry[] old_B = B.getAllElements();
            for (int i3 = 0; i3 < old_B.length; ++i3) {
                ckList = new OneOffEntry[1];
                filesThatConflict = new String[1];
                bugsThatSuperset = new String[1];
                bugsThatConflict = new String[1];
                bugsThatSubset = new String[1];
                ckList[0] = old_B[i3];
                String[] bugsToFix = newElement.getBugIDsFixed();
                try {
                    Integer index;
                    if (conflictHandler.isBugSuperset(ckList, bugsToFix, bugsThatSuperset)) {
                        if (!conflictHandler.isFileSuperset(ckList[0], patchActions)) {
                            OLogger.debug(OLogger.getString("OUI-67644", new Object[]{newElement.getID(), ckList[0].getID()}));
                        }
                        if (Rules.shouldErrorOnConflict(newElement, old_B[i3], oracleHomePath)) {
                            OneOffEntry subSetElement = old_B[i3];
                            B.delete(subSetElement);
                            if (patchesInOH.contains(subSetElement)) {
                                R.add(subSetElement);
                            }
                            if (C.contains(subSetElement)) {
                                C.delete(subSetElement);
                                C.add(newElement);
                            }
                            PrereqAPI.updateSuperSubRelationship(super_sub, newElement, subSetElement);
                            if (patchesInOH.contains(subSetElement) && subSetElement.getTripletID().equals(newElement.getTripletID())) {
                                patchesInOH.delete(subSetElement);
                            } else {
                                D.add(subSetElement);
                            }
                            OLogger.printlnOnLog("Patch " + newElement.getID() + " is superset of " + old_B[i3].getID());
                            continue;
                        }
                        OLogger.printlnOnLog("Ignore the relation that patch \"" + newElement.getID() + "\" is superset of \"" + old_B[i3].getID() + "\"");
                        continue;
                    }
                    if (conflictHandler.isBugSubset(ckList, bugsToFix, bugsThatSubset)) {
                        D.add(newElement);
                        newElemNotNeeded = true;
                        B.delete(newElement);
                        if (C.contains(newElement)) {
                            C.delete(newElement);
                            if (!C.contains(old_B[i3])) {
                                C.add(old_B[i3]);
                            }
                        }
                        PrereqAPI.updateSuperSubRelationship(super_sub, old_B[i3], newElement);
                        if (patchesInOH.contains(newElement) && newElement.getID().equals(old_B[i3].getID())) {
                            patchesInOH.delete(newElement);
                        } else {
                            D.add(newElement);
                        }
                        OLogger.printlnOnLog("Patch " + newElement.getID() + " is subset of " + old_B[i3].getID());
                        continue;
                    }
                    if (conflictHandler.isBugConflict(ckList, bugsToFix, bugsThatConflict)) {
                        if (Rules.shouldErrorOnConflict(newElement, old_B[i3], oracleHomePath) && !CompositePatchObject.canIgnoreConflictWithOneOff(oracleHomePath, newElement, oneOffEntry, old_B[i3])) {
                            C.add(old_B[i3]);
                            C.add(newElement);
                            if (patchesInOH.contains(old_B[i3])) {
                                R.add(old_B[i3]);
                            }
                            conflictsList[j2].add(old_B[i3]);
                            if (indexList.size() > i3 && indexList.size() != 0 && (index = (Integer)indexList.get(old_B[i3])) != null) {
                                conflictsList[index].add(newElement);
                            }
                            OLogger.printlnOnLog("Patch " + newElement.getID() + " has Bug Conflict with " + old_B[i3].getID());
                            continue;
                        }
                        OLogger.printlnOnLog("Bug Conflict ignored between Patches \"" + newElement.getID() + "\" and \"" + old_B[i3].getID() + "\"");
                        continue;
                    }
                    if (!conflictHandler.isGenericConflict(oracleHomePath, ckList, patchActions, filesThatConflict)) continue;
                    if (Rules.shouldErrorOnConflict(newElement, old_B[i3], oracleHomePath) && !CompositePatchObject.canIgnoreConflictWithOneOff(oracleHomePath, newElement, oneOffEntry, old_B[i3])) {
                        C.add(old_B[i3]);
                        C.add(newElement);
                        if (patchesInOH.contains(old_B[i3])) {
                            R.add(old_B[i3]);
                        }
                        conflictsList[j2].add(old_B[i3]);
                        if (indexList.size() > i3 && indexList.size() != 0 && (index = (Integer)indexList.get(old_B[i3])) != null) {
                            conflictsList[index].add(newElement);
                        }
                        OLogger.printlnOnLog("Patch " + newElement.getID() + " has Generic Conflict with " + old_B[i3].getID());
                        continue;
                    }
                    OLogger.printlnOnLog("Generic Conflict ignored between Patches \"" + newElement.getID() + "\" and \"" + old_B[i3].getID() + "\"");
                    continue;
                }
                catch (BugSupersetException e3) {
                    resObj.addDetail(e3);
                    resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                    OLogger.printlnOnLog("BugSupersetException occurred : " + e3.getMessage());
                    return resObj;
                }
                catch (BugSubsetException e4) {
                    resObj.addDetail(e4);
                    resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                    OLogger.printlnOnLog("BugSubsetException occurred : " + e4.getMessage());
                    return resObj;
                }
                catch (BugConflictException e5) {
                    resObj.addDetail(e5);
                    resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                    OLogger.printlnOnLog("BugConflictException occurred : " + e5.getMessage());
                    return resObj;
                }
                catch (GenericConflictException e6) {
                    resObj.addDetail(e6);
                    resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                    OLogger.printlnOnLog("GenericConflictException occurred : " + e6.getMessage());
                    return resObj;
                }
            }
            if (newElemNotNeeded) continue;
            B.add(newElement);
            indexList.put(newElement, new Integer(j2));
            OLogger.printlnOnLog("Patch " + newElement.getID() + " is not subset of any other patch processed till now");
        }
        if (C.size() == 1) {
            B.add(C.getElement(0));
            C.delete(0);
        }
        PrereqAPI.updateConflictRelationships(super_sub, oneOffEntry, OHOneOffs, conflictsList, C);
        PrereqSet tmp = B.delete(patchesInOH);
        resObj.update(tmp.delete(C), C, D, R);
        resObj = PrereqAPI.processOverLay(oneOffEntry, resObj, conflictsList, oracleHomePath);
        return resObj;
    }

    private static void updateConflictRelationships(HashMap super_sub, OneOffEntry[] oneOffEntry, OneOffEntry[] OHOneOffs, PrereqSet[] conflictsList, PrereqSet mergeList) {
        int oIter;
        int a_Length = oneOffEntry.length;
        if (oneOffEntry == null || OHOneOffs == null) {
            throw new RuntimeException("API updateConflictRelationShips() does not allow null OneOffEntry objects.");
        }
        OneOffEntry[] mergedOneOffList = new OneOffEntry[oneOffEntry.length + OHOneOffs.length];
        int mIter = 0;
        for (oIter = 0; oIter < oneOffEntry.length; ++oIter) {
            mergedOneOffList[mIter++] = oneOffEntry[oIter];
        }
        for (oIter = 0; oIter < OHOneOffs.length; ++oIter) {
            mergedOneOffList[mIter++] = OHOneOffs[oIter];
        }
        if (super_sub != null && super_sub.size() != 0) {
            for (int j2 = 0; j2 < mergedOneOffList.length; ++j2) {
                Set myKeys = super_sub.keySet();
                for (OneOffEntry curKey : myKeys) {
                    HashSet curValues = (HashSet)super_sub.get(curKey);
                    for (OneOffEntry subsetVal : curValues) {
                        if (mergeList.contains(subsetVal)) {
                            mergeList.delete(subsetVal);
                            if (!mergeList.contains(curKey)) {
                                mergeList.add(curKey);
                            }
                        }
                        if (j2 < a_Length && conflictsList[j2].contains(subsetVal)) {
                            OLogger.printlnOnLog("Delete this subset patch \"" + subsetVal.getID() + "\" from the Conflict list of \"" + mergedOneOffList[j2].getID() + "\"");
                            conflictsList[j2].delete(subsetVal);
                            if (!conflictsList[j2].contains(curKey)) {
                                OLogger.printlnOnLog("Add this superset patch \"" + curKey.getID() + "\" to the Conflict list of \"" + mergedOneOffList[j2].getID() + "\"");
                                conflictsList[j2].add(curKey);
                            }
                        }
                        for (int k2 = 0; k2 < mergedOneOffList.length; ++k2) {
                            if (!mergedOneOffList[k2].equals(subsetVal) || k2 >= a_Length || !conflictsList[k2].contains(mergedOneOffList[k2])) continue;
                            OLogger.printlnOnLog("Delete patch \"" + mergedOneOffList[k2].getID() + "\" from the conflicts list of subset patch \"" + mergedOneOffList[k2].getID() + "\"");
                            conflictsList[k2].delete(mergedOneOffList[k2]);
                        }
                    }
                }
            }
        }
        for (int i2 = 0; i2 < oneOffEntry.length; ++i2) {
            OLogger.printlnOnLog("Patch ID  " + oneOffEntry[i2].getID());
            OLogger.printlnOnLog("Patches that conflict: " + conflictsList[i2].toString());
        }
    }

    private static void updateSuperSubRelationship(HashMap super_sub, OneOffEntry supersetElement, OneOffEntry subsetElement) {
        Set myKeys = super_sub.keySet();
        Iterator itr = myKeys.iterator();
        HashSet value = new HashSet();
        while (itr.hasNext()) {
            OneOffEntry curKey = (OneOffEntry)itr.next();
            if (!curKey.equals(subsetElement)) continue;
            value = (HashSet)super_sub.get(curKey);
            super_sub.remove(curKey);
            break;
        }
        HashSet<OneOffEntry> newValue = new HashSet<OneOffEntry>();
        OneOffEntry newKey = supersetElement;
        if (value != null && value.size() != 0) {
            newValue.addAll(value);
        }
        newValue.add(subsetElement);
        super_sub.put(newKey, newValue);
    }

    protected static OneOffEntry[] filterOverLaidOneOffs(OneOffEntry[] oneOffs) {
        PrereqSet filterList = new PrereqSet(oneOffs);
        for (int i2 = 0; i2 < oneOffs.length; ++i2) {
            String[] overLaidPatchIDs = oneOffs[i2].getOverLayPatchIDs();
            filterList.delete(overLaidPatchIDs);
        }
        return filterList.getAllElements();
    }

    public static ArrayList CompositesBeingRollbacked(OneOffEntry[] oneoffs) {
        if (oneoffs == null) {
            return null;
        }
        ArrayList<String> list_of_composites = new ArrayList<String>();
        for (int i2 = 0; i2 < oneoffs.length; ++i2) {
            if (!oneoffs[i2].getIsComposite()) continue;
            list_of_composites.add(oneoffs[i2].getID());
        }
        return list_of_composites;
    }

    protected static void printList(OneOffEntry[] oneOffEntry) {
        OLogger.debug("Print the list of OneOffEntry(Pi)");
        for (OneOffEntry entry : oneOffEntry) {
            OLogger.debug("PID=" + entry.getID());
        }
        OLogger.debug("end print\n");
    }

    protected static ConflictOutput processOverLay(OneOffEntry[] oneOffEntry, ConflictOutput cOutput, PrereqSet[] conflictingOneOffs, String oracleHomePath) {
        int i2;
        PrereqSet mergeList = new PrereqSet(cOutput.getListOfPatchesToBeMerged());
        PrereqSet autoRollbackList = new PrereqSet(cOutput.getListOfPatchesThatNeedToBeRollback());
        PrereqSet notNeededList = new PrereqSet(cOutput.getListOfPatchesNotNeeded());
        PrereqSet canGoNowList = new PrereqSet(cOutput.getListOfPatchesThatCanGoNow());
        PrereqSet cleanUpList = new PrereqSet();
        OneOffEntry[] originalPi = null;
        OneOffEntry[] OHOneOffs = null;
        PrereqAPI.printList(oneOffEntry);
        for (PrereqSet p2 : conflictingOneOffs) {
            p2.print("Before ProcessOverlay,Conflicting List is");
        }
        mergeList.print("INPUT:mergeList");
        autoRollbackList.print("INPUT:autorollbackList");
        notNeededList.print("INPUT:notneededList");
        canGoNowList.print("INPUT:cangonowList");
        PrereqSet oneOffEntrySet = new PrereqSet(oneOffEntry);
        for (int cIter = 0; cIter < conflictingOneOffs.length; ++cIter) {
            int ohIter;
            int cIter1;
            int ovIter;
            String[] overlayPsu;
            boolean isInPi;
            PrereqSet conflictingList = conflictingOneOffs[cIter];
            originalPi = OPatchEnv.getPi();
            try {
                OHOneOffs = PrereqAPI.getInstalledOneOff(oracleHomePath);
            }
            catch (Throwable e2) {
                OLogger.debug(new StringBuffer("Converting Throwable to RuntimeException"));
                RuntimeException re = new RuntimeException(e2.getMessage());
                re.setStackTrace(e2.getStackTrace());
            }
            if (originalPi != null) {
                isInPi = false;
                overlayPsu = oneOffEntry[cIter].getOverLayPatchIDs();
                for (ovIter = 0; ovIter < overlayPsu.length; ++ovIter) {
                    for (cIter1 = 0; cIter1 < originalPi.length; ++cIter1) {
                        if (!overlayPsu[ovIter].equals(originalPi[cIter1].getID()) || !originalPi[cIter1].getIsComposite()) continue;
                        conflictingList.add(originalPi[cIter1]);
                        isInPi = true;
                    }
                    if (isInPi) continue;
                    for (ohIter = 0; ohIter < OHOneOffs.length; ++ohIter) {
                        if (!overlayPsu[ovIter].equals(OHOneOffs[ohIter].getID()) || !OHOneOffs[ohIter].getIsComposite()) continue;
                        conflictingList.add(OHOneOffs[ohIter]);
                    }
                }
            } else {
                isInPi = false;
                overlayPsu = oneOffEntry[cIter].getOverLayPatchIDs();
                for (ovIter = 0; ovIter < overlayPsu.length; ++ovIter) {
                    for (cIter1 = 0; cIter1 < oneOffEntry.length; ++cIter1) {
                        if (!overlayPsu[ovIter].equals(oneOffEntry[cIter1].getID()) || !oneOffEntry[cIter1].getIsComposite()) continue;
                        conflictingList.add(oneOffEntry[cIter1]);
                        isInPi = true;
                    }
                    if (isInPi) continue;
                    for (ohIter = 0; ohIter < OHOneOffs.length; ++ohIter) {
                        if (!overlayPsu[ovIter].equals(OHOneOffs[ohIter].getID()) || !OHOneOffs[ohIter].getIsComposite()) continue;
                        conflictingList.add(OHOneOffs[ohIter]);
                    }
                }
            }
            int size = conflictingList.size();
            for (i2 = 0; i2 < size; ++i2) {
                OneOffEntry p3 = conflictingList.getElement(i2);
                if (!p3.getIsComposite()) continue;
                String[] listOfPsu = CompositePatchObject.getConstituentList(p3.getCompositeFileLocation());
                ArrayList<Integer> toDeleteList = new ArrayList<Integer>();
                for (int s = 0; s < listOfPsu.length; ++s) {
                    for (int j2 = 0; j2 < size; ++j2) {
                        if (j2 == i2 || !listOfPsu[s].equals(conflictingList.getElement(j2).getID())) continue;
                        toDeleteList.add(j2);
                    }
                }
                int[] array = new int[toDeleteList.size()];
                for (int ii = 0; ii < toDeleteList.size(); ++ii) {
                    array[ii] = (Integer)toDeleteList.get(ii);
                }
                Arrays.sort(array);
                for (int l2 = array.length - 1; l2 >= 0; --l2) {
                    conflictingList.delete(array[l2]);
                }
                size -= array.length;
            }
            String[] allOverlaysOfPi = oneOffEntry[cIter].getTotalOverLayPatchIDs(oracleHomePath, oneOffEntry);
            for (int oIter = 0; oIter < size; ++oIter) {
                OneOffEntry p4 = conflictingList.getElement(oIter);
                if (p4.isOverlay(oneOffEntry[cIter].getPatchID()) && oneOffEntrySet.contains(p4)) {
                    conflictingList.delete(p4);
                    --oIter;
                    --size;
                    continue;
                }
                for (int aov = 0; aov < allOverlaysOfPi.length; ++aov) {
                    if (!p4.getID().equals(allOverlaysOfPi[aov])) continue;
                    conflictingList.delete(p4);
                    --oIter;
                    --size;
                }
            }
            for (int eIter = 0; eIter < size; ++eIter) {
                OneOffEntry p5 = conflictingList.getElement(eIter);
                if (!p5.getPatchID().equals(oneOffEntry[cIter].getPatchID())) continue;
                if (PrereqAPI.compareDate(p5.getCreationDate(), oneOffEntry[cIter].getCreationDate()) < 0L) {
                    if (oneOffEntrySet.contains(p5)) {
                        notNeededList.add(p5);
                    } else {
                        autoRollbackList.add(p5);
                    }
                    cleanUpList.add(p5);
                    conflictingList.delete(p5);
                    --eIter;
                    --size;
                    continue;
                }
                notNeededList.add(oneOffEntry[cIter]);
                size = 0;
                cleanUpList.add(oneOffEntry[cIter]);
            }
        }
        for (int t = 0; t < cleanUpList.size(); ++t) {
            OneOffEntry cleanElem = cleanUpList.getElement(t);
            for (int i3 = 0; i3 < conflictingOneOffs.length; ++i3) {
                int size = conflictingOneOffs[i3].size();
                if (!conflictingOneOffs[i3].contains(cleanElem)) continue;
                conflictingOneOffs[i3].delete(cleanElem);
            }
        }
        block20: for (int mIter = 0; mIter < mergeList.size(); ++mIter) {
            OneOffEntry mergeElem = mergeList.getElement(mIter);
            if (oneOffEntrySet.contains(mergeElem)) {
                for (int i4 = 0; i4 < oneOffEntrySet.size(); ++i4) {
                    if (!mergeElem.getID().equals(oneOffEntry[i4].getID()) || conflictingOneOffs[i4].size() != 0) continue;
                    mergeList.delete(mergeElem);
                    --mIter;
                    if (notNeededList.contains(mergeElem)) continue block20;
                    canGoNowList.add(mergeElem);
                    continue block20;
                }
                continue;
            }
            boolean isContain = false;
            for (i2 = 0; i2 < conflictingOneOffs.length; ++i2) {
                if (!conflictingOneOffs[i2].contains(mergeElem)) continue;
                isContain = true;
                break;
            }
            if (isContain || !mergeElem.getIsComposite() && cleanUpList.contains(mergeElem)) continue;
            autoRollbackList.delete(mergeElem);
            mergeList.delete(mergeElem);
            --mIter;
        }
        for (OneOffEntry pIn : oneOffEntry) {
            String[] overlay = pIn.getOverLayPatchIDs();
            autoRollbackList.delete(overlay);
        }
        if (mergeList.size() == 0 && notNeededList.size() == 0 && autoRollbackList.size() == 0) {
            cOutput.setResult(PrereqResult.ExecuteStatus.PASSED);
        }
        cOutput.setListOfPatchesNotNeeded(notNeededList.getAllElements());
        cOutput.setListOfPatchesThatNeedToBeRollback(autoRollbackList.getAllElements());
        cOutput.setListOfPatchesToBeMerged(mergeList.getAllElements());
        cOutput.setListOfPatchesThatCanGoNow(canGoNowList.getAllElements());
        for (PrereqSet p6 : conflictingOneOffs) {
            p6.print("After ProcessOverLay,conflicting list is");
        }
        mergeList.print("OUTPUT:mergeList");
        autoRollbackList.print("OUTPUT:autorollbackList");
        notNeededList.print("OUTPUT:notneededList");
        canGoNowList.print("OUTPUT:cangonowList");
        return cOutput;
    }

    private static long compareDate(String s1, String s2) {
        SimpleDateFormat df = new SimpleDateFormat("dd MMM yyyy, HH:mm:ss 'hrs'");
        StringTokenizer tokenizer1 = new StringTokenizer(s1, " ");
        StringTokenizer tokenizer2 = new StringTokenizer(s2, " ");
        StringBuffer timebuff1 = new StringBuffer(tokenizer1.nextToken());
        StringBuffer timebuff2 = new StringBuffer(tokenizer2.nextToken());
        String z1 = "";
        String z2 = "";
        try {
            timebuff1.append(" ");
            timebuff1.append(tokenizer1.nextToken());
            timebuff1.append(" ");
            timebuff1.append(tokenizer1.nextToken());
            timebuff1.append(" ");
            timebuff1.append(tokenizer1.nextToken());
            timebuff1.append(" ");
            timebuff1.append(tokenizer1.nextToken());
            z1 = tokenizer1.nextToken();
            timebuff2.append(" ");
            timebuff2.append(tokenizer2.nextToken());
            timebuff2.append(" ");
            timebuff2.append(tokenizer2.nextToken());
            timebuff2.append(" ");
            timebuff2.append(tokenizer2.nextToken());
            timebuff2.append(" ");
            timebuff2.append(tokenizer2.nextToken());
            z2 = tokenizer2.nextToken();
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
        }
        long l1 = 0L;
        try {
            df.setTimeZone(TimeZone.getTimeZone(z1));
        }
        catch (Exception e3) {
            OLogger.printStackTrace(e3);
        }
        try {
            l1 = df.parse(timebuff1.toString()).getTime();
        }
        catch (Exception e4) {
            OLogger.printStackTrace(e4);
        }
        long l2 = 0L;
        try {
            df.setTimeZone(TimeZone.getTimeZone(z2));
        }
        catch (Exception e5) {
            OLogger.printStackTrace(e5);
        }
        try {
            l2 = df.parse(timebuff2.toString()).getTime();
        }
        catch (Exception e6) {
            OLogger.printStackTrace(e6);
        }
        return l1 - l2;
    }

    private static boolean checkPath(String path) {
        if (path == null || path.length() == 0) {
            return false;
        }
        Path fp = WrapperFactory.getNioServiceWrapper().getPath(path, new String[0]);
        return Files.exists(fp, new LinkOption[0]);
    }

    private static String[] getFilePID(String filePath, boolean isOpatch) {
        String[] pid = new String[]{""};
        OLogger.debug("INFO PrereAPI->getFilePID() : OPATCH_NO_FUSER is set to : " + opatchNoFuser);
        OLogger.debug("INFO PrereAPI->getFilePID() : fuser File to be checked :" + filePath);
        if (OPatchEnv.isOPATCH_NO_FUSER()) {
            OLogger.printlnOnLog("INFO PrereAPI->getFilePID() : Skip fuser execution as OPATCH_NO_FUSER is set to : " + opatchNoFuser);
            OLogger.debug("INFO PrereAPI->getFilePID() : Skip fuser execution as OPATCH_NO_FUSER is set to : " + opatchNoFuser);
            return pid;
        }
        if (OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS)) {
            StringBuffer buff = new StringBuffer("Env is casrepo enabled, skipping getFilePID & skipped fuser");
            OLogger.printlnOnLog(buff.toString());
            return pid;
        }
        ArrayList<String> pidlist = new ArrayList<String>();
        Path fp = WrapperFactory.getNioServiceWrapper().getPath(filePath, new String[0]);
        if (!Files.exists(fp, new LinkOption[0])) {
            StringBuffer tmpSb = new StringBuffer("File does not exist:");
            tmpSb.append(" ");
            tmpSb.append(filePath);
            OLogger.verbose(OPatchSession.PREREQ, tmpSb);
            return pid;
        }
        if (OPatchEnv.isWindows()) {
            try {
                pidlist.add(PrereqAPI.getProcessExecWin(filePath));
                pid = pidlist.toArray(new String[0]);
            }
            catch (Exception e2) {
                RuntimeException re = new RuntimeException(e2.getMessage());
                re.setStackTrace(e2.getStackTrace());
                throw re;
            }
        } else {
            String fuserLoc = PrereqAPI.getFuserLocation();
            if (fuserLoc == null || fuserLoc.equals("")) {
                StringBuffer tmpSb = new StringBuffer("fuser could not be located:");
                tmpSb.append(" ");
                tmpSb.append(fuserLoc);
                OLogger.verbose(OPatchSession.PREREQ, tmpSb);
                RuntimeException re = new RuntimeException(tmpSb.toString());
                throw re;
            }
            String[] systemCommand = new String[1];
            StringBuffer commSb = new StringBuffer(fuserLoc);
            if (isOpatch) {
                commSb.append(" -c ");
            } else {
                commSb.append(" ");
            }
            commSb.append(filePath);
            systemCommand[0] = commSb.toString();
            String runDir = fp.getParent().toString();
            SystemCall.ExecReturn ret = SystemCall.runtimeExec(systemCommand, null, runDir);
            String nMsg = ret.getNormalMessage();
            String eMsg = ret.getErrorMessage();
            if (!ret.isOK() && !eMsg.isEmpty()) {
                StringBuffer tmpSb = new StringBuffer("Failed to execute the command.\n");
                tmpSb.append(ret.getErrorMessage());
                OLogger.verbose(OPatchSession.PREREQ, tmpSb);
            }
            if (!isOpatch) {
                pidlist.add(nMsg.trim());
            } else {
                String[] words = nMsg.split("\\s+");
                if (words.length > 1) {
                    Pattern pDigit = Pattern.compile("^\\d+");
                    for (String s : words) {
                        Matcher mDigit = pDigit.matcher(s);
                        if (!mDigit.find()) continue;
                        pidlist.add(s.replaceAll("[^(0-9)]", ""));
                    }
                }
            }
            pid = pidlist.toArray(new String[0]);
        }
        return pid;
    }

    private static String[] getActiveFiles(String[][] files) throws RuntimeException {
        String[] result = new String[]{};
        ArrayList<String> tmpAl = new ArrayList<String>();
        if (OPatchEnv.isWindows()) {
            for (int i2 = 0; i2 < files.length; ++i2) {
                Path fp;
                String parentFile = files[i2][1];
                String[] nestedFiles = parentFile.split(":");
                if (nestedFiles.length > 2) {
                    parentFile = nestedFiles[0] + ":" + nestedFiles[1];
                }
                if (!Files.exists(fp = WrapperFactory.getNioServiceWrapper().getPath(parentFile, new String[0]), new LinkOption[0])) {
                    StringBuffer buff = new StringBuffer("\nSkipping the check on \"");
                    buff.append(files[i2][1]);
                    buff.append("\" as the file does not exitst.");
                    OLogger.debug(buff);
                    continue;
                }
                if (Files.isDirectory(fp, new LinkOption[0])) {
                    StringBuffer buff = new StringBuffer("\nSkipping the check on \"");
                    buff.append(files[i2][1]);
                    buff.append("\" as it is a directory.");
                    OLogger.debug(buff);
                    continue;
                }
                try {
                    boolean fileIsActive = OiipwWin32NativeCalls.isFileInUse((String)files[i2][1]);
                    if (!fileIsActive) continue;
                    tmpAl.add(files[i2][1]);
                    continue;
                }
                catch (Exception e2) {
                    RuntimeException re = new RuntimeException(e2.getMessage());
                    re.setStackTrace(e2.getStackTrace());
                    throw re;
                }
            }
        }
        if (tmpAl.size() > 0) {
            result = new String[tmpAl.size()];
            tmpAl.toArray(result);
        }
        return result;
    }

    private static String[] getActiveExecutables(String[] executables) throws RuntimeException, IOException {
        OLogger.debug("INFO PrereAPI->getActiveExecutables() : OPATCH_NO_FUSER is set to : " + opatchNoFuser);
        for (int i2 = 0; i2 < executables.length; ++i2) {
            OLogger.debug("INFO PrereqAPI -> getActiveExecutables() : Executables : " + executables[i2]);
        }
        if (OPatchEnv.isOPATCH_NO_FUSER()) {
            OLogger.printlnOnLog("INFO PrereAPI->getActiveExecutables() : Skip fuser execution as OPATCH_NO_FUSER is set to : " + opatchNoFuser);
            return new String[0];
        }
        if (OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS)) {
            StringBuffer buff = new StringBuffer("Env is casrepo enabled, skipping prereq -> getActiveExecutables & skipped fuser");
            OLogger.printlnOnLog(buff.toString());
            return new String[0];
        }
        String[] result = new String[]{};
        ArrayList<String> tmpAl = new ArrayList<String>();
        if (OPatchEnv.isWindows()) {
            for (int i3 = 0; i3 < executables.length; ++i3) {
                if (executablesChecked.contains(executables[i3])) continue;
                executablesChecked.add(executables[i3]);
                Path fp = WrapperFactory.getNioServiceWrapper().getPath(executables[i3], new String[0]);
                if (!Files.exists(fp, new LinkOption[0])) {
                    StringBuffer buff = new StringBuffer("\nSkipping the check on \"");
                    buff.append(executables[i3]);
                    buff.append("\" as the file does not exitst.");
                    OLogger.debug(buff);
                    continue;
                }
                if (Files.isDirectory(fp, new LinkOption[0])) {
                    StringBuffer buff = new StringBuffer("\nSkipping the check on \"");
                    buff.append(executables[i3]);
                    buff.append("\" as it is a directory.");
                    OLogger.debug(buff);
                    continue;
                }
                try {
                    boolean fileIsActive = OiipwWin32NativeCalls.isFileInUse((String)executables[i3]);
                    if (!fileIsActive) continue;
                    String pid = PrereqAPI.getProcessExecWin(executables[i3]);
                    tmpAl.add(executables[i3]);
                    StringBuffer activeFiles = new StringBuffer(executables[i3]);
                    activeFiles.append(" PID(");
                    activeFiles.append(pid);
                    activeFiles.append(")");
                    OLogger.printlnOnLog(activeFiles.toString());
                    continue;
                }
                catch (Exception e2) {
                    RuntimeException re = new RuntimeException(e2.getMessage());
                    re.setStackTrace(e2.getStackTrace());
                    throw re;
                }
            }
        } else {
            String fuserLoc = PrereqAPI.getFuserLocation();
            if (fuserLoc == null || fuserLoc.equals("")) {
                StringBuffer tmpSb = new StringBuffer("fuser could not be located:");
                tmpSb.append(" ");
                tmpSb.append(fuserLoc);
                OLogger.verbose(OPatchSession.PREREQ, tmpSb);
                return executables;
            }
            String[] systemCommand = new String[1];
            for (int i4 = 0; i4 < executables.length; ++i4) {
                String pid;
                boolean skipFuserWarnings;
                StringBuffer buff;
                if (executablesChecked.contains(executables[i4])) continue;
                executablesChecked.add(executables[i4]);
                Path fp = WrapperFactory.getNioServiceWrapper().getPath(executables[i4], new String[0]);
                if (!Files.exists(fp, new LinkOption[0])) {
                    buff = new StringBuffer("\nSkipping invocation of fuser on \"");
                    buff.append(executables[i4]);
                    buff.append("\" as the file does not exist.");
                    OLogger.debug(buff);
                    continue;
                }
                if (Files.isDirectory(fp, new LinkOption[0])) {
                    buff = new StringBuffer("\nSkipping invocation of fuser on \"");
                    buff.append(executables[i4]);
                    buff.append("\" as it is a directory.");
                    OLogger.debug(buff);
                    continue;
                }
                StringBuffer commSb = new StringBuffer(fuserLoc);
                commSb.append(" ");
                commSb.append(executables[i4]);
                systemCommand[0] = commSb.toString();
                StringBuffer tmpB = new StringBuffer("PrereqAPI::getActiveExecutables() fuser command set to: ");
                tmpB.append(systemCommand[0]);
                OLogger.debug(tmpB);
                Path tmpF = WrapperFactory.getNioServiceWrapper().getPath(executables[i4], new String[0]);
                if (!Files.exists(tmpF, new LinkOption[0])) continue;
                String runDir = tmpF.getParent().toString();
                OLogger.log(OLogger.FINE, "Invoking fuser on \"" + executables[i4] + "\"");
                StringBuffer ts = new StringBuffer("Start fuser command ");
                ts.append(systemCommand[0]);
                ts.append(" at ");
                OLogger.logTime(ts);
                SystemCall.ExecReturn ret = SystemCall.runtimeExec(systemCommand, null, runDir);
                ts = new StringBuffer("Finish fuser command ");
                ts.append(systemCommand[0]);
                ts.append(" at ");
                OLogger.logTime(ts);
                tmpB = new StringBuffer(ret.toString());
                OLogger.debug(tmpB);
                String nMesg = ret.getNormalMessage();
                String eMesg = ret.getErrorMessage();
                if (!OPatchEnv.global_skip_fuser_warnings && !(skipFuserWarnings = OPatchEnv.getSkipFuserWarningsProp())) {
                    if (eMesg.contains("Cannot stat file") || eMesg.contains("Permission denied")) {
                        OLogger.printlnOnLog("As it is executable , checking FUSER for warning msgs ");
                        OPatchEnv.global_skip_fuser_warnings = true;
                        String msg = "Unable to run fuser command and unable to determine the active processes which are running from the OH. Please make sure that services are properly shutdown";
                        OLogger.log(msg, new Object[0]);
                        OLogger.log("Fuser error message : " + String.format("%.105s", eMesg), new Object[0]);
                        OLogger.log("Checking through DBOPerations Approach", new Object[0]);
                        DBOperations dbOperations = new DBOperations();
                        if (dbOperations.dbServiceIsRunning(OPatchEnv.getOracleHome())) {
                            System.out.println("Please check the services of the OH are shutdown before patching.");
                            if (dbOperations.serviceRunningList.size() > 0) {
                                tmpAl.add("Running service : " + dbOperations.serviceRunningList);
                            }
                        } else {
                            OLogger.printlnOnLog("FUSER fallback : DBOperations execution is complete. No service is running");
                        }
                    }
                    OLogger.printlnOnLog("No warning msgs from fuser");
                }
                if (!ret.isOK() || (pid = nMesg.trim()).isEmpty()) continue;
                tmpAl.add(executables[i4]);
                StringBuffer filesUsedPid = new StringBuffer("Files in use by a process: ");
                filesUsedPid.append(executables[i4]);
                filesUsedPid.append(" PID( ");
                filesUsedPid.append(pid);
                filesUsedPid.append(" )");
                OLogger.printlnOnLog(filesUsedPid.toString());
                OLogger.printlnOnLog("Printing more details of active processes:");
                String[] pids = pid.split(" ");
                HashMap<String, ArrayList> procMap = new HashMap<String, ArrayList>();
                for (String procId : pids) {
                    ArrayList x;
                    if ((procId = procId.trim()).equals("") || procId == null) continue;
                    String ppid = PrereqAPI.getParentProcessId(procId);
                    if (procMap.containsKey(ppid)) {
                        x = (ArrayList)procMap.get(ppid);
                        x.add(procId);
                        procMap.put(ppid, x);
                        continue;
                    }
                    x = new ArrayList();
                    x.add(procId);
                    procMap.put(ppid, x);
                }
                Set pidset = procMap.keySet();
                Iterator itr = pidset.iterator();
                while (itr.hasNext()) {
                    ArrayList x;
                    String childPidList;
                    String childPidName;
                    String entry = itr.next().toString();
                    String ppidName = PrereqAPI.getProcessNameById(entry);
                    if (!ppidName.equals("") && ppidName != null) {
                        OLogger.printlnOnLog("START PARENT PROCESS DETAILS\n" + ppidName + "\nEND PARENT PROCESS DETAILS");
                    }
                    if ((childPidName = PrereqAPI.getProcessNameById(childPidList = String.join((CharSequence)",", x = (ArrayList)procMap.get(entry)))).equals("") || childPidName == null) continue;
                    OLogger.printlnOnLog("START CHILD PROCESS DETAILS FOR PARENT PROCESS: " + entry + "\n" + childPidName + "\nEND CHILD PROCESS DETAILS FOR PARENT PROCESS: " + entry);
                }
            }
        }
        if (tmpAl.size() > 0) {
            result = new String[tmpAl.size()];
            tmpAl.toArray(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getProcessExecWin(String executable) throws IOException {
        String pid = "";
        BufferedReader br = null;
        InputStreamReader isr = null;
        InputStream is = null;
        String line = null;
        ArrayList<String> command = new ArrayList<String>();
        Path fPath = WrapperFactory.getNioServiceWrapper().getPath(executable, new String[0]);
        command.add("cmd");
        command.add("/c");
        command.add("wmic");
        command.add("process");
        command.add("where");
        command.add("\"executablepath like '%" + fPath.toRealPath(new LinkOption[0]).toString().replace("\\", "\\\\") + "%'\"");
        command.add("get");
        command.add("processid");
        command.add("/FORMAT:LIST");
        try {
            ProcessBuilder builder = new ProcessBuilder(command);
            Process process = builder.start();
            process.getOutputStream().close();
            is = process.getInputStream();
            isr = new InputStreamReader(is);
            br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                String[] res = line.split("=");
                if (res.length <= 1) continue;
                String string = pid = res[1];
                return string;
            }
            String string = pid;
            return string;
        }
        catch (Exception e2) {
            OLogger.debug("Exception occurred getting PID of executable");
            String string = "";
            return string;
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (isr != null) {
                isr.close();
            }
            if (is != null) {
                is.close();
            }
        }
    }

    private static String getFuserLocation() {
        OPatchProperty opp = new OPatchProperty();
        if (opp.hasFuserCommand()) {
            try {
                fuserLoc = opp.getFuserCommand();
            }
            catch (Exception e2) {
                OLogger.printStackTrace(e2);
                fuserLoc = "";
            }
        }
        return fuserLoc;
    }

    private static String getParentProcessId(String pId) {
        String ppId = "";
        String ppIdCmd = "ps -o ppid= -p " + pId;
        SystemCall.ExecReturn ret1 = SystemCall.runtimeExec(ppIdCmd);
        ppId = ret1.getNormalMessage().trim();
        return ppId;
    }

    private static String getProcessNameById(String ppId) {
        String ppName = "";
        String ppidNameCmd = "ps -o pid,comm -p " + ppId;
        SystemCall.ExecReturn ret2 = SystemCall.runtimeExec(ppidNameCmd);
        ppName = ret2.getNormalMessage().trim();
        return ppName;
    }

    public static OneOffEntry getInactiveOneOff(String oracleHomePath, String patchID) throws Throwable {
        OneOffEntry[] OHOneOffs = null;
        IIPMReadServices readServices = PrereqSession.getReadServices(oracleHomePath);
        OHOneOffs = readServices.getInactivePatches();
        for (int i2 = 0; i2 < OHOneOffs.length; ++i2) {
            if (!patchID.equals(OHOneOffs[i2].getID())) continue;
            return OHOneOffs[i2];
        }
        return null;
    }

    public static OneOffEntry[] getInactiveOneOff(String oracleHomePath) throws Throwable {
        OneOffEntry[] OHOneOffs = null;
        IIPMReadServices readServices = PrereqSession.getReadServices(oracleHomePath);
        OHOneOffs = readServices.getInactivePatches();
        return OHOneOffs;
    }

    public static OneOffEntry getInstalledOneOff(String oracleHomePath, String patchID) throws Throwable {
        OneOffEntry[] OHOneOffs = PrereqAPI.getInstalledOneOff(oracleHomePath);
        for (int i2 = 0; i2 < OHOneOffs.length; ++i2) {
            if (!patchID.equals(OHOneOffs[i2].getID())) continue;
            return OHOneOffs[i2];
        }
        return null;
    }

    public static OneOffEntry[] getInstalledOneOff(String oracleHomePath) throws Throwable {
        OneOffEntry[] OHOneOffs = null;
        IIPMReadServices readServices = null;
        readServices = PrereqSession.getReadServices(oracleHomePath);
        if (!OPatchEnv.isCUPSupported() || OPatchEnv.isSnowBall()) {
            OHOneOffs = readServices.getInstalledPatches();
        } else {
            HomeOperationsExt homeOp = readServices.getHomeOperations();
            homeOp.initialize(SessionMode.READ);
            Set patchInfos = homeOp.getInstalledPatchesFromInventory();
            homeOp.close();
            OHOneOffs = PrereqAPI.convertPatchInfosToOneoffs(patchInfos);
            OHOneOffs = PrereqAPI.removeInactivePatches(OHOneOffs, oracleHomePath);
        }
        return OHOneOffs;
    }

    private static OneOffEntry[] removeInactivePatches(OneOffEntry[] pohs, String oracleHomePath) {
        OneOffEntry[] result = null;
        OracleHomeConflictMap conflictMap = OracleHomeConflictMap.getInstance(pohs, oracleHomePath);
        OneOffEntry[] inactiveSubsetOneOffs = new OneOffEntry[conflictMap.getSubsetPatches().size()];
        conflictMap.getSubsetPatches().toArray(inactiveSubsetOneOffs);
        ArrayList<OneOffEntry> filteredOneOffList = new ArrayList<OneOffEntry>(Arrays.asList(pohs));
        filteredOneOffList.removeAll(Arrays.asList(inactiveSubsetOneOffs));
        result = new OneOffEntry[filteredOneOffList.size()];
        filteredOneOffList.toArray(result);
        return result;
    }

    private static OneOffEntry[] convertPatchInfosToOneoffs(Set<PatchInfo> patchInfos) {
        ArrayList<OneOffEntry> result = new ArrayList<OneOffEntry>();
        for (PatchInfo pInfo : patchInfos) {
            String patchId = pInfo.getPatchId();
            String patchUPI = pInfo.getPatchUpi();
            List langs = pInfo.getLanguages();
            Date appliedDate = pInfo.getAppliedDate().getTime();
            String language = PrereqAPI.convertLocalesToString(pInfo.getLanguages());
            if (language != null && !language.isEmpty()) {
                patchId = patchId + "_" + language + "_" + patchUPI;
            }
            OPatchEnv.needSearchTripletID(false);
            IIPMRWServices rwService = IPM.INSTANCE.getRWServices();
            OneOffEntry cookedOneOff = HomeInventoryHelper.getOneOffEntry(rwService.getOracleHomePath(), patchId);
            OPatchEnv.needSearchTripletID(true);
            cookedOneOff.setAppliedDate(appliedDate);
            result.add(cookedOneOff);
        }
        return result.toArray(new OneOffEntry[result.size()]);
    }

    private static String convertLocalesToString(List<Locale> locales) {
        StringBuffer sbLangs = new StringBuffer();
        int size = locales.size();
        for (int i2 = 0; i2 < size; ++i2) {
            Locale l2 = locales.get(i2);
            if (!l2.toString().equalsIgnoreCase("en")) {
                sbLangs.append(l2.toString());
            }
            if (i2 >= size - 1) continue;
            sbLangs.append(" ");
        }
        return sbLangs.toString();
    }

    public static PrereqResult checkInstalledOneOffs(String oracleHomePath, String[] patchIDs, Vector installedPatchIDs, Vector notInstalledPatchIDs) {
        StringBuffer buff = new StringBuffer("PrereqAPI::checkInstalledOneOffs()");
        OLogger.debug(buff);
        PrereqResult resObj = new PrereqResult();
        OneOffEntry[] OHOneOffs = new OneOffEntry[]{};
        if (patchIDs == null || patchIDs.length == 0) {
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            buff = new StringBuffer("Argument patchIDs is empty");
            OLogger.printlnOnLog(buff.toString());
            resObj.addDetail(buff.toString());
            return resObj;
        }
        for (int i2 = 0; i2 < patchIDs.length; ++i2) {
            int noTokens;
            boolean maybeLang = false;
            StringTokenizer tk2 = new StringTokenizer(patchIDs[i2], "_");
            if (tk2 != null && (noTokens = tk2.countTokens()) >= 2) {
                maybeLang = true;
            }
            if (maybeLang) {
                String[] inputs = OPatchEnv.getPatchFilemapInfoLoc(oracleHomePath, patchIDs[i2], true);
                patchIDs[i2] = inputs[1];
            }
            maybeLang = false;
        }
        try {
            OHOneOffs = PrereqAPI.getInstalledOneOff(oracleHomePath);
        }
        catch (Throwable t) {
            buff = new StringBuffer("Throwable occurred: " + t.getMessage());
            OLogger.printlnOnLog(buff.toString());
            OLogger.debug(new StringBuffer("Converting Throwable to RuntimeException"));
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            resObj.addDetail(re);
        }
        for (int pIter = 0; pIter < patchIDs.length; ++pIter) {
            boolean thisPatchIsPresent = false;
            for (int oIter = 0; oIter < OHOneOffs.length; ++oIter) {
                if (!OHOneOffs[oIter].getID().equals(patchIDs[pIter])) continue;
                thisPatchIsPresent = true;
                installedPatchIDs.add(patchIDs[pIter]);
                break;
            }
            if (thisPatchIsPresent) continue;
            buff = new StringBuffer("Skipping patch " + patchIDs[pIter]);
            buff.append(" as it is not present in the Oracle Home.\n");
            OLogger.printlnOnLog(buff.toString());
            notInstalledPatchIDs.add(patchIDs[pIter]);
        }
        if (notInstalledPatchIDs.size() > 0) {
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            buff = new StringBuffer("\nPatches not installed are:\n");
            buff.append(notInstalledPatchIDs.toString());
            OLogger.printlnOnLog(buff.toString());
            if (OPatchEnv.getSessionType().equalsIgnoreCase("prereq")) {
                ZOPErrorMessage.printErrorMessage(30);
            }
            resObj.addDetail(buff.toString());
            if (OPatchEnv.isContinueOnPrereqFailure()) {
                for (int i3 = 0; i3 < installedPatchIDs.size(); ++i3) {
                    String patchId = (String)installedPatchIDs.elementAt(i3);
                    OUSession.addPrereqResultForPatchesToReport(patchId, OPatchPatchPrereq.CHECK_INSTALLED_ONE_OFFS, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
                }
            }
        } else {
            buff = new StringBuffer("\nAll the specified patches are present in the Oracle Home.");
            OLogger.verbose(OPatchSession.PREREQ, buff);
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        }
        return resObj;
    }

    public static PrereqResult isOHPathOK(String path) {
        OLogger.debug(new StringBuffer("PrereqAPI::isOHPathOK()"));
        Path fp = WrapperFactory.getNioServiceWrapper().getPath(path, new String[0]);
        if (!Files.exists(fp, new LinkOption[0])) {
            StringBuffer buff = new StringBuffer("OPatch cannot find ORACLE_HOME (\"");
            buff.append(path);
            buff.append("\")");
            OLogger.debug(buff);
            PrereqResult resObj = new PrereqResult();
            resObj.addDetail(buff.toString());
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            return resObj;
        }
        OLogger.justlog(OLogger.INFO, "Checking if the Oracle Home " + fp.toAbsolutePath().toString() + " is good for OPatch to work.");
        if (!fp.isAbsolute()) {
            StringBuffer buff = new StringBuffer("\nOracle Home Path specified is relative path.");
            buff.append("\nOPatch cannot work with relative Oracle Home Paths, please specify the absolute path to Oracle Home.");
            OLogger.debug(buff);
            PrereqResult resObj = new PrereqResult();
            resObj.addDetail(buff.toString());
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
        }
        PrereqResult resObj = new PrereqResult();
        resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        OLogger.debug(new StringBuffer("Prereq isOHPathOK passed"));
        return resObj;
    }

    public static PrereqResult isOUIVersionApplicableForOPatch(String opatchVersion, String oracleHomePath) {
        boolean majorNumberMatched;
        StringBuffer buff = new StringBuffer("PrereqAPI::isOUIVersionApplicableForOPatch()");
        OLogger.debug(buff);
        PrereqResult resObj = new PrereqResult();
        String ouiVersion = OPatchSDK.getOUIVersion();
        String[] ouiVerParts = ouiVersion.split("\\.");
        String[] opatchVerParts = opatchVersion.split("\\.");
        if (ouiVerParts.length < 2 || opatchVerParts.length < 2) {
            buff = new StringBuffer("\nThe version format of OUI/OPatch is not right. Please check OUI and OPatch versions.");
            OLogger.debug(buff);
            resObj.addDetail(buff.toString());
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
        }
        boolean bl = majorNumberMatched = ouiVerParts[0].compareTo(opatchVerParts[0]) == 0;
        if (majorNumberMatched) {
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            OLogger.debug(new StringBuffer("Prereq isOUIVersionApplicableForOPatch passed."));
        } else {
            String tempOuiVer = ouiVerParts[0] + "." + ouiVerParts[1];
            buff = new StringBuffer("\n");
            buff.append("OPatch Version : " + opatchVersion);
            buff.append("\n  OUI  Version : " + ouiVersion);
            buff.append("\nThe OPatch version is not applicable for current OUI version.");
            OLogger.debug(buff);
            resObj.addDetail(buff.toString());
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            try {
                InputStream istream = new PrereqAPI().getClass().getResourceAsStream("opatch_oui_applicable_version.xml");
                if (istream == null) {
                    StringBuffer sb1 = new StringBuffer("Cannot load file\"");
                    sb1.append("opatch_oui_applicable_version.xml");
                    sb1.append("\".");
                    throw new RuntimeException(sb1.toString());
                }
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(istream);
                Element root = doc.getDocumentElement();
                NodeList versionList = root.getChildNodes();
                for (int i2 = 0; i2 < versionList.getLength(); ++i2) {
                    Node versionNode = versionList.item(i2);
                    String name = versionNode.getNodeName();
                    if (name.equals("#text")) continue;
                    NamedNodeMap attrs = versionNode.getAttributes();
                    if (attrs == null) {
                        throw new RuntimeException("Unable to parse opatch/oui compatible version file");
                    }
                    Node ouiVerNode = attrs.getNamedItem("oui");
                    String ouiVersion1 = ouiVerNode.getNodeValue();
                    Node opatchVerNode = attrs.getNamedItem("opatch");
                    String opatchVersion1 = opatchVerNode.getNodeValue();
                    Node releaseVerNode = attrs.getNamedItem("rel_ver");
                    String release_version = releaseVerNode.getNodeValue();
                    if (!tempOuiVer.equals(ouiVersion1)) continue;
                    StringBuffer buff1 = new StringBuffer("\nSince OUI Version starts with ");
                    buff1.append(ouiVersion1);
                    buff1.append(", Please go to 'My Oracle Support' and get right OPatch ");
                    buff1.append(opatchVersion1);
                    buff1.append(" based on patch 6880880, release version ");
                    buff1.append(release_version);
                    buff1.append(" and appropriate platform.");
                    OLogger.debug(buff1.toString());
                    resObj.addDetail(buff1.toString());
                }
            }
            catch (Exception e2) {
                OLogger.debug("Exception occurred: " + e2.getMessage());
            }
        }
        return resObj;
    }

    public static PrereqResult checkMultipleTranslationPatches(String oracleHomePath, PatchObject[] patchObjects) {
        StringBuffer buff = new StringBuffer("PrereqAPI::checkMultipleTranslationPatches()");
        OLogger.debug(buff);
        PrereqResult resObj = new PrereqResult();
        if (patchObjects == null) {
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            buff = new StringBuffer("Input list of PatchObjects are 'null'.");
            resObj.addDetail(buff.toString());
            return resObj;
        }
        ArrayList<String> translationIDs = new ArrayList<String>();
        ArrayList<String> duplicates = new ArrayList<String>();
        boolean duplicateFound = false;
        for (int i2 = 0; i2 < patchObjects.length; ++i2) {
            if (!patchObjects[i2].getPatchInventory().mayBeTranslation()) continue;
            String patchID = patchObjects[i2].getOriginalPatchID();
            if (translationIDs.contains(patchID) && !duplicates.contains(patchID)) {
                duplicateFound = true;
                duplicates.add(patchID);
            }
            translationIDs.add(patchID);
        }
        if (!duplicateFound) {
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        } else {
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            resObj.addDetail("The following patch(es) have multiple language translation molecules.\n");
            resObj.addDetail(duplicates.toString());
            resObj.addDetail("\nPlease make sure that there is only one translation molecule given to OPatch for the specified patch(es) in a session.");
        }
        return resObj;
    }

    public static PrereqResult checkPatchingModel(String oracleHomePath, PatchObject[] patchObjects) {
        StringBuffer buff = new StringBuffer("PrereqAPI::checkPatchingModel()");
        OLogger.debug(buff);
        PrereqResult resObj = new PrereqResult();
        if (patchObjects == null) {
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            buff = new StringBuffer("Input list of PatchObjects are 'null'.");
            resObj.addDetail(buff.toString());
            return resObj;
        }
        int homePatchModel = PatchingModel.returnModelCode(oracleHomePath);
        StringBuffer failedPatches = new StringBuffer("");
        ArrayList<String> failedPatchesList = new ArrayList<String>();
        for (int i2 = 0; i2 < patchObjects.length; ++i2) {
            String modelType = patchObjects[i2].getPatchInventory().getPatchModel();
            int modelCode = PatchingModel.getModelCodeRep(modelType);
            if (modelCode == homePatchModel && (homePatchModel != 2 || !"singleton".equals(patchObjects[i2].getPatchType()))) continue;
            failedPatches.append(" ");
            failedPatches.append(patchObjects[i2].getPatchID());
            failedPatchesList.add(patchObjects[i2].getPatchID());
        }
        if (!failedPatches.toString().equals("")) {
            String msg = OLogger.getString("OUI-67640", new Object[]{oracleHomePath, PatchingModel.getModelType(homePatchModel), failedPatches.toString()});
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            resObj.addDetail(msg);
            if (OPatchEnv.isContinueOnPrereqFailure()) {
                for (String patchId : failedPatchesList) {
                    OUSession.addPrereqResultForPatchesToReport(patchId, OPatchPatchPrereq.CHECK_PATCHING_MODEL, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
                }
            }
            return resObj;
        }
        if (resObj.getResult() != PrereqResult.ExecuteStatus.FAILED) {
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        } else if (OPatchEnv.isContinueOnPrereqFailure()) {
            for (PatchObject po : patchObjects) {
                OUSession.addPrereqResultForPatchesToReport(po.getPatchID(), OPatchPatchPrereq.CHECK_PATCHING_MODEL, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
            }
        }
        return resObj;
    }

    private static ArrayList findIntersectionComps(PatchComponent[] x, PatchComponent[] y) {
        ArrayList<PatchComponent> intersect = new ArrayList<PatchComponent>();
        if (x == null && y == null) {
            return intersect;
        }
        if (x == null || y == null) {
            return intersect;
        }
        for (int i2 = 0; i2 < x.length; ++i2) {
            for (int j2 = 0; j2 < y.length; ++j2) {
                if (!x[i2].getName().equals(y[j2].getName()) || !x[i2].getVersion().equals(y[j2].getVersion())) continue;
                intersect.add(x[i2]);
            }
        }
        return intersect;
    }

    public static boolean isNoOpPatch(String oracleHomePath, PatchObject patchObject) {
        try {
            Map<PatchComponent, PatchComponentCheckResult> analyzed = null;
            IIPMReadServices readServices = PrereqSession.getReadServices(oracleHomePath);
            analyzed = readServices.analyzePatchComponents(patchObject, OPatchEnv.isNRollback());
            for (Map.Entry<PatchComponent, PatchComponentCheckResult> entry : analyzed.entrySet()) {
                if (!entry.getKey().isRequired() && !entry.getValue().getResult().isProcessComponent()) continue;
                return false;
            }
            StringBuffer dBuff = new StringBuffer("N-Apply: check if the patch is a Maintenance alias patch: ");
            dBuff.append(patchObject.getPatchID());
            OLogger.debug(dBuff.toString());
            boolean isMAPatch = PrereqAPI.isMAPatch(patchObject);
            dBuff = new StringBuffer("Patch ").append(patchObject.getPatchID());
            dBuff.append(isMAPatch ? " is " : " isn't ").append("a Maintenance Alias patch");
            OLogger.debug(dBuff.toString());
            if (patchObject.getPatchComponents().length == 0 && isMAPatch) {
                return false;
            }
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    public static boolean isAllComponentsNotRequiredToProcess(String oracleHomePath, PatchObject patchObject) {
        boolean isAllComponentNotProcess = false;
        try {
            Map<PatchComponent, PatchComponentCheckResult> analyzed = null;
            IIPMReadServices readServices = PrereqSession.getReadServices(oracleHomePath);
            analyzed = readServices.analyzePatchComponents(patchObject, OPatchEnv.isNRollback());
            for (Map.Entry<PatchComponent, PatchComponentCheckResult> entry : analyzed.entrySet()) {
                if (entry.getValue().getResult().isProcessingNotRequired()) {
                    isAllComponentNotProcess = true;
                    continue;
                }
                isAllComponentNotProcess = false;
                break;
            }
            return isAllComponentNotProcess;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean isRequiredComponentMissing(String oracleHomePath, PatchObject patchObject, Vector missingRequiredComps) {
        String patchID = patchObject.getPatchID();
        StringBuffer buff = new StringBuffer("Check if patch ");
        buff.append(patchID).append(" required a component that is not in OH.");
        OLogger.debug(buff);
        boolean compMissing = false;
        try {
            Map<PatchComponent, PatchComponentCheckResult> analyzed = null;
            IIPMReadServices readServices = PrereqSession.getReadServices(oracleHomePath);
            analyzed = readServices.analyzeRequiredPatchComponents(patchObject, OPatchEnv.isNRollback());
            for (Map.Entry<PatchComponent, PatchComponentCheckResult> entry : analyzed.entrySet()) {
                Result checkResult = entry.getValue().getResult();
                if (!checkResult.isErrNotFound() && !checkResult.isVersionMismatch()) continue;
                compMissing = true;
                OLogger.debug("Required Component is " + checkResult.toString() + entry.getValue().getDetails());
                missingRequiredComps.add(entry.getKey());
            }
        }
        catch (Throwable t) {
            RuntimeException e2 = new RuntimeException(t.getMessage());
            e2.setStackTrace(e2.getStackTrace());
        }
        return compMissing;
    }

    public static boolean isAtleastOneComponentMissing(String oracleHomePath, PatchObject patchObject, List<PatchComponent> atleastOneComponentsMissing) {
        String patchID = patchObject.getPatchID();
        StringBuffer buff = new StringBuffer("Check if patch ");
        buff.append(patchID).append(" has missing at least one component in <atleast_one_components> in OH.");
        OLogger.debug(buff);
        boolean atleastCompMissing = false;
        try {
            List pcList;
            Map<PatchComponent, PatchComponentCheckResult> analyzed = null;
            IIPMReadServices readServices = PrereqSession.getReadServices(oracleHomePath);
            analyzed = readServices.analyzeOptionalPatchComponents(patchObject, OPatchEnv.isNRollback());
            List<ArrayList<PatchComponent>> atleastOneComponentsList = patchObject.getPatchInventory().getAtLeastOneComponents();
            Iterator<ArrayList<PatchComponent>> iterator = atleastOneComponentsList.iterator();
            while (iterator.hasNext() && (pcList = (List)iterator.next()).size() != 0) {
                PatchComponentCheckResult pccr;
                int i2;
                for (i2 = 0; i2 < pcList.size() && !(pccr = analyzed.get(pcList.get(i2))).getResult().isProcessComponent(); ++i2) {
                }
                if (i2 == pcList.size()) {
                    atleastCompMissing = true;
                    atleastOneComponentsMissing.addAll(pcList);
                }
                if (!atleastCompMissing) continue;
                break;
            }
        }
        catch (Throwable t) {
            RuntimeException e2 = new RuntimeException(t.getMessage());
            e2.setStackTrace(t.getStackTrace());
            throw e2;
        }
        return atleastCompMissing;
    }

    private static boolean checkOUI(String oh) {
        return true;
    }

    public static PrereqResult checkSupersetRollbacks(String oracleHomePath, OneOffEntry[] oneoffs) {
        StringBuffer buff = new StringBuffer("PrereqAPI::checkSupersetRollbacks()");
        OLogger.debug(buff);
        buff = new StringBuffer("OPatch does not allow rollback of superset-subset patches together.\n");
        PrereqResult resObj = new PrereqResult();
        if (oneoffs != null && oneoffs.length == 1) {
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            return resObj;
        }
        for (int i2 = 0; i2 < oneoffs.length; ++i2) {
            OneOffEntry curOneOff = oneoffs[i2];
            for (int j2 = 0; j2 < oneoffs.length; ++j2) {
                if (j2 == i2) continue;
                OneOffEntry consideredOneOff = oneoffs[j2];
                String[] bugsFirstOneOff = curOneOff.getBugIDsFixed();
                String[] bugsThatSuperset = new String[1];
                OneOffEntry[] toPatch = new OneOffEntry[]{consideredOneOff};
                ConflictHandler conflictHandler = new ConflictHandler(true, true, true, true);
                try {
                    if (!conflictHandler.isBugSuperset(toPatch, bugsFirstOneOff, bugsThatSuperset)) continue;
                    resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                    buff.append("Patch \"" + curOneOff.getID() + "\" is a superset of Patch \"" + consideredOneOff.getID() + "\".");
                    buff.append("\n");
                    continue;
                }
                catch (Exception e2) {
                    OLogger.printStackTrace(e2);
                    resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                    resObj.addDetail(e2.getMessage());
                    return resObj;
                }
            }
        }
        if (resObj.getResult() != PrereqResult.ExecuteStatus.FAILED) {
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            return resObj;
        }
        resObj.addDetail(buff.toString());
        return resObj;
    }

    public static PrereqResult checkPatchApplyDependents(String oracleHomePath, OneOffEntry[] oneOffs, String[] rollbackPatchIDList) {
        ArrayList<String> patchIds = new ArrayList<String>();
        for (int i2 = 0; i2 < rollbackPatchIDList.length; ++i2) {
            String id = rollbackPatchIDList[i2].trim();
            if (id == null || id.equals("") || patchIds.contains(id)) continue;
            patchIds.add(id);
        }
        OPatchEnv.setToBeRolledBackPatchIDs(patchIds);
        PrereqResult resObj = PrereqAPI.checkPatchApplyDependents(oracleHomePath, oneOffs);
        return resObj;
    }

    public static PrereqResult checkPatchApplyDependents(String oracleHomePath, OneOffEntry[] oneOffs) {
        int i2;
        StringBuffer buff = new StringBuffer("PrereqAPI::checkPatchApplyDependents()");
        OLogger.debug(buff);
        PrereqResult resObj = new PrereqResult();
        OneOffEntry[] installedOneOffs = null;
        String[] prereqOneOffs = null;
        String[] requiredBugList = new String[]{};
        WLSPatch[] wlsPrereqOneOffs = null;
        String[] bugList = new String[]{};
        ArrayList simulateRBPatchIDs = OPatchEnv.getToBeRolledBackPatchIDs();
        try {
            installedOneOffs = PrereqAPI.getInstalledOneOff(oracleHomePath);
            if (simulateRBPatchIDs != null && simulateRBPatchIDs.size() != 0) {
                ArrayList<OneOffEntry> oneoffList = new ArrayList<OneOffEntry>();
                for (i2 = 0; i2 < installedOneOffs.length; ++i2) {
                    String installedPatchID = installedOneOffs[i2].getID();
                    if (simulateRBPatchIDs.contains(installedPatchID)) continue;
                    oneoffList.add(installedOneOffs[i2]);
                }
                installedOneOffs = new OneOffEntry[oneoffList.size()];
                oneoffList.toArray(installedOneOffs);
            }
        }
        catch (Throwable t) {
            buff = new StringBuffer("Throwable occurred: " + t.getMessage());
            OLogger.printlnOnLog(buff.toString());
            OLogger.debug(new StringBuffer("Converting Throwable to RuntimeException"));
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            resObj.addDetail(re);
            return resObj;
        }
        OneOffEntry[] combinedOneOffs = new OneOffEntry[installedOneOffs.length + oneOffs.length];
        for (i2 = 0; i2 < installedOneOffs.length; ++i2) {
            combinedOneOffs[i2] = installedOneOffs[i2];
        }
        int remCount = 0;
        for (int i3 = installedOneOffs.length; i3 < combinedOneOffs.length; ++i3) {
            combinedOneOffs[i3] = oneOffs[remCount];
            ++remCount;
        }
        ArrayList<String> failedPatches = new ArrayList<String>();
        for (int oIter = 0; oIter < oneOffs.length; ++oIter) {
            int j2;
            int i4;
            prereqOneOffs = oneOffs[oIter].getPrereqPatchIDs();
            wlsPrereqOneOffs = oneOffs[oIter].getWlsPrereqPatchIDs();
            requiredBugList = oneOffs[oIter].getPrereqBugIDs();
            StringBuffer missingOneOffs = new StringBuffer();
            StringBuffer missingWlsOneOffs = new StringBuffer();
            StringBuffer missingBugs = new StringBuffer();
            boolean prereqNotPresent = false;
            boolean wlsPrereqNotPresent = false;
            boolean bugsNotPresent = false;
            boolean addedOne = false;
            for (i4 = 0; i4 < wlsPrereqOneOffs.length; ++i4) {
                WLSPatch requiredWlsOneOff = wlsPrereqOneOffs[i4];
                boolean found = false;
                Object[] wlsList = OPatchEnv.getWlsPrereqOneOffsList();
                for (int wIndex = 0; wIndex < wlsList.length; ++wIndex) {
                    WLSPatch installedWlsOneOff = (WLSPatch)wlsList[wIndex];
                    if (!requiredWlsOneOff.equals(installedWlsOneOff)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                if (!requiredWlsOneOff.isRequired()) {
                    OLogger.println("Patch " + oneOffs[oIter].getID() + ": Optional prerequisite WLS patch(es) \"" + requiredWlsOneOff.getPatchID() + "\" is not present in the WLS Home.");
                } else {
                    wlsPrereqNotPresent = true;
                    if (addedOne) {
                        missingWlsOneOffs.append(",");
                    }
                    missingWlsOneOffs.append(requiredWlsOneOff.getPatchID());
                    addedOne = true;
                }
                requiredWlsOneOff.setMissing(true);
            }
            if (wlsPrereqNotPresent) {
                buff = new StringBuffer("\nThe Patch " + oneOffs[oIter].getID() + " requires that WLS patch(es)");
                buff.append(" \"" + missingWlsOneOffs + "\" ");
                buff.append("be installed.");
                OLogger.debug(buff);
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                resObj.addDetail(buff.toString());
                failedPatches.add(oneOffs[oIter].getPatchID());
            }
            for (i4 = 0; i4 < prereqOneOffs.length; ++i4) {
                boolean found = false;
                for (j2 = 0; j2 < installedOneOffs.length; ++j2) {
                    if (!prereqOneOffs[i4].equals(installedOneOffs[j2].getID())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    for (int k2 = 0; k2 < oneOffs.length; ++k2) {
                        if (!prereqOneOffs[i4].equals(oneOffs[k2].getID())) continue;
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                prereqNotPresent = true;
                missingOneOffs.append(prereqOneOffs[i4]);
                missingOneOffs.append(" ");
            }
            if (prereqNotPresent) {
                buff = new StringBuffer("Interim patch " + oneOffs[oIter].getID());
                buff.append(" requires prerequisite patch(es) [ ");
                buff.append(missingOneOffs);
                buff.append("] which are not present in the Oracle Home.\n");
                buff.append("Apply prerequisite patch(es) [ ");
                buff.append(missingOneOffs);
                buff.append("] before applying interim patch " + oneOffs[oIter].getID() + " .");
                OLogger.debug(buff);
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                resObj.addDetail(buff.toString());
                failedPatches.add(oneOffs[oIter].getPatchID());
            }
            for (i4 = 0; i4 < requiredBugList.length; ++i4) {
                int k3;
                String[] bugsCur;
                boolean found = false;
                block12: for (j2 = 0; j2 < installedOneOffs.length; ++j2) {
                    bugsCur = installedOneOffs[j2].getBugIDsFixed();
                    for (k3 = 0; k3 < bugsCur.length; ++k3) {
                        if (!requiredBugList[i4].equals(bugsCur[k3])) continue;
                        found = true;
                        continue block12;
                    }
                }
                if (!found) {
                    block14: for (int l2 = 0; l2 < oneOffs.length; ++l2) {
                        if (l2 == oIter) continue;
                        bugsCur = oneOffs[l2].getBugIDsFixed();
                        for (k3 = 0; k3 < bugsCur.length; ++k3) {
                            if (!requiredBugList[i4].equals(bugsCur[k3])) continue;
                            found = true;
                            continue block14;
                        }
                    }
                }
                if (found) continue;
                bugsNotPresent = true;
                missingBugs.append(requiredBugList[i4]);
                missingBugs.append(" ");
            }
            if (bugsNotPresent) {
                buff = new StringBuffer("Required prerequisite bug fix(es) [ ");
                buff.append(missingBugs);
                buff.append("] for patch '");
                buff.append(oneOffs[oIter].getID());
                buff.append("' are not present in the Oracle Home.");
                OLogger.debug(buff);
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                resObj.addDetail(buff.toString());
                failedPatches.add(oneOffs[oIter].getPatchID());
            }
            if (OPatchEnv.getRegressedPatchinPi().length <= 0) continue;
            StringBuffer RegressedOneOffs = new StringBuffer();
            boolean foundIncoming = false;
            OneOffEntry[] regressedOneOffsinPi = OPatchEnv.getRegressedPatchinPi();
            for (int k4 = 0; k4 < regressedOneOffsinPi.length; ++k4) {
                if (!regressedOneOffsinPi[k4].getID().equals(oneOffs[oIter].getID())) continue;
                RegressedOneOffs.append(regressedOneOffsinPi[k4].getID());
                foundIncoming = true;
                break;
            }
            if (!foundIncoming) continue;
            buff = new StringBuffer("Regressed Patch [ ");
            buff.append(RegressedOneOffs);
            buff.append("] is present in the list of patches being applied.\n");
            buff.append("Remove Regressed patch [ ");
            buff.append(RegressedOneOffs);
            buff.append(" ] from the patches list and retry patching");
            OLogger.debug(buff);
            resObj.addDetail(buff.toString());
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            failedPatches.add(oneOffs[oIter].getPatchID());
        }
        if (resObj.getResult() != PrereqResult.ExecuteStatus.FAILED) {
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        } else if (OPatchEnv.isContinueOnPrereqFailure()) {
            for (String patchId : failedPatches) {
                OUSession.addPrereqResultForPatchesToReport(patchId, OPatchPatchPrereq.CHECK_PATCH_APPLY_DEPENDENTS, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
            }
        }
        return resObj;
    }

    public static PrereqResult checkPatchRollbackDependents(String oracleHomePath, String[] oneOffIDs) {
        StringBuffer buff = new StringBuffer("PrereqAPI::checkPatchRollbackDependents()");
        OLogger.debug(buff);
        PrereqResult resObj = new PrereqResult();
        OneOffEntry[] installedOneOffs = null;
        try {
            IIPMReadServices readServices = PrereqSession.getReadServices(oracleHomePath);
            installedOneOffs = readServices.getInstalledPatchesIncludeInactive();
        }
        catch (Throwable t) {
            buff = new StringBuffer("Throwable occurred: " + t.getMessage());
            OLogger.printlnOnLog(buff.toString());
            OLogger.debug(new StringBuffer("Converting Throwable to RuntimeException"));
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            resObj.addDetail(re);
        }
        if (OPatchEnv.isCUPSupported()) {
            ArrayList<IPatch> listOh = new ArrayList<IPatch>();
            for (OneOffEntry e2 : installedOneOffs) {
                listOh.add(new Patch(e2, true));
            }
            CheckPatchLevel checkPL = new CheckPatchLevel(null, listOh);
            checkPL.checkBetweenPoh();
        }
        ArrayList<OneOffEntry> arrListOfOneOffs = new ArrayList<OneOffEntry>();
        block3: for (int i2 = 0; i2 < installedOneOffs.length; ++i2) {
            for (int j2 = 0; j2 < oneOffIDs.length; ++j2) {
                if (!oneOffIDs[j2].equals(installedOneOffs[i2].getID())) continue;
                arrListOfOneOffs.add(installedOneOffs[i2]);
                continue block3;
            }
        }
        OneOffEntry[] listOfOneOffs = arrListOfOneOffs.toArray(new OneOffEntry[arrListOfOneOffs.size()]);
        OneOffEntry[] dependents = OPatchSessionHelper.getCompleteDependentRollbackList(listOfOneOffs, installedOneOffs);
        if (dependents.length == listOfOneOffs.length) {
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        } else {
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            StringBuffer msg = new StringBuffer("OPatch will not roll back patch(es) \"");
            for (int o2 = 0; o2 < oneOffIDs.length; ++o2) {
                msg.append(oneOffIDs[o2]);
                if (o2 == oneOffIDs.length - 1) continue;
                msg.append(",");
            }
            msg.append("\" until you have rolled back dependent patch(es) \"");
            boolean addedOne = false;
            for (int i3 = 0; i3 < dependents.length; ++i3) {
                String pID = dependents[i3].getID();
                boolean found = false;
                for (int j3 = 0; j3 < oneOffIDs.length; ++j3) {
                    if (!pID.equals(oneOffIDs[j3])) continue;
                    found = true;
                }
                if (found) continue;
                if (addedOne) {
                    msg.append(",");
                }
                msg.append(dependents[i3].getID());
                addedOne = true;
            }
            msg.append("\".\n");
            resObj.addDetail(msg.toString());
            if (OPatchEnv.isContinueOnPrereqFailure()) {
                for (String patchId : oneOffIDs) {
                    OUSession.addPrereqResultForPatchesToReport(patchId, OPatchPatchPrereq.CHECK_PATCH_ROLLBACK_DEPENDENTS, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
                }
            }
        }
        return resObj;
    }

    public static PrereqResult checkForInputValues(String oracleHomePath, OneOffEntry[] oneoffs) {
        StringBuffer buff = new StringBuffer("PrereqAPI::checkForInputValues()");
        OLogger.debug(buff);
        StringBuffer patchInfo = new StringBuffer("");
        boolean inputFault = false;
        PrereqResult resObj = new PrereqResult();
        buff = new StringBuffer("");
        ArrayList<String> failedPatches = new ArrayList<String>();
        for (int i2 = 0; i2 < oneoffs.length; ++i2) {
            PatchAction[] pActions = oneoffs[i2].getPatchActions();
            patchInfo = new StringBuffer(" Patch " + oneoffs[i2].getID() + " : \n");
            for (int j2 = 0; j2 < pActions.length; ++j2) {
                String ptlConnect;
                String ptlPassword;
                String[] sids;
                if (pActions[j2] instanceof hotpatchAction) {
                    sids = OPatchEnv.getDBSIDs();
                    if (sids != null && sids.length != 0 || !OPatchEnv.isOnline()) continue;
                    resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                    buff.append("   Online patching requires -connectString option.\n");
                    inputFault = true;
                    failedPatches.add(oneoffs[i2].getID());
                    continue;
                }
                if (pActions[j2] instanceof sqlAction || pActions[j2] instanceof sqlprocAction) {
                    if (!OPatchEnv.isRunSql() || (sids = OPatchEnv.getDBSIDs()) != null && sids.length != 0) continue;
                    resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                    buff.append("   Sql patching requires -connectString option.\n");
                    inputFault = true;
                    failedPatches.add(oneoffs[i2].getID());
                    continue;
                }
                if (!(pActions[j2] instanceof portalAction)) continue;
                String ptlSchema = OPatchEnv.getPtlSchema();
                if (ptlSchema == null || ptlSchema.equals("")) {
                    resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                    buff.append("   Portal patching requires -ptlSchema option.\n");
                    inputFault = true;
                    failedPatches.add(oneoffs[i2].getID());
                }
                if ((ptlPassword = OPatchEnv.getPtlPassword()) == null || ptlPassword.equals("")) {
                    resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                    buff.append("   Portal patching requires -ptlPassword option.\n");
                    inputFault = true;
                    failedPatches.add(oneoffs[i2].getID());
                }
                if ((ptlConnect = OPatchEnv.getPtlConnect()) != null && !ptlConnect.equals("")) continue;
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                buff.append("   Portal patching requires -ptlConnect option.\n");
                inputFault = true;
                failedPatches.add(oneoffs[i2].getID());
            }
            if (inputFault) {
                buff.append("\n");
                patchInfo.append(buff);
                inputFault = false;
                resObj.addDetail(patchInfo.toString());
            }
            patchInfo = new StringBuffer();
            buff = new StringBuffer();
        }
        if (resObj.getResult() != PrereqResult.ExecuteStatus.FAILED) {
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        } else if (OPatchEnv.isContinueOnPrereqFailure()) {
            for (String patchId : failedPatches) {
                OUSession.addPrereqResultForPatchesToReport(patchId, OPatchPatchPrereq.CHECK_FOR_INPUT_VALUES, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
            }
        }
        return resObj;
    }

    private static void loadCRSRelatedLibs(String oracleHomePath) {
        if (crsLibsLoaded) {
            return;
        }
        Properties prop = System.getProperties();
        String classpath = prop.getProperty("java.class.path");
        String jlibLoc = oracleHomePath + File.separator + (OPatchEnv.isNextGen() ? "modules" : "jlib");
        String srvmasm = jlibLoc + File.separator + "srvmasm.jar";
        String srvmhas = jlibLoc + File.separator + "srvmhas.jar";
        String netcfg = jlibLoc + File.separator + "netcfg.jar";
        try {
            OPatchOOPHelper.loadExternalLibs(srvmasm);
            OPatchOOPHelper.loadExternalLibs(srvmhas);
            OPatchOOPHelper.loadExternalLibs(netcfg);
            try {
                if (!new File(srvmasm).exists()) {
                    throw new RuntimeException("Error: Trying to load jar: " + srvmasm + " ,but it does not exist.");
                }
                ClassPathAdder.add(Paths.get(srvmasm, new String[0]));
                OLogger.justlog(OLogger.INFO, "Loaded jar: " + srvmasm + "  dynamically at runtime");
                if (!new File(srvmhas).exists()) {
                    throw new RuntimeException("Error: Trying to load jar: " + srvmhas + " ,but it does not exist.");
                }
                ClassPathAdder.add(Paths.get(srvmhas, new String[0]));
                OLogger.justlog(OLogger.INFO, "Loaded jar: " + srvmhas + "  dynamically at runtime");
                if (!new File(netcfg).exists()) {
                    throw new RuntimeException("Error: Trying to load jar: " + netcfg + " ,but it does not exist.");
                }
                ClassPathAdder.add(Paths.get(netcfg, new String[0]));
                OLogger.justlog(OLogger.INFO, "Loaded jar: " + netcfg + "  dynamically at runtime");
            }
            catch (Exception e2) {
                OLogger.printStackTrace(e2);
                throw new RuntimeException("Failed to load jar at runtime:" + e2.getMessage());
            }
            if (OPatchEnv.isWindows()) {
                classpath = classpath + ";" + srvmasm;
                classpath = classpath + ";" + srvmhas;
                classpath = classpath + ";" + netcfg;
            } else {
                classpath = classpath + ":" + srvmasm;
                classpath = classpath + ":" + srvmhas;
                classpath = classpath + ":" + netcfg;
            }
            prop.setProperty("java.class.path", classpath);
            OPatchOOPHelper.updateClassPath();
        }
        catch (Exception e3) {
            OLogger.printStackTrace(e3);
            RuntimeException re = new RuntimeException(e3);
            re.setStackTrace(e3.getStackTrace());
            throw re;
        }
        crsLibsLoaded = true;
    }

    public static void checkDBInstances() {
        StringBuffer buff = new StringBuffer("PrereqAPI::checkDBInstances()");
        OLogger.debug(buff);
        if (OPatchEnv.isOnline() && OPatchEnv.getDBNodes().length > 1) {
            String oracleHome = OPatchEnv.getOracleHome();
            PrereqAPI.loadCRSRelatedLibs(oracleHome);
            ArrayList<String> sids = new ArrayList<String>(Arrays.asList(OPatchEnv.getDBSIDs()));
            ArrayList<String> nodes = new ArrayList<String>(Arrays.asList(OPatchEnv.getDBNodes()));
            if (sids.size() == 0 || nodes.size() == 0) {
                return;
            }
            StringBuffer errorOutput = new StringBuffer();
            StringBuffer passOutput = new StringBuffer();
            boolean statusValue = true;
            try {
                DatabaseFactoryImpl dbImpl = DatabaseFactoryImpl.getInstance();
                String dbName = null;
                List dbs = dbImpl.getDatabases(oracleHome);
                if (dbs.size() > 0) {
                    dbName = ((Database)dbs.get(0)).getDBName();
                }
                if (dbName == null || dbName.length() <= 0) {
                    OLogger.justlog(OLogger.SEVERE, " In PrereqAPI.checkDBInstances(): Failed to get DB name.");
                    OLogger.print("Failed to get DB name when checking db instances.");
                    throw new RuntimeException("Failed to get DB name when checking db instances.");
                }
                OLogger.justlog(OLogger.INFO, " In PrereqAPI.checkDBInstances(): DB name is:" + dbName);
                Database db = DatabaseFactory.getInstance().getDatabase(dbName);
                List dbinstances = db.instances();
                for (DatabaseInstance dbinst : dbinstances) {
                    String sid = dbinst.getInstanceName();
                    String nodeName = dbinst.node().getName();
                    if (!sids.contains(sid) || !nodes.contains(nodeName)) continue;
                    sids.remove(sid);
                    nodes.remove(nodeName);
                    if (dbinst.isRunning()) {
                        passOutput.append("\nInstance:" + sid + " is running on node:" + nodeName);
                        continue;
                    }
                    errorOutput.append("\nInstance:" + sid + " is NOT running on node:" + nodeName);
                    statusValue = false;
                }
                passOutput.append("\n");
                errorOutput.append("\n");
            }
            catch (Exception e2) {
                OLogger.justlog(OLogger.SEVERE, " In PrereqAPI.checkDBInstances(): Failed while checking db instances.");
                OLogger.print("Failed to check db instances.");
                OLogger.printStackTrace(e2);
                throw new RuntimeException("Failed to check db instances." + e2.getMessage());
            }
            if (sids.size() > 0) {
                errorOutput.append("\nThese SIDs are not valid:" + ((Object)sids).toString());
                statusValue = false;
            }
            if (nodes.size() > 0) {
                errorOutput.append("\nThese nodes are not valid:" + ((Object)nodes).toString());
                statusValue = false;
            }
            if (statusValue) {
                OLogger.print("DB instances are up and running");
                OLogger.print(passOutput.toString());
            } else {
                OLogger.print(errorOutput.toString());
                throw new RuntimeException("Failed to check db instances.");
            }
        }
    }

    public static PrereqResult checkDBInstanceUp(String oracleHomePath, boolean apply) {
        StringBuffer buff = new StringBuffer("PrereqAPI::checkDBInstanceUp()");
        OLogger.debug(buff);
        PrereqResult resObj = new PrereqResult();
        if (OPatchEnv.isSnowBall()) {
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            String msg = "For snowball patching model, skip checkDBInstanceUp \n.";
            resObj.addDetail(msg);
            buff.setLength(0);
            OLogger.debug(buff.append(msg));
            return resObj;
        }
        String localNode = "";
        String[] remoteNodes = new String[]{};
        try {
            IIPMReadServices readServices = null;
            try {
                readServices = PrereqSession.getReadServices(oracleHomePath);
            }
            catch (Throwable t) {
                StringBuffer failBuff = new StringBuffer("Unable to load the inventory for the given Home");
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                resObj.addDetail(failBuff.toString());
                return resObj;
            }
            Rac.RacType racType = null;
            Rac rac = OPatchExternalFactory.getRac(oracleHomePath);
            try {
                racType = rac.getInstance(readServices);
            }
            catch (RuntimeException e2) {
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                resObj.addDetail(e2);
                buff = new StringBuffer("Exception occurred");
                buff.append(e2.getMessage());
                OLogger.printlnOnLog(buff.toString());
                return resObj;
            }
            buff = new StringBuffer(racType.getDetail());
            OLogger.debug(buff);
            String toString = rac.toString(readServices);
            OLogger.printlnOnLog(toString);
            if (racType == Rac.RacType.NO_RAC && racType.getRacDiagCode() == Rac.RacDiagCode.NODE_LIST_DETECTED_PATCH_LOCAL) {
                buff = new StringBuffer("\nOPatch found issues in detecting the local node and remote_nodes. ");
                buff.append("This could be because of one or more of the following:\n");
                buff.append("   a) Problems with the clusterware detection.\n");
                buff.append("   b) Problems getting the local node name.\n");
                buff.append("   c) Problems getting the remote node names.\n");
                buff.append("   d) Values passed to -local_node or -remote_nodes options are not valid.\n");
                buff.append("Please check the setup and run 'opatch lsinventory' to get the node names.\n");
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                resObj.addDetail(buff.toString());
                return resObj;
            }
            if (racType == Rac.RacType.MULTIPLE_NODE) {
                localNode = racType.getLocalNode();
                remoteNodes = racType.getRemoteNodes();
                buff = new StringBuffer("\nLocal Node : " + localNode);
                if (remoteNodes != null) {
                    buff.append("\nRemote Nodes : ");
                    for (int i2 = 0; i2 < remoteNodes.length; ++i2) {
                        buff.append(remoteNodes[i2]);
                        buff.append("   ");
                    }
                }
                OLogger.verbose(OPatchSession.PREREQ, buff);
            }
        }
        catch (RuntimeException e3) {
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            resObj.addDetail(e3);
            buff = new StringBuffer("Exception occurred");
            buff.append(e3.getMessage());
            OLogger.printlnOnLog(buff.toString());
            return resObj;
        }
        String[] dbSids = OPatchEnv.getDBSIDs();
        String[] dbUsers = OPatchEnv.getDBUsers();
        String[] dbPasswds = OPatchEnv.getDBPasswds();
        String[] dbNodes = OPatchEnv.getDBNodes();
        Boolean[] SIDStatus = new Boolean[dbSids.length];
        if (dbSids == null || dbSids.length < 1) {
            resObj.addDetail("OnlinePatch : Database SIDs are not provided.");
            return resObj;
        }
        String sqlFilePath = null;
        try {
            sqlFilePath = PrereqAPI.createSQLFileForStatusCheck(oracleHomePath);
        }
        catch (Exception e4) {
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            resObj.addDetail(e4);
            return resObj;
        }
        boolean allSIDsPassed = true;
        boolean someSIDsDown = false;
        for (int sidIter = 0; sidIter < dbSids.length; ++sidIter) {
            String searchStr;
            if (dbNodes[sidIter] != null && !dbNodes[sidIter].equals("") && !dbNodes[sidIter].equals(localNode)) {
                SIDStatus[sidIter] = false;
                continue;
            }
            SystemCall.ExecReturn ret = SQLUtilities.runSqlScript(oracleHomePath, sqlFilePath, dbUsers[sidIter], dbPasswds[sidIter], dbSids[sidIter]);
            boolean ok = ret.isOK();
            if (!ok) {
                String msg = ret.getErrorMessage();
                if (msg.equals("")) {
                    msg = ret.getNormalMessage();
                }
                resObj.addDetail("DB Instance \"" + dbSids[sidIter] + "\" : " + msg);
                allSIDsPassed = false;
                continue;
            }
            String normalOutput = ret.getNormalMessage();
            int ind = normalOutput.indexOf(searchStr = "ORA-01034");
            if (ind != -1) {
                if (apply) {
                    resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                    resObj.addDetail("DB Instance \"" + dbSids[sidIter] + "\" is down or the given SID is invalid.\n");
                    continue;
                }
                SIDStatus[sidIter] = true;
                someSIDsDown = true;
                continue;
            }
            String oraStr = "ORA-";
            ind = normalOutput.indexOf(oraStr);
            if (ind != -1) {
                resObj.addDetail("DB Instance \"" + dbSids[sidIter] + "\" : Unknown error occurred. See log file for details.");
                OLogger.printlnOnLog("DB Instance \"" + dbSids[sidIter] + "\" : Unknown error occurred.");
                OLogger.printlnOnLog(normalOutput);
                allSIDsPassed = false;
                continue;
            }
            SIDStatus[sidIter] = false;
            OLogger.printlnOnLog("DB Instance \"" + dbSids[sidIter] + "\" is up.\n");
        }
        if (resObj.getResult() != PrereqResult.ExecuteStatus.FAILED && allSIDsPassed) {
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        } else if (OPatchEnv.isContinueOnPrereqFailure()) {
            for (String patchId : patchesToApplyList) {
                OUSession.addPrereqResultForPatchesToReport(patchId, OPatchPatchPrereq.CHECK_DB_INSTANCE_UP, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
            }
        }
        OPatchEnv.setSIDStatus(SIDStatus);
        return resObj;
    }

    private static String createSQLFileForStatusCheck(String oracleHomePath) {
        StringBuffer buff = new StringBuffer(OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath));
        buff.append(File.separator);
        buff.append("db_status.sql");
        StringBuffer cmds = new StringBuffer();
        cmds.append("select * from dual");
        cmds.append(";\nexit;\n");
        try {
            Path f2 = WrapperFactory.getNioServiceWrapper().getPath(buff.toString(), new String[0]);
            if (!Files.exists(f2, new LinkOption[0])) {
                Files.createFile(f2, new FileAttribute[0]);
            }
            if (!Files.exists(f2, new LinkOption[0])) {
                throw new RuntimeException("Cannot create \"" + buff.toString() + "\"");
            }
            BufferedWriter bw = Files.newBufferedWriter(f2, Charset.forName("UTF-8"), new OpenOption[0]);
            bw.write(cmds.toString());
            bw.close();
        }
        catch (IOException e2) {
            RuntimeException re = new RuntimeException(e2);
            throw re;
        }
        return buff.toString();
    }

    public static PrereqResult checkOPatchMinVersionRequirement(String oracleHomePath, PatchObject[] patchObjects) {
        PrereqResult resObj = new PrereqResult();
        resObj = PrereqAPI.checkOPatchMinVersionRequirement(oracleHomePath, patchObjects, OPatchEnv.getCallerVersion());
        return resObj;
    }

    public static PrereqResult checkOPatchMinVersionRequirement(String oracleHomePath, PatchObject[] patchObjects, String version) {
        StringBuffer buff = new StringBuffer("PrereqAPI::checkOPatchMinVersionRequirement()");
        OLogger.debug(buff);
        PrereqResult resObj = new PrereqResult();
        try {
            OPatchSessionHelper.checkMinOPatchVersions(patchObjects, version);
        }
        catch (RuntimeException e2) {
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            resObj.addDetail(e2.getMessage());
        }
        if (resObj.getResult() != PrereqResult.ExecuteStatus.FAILED) {
            buff = new StringBuffer("\nAll patches can be applied using this OPatch.");
            OLogger.verbose(OPatchSession.PREREQ, buff);
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            OLogger.debug(new StringBuffer("Prereq checkOPatchMinVersionRequirement Passed"));
        }
        if (OPatchEnv.isContinueOnPrereqFailure() || !OPatchEnv.isOPatchCLIMode()) {
            List<String> failedPatches = PrereqAPI.getFailedPatches();
            for (String patchId : failedPatches) {
                OUSession.addPrereqResultForPatchesToReport(patchId, OPatchPatchPrereq.CHECK_MINIMUM_OPATCH_VERSION, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
            }
        }
        return resObj;
    }

    public static PrereqResult checkPatchsetUpdateComponents(String oracleHomePath, PatchObject[] patchObjects) {
        StringBuffer buff = new StringBuffer("PrereqAPI::checkPatchsetUpdateComponents()");
        OLogger.debug(buff);
        PrereqResult resObj = new PrereqResult();
        if (patchObjects == null) {
            buff = new StringBuffer("PatchObject Array is null");
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            resObj.addDetail(buff.toString());
        }
        PrereqResult isCompat = new PrereqResult();
        isCompat = PrereqAPI.checkPatchsetUpdateCompatible(oracleHomePath, patchObjects);
        if (isCompat.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED || isCompat.getResult() == PrereqResult.ExecuteStatus.FAILED) {
            if (OPatchEnv.isContinueOnPrereqFailure()) {
                for (PatchObject pObject : patchObjects) {
                    OUSession.addPrereqResultForPatchesToReport(pObject.getPatchID(), OPatchPatchPrereq.CHECK_PATCHSET_UPDATE_COMPONENTS, isCompat, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
                }
            }
            return isCompat;
        }
        IIPMReadServices readServices = null;
        try {
            readServices = PrereqSession.getReadServices(oracleHomePath);
        }
        catch (Throwable t) {
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            OLogger.debug(new StringBuffer("Throwable occurred: " + t.getMessage()));
            resObj.addDetail(t);
            return resObj;
        }
        InstalledComponent[] installedComponents = readServices.getInstalledComponents();
        ArrayList<String> failedPatches = new ArrayList<String>();
        for (int i2 = 0; i2 < patchObjects.length; ++i2) {
            if (!patchObjects[i2].getPatchInventory().isMiniPatchSet()) continue;
            ArrayList updateComp = patchObjects[i2].getPatchInventory().getUpdateCompsList();
            UpdateComponent[] uc = new UpdateComponent[updateComp.size()];
            for (int j2 = 0; j2 < updateComp.size(); ++j2) {
                UpdateComponent upObj;
                uc[j2] = upObj = (UpdateComponent)updateComp.get(j2);
            }
            try {
                readServices.haveComponents(uc);
            }
            catch (RuntimeException e2) {
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                OLogger.debug(new StringBuffer("Exception occurred " + e2.getMessage()));
                resObj.addDetail("\nPatch Set Update " + patchObjects[i2].getPatchID() + ": " + e2.getMessage() + "\n");
                failedPatches.add(patchObjects[i2].getPatchID());
            }
            boolean isAnyUpdateComp = false;
            boolean checkZeroComp = false;
            for (int j3 = 0; j3 < updateComp.size(); ++j3) {
                UpdateComponent upObj = (UpdateComponent)updateComp.get(j3);
                if (!upObj.isIncluded()) continue;
                isAnyUpdateComp = true;
            }
            if (isAnyUpdateComp || !checkZeroComp) continue;
            buff = new StringBuffer("Patch Set Update \"" + patchObjects[i2].getPatchID() + "\": There are zero components to be upgraded in the Oracle Home.\nPatchset Update requires component version upgrade.\n");
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            resObj.addDetail(buff.toString());
            failedPatches.add(patchObjects[i2].getPatchID());
        }
        if (resObj.getResult() != PrereqResult.ExecuteStatus.FAILED) {
            buff = new StringBuffer("\nAll the components to be upgraded can be done successfully.");
            OLogger.verbose(OPatchSession.PREREQ, buff);
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            OLogger.debug(new StringBuffer("Prereq checkPatchsetUpdateComponents Passed"));
        } else if (OPatchEnv.isContinueOnPrereqFailure()) {
            for (String patchId : failedPatches) {
                OUSession.addPrereqResultForPatchesToReport(patchId, OPatchPatchPrereq.CHECK_PATCHSET_UPDATE_COMPONENTS, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
            }
        }
        return resObj;
    }

    public static PrereqResult checkComponents(String oracleHomePath, PatchObject patchObject, Vector includedPC) throws NoOpPatchException {
        StringBuffer buff = new StringBuffer("PrereqAPI::checkComponents()");
        OLogger.debug(buff);
        PrereqResult resObj = new PrereqResult();
        boolean failedReqComponent = false;
        boolean ngVersionMismatchFailure = false;
        boolean metadataFailure = false;
        String metadataFailureDetails = "";
        try {
            IIPMReadServices readServices = PrereqSession.getReadServices(oracleHomePath);
            Map<PatchComponent, PatchComponentCheckResult> analyzed = readServices.analyzePatchComponents(patchObject, OPatchEnv.isNRollback());
            PatchComponentCheckResult pcCheck = null;
            for (PatchComponent pc : analyzed.keySet()) {
                pcCheck = analyzed.get(pc);
                OLogger.debug(pcCheck.getDetails());
                if (pcCheck.getResult().isProcessComponent()) {
                    includedPC.add(pc);
                    continue;
                }
                if (pcCheck.getResult().isProcessingNotRequired()) {
                    pc.setExcluded();
                    continue;
                }
                if (pc.isRequired()) {
                    failedReqComponent = true;
                } else {
                    pc.setExcluded();
                }
                if (!OPatchEnv.isCUPSupported()) continue;
                if (pcCheck.getResult().isVersionMismatch()) {
                    ngVersionMismatchFailure = true;
                }
                if (!pcCheck.getResult().isMetaDataError()) continue;
                metadataFailure = true;
                metadataFailureDetails = pcCheck.getDetails();
            }
        }
        catch (Throwable t) {
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            OLogger.debug(new StringBuffer("Throwable occurred: " + t.getMessage()));
            resObj.addDetail(t.getMessage());
            return resObj;
        }
        if (ngVersionMismatchFailure) {
            includedPC.removeAllElements();
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            resObj.addDetail("Version Mismatch of Component occurred. This Patch cannot be applied");
            return resObj;
        }
        if (metadataFailure) {
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            resObj.addDetail(metadataFailureDetails);
            return resObj;
        }
        if (failedReqComponent) {
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            resObj.addDetail("One or many required components cannot be processed.");
            return resObj;
        }
        resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        resObj.addDetail("CheckComponent prereq succeeded");
        return resObj;
    }

    protected static PrereqResult checkOptionalComponents(String oracleHomePath, PatchObject patchObject, Vector includedPC) {
        StringBuffer buff = new StringBuffer("PrereqAPI::checkOptionalComponents()");
        OLogger.debug(buff);
        PrereqResult resObj = new PrereqResult();
        try {
            IIPMReadServices readServices = PrereqSession.getReadServices(oracleHomePath);
            Map<PatchComponent, PatchComponentCheckResult> analyzedPC = readServices.analyzeOptionalPatchComponents(patchObject, OPatchEnv.isNRollback());
            for (Map.Entry<PatchComponent, PatchComponentCheckResult> entry : analyzedPC.entrySet()) {
                if (!entry.getValue().getResult().isProcessComponent()) continue;
                includedPC.add(entry.getKey());
            }
        }
        catch (Throwable t) {
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            OLogger.debug(new StringBuffer("Throwable occurred: " + t.getMessage()));
            resObj.addDetail(t);
            return resObj;
        }
        resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        return resObj;
    }

    public static PrereqResult checkRollbackableForFusionApps(String oracleHomePath, PatchObject[] patchObjects) {
        PrereqResult resObj = new PrereqResult();
        StringBuffer buff = new StringBuffer("PrereqAPI::checkRollbackableForFusionApps()");
        OLogger.debug(buff);
        try {
            int modelCode = PatchingModel.returnModelCode(oracleHomePath);
            if (modelCode == 1 || modelCode == -1) {
                resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
                return resObj;
            }
            IIPMReadServices readServices = null;
            try {
                readServices = PrereqSession.getReadServices(oracleHomePath);
            }
            catch (Throwable t) {
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                OLogger.debug(new StringBuffer("Throwable occurred: " + t.getMessage()));
                resObj.addDetail(t);
                return resObj;
            }
            if (!readServices.isInventoryLoaded()) {
                buff = new StringBuffer("Unable to get a Inventory Session object");
                resObj.addDetail(buff.toString());
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                if (OPatchEnv.isContinueOnPrereqFailure()) {
                    for (PatchObject patch : patchObjects) {
                        OUSession.addPrereqResultForPatchesToReport(patch.getPatchID(), OPatchPatchPrereq.CHECK_ROLLBACKABLE, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
                    }
                }
                return resObj;
            }
            OneOffEntry[] selectedoneoffs = new OneOffEntry[patchObjects.length];
            for (int pObjIter = 0; pObjIter < patchObjects.length; ++pObjIter) {
                selectedoneoffs[pObjIter] = patchObjects[pObjIter].toOneOffEntry(oracleHomePath);
            }
            OneOffEntry[] installedoneoffs = readServices.getInstalledPatches();
            Date oldest = new Date();
            for (int i2 = 0; i2 < installedoneoffs.length; ++i2) {
                for (int j2 = 0; j2 < selectedoneoffs.length; ++j2) {
                    if (!selectedoneoffs[j2].equals(installedoneoffs[i2])) continue;
                    selectedoneoffs[j2] = installedoneoffs[i2];
                    Date appliedDate = selectedoneoffs[j2].getAppliedDate();
                    oldest = appliedDate.before(oldest) ? appliedDate : oldest;
                }
            }
            StringBuffer listOfNewerPatches = new StringBuffer("");
            ArrayList<String> newerPatches = new ArrayList<String>();
            boolean newerPatchesFound = false;
            boolean newerInstance = false;
            for (int i3 = 0; i3 < installedoneoffs.length; ++i3) {
                if (installedoneoffs[i3].getAppliedDate().before(oldest)) continue;
                newerInstance = true;
                for (int j3 = 0; j3 < selectedoneoffs.length; ++j3) {
                    if (!selectedoneoffs[j3].equals(installedoneoffs[i3])) continue;
                    newerInstance = false;
                    break;
                }
                if (!newerInstance) continue;
                newerPatchesFound = true;
                listOfNewerPatches.append(installedoneoffs[i3].getID());
                listOfNewerPatches.append(" ");
                newerPatches.add(installedoneoffs[i3].getID());
            }
            if (newerPatchesFound) {
                String msg = OLogger.getString("OUI-67641", new Object[]{listOfNewerPatches.toString()});
                resObj.addDetail(msg);
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            }
            if (resObj.getResult() != PrereqResult.ExecuteStatus.FAILED) {
                resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            } else if (OPatchEnv.isContinueOnPrereqFailure()) {
                for (String patchId : newerPatches) {
                    OUSession.addPrereqResultForPatchesToReport(patchId, OPatchPatchPrereq.CHECK_ROLLBACKABLE, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
                }
            }
            return resObj;
        }
        catch (Exception e2) {
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            OLogger.debug(new StringBuffer("Throwable occurred: " + e2.getMessage()));
            resObj.addDetail(e2);
            return resObj;
        }
    }

    public static long getDirSize(Path path) {
        long size = 0L;
        ArrayList<Path> list = new ArrayList<Path>();
        try (DirectoryStream<Path> streams = Files.newDirectoryStream(path);){
            for (Path stream : streams) {
                list.add(stream);
            }
        }
        catch (IOException e2) {
            OLogger.debug(e2.getMessage());
        }
        for (Path current_file : list) {
            if (Files.isRegularFile(current_file, new LinkOption[0])) {
                try {
                    size += Files.size(current_file);
                }
                catch (IOException e3) {
                    OLogger.debug(e3.getMessage());
                }
                continue;
            }
            size += PrereqAPI.getDirSize(current_file);
        }
        return size;
    }

    public static PrereqResult checkNoOpPatches(String oracleHomePath, PatchObject[] patchObjects, Vector store) {
        StringBuffer buff = new StringBuffer("PrereqAPI::checkNoOpPatches()");
        OLogger.debug(buff);
        PrereqResult resObj = new PrereqResult();
        boolean noOpPatchFound = false;
        Vector<PatchObject> snowBallNoOpList = new Vector<PatchObject>();
        PatchObject[] checkSnowBallNoOpList = new PatchObject[]{};
        if (patchObjects == null) {
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            resObj.addDetail("Input array of PatchObjects is null.");
            return resObj;
        }
        int modelCode = PatchingModel.returnModelCode(oracleHomePath);
        StringBuffer listOfNoOpPatches = new StringBuffer("The following no-op. patches have no components compatible with that of the Oracle Home to patch.\n");
        for (int i2 = 0; i2 < patchObjects.length; ++i2) {
            String patchID = patchObjects[i2].getPatchID();
            boolean isNoOp = PrereqAPI.isNoOpPatch(oracleHomePath, patchObjects[i2]);
            if (isNoOp) {
                noOpPatchFound = true;
                listOfNoOpPatches.append(" ");
                listOfNoOpPatches.append(patchID);
                store.add(patchID);
                continue;
            }
            snowBallNoOpList.add(patchObjects[i2]);
        }
        if (snowBallNoOpList != null && snowBallNoOpList.size() != 0) {
            checkSnowBallNoOpList = new PatchObject[snowBallNoOpList.size()];
            snowBallNoOpList.toArray(checkSnowBallNoOpList);
        }
        if (modelCode != 2) {
            if (noOpPatchFound) {
                resObj.addDetail(listOfNoOpPatches.toString());
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            } else {
                OLogger.printlnOnLogAndVerbose("None of the selected patches are no-op. patches..");
                resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            }
        } else {
            PrereqResult sbFileVersions;
            StringBuffer listOfNoOpSnowball = new StringBuffer();
            if (noOpPatchFound) {
                listOfNoOpSnowball.append(listOfNoOpPatches.toString());
                listOfNoOpSnowball.append("\n");
            }
            if ((sbFileVersions = PrereqAPI.checkFileVersions(oracleHomePath, checkSnowBallNoOpList, store)).getResult() == PrereqResult.ExecuteStatus.FAILED) {
                noOpPatchFound = true;
                Vector result = sbFileVersions.getResultDetails();
                for (int k2 = 0; k2 < result.size(); ++k2) {
                    listOfNoOpSnowball.append((String)result.get(k2));
                }
            }
            if (noOpPatchFound) {
                resObj.addDetail(listOfNoOpSnowball.toString());
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                if (OPatchEnv.isContinueOnPrereqFailure()) {
                    Vector failedPatches = store;
                    for (String patchId : failedPatches) {
                        OUSession.addPrereqResultForPatchesToReport(patchId, OPatchPatchPrereq.CHECK_NO_OPERATION_PATCHES, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
                    }
                }
            } else {
                OLogger.printlnOnLogAndVerbose("None of the selected patch(es) are no-op. patch(es)");
                resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            }
        }
        return resObj;
    }

    public static PrereqResult checkDuplicatePatch(String oh, ArrayList exitPatches, OneOffEntry[] pIs) {
        StringBuffer buff = new StringBuffer("PrereqAPI::checkDuplicatePatch()");
        OLogger.debug(buff);
        PrereqResult pr = new PrereqResult();
        int modelCode = PatchingModel.returnModelCode(oh);
        if (modelCode == 2) {
            pr.setResult(PrereqResult.ExecuteStatus.PASSED);
            String msg = "For snowball patching model, let all incoming patches in \n.";
            pr.addDetail(msg);
            buff.setLength(0);
            OLogger.debug(buff.append(msg));
            return pr;
        }
        CheckPatchInterPrereqEngine eng = new CheckPatchInterPrereqEngine();
        pr = eng.checkDuplicatePatch(oh, exitPatches, pIs);
        if (OPatchEnv.isContinueOnPrereqFailure()) {
            for (int i2 = 0; i2 < exitPatches.size(); ++i2) {
                OneOffEntry ooe = (OneOffEntry)exitPatches.get(i2);
                OUSession.addPrereqResultForPatchesToReport(ooe.getPatchID(), OPatchPatchPrereq.CHECK_FOR_IDENTICAL_PATCHES_IN_ORACLE_HOME, pr, OPatchAnalysisReport.PrereqStatusForPatch.SKIP);
            }
        }
        return pr;
    }

    public static PrereqResult checkIdenticalPatch(String oh, ArrayList exitPatches, OneOffEntry[] pIs) {
        StringBuffer buff = new StringBuffer("PrereqAPI::checkIdenticalPatch()");
        OLogger.debug(buff);
        PrereqResult pr = new PrereqResult();
        int modelCode = PatchingModel.returnModelCode(oh);
        if (modelCode == 2) {
            pr.setResult(PrereqResult.ExecuteStatus.PASSED);
            String msg = "For snowball patching model, let all incoming patches in \n.";
            pr.addDetail(msg);
            buff.setLength(0);
            OLogger.debug(buff.append(msg));
            return pr;
        }
        CheckPatchInterPrereqEngine eng = new CheckPatchInterPrereqEngine();
        pr = eng.checkIdenticalPatch(oh, exitPatches, pIs);
        if (OPatchEnv.isContinueOnPrereqFailure()) {
            for (int i2 = 0; i2 < exitPatches.size(); ++i2) {
                OneOffEntry ooe = (OneOffEntry)exitPatches.get(i2);
                OUSession.addPrereqResultForPatchesToReport(ooe.getPatchID(), OPatchPatchPrereq.CHECK_FOR_IDENTICAL_PATCHES_IN_ORACLE_HOME, pr, OPatchAnalysisReport.PrereqStatusForPatch.SKIP);
            }
        }
        return pr;
    }

    public static PrereqResult OLD_checkIdenticalPatch(String oh, ArrayList exitPatches, OneOffEntry[] pIs) {
        StringBuffer buff = new StringBuffer("PrereqAPI::checkIdenticalPatch()");
        OLogger.debug(buff);
        PrereqResult pr = new PrereqResult();
        int modelCode = PatchingModel.returnModelCode(oh);
        boolean calledFromOUI = Boolean.getBoolean("oracle.opatch.opatchprereq.calledFromOUI");
        if (pIs == null || pIs.length == 0) {
            pr.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            String msg = "Empty List of incoming patches.";
            pr.addDetail(msg);
            buff.setLength(0);
            OLogger.debug(buff.append(msg));
            return pr;
        }
        HashMap hm = new HashMap();
        StringBuffer sb = null;
        for (int i2 = 0; i2 < pIs.length; ++i2) {
            String uidPi = PrereqAPI.norm(pIs[i2].getPSENumber());
            if ("".equals(uidPi)) continue;
            String idPi = PrereqAPI.norm(pIs[i2].getID());
            if (hm.containsKey(uidPi)) {
                ((ArrayList)hm.get(uidPi)).add(idPi);
                continue;
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add(idPi);
            hm.put(uidPi, list);
        }
        Set set = hm.keySet();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            ArrayList list = (ArrayList)hm.get(it.next());
            if (list.size() <= 1) continue;
            sb = sb == null ? (sb = new StringBuffer(list.toString())) : sb.append("\n").append(list.toString());
        }
        if (sb != null) {
            // empty if block
        }
        if ("".equals(oh = PrereqAPI.norm(oh))) {
            pr.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            String msg = "Invalid Oracle Home Path.";
            pr.addDetail(msg);
            buff.setLength(0);
            OLogger.debug(buff.append(msg));
            return pr;
        }
        OneOffEntry[] pOHs = null;
        try {
            pOHs = PrereqAPI.getInstalledOneOff(oh);
        }
        catch (Throwable t) {
            pr.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            OLogger.printlnOnLog("Exception occurred while getting patches installed in Oracle Home \n" + t.getMessage());
            pr.addDetail(new Exception(t));
            return pr;
        }
        if (pOHs == null || pOHs.length == 0) {
            pr.setResult(PrereqResult.ExecuteStatus.PASSED);
            String msg = "No patch installed in Oracle Home. Skipping check.";
            pr.addDetail(msg);
            buff.setLength(0);
            OLogger.debug(buff.append(msg));
            return pr;
        }
        int size = pOHs.length;
        HashMap<String, String> hm1 = new HashMap<String, String>(size);
        HashMap<String, String> hm2 = new HashMap<String, String>(size);
        HashMap<String, String> hm3 = new HashMap<String, String>(size);
        HashMap<String, String> hm4 = new HashMap<String, String>(size);
        boolean shouldWarn = false;
        for (int i3 = 0; i3 < size; ++i3) {
            if (pOHs[i3] == null) continue;
            String id = PrereqAPI.norm(pOHs[i3].getTripletID());
            String uid = PrereqAPI.norm(pOHs[i3].getPSENumber());
            String cd = PrereqAPI.norm(pOHs[i3].getCreationDate());
            String zd = PrereqAPI.norm(pOHs[i3].getCreationZone());
            if (!"".equals(id)) {
                hm1.put(id, uid);
                hm2.put(id, cd);
                hm4.put(id, zd);
            }
            if ("".equals(uid)) continue;
            hm3.put(uid, id);
        }
        int status = 0;
        StringBuffer[] msgs = new StringBuffer[6];
        boolean silent = OPatchEnv.isSilent() || calledFromOUI;
        for (int i4 = 0; i4 < pIs.length; ++i4) {
            String zdPoh;
            OneOffEntry pi = pIs[i4];
            String idPi = PrereqAPI.norm(pi.getTripletID());
            String uidPi = PrereqAPI.norm(pi.getPSENumber());
            String cdPi = PrereqAPI.norm(pi.getCreationDate());
            String zdPi = PrereqAPI.norm(pi.getCreationZone());
            String uidPoh = (String)hm1.get(idPi);
            if (uidPoh == null) {
                String idPr = (String)hm3.get(uidPi);
                if (idPr != null) continue;
                buff.setLength(0);
                OLogger.debug(buff.append("PREREQ_CHECK_ID_MISSING_UID_MISSING [PASS] Pi [").append(idPi).append("]"));
                continue;
            }
            if (uidPi.equals(uidPoh) && !"".equals(uidPi)) {
                status |= 2;
                msgs[1] = msgs[1] == null ? new StringBuffer(idPi) : msgs[1].append(" ").append(idPi);
                buff.setLength(0);
                OLogger.debug(buff.append("PREREQ_CHECK_PATCH_FOUND_IN_OH [EXIT] Pi [").append(idPi).append("]"));
                exitPatches.add(pi);
                continue;
            }
            String cdPoh = (String)hm2.get(idPi);
            long cmp = PrereqAPI.compareDate(cdPi, zdPi, cdPoh, zdPoh = (String)hm4.get(idPi));
            if (cmp == 0L) {
                if (modelCode == 2) {
                    status |= 2;
                    msgs[1] = msgs[1] == null ? new StringBuffer(idPi) : msgs[1].append(" ").append(idPi);
                    buff.setLength(0);
                    OLogger.debug(buff.append("PREREQ_CHECK_PATCH_FOUND_IN_OH [EXIT] Pi [").append(idPi).append("]"));
                    exitPatches.add(pi);
                    continue;
                }
                status |= 1;
                msgs[5] = msgs[5] == null ? new StringBuffer(idPi) : msgs[5].append(" ").append(idPi);
                buff.setLength(0);
                OLogger.debug(buff.append("PREREQ_CHECK_PATCH_FOUND_IN_OH [WARN] Pi [").append(idPi).append("]"));
                continue;
            }
            if (cmp > 0L) {
                if (modelCode == 2) {
                    status |= 2;
                    msgs[2] = msgs[2] == null ? new StringBuffer(idPi) : msgs[2].append(" ").append(idPi);
                    buff.setLength(0);
                    buff.append("PREREQ_CHECK_UNEQUAL_UID_I_GT_OH [EXIT] Pi [").append(idPi).append("], [cdPi,cdPoh] [");
                    buff.append(cdPi).append(",").append(cdPoh).append("]");
                    exitPatches.add(pi);
                    OLogger.debug(buff);
                    continue;
                }
                status |= 1;
                msgs[3] = msgs[3] == null ? new StringBuffer(idPi) : msgs[3].append(" ").append(idPi);
                buff.setLength(0);
                buff.append("PREREQ_CHECK_UNEQUAL_UID_I_GT_OH_SILENT [WARN] Pi [").append(idPi);
                buff.append("], [cdPi,cdPoh] [").append(cdPi).append(",").append(cdPoh).append("]");
                OLogger.debug(buff);
                continue;
            }
            if (modelCode == 2) {
                status |= 2;
                msgs[2] = msgs[2] == null ? new StringBuffer(idPi) : msgs[2].append(" ").append(idPi);
                buff.setLength(0);
                buff.append("PREREQ_CHECK_UNEQUAL_UID_I_LT_OH [EXIT] Pi [").append(idPi).append("], [cdPi,cdPoh] [");
                buff.append(cdPi).append(",").append(cdPoh).append("]");
                exitPatches.add(pi);
                OLogger.debug(buff);
                continue;
            }
            shouldWarn = true;
            status |= 1;
            msgs[4] = msgs[4] == null ? new StringBuffer(idPi) : msgs[4].append(" ").append(idPi);
            buff.setLength(0);
            buff.append("PREREQ_CHECK_UNEQUAL_UID_I_LT_OH [WARN] Pi [").append(idPi);
            buff.append("], [cdPi,cdPoh] [").append(cdPi).append(",").append(cdPoh).append("]");
            OLogger.debug(buff);
        }
        String retMsg = "";
        if (OPatchEnv.getSessionType().equalsIgnoreCase("prereq")) {
            retMsg = PrereqAPI.printWarningMessages(msgs, true) + PrereqAPI.getErrorMessages(msgs);
        } else {
            boolean shouldPrint = true;
            if (exitPatches.size() != pIs.length && pIs.length != 1) {
                shouldPrint = false;
            }
            if (shouldWarn) {
                shouldPrint = true;
            }
            if (calledFromOUI) {
                shouldPrint = false;
            }
            String warnMsg = PrereqAPI.printWarningMessages(msgs, shouldPrint);
            if (calledFromOUI) {
                retMsg = warnMsg;
            }
            retMsg = retMsg + PrereqAPI.getErrorMessages(msgs);
        }
        buff.setLength(0);
        OLogger.debug(buff.append("Error Messages").append(retMsg));
        if (status >= 4) {
            pr.setResult(PrereqResult.ExecuteStatus.FAILED);
        } else if (status >= 2) {
            if (calledFromOUI) {
                pr.setResult(PrereqResult.ExecuteStatus.FAILED);
            } else {
                if (!OPatchEnv.getSessionType().equalsIgnoreCase("prereq")) {
                    buff.setLength(0);
                    OLogger.debug(buff.append("Error Messages[ExitOpatchException]").append(retMsg));
                    throw new ExitOPatchException(retMsg);
                }
                pr.setResult(PrereqResult.ExecuteStatus.FAILED);
            }
        } else {
            pr.setResult(PrereqResult.ExecuteStatus.PASSED);
        }
        pr.addDetail(retMsg);
        return pr;
    }

    private static String printWarningMessages(StringBuffer[] msgs, boolean shouldPrint) {
        String s = "";
        if (msgs != null && msgs.length >= 6) {
            if (msgs[1] != null) {
                if (!OPatchEnv.getSessionType().equalsIgnoreCase("prereq") && shouldPrint) {
                    OLogger.warn("OUI-67632", new Object[]{msgs[1]});
                }
                s = s + OLogger.getString("OUI-67632", new Object[]{msgs[1]});
            }
            if (msgs[2] != null) {
                if (!OPatchEnv.getSessionType().equalsIgnoreCase("prereq") && shouldPrint) {
                    OLogger.warn("OUI-67633", new Object[]{msgs[2]});
                }
                s = s + OLogger.getString("OUI-67633", new Object[]{msgs[2]});
            }
            if (msgs[3] != null) {
                if (!OPatchEnv.getSessionType().equalsIgnoreCase("prereq") && shouldPrint) {
                    OLogger.warn("OUI-67634", new Object[]{msgs[3]});
                }
                s = s + OLogger.getString("OUI-67634", new Object[]{msgs[3]});
            }
            if (msgs[4] != null) {
                if (!OPatchEnv.getSessionType().equalsIgnoreCase("prereq") && shouldPrint) {
                    OLogger.warn("OUI-67953", new Object[]{msgs[4]});
                }
                s = s + OLogger.getString("OUI-67638", new Object[]{msgs[4]});
            }
            if (msgs[5] != null) {
                if (!OPatchEnv.getSessionType().equalsIgnoreCase("prereq") && shouldPrint) {
                    OLogger.warn("OUI-67954", new Object[]{msgs[5]});
                }
                s = s + OLogger.getString("OUI-67954", new Object[]{msgs[5]});
            }
        }
        return s;
    }

    private static String getErrorMessages(StringBuffer[] msgs) {
        String s = "";
        if (msgs != null && msgs.length >= 6 && msgs[0] != null) {
            s = s + OLogger.getString("OUI-67631", new Object[]{msgs[0]});
        }
        return s;
    }

    private static String norm(String s) {
        return s == null ? "" : s.trim();
    }

    private static long compareDate(String s1, String z1, String s2, String z2) {
        SimpleDateFormat df = new SimpleDateFormat("dd MMM yyyy, HH:mm:ss 'hrs'", Locale.ENGLISH);
        long l1 = 0L;
        try {
            df.setTimeZone(TimeZone.getTimeZone(z1));
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
        }
        try {
            l1 = df.parse(s1).getTime();
        }
        catch (Exception e3) {
            OLogger.printStackTrace(e3);
        }
        long l2 = 0L;
        try {
            df.setTimeZone(TimeZone.getTimeZone(z2));
        }
        catch (Exception e4) {
            OLogger.printStackTrace(e4);
        }
        try {
            l2 = df.parse(s2).getTime();
        }
        catch (Exception e5) {
            OLogger.printStackTrace(e5);
        }
        return l1 - l2;
    }

    public static PrereqResult checkPatchActionsForSymbolComponent(String oracleHomePath, PatchObject[] apObjects) {
        PrereqResult resObj = new PrereqResult();
        StringBuffer buff = new StringBuffer("PrereqAPI::checkPatchActionsForSymbolComponent()");
        OLogger.debug(buff);
        if (apObjects == null) {
            buff = new StringBuffer("Input list of PatchObjects are 'null'");
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            resObj.addDetail(buff.toString());
            return resObj;
        }
        HashMap dstFileMap = new HashMap();
        for (int i2 = 0; i2 < apObjects.length; ++i2) {
            PatchComponent[] pcs = apObjects[i2].getIncludedPatchComponents();
            for (int j2 = 0; j2 < pcs.length; ++j2) {
                if (!pcs[j2].hasSymbol()) continue;
                String[] dirs = pcs[j2].getProductDirectories(oracleHomePath);
                for (int l2 = 0; l2 < dirs.length; ++l2) {
                    if (dirs[l2] == null) continue;
                    buff = new StringBuffer("Setting up mapped producte directories hashmap :\n");
                    buff.append("  key -> ");
                    buff.append(dirs[l2] + "\n");
                    buff.append("  value -> [ PatchComponent: name=");
                    buff.append(pcs[j2].getName());
                    buff.append(", version=");
                    buff.append(pcs[j2].getVersion());
                    buff.append(", symbol=");
                    buff.append(pcs[j2].getSymbolName());
                    buff.append("]");
                    OLogger.debug(buff);
                    if (dstFileMap.containsKey(dirs[l2])) {
                        ((ArrayList)dstFileMap.get(dirs[l2])).add(pcs[j2]);
                        continue;
                    }
                    ArrayList<PatchComponent> symbolComps = new ArrayList<PatchComponent>();
                    symbolComps.add(pcs[j2]);
                    dstFileMap.put(dirs[l2], symbolComps);
                }
            }
            Iterator iter = dstFileMap.keySet().iterator();
            HashMap actionMap = new HashMap();
            while (iter.hasNext()) {
                String key = iter.next().toString();
                ArrayList comps = (ArrayList)dstFileMap.get(key);
                if (comps.size() <= 1) continue;
                for (int j3 = 0; j3 < comps.size(); ++j3) {
                    PatchComponent pc = (PatchComponent)comps.get(j3);
                    PatchAction[] actions = pc.getAllActions();
                    buff = new StringBuffer("Patch component [");
                    buff.append(pc.getName());
                    buff.append(", ");
                    buff.append(pc.getVersion());
                    buff.append(", ");
                    buff.append(pc.getSymbolName());
                    buff.append("] ");
                    for (int k2 = 0; k2 < actions.length; ++k2) {
                        if (!(actions[k2] instanceof ConflictDetectable)) continue;
                        Object[] pair = new Object[]{pc, actions[k2]};
                        String dstPath = actions[k2].getParentFilePath(oracleHomePath);
                        StringBuffer actionBuff = new StringBuffer(buff.toString());
                        actionBuff.append("has action which touches \"");
                        actionBuff.append(dstPath);
                        actionBuff.append("\"");
                        OLogger.debug(actionBuff);
                        if (dstPath == null || dstPath.equals("")) continue;
                        if (actionMap.containsKey(dstPath)) {
                            ((ArrayList)actionMap.get(dstPath)).add(pair);
                            continue;
                        }
                        ArrayList<Object[]> actionList = new ArrayList<Object[]>();
                        actionList.add(pair);
                        actionMap.put(dstPath, actionList);
                    }
                }
            }
            iter = actionMap.keySet().iterator();
            boolean flag = false;
            while (iter.hasNext()) {
                String key = iter.next().toString();
                ArrayList pair = (ArrayList)actionMap.get(key);
                if (pair.size() <= 1) continue;
                ArrayList cflActions = new ArrayList();
                for (int k3 = 0; k3 < pair.size(); ++k3) {
                    Object[] caArr = (Object[])pair.get(k3);
                    ConflictDetectable a1 = (ConflictDetectable)caArr[1];
                    for (int j4 = k3 + 1; j4 < pair.size(); ++j4) {
                        Object[] caArr2 = (Object[])pair.get(j4);
                        ConflictDetectable a2 = (ConflictDetectable)caArr2[1];
                        PatchComponent pc1 = (PatchComponent)caArr[0];
                        PatchComponent pc2 = (PatchComponent)caArr2[0];
                        if (pc1.equals(pc2) || !ConflictHandler.compareFilesForConflict(a1.filesTouched(oracleHomePath), a2.filesTouched(oracleHomePath))) continue;
                        if (!flag) {
                            buff = new StringBuffer("Patch [ ");
                            buff.append(apObjects[i2].getPatchID());
                            buff.append(" ] following symbol patch components are different");
                            buff.append(" while they have actions which touch the same file :\n");
                        }
                        flag = true;
                        buff.append("    Component [");
                        buff.append(pc1.getName());
                        buff.append(", ");
                        buff.append(pc1.getVersion());
                        buff.append(", ");
                        buff.append(pc1.getSymbolName());
                        buff.append("] and component [");
                        buff.append(pc2.getName());
                        buff.append(", ");
                        buff.append(pc2.getVersion());
                        buff.append(", ");
                        buff.append(pc2.getSymbolName());
                        buff.append("] have some action which touches the same file \"");
                        buff.append(key);
                        buff.append("\"");
                    }
                }
            }
            if (!flag) continue;
            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
            resObj.addDetail(buff.toString());
        }
        if (resObj.getResult() != PrereqResult.ExecuteStatus.FAILED) {
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        }
        return resObj;
    }

    public static PrereqResult checkIfRequiredDeleteActionExist(String oracleHomePath, PatchObject[] patchObjects) {
        StringBuffer buff = new StringBuffer("PrereqAPI::checkIfRequiredDeleteActionExist()");
        OLogger.debug(buff);
        StringBuffer patchInfo = new StringBuffer("");
        boolean inputFault = false;
        PrereqResult resObj = new PrereqResult();
        buff = new StringBuffer("");
        IIPMReadServices readServices = null;
        try {
            readServices = PrereqSession.getReadServices(oracleHomePath);
        }
        catch (Throwable t) {
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            OLogger.debug(new StringBuffer("Throwable occurred: " + t.getMessage()));
            resObj.addDetail(t);
            return resObj;
        }
        Map<Object, Object> copyFileVerMap = new HashMap();
        if (OPatchEnv.isFATwoPhase()) {
            boolean fvExist = ProcessFileVersions.existFvOh(oracleHomePath);
            if (fvExist) {
                OLogger.printlnOnLogAndVerbose("\ncheckIfRequiredDeleteActionExist: Parse cached fv_oh to get HashTable of all installed Snowball Copy Actions Filenames with their versions...");
                try {
                    NApplyDataSerializer serializer = new NApplyDataSerializer();
                    copyFileVerMap = serializer.deserializeFileVersion(OPatchEnv.getPrereqResultFileLoc(oracleHomePath) + File.separator + "fv_oh.txt");
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    OLogger.printlnOnLogAndVerbose("Unable to parse cached OH files.");
                    fvExist = false;
                }
            }
            if (!fvExist) {
                OLogger.printlnOnLogAndVerbose("\ncheckIfRequiredDeleteActionExist: Cached fv_oh does not exist or is invalid, re-generate it.");
                if (!readServices.isInventoryLoaded()) {
                    buff = new StringBuffer("Unable to get Inventory Session object");
                    resObj.addDetail(buff.toString());
                    resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                    return resObj;
                }
                copyFileVerMap = OPatchSessionHelper.getCopyFileVer(readServices);
            }
        } else {
            OPatchSessionHelper.getCopyActionVer(readServices);
            copyFileVerMap = DeleteAction.getCopyFileVer();
        }
        ArrayList<String> failedPatches = new ArrayList<String>();
        for (int i2 = 0; i2 < patchObjects.length; ++i2) {
            ListIterator dActions = patchObjects[i2].getAllIncludedDeleteActions();
            patchInfo = new StringBuffer(" Patch " + patchObjects[i2].getPatchID() + " : \n");
            while (dActions.hasNext()) {
                String fileVersion;
                DeleteAction da = (DeleteAction)dActions.next();
                if (!da.isSnowBallDeleteAction()) continue;
                String filename = da.getFileName();
                Path deleteFileInOH = WrapperFactory.getNioServiceWrapper().getPath(oracleHomePath + File.separator + filename, new String[0]);
                String string = fileVersion = da.isHasFileVersion() ? da.getFileVersion() : "lemax.version";
                if (!da.getIsReq()) continue;
                if (!Files.exists(deleteFileInOH, new LinkOption[0])) {
                    resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                    buff.append("  \tRequired Delete Action ");
                    buff.append(filename);
                    buff.append(" with version ");
                    buff.append(da.getFileVersion());
                    buff.append(" failed, the target file doesn't exist in oracle home");
                    inputFault = true;
                    continue;
                }
                if (fileVersion.startsWith("le")) {
                    if ("lemax.version".equals(fileVersion)) continue;
                    String updateVersion = fileVersion.substring(2);
                    String presentVersion = (String)copyFileVerMap.get(filename);
                    int retVal = OPatchSessionHelper.isGreaterDecimal(presentVersion, updateVersion);
                    if (retVal == -1) continue;
                    resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                    buff.append("  \tRequired Delete Action ");
                    buff.append(filename);
                    buff.append(" with version ");
                    buff.append(da.getFileVersion());
                    buff.append(" failed, it has no subset action in oracle home.");
                    inputFault = true;
                    continue;
                }
                String presentVersion = (String)copyFileVerMap.get(filename);
                int retVal = OPatchSessionHelper.isGreaterDecimal(presentVersion, fileVersion);
                if (retVal == 0) continue;
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                buff.append("  \tRequired Delete Action ");
                buff.append(filename);
                buff.append(" with version ");
                buff.append(da.getFileVersion());
                buff.append(" failed, the target file doesn't exist in oracle home.");
                inputFault = true;
            }
            if (inputFault) {
                buff.append("\n");
                patchInfo.append(buff);
                inputFault = false;
                resObj.addDetail(patchInfo.toString());
                failedPatches.add(patchObjects[i2].getPatchID());
            }
            patchInfo = new StringBuffer();
            buff = new StringBuffer();
        }
        if (resObj.getResult() != PrereqResult.ExecuteStatus.FAILED) {
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        } else if (OPatchEnv.isContinueOnPrereqFailure()) {
            for (String patchId : failedPatches) {
                OUSession.addPrereqResultForPatchesToReport(patchId, OPatchPatchPrereq.CHECK_IF_REQUIRED_DELETE_ACTION_EXIST, resObj, OPatchAnalysisReport.PrereqStatusForPatch.FAILED);
            }
        }
        return resObj;
    }

    private static void checkConflictZOPMessage(ConflictMatrixOutput resObj, CheckConflictAdapter adapter) {
        if (resObj.getResult() == PrereqResult.ExecuteStatus.FAILED && OPatchEnv.getSessionType().equalsIgnoreCase("prereq")) {
            if (adapter.hasSupersetFlag()) {
                ZOPErrorMessage.printErrorMessage(47);
            }
            if (adapter.isConflictStatusCode()) {
                ZOPErrorMessage.printErrorMessage(40);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrereqResult checkStability(String oracleHomePath) {
        StringBuffer buff = new StringBuffer("PrereqAPI::checkStability(). Oracle Home path: " + oracleHomePath);
        OLogger.debug(buff);
        PrereqResult resObj = new PrereqResult();
        if (OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS)) {
            try {
                OPatchOverCAS.INSTANCE.initializeCAS(oracleHomePath);
                boolean result = CASClientFactory.getCASClient().isLastCheckpointCompleted(oracleHomePath);
                if (result) {
                    resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
                    String msg = "Prereq checkStability Passed.";
                    resObj.addDetail(msg);
                }
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                String msg = "Prereq checkStability Failed.";
                resObj.addDetail(msg);
            }
            catch (Throwable t) {
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                String msg = "Throwable occurred: " + t.getMessage();
                resObj.addDetail(msg);
                OLogger.debug(buff.append(msg));
            }
            finally {
                OPatchOverCAS.INSTANCE.cleanupCAS();
            }
        } else {
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            String msg = "CAS is not supported.";
            resObj.addDetail(msg);
            OLogger.debug(buff.append(msg));
        }
        return resObj;
    }

    public static PrereqResult checkIfSupportCasDirectlyPatching(String oracleHomePath) {
        StringBuffer buff = new StringBuffer("PrereqAPI::checkIfSupportCasDirectlyPatching(). Oracle Home path: " + oracleHomePath);
        OLogger.debug(buff);
        PrereqResult resObj = new PrereqResult();
        boolean isCasDirectlyPatching = PatchingFlow.CAS_REPO.equals((Object)OPatchEnv.getPatchingFlow());
        if (isCasDirectlyPatching) {
            boolean isDBHome = OPatchEnv.isDBHome(oracleHomePath);
            if (isDBHome) {
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                buff = new StringBuffer("Prereq checkIfSupportCasDirectlyPatching Failed.");
                buff.append("Cas directly patching flow is not support DB home. Pls use legacy flow");
                resObj.addDetail(buff);
            } else {
                resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
                String msg = "Prereq checkIfSupportCasDirectlyPatching Passed.";
                resObj.addDetail(msg);
            }
        } else {
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            String msg = "This is not Cas directly patching flow. No need to check.";
            resObj.addDetail(msg);
        }
        return resObj;
    }

    public static List<String> getPatchesToApplyList() {
        return patchesToApplyList;
    }

    public static void setPatchesToApplyList(List<String> patchesToApplyList) {
        PrereqAPI.patchesToApplyList = patchesToApplyList;
    }

    public static List<String> getFailedPatches() {
        return failedPatches;
    }

    public static void setFailedPatches(List<String> failedPatches) {
        PrereqAPI.failedPatches = failedPatches;
    }

    private static boolean isRegenerationNeeded(String oracleHome, PatchObject[] patchObjects) throws Exception {
        if (OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS)) {
            OLogger.printlnOnLog("OOP is disabled for CAS flow");
            return false;
        }
        RegenerateLib rlib = new RegenerateLib(patchObjects, oracleHome);
        boolean isRegenerationNeeded = false;
        isRegenerationNeeded = rlib.isRegenerationNeeded();
        if (isRegenerationNeeded) {
            OLogger.printlnOnLog(OLogger.INFO, "Regeneration is needed,OOP should be launched");
        }
        return isRegenerationNeeded;
    }

    private static boolean checkWhetherStartOOP(PatchAction pa, String oracleHomePath, Set<String> allJars) {
        if (PatchingFlow.CAS_REPO.equals((Object)OPatchEnv.getPatchingFlow())) {
            return false;
        }
        if (OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS)) {
            return false;
        }
        boolean res = false;
        boolean isOPatchBinary = false;
        String filePath = null;
        boolean isUsedJar = false;
        if (pa instanceof CopyAction) {
            CopyAction ca = (CopyAction)pa;
            isOPatchBinary = ca.isOpatchBinary();
            filePath = ca.getParentFilePath(oracleHomePath);
        } else if (pa instanceof DeleteAction) {
            DeleteAction da = (DeleteAction)pa;
            isOPatchBinary = da.isOPatchBinary();
            filePath = da.getParentFilePath(oracleHomePath);
        } else if (pa instanceof JarActionEntity) {
            JarActionEntity ja = (JarActionEntity)pa;
            isOPatchBinary = ja.isOPatchBinary();
            filePath = ja.getParentFilePath(oracleHomePath);
        }
        isUsedJar = filePath != null && !allJars.isEmpty() ? PrereqAPI.checkWhetherActionfileInJarList(filePath, allJars) : false;
        if (isUsedJar || isOPatchBinary) {
            res = true;
            if (isOPatchBinary) {
                OLogger.printlnOnLog(OLogger.INFO, "Option OPatchBinary was set by " + filePath + " ,OOP should be launched");
            }
        }
        return res;
    }

    private static boolean checkWhetherActionfileInJarList(String filePath, Set<String> allJars) {
        Path file;
        boolean res = false;
        if (filePath != null && !(file = WrapperFactory.getNioServiceWrapper().getPath(filePath, new String[0])).isAbsolute()) {
            filePath = file.toAbsolutePath().toString();
        }
        if (allJars.contains(filePath)) {
            String buff = "Action file " + filePath + " is in the jar list,OOP should be launched";
            OLogger.printlnOnLog(OLogger.WARNING, buff);
            res = true;
        }
        return res;
    }

    /*
     * WARNING - void declaration
     */
    private static Set<String> getAllClasspathsAndDependencies(String oracleHomePath) {
        HashSet<String> allJars = new HashSet<String>();
        if (PatchingFlow.CAS_REPO.equals((Object)OPatchEnv.getPatchingFlow())) {
            return allJars;
        }
        List<Object> classpathList = new ArrayList();
        Set<Object> dependenciesList = new HashSet();
        HashSet<String> classpathFileList = new HashSet<String>();
        HashSet<String> pathSet = new HashSet<String>();
        try {
            classpathList = PrereqAPI.getAllClasspath(oracleHomePath);
            dependenciesList = OPatchOOPHelper.getDependencies(OPatch.class.getClassLoader(), WrapperFactory.getNioServiceWrapper().getPath(oracleHomePath, new String[0]), pathSet);
            for (String string : classpathList) {
                void var7_8;
                Path classFile;
                if (string != null && !(classFile = WrapperFactory.getNioServiceWrapper().getPath(string, new String[0])).isAbsolute()) {
                    String string2 = classFile.toAbsolutePath().toString();
                }
                Set<String> subClasspathFileList = OPatchOOPHelper.getClassFiles((String)var7_8, WrapperFactory.getNioServiceWrapper().getPath(oracleHomePath, new String[0]));
                classpathFileList.addAll(subClasspathFileList);
            }
            Path opatchJrePath = WrapperFactory.getNioServiceWrapper().getPath(oracleHomePath + File.separator + "OPatch" + File.separator + "jre", new String[0]);
            String string = oracleHomePath + File.separator + "jdk" + File.separator + "bin" + File.separator + "java";
            if (!Files.exists(opatchJrePath, new LinkOption[0])) {
                void var7_13;
                if (OPatchEnv.isWindows()) {
                    String string3 = oracleHomePath + File.separator + "jdk" + File.separator + "bin" + File.separator + "java.exe";
                }
                OLogger.printlnOnLog("OPatch/jre does not exist. Adding " + (String)var7_13 + " to oop dependency list");
                allJars.add((String)var7_13);
            }
            if (OPatchEnv.isWindows() && !OPatchEnv.isNextGenHome()) {
                HashSet<String> staticList = new HashSet<String>();
                staticList.addAll(OPatchEnv.getOOPStaticListFromEnvVariable());
                staticList.addAll(StringResource.OOP_STATIC_SET);
                HashSet<String> prependedOHSet = new HashSet<String>();
                for (String fileName : staticList) {
                    prependedOHSet.add(OPatchEnv.getOracleHome() + File.separator + fileName);
                }
                OLogger.printlnOnLog("OOP : Added the following list also to the OOP static list : -> ");
                OLogger.printlnOnLog(((Object)prependedOHSet).toString());
                allJars.addAll(prependedOHSet);
            }
        }
        catch (IOException e2) {
            RuntimeException runtimeException = new RuntimeException(e2.getMessage());
            runtimeException.setStackTrace(e2.getStackTrace());
            throw runtimeException;
        }
        allJars.addAll(classpathFileList);
        allJars.addAll(dependenciesList);
        return allJars;
    }

    private static List<String> getAllClasspath(String oracleHomePath) {
        ArrayList<String> relatedLibFileList = new ArrayList<String>();
        Properties prop = System.getProperties();
        boolean isWindows = OPatchEnv.isWindows();
        if (prop != null) {
            Path libpath;
            String oh = prop.getProperty("OPatch.ORACLE_HOME");
            String fmwComponentHome = prop.getProperty("OPatch.FMW_COMPONENT_HOME");
            String commonComponentsHome = prop.getProperty("OPatch.COMMON_COMPONENTS_HOME");
            String weblogicClasspath = prop.getProperty("OPatch.WEBLOGIC_CLASSPATH");
            String opatchClasspath = prop.getProperty("OPatch.OPATCH_CLASSPATH");
            String oui = null;
            if (oracleHomePath != null) {
                oui = "";
                oh = oracleHomePath;
            } else {
                oui = prop.getProperty("OPatch.OUI_LOCATION");
            }
            String CRSLibLoc = oh + File.separator + (OPatchEnv.isNextGen() ? "modules" : "jlib");
            StringTokenizer st1 = null;
            if (null != weblogicClasspath) {
                st1 = isWindows ? new StringTokenizer(weblogicClasspath, ";") : new StringTokenizer(weblogicClasspath, ":");
            }
            StringTokenizer st2 = null;
            if (null != opatchClasspath) {
                st2 = isWindows ? new StringTokenizer(opatchClasspath, ";") : new StringTokenizer(opatchClasspath, ":");
            }
            ArrayList<String> fmwRelatedLibFileList = new ArrayList<String>();
            while (st1 != null && st1.hasMoreTokens()) {
                String pathString1 = st1.nextToken();
                libpath = WrapperFactory.getNioServiceWrapper().getPath(pathString1, new String[0]);
                if (!Files.exists(libpath, new LinkOption[0])) continue;
                fmwRelatedLibFileList.add(pathString1);
            }
            while (st2 != null && st2.hasMoreTokens()) {
                String pathString2 = st2.nextToken();
                libpath = WrapperFactory.getNioServiceWrapper().getPath(pathString2, new String[0]);
                if (!Files.exists(libpath, new LinkOption[0])) continue;
                fmwRelatedLibFileList.add(pathString2);
            }
            String libFile = null;
            libFile = fmwComponentHome + File.separator + "soa" + File.separator + "modules" + File.separator + "oracle.soa.fabric_11.1.1" + File.separator + "oracle.soa.wlstman.jar";
            if (PrereqAPI.isActiveFile(libFile) && PrereqAPI.isActiveFileUsedByOPatch(libFile)) {
                fmwRelatedLibFileList.add(libFile);
            }
            libFile = null;
            libFile = commonComponentsHome + File.separator + "modules" + File.separator + "oracle.ldap_11.1.1" + File.separator + "ldifloadtool.jar";
            if (PrereqAPI.isActiveFile(libFile) && PrereqAPI.isActiveFileUsedByOPatch(libFile)) {
                fmwRelatedLibFileList.add(libFile);
            }
            libFile = null;
            libFile = oh + File.separator + "biapps" + File.separator + "patch" + File.separator + "biappspatch.jar";
            if (PrereqAPI.isActiveFile(libFile) && PrereqAPI.isActiveFileUsedByOPatch(libFile)) {
                fmwRelatedLibFileList.add(libFile);
            }
            relatedLibFileList.addAll(fmwRelatedLibFileList);
            libFile = null;
            StringBuffer srvm_lib_location = new StringBuffer("");
            if (oui == null || oui.equals("")) {
                srvm_lib_location.append(oh);
                srvm_lib_location.append(File.separator);
                srvm_lib_location.append("oui");
            } else {
                srvm_lib_location.append(oui);
            }
            srvm_lib_location.append(File.separator);
            srvm_lib_location.append(OPatchEnv.isNextGen() ? "modules" : "jlib");
            srvm_lib_location.append(File.separator);
            srvm_lib_location.append("srvm.jar");
            libFile = srvm_lib_location.toString();
            if (PrereqAPI.isActiveFile(libFile) && PrereqAPI.isActiveFileUsedByOPatch(libFile)) {
                relatedLibFileList.add(libFile);
            }
            String srvmasm = CRSLibLoc + File.separator + "srvmasm.jar";
            String srvmhas = CRSLibLoc + File.separator + "srvmhas.jar";
            String netcfg = CRSLibLoc + File.separator + "netcfg.jar";
            if (PrereqAPI.isActiveFile(srvmasm) && PrereqAPI.isActiveFileUsedByOPatch(srvmasm)) {
                relatedLibFileList.add(srvmasm);
            }
            if (PrereqAPI.isActiveFile(srvmhas) && PrereqAPI.isActiveFileUsedByOPatch(srvmhas)) {
                relatedLibFileList.add(srvmhas);
            }
            if (PrereqAPI.isActiveFile(netcfg) && PrereqAPI.isActiveFileUsedByOPatch(netcfg)) {
                relatedLibFileList.add(netcfg);
            }
        }
        return relatedLibFileList;
    }

    private static boolean isActiveFile(String libFile) {
        if (PatchingFlow.CAS_REPO.equals((Object)OPatchEnv.getPatchingFlow())) {
            return false;
        }
        boolean iswin = OPatchEnv.isWindows();
        boolean isactive = false;
        Path filePath = WrapperFactory.getNioServiceWrapper().getPath(libFile, new String[0]);
        if (!Files.exists(filePath, new LinkOption[0]) || Files.isDirectory(filePath, new LinkOption[0])) {
            return false;
        }
        if (iswin) {
            try {
                isactive = OiipwWin32NativeCalls.isFileInUse((String)filePath.toString());
            }
            catch (OiilNativeException e2) {
                RuntimeException re = new RuntimeException(e2.getMessage());
                re.setStackTrace(e2.getStackTrace());
                throw re;
            }
        } else {
            String pid = PrereqAPI.getFilePID(filePath.toString(), false)[0];
            isactive = !pid.equals("");
        }
        return isactive;
    }

    private static boolean isActiveFileUsedByOPatch(String libFile) {
        boolean res;
        block7: {
            boolean iswin = OPatchEnv.isWindows();
            res = false;
            String opatchPath = "";
            if (!iswin) {
                try {
                    opatchPath = OPatchEnv.getOPatchHome();
                    opatchPath = opatchPath + File.separator + (iswin ? "opatch.bat" : "opatch");
                }
                catch (IOException e1) {
                    OLogger.debug("Fail to get the path of opatch script.");
                    return false;
                }
                Object[] opatchPID = PrereqAPI.getFilePID(opatchPath, true);
                Object[] filePID = PrereqAPI.getFilePID(libFile, false);
                try {
                    if (opatchPID.length > 0 && filePID.length > 0 && !opatchPID[0].equals("") && Arrays.asList(opatchPID).contains(filePID[0])) {
                        res = true;
                        break block7;
                    }
                    res = false;
                }
                catch (Exception e2) {
                    res = false;
                    OLogger.printlnOnLog(OLogger.INFO, "fuser command did not work:");
                    OLogger.printlnOnLog(OLogger.INFO, "opatchPID:" + Arrays.toString(opatchPID));
                    OLogger.printlnOnLog(OLogger.INFO, "filePID:" + Arrays.toString(filePID));
                }
            } else {
                res = true;
            }
        }
        return res;
    }

    public static boolean isMAPatch(PatchObject patchObject) {
        String maPath = PatchObject.getMaintenanceAliasFilePath(patchObject.getPatchLocation());
        Path maFile = WrapperFactory.getNioServiceWrapper().getPath(maPath, new String[0]);
        return Files.exists(maFile, new LinkOption[0]);
    }

    private static boolean isPatchArchiveFilePresent(String oracle_home_path) {
        Path psCookedPatchIDPath = WrapperFactory.getNioServiceWrapper().getPath(oracle_home_path, ".patch_storage", ".patch_archive_mapping.xml");
        if (!Files.exists(psCookedPatchIDPath, new LinkOption[0]) || !Files.isReadable(psCookedPatchIDPath)) {
            OLogger.justDebugLog(".patch_archive_mapping.xmlis not present in " + oracle_home_path);
            return false;
        }
        OLogger.justDebugLog(".patch_archive_mapping.xmlis present in " + oracle_home_path);
        return true;
    }

    public static void setRegressedDependents(String oracleHomePath, OneOffEntry[] oneOffs) {
        OneOffEntry[] installedOneOffs = null;
        String regressedOneOffString = "";
        ArrayList<OneOffEntry> regPatchListinPoh = new ArrayList<OneOffEntry>();
        ArrayList<OneOffEntry> regPatchListinPi = new ArrayList<OneOffEntry>();
        try {
            installedOneOffs = PrereqAPI.getInstalledOneOff(oracleHomePath);
        }
        catch (Throwable t) {
            OLogger.debug(new StringBuffer("Converting Throwable to RuntimeException"));
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
        }
        for (int oIter = 0; oIter < oneOffs.length; ++oIter) {
            regressedOneOffString = oneOffs[oIter].getRegressedPatchID();
            if (regressedOneOffString == "" || regressedOneOffString == null) continue;
            boolean foundinOH = false;
            for (int j2 = 0; j2 < installedOneOffs.length; ++j2) {
                if (!regressedOneOffString.equals(installedOneOffs[j2].getID())) continue;
                regPatchListinPoh.add(installedOneOffs[j2]);
                OLogger.printlnOnLog("Found Regressed Patch in ORACLE_HOME: " + installedOneOffs[j2].getID());
            }
            if (foundinOH) continue;
            for (int k2 = 0; k2 < oneOffs.length; ++k2) {
                if (!regressedOneOffString.equals(oneOffs[k2].getID())) continue;
                regPatchListinPi.add(oneOffs[k2]);
                OLogger.printlnOnLog("Found Regressed Patch in incoming patches: " + oneOffs[k2].getID());
            }
        }
        if (regPatchListinPoh.size() > 0) {
            String regListStr = "";
            for (int r = 0; r < regPatchListinPoh.size(); ++r) {
                regListStr = regListStr + " " + ((OneOffEntry)regPatchListinPoh.get(r)).getID();
            }
            OLogger.printlnOnLog("Regressed Patches List in PoH: [" + regListStr + " ]");
            OneOffEntry[] regressedOneOffPatchinPoh = new OneOffEntry[regPatchListinPoh.size()];
            regPatchListinPoh.toArray(regressedOneOffPatchinPoh);
            OPatchEnv.setRegressedPatchinPoh(regressedOneOffPatchinPoh);
        }
        if (regPatchListinPi.size() > 0) {
            String regListStr = "";
            for (int r = 0; r < regPatchListinPi.size(); ++r) {
                regListStr = regListStr + " " + ((OneOffEntry)regPatchListinPi.get(r)).getID();
            }
            OLogger.printlnOnLog("Regressed Patches List in Pi: [" + regListStr + " ]");
            OneOffEntry[] regressedOneOffPatchinPi = new OneOffEntry[regPatchListinPi.size()];
            regPatchListinPi.toArray(regressedOneOffPatchinPi);
            OPatchEnv.setRegressedPatchinPi(regressedOneOffPatchinPi);
        }
    }

    static {
        failedPatches = new ArrayList<String>();
        opatchNoFuser = System.getenv("OPATCH_NO_FUSER");
        crsLibsLoaded = false;
        twoPhase = false;
    }
}

