/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchsdkv2impl;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import oracle.opatch.OPatchACL;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchOverCAS;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OUIReplacer;
import oracle.opatch.PatchObject;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.ProcessFileVersions;
import oracle.opatch.opatchsdk.FailedPrereqException;
import oracle.opatch.opatchsdk.IAnalysisReport;
import oracle.opatch.opatchsdk.OPatchContext;
import oracle.opatch.opatchsdk.OPatchException;
import oracle.opatch.opatchsdk.OPatchNApplyOptions;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatch.opatchsdk.OPatchTarget;
import oracle.opatch.opatchsdkv2.IPatch;
import oracle.opatch.opatchsdkv2.IReadWriteSession;
import oracle.opatch.opatchsdkv2.ce.OperationConfiguration;
import oracle.opatch.opatchsdkv2impl.Patch;
import oracle.opatch.opatchsdkv2impl.ReadSession;
import oracle.opatch.opatchutil.OPatchUtilHelper;
import oracle.opatch.ops.Feature;
import oracle.opatch.ops.OPS;
import oracle.opatch.twophase.TwoPhasePatching;
import oracle.opatch.wrappers.WrapperFactory;

public class ReadWriteSession
extends ReadSession
implements IReadWriteSession {
    private String oracleHomePath = this.opCfg.getOracleHomePath().toString();
    private Path customLogPath = this.opCfg.getCustomLogPath();
    private PatchObject[] applyPatches = null;
    private PatchObject[] rollbackPatches = null;
    private boolean init = false;

    public ReadWriteSession(OperationConfiguration cfg) {
        super(cfg);
    }

    private void initialize() {
        if (this.init) {
            return;
        }
        this.customLogPath = this.customLogPath != null && !this.customLogPath.toString().equals("") ? this.customLogPath.resolve("opatch-cas") : null;
        System.setProperty("OPatch.PATH", OUIReplacer.getEnv("PATH"));
        this.init = true;
    }

    public void nRollbackPhaseOne(List<IPatch> poh) throws OPatchException {
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: nRollbackPhaseOne");
        if (!OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS)) {
            StringBuffer tBuff = new StringBuffer("OPatch cannot run 2-phase patching");
            tBuff.append(" in the environment that is not CAS-enabled. ");
            OLogger.println(tBuff.toString());
            RuntimeException re = new RuntimeException(tBuff.toString());
            throw re;
        }
        String workSheetLoc = this.getWorkSheetPath();
        this.updateHistoryFile("OPatchSDKV2::nRollbackPhaseOne -phBaseFile" + workSheetLoc);
        if (poh == null || poh.isEmpty()) {
            throw new RuntimeException("OPatchSDKV2:: Input IPatch list cannot be null. ");
        }
        try {
            OLogger.printlnOnLogAndVerbose("OPatchSDKV2::nRollbackPhaseOne:: Get worksheetloc for incoming patches from " + workSheetLoc);
            this.initialize();
            TwoPhasePatching tp = new TwoPhasePatching();
            this.rollbackPatches = new PatchObject[poh.size()];
            for (int i2 = 0; i2 < poh.size(); ++i2) {
                this.rollbackPatches[i2] = OPatchUtilHelper.loadAndInitPatchObject(OPatchEnv.getNRollbackSessionName(), this.oracleHomePath, poh.get(i2).getPatchId());
            }
            this.rollbackPatches = OPatchSessionHelper.sortOnOverlay(this.rollbackPatches, false);
            OPatchOverCAS.INSTANCE.initializeCAS(this.oracleHomePath);
            tp.prepare(this.rollbackPatches, this.applyPatches);
            OLogger.justlog(OLogger.INFO, "Finished OPatch/CAS NRollback phase1.");
        }
        catch (Throwable t) {
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
        finally {
            OPatchOverCAS.INSTANCE.cleanupCAS();
        }
        OLogger.justlog(OLogger.INFO, "EXITING METHOD: nRollbackPhaseOne");
    }

    public void nRollbackPhaseTwo() throws OPatchException {
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: nRollbackPhaseTwo");
        if (!OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS)) {
            StringBuffer tBuff = new StringBuffer("OPatch cannot run 2-phase patching");
            tBuff.append(" in the environment that is not CAS-enabled. ");
            OLogger.println(tBuff.toString());
            RuntimeException re = new RuntimeException(tBuff.toString());
            throw re;
        }
        this.updateHistoryFile("OPatchSDKV2::nRollbackPhaseTwo");
        try {
            this.initialize();
            OLogger.printlnOnLogAndVerbose("OPatchSDKV2::nRollbackPhaseTwo");
            TwoPhasePatching tp = new TwoPhasePatching();
            OPatchOverCAS.INSTANCE.initializeCAS(this.oracleHomePath);
            tp.commit();
        }
        catch (Throwable t) {
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
        finally {
            OPatchOverCAS.INSTANCE.cleanupCAS();
        }
        OLogger.justlog(OLogger.INFO, "EXITING METHOD: nRollbackPhaseTwo");
    }

    public void nApplyPhaseOne(List<IPatch> piList) throws OPatchException {
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: nApplyPhaseOne(List<IPatch> piList)");
        if (!OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS)) {
            StringBuffer tBuff = new StringBuffer("OPatch cannot run 2-phase patching");
            tBuff.append(" in the environment that is not CAS-enabled. ");
            OLogger.println(tBuff.toString());
            RuntimeException re = new RuntimeException(tBuff.toString());
            throw re;
        }
        String workSheetLoc = this.getWorkSheetPath();
        this.updateHistoryFile("OPatchSDKV2::nApplyPhaseOne -phBaseFile" + workSheetLoc);
        if (piList == null || piList.isEmpty()) {
            throw new RuntimeException("OPatchSDKV2:: Input IPatch list cannot be null. ");
        }
        try {
            OLogger.printlnOnLogAndVerbose("OPatchSDKV2::nApplyPhaseOne:: Get worksheetloc for incoming patches from " + workSheetLoc);
            this.writeToWorkSheet(piList, workSheetLoc);
            this.initialize();
            this.analyze(piList);
            OPatchEnv.setReport(false);
            TwoPhasePatching tp = new TwoPhasePatching();
            try {
                OLogger.printlnOnLogAndVerbose("OPatchSDKV2::nApplyPhaseOne, start to run TwoPhasePatching.prepare.");
                OPatchOverCAS.INSTANCE.initializeCAS(this.oracleHomePath);
                tp.prepare(this.rollbackPatches, this.applyPatches);
            }
            catch (Throwable e2) {
                OLogger.printlnOnLog("OPatchSDKV2::nApplyPhaseOne fails");
                e2.printStackTrace();
                throw e2;
            }
        }
        catch (Throwable t) {
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
        finally {
            OPatchOverCAS.INSTANCE.cleanupCAS();
        }
        OLogger.justlog(OLogger.INFO, "EXITING METHOD: nApplyPhaseOne(List<IPatch> piList)");
    }

    public void nApplyPhaseTwo() throws OPatchException {
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: nApplyPhaseTwo");
        if (!OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS)) {
            StringBuffer tBuff = new StringBuffer("OPatch cannot run 2-phase patching");
            tBuff.append(" in the environment that is not CAS-enabled. ");
            OLogger.println(tBuff.toString());
            RuntimeException re = new RuntimeException(tBuff.toString());
            throw re;
        }
        this.updateHistoryFile("OPatchSDKV2::nApplyPhaseTwo");
        try {
            this.initialize();
            OLogger.printlnOnLogAndVerbose("OPatchSDKV2::nApplyPhaseOne:: invoke prepareTwoPhasePatching(TwoPhaseOperations.NAPPLY)");
            TwoPhasePatching tp = new TwoPhasePatching();
            OPatchOverCAS.INSTANCE.initializeCAS(this.oracleHomePath);
            tp.commit();
        }
        catch (Throwable t) {
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
        finally {
            if (OPS.INSTANCE.getSupportServices().isSupport(Feature.FA_TWO_PHASE)) {
                OLogger.printlnOnLog("OPatchSDKV2::clean and update cached files after nApplyPhaseTwo completes.");
                ProcessFileVersions proc = new ProcessFileVersions();
                proc.cleanCachedFiles(this.oracleHomePath);
                OPatchEnv.unsetHashMatch();
                OPatchEnv.unsetFATwoPhase();
            }
            OPatchOverCAS.INSTANCE.cleanupCAS();
        }
        OLogger.justlog(OLogger.INFO, "EXITING METHOD: nApplyPhaseTwo");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyze(List<IPatch> pi) {
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: analyze(List<IPatch> pi");
        try {
            OPatchContext context = OPatchContext.getInstance((String)this.opCfg.getOracleHomePath().toString(), (String)this.opCfg.getInvPtr().toString());
            OPatchPatch[] patches = new OPatchPatch[pi.size()];
            OPatchTarget target = new OPatchTarget(context);
            OPatchNApplyOptions options = new OPatchNApplyOptions();
            try {
                int i2;
                for (int i3 = 0; i3 < pi.size(); ++i3) {
                    patches[i3] = ((Patch)pi.get(i3)).getRaw();
                }
                IAnalysisReport report = target.NApplyReport(patches, options);
                List nAPatches = report.getNApplyPatches();
                List nRPatches = report.getNRollbackPatches();
                this.applyPatches = new PatchObject[nAPatches.size()];
                this.rollbackPatches = new PatchObject[nRPatches.size()];
                for (i2 = 0; i2 < nAPatches.size(); ++i2) {
                    this.applyPatches[i2] = OPatchUtilHelper.loadAndInitPatchObject(OPatchEnv.getNApplySessionName(), ((OPatchPatch)nAPatches.get(i2)).getPatchLocation());
                }
                for (i2 = 0; i2 < nRPatches.size(); ++i2) {
                    this.rollbackPatches[i2] = OPatchUtilHelper.loadAndInitPatchObject(OPatchEnv.getNApplySessionName(), this.oracleHomePath, ((OPatchPatch)nRPatches.get(i2)).getPatchId());
                }
                OLogger.printlnOnLog("analyze: there are " + this.applyPatches.length + " apply patches and " + this.rollbackPatches.length + " rollback patches");
            }
            catch (FailedPrereqException e2) {
                e2.printStackTrace();
            }
        }
        catch (OPatchException e3) {
            e3.printStackTrace();
        }
        OLogger.justlog(OLogger.INFO, "EXITING METHOD: analyze(List<IPatch> pi");
    }

    private void updateHistoryFile(String arg) {
        StringBuffer buff = new StringBuffer("Log File    : ");
        try {
            String logfile = OPatchACL.getLogFileNameAndLocation(this, this.oracleHomePath);
            buff.append(logfile);
            buff.append("\n\n");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        OPatchSessionHelper.updateHistoryFile(this.oracleHomePath, new String[]{arg + "\n" + buff.toString()});
    }

    private void writeToWorkSheet(List<IPatch> patchList, String workSheetLoc) throws IOException {
        Path wsObj = WrapperFactory.getNioServiceWrapper().getPath(workSheetLoc, new String[0]);
        BufferedWriter fw = Files.newBufferedWriter(wsObj, new OpenOption[0]);
        PrintWriter pw = new PrintWriter(fw);
        for (IPatch pi : patchList) {
            pw.println(pi.getLocation().toString());
        }
        pw.flush();
        fw.close();
        pw.close();
    }
}

