/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchutil;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import oracle.opatch.OPatchEnv;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchutil.ClassPathAdder;
import oracle.opatch.wrappers.WrapperFactory;

public final class CasClasspathLoader {
    StringBuffer casDLMsg = new StringBuffer("");
    Path opatchJlibPath;

    public void loadCasJars() throws Exception {
        String casJarLoc = "";
        Path opatchJlib = this.getOPatchJlibPath();
        this.casDLMsg.append("\nCasJarLoader:  OPatch jlib Path: " + opatchJlib);
        OLogger.printlnOnLog("CasJarLoader: OPatch jlib Path: " + opatchJlib);
        casJarLoc = this.getCASJar(opatchJlib);
        if (casJarLoc == null || casJarLoc == "") {
            this.casDLMsg.append("\nERROR: cas jars does not exist at casJarLoc:" + casJarLoc + ",opatchJlibPath:" + opatchJlib);
            OLogger.printlnOnLog("\nERROR: cas jars does not exist at casJarLoc:" + casJarLoc + "\n,opatchJlibPath:" + opatchJlib);
            throw new Exception("\nERROR: cas jars does not exist at casJarLoc:" + casJarLoc + ",opatchJlibPath:" + opatchJlib);
        }
        this.loadCASJarToClassPath(casJarLoc);
    }

    private String getCASJar(Path casPathLoc) {
        String casJarLoc = "";
        this.casDLMsg.append("\nCasJarLoader: casJarExists -> Directory to be searched :\n" + casPathLoc.toString());
        OLogger.printlnOnLog("CasJarLoader: casJarExists -> Directory to be searched :\n" + casPathLoc.toString());
        MyFilenameFilter filter = new MyFilenameFilter("content-store-external-");
        String[] flist = casPathLoc.toFile().list(filter);
        if (flist.length != 0) {
            casJarLoc = casPathLoc + File.separator + flist[0];
            this.casDLMsg.append("\nCasJarLoader:casJarLoc:" + casJarLoc);
            OLogger.printlnOnLog("CasJarLoader:casJarLoc:" + casJarLoc);
        } else {
            this.casDLMsg.append("\nCasJarLoader: Could not find cas jar");
            OLogger.printlnOnLog("CasJarLoader: Could not find cas jar");
        }
        return casJarLoc;
    }

    private void loadCASJarToClassPath(String casJarsPathLoc) throws Exception {
        try {
            this.casDLMsg.append("\nCasJarLoader: casJarsPathLoc : " + casJarsPathLoc);
            OLogger.printlnOnLog("nCasJarLoader: casJarsPathLoc : " + casJarsPathLoc);
            ClassPathAdder.add(WrapperFactory.getNioServiceWrapper().getPath(casJarsPathLoc, new String[0]));
        }
        catch (Exception e2) {
            this.casDLMsg.append("\nERROR: Exception while loading CasClassPath :" + casJarsPathLoc);
            OLogger.printlnOnLog("ERROR: Exception while loading CasClassPath :" + casJarsPathLoc);
            throw new Exception("ERROR: Exception while loading CasClassPath :" + casJarsPathLoc, e2);
        }
    }

    private Path getOPatchJlibPath() throws IOException {
        if (this.opatchJlibPath != null && Files.exists(this.opatchJlibPath, new LinkOption[0])) {
            return this.opatchJlibPath;
        }
        this.opatchJlibPath = WrapperFactory.getNioServiceWrapper().getPath(OPatchEnv.getOPatchHome(), "jlib");
        return this.opatchJlibPath;
    }

    public String getDebugMsg() {
        return this.casDLMsg.toString();
    }

    class MyFilenameFilter
    implements FilenameFilter {
        String initials;

        public MyFilenameFilter(String initials) {
            this.initials = initials;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.startsWith(this.initials);
        }
    }
}

