/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchutil;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.glcm.opatch.common.api.Utility;
import oracle.opatch.OPatchEnv;
import oracle.opatch.PatchAction;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchsdk.IAnalysisReport;
import oracle.opatch.opatchsdk.OPatchAnalysisReport;

public class DeltaFileProcessor {
    private Map<String, Set> napplyDeltaFiles = new HashMap<String, Set>();
    private Map<String, Set> nrollbackDeltaFiles = new HashMap<String, Set>();
    private OPatchAnalysisReport report = null;

    public void addNApplyDeltaFiles(String file, PatchAction action) {
        HashSet<String> deltaSet;
        String patchId = "";
        if (action.getPatchObject() != null) {
            patchId = action.getPatchObject().getPatchID();
        }
        if ((deltaSet = this.napplyDeltaFiles.get(patchId)) == null) {
            deltaSet = new HashSet<String>();
        }
        deltaSet.add(this.getDeltaFileToOH(file));
        this.napplyDeltaFiles.put(patchId, deltaSet);
    }

    public void addNRollbackDeltaFiles(String file, PatchAction action) {
        HashSet<String> deltaSet;
        String patchId = "";
        if (action.getPatchObject() != null) {
            patchId = action.getPatchObject().getPatchID();
        }
        if ((deltaSet = this.nrollbackDeltaFiles.get(patchId)) == null) {
            deltaSet = new HashSet<String>();
        }
        deltaSet.add(this.getDeltaFileToOH(file));
        this.nrollbackDeltaFiles.put(patchId, deltaSet);
    }

    public DeltaFileProcessor(IAnalysisReport ireport) {
        if (ireport != null) {
            this.report = (OPatchAnalysisReport)ireport;
            this.report.setNApplyDeltaFiles(this.napplyDeltaFiles);
            this.report.setNRollbackDeltaFiles(this.nrollbackDeltaFiles);
        }
    }

    public boolean compareHash(Path srcFile, Path dstFile, PatchAction action) {
        boolean sameHash = false;
        if (Files.exists(dstFile, new LinkOption[0]) && Files.isRegularFile(dstFile, new LinkOption[0])) {
            String destHash = "";
            String srcHash = "";
            if (action != null) {
                srcHash = action.getHashValue();
            }
            if ((srcHash == null || srcHash.equals("")) && Files.exists(srcFile, new LinkOption[0]) && Files.isRegularFile(srcFile, new LinkOption[0])) {
                try {
                    srcHash = Utility.getSha256sum((File)srcFile.toFile());
                }
                catch (IOException e2) {
                    OLogger.log(OLogger.WARNING, "Can't get hash of file " + srcFile.toAbsolutePath().toString());
                }
            }
            try {
                destHash = srcHash.length() >= 64 ? Utility.getSha256sum((File)dstFile.toFile()) : Utility.getSha1sum((File)dstFile.toFile());
            }
            catch (IOException e3) {
                OLogger.log(OLogger.WARNING, "Can't get hash of file " + dstFile.toAbsolutePath().toString());
            }
            if (srcHash.equalsIgnoreCase(destHash)) {
                sameHash = true;
            }
        }
        return sameHash;
    }

    private String getDeltaFileToOH(String pathToCas) {
        String pathToOH = pathToCas;
        if (OPatchEnv.isCASPhase1()) {
            pathToOH = pathToCas.replace(".cas" + File.separator + "CLI" + File.separator, ".cas" + File.separator).replace(".cas" + File.separator + "SDK" + File.separator, ".cas" + File.separator).replace(".cas" + File.separator, "");
        }
        return pathToOH;
    }
}

