/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchutil;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.zip.ZipFile;
import oracle.opatch.CompositePatchObject;
import oracle.opatch.Crs;
import oracle.opatch.ExitOPatchException;
import oracle.opatch.FMWHandler;
import oracle.opatch.MergedPatchObject;
import oracle.opatch.OPatchACL;
import oracle.opatch.OPatchEncrypt;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchException;
import oracle.opatch.OPatchExternalFactory;
import oracle.opatch.OPatchFmwEnv;
import oracle.opatch.OPatchSession;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OPatchVersionSpecific;
import oracle.opatch.OneOffEntry;
import oracle.opatch.OnlinePatchException;
import oracle.opatch.OnlinePatchProcessor;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchObject;
import oracle.opatch.PatchObjectUtil;
import oracle.opatch.PostScriptAction;
import oracle.opatch.SCM;
import oracle.opatch.StringResource;
import oracle.opatch.SystemCall;
import oracle.opatch.ZOPErrorMessage;
import oracle.opatch.ZipUtilities;
import oracle.opatch.conflicttextualinterpreter.OracleHomeConflictMap;
import oracle.opatch.conflicttextualinterpreter.cbcc.FileMapping;
import oracle.opatch.ipm.IIPMRWServices;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.ipm.IPM;
import oracle.opatch.ipm.IPMUtil;
import oracle.opatch.opatchactions.hotpatchAction;
import oracle.opatch.opatchext.SecurePrompter;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.PQSession;
import oracle.opatch.opatchprereq.PrereqAPI;
import oracle.opatch.opatchprereq.PrereqResult;
import oracle.opatch.opatchsdk.ContentTypeHelper;
import oracle.opatch.opatchsdk.ContentTypeHelperFactory;
import oracle.opatch.opatchsdk.FailedPrereqException;
import oracle.opatch.opatchsdk.IAnalysisReport;
import oracle.opatch.opatchsdk.OPatchAnalysisReport;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatch.opatchsdk.OPatchPatchPrereq;
import oracle.opatch.opatchsdk.OPatchTarget;
import oracle.opatch.opatchsdk.RHPHelper;
import oracle.opatch.opatchsdk.RHPHelperFactory;
import oracle.opatch.opatchsdk.RUHelper;
import oracle.opatch.opatchsdk.RUHelperFactory;
import oracle.opatch.opatchutil.ApplyRollbackSql;
import oracle.opatch.opatchutil.CacheProcessor;
import oracle.opatch.opatchutil.CopyToNodes;
import oracle.opatch.opatchutil.DeltaFileProcessor;
import oracle.opatch.opatchutil.IsShared;
import oracle.opatch.opatchutil.LsSession;
import oracle.opatch.opatchutil.MakeSession;
import oracle.opatch.opatchutil.NApply;
import oracle.opatch.opatchutil.NRollback;
import oracle.opatch.opatchutil.OPatchFmwPointer;
import oracle.opatch.opatchutil.OPatchUtilHelper;
import oracle.opatch.opatchutil.RemoveOnNodes;
import oracle.opatch.opatchutil.SrvmUtil;
import oracle.opatch.opatchutil.UpdateRemoteNodes;
import oracle.opatch.opatchutil.UpdateVersion;
import oracle.opatch.opatchutil.UtilEnv;
import oracle.opatch.opatchutil.VerifyPatch;
import oracle.opatch.opatchutil.XmlValidator;
import oracle.opatch.opatchutil.archive.ListArchives;
import oracle.opatch.opatchutil.archive.PatchArchiver;
import oracle.opatch.opatchutil.checkComponents;
import oracle.opatch.opatchutil.checkPhaseOneStatus;
import oracle.opatch.opatchutil.cleanuphome.InactivePatchesUtil;
import oracle.opatch.opatchutil.obfuscation.ObfuscationUtil;
import oracle.opatch.util.perfmonitor.MethodTracker;
import oracle.opatch.util.perfmonitor.MethodTrackerObj;
import oracle.opatch.util.perfmonitor.TrackerTags;
import oracle.opatch.wrappers.WrapperFactory;

public class OUSession {
    private static String patchBaseDir;
    private static String patchBaseFile;
    private static boolean baseDir;
    private static boolean phBaseFile;
    private static String PATCH_STORAGE_DIR;
    private static OPatchAnalysisReport report;
    private static DeltaFileProcessor deltaProcessor;
    private static HashMap<OPatchPatchPrereq, OPatchTarget.StatusCheck> applyPrereqResults;
    private static boolean needThrowThrowableOnFirstFail;
    private static boolean phaseOneReport;
    private static Map<String, Set<String>> fileToPatchRefCount;
    private List<String> listOfInvalidPatches = new ArrayList<String>();
    static String[] cachePatchLocs;

    private OUSession() {
    }

    public static void resetPHBaseDir() {
        patchBaseDir = "";
        baseDir = false;
        cachePatchLocs = null;
    }

    public static boolean isPatchBaseDirProvided() {
        return baseDir;
    }

    public static void setPatchBaseDirProvided() {
        baseDir = true;
    }

    public static String getPatchBaseDir() {
        return patchBaseDir;
    }

    protected static void setPatchBaseDir(String patchLocation) {
        patchBaseDir = patchLocation;
    }

    public static boolean isPatchBaseFileProvided() {
        return phBaseFile;
    }

    protected static String getPatchBaseFile() {
        return patchBaseFile;
    }

    public static void setPatchBaseFile(String baseFile) {
        patchBaseFile = baseFile;
    }

    public static String getPatchLocation() {
        String patchLoc = null;
        if (OPatchEnv.getPatchloc() != "") {
            patchLoc = OPatchEnv.getPatchloc();
        } else if (OUSession.isPatchBaseDirProvided()) {
            patchLoc = OUSession.getPatchBaseDir();
        } else if (OUSession.isPatchBaseFileProvided()) {
            patchLoc = OUSession.getPatchBaseFile();
        }
        return patchLoc;
    }

    public static void getautorollback(String oracleHomePath) {
        StringBuffer dBuff = null;
        OneOffEntry[] patchesToApply = new OneOffEntry[]{};
        try {
            dBuff = new StringBuffer("N-Apply: get a list of patches.");
            OLogger.debug(dBuff);
            patchesToApply = OPatchUtilHelper.getPatchesToApply(oracleHomePath, "util");
        }
        catch (Exception e2) {
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        PrereqResult resObj = PrereqAPI.checkAutoRollbackPatches(oracleHomePath, patchesToApply);
        if (resObj.getResult() != PrereqResult.ExecuteStatus.PASSED) {
            OLogger.println(resObj.toString());
        } else {
            OLogger.println("There are no patches that need to be auto-rollback");
        }
    }

    protected static boolean isValidPatchLoc(String loc) {
        if (OPatchSessionHelper.checkIsEsysPatch(loc)) {
            return true;
        }
        boolean hasEtc = false;
        boolean hasFile = false;
        Path f2 = WrapperFactory.getNioServiceWrapper().getPath(loc, new String[0]);
        if (f2 != null && Files.exists(f2, new LinkOption[0]) && !Files.isDirectory(f2, new LinkOption[0])) {
            return false;
        }
        try (DirectoryStream<Path> entries = Files.newDirectoryStream(f2);){
            for (Path stream : entries) {
                String entry = stream.getFileName().toString();
                if (entry.indexOf("etc") != -1) {
                    hasEtc = true;
                    continue;
                }
                if (entry.indexOf("files") == -1) continue;
                hasFile = true;
            }
        }
        catch (IOException e2) {
            OLogger.debug(e2.getMessage());
        }
        return hasEtc && hasFile;
    }

    public static String[] parsePatchLocs(Object caller) throws IllegalAccessException, FileNotFoundException, IOException, RuntimeException {
        if (caller instanceof OPatchPatch) {
            return OUSession.parseBaseDirListFile();
        }
        throw new IllegalAccessException("Permission denied. Access is available only for OPatchPatch");
    }

    protected static String[] parseBaseDirListFile() throws FileNotFoundException, IOException, RuntimeException {
        String[] patchLocs;
        block86: {
            StringBuffer tBuff;
            patchLocs = null;
            ArrayList<String> tmpPatchLocs = new ArrayList<String>();
            boolean isBaseDirZipFile = false;
            if (cachePatchLocs != null) {
                return cachePatchLocs;
            }
            if (OUSession.isPatchBaseDirProvided()) {
                Object fullPath;
                Object phBaseDir = OUSession.getPatchBaseDir();
                Path patchDir = WrapperFactory.getNioServiceWrapper().getPath((String)phBaseDir, new String[0]);
                if (!Files.isDirectory(patchDir, new LinkOption[0])) {
                    if (((String)phBaseDir).endsWith(".zip") || ((String)phBaseDir).endsWith(".ZIP")) {
                        String extractLoc = OPatchEnv.getPatchUnzipLocation();
                        isBaseDirZipFile = true;
                        String topLevelDir = ZipUtilities.unzip((String)phBaseDir, extractLoc);
                        fullPath = extractLoc + File.separator + topLevelDir;
                        patchDir = WrapperFactory.getNioServiceWrapper().getPath((String)fullPath, new String[0]);
                        if (!Files.exists(patchDir, new LinkOption[0]) || !Files.isDirectory(patchDir, new LinkOption[0])) {
                            RuntimeException re = new RuntimeException("Could not extract the given zip file");
                            throw re;
                        }
                        patchBaseDir = fullPath;
                        phBaseDir = fullPath;
                    } else {
                        OLogger.println("The patch base location should be a directory or a zip file.");
                        RuntimeException re = new RuntimeException("Invalid patch zip file.");
                        throw re;
                    }
                }
                ArrayList<String> al = new ArrayList<String>();
                if (OUSession.isValidPatchLoc((String)phBaseDir)) {
                    al.add((String)phBaseDir);
                } else {
                    try {
                        DirectoryStream<Path> streams = Files.newDirectoryStream(patchDir);
                        fullPath = null;
                        try {
                            ArrayList entriesList = new ArrayList();
                            for (Path stream : streams) {
                                String entry = stream.toString();
                                tmpPatchLocs.add(entry);
                            }
                        }
                        catch (Throwable entriesList) {
                            fullPath = entriesList;
                            throw entriesList;
                        }
                        finally {
                            if (streams != null) {
                                if (fullPath != null) {
                                    try {
                                        streams.close();
                                    }
                                    catch (Throwable entriesList) {
                                        ((Throwable)fullPath).addSuppressed(entriesList);
                                    }
                                } else {
                                    streams.close();
                                }
                            }
                        }
                    }
                    catch (IOException e2) {
                        OLogger.debug(e2.getMessage());
                    }
                    Collections.sort(tmpPatchLocs);
                }
                for (String pLoc : tmpPatchLocs) {
                    Path pFile = WrapperFactory.getNioServiceWrapper().getPath(pLoc, new String[0]);
                    if (!Files.isDirectory(pFile, new LinkOption[0]) && (pLoc.endsWith(".zip") || pLoc.endsWith(".ZIP"))) {
                        String fullPath2;
                        String topLevelDir;
                        if (isBaseDirZipFile) {
                            topLevelDir = ZipUtilities.unzip(pLoc, (String)phBaseDir);
                            fullPath2 = (String)phBaseDir + File.separator + topLevelDir;
                        } else {
                            String extPath = OPatchEnv.getPatchUnzipLocation();
                            topLevelDir = ZipUtilities.unzip(pLoc, extPath);
                            fullPath2 = extPath + File.separator + topLevelDir;
                        }
                        pFile = WrapperFactory.getNioServiceWrapper().getPath(fullPath2, new String[0]);
                        if (!Files.exists(pFile, new LinkOption[0]) || !Files.isDirectory(pFile, new LinkOption[0])) {
                            StringBuffer tBuff2 = new StringBuffer("The location \"");
                            tBuff2.append(pLoc);
                            tBuff2.append("\" is not a valid patch zip file. Its extraction ");
                            tBuff2.append("did not create a directory.");
                            OLogger.println(tBuff2.toString());
                            RuntimeException re = new RuntimeException(tBuff2.toString());
                            throw re;
                        }
                        al.add(fullPath2);
                        continue;
                    }
                    if (Files.isDirectory(pFile, new LinkOption[0])) {
                        al.add(pLoc);
                        continue;
                    }
                    if (Files.isRegularFile(pFile, new LinkOption[0])) {
                        tBuff = new StringBuffer("Ignoring file \"");
                        tBuff.append(pLoc);
                        tBuff.append("\" in the patch directory. ");
                        OLogger.printlnOnLog(tBuff.toString());
                        continue;
                    }
                    tBuff = new StringBuffer("The location \"");
                    tBuff.append(pLoc);
                    tBuff.append("\" is not a directory or a valid patch zip file. ");
                    OLogger.println(tBuff.toString());
                    RuntimeException re = new RuntimeException("Invalid patch location.");
                    throw re;
                }
                patchLocs = new String[al.size()];
                al.toArray(patchLocs);
            } else {
                ZipFile zipFile = null;
                try {
                    zipFile = new ZipFile(OUSession.getPatchBaseFile());
                    if (null != zipFile) {
                        StringBuffer tBuff3 = new StringBuffer("The location \"");
                        tBuff3.append(OUSession.getPatchBaseFile());
                        tBuff3.append("\" is not a valid patch base file. ");
                        OLogger.println(tBuff3.toString());
                        RuntimeException re = new RuntimeException("Invalid patch base location.");
                        throw re;
                    }
                }
                catch (IOException tBuff3) {
                    // empty catch block
                }
                try (BufferedReader br = null;){
                    Path patchFile = WrapperFactory.getNioServiceWrapper().getPath(OUSession.getPatchBaseFile(), new String[0]);
                    br = Files.newBufferedReader(patchFile, Charset.forName("UTF-8"));
                    ArrayList<String> al = new ArrayList<String>();
                    String line = br.readLine();
                    while (line != null) {
                        if (!al.contains(line) && !line.equals("")) {
                            Object re;
                            Path pDir = WrapperFactory.getNioServiceWrapper().getPath(line, new String[0]);
                            if (!Files.isDirectory(pDir, new LinkOption[0])) {
                                if (line.endsWith(".zip") || line.endsWith(".ZIP")) {
                                    String extractLoc = OPatchEnv.getPatchUnzipLocation();
                                    String topLevelDir = ZipUtilities.unzip(line, extractLoc);
                                    String fullPath = extractLoc + File.separator + topLevelDir;
                                    pDir = WrapperFactory.getNioServiceWrapper().getPath(fullPath, new String[0]);
                                    if (!Files.exists(pDir, new LinkOption[0]) || !Files.isDirectory(pDir, new LinkOption[0])) {
                                        StringBuffer tBuff4 = new StringBuffer("The location \"");
                                        tBuff4.append(line);
                                        tBuff4.append("\" is not a valid patch zip file. Its extraction ");
                                        tBuff4.append("did not create a directory.");
                                        OLogger.println(tBuff4.toString());
                                        re = new RuntimeException(tBuff4.toString());
                                        throw re;
                                    }
                                    line = fullPath;
                                } else {
                                    tBuff = new StringBuffer("The location \"");
                                    tBuff.append(line);
                                    tBuff.append("\" is not a directory or a valid patch zip file. ");
                                    OLogger.println(tBuff.toString());
                                    RuntimeException re2 = new RuntimeException("Invalid patch location.");
                                    throw re2;
                                }
                            }
                            ArrayList<Path> files = new ArrayList<Path>();
                            boolean hasEtc = false;
                            boolean hasFile = false;
                            try {
                                DirectoryStream<Path> subDirs = Files.newDirectoryStream(pDir);
                                re = null;
                                try {
                                    for (Path subDir : subDirs) {
                                        files.add(subDir);
                                        String entry = subDir.getFileName().toString();
                                        if (entry.indexOf("etc") != -1) {
                                            hasEtc = true;
                                            continue;
                                        }
                                        if (entry.indexOf("files") == -1) continue;
                                        hasFile = true;
                                    }
                                }
                                catch (Throwable throwable) {
                                    re = throwable;
                                    throw throwable;
                                }
                                finally {
                                    if (subDirs != null) {
                                        if (re != null) {
                                            try {
                                                subDirs.close();
                                            }
                                            catch (Throwable throwable) {
                                                ((Throwable)re).addSuppressed(throwable);
                                            }
                                        } else {
                                            subDirs.close();
                                        }
                                    }
                                }
                            }
                            catch (IOException e3) {
                                OLogger.debug(e3.getMessage());
                            }
                            if (hasEtc && hasFile || PQSession.isComposite(pDir.toString())) {
                                al.add(line);
                            } else if (OPatchSessionHelper.checkIsEsysPatch(line)) {
                                al.add(line);
                            } else {
                                String absolutePath = pDir.toAbsolutePath().toString();
                                for (Path subDir : files) {
                                    if (!Files.isDirectory(subDir, new LinkOption[0])) continue;
                                    al.add(subDir.toString());
                                }
                            }
                        }
                        line = br.readLine();
                    }
                    patchLocs = new String[al.size()];
                    al.toArray(patchLocs);
                }
            }
            if (!OPatchEnv.getisAuto()) {
                try {
                    String[] selectedList = OPatchEnv.getUserSuppliedPatchIDs();
                    boolean sListOK = false;
                    boolean isPatchIDListOk = true;
                    StringBuffer consolidateErrorMsg = new StringBuffer("");
                    if (selectedList == null || selectedList.length == 0) break block86;
                    ArrayList<String> sList = new ArrayList<String>();
                    int count = 0;
                    for (int i2 = 0; i2 < selectedList.length; ++i2) {
                        sListOK = false;
                        StringBuffer fBuff = new StringBuffer("Process only patch IDs ");
                        fBuff.append("given by -id option.");
                        String sid = selectedList[i2];
                        OLogger.printlnOnLog(fBuff.toString());
                        for (int j2 = 0; j2 < patchLocs.length; ++j2) {
                            String loc = patchLocs[j2];
                            PatchObject po = null;
                            try {
                                po = PatchObject.getInstance(loc);
                            }
                            catch (Exception e4) {
                                OLogger.printStackTrace(e4);
                                po = null;
                            }
                            if (po != null && sid.equals(po.getPatchID())) {
                                sList.add(count, loc);
                                ++count;
                                sListOK = true;
                                continue;
                            }
                            if (po == null || !po.getPatchInventory().mayBeTranslation()) continue;
                            String id = po.getOriginalPatchID();
                            String lang = po.getPatchInventory().getPatchLanguage();
                            String langId = id + "_" + lang;
                            if (!po.getPatchID().startsWith(langId)) continue;
                            sList.add(count, loc);
                            ++count;
                            sListOK = true;
                        }
                        if (sListOK) continue;
                        isPatchIDListOk = false;
                        consolidateErrorMsg.append("\nPatch ");
                        consolidateErrorMsg.append("\"" + sid + "\"").append(" is invalid (or) doesn't exist among the given individual patches.");
                    }
                    if (!isPatchIDListOk) {
                        consolidateErrorMsg.append("\nPlease specify a list of patch IDs ");
                        consolidateErrorMsg.append("separated by commas without spaces.");
                        OLogger.printlnOnLog(consolidateErrorMsg.toString());
                        throw new FileNotFoundException(consolidateErrorMsg.toString());
                    }
                    patchLocs = new String[sList.size()];
                    OLogger.printlnOnLogAndVerbose("The selected list of patches to apply by 'id' option are: " + sList.toString());
                    sList.toArray(patchLocs);
                }
                catch (FileNotFoundException e5) {
                    throw e5;
                }
                catch (IOException e6) {
                    throw e6;
                }
            }
        }
        OnlinePatchProcessor.handleOnlinePatch(patchLocs);
        cachePatchLocs = patchLocs;
        return patchLocs;
    }

    public static boolean checkMethod(String methodName) {
        boolean foundFlag = false;
        try {
            Class<?> chkClass = Class.forName(OUSession.class.getName());
            Method[] methods = chkClass.getMethods();
            for (int i2 = 0; i2 < methods.length; ++i2) {
                if (methods[i2].getName().equalsIgnoreCase(methodName)) {
                    foundFlag = true;
                }
                if (!foundFlag) continue;
                for (int di = 0; di < OPatchVersionSpecific.DISABLED_UTILS.length; ++di) {
                    if (!methodName.equalsIgnoreCase(OPatchVersionSpecific.DISABLED_UTILS[di])) continue;
                    return false;
                }
                break;
            }
        }
        catch (Exception e2) {
            return false;
        }
        return foundFlag;
    }

    public static boolean isReadOnly(String methodName) {
        for (int i2 = 0; i2 < StringResource.READ_ONLY_UTILS.length; ++i2) {
            if (!methodName.equalsIgnoreCase(StringResource.READ_ONLY_UTILS[i2])) continue;
            return true;
        }
        return false;
    }

    public static void defaultOption(String oracleHomePath) {
        StringBuffer buff = new StringBuffer("Unknown option on Oracle Home \"");
        buff.append(oracleHomePath);
        buff.append("\"");
        throw new RuntimeException(buff.toString());
    }

    public static void defaultArgument(String arg) {
        OLogger.log(OLogger.FINE, "OUSession::defaultArgument(), arg = " + arg);
    }

    public static void installocm(String oracleHomePath) throws RuntimeException {
        IIPMRWServices rwServices = IPM.INSTANCE.getRWServices();
        boolean alreadyLocked = rwServices.isLocked();
        try {
            String curWorkDir;
            if (!alreadyLocked) {
                rwServices.lock(oracleHomePath);
            }
            if (!SCM.isPlatformSpecific(curWorkDir = System.getProperty("OPatch.RUNNING_DIR"), oracleHomePath)) {
                OLogger.println("\nOPatch is not bundled with OCM install bits.");
            }
            OPatchSessionHelper.validateOCMOption(oracleHomePath, rwServices);
            OPatchSessionHelper.processOCM(rwServices, oracleHomePath);
        }
        catch (Exception e2) {
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        catch (Throwable t) {
            RuntimeException re = new RuntimeException(t.getMessage());
            throw re;
        }
        finally {
            if (!alreadyLocked) {
                rwServices.release();
            }
        }
        OLogger.println("\nPlease refer log file for details of this util operation.");
    }

    public static void loadxml(String oracleHomePath) throws RuntimeException {
        XmlValidator.validateXMLFile(oracleHomePath);
        OLogger.println("UtilSession: XML file is OK.");
    }

    public static void checkminimumopatchversion(String oracleHomePath) {
        PatchObject po = null;
        String userInputVersion = "";
        boolean isComposite = false;
        PatchObject[] pos = null;
        try {
            String patchLocation = OPatchEnv.getPatchloc();
            userInputVersion = OPatchEnv.getUserInputVersion();
            String compositeXmlLoc = CompositePatchObject.validateComposite(patchLocation);
            Path compositeXml = WrapperFactory.getNioServiceWrapper().getPath(compositeXmlLoc, new String[0]);
            if (Files.exists(compositeXml, new LinkOption[0])) {
                isComposite = true;
                OUSession.setPatchBaseDirProvided();
                OUSession.setPatchBaseDir(patchLocation);
                String[] patchLocs = OUSession.parseBaseDirListFile();
                pos = new PatchObject[patchLocs.length];
                for (int j2 = 0; j2 < pos.length; ++j2) {
                    pos[j2] = PatchObject.getInstance(patchLocs[j2]);
                    if (userInputVersion == null || userInputVersion.equals("")) {
                        throw new RuntimeException("The input version is empty. Please give proper input version.");
                    }
                    if (pos[j2] != null) continue;
                    throw new RuntimeException("OPatch was not able to create a PatchObject from the input location. Please check if it is a valid patch using 'opatch query'");
                }
            } else {
                po = PatchObject.getInstance(patchLocation);
                if (userInputVersion == null || userInputVersion.equals("")) {
                    throw new RuntimeException("The input version is empty. Please give proper input version.");
                }
                if (po == null) {
                    throw new RuntimeException("OPatch was not able to create a PatchObject from the input location. Please check if it is a valid patch using 'opatch query'");
                }
            }
        }
        catch (Throwable t) {
            RuntimeException re = new RuntimeException(t.getMessage());
            ZOPErrorMessage.printErrorMessage(49);
            OLogger.println(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
        try {
            PrereqResult resObj = null;
            resObj = isComposite ? PrereqAPI.checkOPatchMinVersionRequirement(oracleHomePath, pos, userInputVersion) : PrereqAPI.checkOPatchMinVersionRequirement(oracleHomePath, new PatchObject[]{po}, userInputVersion);
            if (resObj.getResult() == PrereqResult.ExecuteStatus.PASSED) {
                OLogger.println("Is patch compatible with the given user input version? : true");
            } else if (resObj.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                OLogger.println("Is patch compatible with the given user input version? : false");
            } else {
                ZOPErrorMessage.printErrorMessage(49);
            }
        }
        catch (Throwable t) {
            RuntimeException re = new RuntimeException(t.getMessage());
            ZOPErrorMessage.printErrorMessage(49);
            OLogger.println(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
        OLogger.println("UtilSession: checkMinimumOPatchVersion done.");
    }

    public static void lsinvrac(String oracleHomePath) {
        LsSession.lsinvrac(oracleHomePath);
        OLogger.println("UtilSession: lsInvRac done.");
    }

    public static void encryptvalue(String oracleHomePath) {
        if (OPatchEnv.isSilent()) {
            OLogger.println("This operation cannot be invoked in 'silent' mode.");
        } else {
            char[] input = SecurePrompter.readResponse("Please enter the value to be encrypted");
            String sinput = new String(input);
            String soutput = OPatchEncrypt.performOperation(OPatchEncrypt.ENCRYPT, sinput, oracleHomePath);
            OLogger.println("Encrypted value is :" + soutput);
        }
    }

    public static void updateopatchversion(String oracleHomePath) {
        UpdateVersion.upgradeCompVersion(oracleHomePath);
    }

    public static void applysql(String oracleHomePath) throws RuntimeException, Exception {
        try {
            OUSession.checkComposite();
            ApplyRollbackSql.applySql(oracleHomePath);
            OLogger.println("UtilSession: applySql done.");
        }
        catch (RuntimeException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw e3;
        }
    }

    public static void rollbacksql(String oracleHomePath) throws RuntimeException, Exception {
        try {
            OUSession.checkComposite();
            ApplyRollbackSql.rollbackSql(oracleHomePath);
            OLogger.println("UtilSession: rollbackSql done.");
        }
        catch (RuntimeException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw e3;
        }
    }

    public static void lsfiles(String oracleHomePath) {
        LsSession.lsfiles(oracleHomePath);
        OLogger.println("UtilSession: lsFiles done.");
    }

    public static void lsinvfiles(String oracleHomePath) {
        LsSession.lsinvfiles(oracleHomePath);
        OLogger.println("UtilSession: lsInvFiles done.");
    }

    public static void napply(String oracleHomePath) throws Throwable {
        NApply.process(oracleHomePath);
        OLogger.printlnOnLog("UtilSession: N-Apply done.");
    }

    public static void nrollback(String oracleHomePath) {
        try {
            NRollback.process(oracleHomePath);
            OLogger.printlnOnLog("UtilSession: N-Rollback done.");
        }
        catch (ExitOPatchException e2) {
            throw e2;
        }
        catch (RuntimeException e3) {
            throw e3;
        }
    }

    public static void runlocalmake(String oracleHomePath) {
        MakeSession.runLocalMake(oracleHomePath);
        OLogger.println("UtilSession: runLocalMake done.");
    }

    public static void runpostscript(String oracleHomePath) {
        try {
            String patchLoc = OPatchEnv.getPatchloc();
            if (patchLoc == null || patchLoc.equals("")) {
                throw new RuntimeException("Please use '-ph' option to point to the patch location.");
            }
            String postScriptLoc = PatchObject.getPostScriptFilePath(patchLoc);
            PostScriptAction postScript = new PostScriptAction(postScriptLoc);
            Path postScriptFile = WrapperFactory.getNioServiceWrapper().getPath(postScriptLoc, new String[0]);
            if (!Files.exists(postScriptFile, new LinkOption[0])) {
                OLogger.printlnOnLog(OLogger.INFO, "OUI-67333");
                return;
            }
            OLogger.println("Executing post script \"" + postScriptLoc + "\"...");
            PatchObject po = PatchObjectUtil.loadPatch(patchLoc);
            String patchID = po.getPatchID();
            String arg = OPatchSessionHelper.getPostScriptActionArgumentForDeploy(patchID);
            StringBuffer dBuff = new StringBuffer(" Invoke post-script of patch ");
            dBuff.append(patchID).append(" with argument \"");
            dBuff.append(arg).append("\" and ").append("deploy");
            OLogger.debug(dBuff);
            int postReturnVal = postScript.process(arg, "deploy", patchID);
            if (postReturnVal != 0) {
                String postMsg = OLogger.getString("OUI-67133", new Object[]{"POST", Integer.toString(postReturnVal)});
                OLogger.error("OUI-67133", new Object[]{"POST", Integer.toString(postReturnVal)});
                throw new RuntimeException(postMsg);
            }
        }
        catch (Exception e2) {
            OLogger.println("UtilSession failed to run post script on ORACLE_HOME. ");
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
    }

    public static void runremotemake(String oracleHomePath) {
        MakeSession.runRemoteMake(oracleHomePath);
        OLogger.println("UtilSession: runRemoteMake done.");
    }

    public static void runanycommand(String oracleHomePath) {
        MakeSession.runAnyCommand(oracleHomePath);
        OLogger.println("UtilSession: runAnyCommand done.");
    }

    public static void copylistedfilestest(String oracleHomePath) throws RuntimeException {
        try {
            CopyToNodes.copyListedFilesTest(oracleHomePath);
            OLogger.println("UtilSession: Files copied to remote nodes.");
        }
        catch (RuntimeException e2) {
            OLogger.println("UtilSession failed to copy files to remote nodes. ");
            throw e2;
        }
    }

    public static void copylistedfiles(String oracleHomePath) throws RuntimeException {
        try {
            CopyToNodes.copyListedFiles(oracleHomePath);
            OLogger.println("UtilSession: Files copied to remote nodes.");
        }
        catch (RuntimeException e2) {
            OLogger.println("UtilSession failed to copy files to remote nodes. ");
            throw e2;
        }
    }

    public static void copylisteddirstest(String oracleHomePath) throws RuntimeException {
        try {
            CopyToNodes.copyListedDirsTest(oracleHomePath);
            OLogger.println("UtilSession: Directories copied to remote nodes.");
        }
        catch (RuntimeException e2) {
            OLogger.println("UtilSession failed to copy dirs to remote nodes. ");
            throw e2;
        }
    }

    public static void getpatchlevel(String oracleHomePath) throws RuntimeException {
        StringBuilder buff = new StringBuilder("");
        if (!IPMUtil.isGridHome(oracleHomePath)) {
            buff.append("UtilSession failed to get patch level information because current Oracle Home \"" + oracleHomePath + "\" is not Grid Home.");
            OLogger.println(buff.toString());
            return;
        }
        try {
            OPatchSessionHelper.loadCRSRelatedLibFiles(oracleHomePath);
            Crs crs = OPatchExternalFactory.getCrs(oracleHomePath).getInstance(oracleHomePath);
            if (crs.getCrsType().equals((Object)Crs.CrsType.CRS)) {
                String localNode = crs.getLocalNode();
                String localPatchLevel = "";
                if (crs.isStackRunning()) {
                    HashMap<String, String> patchingLevels = crs.getPatchingLevel(oracleHomePath);
                    localPatchLevel = patchingLevels.get(localNode);
                } else {
                    StringBuilder getLevelCmd = new StringBuilder(crs.getGridHome());
                    getLevelCmd.append(File.separator).append("bin");
                    getLevelCmd.append(File.separator).append("crsctl");
                    getLevelCmd.append(" query crs softwarepatch");
                    SystemCall.ExecReturn rt = SystemCall.runtimeExec(getLevelCmd.toString());
                    if (rt.isOK()) {
                        String msg = rt.getNormalMessage();
                        OLogger.debug("Output of geting crs patching level: " + msg);
                        int iindex = msg.indexOf("[");
                        int eindex = msg.indexOf("]");
                        localPatchLevel = msg.substring(iindex + 1, eindex);
                    } else {
                        buff.append("UtilSession failed to get patch level information.");
                        OLogger.printlnOnLog(buff.toString());
                        RuntimeException re = new RuntimeException(buff.toString());
                        throw re;
                    }
                }
                buff.append("\tLocal Node: " + localNode);
                buff.append("\tPatching Level: " + localPatchLevel);
                buff.append("\n");
            } else if (crs.getCrsType().equals((Object)Crs.CrsType.SIHA)) {
                buff.append("UtilSession failed to get patch level information because current Oracle Home \"" + oracleHomePath + "\" is SIHA Home.");
            } else if (crs.getCrsType().equals((Object)Crs.CrsType.SOFTWARE_INSTALLATION_ONLY)) {
                buff.append("UtilSession failed to get patch level information because current Oracle Home \"" + oracleHomePath + "\" is a non-configured Grid Home.");
            } else {
                buff.append("UtilSession failed to get patch level information because current Oracle Home \"" + oracleHomePath + "\" is not Grid Home.");
            }
            OLogger.println(buff.toString());
            OLogger.println("UtilSession: getPatchLevel command completed.");
        }
        catch (IllegalAccessException crs) {
        }
        catch (NullPointerException e2) {
            buff = new StringBuilder("UtilSession cannot load inventory from the given Oracle Home.\n");
            buff.append("Possible causes are:\n");
            buff.append("    Oracle Home dir. path does not exist in Central Inventory\n");
            buff.append("    Oracle Home is a symbolic link\n");
            buff.append("    Oracle Home inventory is corrupted");
            throw new RuntimeException(buff.toString(), e2);
        }
    }

    public static void isshared(String oracleHomePath) throws RuntimeException {
        try {
            IsShared.isShared(oracleHomePath);
            OLogger.printlnOnLog("UtilSession: IsShared command completed.");
        }
        catch (RuntimeException e2) {
            OLogger.printlnOnLog("UtilSession could not finish executing IsShared command. ");
            throw e2;
        }
    }

    public static void isspaceavailable(String oracleHomePath) throws RuntimeException {
        try {
            SrvmUtil.isSpaceAvailable(oracleHomePath);
            OLogger.printlnOnLog("UtilSession: IsSpaceAvailable command completed.");
        }
        catch (RuntimeException e2) {
            OLogger.printlnOnLog("UtilSession could not finish executing IsSpaceAvailable command. ");
            throw e2;
        }
    }

    public static void lsnodes(String oracleHomePath) throws RuntimeException {
        try {
            OPatchSessionHelper.loadCRSRelatedLibFiles(oracleHomePath);
            SrvmUtil.lsNodes(oracleHomePath);
            OLogger.printlnOnLog("UtilSession: lsnodes command completed.");
        }
        catch (RuntimeException e2) {
            OLogger.printlnOnLog("UtilSession could not finish executing lsnodes command. ");
            throw e2;
        }
    }

    public static void copylisteddirs(String oracleHomePath) throws RuntimeException {
        try {
            CopyToNodes.copyListedDirs(oracleHomePath);
            OLogger.println("UtilSession: Directories copied to remote nodes.");
        }
        catch (RuntimeException e2) {
            OLogger.println("UtilSession failed to copy dirs to remote nodes. ");
            throw e2;
        }
    }

    public static void removelistedfilestest(String oracleHomePath) throws RuntimeException {
        try {
            RemoveOnNodes.removeListedFilesTest(oracleHomePath);
            OLogger.println("UtilSession: Files removed on remote nodes.");
        }
        catch (RuntimeException e2) {
            OLogger.println("UtilSession failed to remove files on remote nodes. ");
            throw e2;
        }
    }

    public static void removelistedfiles(String oracleHomePath) throws RuntimeException {
        try {
            RemoveOnNodes.removeListedFiles(oracleHomePath);
            OLogger.println("UtilSession: Files removed on remote nodes.");
        }
        catch (RuntimeException e2) {
            OLogger.println("UtilSession failed to remove files on remote nodes. ");
            throw e2;
        }
    }

    public static void removelisteddirstest(String oracleHomePath) throws RuntimeException {
        try {
            RemoveOnNodes.removeListedDirsTest(oracleHomePath);
            OLogger.println("UtilSession: Directories removed on remote nodes.");
        }
        catch (RuntimeException e2) {
            OLogger.println("UtilSession failed to remove dirs on remote nodes. ");
            throw e2;
        }
    }

    public static void removelisteddirs(String oracleHomePath) throws RuntimeException {
        try {
            RemoveOnNodes.removeListedDirs(oracleHomePath);
            OLogger.println("UtilSession: Directories removed on remote nodes.");
        }
        catch (RuntimeException e2) {
            OLogger.println("UtilSession failed to remove dirs on remote nodes. ");
            throw e2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void cleanup(String oracleHomePath) throws ExitOPatchException, RuntimeException {
        String msg = "";
        MethodTrackerObj trackerObj = MethodTracker.getTracker(TrackerTags.CLEAN_BACKUPFORRESTORE);
        trackerObj.start();
        try {
            if (OPatchEnv.isCleanupCmdLine()) {
                OUSession.checkComposite();
            }
            if (OPatchEnv.isReport()) {
                String reportMsg = OLogger.getString("OUI-67325");
                OLogger.println(reportMsg);
            }
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Cleaning up backup");
            msg = OLogger.getString("OUI-67323", new Object[]{"restore.sh,make.txt", "scratch,backup"});
            String promptMsg = OLogger.getString("OUI-67057", new Object[]{msg, "[y|n]"});
            boolean proceed = false;
            proceed = OPatchEnv.proceedWithOperationDefaultYes(promptMsg);
            if (!proceed) {
                ExitOPatchException ee = new ExitOPatchException("UtilSession stopped cleaning up on request.");
                throw ee;
            }
            String cookedPatchID = UtilEnv.getTimeStampedPatchID();
            if (cookedPatchID != null && !cookedPatchID.equals("")) {
                StringBuffer pStorage = new StringBuffer("");
                pStorage.append(OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath));
                pStorage.append(File.separator);
                pStorage.append(cookedPatchID);
                String patchStorage = pStorage.toString();
                Path psDir = WrapperFactory.getNioServiceWrapper().getPath(patchStorage, new String[0]);
                if (!Files.exists(psDir, new LinkOption[0])) throw new RuntimeException("No patch storage directory \"" + patchStorage + "\" for given Oracle Home.");
                OPatchUtilHelper.cleanupBackupArea(oracleHomePath, patchStorage);
            } else {
                OPatchUtilHelper.cleanupBackupArea(oracleHomePath);
            }
            OLogger.printlnOnConsole("\n" + OLogger.getString("OUI-67324"));
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] " + OLogger.getString("OUI-67324"));
            return;
        }
        catch (ExitOPatchException e2) {
            throw e2;
        }
        catch (Throwable t) {
            RuntimeException re = new RuntimeException(t);
            throw re;
        }
        finally {
            trackerObj.end();
        }
    }

    public static void clearcache(String oracleHomePath) {
        CacheProcessor.clearcachedfiles(oracleHomePath);
    }

    public static void checkphaseonestatus(String oracleHomePath) throws RuntimeException {
        String[] patchLocs = null;
        try {
            if (OPatchEnv.isUserSuppliedPatchIDs()) {
                Vector notInstalledPatchIDs = new Vector();
                Vector installedPatchIDs = new Vector();
                PrereqResult pRes = PrereqAPI.checkInstalledOneOffs(oracleHomePath, OPatchEnv.getUserSuppliedPatchIDs(), installedPatchIDs, notInstalledPatchIDs);
                if (pRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                    throw new RuntimeException("Some or all of the patch(es) are not installed in the Oracle Home. Please specify valid patch IDs. ");
                }
                patchLocs = new String[installedPatchIDs.size()];
                for (int i2 = 0; i2 < installedPatchIDs.size(); ++i2) {
                    patchLocs[i2] = OPatchEnv.getPatchFilemapInfoLoc(oracleHomePath, (String)installedPatchIDs.elementAt(i2));
                }
            } else if (OUSession.isPatchBaseDirProvided() || OUSession.isPatchBaseFileProvided()) {
                try {
                    patchLocs = OUSession.parseBaseDirListFile();
                }
                catch (Exception e2) {
                    StringBuffer buff = new StringBuffer("Failed to phbaseDir/phBaseFile options: ");
                    buff.append(e2.getMessage());
                    RuntimeException re = new RuntimeException(buff.toString());
                    re.setStackTrace(e2.getStackTrace());
                    throw re;
                }
            } else {
                String patchLoc = OPatchEnv.getPatchloc();
                if (patchLoc == null || patchLoc.equals("")) {
                    throw new RuntimeException("Please use -ph (or) -phbasefile (or) -phbasedir to point to the patch location(s).");
                }
                patchLocs = new String[]{patchLoc};
            }
            checkPhaseOneStatus.checkPhaseOneStatus(oracleHomePath, patchLocs);
            OLogger.println("OPatch util 'checkphaseonestatus' done.");
        }
        catch (Exception e3) {
            OLogger.println("\nUtil \"checkphaseonestatus\" failed.");
            RuntimeException re = new RuntimeException(e3.getMessage());
            re.setStackTrace(e3.getStackTrace());
            throw re;
        }
    }

    public static void enableonlinepatch(String oracleHomePath) throws RuntimeException {
        PrereqResult pRes;
        Vector installedPatchIDs;
        Vector notInstalledPatchIDs;
        OPatchEnv.setOnline(true);
        String[] patchLocs = null;
        String[] patchID = new String[]{OPatchEnv.getRollbackPatchid()};
        Vector inPatchIDs = new Vector();
        boolean inSystem = false;
        StringBuffer buff = new StringBuffer("enableonlinepatch() ");
        buff.append("on Oracle Home ").append(oracleHomePath);
        OLogger.debug(buff);
        if (OUSession.isPatchBaseDirProvided() || OUSession.isPatchBaseFileProvided()) {
            buff = new StringBuffer(" baseDir or baseFile provided");
            OLogger.debug(buff);
            try {
                patchLocs = OUSession.parseBaseDirListFile();
                OnlinePatchProcessor.handleOnlinePatch(patchLocs);
            }
            catch (Exception e2) {
                buff = new StringBuffer("Failed to parseBaseDir(): ");
                buff.append(e2.getMessage());
                RuntimeException re = new RuntimeException(buff.toString());
                re.setStackTrace(e2.getStackTrace());
                throw re;
            }
        }
        if (OPatchEnv.isUserSuppliedPatchIDs()) {
            buff = new StringBuffer(" use supplied patch IDs");
            OLogger.debug(buff);
            notInstalledPatchIDs = new Vector();
            installedPatchIDs = new Vector();
            pRes = PrereqAPI.checkInstalledOneOffs(oracleHomePath, OPatchEnv.getUserSuppliedPatchIDs(), installedPatchIDs, notInstalledPatchIDs);
            if (pRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                if (installedPatchIDs.size() == 0) {
                    OLogger.println("None of the given patches are present in the Oracle Home.");
                    return;
                }
                StringBuffer tbuf = new StringBuffer("Following patches are not installed and are skipped:\n");
                tbuf.append(notInstalledPatchIDs.toString());
                OLogger.println(tbuf.toString());
            }
            patchLocs = new String[installedPatchIDs.size()];
            for (int i2 = 0; i2 < installedPatchIDs.size(); ++i2) {
                patchLocs[i2] = OPatchEnv.getPatchFilemapInfoLoc(oracleHomePath, (String)installedPatchIDs.elementAt(i2));
            }
            inPatchIDs = installedPatchIDs;
            inSystem = true;
        } else if (patchID[0] != null && !patchID[0].equals("")) {
            installedPatchIDs = new Vector();
            notInstalledPatchIDs = new Vector();
            pRes = PrereqAPI.checkInstalledOneOffs(oracleHomePath, patchID, installedPatchIDs, notInstalledPatchIDs);
            if (pRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                OLogger.println("Patch " + notInstalledPatchIDs.elementAt(0) + " is not present in the Oracle Home.");
                return;
            }
            patchLocs = new String[]{OPatchEnv.getPatchFilemapInfoLoc(oracleHomePath, (String)installedPatchIDs.elementAt(0))};
            inPatchIDs = installedPatchIDs;
            inSystem = true;
        } else {
            buff = new StringBuffer("  get patchLoc from OPatchEnv.getPatchLoc()");
            OLogger.debug(buff);
            patchLocs = new String[]{OPatchEnv.getPatchloc()};
            OnlinePatchProcessor.handleOnlinePatch(patchLocs);
            if (patchLocs[0] != null && !patchLocs[0].equals("")) {
                PatchObject po1 = null;
                try {
                    po1 = PatchObject.getInstance(patchLocs[0]);
                }
                catch (Exception e3) {
                    OLogger.println("Unable to create Patch Object. Check if the given patch location is correct.");
                    OLogger.debug(e3.getMessage());
                    RuntimeException re = new RuntimeException("Util \"enableOnlinePatch\" failed.");
                    throw re;
                }
                if (!po1.isOnlinePatch()) {
                    OLogger.println("Given patch location is invalid. Please provide a valid online patch location.");
                    RuntimeException re1 = new RuntimeException("Util \"enableOnlinePatch\" failed.");
                    throw re1;
                }
            }
        }
        if (patchLocs[0] == null || patchLocs[0].equals("")) {
            buff = new StringBuffer("  patchLocs[0] is null or empty");
            OLogger.debug(buff);
            OLogger.println(" No online patches are provided. Please provide valid online patches.");
            RuntimeException re = new RuntimeException("Util \"enableOnlinePatch\" failed.");
            throw re;
        }
        PrereqResult resObj = PrereqAPI.checkDBInstanceUp(oracleHomePath, true);
        if (resObj.getResult() != PrereqResult.ExecuteStatus.PASSED) {
            buff = new StringBuffer(resObj.toString());
            throw new RuntimeException(buff.toString());
        }
        for (int i3 = 0; i3 < patchLocs.length; ++i3) {
            ArrayList<String> filteredSet = new ArrayList<String>();
            try {
                PatchObject pObj = null;
                pObj = !inSystem ? PatchObject.getInstance(patchLocs[i3]) : PatchObject.getInstance(oracleHomePath, (String)inPatchIDs.elementAt(i3));
                String pID = pObj.getPatchID();
                if (filteredSet.contains(pID)) continue;
                buff = new StringBuffer("Calling UpdateRemoteNodes.enableOnlinePatch() on patch " + pID);
                OLogger.debug(buff);
                filteredSet.add(pObj.getPatchID());
                UpdateRemoteNodes.enableOnlinePatch(oracleHomePath, pObj);
                continue;
            }
            catch (Exception e4) {
                OLogger.println("\nUtil \"enableOnlinePatch\" failed.");
                OLogger.println("Unable to create Patch Object. Check if the given patch location is correct.");
                RuntimeException re = new RuntimeException(e4.getMessage());
                re.setStackTrace(e4.getStackTrace());
                throw re;
            }
        }
    }

    public static void disableonlinepatch(String oracleHomePath) throws RuntimeException {
        int i2;
        PrereqResult pRes;
        Vector installedPatchIDs;
        Vector notInstalledPatchIDs;
        OPatchEnv.setOnline(true);
        String[] patchLocs = null;
        String[] patchID = new String[]{OPatchEnv.getRollbackPatchid()};
        Vector inPatchIDs = new Vector();
        boolean inSystem = false;
        StringBuffer buff = new StringBuffer("disableonlinepatch on Oracle Home ");
        buff.append(oracleHomePath);
        OLogger.debug(buff);
        if (OUSession.isPatchBaseDirProvided() || OUSession.isPatchBaseFileProvided()) {
            buff = new StringBuffer(" baseDir or baseFile provided.");
            OLogger.debug(buff);
            try {
                patchLocs = OUSession.parseBaseDirListFile();
                OnlinePatchProcessor.handleOnlinePatch(patchLocs);
            }
            catch (Exception e2) {
                buff = new StringBuffer("Fail to parseBaseDir(): ");
                buff.append(e2.getMessage());
                RuntimeException re = new RuntimeException(buff.toString());
                re.setStackTrace(e2.getStackTrace());
                throw re;
            }
        }
        if (OPatchEnv.isUserSuppliedPatchIDs()) {
            notInstalledPatchIDs = new Vector();
            installedPatchIDs = new Vector();
            pRes = PrereqAPI.checkInstalledOneOffs(oracleHomePath, OPatchEnv.getUserSuppliedPatchIDs(), installedPatchIDs, notInstalledPatchIDs);
            if (pRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                if (installedPatchIDs.size() == 0) {
                    OLogger.println("None of the given patches are present in the Oracle Home.");
                    return;
                }
                StringBuffer tbuf = new StringBuffer("Following patches are not installed and are skipped:\n");
                tbuf.append(notInstalledPatchIDs.toString());
                OLogger.println(tbuf.toString());
            }
            patchLocs = new String[installedPatchIDs.size()];
            for (int i3 = 0; i3 < installedPatchIDs.size(); ++i3) {
                patchLocs[i3] = OPatchEnv.getPatchFilemapInfoLoc(oracleHomePath, (String)installedPatchIDs.elementAt(i3));
            }
            inPatchIDs = installedPatchIDs;
            inSystem = true;
        } else if (patchID[0] != null && !patchID[0].equals("")) {
            installedPatchIDs = new Vector();
            notInstalledPatchIDs = new Vector();
            pRes = PrereqAPI.checkInstalledOneOffs(oracleHomePath, patchID, installedPatchIDs, notInstalledPatchIDs);
            if (pRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                OLogger.println("Patch " + notInstalledPatchIDs.elementAt(0) + " is not present in the Oracle Home.");
                return;
            }
            patchLocs = new String[]{OPatchEnv.getPatchFilemapInfoLoc(oracleHomePath, (String)installedPatchIDs.elementAt(0))};
            inPatchIDs = installedPatchIDs;
            inSystem = true;
        } else {
            patchLocs = new String[]{OPatchEnv.getPatchloc()};
            OnlinePatchProcessor.handleOnlinePatch(patchLocs);
            if (patchLocs[0] != null && !patchLocs[0].equals("")) {
                PatchObject po1 = null;
                try {
                    po1 = PatchObject.getInstance(patchLocs[0]);
                }
                catch (Exception e3) {
                    OLogger.println("Unable to create Patch object. Check if the given patch location is correct.");
                    OLogger.debug(e3.getMessage());
                    throw new RuntimeException("Util \"disableOnlinePatch\" failed.");
                }
                if (!po1.isOnlinePatch()) {
                    OLogger.println("Given patch location is invalid. Please provide a valid online patch location.");
                    RuntimeException re1 = new RuntimeException("Util \"disableOnlinePatch\" failed.");
                    throw re1;
                }
            }
        }
        if (patchLocs[0] == null || patchLocs[0].equals("")) {
            buff = new StringBuffer("Util \"disableOnlinePatch\" failed: ");
            buff.append("patchLoc is either null or empty");
            RuntimeException re = new RuntimeException(buff.toString());
            throw re;
        }
        PrereqResult resObj = PrereqAPI.checkDBInstanceUp(oracleHomePath, false);
        if (resObj.getResult() != PrereqResult.ExecuteStatus.PASSED) {
            buff = new StringBuffer(resObj.toString());
            throw new RuntimeException(buff.toString());
        }
        HashSet<String> sidInfo = new HashSet<String>();
        String[] dbSids = OPatchEnv.getDBSIDs();
        String[] dbNodes = OPatchEnv.getDBNodes();
        String localNode = OPatchEnv.getLocalNode();
        for (int i4 = 0; i4 < dbSids.length; ++i4) {
            if (!dbNodes[i4].equals(localNode) && !dbNodes[i4].equals("")) continue;
            sidInfo.add(dbSids[i4]);
        }
        Properties onlineProp = OPatchSessionHelper.getOnlinePropertyFromFile(oracleHomePath);
        String onlineFilePath = OPatchEnv.getOnlinePropertyFilePath(oracleHomePath);
        if (sidInfo == null || sidInfo.size() == 0) {
            onlineProp = new Properties();
            onlineFilePath = "";
        }
        StringBuffer prereqBuff = new StringBuffer("");
        resObj = null;
        for (i2 = 0; i2 < patchLocs.length; ++i2) {
            PatchObject pObj = null;
            try {
                pObj = !inSystem ? PatchObject.getInstance(patchLocs[i2]) : PatchObject.getInstance(oracleHomePath, (String)inPatchIDs.elementAt(i2));
            }
            catch (Exception e4) {
                buff = new StringBuffer("Unable to create Patch Object. Check if the given patch location is correct.");
                RuntimeException re = new RuntimeException(buff.toString());
                re.setStackTrace(e4.getStackTrace());
                throw re;
            }
            resObj = PrereqAPI.checkOnlinePatchRollbackSid(pObj, sidInfo, onlineProp, onlineFilePath, oracleHomePath, true, localNode);
            if (resObj.getResult() == PrereqResult.ExecuteStatus.PASSED) continue;
            prereqBuff.append("\nPatch ID: " + pObj.getPatchID() + "\n");
            prereqBuff.append(resObj.toString());
        }
        if (!prereqBuff.toString().equals("")) {
            throw new RuntimeException(prereqBuff.toString());
        }
        for (i2 = 0; i2 < patchLocs.length; ++i2) {
            ArrayList<String> filteredSet = new ArrayList<String>();
            try {
                PatchObject pObj = null;
                pObj = !inSystem ? PatchObject.getInstance(patchLocs[i2]) : PatchObject.getInstance(oracleHomePath, (String)inPatchIDs.elementAt(i2));
                if (filteredSet.contains(pObj.getPatchID())) continue;
                filteredSet.add(pObj.getPatchID());
                UpdateRemoteNodes.disableOnlinePatch(oracleHomePath, pObj);
                continue;
            }
            catch (Exception e5) {
                buff = new StringBuffer("\n Util \"disableOnlinePatch\" failed.");
                buff.append("Unable to create Patch Object. Check if the given patch location is correct.");
                RuntimeException re = new RuntimeException(buff.toString());
                re.setStackTrace(e5.getStackTrace());
                throw re;
            }
        }
    }

    public static void restoreoh(String oracleHomePath) throws RuntimeException {
        StringBuffer buff = new StringBuffer("OUSession::restoreOH()");
        OLogger.debug(buff);
        String propertiesPath = OPatchEnv.getSessionProperties(oracleHomePath);
        Properties prop = new Properties();
        try {
            OUSession.checkComposite();
            InputStream fs = Files.newInputStream(WrapperFactory.getNioServiceWrapper().getPath(propertiesPath, new String[0]), new OpenOption[0]);
            prop.load(fs);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        String sessionName = prop.getProperty("SessionName");
        String sessionID = prop.getProperty("SessionID");
        String patchID = prop.getProperty("PatchID");
        String triggeredPatchID = prop.getProperty("TriggeredPatchID");
        if (sessionName.equals(OPatchSession.APPLY.getSessionName()) || sessionName.equals(OPatchEnv.getNApplySessionName())) {
            int i2;
            int i3;
            String[] patchLocs = null;
            PatchObject[] pObj = null;
            if (OUSession.isPatchBaseDirProvided() || OUSession.isPatchBaseFileProvided()) {
                try {
                    patchLocs = OUSession.parseBaseDirListFile();
                }
                catch (Exception e3) {
                    RuntimeException re = new RuntimeException(e3);
                    throw re;
                }
            } else {
                patchLocs = new String[]{OPatchEnv.getPatchloc()};
                if (patchLocs[0] == null || patchLocs[0].equals("")) {
                    RuntimeException re = new RuntimeException("No patch location specified. Restore cannot proceed.");
                    throw re;
                }
            }
            ArrayList<PatchObject> pObjsList = new ArrayList<PatchObject>();
            ArrayList<String> filteredSet = new ArrayList<String>();
            for (i3 = 0; i3 < patchLocs.length; ++i3) {
                try {
                    PatchObject tmpPObj = PatchObject.getInstance(patchLocs[i3]);
                    if (filteredSet.contains(tmpPObj.getPatchID())) continue;
                    filteredSet.add(tmpPObj.getPatchID());
                    pObjsList.add(tmpPObj);
                    continue;
                }
                catch (Exception e4) {
                    throw new RuntimeException(e4);
                }
            }
            pObj = new PatchObject[pObjsList.size()];
            pObjsList.toArray(pObj);
            if (sessionName.equals(OPatchSession.APPLY.getSessionName())) {
                if (pObj.length > 1) {
                    RuntimeException re = new RuntimeException("Session is apply, but there are more than one session patches.");
                    throw re;
                }
                if (!sessionID.equals(pObj[0].getCookedPatchID())) {
                    RuntimeException re = new RuntimeException("SessionID does not match patchID with timestamp.");
                    throw re;
                }
                if (!patchID.equals(pObj[0].getPatchID())) {
                    RuntimeException re = new RuntimeException("PatchID does not match patch in the given location.");
                    throw re;
                }
                OPatchSession.restoreSystemAndInventory(oracleHomePath, sessionID, true);
            } else {
                String[] patchIDs = patchID.split(",");
                MergedPatchObject mPo = new MergedPatchObject(sessionName, sessionID);
                StringBuffer pBuff = new StringBuffer();
                for (i2 = 0; i2 < patchIDs.length; ++i2) {
                    boolean found = true;
                    for (int j2 = 0; j2 < pObj.length; ++j2) {
                        if (!patchIDs[i2].equals(pObj[j2].getPatchID())) continue;
                        found = false;
                    }
                    if (found) continue;
                    pBuff.append(patchIDs[i2]);
                    pBuff.append(" ");
                }
                if (!pBuff.equals("")) {
                    buff = new StringBuffer("Patch location is not specified for the following patches : ");
                    buff.append(pBuff);
                    OLogger.println(buff.toString());
                    RuntimeException re = new RuntimeException("Patch location specified is not complete.");
                    throw re;
                }
                mPo.restoreSystemAndInventory(oracleHomePath, sessionID);
            }
            for (i3 = 0; i3 < pObj.length; ++i3) {
                OPatchSession.restorePluginActions(oracleHomePath, sessionID, pObj[i3], true, false, false);
            }
            boolean triggered = false;
            String[] tPatchIDs = null;
            PatchObject[] tPobjs = null;
            if (triggeredPatchID != null && !triggeredPatchID.equals("")) {
                tPatchIDs = triggeredPatchID.split(",");
                tPobjs = new PatchObject[tPatchIDs.length];
                for (i2 = 0; i2 < tPatchIDs.length; ++i2) {
                    try {
                        tPobjs[i2] = PatchObject.getInstance(oracleHomePath, tPatchIDs[i2]);
                    }
                    catch (Exception e5) {
                        RuntimeException re = new RuntimeException("Unable to create the patchobject for patch " + tPatchIDs[i2]);
                        re.setStackTrace(e5.getStackTrace());
                        throw re;
                    }
                    triggered = true;
                }
            }
            if (triggered) {
                for (i2 = 0; i2 < tPobjs.length; ++i2) {
                    OPatchSession.restorePluginActions(oracleHomePath, sessionID, tPobjs[i2], true, true, false);
                }
            }
            if (!OPatchEnv.isWindows()) {
                OLogger.info("OUI-67111");
                if (OPatchEnv.isNolink()) {
                    OLogger.info("OUI-67217");
                } else {
                    OPatchSession.restoreMake(oracleHomePath, sessionID);
                }
            }
            for (i2 = 0; i2 < pObj.length; ++i2) {
                OPatchSession.restorePluginActions(oracleHomePath, sessionID, pObj[i2], true, false, true);
            }
            if (triggered) {
                for (i2 = 0; i2 < tPobjs.length; ++i2) {
                    OPatchSession.restorePluginActions(oracleHomePath, sessionID, tPobjs[i2], true, true, true);
                }
            }
        } else if (sessionName.equals(OPatchSession.ROLLBACK.getSessionName()) || sessionName.equals(OPatchEnv.getNRollbackSessionName())) {
            int i4;
            if (sessionName.equals(OPatchSession.ROLLBACK.getSessionName())) {
                OPatchSession.restoreSystemAndInventory(oracleHomePath, sessionID, true);
            } else {
                MergedPatchObject mPo = new MergedPatchObject(sessionName, sessionID);
                mPo.restoreSystemAndInventory(oracleHomePath, sessionID);
            }
            String[] patchIDs = patchID.split(",");
            PatchObject[] pObjs = new PatchObject[patchIDs.length];
            for (i4 = 0; i4 < patchIDs.length; ++i4) {
                try {
                    pObjs[i4] = PatchObject.getInstance(oracleHomePath, patchIDs[i4]);
                    continue;
                }
                catch (Exception e6) {
                    RuntimeException re = new RuntimeException("Unable to create the patchobject for patch " + patchIDs[i4]);
                    throw re;
                }
            }
            for (i4 = 0; i4 < pObjs.length; ++i4) {
                OPatchSession.restorePluginActions(oracleHomePath, sessionID, pObjs[i4], false, true, false);
            }
            if (!OPatchEnv.isWindows()) {
                OLogger.info("OUI-67111");
                if (OPatchEnv.isNolink()) {
                    OLogger.info("OUI-67217");
                } else {
                    OPatchSession.restoreMake(oracleHomePath, sessionID);
                }
            }
            for (i4 = 0; i4 < pObjs.length; ++i4) {
                OPatchSession.restorePluginActions(oracleHomePath, sessionID, pObjs[i4], false, true, true);
            }
        } else {
            buff = new StringBuffer("Unknown session name in the properties file.");
            OLogger.debug(buff);
            RuntimeException re = new RuntimeException(buff.toString());
            throw re;
        }
    }

    public static void updateremotenodes(String oracleHomePath) throws RuntimeException {
        try {
            UpdateRemoteNodes.process(oracleHomePath);
            OLogger.println("UtilSession: updateRemoteNodes done.");
        }
        catch (RuntimeException e2) {
            OLogger.println("UtilSession failed to propagate all RAC files to remote nodes. ");
            throw e2;
        }
    }

    public static void verify(String oracleHomePath) throws RuntimeException {
        try {
            OLogger.println("Verifying that patch has been applied to Oracle Home.");
            OUSession.checkComposite();
            String patchLoc = OPatchEnv.getPatchloc();
            if (patchLoc == null || patchLoc.equals("")) {
                throw new RuntimeException("Please use -ph to point to the patch location.");
            }
            boolean ok = VerifyPatch.verify(oracleHomePath, patchLoc);
            if (ok) {
                OLogger.println("Patch has been verified successfully.");
            }
        }
        catch (Exception e2) {
            OLogger.println("UtilSession failed to verify patch on ORACLE_HOME. ");
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
    }

    public static void xmlinput(String arg) {
        UtilEnv.setXML(arg);
    }

    public static void cmd(String arg) {
        String command = arg;
        UtilEnv.setCommand(command);
    }

    public static void cmd_end(String arg) {
    }

    public static void ps(String arg) {
        UtilEnv.setTimeStampedPatchID(arg);
    }

    public static void fp(String arg) {
        OLogger.debug(new StringBuffer("OUSession::fp()"));
        Path fpFile = WrapperFactory.getNioServiceWrapper().getPath(arg, new String[0]);
        if (Files.exists(fpFile, new LinkOption[0]) && Files.isReadable(fpFile)) {
            UtilEnv.setFilesToPropagate(arg);
        } else {
            OLogger.println("The file \"" + arg + "\" does not exists or is not readable.\n");
            try {
                OPatchACL.setArgumentError(new OUSession(), "fp file is not valid.");
            }
            catch (IllegalAccessException e2) {
                OLogger.debug(new StringBuffer("OUSession::fp()-  \"IllegalAccessException\" was thrown when calling OPatchACL.setArgumentError()."));
            }
        }
    }

    public static void dp(String arg) {
        OLogger.debug(new StringBuffer("OUSession::dp()"));
        Path dpFile = WrapperFactory.getNioServiceWrapper().getPath(arg, new String[0]);
        if (Files.exists(dpFile, new LinkOption[0]) && Files.isReadable(dpFile)) {
            UtilEnv.setDirectoriesToPropagate(arg);
        } else {
            OLogger.println("The file \"" + arg + "\" does not exists or is not readable.\n");
            try {
                OPatchACL.setArgumentError(new OUSession(), "dp file is not valid.");
            }
            catch (IllegalAccessException e2) {
                OLogger.debug(new StringBuffer("OUSession::dp()-  \"IllegalAccessException\" was thrown when calling OPatchACL.setArgumentError()."));
            }
        }
    }

    public static void fr(String arg) {
        OLogger.debug(new StringBuffer("OUSession::fr()"));
        if (arg != null && !arg.equals("")) {
            UtilEnv.setFilesToRemove(arg);
        } else {
            OLogger.println("The argument for -fr \"" + arg + "\" is invalid.\n");
            try {
                OPatchACL.setArgumentError(new OUSession(), "fr argument is not valid.");
            }
            catch (IllegalAccessException e2) {
                OLogger.debug(new StringBuffer("OUSession::fr()-  \"IllegalAccessException\" was thrown when calling OPatchACL.setArgumentError()."));
            }
        }
    }

    public static void dr(String arg) {
        OLogger.debug(new StringBuffer("OUSession::dr()"));
        if (arg != null && !arg.equals("")) {
            UtilEnv.setDirectoriesToRemove(arg);
        } else {
            OLogger.println("The argument for -dr \"" + arg + "\" is invalid.\n");
            try {
                OPatchACL.setArgumentError(new OUSession(), "-dr argument is not valid.");
            }
            catch (IllegalAccessException e2) {
                OLogger.debug(new StringBuffer("OUSession::dr()-  \"IllegalAccessException\" was thrown when calling OPatchACL.setArgumentError()."));
            }
        }
    }

    public static void mp(String arg) {
        OLogger.println("OUSession::mp(): " + arg);
    }

    public static void phbasedir(String arg) {
        OLogger.debug(new StringBuffer("OUSession::phBaseDir()"));
        Path fDir = WrapperFactory.getNioServiceWrapper().getPath(arg, new String[0]);
        if (Files.exists(fDir, new LinkOption[0])) {
            patchBaseDir = arg;
            baseDir = true;
        } else {
            OLogger.println("The argument \"" + arg + "\" does not exists.\n");
            try {
                OPatchACL.setArgumentError(new OUSession(), "Patch base location is not valid.");
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public static void phbasefile(String arg) {
        OLogger.debug(new StringBuffer("OUSession::phBaseFile()"));
        Path fFile = WrapperFactory.getNioServiceWrapper().getPath(arg, new String[0]);
        if (Files.exists(fFile, new LinkOption[0]) && Files.isReadable(fFile)) {
            patchBaseFile = arg;
            phBaseFile = true;
        } else {
            OLogger.println("The argument \"" + arg + "\" does not exists or is not readable.\n");
            try {
                OPatchACL.setArgumentError(new OUSession(), "Patch base file is not valid.");
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public static void deploy(String oracleHomePath) throws RuntimeException {
        if (!OPatchEnv.isBeaHome()) {
            String msg = OLogger.getString("OUI-67332");
            OLogger.printlnOnLog(msg);
            throw new UnsupportedOperationException(msg);
        }
        FMWHandler.deploy();
        OLogger.println("OPatch command 'deploy' done.");
    }

    public static void undeploy(String oracleHomePath) throws RuntimeException {
        if (!OPatchEnv.isBeaHome()) {
            String msg = OLogger.getString("OUI-67332");
            OLogger.printlnOnLog(msg);
            throw new UnsupportedOperationException(msg);
        }
        FMWHandler.undeploy();
        OLogger.println("OPatch command 'undeploy' done.");
    }

    public static void lsdomains(String oracleHomePath) throws RuntimeException {
        if (!OPatchEnv.isBeaHome()) {
            String msg = OLogger.getString("OUI-67332");
            OLogger.printlnOnLog(msg);
            throw new UnsupportedOperationException(msg);
        }
        OPatchFmwPointer.lsdomains();
        OLogger.println("OPatch command 'lsdomains' done.");
    }

    public static void lshomes(String oracleHomePath) throws RuntimeException {
        if (!OPatchEnv.isBeaHome()) {
            String msg = OLogger.getString("OUI-67332");
            OLogger.printlnOnLog(msg);
            throw new UnsupportedOperationException(msg);
        }
        OPatchFmwPointer.lshomes();
        OLogger.println("OPatch command 'lshomes' done.");
    }

    public static void checkapplicable(String oracleHomePath) throws RuntimeException {
        try {
            OUSession.checkComposite();
        }
        catch (FileNotFoundException e1) {
            throw new RuntimeException(e1.getMessage());
        }
        catch (IOException e1) {
            throw new RuntimeException(e1.getMessage());
        }
        String patchLoc = OPatchEnv.getPatchloc();
        if (patchLoc == null || patchLoc.equals("")) {
            throw new RuntimeException("Please use -ph to point to the patch location.");
        }
        OPatchFmwPointer.checkApplicable(oracleHomePath);
        OLogger.println("OPatch command 'checkApplicable' done.");
    }

    public static void checkcomponents(String oracleHomePath) throws RuntimeException {
        String[] patchLocs = null;
        if (OUSession.isPatchBaseDirProvided() || OUSession.isPatchBaseFileProvided()) {
            StringBuffer buff = new StringBuffer(" -phBaseDir or -phBaseFile provided");
            OLogger.debug(buff);
            try {
                patchLocs = OUSession.parseBaseDirListFile();
            }
            catch (Exception e2) {
                buff = new StringBuffer("Failed to phbaseDir/phBaseFile options: ");
                buff.append(e2.getMessage());
                RuntimeException re = new RuntimeException(buff.toString());
                re.setStackTrace(e2.getStackTrace());
                throw re;
            }
        } else {
            String patchLoc = OPatchEnv.getPatchloc();
            if (patchLoc == null || patchLoc.equals("")) {
                throw new RuntimeException("Please use -ph (or) -phbasefile (or) -phbasedir to point to the patch location(s).");
            }
            patchLocs = new String[]{patchLoc};
        }
        checkComponents.checkComponents(oracleHomePath, patchLocs);
        OLogger.println("OPatch command 'checkComponents' done.");
    }

    public static void checkinstalledoneoffs(String oracleHomePath) {
        OPatchFmwPointer.checkInstalledOneOffs(oracleHomePath);
        OLogger.println("OPatch command 'checkInstalledOneOffs' done.");
    }

    public static void start(String oracleHomePath) throws RuntimeException {
        if (!OPatchEnv.isBeaHome()) {
            String msg = OLogger.getString("OUI-67332");
            OLogger.printlnOnLog(msg);
            throw new UnsupportedOperationException(msg);
        }
        HashSet targetList = OPatchFmwEnv.getFmwTargetList();
        String cmdTargetType = OPatchFmwEnv.getCmdTargetType();
        if (targetList == null) {
            throw new RuntimeException("Please use -targets to provide the list of targets of the domain for the 'start' operation.");
        }
        if (cmdTargetType == null) {
            throw new RuntimeException("Please use -target_type to provide the target type for the 'start' operation.");
        }
        FMWHandler.start();
        OLogger.println("OPatch command 'start' done.");
    }

    public static void stop(String oracleHomePath) throws RuntimeException {
        if (!OPatchEnv.isBeaHome()) {
            String msg = OLogger.getString("OUI-67332");
            OLogger.printlnOnLog(msg);
            throw new UnsupportedOperationException(msg);
        }
        HashSet targetList = OPatchFmwEnv.getFmwTargetList();
        String cmdTargetType = OPatchFmwEnv.getCmdTargetType();
        if (targetList == null) {
            throw new RuntimeException("Please use -targets to provide the list of targets of the domain for the 'stop' operation.");
        }
        if (cmdTargetType == null) {
            throw new RuntimeException("Please use -target_type to provide the target type for the 'stop' operation.");
        }
        FMWHandler.stop();
        OLogger.println("OPatch command 'stop' done.");
    }

    public static void startcomposite(String oracleHomePath) throws RuntimeException {
        if (!OPatchEnv.isBeaHome()) {
            String msg = OLogger.getString("OUI-67332");
            OLogger.printlnOnLog(msg);
            throw new UnsupportedOperationException(msg);
        }
        String cmdCompName = OPatchFmwEnv.getCmdCompositeName();
        String cmdCompRev = OPatchFmwEnv.getCmdCompositeRevision();
        if (cmdCompName == null) {
            throw new RuntimeException("Please use 'name' option to provide the composite name for the 'startComposite' operation.");
        }
        if (cmdCompRev == null) {
            throw new RuntimeException("Please use 'revision' option to provide the composite revision for the 'startComposite' operation.");
        }
        FMWHandler.startComposite();
        OLogger.println("OPatch command 'startComposite' done.");
    }

    public static void stopcomposite(String oracleHomePath) throws RuntimeException {
        if (!OPatchEnv.isBeaHome()) {
            String msg = OLogger.getString("OUI-67332");
            OLogger.printlnOnLog(msg);
            throw new UnsupportedOperationException(msg);
        }
        String cmdCompName = OPatchFmwEnv.getCmdCompositeName();
        String cmdCompRev = OPatchFmwEnv.getCmdCompositeRevision();
        if (cmdCompName == null) {
            throw new RuntimeException("Please use -name to provide the composite name for the 'stopComposite' operation.");
        }
        if (cmdCompRev == null) {
            throw new RuntimeException("Please use -revision to provide the composite revision for the 'stopComposite' operation.");
        }
        FMWHandler.stopComposite();
        OLogger.println("OPatch command 'stopComposite' done.");
    }

    public static void listcomposites(String oracleHomePath) throws RuntimeException {
        if (!OPatchEnv.isBeaHome()) {
            String msg = OLogger.getString("OUI-67332");
            OLogger.printlnOnLog(msg);
            throw new UnsupportedOperationException(msg);
        }
        FMWHandler.listComposites();
        OLogger.println("OPatch command 'listComposites' done.");
    }

    public static String findCompositePatchLocations(String[] patchLocs) {
        ArrayList<String> compositeLocs = new ArrayList<String>();
        for (int i2 = 0; i2 < patchLocs.length; ++i2) {
            String compositeXmlLoc = CompositePatchObject.validateComposite(patchLocs[i2]);
            Path compositeXml = WrapperFactory.getNioServiceWrapper().getPath(compositeXmlLoc, new String[0]);
            if (compositeXmlLoc.equals("") || !Files.exists(compositeXml, new LinkOption[0])) continue;
            compositeLocs.add(patchLocs[i2]);
        }
        if (compositeLocs.size() == 0) {
            return null;
        }
        String patchList = "";
        for (int i3 = 0; i3 < compositeLocs.size(); ++i3) {
            patchList = patchList + "\n" + (String)compositeLocs.get(i3);
        }
        return patchList;
    }

    public static boolean isComposite(String patchLocation) {
        String compositeXmlLoc = CompositePatchObject.validateComposite(patchLocation);
        Path compositeXml = WrapperFactory.getNioServiceWrapper().getPath(compositeXmlLoc, new String[0]);
        return !compositeXmlLoc.equals("") && Files.exists(compositeXml, new LinkOption[0]);
    }

    public static void checkComposite() throws FileNotFoundException, IOException, RuntimeException {
        if (OUSession.isPatchBaseDirProvided() || OUSession.isPatchBaseFileProvided()) {
            String[] patchLocs = OUSession.parseBaseDirListFile();
            OUSession.findCompositeAndErrorOut(patchLocs);
        } else {
            String[] patchLocs = new String[]{OPatchEnv.getPatchloc()};
            OUSession.findCompositeAndErrorOut(patchLocs);
        }
    }

    public static void findCompositeAndErrorOut(String[] patchLocs) {
        String compositeLocs = OUSession.findCompositePatchLocations(patchLocs);
        if (compositeLocs != null) {
            throw new OPatchException(OLogger.getString("S_OPATCH_UTIL_COMPOSITE_ERROR", new Object[]{compositeLocs}));
        }
    }

    public static void setIAnalysisReport(IAnalysisReport report) {
        OUSession.report = (OPatchAnalysisReport)report;
        OUSession.setDeltaFileProcessor(new DeltaFileProcessor(report));
    }

    public static void addPrereqResultToReport(OPatchPatchPrereq prereq, PrereqResult result) {
        if (OPatchEnv.isOPatchSDKMode() && report != null) {
            report.addOPatchPatchPrereqResult(prereq, result);
        }
    }

    public static void addPrereqResultForPatchesToReport(String patchId, OPatchPatchPrereq prereq, PrereqResult result, OPatchAnalysisReport.PrereqStatusForPatch psp) {
        if (OPatchEnv.isOPatchSDKMode() && report != null) {
            report.addOPatchPatchPrereqResultForPatches(patchId, prereq, result, psp);
        }
    }

    public static void setPrereqResult(OPatchPatchPrereq prereq, PrereqResult.ExecuteStatus status, String message) {
        if (OPatchEnv.isOPatchSDKMode() && report != null) {
            report.setOPatchPatchPrereqResult(prereq, status, message);
        }
    }

    public static void setPrereqResult(OPatchPatchPrereq prereq, PrereqResult.ExecuteStatus status) {
        if (OPatchEnv.isOPatchSDKMode() && report != null) {
            report.setOPatchPatchPrereqResult(prereq, status);
        }
    }

    public static void addNApplyPatchesToReport(PatchObject[] patches) {
        if (OPatchEnv.isOPatchSDKMode() && report != null) {
            for (PatchObject patch : patches) {
                report.addNApplyPatch(patch.getPatchID());
            }
        }
    }

    public static void addNApplyPatchesToReport(String patchId) {
        if (OPatchEnv.isOPatchSDKMode() && report != null) {
            report.addNApplyPatch(patchId);
        }
    }

    public static void addNRollbackPatchesToReport(PatchObject[] patches, boolean autoRollback) {
        if (OPatchEnv.isOPatchSDKMode() && report != null) {
            for (PatchObject patch : patches) {
                report.addNRollbackPatch(patch.getPatchID(), autoRollback);
            }
        }
    }

    public static void addNRollbackPatchesToReport(String patchId, boolean autoRollback) {
        if (OPatchEnv.isOPatchSDKMode() && report != null) {
            report.addNRollbackPatch(patchId, autoRollback);
        }
    }

    public static void checkmemory(String oracleHomePath) throws RuntimeException {
        OPatchEnv.setOnline(true);
        String patchLoc = null;
        StringBuffer buff = new StringBuffer("checkMemory() ");
        buff.append("on Oracle Home ").append(oracleHomePath);
        OLogger.debug(buff);
        buff = new StringBuffer("  get patchLoc from OPatchEnv.getPatchLoc()");
        OLogger.debug(buff);
        patchLoc = OPatchEnv.getPatchloc();
        String[] patchlocArray = new String[]{patchLoc};
        if (patchLoc == null || patchLoc.equals("")) {
            buff = new StringBuffer("  patchLoc is null or empty");
            OLogger.debug(buff);
            OLogger.println(" No online patches are provided. Please use \" opatch util checkMemory -ph \" to specify the patch location and provide one single patch at one time.");
            OnlinePatchException re = new OnlinePatchException("Util \"checkMemory\" failed.");
            throw re;
        }
        OnlinePatchProcessor.handleOnlinePatch(patchlocArray);
        patchLoc = patchlocArray[0];
        PatchObject po1 = null;
        if (patchLoc != null && !patchLoc.equals("")) {
            try {
                po1 = PatchObject.getInstance(patchLoc);
            }
            catch (Exception e2) {
                OLogger.println("Unable to create Patch Object. Check if the given patch location is correct.");
                OLogger.debug(e2.getMessage());
                RuntimeException re = new RuntimeException("Util \"checkMemory\" failed.");
                throw re;
            }
            if (!po1.isOnlinePatch()) {
                OLogger.println("Given patch location is invalid. Please provide a valid online patch location.");
                RuntimeException re1 = new RuntimeException("Util \"checkMemory\" failed.");
                throw re1;
            }
        }
        try {
            PatchAction[] actions = po1.getAllActions();
            for (int i2 = 0; i2 < actions.length; ++i2) {
                if (!(actions[i2] instanceof hotpatchAction)) continue;
                ((hotpatchAction)actions[i2]).checkMemory(oracleHomePath, patchLoc);
            }
        }
        catch (Exception e3) {
            OLogger.println("\nUtil \"checkMemory\" failed.");
            RuntimeException re = new RuntimeException(e3.getMessage());
            re.setStackTrace(e3.getStackTrace());
            throw re;
        }
    }

    public static DeltaFileProcessor getDeltaFileProcessor() {
        if (deltaProcessor == null) {
            deltaProcessor = new DeltaFileProcessor(null);
        }
        return deltaProcessor;
    }

    public static void setDeltaFileProcessor(DeltaFileProcessor processor) {
        deltaProcessor = processor;
    }

    public static HashMap getApplyPrereqResults() {
        return applyPrereqResults;
    }

    public static synchronized void addApplyPrereqResult(OPatchPatchPrereq prereq, PrereqResult pRes) throws FailedPrereqException {
        int i2 = 0;
        if (pRes == null || pRes.getResult() == null) {
            i2 = 2;
        } else if (pRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
            if (OUSession.isNeedThrowThrowableOnFirstFail()) {
                throw new FailedPrereqException("Prerequisite " + pRes.toString() + " failed.");
            }
            i2 = 1;
        } else if (pRes.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED) {
            i2 = 2;
        }
        OPatchTarget.StatusCheck checkResult = new OPatchTarget.StatusCheck(i2, pRes.toString());
        OUSession.addApplyPrereqResultStatus(prereq, checkResult);
    }

    public static synchronized void addApplyPrereqResultStatus(OPatchPatchPrereq prereq, OPatchTarget.StatusCheck checkResult) {
        applyPrereqResults.put(prereq, checkResult);
    }

    public static synchronized void addPrereqResultArray(OPatchPatchPrereq prereqObject, List resultsArray) throws FailedPrereqException {
        boolean isNotExecuted = false;
        Iterator itr = resultsArray.iterator();
        boolean neCount = false;
        boolean fCount = false;
        int combinedStatus = 0;
        StringBuffer buff = new StringBuffer("");
        boolean failStatus = false;
        boolean notExecutedStatus = false;
        if (resultsArray.size() == 0) {
            notExecutedStatus = true;
        }
        while (itr.hasNext()) {
            PrereqResult pRes = (PrereqResult)itr.next();
            if (pRes == null || pRes.getResult() == null) {
                failStatus = true;
            } else if (pRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                failStatus = true;
            } else if (pRes.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED) {
                notExecutedStatus = true;
            }
            buff.append(pRes.toString());
        }
        if (failStatus) {
            if (OUSession.isNeedThrowThrowableOnFirstFail()) {
                throw new FailedPrereqException("Prerequisite " + prereqObject.toString() + " failed.");
            }
            combinedStatus = 1;
        } else if (notExecutedStatus) {
            combinedStatus = 2;
        }
        OPatchTarget.StatusCheck sc = new OPatchTarget.StatusCheck(combinedStatus, buff.toString());
        OUSession.addApplyPrereqResultStatus(prereqObject, sc);
    }

    public static boolean isNeedThrowThrowableOnFirstFail() {
        return needThrowThrowableOnFirstFail;
    }

    public static void setNeedThrowThrowableOnFirstFail(boolean needThrowThrowableOnFirstFail) {
        OUSession.needThrowThrowableOnFirstFail = needThrowThrowableOnFirstFail;
    }

    public static boolean isPhaseOneReport() {
        return phaseOneReport;
    }

    public static void setPhaseOneReport(boolean phaseOneReport) {
        OUSession.phaseOneReport = phaseOneReport;
    }

    public static Map<String, Set<String>> getFileRefCount(String oracleHomePath) {
        if (fileToPatchRefCount != null) {
            return fileToPatchRefCount;
        }
        OLogger.justlog(OLogger.INFO, "Building File to Patches reference count map.");
        IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
        readServices.lock(oracleHomePath);
        fileToPatchRefCount = new HashMap<String, Set<String>>();
        for (OneOffEntry oneOffEntry : readServices.getInstalledPatches()) {
            if (!oneOffEntry.getPatchObject().isCbccPatch()) continue;
            FileMapping fileMapping = oneOffEntry.getPatchObject().getFileMappingList();
            List<FileMapping.FileInfo> files = fileMapping.getFiles();
            for (FileMapping.FileInfo fileInfo : files) {
                String mapKey = fileMapping.getAbsPathFile(fileInfo) + "_" + fileInfo.getCheckSum();
                if (fileToPatchRefCount.containsKey(mapKey)) {
                    fileToPatchRefCount.get(mapKey).add(oneOffEntry.getPatchID());
                    continue;
                }
                HashSet<String> patchIds = new HashSet<String>();
                patchIds.add(oneOffEntry.getPatchID());
                fileToPatchRefCount.put(mapKey, patchIds);
            }
        }
        Set<String> rollbackPatchIds = OPatchUtilHelper.getNRollbackPatchIds();
        OracleHomeConflictMap conflictMap = OracleHomeConflictMap.getInstance();
        Map<String, Set<String>> supersetMap = conflictMap.getSupersetMap();
        for (OneOffEntry oneOff : readServices.getInactivePatches()) {
            boolean tobe_active = false;
            for (String patchid : rollbackPatchIds) {
                Set<String> subsets;
                if (!supersetMap.containsKey(patchid) || !(subsets = supersetMap.get(patchid)).contains(oneOff.getPatchID())) continue;
                tobe_active = true;
            }
            if (!tobe_active || !oneOff.getPatchObject().isCbccPatch()) continue;
            FileMapping fileMapping = oneOff.getPatchObject().getFileMappingList();
            List<FileMapping.FileInfo> files = fileMapping.getFiles();
            for (FileMapping.FileInfo fileInfo : files) {
                String mapKey = fileMapping.getAbsPathFile(fileInfo) + "_" + fileInfo.getCheckSum();
                if (fileToPatchRefCount.containsKey(mapKey)) {
                    fileToPatchRefCount.get(mapKey).add(oneOff.getPatchID());
                    continue;
                }
                HashSet<String> patchIds = new HashSet<String>();
                patchIds.add(oneOff.getPatchID());
                fileToPatchRefCount.put(mapKey, patchIds);
            }
        }
        if (OLogger.isDebug()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("CBCC: File to Patch mapping...\n");
            for (Map.Entry<String, Set<String>> entry : fileToPatchRefCount.entrySet()) {
                stringBuilder.append("File ");
                stringBuilder.append(entry.getKey());
                stringBuilder.append(" belongs to patches ");
                stringBuilder.append(entry.getValue());
                stringBuilder.append("\n");
            }
            OLogger.debug(stringBuilder.toString());
        }
        return fileToPatchRefCount;
    }

    public static void cleanuparchives(String oracleHomePath) {
        try {
            System.out.println("Started : Util cleauparchives session");
            PatchArchiver patchArchiverObj = new PatchArchiver();
            boolean ok = patchArchiverObj.cleanuparchives(oracleHomePath);
            if (ok) {
                OLogger.println("Cleanuparchives from secondary storage is successful.");
            } else {
                OLogger.println("Util cleanuparchives session failed with warnings. Please check log for more details");
            }
        }
        catch (Exception e2) {
            OLogger.println("UtilSession failed cleanuparchives");
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
    }

    public static void lsarchives(String oracleHomePath) {
        try {
            System.out.println("Started : Util lsarchives session");
            ListArchives lsArchiverObj = new ListArchives();
            boolean ok = lsArchiverObj.lsArchives(oracleHomePath);
            if (ok) {
                OLogger.println("lsarchives is successful.");
            } else {
                OLogger.println("Util lsarchives session failed with warnings. Please check log for more details");
            }
        }
        catch (Exception e2) {
            OLogger.println("UtilSession failed lsarchives");
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
    }

    public static void unarchive(String oracleHomePath) throws RuntimeException {
        IIPMRWServices rwServices = IPM.INSTANCE.getRWServices();
        boolean alreadyLocked = rwServices.isLocked();
        try {
            ArrayList<String> patchesList = OPatchEnv.getPatchesForUtilArchive();
            if (!alreadyLocked) {
                rwServices.lock(oracleHomePath);
            }
            OLogger.println("Unarchive given patches for given OH");
            if (patchesList.size() == 0) {
                throw new RuntimeException("Please provide valid patches.Eg: unarchive -patches P1,..,Pn");
            }
            PatchArchiver patchArchiverObj = new PatchArchiver();
            boolean ok = patchArchiverObj.unarchive(oracleHomePath, patchesList);
            if (ok) {
                String opatchPath = oracleHomePath + File.separator + "OPatch" + File.separator + "opatch";
                OLogger.println("Unarchive  session is complete");
                OLogger.println("To clean up archives from custom storage path,Run the following command :'" + opatchPath + " util cleanuparchives'");
            } else {
                OLogger.println("Util unarchive session failed with warnings. Please check log for more details");
            }
        }
        catch (Exception e2) {
            OLogger.println("UtilSession failed to unarchive the patches ");
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
    }

    public static void archive(String oracleHomePath) throws RuntimeException {
        block15: {
            OLogger.printlnOnLog("OUSession::archive()");
            IIPMRWServices rwServices = IPM.INSTANCE.getRWServices();
            boolean alreadyLocked = rwServices.isLocked();
            try {
                ArrayList<String> patchesList = OPatchEnv.getPatchesForUtilArchive();
                if (!alreadyLocked) {
                    rwServices.lock(oracleHomePath);
                }
                if (patchesList.size() == 0) {
                    throw new RuntimeException("Please provide valid patches");
                }
                ArrayList<String> listOfPatchDirs = OUSession.getPatchDirsFromGivenPatchList(WrapperFactory.getNioServiceWrapper().getPath(oracleHomePath, PATCH_STORAGE_DIR), patchesList);
                String archive_dir = OPatchEnv.getPatchArchiveDir();
                if (archive_dir == null || archive_dir.equals("") || archive_dir.isEmpty()) {
                    throw new RuntimeException("Please use '-archive_dir' option to point to the archive location.");
                }
                Path f2 = WrapperFactory.getNioServiceWrapper().getPath(archive_dir, new String[0]);
                if (!Files.exists(f2, new LinkOption[0]) || !Files.isDirectory(f2, new LinkOption[0])) {
                    OLogger.justlog(OLogger.SEVERE, "Provide valid archive directory ");
                    throw new RuntimeException("Provide valid archive directory ");
                }
                if (!Files.isWritable(f2)) {
                    OLogger.justlog(OLogger.SEVERE, "Provide archive directory which has write permission ");
                    throw new RuntimeException("Provide archive directory which has write permission ");
                }
                if (Paths.get(archive_dir, new String[0]).startsWith(WrapperFactory.getNioServiceWrapper().getPath(oracleHomePath, new String[0]))) {
                    OLogger.justlog(OLogger.SEVERE, "Archive directory should not be inside oracle_home");
                    throw new RuntimeException("Archive directory should not be inside oracle_home");
                }
                PatchArchiver patchArchiverObj = new PatchArchiver();
                int result = patchArchiverObj.archive(oracleHomePath, patchesList, archive_dir, listOfPatchDirs);
                if (result == 0) {
                    OLogger.println("Patch archive operation completed successfully.");
                    OLogger.justlog(OLogger.INFO, "Patch archive operation completed successfully.");
                    break block15;
                }
                if (result > 0) {
                    OLogger.justlog(OLogger.WARNING, "Patch archive operation completed with warnings. Check logs for details.");
                    OLogger.println("Patch archive operation completed with warnings. Check logs for details.");
                    break block15;
                }
                OLogger.println("Patch archive operation failed.");
                OLogger.justlog(OLogger.SEVERE, "Patch archive operation failed.");
                throw new RuntimeException("Patch archive operation failed.");
            }
            catch (Exception e2) {
                OLogger.println("UtilSession failed to Archive the patches ");
                OLogger.justlog(OLogger.SEVERE, "UtilSession failed to Archive the patches ");
                RuntimeException re = new RuntimeException(e2.getMessage());
                re.setStackTrace(e2.getStackTrace());
                throw re;
            }
            catch (Throwable t) {
                RuntimeException re = new RuntimeException(t.getMessage());
                throw re;
            }
            finally {
                if (!alreadyLocked) {
                    rwServices.release();
                }
            }
        }
    }

    public static void deleteinactivepatches(String oracleHomePath) {
        OLogger.printlnOnConsole("Inactive Patches Cleanup option provided");
        IIPMRWServices rwServices = IPM.INSTANCE.getRWServices();
        boolean alreadyLocked = rwServices.isLocked();
        try {
            if (!alreadyLocked) {
                rwServices.lock(oracleHomePath);
                alreadyLocked = true;
            }
            OLogger.println("Delete Inactive Patches .......");
            InactivePatchesUtil inactivePatchesUtil = new InactivePatchesUtil();
            if (OPatchEnv.isReport()) {
                inactivePatchesUtil.deletePatches(true, false);
            } else {
                inactivePatchesUtil.deletePatches(false, true);
            }
        }
        catch (Exception e2) {
            OLogger.println("Delete Inactive Patches failed");
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        finally {
            if (alreadyLocked) {
                rwServices.release();
            }
        }
    }

    public static void listorderedinactivepatches(String oracleHomePath) {
        OLogger.printlnOnConsole("List Inactive patches option provided");
        InactivePatchesUtil inactivePatchesUtil = new InactivePatchesUtil();
        inactivePatchesUtil.print();
    }

    private static ArrayList<String> getPatchDirsFromGivenPatchList(Path patchStoragePath, ArrayList<String> patchesList) {
        DirectoryStream.Filter<Path> dirFilter = OUSession.getDirectoriesFilter(patchesList);
        ArrayList<String> listOfPatchDirs = new ArrayList<String>();
        ArrayList<String> invalidPatchesList = new ArrayList<String>();
        try {
            DirectoryStream<Path> dirStream = Files.newDirectoryStream(patchStoragePath, dirFilter);
            Iterator<Path> dirStreamItr = dirStream.iterator();
            if (null == dirStreamItr || !dirStreamItr.hasNext()) {
                OLogger.log(OLogger.FINE, "There is no patchID under patchStorageDir " + patchStoragePath.toAbsolutePath().toString());
            }
            while (dirStreamItr.hasNext()) {
                Path dir = dirStreamItr.next();
                listOfPatchDirs.add(dir.getFileName().toString());
            }
            for (String patch : patchesList) {
                boolean validPatch = false;
                for (String patchDir : listOfPatchDirs) {
                    if (!patchDir.startsWith(patch)) continue;
                    validPatch = true;
                }
                if (validPatch) continue;
                invalidPatchesList.add(patch);
            }
            if (invalidPatchesList.size() > 0) {
                OLogger.justlog(OLogger.WARNING, "Following patches are invalid/not available in the .patch_storage dir : " + ((Object)invalidPatchesList).toString());
            }
        }
        catch (IOException e1) {
            OLogger.log(OLogger.SEVERE, e1.getMessage());
        }
        return listOfPatchDirs;
    }

    private static DirectoryStream.Filter<Path> getDirectoriesFilter(final ArrayList<String> patchIds) {
        DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) throws IOException {
                for (String patchId : patchIds) {
                    if (!Files.isDirectory(entry, new LinkOption[0]) || !entry.getFileName().toString().startsWith(patchId + "_")) continue;
                    return true;
                }
                return false;
            }
        };
        return filter;
    }

    public static void obfuscate(String oracleHomePath) throws RuntimeException {
        OLogger.println("PS Obfuscate OPtion provided");
        IIPMRWServices rwServices = IPM.INSTANCE.getRWServices();
        boolean alreadyLocked = rwServices.isLocked();
        try {
            ArrayList<String> patchesList = OPatchEnv.getPatchesForUtilObfuscation();
            if (!alreadyLocked) {
                rwServices.lock(oracleHomePath);
            }
            OLogger.println("Obfuscate patch storage .......");
            if (patchesList.size() == 0) {
                ObfuscationUtil.obfuscatePatchStorage();
                return;
            }
            ObfuscationUtil.obfuscatePatchStorage(patchesList);
        }
        catch (Exception e2) {
            OLogger.println("Obfuscate failed");
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
    }

    public static void deobfuscate(String oracleHomePath) throws RuntimeException {
        OLogger.println("PS De-Obfuscate OPtion provided");
        IIPMRWServices rwServices = IPM.INSTANCE.getRWServices();
        boolean alreadyLocked = rwServices.isLocked();
        try {
            ArrayList<String> patchesList = OPatchEnv.getPatchesForUtilObfuscation();
            if (!alreadyLocked) {
                rwServices.lock(oracleHomePath);
            }
            OLogger.println("De-Obfuscate patch storage .......");
            if (patchesList.size() == 0) {
                ObfuscationUtil.deobfuscatePatchStorage();
                return;
            }
            ObfuscationUtil.deobfuscatePatchStorage(patchesList);
        }
        catch (Exception e2) {
            OLogger.println("De-Obfuscate failed");
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
    }

    public static void obfuscateverify(String oracleHomePath) throws RuntimeException {
        OLogger.println("PS ObfuscateVerify OPtion provided");
        IIPMRWServices rwServices = IPM.INSTANCE.getRWServices();
        boolean alreadyLocked = rwServices.isLocked();
        try {
            ArrayList<String> patchesList = OPatchEnv.getPatchesForUtilObfuscation();
            if (!alreadyLocked) {
                rwServices.lock(oracleHomePath);
            }
            OLogger.println("ObfuscateVerify patches in patch storage .......");
            if (patchesList.size() == 0) {
                OLogger.println("No patches provided. Please provide a list of patches to verify");
                return;
            }
            ObfuscationUtil.obfuscateVerify(patchesList);
        }
        catch (Exception e2) {
            OLogger.println("ObfuscateVerify failed");
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
    }

    public static void obfuscatefile(String oracleHomePath) throws RuntimeException {
        OLogger.println("ObfuscateFile OPtion provided");
        IIPMRWServices rwServices = IPM.INSTANCE.getRWServices();
        boolean alreadyLocked = rwServices.isLocked();
        try {
            String fileLoc = OPatchEnv.getFileLoc();
            if (!alreadyLocked) {
                rwServices.lock(oracleHomePath);
            }
            OLogger.println("obfuscate a file .......");
            if (fileLoc != null && fileLoc.length() > 0) {
                ObfuscationUtil.obfuscateFile(fileLoc);
                return;
            }
            OLogger.println("File location is not specified. Please provide file location.");
            return;
        }
        catch (Exception e2) {
            OLogger.println("ObfuscateFile failed");
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
    }

    public static void deobfuscatefile(String oracleHomePath) throws RuntimeException {
        OLogger.println("deobfuscateFile OPtion provided");
        IIPMRWServices rwServices = IPM.INSTANCE.getRWServices();
        boolean alreadyLocked = rwServices.isLocked();
        try {
            String fileLoc = OPatchEnv.getFileLoc();
            if (!alreadyLocked) {
                rwServices.lock(oracleHomePath);
            }
            OLogger.println("debfuscate a file .......");
            if (fileLoc != null && fileLoc.length() > 0) {
                ObfuscationUtil.deobfuscateFile(fileLoc);
                return;
            }
            OLogger.println("File location is not specified. Please provide file location.");
            return;
        }
        catch (Exception e2) {
            OLogger.println("deobfuscateFile failed");
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
    }

    public static void getruversion(String oracleHomePath) {
        ArrayList<String> patchIds = OPatchEnv.getPatchesForUtilGetRUVersion();
        String patchLoc = OPatchEnv.getPatchLocForUtilGetRUVersion();
        OLogger.println("getRUVersion option provided");
        RHPHelper rhphelper = RHPHelperFactory.getInstance();
        RUHelper ruverhelper = RUHelperFactory.getInstance();
        String strRUVersion = "";
        if (!patchIds.isEmpty()) {
            try {
                for (int i2 = 0; i2 < patchIds.size(); ++i2) {
                    if (patchIds.size() > 1) {
                        OLogger.println(patchIds.get(i2) + ":");
                    }
                    if ((strRUVersion = ruverhelper.getRUVersionForPatchRollback(oracleHomePath, patchIds.get(i2))) != "") continue;
                    OLogger.println("Patch has NULL RU metadata");
                }
            }
            catch (Exception e2) {
                OLogger.println("getRUVersion failed");
                RuntimeException re = new RuntimeException(e2.getMessage());
                re.setStackTrace(e2.getStackTrace());
                throw re;
            }
        }
        if (patchLoc != "") {
            try {
                strRUVersion = ruverhelper.getRUVersionForPatchApply(patchLoc);
                if (strRUVersion == "") {
                    OLogger.println("Patch has NULL RU metadata");
                }
            }
            catch (Exception e3) {
                OLogger.println("getRUVersion failed");
                RuntimeException re = new RuntimeException(e3.getMessage());
                re.setStackTrace(e3.getStackTrace());
                throw re;
            }
        }
    }

    public static void getpatchcontenttype(String oracleHomePath) {
        ArrayList<String> patchIds = OPatchEnv.getPatchesForUtilGetPatchContentType();
        String patchLoc = OPatchEnv.getPatchLocForUtilGetPatchContentType();
        OLogger.println("getPatchContentType option provided");
        ContentTypeHelper contentTypeHelper = ContentTypeHelperFactory.getInstance();
        String strContentType = "";
        if (!patchIds.isEmpty()) {
            try {
                for (int i2 = 0; i2 < patchIds.size(); ++i2) {
                    if (patchIds.size() > 1) {
                        OLogger.println(patchIds.get(i2) + ":");
                    }
                    if ((strContentType = contentTypeHelper.getContentTypeForPatchRollback(oracleHomePath, patchIds.get(i2))) != "") continue;
                    OLogger.println("Patch not found in inventory");
                }
            }
            catch (Exception e2) {
                OLogger.println("getPatchContentType failed");
                RuntimeException re = new RuntimeException(e2.getMessage());
                re.setStackTrace(e2.getStackTrace());
                throw re;
            }
        }
        if (patchLoc != "") {
            try {
                strContentType = contentTypeHelper.getContentTypeForPatchApply(patchLoc);
                if (strContentType == "") {
                    OLogger.log(OLogger.INFO, "Unable to find patch information. " + patchLoc + " is either empty or unreadable.");
                }
            }
            catch (Exception e3) {
                OLogger.println("getContentType failed");
                RuntimeException re = new RuntimeException(e3.getMessage());
                re.setStackTrace(e3.getStackTrace());
                throw re;
            }
        }
    }

    static {
        baseDir = false;
        phBaseFile = false;
        PATCH_STORAGE_DIR = ".patch_storage";
        report = null;
        deltaProcessor = null;
        applyPrereqResults = new HashMap();
        phaseOneReport = false;
        cachePatchLocs = null;
    }
}

