/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchutil;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Properties;
import oracle.opatch.MergedPatchObject;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.PatchObject;
import oracle.opatch.PatchObjectUtil;
import oracle.opatch.RacFileCreator;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.wrappers.WrapperFactory;

public class RacFileMerger {
    protected static void createMPFinal(String oracleHomePath, String cookedPatchID, PatchObject[] patchObjects) throws RuntimeException {
        StringBuffer tmp = new StringBuffer("RacFileMerger::createMPFinal for all patches");
        OLogger.debug(tmp);
        try {
            OPatchSessionHelper.checkArrayForNull("PatchObject", patchObjects);
        }
        catch (NullPointerException e2) {
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        tmp = new StringBuffer("  generate MP file for ");
        tmp.append(patchObjects.length);
        tmp.append(" patches.");
        try {
            OPatchSessionHelper.createMPFinal(oracleHomePath, cookedPatchID, patchObjects);
        }
        catch (IOException e3) {
            RuntimeException re = new RuntimeException(e3.getMessage());
            re.setStackTrace(e3.getStackTrace());
            throw re;
        }
    }

    private static void checkDirectoryForReadWrite(String caller, String whereToCreate) throws IOException {
        Path dest = WrapperFactory.getNioServiceWrapper().getPath(whereToCreate, new String[0]);
        if (Files.exists(dest, new LinkOption[0]) && Files.isRegularFile(dest, new LinkOption[0])) {
            throw new IOException(caller + ": \"" + whereToCreate + "\" is a file");
        }
        if (!Files.exists(dest, new LinkOption[0])) {
            try {
                Files.createDirectories(dest, new FileAttribute[0]);
            }
            catch (Exception e2) {
                OLogger.debug(e2.getMessage());
            }
        }
        if (!Files.exists(dest, new LinkOption[0])) {
            throw new IOException(caller + ": Cannot mkdir \"" + whereToCreate + "\"");
        }
    }

    private static void checkFileForRead(String caller, String whereToRead) throws IOException {
        Path dest = WrapperFactory.getNioServiceWrapper().getPath(whereToRead, new String[0]);
        if (Files.exists(dest, new LinkOption[0]) && !Files.isRegularFile(dest, new LinkOption[0]) && !Files.isReadable(dest)) {
            throw new IOException(caller + ": \"" + whereToRead + "\" is not a file");
        }
    }

    private static void createFile(String oracleHomePath, String cookedPatchID, PatchObject[] patchObjects, int code) throws IOException {
        if (oracleHomePath == null || cookedPatchID == null) {
            throw new IOException("RacFileMerger::createFile() was called with Null argument");
        }
        try {
            OPatchSessionHelper.checkArrayForNull("PatchObject", patchObjects);
        }
        catch (NullPointerException e2) {
            StringBuffer msg = new StringBuffer("RacFileMerger::createFile(): the PatchObect[] contains null entry: ");
            msg.append(e2.getMessage());
            IOException io = new IOException(msg.toString());
            io.setStackTrace(e2.getStackTrace());
            throw io;
        }
        if (code != 20 && code != 22 && code != 21 && code != 23 && code != 24) {
            throw new IOException("RacFileMerger::createFile() was called with wrong code.");
        }
        StringBuffer rac = new StringBuffer(oracleHomePath);
        rac.append(File.separator);
        rac.append(OPatchEnv.getPatchStorageName());
        rac.append(File.separator);
        rac.append(cookedPatchID);
        rac.append(File.separator);
        rac.append(OPatchEnv.getRacSubdirName());
        RacFileMerger.checkDirectoryForReadWrite("RacFileMerger::createFile()", rac.toString());
        String name = "";
        switch (code) {
            case 20: {
                name = RacFileCreator.getFPFinalName();
                break;
            }
            case 22: {
                name = RacFileCreator.getDPFinalName();
                break;
            }
            case 21: {
                name = RacFileCreator.getFRFinalName();
                break;
            }
            case 23: {
                name = RacFileCreator.getDRFinalName();
                break;
            }
            case 24: {
                name = RacFileCreator.getRCFinalName();
                break;
            }
            default: {
                name = "";
            }
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i2 = 0; i2 < patchObjects.length; ++i2) {
            PatchObject po = patchObjects[i2];
            String racArea = po.getRacFileArea(oracleHomePath);
            Path racDir = WrapperFactory.getNioServiceWrapper().getPath(racArea, new String[0]);
            if (!Files.exists(racDir, new LinkOption[0]) || !Files.isDirectory(racDir, new LinkOption[0])) continue;
            StringBuffer targetFile = new StringBuffer(racArea);
            if (!racArea.endsWith(File.separator)) {
                targetFile.append(File.separator);
            }
            targetFile.append(name);
            Path f2 = WrapperFactory.getNioServiceWrapper().getPath(targetFile.toString(), new String[0]);
            if (!Files.exists(f2, new LinkOption[0]) || !Files.isReadable(f2)) continue;
            list.add(targetFile.toString());
        }
        int len = list.size();
        String[] sourceFiles = new String[len];
        for (int i3 = 0; i3 < len; ++i3) {
            String file;
            Object obj = list.get(i3);
            if (!(obj instanceof String)) continue;
            sourceFiles[i3] = file = (String)obj;
        }
        if (sourceFiles.length != 0) {
            RacFileCreator.mergeFiles(oracleHomePath, cookedPatchID, sourceFiles, code);
        }
    }

    public static void createModeFile(String oracleHomePath, String cookedPatchID, String mode) throws IOException {
        if (oracleHomePath == null || cookedPatchID == null || mode == null) {
            throw new IOException("RacFileMerger::createModeFile: Null value in argument.");
        }
        StringBuffer whereToCreate = new StringBuffer(oracleHomePath);
        whereToCreate.append(File.separator);
        whereToCreate.append(OPatchEnv.getPatchStorageName());
        whereToCreate.append(File.separator);
        whereToCreate.append(cookedPatchID);
        whereToCreate.append(File.separator);
        whereToCreate.append(OPatchEnv.getRacSubdirName());
        RacFileMerger.checkDirectoryForReadWrite("RacFileMerger::createModeFile()", whereToCreate.toString());
        StringBuffer fileName = new StringBuffer(whereToCreate.toString());
        if (!fileName.toString().endsWith(File.separator)) {
            fileName.append(File.separator);
        }
        String modetxt = OPatchEnv.getModeFileName();
        fileName.append(modetxt);
        BufferedWriter bw = Files.newBufferedWriter(WrapperFactory.getNioServiceWrapper().getPath(fileName.toString(), new String[0]), Charset.forName("UTF-8"), new OpenOption[0]);
        bw.close();
    }

    public static void createCopyFile(String oracleHomePath, String cookedPatchID, PatchObject[] patchObjects) throws IOException {
        RacFileMerger.createFile(oracleHomePath, cookedPatchID, patchObjects, 20);
    }

    public static void createCopyDir(String oracleHomePath, String cookedPatchID, PatchObject[] patchObjects) throws IOException {
        RacFileMerger.createFile(oracleHomePath, cookedPatchID, patchObjects, 22);
    }

    public static void createRemoveFile(String oracleHomePath, String cookedPatchID, PatchObject[] patchObjects) throws IOException {
        RacFileMerger.createFile(oracleHomePath, cookedPatchID, patchObjects, 21);
    }

    public static void createRemoveDir(String oracleHomePath, String cookedPatchID, PatchObject[] patchObjects) throws IOException {
        RacFileMerger.createFile(oracleHomePath, cookedPatchID, patchObjects, 23);
    }

    public static void createRemoteCommandFile(String oracleHomePath, String cookedPatchID, PatchObject[] patchObjects) throws IOException {
        RacFileMerger.createFile(oracleHomePath, cookedPatchID, patchObjects, 24);
    }

    public static void createMakeFile(String oracleHomePath, String cookedPatchID, PatchObject[] patchObjects) throws IOException {
        StringBuffer whereToCreate = new StringBuffer(oracleHomePath);
        whereToCreate.append(File.separator);
        whereToCreate.append(OPatchEnv.getPatchStorageName());
        whereToCreate.append(File.separator);
        whereToCreate.append(cookedPatchID);
        whereToCreate.append(File.separator);
        whereToCreate.append(OPatchEnv.getRacSubdirName());
        RacFileMerger.checkDirectoryForReadWrite("RacFileMerger::createModeFile()", whereToCreate.toString());
        OPatchSessionHelper.createMPFinal(oracleHomePath, cookedPatchID, patchObjects);
    }

    public static void main(String[] args) throws IOException, InstantiationException {
        PatchObject p614;
        PatchObject p100;
        PatchObject p20;
        PatchObject p1;
        Properties prop = new Properties();
        prop.setProperty("OPatch.DEBUG", "TRUE");
        StringBuffer tmp = new StringBuffer("PatchList::main()");
        OLogger.debug(tmp);
        String patchLocPtr = "/scratch/phnguyen/OracleHome/10.2/home1/inventory/oneoffs";
        String oracleHomePath = "/scratch/phnguyen/OracleHome/10.2/home1";
        String cookedPatchID = "nApply";
        String[] patchIDs = new String[]{"1", "100", "20", "614"};
        tmp = new StringBuffer(" instantiating a PatchList object");
        OLogger.debug(tmp);
        String sessionName = OPatchEnv.getNApplySessionName();
        try {
            MergedPatchObject mpo = new MergedPatchObject(sessionName);
            p1 = PatchObjectUtil.loadPatch(patchLocPtr + File.separator + "1");
            p20 = PatchObjectUtil.loadPatch(patchLocPtr + File.separator + "20");
            p100 = PatchObjectUtil.loadPatch(patchLocPtr + File.separator + "100");
            p614 = PatchObjectUtil.loadPatch(patchLocPtr + File.separator + "614");
        }
        catch (RuntimeException e2) {
            IOException io = new IOException(e2.getMessage());
            io.setStackTrace(e2.getStackTrace());
            throw io;
        }
        PatchObject[] patchObjects = new PatchObject[]{p1, p20, p100, p614};
        String mode = "apply";
        RacFileMerger.createModeFile(oracleHomePath, cookedPatchID, mode);
        RacFileMerger.createCopyFile(oracleHomePath, cookedPatchID, patchObjects);
        RacFileMerger.createCopyDir(oracleHomePath, cookedPatchID, patchObjects);
        RacFileMerger.createRemoveFile(oracleHomePath, cookedPatchID, patchObjects);
        RacFileMerger.createRemoveDir(oracleHomePath, cookedPatchID, patchObjects);
        RacFileMerger.createMakeFile(oracleHomePath, cookedPatchID, patchObjects);
    }
}

