/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchutil;

import java.lang.reflect.Method;
import oracle.opatch.Crs;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchExternalFactory;
import oracle.opatch.Rac;
import oracle.opatch.opatchlogger.OLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;

public class SrvmUtil {
    protected static void lsNodes(String oracleHomePath) {
        StringBuffer buff = new StringBuffer("SrvmUtil::lsNodes called()");
        OLogger.debug(buff);
        String[] nodes = new String[]{};
        boolean isStackRunning = false;
        boolean share = false;
        String gridHome = "";
        Crs.CrsType type = null;
        Rac rac = OPatchExternalFactory.getRac(oracleHomePath);
        try {
            Crs crs = OPatchExternalFactory.getCrs(oracleHomePath).getInstance(oracleHomePath);
            gridHome = crs.getGridHome();
            type = crs.getCrsType();
            buff = new StringBuffer(" Detect the clusterware type as [ ");
            buff.append((Object)type);
            buff.append(" ]");
            OLogger.debug(buff);
            buff = new StringBuffer(" Detect Grid Home as ");
            buff.append(gridHome);
            OLogger.debug(buff);
            if (type != Crs.CrsType.NONE) {
                isStackRunning = crs.isStackRunning();
            }
            buff = new StringBuffer(" Status of stack is running or not ? ");
            buff.append(isStackRunning);
            OLogger.debug(buff);
            if (type == Crs.CrsType.CRS && isStackRunning && (nodes = crs.getClusterNodeList(oracleHomePath)) != null && nodes.length > 0) {
                share = rac.isCFS(oracleHomePath, nodes, nodes[0]);
            }
        }
        catch (IllegalAccessException crs) {
        }
        catch (Throwable e2) {
            RuntimeException re = new RuntimeException(e2);
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        buff = new StringBuffer();
        for (String node : nodes) {
            buff.append(node + " ");
        }
        OLogger.printlnres("OUI-68009", new Object[]{gridHome, type, isStackRunning, buff.toString(), share});
    }

    public static void isSpaceAvailable(String oracleHomePath) {
        try {
            long spaceNeeded = OPatchEnv.getSpaceNeeded();
            if (OiipgFileSystem.isSpaceAvailable((long)spaceNeeded, (String)oracleHomePath)) {
                OLogger.println("true");
            } else {
                OLogger.println("false");
            }
        }
        catch (Throwable t) {
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
    }

    public static boolean checkMethod(String methodName) {
        boolean foundFlag = false;
        try {
            Class<?> chkClass = Class.forName(SrvmUtil.class.getName());
            Method[] methods = chkClass.getDeclaredMethods();
            for (int i2 = 0; i2 < methods.length; ++i2) {
                if (!methods[i2].getName().equalsIgnoreCase(methodName)) continue;
                foundFlag = true;
            }
        }
        catch (Exception e2) {
            return false;
        }
        return foundFlag;
    }
}

