/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchutil;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Properties;
import oracle.opatch.ExitOPatchException;
import oracle.opatch.OPatchACL;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchExternalFactory;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchObject;
import oracle.opatch.PrereqSession;
import oracle.opatch.Rac;
import oracle.opatch.RacFileCreator;
import oracle.opatch.RacProcessor;
import oracle.opatch.RacSrvm;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.opatchactions.hotpatchAction;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchutil.OUSessionHelper;
import oracle.opatch.wrappers.WrapperFactory;

public class UpdateRemoteNodes {
    private UpdateRemoteNodes() {
    }

    protected static void process(String oracleHomePath) throws RuntimeException, Error {
        String FP = null;
        String DP = null;
        String FR = null;
        String DR = null;
        String MP = null;
        String RC = null;
        OLogger.println("This option will propagate patch to given set of nodes.");
        String[] nodes = OUSessionHelper.readNodes();
        if (nodes == null || nodes.length == 0) {
            StringBuffer buff = new StringBuffer("There are no nodes to update.  ");
            buff.append("Remote nodes have not been modified.");
            throw new RuntimeException(buff.toString());
        }
        String nodesStr = RacProcessor.getNodesString(nodes);
        String patchStorageRac = null;
        try {
            patchStorageRac = OUSessionHelper.readRacLocation(oracleHomePath);
        }
        catch (IOException e2) {
            StringBuffer buff = new StringBuffer(e2.getMessage());
            buff.append("  ");
            buff.append("Remote nodes have not been modified.");
            RuntimeException re = new RuntimeException(buff.toString());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        catch (ExitOPatchException e3) {
            return;
        }
        boolean apply = true;
        boolean rollback = false;
        boolean auto_rollback = false;
        try {
            String fpStr = RacFileCreator.getFPFinalName(patchStorageRac);
            String dpStr = RacFileCreator.getDPFinalName(patchStorageRac);
            String frStr = RacFileCreator.getFRFinalName(patchStorageRac);
            String drStr = RacFileCreator.getDRFinalName(patchStorageRac);
            String mpStr = RacFileCreator.getMPFinalName(patchStorageRac);
            String rcStr = RacFileCreator.getRCFinalName(patchStorageRac);
            Path file = WrapperFactory.getNioServiceWrapper().getPath(fpStr, new String[0]);
            FP = !Files.exists(file, new LinkOption[0]) ? null : file.toRealPath(new LinkOption[0]).toString();
            file = WrapperFactory.getNioServiceWrapper().getPath(rcStr, new String[0]);
            RC = !Files.exists(file, new LinkOption[0]) ? null : file.toRealPath(new LinkOption[0]).toString();
            file = WrapperFactory.getNioServiceWrapper().getPath(dpStr, new String[0]);
            DP = !Files.exists(file, new LinkOption[0]) ? null : file.toRealPath(new LinkOption[0]).toString();
            file = WrapperFactory.getNioServiceWrapper().getPath(frStr, new String[0]);
            FR = !Files.exists(file, new LinkOption[0]) ? null : file.toRealPath(new LinkOption[0]).toString();
            file = WrapperFactory.getNioServiceWrapper().getPath(drStr, new String[0]);
            DR = !Files.exists(file, new LinkOption[0]) ? null : file.toRealPath(new LinkOption[0]).toString();
            file = WrapperFactory.getNioServiceWrapper().getPath(mpStr, new String[0]);
            MP = !Files.exists(file, new LinkOption[0]) ? null : file.toRealPath(new LinkOption[0]).toString();
            String racModeFile = OPatchEnv.getPatchStorageRacModeFile(patchStorageRac);
            Path fMode = WrapperFactory.getNioServiceWrapper().getPath(racModeFile, new String[0]);
            boolean useFilesToDeduct = true;
            if (Files.exists(fMode, new LinkOption[0])) {
                BufferedReader br = Files.newBufferedReader(fMode, Charset.forName("UTF-8"));
                String entry = null;
                while ((entry = br.readLine()) != null) {
                    if (entry.equalsIgnoreCase("apply")) {
                        OLogger.println("Mode file: Apply Session");
                        useFilesToDeduct = false;
                        apply = true;
                        rollback = false;
                        auto_rollback = false;
                        continue;
                    }
                    if (entry.equalsIgnoreCase("rollback")) {
                        OLogger.println("Mode file: Rollback Session");
                        useFilesToDeduct = false;
                        apply = false;
                        rollback = true;
                        auto_rollback = false;
                        continue;
                    }
                    if (!entry.equalsIgnoreCase("auto rolled back")) continue;
                    OLogger.println("Mode file: Apply Sesion with auto-rollback");
                    useFilesToDeduct = false;
                    apply = true;
                    rollback = false;
                    auto_rollback = true;
                }
            }
            if (useFilesToDeduct) {
                if (DP != null) {
                    apply = true;
                    rollback = false;
                    auto_rollback = DR != null;
                } else {
                    rollback = true;
                    apply = false;
                    auto_rollback = false;
                }
            }
        }
        catch (IOException e4) {
            StringBuffer buff = new StringBuffer(e4.getMessage());
            buff.append("  ");
            buff.append("Remote nodes have not been modified.");
            RuntimeException re = new RuntimeException(buff.toString());
            re.setStackTrace(e4.getStackTrace());
            throw re;
        }
        try {
            RacSrvm racSrvm = OPatchExternalFactory.getRacSrvm(oracleHomePath);
            racSrvm.updateRemoteNodes(oracleHomePath, nodes, apply, rollback, auto_rollback, FP, DP, FR, DR, MP, RC, patchStorageRac, null, null, "", true, true);
        }
        catch (RuntimeException e5) {
            StringBuffer buff = new StringBuffer(e5.getMessage());
            buff.append("  ");
            buff.append("Remote nodes have been modified.");
            Error err = new Error(buff.toString());
            err.setStackTrace(e5.getStackTrace());
            throw err;
        }
    }

    protected static void enableOnlinePatch(String oracleHomePath, PatchObject patchObject) throws RuntimeException {
        hotpatchAction ha;
        PatchAction pAction;
        int i2;
        Rac.RacType racType = null;
        boolean ok = OPatchEnv.setupOnlinePropertyFile(oracleHomePath);
        Rac rac = OPatchExternalFactory.getRac(oracleHomePath);
        if (!ok) {
            throw new RuntimeException("Unable to setup online patch properties file.");
        }
        try {
            IIPMReadServices readServices = PrereqSession.getReadServices(oracleHomePath);
            racType = rac.getInstance(readServices);
        }
        catch (RuntimeException e2) {
            throw e2;
        }
        catch (Throwable t) {
            RuntimeException re = new RuntimeException(t);
            throw re;
        }
        String localNode = racType.getLocalNode();
        String[] remoteNodes = racType.getRemoteNodes();
        try {
            OPatchACL.setLocalNode(new UpdateRemoteNodes(), localNode);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        PatchAction[] pa = patchObject.getAllIncludedActions();
        for (i2 = 0; i2 < pa.length; ++i2) {
            pAction = pa[i2];
            if (!(pAction instanceof hotpatchAction)) continue;
            ha = (hotpatchAction)pAction;
            boolean success = ha.updateDBInstances(oracleHomePath, ha.APPLY_MODE);
            if (success) {
                OPatchSessionHelper.setOnlinePropertyToFile(oracleHomePath, OPatchEnv.getLocalNode(), patchObject.getPatchID());
                continue;
            }
            throw new RuntimeException("Apply of Online Patch failed on some SIDs.");
        }
        if (rac.shouldRemoteRun(racType)) {
            for (i2 = 0; i2 < pa.length; ++i2) {
                pAction = pa[i2];
                if (!(pAction instanceof hotpatchAction)) continue;
                ha = (hotpatchAction)pAction;
                ha.runRemoteCommand(oracleHomePath, true, patchObject.getPatchID(), remoteNodes, localNode);
            }
        }
    }

    protected static void disableOnlinePatch(String oracleHomePath, PatchObject patchObject) {
        hotpatchAction ha;
        PatchAction pAction;
        int i2;
        Rac.RacType racType = null;
        Rac rac = OPatchExternalFactory.getRac(oracleHomePath);
        try {
            IIPMReadServices readServices = PrereqSession.getReadServices(oracleHomePath);
            racType = rac.getInstance(readServices);
        }
        catch (RuntimeException e2) {
            throw e2;
        }
        catch (Throwable t) {
            RuntimeException re = new RuntimeException(t);
            throw re;
        }
        String localNode = racType.getLocalNode();
        String[] remoteNodes = racType.getRemoteNodes();
        try {
            OPatchACL.setLocalNode(new UpdateRemoteNodes(), localNode);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        PatchAction[] pa = patchObject.getAllIncludedActions();
        for (i2 = 0; i2 < pa.length; ++i2) {
            pAction = pa[i2];
            if (!(pAction instanceof hotpatchAction)) continue;
            ha = (hotpatchAction)pAction;
            boolean success = ha.updateDBInstances(oracleHomePath, ha.ROLLBACK_MODE);
            if (success) {
                PatchObject[] pArray = new PatchObject[]{patchObject};
                Properties onlineProp = OPatchSessionHelper.getOnlinePropertyFromFile(oracleHomePath);
                OPatchSessionHelper.removeOnlineRollbackSids(onlineProp, pArray, OPatchEnv.getLocalNode(), oracleHomePath);
                continue;
            }
            throw new RuntimeException("Rollback of Online Patch failed on some SIDs.");
        }
        if (rac.shouldRemoteRun(racType)) {
            for (i2 = 0; i2 < pa.length; ++i2) {
                pAction = pa[i2];
                if (!(pAction instanceof hotpatchAction)) continue;
                ha = (hotpatchAction)pAction;
                ha.runRemoteCommand(oracleHomePath, false, patchObject.getCookedPatchID(), remoteNodes, localNode);
            }
        }
    }
}

