/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchutil.archive;

import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.TreeMap;
import oracle.glcm.opatch.common.api.Utility;
import oracle.opatch.opatchlogger.OLogger;

public class DirChecksumCalculator {
    private TreeMap<String, String> sortedFileMap = new TreeMap();

    private void dirSha1Sum(String dir, int algo) throws NoSuchAlgorithmException {
        File folder = new File(dir);
        if (folder.isDirectory() && folder.exists()) {
            File[] files = folder.listFiles();
            if (files.length == 0) {
                this.sortedFileMap.put(folder.getAbsolutePath(), "0");
            }
            for (int i2 = 0; i2 < files.length; ++i2) {
                try {
                    if (files[i2].isDirectory()) {
                        this.dirSha1Sum(files[i2].toString(), algo);
                        continue;
                    }
                    if (algo == 1) {
                        this.sortedFileMap.put(files[i2].getAbsolutePath(), Utility.getSha256sum((File)files[i2]));
                        continue;
                    }
                    this.sortedFileMap.put(files[i2].getAbsolutePath(), Utility.getSha1sum((File)files[i2]));
                    continue;
                }
                catch (IOException e2) {
                    OLogger.justlog(OLogger.SEVERE, "DirChecksumCalculator :: dirSha1Sum() :: failed.");
                }
            }
        }
    }

    public String sha1sumForDirectory(String dir, int algo) throws NoSuchAlgorithmException {
        this.dirSha1Sum(dir, algo);
        String combinedSha1sum = "";
        for (String sha1sumOfFile : this.sortedFileMap.keySet()) {
            combinedSha1sum = combinedSha1sum + this.sortedFileMap.get(sha1sumOfFile);
        }
        if (combinedSha1sum != null && combinedSha1sum.length() > 0) {
            combinedSha1sum = DirChecksumCalculator.GetSha1SumHashOfString(combinedSha1sum);
        }
        return combinedSha1sum;
    }

    public static String GetSha1SumHashOfString(String str) throws NoSuchAlgorithmException {
        StringBuffer hexString = new StringBuffer();
        MessageDigest md5 = MessageDigest.getInstance("SHA-256");
        md5.reset();
        md5.update(str.getBytes());
        byte[] messageDigest = md5.digest();
        for (int i2 = 0; i2 < messageDigest.length; ++i2) {
            hexString.append(Integer.toHexString((0xF0 & messageDigest[i2]) >> 4));
            hexString.append(Integer.toHexString(0xF & messageDigest[i2]));
        }
        return hexString.toString();
    }
}

