/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchutil.archive;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchutil.archive.PatchArchiver;
import oracle.opatch.opatchutil.archive.jaxb.FileMetaData;
import oracle.opatch.opatchutil.archive.jaxb.PatchArchive;
import oracle.opatch.opatchutil.archive.jaxb.PatchArchives;

public class ListArchives {
    public boolean lsArchives(String oracleHomePath) {
        boolean isSuccess = false;
        HashMap<String, ArrayList<String>> archivedPatchMap = new HashMap<String, ArrayList<String>>();
        PatchArchiver patchArchiver = new PatchArchiver();
        if (patchArchiver.isPatchArchiveMappingFilePresent(oracleHomePath)) {
            PatchArchives patchArchives = patchArchiver.readPatchArchiveMappingFile(oracleHomePath);
            if (patchArchives != null && patchArchives.getPatchArchive().size() > 0) {
                for (PatchArchive patchArchive : patchArchives.getPatchArchive()) {
                    String patchId = patchArchive.getPatchId();
                    if (patchArchive.getFileMetadata().size() <= 0) continue;
                    for (FileMetaData fileMetadata : patchArchive.getFileMetadata()) {
                        if (fileMetadata.isUnarchived()) continue;
                        if (!archivedPatchMap.containsKey(patchId)) {
                            archivedPatchMap.put(patchId, new ArrayList());
                        }
                        String archivedPath = fileMetadata.getSecondaryPatchstoragePath() + File.separator + fileMetadata.getName();
                        ((ArrayList)archivedPatchMap.get(patchId)).add(archivedPath);
                    }
                }
                isSuccess = true;
                this.printArchivedPatchesInfo(archivedPatchMap);
            } else {
                OLogger.printlnOnLog(OLogger.SEVERE, "Error while retrieving the patch archive information.");
            }
        } else {
            OLogger.println("\n Patches are not archived in given oracle_home.\n");
            isSuccess = true;
        }
        return isSuccess;
    }

    private void printArchivedPatchesInfo(Map<String, ArrayList<String>> archivedPatchMap) {
        if (!archivedPatchMap.isEmpty()) {
            OLogger.println("---------------------------------------------------------\n");
            OLogger.println("Archived patches :\n");
            for (String patchId : archivedPatchMap.keySet()) {
                OLogger.println("Patch : " + patchId);
                if (!archivedPatchMap.get(patchId).isEmpty()) {
                    for (String path : archivedPatchMap.get(patchId)) {
                        OLogger.println("Archived path : " + path);
                    }
                }
                OLogger.println("\n");
            }
            OLogger.println("---------------------------------------------------------\n");
        } else {
            OLogger.println("\nPatches are not in archived state.\n");
        }
    }
}

