/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchutil.archive;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import oracle.glcm.opatch.common.api.Utility;
import oracle.opatch.HelpSession;
import oracle.opatch.OPatchACL;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.PatchObject;
import oracle.opatch.SystemCall;
import oracle.opatch.ZipUtilities;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchutil.archive.DirChecksumCalculator;
import oracle.opatch.opatchutil.archive.PatchArchiveJaxbBinder;
import oracle.opatch.opatchutil.archive.PatchArchiveXmlException;
import oracle.opatch.opatchutil.archive.PatchManager;
import oracle.opatch.opatchutil.archive.jaxb.FileMetaData;
import oracle.opatch.opatchutil.archive.jaxb.PatchArchive;
import oracle.opatch.opatchutil.archive.jaxb.PatchArchives;
import oracle.opatch.wrappers.WrapperFactory;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import org.apache.commons.compress.archivers.ArchiveException;

public class PatchArchiver {
    private String PATCH_STORAGE_DIR = ".patch_storage";
    private Map<String, String> patchDirSpaceMap = new HashMap<String, String>();
    private Map<String, List<PatchManager>> processedPatchIdMap = new HashMap<String, List<PatchManager>>();
    private PatchArchives patchArchives = null;
    private boolean isMappingFilePresent = false;
    private List<String> skippedPatches = new ArrayList<String>();
    private List<FileMetaData> processPatches_unarchive = new ArrayList<FileMetaData>();
    private Path patchArchiveUnzipPath;
    private boolean hasUpdated = false;
    private String archive_operation = "archive";
    private String unarchive_operation = "unarchive";
    private String cleanup_operation = "cleanuparchives";
    private String oracleHomePath = "";

    public String calculateCheckSum(Path patchDir, int algo) {
        OLogger.justlog(OLogger.INFO, "PatchArchiver :: calculateCheckSum()");
        String checkSum = "";
        try {
            File file;
            if (patchDir != null && (file = patchDir.toFile()).exists() && file.canRead() && !file.isDirectory()) {
                checkSum = algo == 0 ? Utility.getSha1sum((File)file) : Utility.getSha256sum((File)file);
            }
        }
        catch (Exception e2) {
            checkSum = "";
            OLogger.justlog(OLogger.SEVERE, "PatchArchiver :: calculateCheckSum() :: failed.");
        }
        OLogger.justlog(OLogger.INFO, "PatchArchiver :: calculateCheckSum() :: Done.");
        return checkSum;
    }

    public boolean unzipAndValidateArchivedPatch(Path srcDirTobeArchived, Path destLocation, long srcFileSize) {
        OLogger.justlog(OLogger.INFO, "PatchArchiver :: unzipAndValidateArchivedPatch()");
        String topLevelDir = "";
        boolean isUnzipSuccess = false;
        System.out.println("src = " + srcDirTobeArchived + "::" + destLocation.toString() + "::" + srcFileSize);
        if (srcDirTobeArchived.toString() != null && destLocation.toString() != null && !srcDirTobeArchived.toString().endsWith(".zip")) {
            OLogger.justlog(OLogger.SEVERE, "Not a valid archive file");
            System.out.println("Not a valid archive file");
        }
        if (!(Files.isReadable(srcDirTobeArchived) && Files.isDirectory(destLocation, new LinkOption[0]) && Files.isWritable(destLocation))) {
            OLogger.justlog(OLogger.SEVERE, "Unable to unzip the archived directory.Check the permissions." + destLocation.toString());
            System.out.println("Unable to unzip the archived directory.Check the permissions." + destLocation.toString());
            return isUnzipSuccess;
        }
        topLevelDir = ZipUtilities.unzip(srcDirTobeArchived.toString(), destLocation.toString());
        System.out.println(topLevelDir);
        Path unzippedPath = WrapperFactory.getNioServiceWrapper().getPath(destLocation.toString(), topLevelDir);
        System.out.println("unzippedPath = " + unzippedPath.toString());
        try {
            if (Files.isDirectory(unzippedPath, new LinkOption[0]) && Files.list(unzippedPath).findAny().isPresent()) {
                OLogger.justlog(OLogger.INFO, "it has unzipped the dir");
                System.out.println("it has unzipped the dir" + unzippedPath.toString());
                long fileSize = 0L;
                fileSize = this.getSpaceUsedInBytes(unzippedPath.toString());
                if (fileSize == srcFileSize) {
                    OLogger.justlog(OLogger.WARNING, "unzipped patch archive dir size does not match with source");
                    System.out.println("unzipped patch archive dir size matches with source");
                    return true;
                }
            } else {
                OLogger.justlog(OLogger.WARNING, "unzip dir does not exists");
                System.out.println("unzip dir does not exists");
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return isUnzipSuccess;
    }

    public boolean spaceAndFilePermissionForUtilArchive(String patchStorageDir, List<String> listOfPatchDirs, String destPath) {
        OLogger.justlog(OLogger.INFO, "PatchArchiver::spaceAndFilePermissionForUtilArchive()");
        boolean isSuccess = false;
        if (!Files.isWritable(WrapperFactory.getNioServiceWrapper().getPath(destPath, new String[0]))) {
            OLogger.justlog(OLogger.SEVERE, "Archive directory: " + destPath + " has does not have permission to archive the patches");
            return isSuccess;
        }
        OLogger.justlog(OLogger.INFO, "Archive directory: " + destPath + " has required permission to archive the patches");
        long totalSpaceNeeded = 0L;
        for (String patchDirName : listOfPatchDirs) {
            Path patchPath = WrapperFactory.getNioServiceWrapper().getPath(patchStorageDir, patchDirName);
            if (!Files.isDirectory(WrapperFactory.getNioServiceWrapper().getPath(patchStorageDir, patchDirName), new LinkOption[0])) continue;
            long patchDirSpace = this.getSpaceUsedInBytes(patchPath.toString());
            totalSpaceNeeded += patchDirSpace;
            OLogger.justlog(OLogger.INFO, "Space for patch :: " + patchPath + " :: " + patchDirSpace);
            this.patchDirSpaceMap.put(patchPath.toString(), String.valueOf(patchDirSpace));
        }
        OLogger.justlog(OLogger.INFO, "Archive directory: " + destPath + " needs " + totalSpaceNeeded + " bytes.");
        boolean hasenoughSpaceInDest = OiipgFileSystem.isSpaceAvailable((long)totalSpaceNeeded, (String)destPath);
        if (hasenoughSpaceInDest && this.patchDirSpaceMap.size() > 0) {
            OLogger.justlog(OLogger.INFO, "Archive directory: " + destPath + " has required space to archive the patches.");
            isSuccess = true;
        } else {
            isSuccess = false;
            OLogger.justlog(OLogger.SEVERE, " No space to archive given patches in " + destPath);
        }
        return isSuccess;
    }

    public static void main(String[] args) throws Throwable {
        HelpSession INIT = new HelpSession();
        try {
            OPatchACL.invokeOLogger(INIT, "enableConsoleOutput", null);
        }
        catch (IllegalAccessException e2) {
            e2.printStackTrace();
        }
        PatchArchiver p2 = new PatchArchiver();
        Path path = Paths.get("/scratch/app/123/product/11.2.0/dbhome_1/.patch_storage/202041_Aug_5_2020_08_03_02.zip", new String[0]);
        Path path1 = Paths.get("/scratch/app/123/product/11.2.0/dbhome_1/.patch_storage/202041_Aug_5_2020_08_03_02", new String[0]);
        long dirSize = p2.getSpaceUsedInBytes(path1.toFile().toString());
        System.out.println("dir : " + path.toString());
        System.out.println("dir size : " + dirSize);
        boolean isValid = p2.unzipAndValidateArchivedPatch(path, Paths.get("/scratch/tmp123", new String[0]), dirSize);
        if (isValid) {
            System.out.println("file size is same");
        }
    }

    public boolean deleteZipFromSecondaryPatchStorage(Path deletezip) {
        boolean success = true;
        if (!Files.isDirectory(deletezip, new LinkOption[0])) {
            try {
                Files.deleteIfExists(deletezip);
            }
            catch (IOException e2) {
                success = false;
            }
            if (!success) {
                OLogger.printlnOnLogAndVerbose("File \"" + deletezip + "\" could not be deleted");
            } else {
                OLogger.printlnOnLogAndVerbose("Deleted the file \"" + deletezip + "\"");
            }
        }
        return success;
    }

    public boolean cleanuparchives(String oracleHomePath) {
        boolean finalResult;
        block13: {
            finalResult = false;
            this.oracleHomePath = oracleHomePath;
            HashMap<String, FileMetaData> MetadataMap = new HashMap<String, FileMetaData>();
            if (this.isPatchArchiveMappingFilePresent(oracleHomePath)) {
                boolean updateXMLFile = false;
                try {
                    this.patchArchives = this.readPatchArchiveMappingFile(oracleHomePath);
                    if (this.patchArchives.getPatchArchive().size() > 0) {
                        for (PatchArchive patchArchive : this.patchArchives.getPatchArchive()) {
                            OLogger.println("Patch id :" + patchArchive.getPatchId());
                            for (FileMetaData fileMetadata : patchArchive.getFileMetadata()) {
                                if (!fileMetadata.isUnarchived()) continue;
                                Path zipToBeDeleted = WrapperFactory.getNioServiceWrapper().getPath(fileMetadata.getSecondaryPatchstoragePath(), fileMetadata.getName());
                                OLogger.println("Deleting :" + zipToBeDeleted);
                                if (this.deleteZipFromSecondaryPatchStorage(zipToBeDeleted)) {
                                    OLogger.println("Deletion is Success and updating the XML object to remove entry:" + patchArchive.getPatchId());
                                    MetadataMap.put(patchArchive.getPatchId(), fileMetadata);
                                    continue;
                                }
                                OLogger.println("Deletion is Unsuccessful:" + zipToBeDeleted);
                            }
                        }
                        for (Map.Entry entry : MetadataMap.entrySet()) {
                            if (this.removeFileEntryFromMappingFile((String)entry.getKey(), (FileMetaData)entry.getValue())) {
                                updateXMLFile = true;
                                OLogger.println("Removed the entry of :" + (String)entry.getKey() + " from mappingXML file");
                                continue;
                            }
                            OLogger.println("Could not remove the entry from mapping  xml:" + (String)entry.getKey() + " ");
                        }
                    }
                    if (updateXMLFile) {
                        int result = this.updatePatchArchiveMappingFile(oracleHomePath, this.patchArchives, this.cleanup_operation);
                        if (result >= 0) {
                            OLogger.println("Updated Central mapping file. Cleanuparchives operation is completed");
                            finalResult = true;
                        } else {
                            OLogger.justlog(OLogger.WARNING, "Updated Central mapping file result:" + result);
                        }
                        break block13;
                    }
                    OLogger.println("Nothing to cleanup");
                    finalResult = true;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            } else {
                OLogger.println(".patch_archive_mapping.xml is not present . Hence cleanuparchives session is skipped");
            }
        }
        return finalResult;
    }

    public boolean runSpaceRequiredforUnzipOperation() {
        long totalSpaceNeeded = 0L;
        try {
            for (FileMetaData fileMetaData : this.processPatches_unarchive) {
                totalSpaceNeeded += Long.parseLong(fileMetaData.getSize());
            }
            boolean hasenoughSpaceInDest = OiipgFileSystem.isSpaceAvailable((long)totalSpaceNeeded, (String)this.patchArchiveUnzipPath.toString());
            if (hasenoughSpaceInDest) {
                OLogger.println("Total Space Needed for Unarchive :" + totalSpaceNeeded);
                OLogger.printlnOnLog("Space Prereq for Unarchive  : Pass");
                return true;
            }
            OLogger.printlnOnLog("Space Prereq for Unarchive  : Fail");
            OLogger.println("Total Space Needed for Unarchive :" + totalSpaceNeeded + " is not available under " + this.patchArchiveUnzipPath.toString());
            return false;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return false;
        }
    }

    public boolean unarchive(String oracleHomePath, ArrayList<String> patchesList) {
        boolean xmlToBeUpdated = false;
        boolean result = false;
        this.oracleHomePath = oracleHomePath;
        if (this.isPatchArchiveMappingFilePresent(oracleHomePath)) {
            OLogger.println("Started : unarchiving the patch dirs to OH/.patch_storage");
            OLogger.println("User specified list :" + patchesList);
            this.patchArchives = this.readPatchArchiveMappingFile(oracleHomePath);
            this.patchArchiveUnzipPath = WrapperFactory.getNioServiceWrapper().getPath(oracleHomePath, this.PATCH_STORAGE_DIR);
            boolean shallProcess = this.prepareUnarchiveListOfPatches(patchesList, oracleHomePath);
            boolean spaceCheck = this.runSpaceRequiredforUnzipOperation();
            if (!shallProcess && spaceCheck) {
                try {
                    for (FileMetaData fileMetaData : this.processPatches_unarchive) {
                        String abs_path_of_the_zip = WrapperFactory.getNioServiceWrapper().getPath(fileMetaData.getSecondaryPatchstoragePath(), fileMetaData.getName()).toString();
                        Path check = WrapperFactory.getNioServiceWrapper().getPath(oracleHomePath, this.PATCH_STORAGE_DIR, fileMetaData.getName().replace(".zip", ""));
                        if (!Files.exists(check, new LinkOption[0])) {
                            ZipUtilities.unzip(abs_path_of_the_zip, this.patchArchiveUnzipPath.toString());
                            OLogger.justlog(OLogger.INFO, "Details for :" + fileMetaData.getName());
                            OLogger.justlog(OLogger.INFO, "Unarchived under original .patch_storage");
                            long after_unzip_size = this.getSpaceUsedInBytes(check.toString());
                            OLogger.justlog(OLogger.INFO, "size of :" + check + " is in bytes :" + after_unzip_size);
                            OLogger.justlog(OLogger.INFO, "size from XML :" + fileMetaData.getSize());
                            boolean isPatchDirChecksumCorrect = this.verifyPatchDirCheckSum(fileMetaData.getPatchdirChecksum(), check.toString());
                            if (Files.exists(check, new LinkOption[0]) && fileMetaData.getSize().equals(String.valueOf(after_unzip_size)) && isPatchDirChecksumCorrect) {
                                OLogger.println("Unarchive successful :" + check);
                                OLogger.justlog(OLogger.INFO, "Util unarchive is successful: " + fileMetaData.getName());
                                fileMetaData.setUnarchived(true);
                                xmlToBeUpdated = true;
                                result = true;
                                continue;
                            }
                            OLogger.println("Unarchive unsuccessful for : " + fileMetaData.getName());
                            OPatchSessionHelper.deleteRecurse(check.toString());
                            OLogger.justlog(OLogger.SEVERE, "Possible causes are checksum is different or unarchive dir is not present: " + fileMetaData.getName());
                            continue;
                        }
                        OLogger.println("Dir is already present in primary .patch_storage and hence no need to unarchive: " + check);
                        OLogger.justlog(OLogger.INFO, "unarchive dir is already present in primary .patch_storage: " + fileMetaData.getName());
                    }
                    if (xmlToBeUpdated) {
                        this.updatePatchArchiveMappingFile(oracleHomePath, this.patchArchives, this.unarchive_operation);
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            } else if (!spaceCheck) {
                OLogger.println("Space check has failed for Unarchive");
                result = false;
            } else {
                OLogger.println("Nothing to unarchive");
                result = true;
            }
        } else {
            OLogger.println(".patch_archive_mapping.xml is not present.Hence, unarchive operation has been skipped. ");
            result = false;
        }
        return result;
    }

    private boolean verifyPatchDirCheckSum(String patchdirChecksum, String archivedPatchPath) {
        String sha1sumValue = null;
        sha1sumValue = patchdirChecksum.length() >= 64 ? this.generatePatchDirHash(archivedPatchPath, 1) : this.generatePatchDirHash(archivedPatchPath, 0);
        boolean isPatchDirChecksumSame = false;
        if (this.isContentValid(sha1sumValue)) {
            if (this.isContentValid(patchdirChecksum)) {
                if (sha1sumValue.equalsIgnoreCase(patchdirChecksum)) {
                    OLogger.justlog(OLogger.INFO, "Patch directory checksum in XML file matches with patch directory in OH. ");
                    isPatchDirChecksumSame = true;
                } else {
                    OLogger.justlog(OLogger.SEVERE, "Patch directory checksum in XML file does not match with patch directory in OH :" + sha1sumValue + "::" + patchdirChecksum);
                    OLogger.debug("Patch directory checksum in XML file does not match with patch directory in OH : PatchDir checksum in xml :" + patchdirChecksum + " PatchDir checksum in OH: " + sha1sumValue);
                    isPatchDirChecksumSame = false;
                }
            } else {
                OLogger.debug("Assuming the patchdir_checksum attribute is not present in xml file. Not verifying the patchdir checksum. " + patchdirChecksum);
                isPatchDirChecksumSame = true;
            }
        } else {
            OLogger.justlog(OLogger.SEVERE, "Error while calculating Patch directory checksum : " + sha1sumValue);
        }
        return isPatchDirChecksumSame;
    }

    private boolean prepareUnarchiveListOfPatches(List<String> patchesList, String oracleHomePath) {
        for (String patchID : patchesList) {
            String process_patch = "false";
            PatchArchive patchArchiveObj = this.validatePatchId(patchID);
            if (patchArchiveObj != null) {
                for (FileMetaData fileMetaData : patchArchiveObj.getFileMetadata()) {
                    if (fileMetaData.isUnarchived()) {
                        OLogger.justlog(OLogger.INFO, "Skipping patch unarchive process for :" + patchID + ". It is already unarchived");
                        this.skippedPatches.add(patchID);
                        OLogger.println("Unarchive has been skipped as it is already unarchived:" + patchID);
                        process_patch = "false";
                        continue;
                    }
                    Path patchPathobj = WrapperFactory.getNioServiceWrapper().getPath(fileMetaData.getSecondaryPatchstoragePath(), fileMetaData.getName());
                    if (Files.exists(patchPathobj, new LinkOption[0])) {
                        String checkSumInPatch = fileMetaData.getChecksum();
                        String checksum = null;
                        checksum = checkSumInPatch.length() >= 64 ? this.calculateCheckSum(patchPathobj, 1) : this.calculateCheckSum(patchPathobj, 0);
                        if (checkSumInPatch.equalsIgnoreCase(checksum)) {
                            process_patch = "true";
                            this.processPatches_unarchive.add(fileMetaData);
                            continue;
                        }
                        this.skippedPatches.add(patchID);
                        process_patch = "false";
                        OLogger.println("Unarchive has been skipped as there is a mismatch in the checksum. Patch ID : " + patchID);
                        OLogger.justlog(OLogger.INFO, "Checksum from file :" + fileMetaData.getChecksum() + " && Checksum of the existing file : " + checksum);
                        continue;
                    }
                    this.skippedPatches.add(patchID);
                    process_patch = "false";
                    OLogger.println("Unarchive has been skipped as the zip location is not present :" + patchPathobj);
                }
                continue;
            }
            OLogger.justlog(OLogger.INFO, "Invalid Patch as opatch could not find the patch details in the mapping file:" + patchID);
        }
        return this.processPatches_unarchive.isEmpty();
    }

    private long getSpaceUsedInBytes(String path) {
        Path dir = WrapperFactory.getNioServiceWrapper().getPath(path, new String[0]);
        long size = 0L;
        if (Files.exists(dir, new LinkOption[0]) && Files.isDirectory(dir, new LinkOption[0])) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
                Iterator<Path> iterator = stream.iterator();
                while (iterator.hasNext()) {
                    Path entry;
                    Path file = entry = iterator.next();
                    long eachSize = 0L;
                    if (Files.isRegularFile(file, new LinkOption[0])) {
                        eachSize = Files.size(file);
                    } else {
                        String eachPath = file.toAbsolutePath().toString();
                        eachSize = this.getSpaceUsedInBytes(eachPath);
                    }
                    size += eachSize;
                }
            }
            catch (IOException e2) {
                OLogger.debug(e2.getMessage());
            }
        }
        return size;
    }

    public int archive(String oracleHomePath, ArrayList<String> patchesList, String archive_dir, ArrayList<String> listOfPatchDirs) throws IOException {
        OLogger.justlog(OLogger.INFO, "PatchArchiver::archive()");
        this.oracleHomePath = oracleHomePath;
        int archiveResult = -1;
        String patchStorageDir = this.getpatchStoragePath(oracleHomePath);
        boolean isPrereqSuccess = this.spaceAndFilePermissionForUtilArchive(patchStorageDir, listOfPatchDirs, archive_dir);
        ArrayList<PatchManager> toBeDeleted = new ArrayList<PatchManager>();
        if (isPrereqSuccess) {
            OLogger.justlog(OLogger.INFO, "PatchArchiver::spaceAndFilePermissionForUtilArchive() :: Success");
            if (this.isPatchArchiveMappingFilePresent(oracleHomePath)) {
                try {
                    this.patchArchives = this.readPatchArchiveMappingFile(oracleHomePath);
                    if (this.patchArchives.getPatchArchive().size() > 0) {
                        OLogger.justlog(OLogger.INFO, "PatchArchiver:: readPatchArchiveMappingFile()\n Details of already archived patches:\n");
                        for (PatchArchive patchArchive : this.patchArchives.getPatchArchive()) {
                            OLogger.justlog(OLogger.INFO, "---------------------------------------");
                            OLogger.justlog(OLogger.INFO, "Patch id " + patchArchive.getPatchId());
                            for (FileMetaData fileMetadata : patchArchive.getFileMetadata()) {
                                OLogger.justlog(OLogger.INFO, "Patch timestamp " + fileMetadata.getArchivedTimestamp());
                                OLogger.justlog(OLogger.INFO, "checksum " + fileMetadata.getChecksum());
                                OLogger.justlog(OLogger.INFO, "Name" + fileMetadata.getName());
                                OLogger.justlog(OLogger.INFO, "Patch path " + fileMetadata.getSecondaryPatchstoragePath());
                                OLogger.justlog(OLogger.INFO, "Size " + fileMetadata.getSize());
                            }
                        }
                        this.isMappingFilePresent = true;
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            this.getPatchDirDetails(patchStorageDir, listOfPatchDirs, archive_dir);
            for (String patchId : this.processedPatchIdMap.keySet()) {
                for (PatchManager patchManagerObj : this.processedPatchIdMap.get(patchId)) {
                    Path patchArchiveZipPath = WrapperFactory.getNioServiceWrapper().getPath(patchManagerObj.getPatchArchivePath(), patchManagerObj.getPatchArchiveName());
                    try {
                        OLogger.justlog(OLogger.INFO, "Archiving Patch - " + patchId + " ....");
                        OLogger.printlnOnConsole("\nArchiving Patch - " + patchId + " ....");
                        ZipUtilities.compressZip(patchArchiveZipPath.toString(), patchManagerObj.getPatchPath().toString());
                        if (Files.exists(patchArchiveZipPath, new LinkOption[0])) {
                            OLogger.justlog(OLogger.INFO, "Sucessfully archived patch - " + patchId + " in " + patchArchiveZipPath.toString());
                            OLogger.printlnOnConsole("Sucessfully archived patch - " + patchId + " in " + patchArchiveZipPath.toString());
                            String archived_timestamp = new SimpleDateFormat("YYYY_MM_dd_HH_mm_ss_SSS").format(Calendar.getInstance().getTime());
                            String checkSum = this.calculateCheckSum(patchArchiveZipPath, 1);
                            patchManagerObj.setChecksum(checkSum);
                            patchManagerObj.setUnarchived(false);
                            patchManagerObj.setArchived_timestamp(archived_timestamp);
                            OLogger.printlnOnLog(OLogger.INFO, "\nPatch -" + patchId + " is archived in  : " + patchArchiveZipPath.toString());
                            OLogger.printlnOnLog(OLogger.INFO, "with checksum " + checkSum);
                            OLogger.printlnOnLog(OLogger.INFO, "archived_timestamp " + archived_timestamp);
                            toBeDeleted.add(patchManagerObj);
                            continue;
                        }
                        OLogger.justlog(OLogger.SEVERE, "Following patches are not archived. Please check the permissions and proceed." + patchManagerObj.getPatchPath());
                        return archiveResult;
                    }
                    catch (ArchiveException e3) {
                        e3.printStackTrace();
                        OLogger.justlog(OLogger.SEVERE, "Archive operation failed.");
                        return archiveResult;
                    }
                    catch (IOException e4) {
                        e4.printStackTrace();
                        OLogger.justlog(OLogger.SEVERE, "Archive operation failed.");
                        return archiveResult;
                    }
                }
            }
            if (this.patchArchives != null && this.patchArchives.getPatchArchive().size() > 0) {
                this.updatePatchArchivesInfo();
            } else {
                this.patchArchives = new PatchArchives();
                this.updatePatchArchivesInfo();
            }
            if (this.patchArchives != null && this.patchArchives.getPatchArchive() != null && this.patchArchives.getPatchArchive().size() > 0) {
                if (this.hasUpdated) {
                    if (this.validateFileMetaDataContent(this.patchArchives)) {
                        archiveResult = this.updatePatchArchiveMappingFile(oracleHomePath, this.patchArchives, this.archive_operation);
                        if (archiveResult == 0) {
                            OLogger.justlog(OLogger.INFO, "Mapping file has been updated");
                            archiveResult = this.verifyAndDeletePatchesFromPatchStorage(oracleHomePath, toBeDeleted);
                        }
                    } else {
                        OLogger.justlog(OLogger.INFO, "File metadata content validation/backup failed. Not updating the entry in mapping file ");
                    }
                } else {
                    OLogger.justlog(OLogger.INFO, "No changes for mapping file.");
                    archiveResult = 0;
                }
            }
            if (this.skippedPatches.size() > 0) {
                OLogger.println("Following patches are skipped from archive operation.");
                for (String pid : this.skippedPatches) {
                    OLogger.println(pid);
                }
                archiveResult = 1;
            }
        }
        return archiveResult;
    }

    private String getpatchStoragePath(String oracleHomePath) {
        return OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath);
    }

    private void updateFileMetadataInfo(PatchManager patchMgrObj, FileMetaData fileMetaData) {
        fileMetaData.setName(patchMgrObj.getPatchArchiveName());
        fileMetaData.setChecksum(patchMgrObj.getChecksum());
        fileMetaData.setArchivedTimestamp(patchMgrObj.getArchived_timestamp());
        fileMetaData.setSecondaryPatchstoragePath(patchMgrObj.getPatchArchivePath());
        fileMetaData.setSize(patchMgrObj.getPatchDirSize());
        fileMetaData.setUnarchived(patchMgrObj.isUnarchived());
        fileMetaData.setPatchdirChecksum(patchMgrObj.getPatchDirHashValue());
        this.hasUpdated = true;
    }

    private void updatePatchArchivesInfo() {
        ArrayList<PatchArchive> patchArchiveObjList = new ArrayList<PatchArchive>();
        HashMap<String, PatchArchive> patchArchiveMetadataMap = new HashMap<String, PatchArchive>();
        for (String patchId : this.processedPatchIdMap.keySet()) {
            boolean isPatchIdPresentInXml = false;
            for (PatchManager patchMgrObj : this.processedPatchIdMap.get(patchId)) {
                for (PatchArchive patchArchive : this.patchArchives.getPatchArchive()) {
                    if (!patchArchive.getPatchId().equals(patchId)) continue;
                    boolean hasAnEntryForMetadata = false;
                    isPatchIdPresentInXml = true;
                    for (FileMetaData fileMetaData : patchArchive.getFileMetadata()) {
                        if (!fileMetaData.getName().equals(patchMgrObj.getPatchArchiveName())) continue;
                        hasAnEntryForMetadata = true;
                        if (!fileMetaData.getSecondaryPatchstoragePath().equals(patchMgrObj.getPatchArchivePath())) {
                            OLogger.printlnOnLog(OLogger.WARNING, "An archive entry exists for patch id - " + patchMgrObj.getPatchId() + " with archive location: " + fileMetaData.getSecondaryPatchstoragePath() + "\n Replacing the existing entry location for patch id - " + patchMgrObj.getPatchId() + " with new archive locaton " + patchMgrObj.getPatchArchivePath() + ".\n");
                            OLogger.printlnOnConsole("\nWARNING: An archive entry exists for patch id - " + patchMgrObj.getPatchId() + " with archive location" + fileMetaData.getSecondaryPatchstoragePath() + ".\n Replacing the existing entry location for patch id - " + patchMgrObj.getPatchId() + " with new archive locaton: " + patchMgrObj.getPatchArchivePath() + ".\n");
                        }
                        this.updateFileMetadataInfo(patchMgrObj, fileMetaData);
                    }
                    if (hasAnEntryForMetadata) continue;
                    FileMetaData fileMetaData = new FileMetaData();
                    this.updateFileMetadataInfo(patchMgrObj, fileMetaData);
                    patchArchive.getFileMetadata().add(fileMetaData);
                }
                PatchArchive patchArchiveNew = null;
                if (isPatchIdPresentInXml) continue;
                if (!patchArchiveMetadataMap.containsKey(patchId)) {
                    patchArchiveNew = new PatchArchive();
                    patchArchiveNew.setPatchId(patchId);
                    patchArchiveMetadataMap.put(patchId, patchArchiveNew);
                    patchArchiveObjList.add(patchArchiveNew);
                } else {
                    patchArchiveNew = (PatchArchive)patchArchiveMetadataMap.get(patchId);
                }
                FileMetaData fileMetaData = new FileMetaData();
                this.updateFileMetadataInfo(patchMgrObj, fileMetaData);
                ((PatchArchive)patchArchiveMetadataMap.get(patchId)).getFileMetadata().add(fileMetaData);
            }
        }
        if (patchArchiveObjList.size() > 0) {
            this.patchArchives.getPatchArchive().addAll(patchArchiveObjList);
        }
    }

    private boolean isArchiveFilePresent(Path patchArchiveZipPath) {
        return Files.exists(patchArchiveZipPath, new LinkOption[0]);
    }

    private String retrievePatchIdFromPatchDirName(String patchDirName) {
        if (patchDirName != null) {
            return patchDirName.substring(0, patchDirName.indexOf("_"));
        }
        return null;
    }

    private void getPatchDirDetails(String patchStorageDir, List<String> listOfPatchDirs, String archive_dir) {
        OLogger.justDebugLog("PatchArchiver::getPatchDirDetails()");
        OLogger.justlog(OLogger.INFO, "-------------------------------------------------");
        OLogger.justlog(OLogger.INFO, "getPatchDirDetails()::Retrieve the details of patches to be archived");
        String patchPath = null;
        for (String patchDirName : listOfPatchDirs) {
            String patchDirHashValue;
            PatchArchive patchArchiveObj;
            Path patchPathobj = WrapperFactory.getNioServiceWrapper().getPath(patchStorageDir, patchDirName);
            patchPath = WrapperFactory.getNioServiceWrapper().getPath(patchStorageDir, patchDirName).toString();
            if (!Files.isDirectory(patchPathobj, new LinkOption[0])) continue;
            Path archivedPath = WrapperFactory.getNioServiceWrapper().getPath(archive_dir, patchDirName + ".zip");
            String patchIdFromPatchDir = this.retrievePatchIdFromPatchDirName(patchDirName);
            String archiveZipName = patchDirName + ".zip";
            if (this.isMappingFilePresent && (patchArchiveObj = this.isPatchIdPresentInSecondaryStorage(patchIdFromPatchDir)) != null) {
                for (FileMetaData fileMetaData : patchArchiveObj.getFileMetadata()) {
                    Path archivedPathFromXmlFile;
                    if (!fileMetaData.getName().equals(archiveZipName) || !Files.exists(archivedPathFromXmlFile = WrapperFactory.getNioServiceWrapper().getPath(fileMetaData.getSecondaryPatchstoragePath(), fileMetaData.getName()), new LinkOption[0]) || !fileMetaData.isUnarchived()) continue;
                    String opatchPath = this.oracleHomePath + File.separator + "OPatch" + File.separator + "opatch";
                    OLogger.justlog(OLogger.WARNING, "Skipping patch archive process for :" + patchIdFromPatchDir + ".\nReason: It is already unarchived but archive file still exists in " + archivedPathFromXmlFile + "\nAction: Execute '" + opatchPath + " util cleanuparchives' command before archiving this patch.\n");
                    OLogger.println("\nWARNING : Skipping patch archive process for :" + patchIdFromPatchDir + ".\nReason: It is already unarchived but archive file still exists in " + archivedPathFromXmlFile + "\nAction: Execute '" + opatchPath + " util cleanuparchives' command before archiving this patch.\n");
                    this.skippedPatches.add(patchIdFromPatchDir);
                    patchIdFromPatchDir = null;
                }
            }
            if (patchIdFromPatchDir != null && this.isArchiveFilePresent(archivedPath)) {
                OLogger.println("\nWARNING : Skipping patch archive process for :" + patchIdFromPatchDir + ".\nReason: It is already archived in " + archivedPath + "\n");
                this.skippedPatches.add(patchIdFromPatchDir);
                patchIdFromPatchDir = null;
            }
            if (!this.isContentValid(patchDirHashValue = this.generatePatchDirHash(patchPath, 1))) {
                OLogger.println("\nWARNING : Skipping patch archive process for :" + patchIdFromPatchDir + ".\nReason: Error while calculating checksum for Patch directory: \n");
                this.skippedPatches.add(patchIdFromPatchDir);
                patchIdFromPatchDir = null;
            }
            if (patchIdFromPatchDir == null) continue;
            PatchManager patchManager = new PatchManager();
            patchManager.setPatchId(patchIdFromPatchDir);
            patchManager.setPatchArchiveName(archiveZipName);
            patchManager.setPatchArchivePath(archive_dir);
            patchManager.setPatchPath(patchPath);
            patchManager.setPatchDirName(patchDirName);
            patchManager.setPatchDirSize(this.patchDirSpaceMap.get(patchPath));
            patchManager.setPatchDirHashValue(patchDirHashValue);
            OLogger.printlnOnLog(OLogger.INFO, "Details of patch to be archived : " + patchManager.getDetails());
            if (this.processedPatchIdMap.containsKey(patchIdFromPatchDir)) {
                this.processedPatchIdMap.get(patchIdFromPatchDir).add(patchManager);
                continue;
            }
            ArrayList<PatchManager> patchManagerList = new ArrayList<PatchManager>();
            patchManagerList.add(patchManager);
            this.processedPatchIdMap.put(patchIdFromPatchDir, patchManagerList);
        }
    }

    public boolean isPatchArchiveMappingFilePresent(String oracle_home_path) {
        Path patchArchiveMappingFilePath = this.getPatchArchiveMappingFilePath(oracle_home_path);
        if (patchArchiveMappingFilePath != null && !Files.exists(patchArchiveMappingFilePath, new LinkOption[0]) || !Files.isReadable(patchArchiveMappingFilePath)) {
            OLogger.justDebugLog(".patch_archive_mapping.xmlis not present in " + oracle_home_path);
            return false;
        }
        OLogger.justDebugLog(".patch_archive_mapping.xmlis present in " + oracle_home_path);
        return true;
    }

    public Path getPatchArchiveMappingFilePath(String oracleHomePath) {
        Path archiveMappingFilePath = WrapperFactory.getNioServiceWrapper().getPath(oracleHomePath, this.PATCH_STORAGE_DIR, ".patch_archive_mapping.xml");
        return archiveMappingFilePath;
    }

    public PatchArchive isPatchIdPresentInSecondaryStorage(String patchId) {
        if (this.patchArchives != null && this.patchArchives.getPatchArchive().size() > 0) {
            for (PatchArchive patchArchive : this.patchArchives.getPatchArchive()) {
                String patchidFromXmlFile = patchArchive.getPatchId();
                if (!patchidFromXmlFile.equalsIgnoreCase(patchId)) continue;
                return patchArchive;
            }
        }
        return null;
    }

    public PatchArchive validatePatchId(String patchId) {
        if (this.patchArchives != null && this.patchArchives.getPatchArchive().size() > 0) {
            for (PatchArchive patchArchive : this.patchArchives.getPatchArchive()) {
                String patchidFromXmlFile = patchArchive.getPatchId();
                if (!patchidFromXmlFile.equalsIgnoreCase(patchId)) continue;
                return patchArchive;
            }
        }
        return null;
    }

    public PatchArchives readPatchArchiveMappingFile(String oracleHomePath) {
        PatchArchives patchArchives = null;
        try {
            patchArchives = PatchArchiveJaxbBinder.getInstance().loadFromXML(WrapperFactory.getNioServiceWrapper().getPath(oracleHomePath, this.PATCH_STORAGE_DIR, ".patch_archive_mapping.xml"));
        }
        catch (PatchArchiveXmlException e2) {
            e2.printStackTrace();
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
        return patchArchives;
    }

    public ArrayList<String> isPatchArchived(String oracleHomePath, PatchObject[] patchObjects) {
        ArrayList<String> archivedPatches = null;
        this.patchArchives = this.readPatchArchiveMappingFile(oracleHomePath);
        if (this.patchArchives != null) {
            for (PatchObject patchObjectsToRollback : patchObjects) {
                String patchId = patchObjectsToRollback.getPatchID();
                PatchArchive patchArchive = this.isPatchIdPresentInSecondaryStorage(patchId);
                if (patchArchive == null) continue;
                for (FileMetaData fileMetaData : patchArchive.getFileMetadata()) {
                    if (fileMetaData.isUnarchived()) continue;
                    if (archivedPatches == null) {
                        archivedPatches = new ArrayList<String>();
                    }
                    archivedPatches.add(patchId);
                }
            }
        }
        return archivedPatches;
    }

    public int updatePatchArchiveMappingFile(String oracleHomePath, PatchArchives patchArchives, String operation) {
        int result = -1;
        try {
            if (patchArchives != null && patchArchives.getPatchArchive() != null && patchArchives.getPatchArchive().size() > 0 && this.backupMappingFile(oracleHomePath, operation)) {
                PatchArchiveJaxbBinder.getInstance().saveToXML(patchArchives, this.getPatchArchiveMappingFilePath(oracleHomePath));
                result = 0;
            } else {
                OLogger.justlog(OLogger.INFO, "updatePatchArchiveMappingFile :: No more entries in the file, hence deleting the file");
                Path mappingFilePath = this.getPatchArchiveMappingFilePath(oracleHomePath);
                File fl = mappingFilePath.toFile();
                if (fl.exists()) {
                    OLogger.justlog(OLogger.INFO, "updatePatchArchiveMappingFile :: Mapping file exists. Deleting " + fl.getAbsolutePath());
                    fl.delete();
                }
                result = 1;
            }
        }
        catch (PatchArchiveXmlException e2) {
            e2.printStackTrace();
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
        return result;
    }

    private boolean backupMappingFile(String oracleHomePath, String operation) {
        boolean backup_result = false;
        StringBuffer buff = new StringBuffer();
        String timestamp = new SimpleDateFormat("YYYYMMddHHmmssSSS").format(Calendar.getInstance().getTime());
        Path backupDirName = WrapperFactory.getNioServiceWrapper().getPath(oracleHomePath, this.PATCH_STORAGE_DIR, ".archive_xml_bck");
        String backupFileName = operation + "_" + timestamp + ".bck";
        Path srcFile = WrapperFactory.getNioServiceWrapper().getPath(oracleHomePath, this.PATCH_STORAGE_DIR, ".patch_archive_mapping.xml");
        Path dstFile = WrapperFactory.getNioServiceWrapper().getPath(backupDirName.toString(), backupFileName);
        if (Files.exists(srcFile, new LinkOption[0])) {
            try {
                if (!Files.exists(backupDirName, new LinkOption[0])) {
                    buff = new StringBuffer("Creating directory \"");
                    buff.append(dstFile.toString());
                    buff.append("\"");
                    OLogger.log(OLogger.FINEST, buff.toString());
                    Files.createDirectories(backupDirName, new FileAttribute[0]);
                }
                SystemCall.backupFile(srcFile, dstFile);
                if (Files.exists(dstFile, new LinkOption[0])) {
                    backup_result = true;
                    OLogger.printlnOnLog(OLogger.INFO, "backup has been taken: " + dstFile.toAbsolutePath().toString());
                }
            }
            catch (RuntimeException e2) {
                OLogger.printlnOnLog(e2.getMessage());
                backup_result = false;
            }
            catch (IOException e3) {
                OLogger.printlnOnLog(e3.getMessage());
                backup_result = false;
            }
        } else {
            backup_result = true;
        }
        return backup_result;
    }

    private boolean validateFileMetaDataContent(PatchArchives patchArchives) {
        boolean result = false;
        for (PatchArchive pa : patchArchives.getPatchArchive()) {
            if (pa.getPatchId() == null || pa.getPatchId().length() <= 0) continue;
            for (FileMetaData fm : pa.getFileMetadata()) {
                if (this.isContentValid(fm.getName()) && this.isContentValid(fm.getArchivedTimestamp()) && this.isContentValid(fm.getChecksum()) && this.isContentValid(fm.getSecondaryPatchstoragePath()) && this.isContentValid(fm.getSize())) {
                    result = true;
                    continue;
                }
                result = false;
                return result;
            }
        }
        return result;
    }

    private boolean isContentValid(String content) {
        return content != null && content.length() > 0;
    }

    private int verifyAndDeletePatchesFromPatchStorage(String oracleHomePath, List<PatchManager> toBeDeleted) throws IOException {
        OLogger.justlog(OLogger.INFO, "verifyAndDeletePatchesFromPatchStorage :: No of patches to be deleted = " + toBeDeleted.size());
        int result = 0;
        boolean updateMappingxmlFile = false;
        for (PatchManager pm : toBeDeleted) {
            FileMetaData fileMetaData = this.getFileMetaData(pm);
            if (fileMetaData == null) continue;
            boolean success = this.verifyArchive(fileMetaData);
            if (!success) {
                boolean removed;
                OLogger.justlog(OLogger.WARNING, "verifyAndDeletePatchesFromPatchStorage :: Verification failed for " + pm.getPatchPath() + ". Removing the entry from PatchArchiveMappingFile");
                Path archivePath = Paths.get(fileMetaData.getSecondaryPatchstoragePath(), fileMetaData.getName());
                File archiveFile = archivePath.toFile();
                if (archiveFile != null && archiveFile.exists()) {
                    archiveFile.delete();
                    OLogger.justlog(OLogger.WARNING, "Deleting the corrupted archive file -> " + archiveFile);
                }
                if (removed = this.removeFileEntryFromMappingFile(pm.getPatchId(), fileMetaData)) {
                    updateMappingxmlFile = true;
                }
                OLogger.printlnOnConsole("Verification failed for Patch - " + pm.getPatchId());
                ++result;
                continue;
            }
            OLogger.justlog(OLogger.INFO, "verifyAndDeletePatchesFromPatchStorage :: Verification Passed for " + pm.getPatchPath());
            OLogger.justlog(OLogger.INFO, "Succesfully verified the created archive. Deleting the original patch from  - " + pm.getPatchPath());
            OLogger.printlnOnConsole("Succesfully verified the created archive. Deleting the original patch from  - " + pm.getPatchPath());
            OPatchSessionHelper.deleteRecurse(pm.getPatchPath());
            OLogger.justlog(OLogger.INFO, "Deletion Successfull");
            result += 0;
        }
        if (updateMappingxmlFile) {
            OLogger.justlog(OLogger.INFO, "verifyAndDeletePatchesFromPatchStorage :: Updating PatchArchiveMappingFile as one or more patch archive verfication failed.Removing entires for the failed patches");
            result += this.updatePatchArchiveMappingFile(oracleHomePath, this.patchArchives, "verifyarchive");
        }
        return result;
    }

    private String generatePatchDirHash(String patchPath, int algo) {
        String hashCode = null;
        OLogger.justDebugLog("PatchArchiver:: generatePatchDirHash()" + patchPath);
        try {
            DirChecksumCalculator dirChecksumCal = new DirChecksumCalculator();
            hashCode = dirChecksumCal.sha1sumForDirectory(patchPath, algo);
        }
        catch (NoSuchAlgorithmException e2) {
            e2.printStackTrace();
        }
        return hashCode;
    }

    private boolean verifyArchive(FileMetaData fileMetaData) {
        OLogger.justlog(OLogger.INFO, "verifyArchive :: Verifying the validity of archive " + fileMetaData.getName());
        boolean pass = true;
        Path archivePath = Paths.get(fileMetaData.getSecondaryPatchstoragePath(), fileMetaData.getName());
        File archiveFile = archivePath.toFile();
        if (archiveFile != null && archiveFile.exists()) {
            OLogger.justlog(OLogger.INFO, "verifyArchive :: Archive File Exists Verification - PASS");
        } else {
            OLogger.justlog(OLogger.WARNING, "verifyArchive :: The achive file does not exist in path  " + archiveFile);
            pass = false;
        }
        String checkSumInPatch = fileMetaData.getChecksum();
        String checksum = null;
        checksum = checkSumInPatch.length() >= 64 ? this.calculateCheckSum(archivePath, 1) : this.calculateCheckSum(archivePath, 0);
        if (checksum != null && checksum.equalsIgnoreCase(checkSumInPatch)) {
            OLogger.justlog(OLogger.INFO, "verifyArchive :: File Checksum Verification - PASS");
        } else {
            OLogger.justlog(OLogger.WARNING, "verifyArchive :: The checksum of file does not match with metadata. File Checksum =   " + checksum + " --- Metadata Checksum = " + checkSumInPatch);
            pass = false;
        }
        if (this.isValidZipFile(archiveFile)) {
            OLogger.justlog(OLogger.INFO, "verifyArchive :: Zip File Content Verification - PASS");
        } else {
            OLogger.justlog(OLogger.WARNING, "verifyArchive :: The zip file verification failed.");
            pass = false;
        }
        if (fileMetaData.getArchivedTimestamp() == null || fileMetaData.getArchivedTimestamp().length() == 0) {
            OLogger.justlog(OLogger.WARNING, "verifyArchive :: The archived timestamp content is not valid. Archived_Timestamp =   " + fileMetaData.getArchivedTimestamp());
            pass = false;
        }
        if (fileMetaData.getSize() == null || fileMetaData.getSize().length() == 0) {
            OLogger.justlog(OLogger.WARNING, "verifyArchive :: The Patch dir size metadata is not valid. Size =   " + fileMetaData.getSize());
            pass = false;
        }
        String patchDirCheckSumFromMetadata = "";
        if (this.isContentValid(fileMetaData.getPatchdirChecksum())) {
            patchDirCheckSumFromMetadata = fileMetaData.getPatchdirChecksum();
            String[] patchDirNameDerived = fileMetaData.getName().split(".zip");
            if (patchDirNameDerived != null && patchDirNameDerived[0].length() > 0) {
                String patchDirCheckSum = null;
                patchDirCheckSum = patchDirCheckSumFromMetadata.length() >= 64 ? this.generatePatchDirHash(this.getpatchStoragePath(this.oracleHomePath) + File.separator + patchDirNameDerived[0], 1) : this.generatePatchDirHash(this.getpatchStoragePath(this.oracleHomePath) + File.separator + patchDirNameDerived[0], 0);
                if (this.isContentValid(patchDirCheckSum) && patchDirCheckSum.equalsIgnoreCase(patchDirCheckSumFromMetadata)) {
                    OLogger.justlog(OLogger.INFO, "verifyArchive :: The patchdir checksum Verification - PASS");
                }
            } else {
                pass = false;
                OLogger.justlog(OLogger.WARNING, "verifyArchive :: Could not verify Patchdir checksum");
            }
        } else {
            OLogger.justlog(OLogger.WARNING, "verifyArchive :: The patchdir checksum verification failed.");
            pass = false;
        }
        if (!pass) {
            OLogger.justlog(OLogger.WARNING, "verifyArchive :: One or more verifications failed for archive " + fileMetaData.getName());
        }
        return pass;
    }

    private boolean removeFileEntryFromMappingFile(String patchId, FileMetaData metaData) {
        OLogger.justlog(OLogger.INFO, "removeEntryFromPatchArchiveMappingFile:: removing FileMetadata  " + metaData.getName());
        boolean removed = false;
        if (this.patchArchives != null) {
            Iterator<PatchArchive> paItr = this.patchArchives.getPatchArchive().iterator();
            while (paItr.hasNext()) {
                PatchArchive pa = paItr.next();
                if (!pa.getPatchId().equalsIgnoreCase(patchId)) continue;
                if (pa.getFileMetadata() != null) {
                    Iterator<FileMetaData> itr = pa.getFileMetadata().iterator();
                    while (itr.hasNext()) {
                        FileMetaData fmd = itr.next();
                        if (!fmd.getName().equalsIgnoreCase(metaData.getName())) continue;
                        itr.remove();
                        OLogger.justlog(OLogger.INFO, "removeFileEntryFromMappingFile :: Removed entry for " + metaData.getName());
                        removed = true;
                    }
                }
                if (pa.getFileMetadata().size() != 0) continue;
                paItr.remove();
            }
        }
        return removed;
    }

    private FileMetaData getFileMetaData(PatchManager pm) {
        OLogger.justlog(OLogger.INFO, "getFileMetaData:: finding FileMetadata for " + pm.getPatchArchiveName());
        if (this.patchArchives != null) {
            for (PatchArchive pa : this.patchArchives.getPatchArchive()) {
                if (!pa.getPatchId().equalsIgnoreCase(pm.getPatchId())) continue;
                OLogger.justlog(OLogger.INFO, "getFileMetaData :: Found Matching PatchArchive for Patch ID = " + pm.getPatchId());
                if (pa.getFileMetadata() == null) continue;
                for (FileMetaData fmd : pa.getFileMetadata()) {
                    if (!pm.getPatchArchiveName().equalsIgnoreCase(fmd.getName())) continue;
                    OLogger.justlog(OLogger.INFO, "getFileMetaData :: Found Matching FileMetadata for Patch ID = " + pm.getPatchArchiveName());
                    return fmd;
                }
            }
        }
        OLogger.justlog(OLogger.WARNING, "getFileMetaData :: No Matching FileMetadata exists in PatchArchives for  = " + pm.getPatchArchiveName());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValidZipFile(File file) {
        ZipFile zipfile = null;
        ZipInputStream zis = null;
        try {
            zipfile = new ZipFile(file);
            zis = new ZipInputStream(new FileInputStream(file));
            ZipEntry ze = zis.getNextEntry();
            if (ze == null) {
                boolean bl = false;
                return bl;
            }
            while (ze != null) {
                zipfile.getInputStream(ze);
                ze.getCrc();
                ze.getCompressedSize();
                ze.getName();
                ze = zis.getNextEntry();
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e2) {
            OLogger.log(OLogger.SEVERE, "isValidZipFile :: An error occurred while checking zip file contents. Message : " + e2.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (zipfile != null) {
                    zipfile.close();
                    zipfile = null;
                }
            }
            catch (IOException e3) {
                return false;
            }
            try {
                if (zis != null) {
                    zis.close();
                    zis = null;
                }
            }
            catch (IOException e4) {
                return false;
            }
        }
    }
}

