/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchutil.obfuscation;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipInputStream;
import javax.xml.bind.DatatypeConverter;
import oracle.opatch.OPatchEnv;
import oracle.opatch.ZipUtilities;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.wrappers.WrapperFactory;

public class ObfuscationUtil {
    private static final int ONE_MB = 0x100000;
    private static final int FILE_COPY_BUFFER_SIZE = 0x1E00000;
    private static final String HEX_EXT = "_O_";
    private static final String OLD_HEX_EXT = "_o_";
    private static final String HEX_200 = "-";
    private static final String HEX_100 = "_";
    private static final int HEX_PART = 80;
    private static final String PATCH_STORAGE = OPatchEnv.getOracleHome() + File.separator + ".patch_storage";
    private static final String FILES = "files";
    private static List<String> obfuscatedFiles = new ArrayList<String>();
    private static List<String> nonObfuscatedFiles = new ArrayList<String>();

    public static void obfuscateFileContent(Path srcPath, Path destPath, boolean all) {
        byte[] data = new byte[0x1E00000];
        File dest = destPath.toFile();
        File src = srcPath.toFile();
        try {
            File parentDest;
            Set<PosixFilePermission> perms = null;
            if (!OPatchEnv.isWindows()) {
                perms = Files.getPosixFilePermissions(srcPath, new LinkOption[0]);
            }
            if (dest.exists()) {
                dest.delete();
            }
            if ((parentDest = dest.getParentFile()) != null && !parentDest.exists()) {
                Files.createDirectories(parentDest.toPath(), new FileAttribute[0]);
            }
            dest.createNewFile();
            Path outpath = dest.toPath();
            FileInputStream fis = new FileInputStream(src);
            int available = fis.available();
            while (available > 0) {
                if (available >= data.length) {
                    fis.read(data);
                } else {
                    data = new byte[available];
                    fis.read(data);
                }
                if (all) {
                    ObfuscationUtil.negateAll(data, data.length);
                } else {
                    ObfuscationUtil.negate(data, data.length);
                }
                Files.write(outpath, data, StandardOpenOption.APPEND);
                available = fis.available();
            }
            fis.close();
            if (!OPatchEnv.isWindows() && perms != null) {
                Files.setPosixFilePermissions(outpath, perms);
            }
        }
        catch (IOException e2) {
            OLogger.justlog(OLogger.SEVERE, "Failed in obfuscation file: " + srcPath.toString());
            throw new RuntimeException(e2);
        }
    }

    public static void writeOneZipEntryToFileWithObfuscation(String destFileName, ZipInputStream zin) throws IOException {
        byte[] buff = new byte[0x1E00000];
        try {
            OutputStream fout = Files.newOutputStream(WrapperFactory.getNioServiceWrapper().getPath(destFileName, new String[0]), new OpenOption[0]);
            int n2 = 0;
            while ((n2 = zin.read(buff)) > -1) {
                ObfuscationUtil.negateAll(buff, n2);
                fout.write(buff, 0, n2);
            }
            fout.flush();
            fout.close();
        }
        catch (IOException e2) {
            StringBuffer db = new StringBuffer("Error in writeOneZipEntryToStream(): ");
            db.append(e2.getMessage());
            OLogger.debug(db);
            throw e2;
        }
    }

    public static void deObfuscateFileContent(Path src, Path dest, boolean all) {
        ObfuscationUtil.obfuscateFileContent(src, dest, all);
    }

    public static String ObfFileName_old(String fileFullPath) {
        File ff = new File(fileFullPath);
        String obsFilename = ObfuscationUtil.ObfString(ff.getName());
        String obfFullName = ff.getAbsoluteFile().getParent() + File.separator + obsFilename + OLD_HEX_EXT;
        OLogger.debug("Converted file name: " + fileFullPath + " to :" + obfFullName);
        return obfFullName;
    }

    public static String ObfFileName(String fileFullPath) {
        String result = null;
        File ff = new File(fileFullPath);
        String filename = ff.getName();
        String parent = ff.getParent();
        String obfuscatedFileName = ObfuscationUtil.ObfuscateFileNameHex(filename);
        if (obfuscatedFileName == filename) {
            result = fileFullPath;
            OLogger.justlog(OLogger.INFO, "No obfuscation for file:" + result + ". Filename length is:" + filename.length());
        } else {
            result = parent != null && !parent.equals("") ? ff.getParent() + File.separator + obfuscatedFileName : obfuscatedFileName;
            OLogger.debug("Converted file name: " + fileFullPath + " to :" + result);
        }
        return result;
    }

    private static String ObfuscateFileNameHex(String clearFileName) {
        String result = null;
        int len = clearFileName.length();
        if (len > 0 && len < 127) {
            result = String.format("%x", new BigInteger(1, clearFileName.getBytes())) + HEX_EXT;
        } else if (len > 126 && len < 252) {
            int obfPartLen = 252 - len;
            String obfPart = clearFileName.substring(0, obfPartLen);
            String nonObfPart = clearFileName.substring(obfPartLen);
            obfPart = String.format("%x", new BigInteger(1, obfPart.getBytes()));
            String ext = null;
            ext = len > 199 ? (len < 210 ? "-0" + Integer.toString(len - 200) : HEX_200 + Integer.toString(len - 200)) : HEX_100 + Integer.toString(len - 100);
            result = obfPart + nonObfPart + ext;
        } else {
            result = len < 255 ? clearFileName + HEX_200 : clearFileName;
        }
        return result;
    }

    private static String ObfString(String in) {
        String result = null;
        if (in.length() < 80) {
            result = String.format("%x", new BigInteger(1, in.getBytes()));
        } else {
            String hexpart = in.substring(0, 80);
            String unchangePart = in.substring(80);
            result = String.format("%x", new BigInteger(1, hexpart.getBytes())) + unchangePart;
        }
        return result;
    }

    private static String hexToString(String hexString) {
        String result = null;
        try {
            byte[] bytes = DatatypeConverter.parseHexBinary((String)hexString);
            result = new String(bytes, "UTF-8");
        }
        catch (Exception e2) {
            OLogger.justlog(OLogger.INFO, "Failed to convert from HEX to string:" + e2.getMessage());
            OLogger.justlog(OLogger.INFO, hexString + " may not be a hex encoded string");
        }
        return result;
    }

    private static String DeObfFilename_OLD(String in) {
        String result = null;
        int len = in.length();
        if (len < 4) {
            return in;
        }
        String obfFileNameNoExt = in.substring(0, len - 3);
        int len1 = obfFileNameNoExt.length();
        if (len1 < 160) {
            result = ObfuscationUtil.hexToString(obfFileNameNoExt);
            if (result == null) {
                result = in;
            }
        } else {
            String hexPart = obfFileNameNoExt.substring(0, 160);
            String unchangePart = obfFileNameNoExt.substring(160);
            String decodedHexPart = ObfuscationUtil.hexToString(hexPart);
            result = decodedHexPart != null ? decodedHexPart + unchangePart : in;
        }
        return result;
    }

    public static String DeObfFileName(String FileFullPath) {
        String result = null;
        File ff = new File(FileFullPath);
        String filename = ff.getName();
        String parent = ff.getParent();
        String deobfuscatedFileName = ObfuscationUtil.DeObfFileNameHex(filename);
        if (deobfuscatedFileName == filename) {
            result = FileFullPath;
            OLogger.debug("No deobfuscation for file:" + result + ". Filename length is:" + filename.length());
        } else {
            result = parent != null && !parent.equals("") ? ff.getParent() + File.separator + deobfuscatedFileName : deobfuscatedFileName;
            OLogger.debug("Converted file name: " + FileFullPath + " to :" + result);
        }
        return result;
    }

    public static String DeObfFileNameHex(String s) {
        String result = null;
        int len = s.length();
        if (len < 4 || len > 255) {
            return s;
        }
        String extension = s.substring(len - 3);
        if (extension.equals(OLD_HEX_EXT)) {
            return ObfuscationUtil.DeObfFilename_OLD(s);
        }
        if (extension.equals(HEX_EXT)) {
            String obfFileNameNoExt = s.substring(0, len - 3);
            String deobfFilename = ObfuscationUtil.hexToString(obfFileNameNoExt);
            if (deobfFilename == null) {
                return s;
            }
            result = deobfFilename;
        } else if (s.endsWith(HEX_200) && len > 252 && len < 256) {
            result = s.substring(0, len - 1);
        } else if (len == 255 && (extension.startsWith(HEX_100) || extension.startsWith(HEX_200))) {
            int orgLen = 0;
            try {
                orgLen = Integer.parseInt(extension.substring(1));
            }
            catch (NumberFormatException e2) {
                OLogger.justlog(OLogger.INFO, "Extension " + extension + " is not valid.");
                return s;
            }
            if (extension.startsWith(HEX_200)) {
                orgLen += 200;
            } else if (extension.startsWith(HEX_100)) {
                orgLen += 100;
            } else {
                OLogger.justlog(OLogger.INFO, "Extension " + extension + " is not valid.");
                return s;
            }
            int obfPartLen = (255 - orgLen - 3) * 2;
            String obfFileNameNoExt = s.substring(0, len - 3);
            String obfPart = obfFileNameNoExt.substring(0, obfPartLen);
            String nonObfPart = obfFileNameNoExt.substring(obfPartLen);
            String deobfPart = ObfuscationUtil.hexToString(obfPart);
            if (deobfPart == obfPart) {
                return s;
            }
            result = deobfPart + nonObfPart;
        } else {
            return s;
        }
        return result;
    }

    private static void negate(byte[] in, int len) {
        if (len == 1) {
            in[0] = ~in[0];
        } else if (len > 1) {
            in[0] = ~in[0];
            in[len - 1] = ~in[len - 1];
        }
    }

    public static void negateAll(byte[] in, int len) {
        for (int i2 = 0; i2 < len; ++i2) {
            in[i2] = ~in[i2];
        }
    }

    public static void obfuscateDirs(Path srcFile) {
        if (Files.isDirectory(srcFile, new LinkOption[0])) {
            File[] files;
            for (File file : files = srcFile.toFile().listFiles()) {
                if (file.isDirectory()) {
                    ObfuscationUtil.obfuscateDirs(file.toPath());
                    continue;
                }
                String fileStr = file.toString();
                String deObfFilename = ObfuscationUtil.DeObfFileName(fileStr);
                if (deObfFilename == fileStr) continue;
                ObfuscationUtil.deObfuscateFileContent(file.toPath(), WrapperFactory.getNioServiceWrapper().getPath(deObfFilename, new String[0]), false);
            }
        }
    }

    public static void obfuscateVerify(List<String> patchIds) {
        File[] directories;
        OLogger.justlog(OLogger.INFO, "Begin obfuscateVerify(List patchIds)\n");
        for (File dir : directories = new File(PATCH_STORAGE).listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        })) {
            String patchID = ObfuscationUtil.isPatchDir(dir);
            if (patchID == null || !patchIds.contains(patchID)) continue;
            OLogger.justlog(OLogger.INFO, "Verifying patch: " + dir.getName() + "\n");
            String backuparea = dir.toString() + File.separator + FILES;
            File backupareaFile = new File(backuparea);
            File[] files = backupareaFile.listFiles();
            ObfuscationUtil.verifyRecurDir(dir, files);
            if (obfuscatedFiles.size() > 0) {
                if (nonObfuscatedFiles.size() > 0) {
                    OLogger.println("Patch " + dir.getName() + " is obfuscated, except the following files:");
                    for (String f1 : nonObfuscatedFiles) {
                        OLogger.println(f1);
                    }
                } else {
                    OLogger.println("Patch " + dir.getName() + " is obfuscated.");
                }
            } else {
                OLogger.println("Patch " + dir.getName() + " is not obfuscated.");
            }
            obfuscatedFiles = new ArrayList<String>();
            nonObfuscatedFiles = new ArrayList<String>();
            patchIds.remove(patchID);
            OLogger.justlog(OLogger.INFO, "obfuscateVerify patch: " + dir.getName() + " is done\n");
        }
        if (patchIds.size() > 0) {
            StringBuffer nonExistPatchIds = new StringBuffer();
            for (String id : patchIds) {
                nonExistPatchIds.append(" " + id);
            }
            OLogger.println("These patches do not exist in patch storage: " + nonExistPatchIds.toString() + "\n");
        }
        OLogger.justlog(OLogger.INFO, "End obfuscatePatchStorage(List patchIds)\n");
    }

    public static void obfuscateFile(String fullpathFileLoc) {
        File file = new File(fullpathFileLoc);
        String filename = file.getName();
        if (!file.exists() || file.isDirectory()) {
            OLogger.println("File: " + fullpathFileLoc + " does not exist, or it's a directory. Please provide a file");
            return;
        }
        String obfFilename = ObfuscationUtil.ObfFileName(fullpathFileLoc);
        if (obfFilename == fullpathFileLoc) {
            OLogger.println("File: " + fullpathFileLoc + " cannot be obfuscated. Please provide a file");
            OLogger.println("Filename length is: " + filename.length());
            return;
        }
        boolean obfFlag = false;
        String obfEnVar = System.getenv("OBFUSCATE_ALL");
        obfFlag = obfEnVar != null && obfEnVar.equals("true");
        ObfuscationUtil.obfuscateFileContent(WrapperFactory.getNioServiceWrapper().getPath(fullpathFileLoc, new String[0]), WrapperFactory.getNioServiceWrapper().getPath(obfFilename, new String[0]), obfFlag);
        OLogger.println("File:" + fullpathFileLoc + " got obfuscated as:" + obfFilename);
        OLogger.println("Obfuscated all bytes:" + obfFlag);
    }

    public static void deobfuscateFile(String fullpathFileLoc) {
        File file = new File(fullpathFileLoc);
        String filename = file.getName();
        if (!file.exists() || file.isDirectory()) {
            OLogger.println("File: " + fullpathFileLoc + " does not exist, or it's a directory. Please provide an obfuscated file");
            return;
        }
        String deobfFilename = ObfuscationUtil.DeObfFileName(fullpathFileLoc);
        if (deobfFilename == fullpathFileLoc) {
            OLogger.println("File: " + fullpathFileLoc + " cannot be deobfuscated. Please provide an obfuscated file");
            OLogger.println("Filename length is: " + filename.length());
            return;
        }
        boolean obfFlag = false;
        String obfEnVar = System.getenv("OBFUSCATE_ALL");
        obfFlag = obfEnVar != null && obfEnVar.equals("true");
        ObfuscationUtil.deObfuscateFileContent(WrapperFactory.getNioServiceWrapper().getPath(fullpathFileLoc, new String[0]), WrapperFactory.getNioServiceWrapper().getPath(deobfFilename, new String[0]), obfFlag);
        OLogger.println("File:" + fullpathFileLoc + " got deobfuscated as:" + deobfFilename);
        OLogger.println("De-Obfuscated all bytes:" + obfFlag);
    }

    public static void obfuscatePatchStorage(List<String> patchIds) {
        File[] directories;
        OLogger.justlog(OLogger.INFO, "Begin obfuscatePatchStorage(List patchIds)\n");
        for (File dir : directories = new File(PATCH_STORAGE).listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        })) {
            String patchID = ObfuscationUtil.isPatchDir(dir);
            if (patchID == null || !patchIds.contains(patchID)) continue;
            OLogger.justlog(OLogger.INFO, "Obfuscating patch: " + dir.getName() + "\n");
            String backuparea = dir.toString() + File.separator + FILES;
            File backupareaFile = new File(backuparea);
            File[] files = backupareaFile.listFiles();
            ObfuscationUtil.obfuscateRecurDir(dir, files);
            patchIds.remove(patchID);
            OLogger.justlog(OLogger.INFO, "Obfuscating patch: " + dir.getName() + " is done\n");
        }
        if (patchIds.size() > 0) {
            StringBuffer nonExistPatchIds = new StringBuffer();
            for (String id : patchIds) {
                nonExistPatchIds.append(" " + id);
            }
            OLogger.justlog(OLogger.WARNING, "These patches do not exist in patch storage: " + nonExistPatchIds.toString() + "\n");
        }
        OLogger.justlog(OLogger.INFO, "End obfuscatePatchStorage(List patchIds)\n");
    }

    public static void obfuscatePatchStorage() {
        File[] directories;
        OLogger.justlog(OLogger.INFO, "Begin obfuscatePatchStorage\n");
        for (File dir : directories = new File(PATCH_STORAGE).listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        })) {
            if (ObfuscationUtil.isPatchDir(dir) == null) continue;
            OLogger.justlog(OLogger.INFO, "Obfuscating patch: " + dir.getName() + "\n");
            String backuparea = dir.toString() + File.separator + FILES;
            File backupareaFile = new File(backuparea);
            File[] files = backupareaFile.listFiles();
            ObfuscationUtil.obfuscateRecurDir(dir, files);
            OLogger.justlog(OLogger.INFO, "Obfuscating patch: " + dir.getName() + " is done\n");
        }
        OLogger.justlog(OLogger.INFO, "End obfuscatePatchStorage\n");
    }

    public static void deobfuscatePatchStorage(List<String> patchIds) {
        File[] directories;
        OLogger.justlog(OLogger.INFO, "Begin deobfuscatePatchStorage(List patchIds)\n");
        for (File dir : directories = new File(PATCH_STORAGE).listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        })) {
            String patchID = ObfuscationUtil.isPatchDir(dir);
            if (patchID == null || !patchIds.contains(patchID)) continue;
            OLogger.justlog(OLogger.INFO, "Deobfuscating patch: " + dir.getName() + "\n");
            String backuparea = dir.toString() + File.separator + FILES;
            File backupareaFile = new File(backuparea);
            File[] files = backupareaFile.listFiles();
            ObfuscationUtil.deObfuscateRecurDir(dir, files);
            patchIds.remove(patchID);
            OLogger.justlog(OLogger.INFO, "Deobfuscating patch: " + dir.getName() + " is done\n");
        }
        if (patchIds.size() > 0) {
            StringBuffer nonExistPatchIds = new StringBuffer();
            for (String id : patchIds) {
                nonExistPatchIds.append(" " + id);
            }
            OLogger.justlog(OLogger.WARNING, "These patches do not exist in patch storage: " + nonExistPatchIds.toString() + "\n");
        }
        OLogger.justlog(OLogger.INFO, "deobfuscatePatchStorage(List patchIds)\n");
    }

    public static void deobfuscatePatchStorage() {
        File[] directories;
        OLogger.justlog(OLogger.INFO, "Begin deobfuscatePatchStorage\n");
        for (File dir : directories = new File(PATCH_STORAGE).listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        })) {
            if (ObfuscationUtil.isPatchDir(dir) == null) continue;
            OLogger.justlog(OLogger.INFO, "Deobfuscating patch: " + dir.getName() + "\n");
            String backuparea = dir.toString() + File.separator + FILES;
            File backupareaFile = new File(backuparea);
            File[] files = backupareaFile.listFiles();
            ObfuscationUtil.deObfuscateRecurDir(dir, files);
            OLogger.justlog(OLogger.INFO, "Deobfuscating patch: " + dir.getName() + " is done\n");
        }
        OLogger.justlog(OLogger.INFO, "End deobfuscatePatchStorage\n");
    }

    private static void deObfuscateRecurDir(File patch, File[] files) {
        if (files == null) {
            OLogger.justlog(OLogger.INFO, "Patch " + patch.toString() + " has no backup files\n");
            return;
        }
        for (File f2 : files) {
            if (f2.isFile()) {
                String filename = f2.toString();
                if (filename.endsWith("+") || filename.endsWith(".zip")) {
                    ObfuscationUtil.deObfuscateZipFileShalow(patch, f2);
                    continue;
                }
                String clearFileName = ObfuscationUtil.DeObfFileName(filename);
                if (clearFileName != filename) {
                    boolean obfuscateAll = false;
                    int index = clearFileName.indexOf(".jar");
                    int len = clearFileName.length();
                    obfuscateAll = index != -1 && index != len - 4;
                    ObfuscationUtil.deObfuscateFileContent(Paths.get(filename, new String[0]), Paths.get(clearFileName, new String[0]), obfuscateAll);
                    try {
                        Files.delete(Paths.get(filename, new String[0]));
                        continue;
                    }
                    catch (IOException e2) {
                        OLogger.justlog(OLogger.SEVERE, "IOException:Failed to remove original file after obfuscation " + e2.getMessage() + "\n");
                        return;
                    }
                }
                OLogger.justlog(OLogger.WARNING, "Patch " + patch.toString() + " is not yet obfuscated\n");
                continue;
            }
            if (!f2.isDirectory()) continue;
            File[] subdirFiles = f2.listFiles();
            ObfuscationUtil.deObfuscateRecurDir(patch, subdirFiles);
        }
    }

    private static void deObfuscateRecurDirShalow(File patch, File[] files) {
        if (files == null) {
            OLogger.justlog(OLogger.INFO, "Patch " + patch.toString() + " has no backup files\n");
            return;
        }
        for (File f2 : files) {
            if (f2.isFile()) {
                String filename = f2.toString();
                String clearFileName = ObfuscationUtil.DeObfFileName(filename);
                if (clearFileName != filename) {
                    boolean obfuscateAll = false;
                    int index = clearFileName.indexOf(".jar");
                    int len = clearFileName.length();
                    obfuscateAll = index != -1 && index != len - 4;
                    ObfuscationUtil.deObfuscateFileContent(Paths.get(filename, new String[0]), Paths.get(clearFileName, new String[0]), obfuscateAll);
                    try {
                        Files.delete(Paths.get(filename, new String[0]));
                        continue;
                    }
                    catch (IOException e2) {
                        OLogger.justlog(OLogger.SEVERE, "IOException:Failed to remove original file after obfuscation " + e2.getMessage() + "\n");
                        return;
                    }
                }
                OLogger.justlog(OLogger.WARNING, "Patch " + patch.toString() + " is not yet obfuscated\n");
                continue;
            }
            if (!f2.isDirectory()) continue;
            File[] subdirFiles = f2.listFiles();
            ObfuscationUtil.deObfuscateRecurDirShalow(patch, subdirFiles);
        }
    }

    private static String isPatchDir(File dir) {
        String filename = dir.getName();
        String[] tokens = filename.split(HEX_100);
        if (tokens[0] != null && tokens[0].length() > 0) {
            try {
                int value = Integer.parseInt(tokens[0]);
                return tokens[0];
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private static void obfuscateRecurDir(File patch, File[] files) {
        if (files == null) {
            OLogger.justlog(OLogger.INFO, "Patch " + patch.toString() + " has no backup files\n");
            return;
        }
        for (File f2 : files) {
            if (f2.isFile()) {
                String filename = f2.toString();
                if (filename.endsWith("+") || filename.endsWith(".zip")) {
                    ObfuscationUtil.obfuscateZipFile(patch, f2);
                    continue;
                }
                String obfFilename = ObfuscationUtil.DeObfFileName(filename);
                if (obfFilename != filename) {
                    OLogger.debug("File: " + filename + " in Patch " + patch.toString() + " is already obfuscated.\n");
                    continue;
                }
                boolean obfuscateAll = false;
                int index = filename.indexOf(".jar");
                int len = filename.length();
                obfuscateAll = index != -1 && index != len - 4;
                obfFilename = ObfuscationUtil.ObfFileName(filename);
                if (obfFilename == filename) continue;
                ObfuscationUtil.obfuscateFileContent(Paths.get(filename, new String[0]), Paths.get(obfFilename, new String[0]), obfuscateAll);
                try {
                    Files.delete(Paths.get(filename, new String[0]));
                    continue;
                }
                catch (IOException e2) {
                    OLogger.justlog(OLogger.SEVERE, "IOException:Failed to remove original file after obfuscation " + e2.getMessage() + "\n");
                    return;
                }
            }
            if (!f2.isDirectory()) continue;
            File[] subdirFiles = f2.listFiles();
            ObfuscationUtil.obfuscateRecurDir(patch, subdirFiles);
        }
    }

    private static void verifyRecurDir(File patch, File[] files) {
        if (files == null) {
            OLogger.justlog(OLogger.INFO, "Patch " + patch.toString() + " has no backup files\n");
            return;
        }
        for (File f2 : files) {
            if (f2.isFile()) {
                String filename = f2.toString();
                if (filename.endsWith("+") || filename.endsWith(".zip")) {
                    ObfuscationUtil.verifyObfuscateZipFile(patch, f2);
                    continue;
                }
                String clearFileName = ObfuscationUtil.DeObfFileName(filename);
                if (clearFileName != filename) {
                    obfuscatedFiles.add(clearFileName);
                    continue;
                }
                nonObfuscatedFiles.add(filename);
                continue;
            }
            if (!f2.isDirectory()) continue;
            File[] subdirFiles = f2.listFiles();
            ObfuscationUtil.verifyRecurDir(patch, subdirFiles);
        }
    }

    private static void deleteDirectory(File dir) {
        File[] files;
        if (dir.exists() && dir.isDirectory() && (files = dir.listFiles()) != null) {
            for (File f2 : files) {
                ObfuscationUtil.deleteDirectory(f2);
            }
        }
        dir.delete();
    }

    private static void obfuscateZipFile(File patch, File f2) {
        String scratch = patch.toString() + File.separator + "scratch";
        File scratchFile = new File(scratch);
        try {
            if (scratchFile.exists()) {
                ObfuscationUtil.deleteDirectory(scratchFile);
            }
            ZipUtilities.unzip(f2.toString(), scratch);
            File[] files = scratchFile.listFiles();
            ObfuscationUtil.obfuscateRecurDir(patch, files);
            String fString = f2.toString();
            if (fString.endsWith(".zip")) {
                fString = fString.substring(0, fString.length() - ".zip".length()) + "+";
                if (f2.exists()) {
                    Files.delete(f2.toPath());
                }
            }
            f2 = new File(fString);
            ZipUtilities.compressZipUnder(f2.toString(), scratch);
        }
        catch (Exception e2) {
            OLogger.justlog(OLogger.SEVERE, "Failed to zip obfuscated files: " + e2.getMessage() + "\n");
            return;
        }
    }

    private static void verifyObfuscateZipFile(File patch, File f2) {
        OLogger.debug("Begin verifyObfuscateZipFile\n");
        String scratch = patch.toString() + File.separator + "scratch";
        File scratchFile = new File(scratch);
        try {
            if (scratchFile.exists()) {
                ObfuscationUtil.deleteDirectory(scratchFile);
            }
            ZipUtilities.unzip(f2.toString(), scratch);
            File[] files = scratchFile.listFiles();
            ObfuscationUtil.verifyRecurDir(patch, files);
        }
        catch (Exception e2) {
            OLogger.justlog(OLogger.SEVERE, "Failed to zip deObfuscated files: " + e2.getMessage() + "\n");
            return;
        }
        OLogger.debug("End verifyObfuscateZipFile\n");
    }

    private static void deObfuscateZipFileShalow(File patch, File f2) {
        OLogger.debug("Begin deObfuscateZipFileShalow\n");
        String scratch = patch.toString() + File.separator + "scratch";
        File scratchFile = new File(scratch);
        try {
            if (scratchFile.exists()) {
                ObfuscationUtil.deleteDirectory(scratchFile);
            }
            ZipUtilities.unzip(f2.toString(), scratch);
            File[] files = scratchFile.listFiles();
            ObfuscationUtil.deObfuscateRecurDirShalow(patch, files);
            String fString = f2.toString();
            f2 = new File(fString);
            ZipUtilities.compressZipUnder(f2.toString(), scratch);
        }
        catch (Exception e2) {
            OLogger.justlog(OLogger.SEVERE, "Failed to zip deObfuscated files: " + e2.getMessage() + "\n");
            return;
        }
        OLogger.debug("End deObfuscateZipFileShalow\n");
    }
}

