/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.patchsdk;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatch.patchsdk.OPatchSingletonPatch;
import oracle.opatch.patchsdk.OPatchZipStringResource;
import oracle.opatch.patchsdk.PatchPackageException;
import oracle.opatch.patchsdk.PatchValidatorAndGenerator;
import oracle.opatch.patchsdk.patchmodel.PatchPackage;
import oracle.opatch.wrappers.WrapperFactory;

public class OPatchSingletonPatchValidatorAndGenerator
implements PatchValidatorAndGenerator {
    @Override
    public boolean isPatchValid(String patchLocation) {
        try {
            OPatchPatch oPatchPatch = new OPatchPatch(patchLocation);
        }
        catch (Exception e2) {
            return false;
        }
        return true;
    }

    @Override
    public boolean isPatchValid(Map map) {
        HashMap invMap = (HashMap)map.get(OPatchZipStringResource.INVENTORY);
        HashMap actionMap = (HashMap)map.get(OPatchZipStringResource.ACTION);
        int invNum = invMap.size();
        int actionNum = actionMap.size();
        Boolean isValid = true;
        if (invNum == 1 && actionNum == 1) {
            String invPath = (String)invMap.keySet().toArray()[0];
            String actionPath = (String)actionMap.keySet().toArray()[0];
            Pattern invPartern = Pattern.compile("\\d+/etc/config/inventory\\.xml");
            Pattern actionPartern = Pattern.compile("\\d+/etc/config/actions\\.xml");
            Matcher invMatcher = invPartern.matcher(invPath);
            Matcher actionMatcher = actionPartern.matcher(actionPath);
            if (!invMatcher.matches()) {
                isValid = false;
            }
            if (!actionMatcher.matches()) {
                isValid = false;
            }
        } else {
            isValid = false;
        }
        return isValid;
    }

    @Override
    public PatchPackage generate(String patchLocation) {
        OPatchSingletonPatch patch = new OPatchSingletonPatch(patchLocation);
        try {
            OPatchPatch po = new OPatchPatch(patchLocation);
            patch.setPatchID(po.getPatchId());
            patch.setPatchObject(po);
            this.constructSingletonPatchAutomationMetadata(patch);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            patch = null;
        }
        return patch;
    }

    @Override
    public PatchPackage generate(Map map) throws PatchPackageException {
        OPatchSingletonPatch patch = null;
        try {
            Map patchmap = OPatchPatch.getPatches((Map)map);
            OPatchPatch po = (OPatchPatch)patchmap.values().toArray()[0];
            patch = new OPatchSingletonPatch(po);
            String topDirName = (String)map.get(OPatchZipStringResource.TOPDIRNAME);
            patch.setPatchLocation(topDirName);
            patch.setPatchID(po.getPatchId());
            this.constructSingletonPatchAutomationMetadata(patch, map);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            patch = null;
        }
        return patch;
    }

    @Override
    public String getPatchTool() {
        return "OPATCH";
    }

    private void constructSingletonPatchAutomationMetadata(OPatchSingletonPatch patch, Map map) {
        try {
            Map apply_auto_map = (Map)map.get(OPatchZipStringResource.APPLYAUTO_ETC);
            Map auto_map = (Map)map.get(OPatchZipStringResource.AUTO_ETC);
            Map rollback_auto_map = (Map)map.get(OPatchZipStringResource.ROLLBACKAUTO_ETC);
            String etcConfig = File.separator + "etc" + File.separator + "config" + File.separator;
            if (apply_auto_map.size() != 0) {
                byte[] apply_auto = (byte[])apply_auto_map.values().toArray()[0];
                patch.setApplyAutomationXMLLoc(apply_auto_map.keySet().toArray()[0] + etcConfig + "apply_automation.xml");
            } else if (auto_map.size() != 0) {
                byte[] auto = (byte[])auto_map.values().toArray()[0];
                patch.setApplyAutomationXMLLoc(auto_map.keySet().toArray()[0] + etcConfig + "automation.xml");
            }
            if (rollback_auto_map.size() != 0) {
                byte[] rollback_auto = (byte[])rollback_auto_map.values().toArray()[0];
                patch.setRollbackAutomationXMLLoc(rollback_auto_map.keySet().toArray()[0] + etcConfig + "rollback_automation.xml");
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            String msg = "Not able to get automation elements of the patch.";
            throw new RuntimeException(msg);
        }
    }

    private void constructSingletonPatchAutomationMetadata(OPatchSingletonPatch patch) {
        try {
            StringBuffer applyAutomationXMLLoc = new StringBuffer(patch.getPatchLocation());
            applyAutomationXMLLoc.append(File.separator);
            applyAutomationXMLLoc.append("etc");
            applyAutomationXMLLoc.append(File.separator);
            applyAutomationXMLLoc.append("config");
            applyAutomationXMLLoc.append(File.separator);
            applyAutomationXMLLoc.append("apply_automation.xml");
            Path applyAutomationXML = WrapperFactory.getNioServiceWrapper().getPath(applyAutomationXMLLoc.toString(), new String[0]);
            if (Files.exists(applyAutomationXML, new LinkOption[0])) {
                patch.setApplyAutomationXMLLoc(applyAutomationXML.toAbsolutePath().toString());
            } else {
                applyAutomationXMLLoc = new StringBuffer(patch.getPatchLocation());
                applyAutomationXMLLoc.append(File.separator);
                applyAutomationXMLLoc.append("etc");
                applyAutomationXMLLoc.append(File.separator);
                applyAutomationXMLLoc.append("config");
                applyAutomationXMLLoc.append(File.separator);
                applyAutomationXMLLoc.append("automation.xml");
                applyAutomationXML = WrapperFactory.getNioServiceWrapper().getPath(applyAutomationXMLLoc.toString(), new String[0]);
                if (Files.exists(applyAutomationXML, new LinkOption[0])) {
                    patch.setApplyAutomationXMLLoc(applyAutomationXML.toAbsolutePath().toString());
                }
            }
            StringBuffer rollbackAutomationXMLLoc = new StringBuffer(patch.getPatchLocation());
            rollbackAutomationXMLLoc.append(File.separator);
            rollbackAutomationXMLLoc.append("etc");
            rollbackAutomationXMLLoc.append(File.separator);
            rollbackAutomationXMLLoc.append("config");
            rollbackAutomationXMLLoc.append(File.separator);
            rollbackAutomationXMLLoc.append("rollback_automation.xml");
            Path rollbackAutomationXML = WrapperFactory.getNioServiceWrapper().getPath(rollbackAutomationXMLLoc.toString(), new String[0]);
            if (Files.exists(rollbackAutomationXML, new LinkOption[0])) {
                patch.setRollbackAutomationXMLLoc(rollbackAutomationXML.toAbsolutePath().toString());
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            String msg = "Not able to get automation elements of the patch.";
            throw new RuntimeException(msg);
        }
    }
}

