/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.patchsdk;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import oracle.opatch.OPatchVersionSpecific;
import oracle.opatch.PatchObject;
import oracle.opatch.patchsdk.OPatchZipStringResource;
import oracle.opatch.patchsdk.PatchPackageException;
import oracle.opatch.patchsdk.ZipStreamMapConstructor;
import oracle.opatch.patchverbs.ParserObject;

public class OPatchZipStreamMapConstructor
implements ZipStreamMapConstructor {
    HashMap<String, byte[]> actionStreamMap = new HashMap();
    HashMap<String, byte[]> invStreamMap = new HashMap();
    HashMap<String, byte[]> autoStreamMap_etc = new HashMap();
    HashMap<String, byte[]> applyAutoStreamMap_etc = new HashMap();
    HashMap<String, byte[]> rollbackAutoStreamMap_etc = new HashMap();
    HashMap<String, byte[]> deployStreamMap = new HashMap();
    HashMap<String, byte[]> cksumStreamMap = new HashMap();
    Object[] bundleXMLStreamArray = new Object[0];
    Object[] applyAutoStreamArray = new Object[0];
    Object[] rollbackAutoStreamArray = new Object[0];
    Object[] messageStreamArray = new Object[0];
    HashMap<String, byte[]> autoStreamsMap = new HashMap();
    HashMap<String, byte[]> compositeStreamMap = new HashMap();
    HashMap<String, PatchObject> patchesMap = new HashMap();
    String topDirName = "";
    HashMap<String, Object> totalMap = new HashMap();

    @Override
    public HashMap<String, Object> ConstructMap(ZipInputStream zStream) throws PatchPackageException {
        if (zStream == null) {
            throw new PatchPackageException("The input stream of OPatch compatible patch is <null>. Please check input.");
        }
        try {
            byte[] tempBytes = null;
            ZipEntry ze = null;
            boolean topLevel = true;
            HashMap<String, byte[]> tempActionMap = new HashMap<String, byte[]>();
            HashMap<String, byte[]> tempInventoryMap = new HashMap<String, byte[]>();
            while ((ze = zStream.getNextEntry()) != null) {
                PatchObject po;
                String entryName = ze.getName();
                if (topLevel) {
                    String dirName;
                    this.topDirName = entryName;
                    int divZeName = this.topDirName.indexOf("/");
                    this.topDirName = dirName = this.topDirName.substring(0, divZeName);
                    topLevel = false;
                    continue;
                }
                String patternStr = "((" + this.topDirName + "/)?((\\d+)((/\\d+)|(_.+)|(/custom/server/(\\d+).*))?)?)";
                String etcConfig = File.separator + "etc" + File.separator + "config" + File.separator;
                etcConfig = etcConfig.replace('\\', '/');
                String actionPtrnStr = patternStr + etcConfig + "actions(\\.xml)";
                String invPtrnStr = patternStr + etcConfig + "inventory(\\.xml)";
                String autoPtrnStr = patternStr + etcConfig + "automation.xml";
                String applyAutoPtrnStr = patternStr + etcConfig + "apply_automation.xml";
                String rollbackAutoPtrnStr = patternStr + etcConfig + "rollback_automation.xml";
                String depPtrnStr = patternStr + etcConfig + "deploy.xml";
                String checkPtrnStr = patternStr + etcConfig + "checksum.xml";
                String compositeStr = patternStr + etcConfig + "composite(\\.xml)";
                Pattern actionPattern = Pattern.compile(actionPtrnStr);
                Pattern invPattern = Pattern.compile(invPtrnStr);
                Pattern autoPattern = Pattern.compile(autoPtrnStr);
                Pattern applyAutoPattern = Pattern.compile(applyAutoPtrnStr);
                Pattern rollbackAutoPattern = Pattern.compile(rollbackAutoPtrnStr);
                Pattern depPattern = Pattern.compile(depPtrnStr);
                Pattern checkPattern = Pattern.compile(checkPtrnStr);
                Pattern compositePattern = Pattern.compile(compositeStr);
                Matcher actionMatcher = actionPattern.matcher(entryName);
                Matcher invMatcher = invPattern.matcher(entryName);
                Matcher autoMatcher = autoPattern.matcher(entryName);
                Matcher applyAutoMatcher = applyAutoPattern.matcher(entryName);
                Matcher rollbackAutoMatcher = rollbackAutoPattern.matcher(entryName);
                Matcher depMatcher = depPattern.matcher(entryName);
                Matcher checkMatcher = checkPattern.matcher(entryName);
                Matcher compositeMatcher = compositePattern.matcher(entryName);
                String bundleEntry = this.topDirName + File.separator + "bundle.xml";
                bundleEntry = bundleEntry.replace('\\', '/');
                String giBundleEntry = "bundle.xml";
                String applyAutoEntry = this.topDirName + File.separator + "automation" + File.separator + "apply_automation.xml";
                String giapplyAutoEntry = "automation" + File.separator + "apply_automation.xml";
                applyAutoEntry = applyAutoEntry.replace('\\', '/');
                giapplyAutoEntry = giapplyAutoEntry.replace('\\', '/');
                String rollbackAutoEntry = this.topDirName + File.separator + "automation" + File.separator + "rollback_automation.xml";
                String giRollbackAutoEntry = "automation" + File.separator + "rollback_automation.xml";
                rollbackAutoEntry = rollbackAutoEntry.replace('\\', '/');
                giRollbackAutoEntry = giRollbackAutoEntry.replace('\\', '/');
                String messageEntry = this.topDirName + File.separator + "automation" + File.separator + "messages.properties";
                String gimessageEntry = "automation" + File.separator + "messages.properties";
                messageEntry = messageEntry.replace('\\', '/');
                gimessageEntry = gimessageEntry.replace('\\', '/');
                String autosStream = "(" + this.topDirName + "/)?automation/(.+)\\.xml";
                Pattern autosPattern = Pattern.compile(autosStream);
                Matcher autosMatcher = autosPattern.matcher(entryName);
                if (compositeMatcher.matches()) {
                    String comPatchLocation = compositeMatcher.group(1);
                    Pattern comPatchPattern = Pattern.compile("(.*)(/.*)");
                    Matcher comPatchMatcher = comPatchPattern.matcher(comPatchLocation);
                    if (comPatchMatcher.matches()) {
                        this.compositeStreamMap.put(comPatchMatcher.group(1), OPatchZipStreamMapConstructor.readBytes(ze, zStream));
                    }
                }
                if (autosMatcher.matches()) {
                    tempBytes = OPatchZipStreamMapConstructor.readBytes(ze, zStream);
                    this.autoStreamsMap.put(entryName, tempBytes);
                    if (entryName.equals(applyAutoEntry) || entryName.equals(giapplyAutoEntry)) {
                        this.applyAutoStreamArray = new Object[2];
                        this.applyAutoStreamArray[0] = entryName;
                        this.applyAutoStreamArray[1] = tempBytes;
                    }
                    if (entryName.equals(rollbackAutoEntry) || entryName.equals(giRollbackAutoEntry)) {
                        this.rollbackAutoStreamArray = new Object[2];
                        this.rollbackAutoStreamArray[0] = entryName;
                        this.rollbackAutoStreamArray[1] = tempBytes;
                    }
                }
                if (actionMatcher.matches()) {
                    tempBytes = OPatchZipStreamMapConstructor.readBytes(ze, zStream);
                    if (tempInventoryMap.get(actionMatcher.group(1)) != null) {
                        byte[] invBytes = (byte[])tempInventoryMap.get(actionMatcher.group(1));
                        po = new PatchObject(new ByteArrayInputStream(invBytes), new ByteArrayInputStream(tempBytes), null);
                        this.patchesMap.put(actionMatcher.group(1), po);
                    }
                    tempActionMap.put(actionMatcher.group(1), tempBytes);
                    this.actionStreamMap.put(entryName, tempBytes);
                }
                if (invMatcher.matches()) {
                    tempBytes = OPatchZipStreamMapConstructor.readBytes(ze, zStream);
                    if (tempActionMap.get(invMatcher.group(1)) != null) {
                        byte[] actionBytes = (byte[])tempActionMap.get(invMatcher.group(1));
                        po = new PatchObject(new ByteArrayInputStream(tempBytes), new ByteArrayInputStream(actionBytes), null);
                        this.patchesMap.put(invMatcher.group(1), po);
                    }
                    tempInventoryMap.put(invMatcher.group(1), tempBytes);
                    this.invStreamMap.put(entryName, tempBytes);
                }
                if (autoMatcher.matches()) {
                    this.autoStreamMap_etc.put(autoMatcher.group(1), OPatchZipStreamMapConstructor.readBytes(ze, zStream));
                }
                if (applyAutoMatcher.matches()) {
                    this.applyAutoStreamMap_etc.put(applyAutoMatcher.group(1), OPatchZipStreamMapConstructor.readBytes(ze, zStream));
                }
                if (rollbackAutoMatcher.matches()) {
                    this.rollbackAutoStreamMap_etc.put(rollbackAutoMatcher.group(1), OPatchZipStreamMapConstructor.readBytes(ze, zStream));
                }
                if (depMatcher.matches()) {
                    this.deployStreamMap.put(depMatcher.group(1), OPatchZipStreamMapConstructor.readBytes(ze, zStream));
                }
                if (checkMatcher.matches()) {
                    this.cksumStreamMap.put(checkMatcher.group(1), OPatchZipStreamMapConstructor.readBytes(ze, zStream));
                }
                if (entryName.equals(bundleEntry) || entryName.equals(giBundleEntry)) {
                    this.bundleXMLStreamArray = new Object[2];
                    this.bundleXMLStreamArray[0] = entryName;
                    this.bundleXMLStreamArray[1] = OPatchZipStreamMapConstructor.readBytes(ze, zStream);
                }
                if (!entryName.equals(messageEntry) && !entryName.equals(gimessageEntry)) continue;
                this.messageStreamArray = new Object[2];
                this.messageStreamArray[0] = entryName;
                this.messageStreamArray[1] = OPatchZipStreamMapConstructor.readBytes(ze, zStream);
            }
            for (String key : this.patchesMap.keySet()) {
                ParserObject pb;
                PatchObject po = this.patchesMap.get(key);
                ArrayList<ParserObject> parsers = new ArrayList<ParserObject>();
                if (this.autoStreamMap_etc.get(key) != null) {
                    pb = OPatchVersionSpecific.loadAutomationFileStream(new ByteArrayInputStream(this.autoStreamMap_etc.get(key)));
                    pb.setFileName("automation.xml");
                    parsers.add(pb);
                }
                if (this.applyAutoStreamMap_etc.get(key) != null) {
                    pb = OPatchVersionSpecific.loadAutomationFileStream(new ByteArrayInputStream(this.applyAutoStreamMap_etc.get(key)));
                    pb.setFileName("apply_automation.xml");
                    parsers.add(pb);
                }
                if (this.rollbackAutoStreamMap_etc.get(key) != null) {
                    pb = OPatchVersionSpecific.loadAutomationFileStream(new ByteArrayInputStream(this.rollbackAutoStreamMap_etc.get(key)));
                    pb.setFileName("rollback_automation.xml");
                    parsers.add(pb);
                }
                po.setParserObject(parsers);
                if (this.deployStreamMap.get(key) != null) {
                    po.loadDeployStream(new ByteArrayInputStream(this.deployStreamMap.get(key)));
                }
                if (this.cksumStreamMap.get(key) == null) continue;
                po.loadChecksumStream(new ByteArrayInputStream(this.cksumStreamMap.get(key)));
            }
            this.totalMap.put(OPatchZipStringResource.ACTION, this.actionStreamMap);
            this.totalMap.put(OPatchZipStringResource.INVENTORY, this.invStreamMap);
            this.totalMap.put(OPatchZipStringResource.AUTO_ETC, this.autoStreamMap_etc);
            this.totalMap.put(OPatchZipStringResource.APPLYAUTO_ETC, this.applyAutoStreamMap_etc);
            this.totalMap.put(OPatchZipStringResource.ROLLBACKAUTO_ETC, this.rollbackAutoStreamMap_etc);
            this.totalMap.put(OPatchZipStringResource.DEPLOY, this.deployStreamMap);
            this.totalMap.put(OPatchZipStringResource.CKSUM, this.cksumStreamMap);
            this.totalMap.put(OPatchZipStringResource.BUNDLE, this.bundleXMLStreamArray);
            this.totalMap.put(OPatchZipStringResource.APPLYAUTO, this.applyAutoStreamArray);
            this.totalMap.put(OPatchZipStringResource.ROLLBACKAUTO, this.rollbackAutoStreamArray);
            this.totalMap.put(OPatchZipStringResource.AUTOS, this.autoStreamsMap);
            this.totalMap.put(OPatchZipStringResource.COMPOSITE, this.compositeStreamMap);
            this.totalMap.put(OPatchZipStringResource.PATCHESMAP, this.patchesMap);
            this.totalMap.put(OPatchZipStringResource.TOPDIRNAME, this.topDirName);
            this.totalMap.put(OPatchZipStringResource.MESSAGE, this.messageStreamArray);
        }
        catch (Exception e2) {
            PatchPackageException oe = new PatchPackageException(e2.getMessage());
            oe.setStackTrace(e2.getStackTrace());
            throw oe;
        }
        return this.totalMap;
    }

    private static byte[] readBytes(ZipEntry ze, ZipInputStream zStream) throws Exception {
        int off = 0;
        int len = -1;
        byte[] data = new byte[(int)ze.getSize()];
        while ((len = zStream.read(data, off, (int)ze.getSize() - off)) > 0) {
            off += len;
        }
        return data;
    }
}

