/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.patchsdk.engineeredsystem;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.patchsdk.PatchPackageException;
import oracle.opatch.patchsdk.PatchValidatorAndGenerator;
import oracle.opatch.patchsdk.ZipStringResource;
import oracle.opatch.patchsdk.bundle_xml.SystemPatchBundleXML;
import oracle.opatch.patchsdk.bundle_xml.fvalue;
import oracle.opatch.patchsdk.engineeredsystem.HashComputeFunction;
import oracle.opatch.patchsdk.engineeredsystem.IncludeAutomationXml;
import oracle.opatch.patchsdk.engineeredsystem.InventoryAndActionOnly;
import oracle.opatch.patchsdk.engineeredsystem.InventoryAndActionOnlyV2;
import oracle.opatch.patchsdk.patchmodel.EngineeredSystemPatch;
import oracle.opatch.patchsdk.patchmodel.GenericPatch;
import oracle.opatch.patchsdk.patchmodel.PatchPackage;
import oracle.opatch.patchsdk.util.BundleValidationException;
import oracle.opatch.patchsdk.util.BundleXmlException;
import oracle.opatch.patchsdk.util.BundleXmlHelper;
import oracle.opatch.wrappers.WrapperFactory;

public class EngineeredSystemPatchValidatorAndGenerator
implements PatchValidatorAndGenerator {
    private static String fileSeparator = File.separator;
    static Logger logger = Logger.getLogger(EngineeredSystemPatchValidatorAndGenerator.class.getName());
    public static final String BUNDLE_XML = "bundle.xml";
    public static final String AUTOMATION_XML = "automation";
    public static final String BUNDLE_XML_NAME = "bundle.xml";
    public static final String RESOURCE_BUNDLE = "messages.properties";
    public static final String ETC_CONFIG = "etc" + fileSeparator + "config";
    public static final String ACTIONS_XML = ETC_CONFIG + fileSeparator + "actions.xml";
    public static final String INVENTORY_XML = ETC_CONFIG + fileSeparator + "inventory.xml";
    public static final String COMPOSITE_XML = ETC_CONFIG + fileSeparator + "composite.xml";
    public static HashMap<Integer, HashComputeFunction> hashFunctions = new HashMap();

    @Override
    public boolean isPatchValid(String patchLocation) throws PatchPackageException {
        HashComputeFunction trueFunc;
        SystemPatchBundleXML esysbundle;
        assert (patchLocation != null);
        Path patchDir = WrapperFactory.getNioServiceWrapper().getPath(patchLocation, new String[0]);
        if (!Files.exists(patchDir, new LinkOption[0])) {
            throw new PatchPackageException("The given patchLocation " + patchLocation + " does not exist");
        }
        if (!Files.isDirectory(patchDir, new LinkOption[0])) {
            throw new PatchPackageException("The patch specified by the given location " + patchLocation + " is not a directory");
        }
        StringBuffer bundleXMLLoc = new StringBuffer(patchLocation);
        bundleXMLLoc.append(fileSeparator);
        bundleXMLLoc.append("bundle.xml");
        Path bxml = WrapperFactory.getNioServiceWrapper().getPath(bundleXMLLoc.toString(), new String[0]);
        if (!Files.exists(bxml, new LinkOption[0])) {
            logger.log(Level.INFO, "Bundle.xml was not found at the given patch location " + patchLocation);
            return false;
        }
        if (!Files.isRegularFile(bxml, new LinkOption[0])) {
            logger.log(Level.INFO, "Bundle.xml was found but it is not a file.");
            throw new PatchPackageException("Bundle.xml was found at location " + bxml.toAbsolutePath().toString() + " but it is not a file");
        }
        try {
            BundleXmlHelper bhxml = new BundleXmlHelper();
            esysbundle = bhxml.readBundle(bxml);
        }
        catch (BundleXmlException e2) {
            throw new PatchPackageException("Exception was thrown while creating the bundleXml object from the bundleXml. ", e2);
        }
        catch (BundleValidationException e3) {
            logger.log(Level.INFO, "The given patch has bundle.xml but it could not bevalidated to be a Engineered System Patch bundleXml. ");
            return false;
        }
        fvalue fv = esysbundle.getFvalue();
        String hv = fv.getValue();
        if (hv == null) {
            hv = new String();
        }
        String function = fv.getFunction();
        int hashAlgo = 0;
        if (hv.length() >= 64) {
            hashAlgo = 1;
        }
        if ((trueFunc = hashFunctions.get(new Integer(function))) != null) {
            List<String> metaList = trueFunc.fileList(patchLocation, esysbundle);
            String valueComp = trueFunc.computeHash(metaList, hashAlgo);
            if (!valueComp.equals(hv)) {
                throw new PatchPackageException("Engineered System Patch may be modified. Please try the same patch from MOS");
            }
        } else {
            throw new PatchPackageException("Hash function of fvalue in \"" + bxml.toAbsolutePath().toString() + "\" is not supported in current version.");
        }
        return true;
    }

    @Override
    public boolean isPatchValid(Map map) throws PatchPackageException {
        HashComputeFunction trueFunc;
        SystemPatchBundleXML esysbundle;
        assert (!map.isEmpty());
        Object[] bundleXMLArray = (Object[])map.get(ZipStringResource.BUNDLE);
        if (bundleXMLArray.length == 0) {
            logger.log(Level.FINE, "Bundle.xml was not found in the given patch zip file ");
            return false;
        }
        Object[] applyAutoArray = (Object[])map.get(ZipStringResource.APPLYAUTO);
        Object[] rollbackAutoArray = (Object[])map.get(ZipStringResource.ROLLBACKAUTO);
        ByteArrayInputStream bundleXML = new ByteArrayInputStream((byte[])bundleXMLArray[1]);
        byte[] applyAutomation = null;
        byte[] rollbackAutomation = null;
        String applyAutoEntry = null;
        String rollbackAutoEntry = null;
        if (applyAutoArray != null && applyAutoArray.length != 0) {
            applyAutomation = (byte[])applyAutoArray[1];
            applyAutoEntry = (String)applyAutoArray[0];
        }
        if (rollbackAutoArray != null && rollbackAutoArray.length != 0) {
            rollbackAutomation = (byte[])rollbackAutoArray[1];
            rollbackAutoEntry = (String)rollbackAutoArray[0];
        }
        HashMap<String, byte[]> metaMap = new HashMap<String, byte[]>();
        if (map.containsKey(ZipStringResource.INVENTORY)) {
            Map inventoryAutoMap = (Map)map.get(ZipStringResource.INVENTORY);
            for (Map.Entry invEntry : inventoryAutoMap.entrySet()) {
                metaMap.put((String)invEntry.getKey(), (byte[])invEntry.getValue());
            }
        }
        if (map.containsKey(ZipStringResource.ACTION)) {
            Map actionAutoMap = (Map)map.get(ZipStringResource.ACTION);
            for (Map.Entry actionEntry : actionAutoMap.entrySet()) {
                metaMap.put((String)actionEntry.getKey(), (byte[])actionEntry.getValue());
            }
        }
        try {
            BundleXmlHelper bhxml = new BundleXmlHelper();
            esysbundle = bhxml.readBundle(bundleXML);
        }
        catch (BundleXmlException e2) {
            throw new PatchPackageException("Exception was thrown while creating the bundleXml object from the bundleXml. ", e2);
        }
        catch (BundleValidationException e3) {
            logger.log(Level.INFO, "The given patch has bundle.xml but it could not be validated to be a Engineered System Patch bundleXml. ");
            return false;
        }
        fvalue fv = esysbundle.getFvalue();
        String hv = fv.getValue();
        if (hv == null) {
            hv = new String();
        }
        String function = fv.getFunction();
        int hashAlgo = 0;
        if (hv.length() >= 64) {
            hashAlgo = 1;
        }
        if (function.equals(2)) {
            if (applyAutoEntry != null) {
                metaMap.put(applyAutoEntry, applyAutomation);
            }
            if (rollbackAutoEntry != null) {
                metaMap.put(rollbackAutoEntry, rollbackAutomation);
            }
        }
        if ((trueFunc = hashFunctions.get(new Integer(function))) != null) {
            String valueComp = trueFunc.computeHash(metaMap, hashAlgo);
            if (!valueComp.equals(hv)) {
                throw new PatchPackageException("Engineered System Patch may be modified. Please try the same patch from MOS");
            }
        } else {
            throw new PatchPackageException("Hash function of fvalue in the given patch zip file is not supported in current version.");
        }
        return true;
    }

    public StringBuffer getContentWithFilter(InputStream is, String filterWord, boolean newLine) throws IOException {
        Scanner sc = new Scanner(is);
        sc.useDelimiter("\n");
        StringWriter sw = new StringWriter();
        String line = null;
        String tempLine = null;
        while (sc.hasNext()) {
            if (tempLine != null) {
                sw.write(line);
                sw.write(10);
            }
            if (!(line = sc.next()).contains(filterWord)) {
                tempLine = line;
                continue;
            }
            tempLine = null;
        }
        if (tempLine != null) {
            sw.write(tempLine);
            if (newLine) {
                sw.write(10);
            }
        }
        sw.close();
        return sw.getBuffer();
    }

    @Override
    public PatchPackage generate(String patchLocation) throws PatchPackageException {
        SystemPatchBundleXML esysbundle;
        assert (patchLocation != null);
        Path patchDir = WrapperFactory.getNioServiceWrapper().getPath(patchLocation, new String[0]);
        if (!Files.exists(patchDir, new LinkOption[0])) {
            throw new PatchPackageException("The given patchLocation " + patchLocation + " does not exist");
        }
        if (!Files.isDirectory(patchDir, new LinkOption[0])) {
            throw new PatchPackageException("The patch specified by the given location " + patchLocation + " is not a directory");
        }
        StringBuffer bundleXMLLoc = new StringBuffer(patchLocation);
        bundleXMLLoc.append(fileSeparator);
        bundleXMLLoc.append("bundle.xml");
        Path bxml = WrapperFactory.getNioServiceWrapper().getPath(bundleXMLLoc.toString(), new String[0]);
        if (!Files.exists(bxml, new LinkOption[0])) {
            logger.log(Level.SEVERE, "Bundle.xml was not found at the given patch location " + patchLocation);
            throw new PatchPackageException("Bundle.xml was not found at the given patch location");
        }
        if (!Files.isRegularFile(bxml, new LinkOption[0])) {
            logger.log(Level.SEVERE, "Bundle.xml was found but it is not a file.");
            throw new PatchPackageException("Bundle.xml was found at location " + bxml.toAbsolutePath().toString() + " but it is not a file");
        }
        try {
            BundleXmlHelper bhxml = new BundleXmlHelper();
            esysbundle = bhxml.readBundle(bxml);
        }
        catch (BundleXmlException e2) {
            throw new PatchPackageException("Exception was thrown while creating the bundleXml object from the bundleXml. ", e2);
        }
        catch (BundleValidationException e3) {
            logger.log(Level.INFO, "The given patch has bundle.xml but it could not bevalidated to be a Engineered System Patch bundleXml. ");
            throw new PatchPackageException("The given patch has bundle.xml but it could not bevalidated to be a Engineered System Patch bundleXml. ", e3);
        }
        EngineeredSystemPatch patch = new EngineeredSystemPatch();
        patch.setPatchLocation(patchLocation);
        patch.setPatchID(esysbundle.getPatchID());
        patch.setBundleXmlLoc(bxml.toAbsolutePath().toString());
        try {
            patch.setScripts(esysbundle.getScripts());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            patch.setBundleXml(this.getContent(Files.newInputStream(bxml, new OpenOption[0])).toString());
        }
        catch (IOException e4) {
            throw new PatchPackageException("Couldn't get the string content of the bundle.xml", e4);
        }
        patch.setPatchTool(this.getPatchTool());
        Path automationXmlFolderLocation = WrapperFactory.getNioServiceWrapper().getPath(patchDir.toString(), AUTOMATION_XML);
        if (Files.exists(automationXmlFolderLocation, new LinkOption[0])) {
            if (!Files.isDirectory(automationXmlFolderLocation, new LinkOption[0])) {
                throw new PatchPackageException(automationXmlFolderLocation.toAbsolutePath().toString() + " exists but is not a folder");
            }
            try (DirectoryStream<Path> automationXmlFiles = Files.newDirectoryStream(automationXmlFolderLocation);){
                Iterator<Path> iterator = automationXmlFiles.iterator();
                if (automationXmlFiles == null || !iterator.hasNext()) {
                    throw new PatchPackageException(automationXmlFolderLocation.toAbsolutePath().toString() + " exists but does not contain any automationXmls.");
                }
                patch.setAutomationXmlLocation(automationXmlFolderLocation.toAbsolutePath().toString());
                ArrayList<String> automationXmls = new ArrayList<String>();
                while (iterator.hasNext()) {
                    Path file = iterator.next();
                    if (!Files.isRegularFile(file, new LinkOption[0])) continue;
                    try {
                        if (RESOURCE_BUNDLE.equals(file.getFileName().toString())) {
                            patch.setResourceBundle(this.getContent(Files.newInputStream(file, new OpenOption[0])).toString());
                            continue;
                        }
                        automationXmls.add(this.getContent(Files.newInputStream(file, new OpenOption[0])).toString());
                    }
                    catch (IOException e5) {
                        throw new PatchPackageException("Couldn't read the file from automation folder", e5);
                    }
                }
                patch.setAutoXmls(automationXmls);
            }
            catch (IOException e6) {
                OLogger.debug(e6.getMessage());
            }
        } else {
            patch.setAutomationXmlLocation(null);
        }
        patch.setSubPatches(new ArrayList<GenericPatch>());
        return patch;
    }

    @Override
    public PatchPackage generate(Map map) throws PatchPackageException {
        SystemPatchBundleXML esysbundle;
        assert (!map.isEmpty());
        Object[] bundleXMLArray = (Object[])map.get(ZipStringResource.BUNDLE);
        if (bundleXMLArray.length == 0) {
            logger.log(Level.FINE, "Bundle.xml was not found in the given patch zip file");
            throw new PatchPackageException("Bundle.xml was not found in the given patch zip file");
        }
        byte[] bundleXML = (byte[])bundleXMLArray[1];
        ArrayList<byte[]> automationList = new ArrayList<byte[]>();
        Map autoStreamMap = (Map)map.get(ZipStringResource.AUTOS);
        if (autoStreamMap != null) {
            Iterator autoStreamIterator = autoStreamMap.values().iterator();
            while (autoStreamIterator.hasNext()) {
                automationList.add((byte[])autoStreamIterator.next());
            }
        }
        try {
            BundleXmlHelper bhxml = new BundleXmlHelper();
            esysbundle = bhxml.readBundle(new ByteArrayInputStream(bundleXML));
        }
        catch (BundleXmlException e2) {
            throw new PatchPackageException("Exception was thrown while creating the bundleXml object from the bundleXml. ", e2);
        }
        catch (BundleValidationException e3) {
            logger.log(Level.INFO, "The given patch has bundle.xml but it could not bevalidated to be a Engineered System Patch bundleXml. ");
            throw new PatchPackageException("The given patch has bundle.xml but it could not bevalidated to be a Engineered System Patch bundleXml. ", e3);
        }
        EngineeredSystemPatch patch = new EngineeredSystemPatch();
        patch.setPatchLocation(null);
        patch.setPatchID(esysbundle.getPatchID());
        patch.setBundleXmlLoc((String)bundleXMLArray[0]);
        try {
            patch.setBundleXml(this.getContent(new ByteArrayInputStream(bundleXML)).toString());
        }
        catch (IOException e4) {
            throw new PatchPackageException("Couldn't get the string content of the bundle.xml");
        }
        patch.setPatchTool(this.getPatchTool());
        try {
            patch.setScripts(esysbundle.getScripts());
        }
        catch (NoSuchMethodError e4) {
            // empty catch block
        }
        if (!automationList.isEmpty()) {
            ArrayList<String> automationXmls = new ArrayList<String>();
            for (byte[] automationXml : automationList) {
                try {
                    automationXmls.add(this.getContent(new ByteArrayInputStream(automationXml)).toString());
                }
                catch (IOException e5) {
                    throw new PatchPackageException("Couldn't read the automationXmls", e5);
                }
            }
            patch.setAutoXmls(automationXmls);
        }
        patch.setAutomationXmlLocation(null);
        Object[] messageXMLArray = (Object[])map.get(ZipStringResource.MESSAGE_PROPERTIES);
        if (messageXMLArray.length == 2) {
            byte[] message = (byte[])messageXMLArray[1];
            try {
                patch.setResourceBundle(this.getContent(new ByteArrayInputStream(message)).toString());
                logger.fine("resource bundle in osys s:\t" + patch.getResourceBundle());
            }
            catch (IOException e6) {
                throw new PatchPackageException("Couldn't read the message.properties", e6);
            }
        }
        patch.setSubPatches(new ArrayList<GenericPatch>());
        return patch;
    }

    @Override
    public String getPatchTool() {
        return "EsysPatch";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer getContent(InputStream is) throws IOException {
        InputStreamReader isr = new InputStreamReader(is);
        StringWriter sw = new StringWriter();
        char[] buff = new char[1024];
        int len = 0;
        try {
            while ((len = isr.read(buff, 0, buff.length)) != -1) {
                sw.write(buff, 0, len);
            }
        }
        finally {
            sw.close();
            isr.close();
        }
        return sw.getBuffer();
    }

    public static boolean IsSubPatchCompositePatch(String subLocation) {
        Path compositePatchDir = WrapperFactory.getNioServiceWrapper().getPath(subLocation, new String[0]);
        if (Files.exists(compositePatchDir, new LinkOption[0])) {
            try {
                for (Path subPatch : Files.newDirectoryStream(compositePatchDir)) {
                    if (!Files.isDirectory(subPatch, new LinkOption[0])) continue;
                    Path subPatchinvxml = WrapperFactory.getNioServiceWrapper().getPath(subPatch.toString(), INVENTORY_XML);
                    Path compositeXml = WrapperFactory.getNioServiceWrapper().getPath(subPatch.toString(), COMPOSITE_XML);
                    if (!Files.isRegularFile(subPatchinvxml, new LinkOption[0]) || !Files.isRegularFile(compositeXml, new LinkOption[0])) continue;
                    logger.info("There is a composite patch in " + subLocation);
                    return true;
                }
            }
            catch (IOException e2) {
                OLogger.debug(e2.getMessage());
            }
        }
        return false;
    }

    static {
        hashFunctions.put(1, new InventoryAndActionOnly());
        hashFunctions.put(2, new IncludeAutomationXml());
        hashFunctions.put(3, new InventoryAndActionOnlyV2());
    }
}

