/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.patchsdk.engineeredsystem;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.logging.Logger;
import oracle.opatch.patchsdk.PatchPackageException;
import oracle.opatch.patchsdk.bundle_xml.SystemPatchBundleXML;
import oracle.opatch.wrappers.WrapperFactory;

public abstract class HashComputeFunction {
    static Logger logger = Logger.getLogger(HashComputeFunction.class.getName());

    protected abstract List<String> fileList(String var1, SystemPatchBundleXML var2);

    protected abstract String getHashFunction(int var1);

    protected String computeHash(List<String> metaList, int type) throws PatchPackageException {
        if (metaList.isEmpty()) {
            return new String();
        }
        try {
            MessageDigest md = MessageDigest.getInstance(this.getHashFunction(type));
            Collections.sort(metaList);
            for (int j2 = 0; j2 < metaList.size(); ++j2) {
                String[] filterWords = new String[]{"unique_patch_id", "fvalue"};
                String metaContents = this.getContentWithFilter(Files.newInputStream(WrapperFactory.getNioServiceWrapper().getPath(metaList.get(j2), new String[0]), new OpenOption[0]), filterWords).toString();
                byte[] buffHash = metaContents.getBytes();
                md.update(buffHash);
            }
            byte[] b2 = md.digest();
            String HEXES = "0123456789ABCDEF";
            StringBuilder hex = new StringBuilder(2 * b2.length);
            for (int j3 = 0; j3 < b2.length; ++j3) {
                byte bit = b2[j3];
                hex.append(HEXES.charAt((bit & 0xF0) >> 4)).append(HEXES.charAt(bit & 0xF));
            }
            String valueComp = hex.toString();
            return valueComp.toLowerCase();
        }
        catch (NumberFormatException e2) {
            throw new PatchPackageException("The function value \"" + this.getHashFunction(type) + "\" of tag <fvalue> is invalid.");
        }
        catch (NoSuchAlgorithmException e3) {
            PatchPackageException ppe = new PatchPackageException(e3.getMessage());
            ppe.setStackTrace(e3.getStackTrace());
            throw ppe;
        }
        catch (Exception e4) {
            PatchPackageException ppe = new PatchPackageException(e4.getMessage());
            ppe.setStackTrace(e4.getStackTrace());
            throw ppe;
        }
    }

    protected String computeHash(HashMap<String, byte[]> metaMap, int type) throws PatchPackageException {
        if (metaMap.isEmpty()) {
            return new String();
        }
        try {
            MessageDigest md = MessageDigest.getInstance(this.getHashFunction(type));
            ArrayList<String> keyList = new ArrayList<String>();
            Set<String> keySet = metaMap.keySet();
            Iterator<String> iterator = keySet.iterator();
            while (iterator.hasNext()) {
                keyList.add(iterator.next());
            }
            Collections.sort(keyList);
            for (String key : keyList) {
                String[] filterWords = new String[]{"unique_patch_id", "fvalue"};
                String metaContents = this.getContentWithFilter(new ByteArrayInputStream(metaMap.get(key)), filterWords).toString();
                byte[] buffHash = metaContents.getBytes();
                md.update(buffHash);
            }
            byte[] b2 = md.digest();
            String HEXES = "0123456789ABCDEF";
            StringBuilder hex = new StringBuilder(2 * b2.length);
            for (int j2 = 0; j2 < b2.length; ++j2) {
                byte bit = b2[j2];
                hex.append(HEXES.charAt((bit & 0xF0) >> 4)).append(HEXES.charAt(bit & 0xF));
            }
            String valueComp = hex.toString();
            return valueComp.toLowerCase();
        }
        catch (NumberFormatException e2) {
            throw new PatchPackageException("The function value \"" + this.getHashFunction(type) + "\" of tag <fvalue> is invalid.");
        }
        catch (NoSuchAlgorithmException e3) {
            PatchPackageException ppe = new PatchPackageException(e3.getMessage());
            ppe.setStackTrace(e3.getStackTrace());
            throw ppe;
        }
        catch (Exception e4) {
            PatchPackageException ppe = new PatchPackageException(e4.getMessage());
            ppe.setStackTrace(e4.getStackTrace());
            throw ppe;
        }
    }

    public StringBuffer getContentWithFilter(InputStream is, String[] filterWords) throws IOException {
        Scanner sc = new Scanner(is);
        sc.useDelimiter("\n");
        StringWriter sw = new StringWriter();
        String line = null;
        String tempLine = null;
        while (sc.hasNext()) {
            if (tempLine != null) {
                sw.write(line);
                sw.write(10);
            }
            line = sc.next();
            boolean isFilter = false;
            for (int i2 = 0; i2 < filterWords.length; ++i2) {
                if (line.trim().length() != 0 && !line.contains(filterWords[i2])) continue;
                isFilter = true;
                break;
            }
            if (!isFilter) {
                tempLine = line;
                continue;
            }
            tempLine = null;
        }
        if (tempLine != null) {
            sw.write(tempLine.trim());
        }
        sw.close();
        return sw.getBuffer();
    }
}

