/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.twophase;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import oracle.opatch.CompositePatchObject;
import oracle.opatch.CopyAction;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchObject;
import oracle.opatch.opatchactions.DeleteAction;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchutil.NApply;
import oracle.opatch.opatchutil.OPatchUtilHelper;
import oracle.opatch.twophase.PhaseOneOperator;
import oracle.opatch.wrappers.WrapperFactory;

public class NApplyOperator
extends PhaseOneOperator {
    @Override
    public String getPrefix() {
        String aCache = OPatchEnv.getPrereqResultFileLoc(OPatchEnv.getOracleHome()) + File.separator + "napply.key";
        return aCache;
    }

    @Override
    public String getKeyPostfix() {
        return "napply";
    }

    @Override
    public Map<Path, String> modify(String soh, PatchObject[] piList) throws Exception {
        OPatchUtilHelper.setAutoRollbackOneOffs(new OneOffEntry[0]);
        NApply.legacy_process_binary(soh, piList);
        HashMap<Path, String> remove = new HashMap<Path, String>();
        for (PatchObject patch : piList) {
            Path filePath;
            String fileName;
            ListIterator das = patch.getAllIncludedDeleteActions();
            ListIterator cas = patch.getAllTruelyIncludedCopyActions();
            while (das.hasNext()) {
                boolean isDir;
                DeleteAction da = (DeleteAction)das.next();
                if (da.isSnowBallDeleteAction()) {
                    if (!da.isAppliedOK()) continue;
                    fileName = da.getRelativePath();
                    filePath = WrapperFactory.getNioServiceWrapper().getPath(fileName, new String[0]);
                    isDir = Files.isDirectory(filePath, new LinkOption[0]);
                    if (isDir) continue;
                    remove.put(filePath, fileName);
                    continue;
                }
                fileName = da.getRelativePath();
                filePath = WrapperFactory.getNioServiceWrapper().getPath(fileName, new String[0]);
                isDir = Files.isDirectory(filePath, new LinkOption[0]);
                if (isDir) continue;
                remove.put(filePath, fileName);
            }
            while (cas.hasNext()) {
                CopyAction ca = (CopyAction)cas.next();
                if (ca.isSnowBallCopyAction()) {
                    if (!ca.isAppliedOK()) continue;
                    fileName = ca.getFilename();
                    filePath = WrapperFactory.getNioServiceWrapper().getPath(fileName, new String[0]);
                    if (!remove.containsKey(filePath)) continue;
                    if (this.isDiffType(soh, OPatchEnv.getOracleHome(), fileName)) {
                        OLogger.justlog(OLogger.INFO, "Add to delete list, because there is change between file/dir at the same path: " + filePath);
                        continue;
                    }
                    remove.remove(filePath);
                    continue;
                }
                fileName = ca.getFilename();
                filePath = WrapperFactory.getNioServiceWrapper().getPath(fileName, new String[0]);
                if (!remove.containsKey(filePath)) continue;
                if (this.isDiffType(soh, OPatchEnv.getOracleHome(), fileName)) {
                    OLogger.justlog(OLogger.INFO, "Add to delete list, because there is change between file/dir at the same path: " + filePath);
                    continue;
                }
                remove.remove(filePath);
            }
        }
        return remove;
    }

    private boolean isDiffType(String soh, String oh, String fileName) {
        boolean isDiff = false;
        Path fileInSOH = Paths.get(soh + File.separator + fileName, new String[0]);
        Path fileInOH = Paths.get(oh + File.separator + fileName, new String[0]);
        if (Files.exists(fileInSOH, new LinkOption[0]) && Files.exists(fileInOH, new LinkOption[0])) {
            if (Files.isDirectory(fileInSOH, new LinkOption[0]) && Files.isRegularFile(fileInOH, new LinkOption[0])) {
                isDiff = true;
            }
            if (Files.isRegularFile(fileInSOH, new LinkOption[0]) && Files.isDirectory(fileInOH, new LinkOption[0])) {
                isDiff = true;
            }
        }
        return isDiff;
    }

    @Override
    public PatchObject[] buildInputPatchList(PatchObject patch, PatchObject[] patchList) {
        if (patch.getIsComposite()) {
            if (patch.isActiveCompositeSubPatch()) {
                String patchLoc = patch.getPatchLocation();
                String topCompositeLoc = WrapperFactory.getNioServiceWrapper().getPath(patchLoc, new String[0]).getParent().toString();
                return CompositePatchObject.getCompositeSubPatches(topCompositeLoc);
            }
            return new PatchObject[0];
        }
        return new PatchObject[]{patch};
    }

    @Override
    public List<PatchObject> getScriptsSavePatchList(PatchObject p2, PatchObject[] piList) {
        return new ArrayList<PatchObject>(Arrays.asList(p2));
    }
}

