/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.twophase;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import oracle.glcm.opatch.common.api.Patch;
import oracle.glcm.opatch.common.api.PatchInventory;
import oracle.glcm.opatch.common.api.SessionMode;
import oracle.glcm.opatch.common.api.install.ComponentInfo;
import oracle.glcm.opatch.common.api.install.HomeOperationsException;
import oracle.glcm.opatch.common.api.install.HomeOperationsExt;
import oracle.glcm.opatch.common.api.install.HomeOperationsFactory;
import oracle.opatch.CopyAction;
import oracle.opatch.ICustomizedActionResults;
import oracle.opatch.JarAction;
import oracle.opatch.JarActionEntity;
import oracle.opatch.OPatchCASOracleHome;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchObject;
import oracle.opatch.RegenerateLib;
import oracle.opatch.SystemCall;
import oracle.opatch.cas.CASFileServices;
import oracle.opatch.cup.CUPAdapter;
import oracle.opatch.ipm.IIPMAuxServices;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.ipm.IPM;
import oracle.opatch.ipm.IPMUtil;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchutil.CommonAPIUtil;
import oracle.opatch.twophase.ExitTwoPhaseException;
import oracle.opatch.twophase.PhaseOneExecutor;
import oracle.opatch.twophase.PhaseTwoExecutor;
import oracle.opatch.twophase.TwoPhasePatchingHelper;
import oracle.opatch.wrappers.PatchComponentInfoWrapper;
import oracle.opatch.wrappers.WrapperFactory;

public class TwoPhasePatching {
    private boolean init = false;
    private String oh = OPatchEnv.getOracleHome();
    private OPatchCASOracleHome coh;

    private void initialize() {
        if (this.init) {
            return;
        }
        Path customLogPath = null;
        String customLogDir = OPatchEnv.getCustomLogDir();
        if (customLogDir != null && !customLogDir.equals("")) {
            customLogPath = WrapperFactory.getNioServiceWrapper().getPath(customLogDir, new String[0]).resolve("opatch-cas");
        }
        this.coh = new OPatchCASOracleHome(this.oh, ".cas", customLogPath);
        this.init = true;
    }

    public void prepare(PatchObject[] rollbackPatch, PatchObject[] applyPatch) {
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: TwoPhasePatching::prepare(PatchObject[] rollbackPatch, PatchObject[] applyPatch)");
        this.initialize();
        String soh = "";
        soh = this.casPrepare(this.oh, rollbackPatch, applyPatch);
        this.attachHome(soh, "soh");
        try {
            OLogger.justlog(OLogger.INFO, "TwoPhasePatching::copy over comps.xml from origianl OH to Shadow OH after attachhome");
            Path oComps = WrapperFactory.getNioServiceWrapper().getPath(IPMUtil.getCompsXMLLocation(this.oh), new String[0]);
            Path sComps = WrapperFactory.getNioServiceWrapper().getPath(IPMUtil.getCompsXMLLocation(soh), new String[0]);
            SystemCall.copyFile(oComps, sComps);
            PhaseOneExecutor exe = new PhaseOneExecutor();
            OPatchEnv.checkAndSetCupFlag(soh);
            if (OPatchEnv.isNextGen() && applyPatch != null && applyPatch.length != 0 && OPatchEnv.isCUP2Supported()) {
                this.callGetApplyInventoryComponents(applyPatch);
            }
            exe.execute(soh, applyPatch, rollbackPatch);
            OLogger.justlog(OLogger.INFO, "EXITING METHOD: TwoPhasePatching::prepare(PatchObject[] rollbackPatch, PatchObject[] applyPatch)");
        }
        catch (HomeOperationsException e2) {
            throw new RuntimeException("TwoPhasepatching.prepare() failed to get ComponentInfo from inventory " + e2.getMessage(), e2);
        }
        finally {
            HomeOperationsExt homeOp = IPM.INSTANCE.getReadServices().getHomeOperations();
            if (homeOp != null && homeOp.isInitialized()) {
                homeOp.close();
            }
            this.detachHome(soh, "soh");
            OPatchEnv.checkAndSetCupFlag(OPatchEnv.getOracleHome());
        }
        String path = soh + File.separator + ".patch_storage";
        SystemCall.deleteRecurse(WrapperFactory.getNioServiceWrapper().getPath(path, new String[0]), false);
        OLogger.justlog(OLogger.INFO, "clean up shadow oh \"" + soh + "\" after phase one.");
    }

    private void callGetApplyInventoryComponents(PatchObject[] applyPatch) throws HomeOperationsException {
        for (PatchObject patchObj : applyPatch) {
            Patch patchObject = null;
            try {
                patchObject = CommonAPIUtil.getInstance().getCommonAPIPatch(patchObj);
            }
            catch (Exception e1) {
                throw new RuntimeException(e1);
            }
            Set<PatchComponentInfoWrapper> compsInPatch = null;
            if (!OPatchEnv.isNRollback()) {
                compsInPatch = this.getCompsInfoInPatch(patchObject, patchObj);
            }
            HomeOperationsExt homeOp = IPM.INSTANCE.getReadServices().getHomeOperations();
            homeOp.initialize(SessionMode.READ);
            CUPAdapter cupAdapter = new CUPAdapter(IPM.INSTANCE.getReadServices().getHomeOperations(), patchObj);
            if (!OPatchEnv.isNRollback()) {
                Set<ComponentInfo> set = cupAdapter.getApplyInventoryComponents(compsInPatch);
            } else {
                Map<Object, Object> compsInInventoryRollback = new HashMap();
                compsInInventoryRollback = cupAdapter.getRollbackInventoryComponents();
            }
            homeOp.close();
        }
    }

    private Set<PatchComponentInfoWrapper> getCompsInfoInPatch(Patch patchObjectInCommonAPI, PatchObject patchObject) {
        HashSet<PatchComponentInfoWrapper> result = new HashSet<PatchComponentInfoWrapper>();
        if (patchObjectInCommonAPI == null) {
            return result;
        }
        List compsInPatch = patchObjectInCommonAPI.getComponents();
        HomeOperationsFactory homeOpFactory = HomeOperationsFactory.getInstance();
        for (PatchInventory.Component c2 : compsInPatch) {
            ComponentInfo compInfoObj = homeOpFactory.getComponentInfo(c2.getName(), c2.getVersion());
            Map<Path, Path> patchFilesMap = this.getPatchFilesPath(patchObject, compInfoObj);
            result.add(WrapperFactory.getCommonApiWrapper().getPatchComponentInfoWrapper(compInfoObj, patchFilesMap));
        }
        return result;
    }

    private Map<Path, Path> getPatchFilesPath(PatchObject patchObject, ComponentInfo compInfoObj) {
        ICustomizedActionResults result;
        HashMap<Path, Path> patchFilesMap = new HashMap<Path, Path>();
        String patchlocation = patchObject.getPatchLocation();
        String oracleHomePath = OPatchEnv.getOracleHome();
        for (PatchComponent pc : patchObject.getPatchComponents()) {
            boolean matchedName = pc.getName().equals(compInfoObj.getName());
            boolean matchedVersion = pc.getVersion().equals(compInfoObj.getVersion());
            if (!matchedName || !matchedVersion) continue;
            for (PatchAction action : pc.getAllActions()) {
                ArrayList targetFiles = action.getFilesTouched(oracleHomePath);
                String source = "";
                if (action instanceof CopyAction) {
                    source = ((CopyAction)action).getSourceFile(patchlocation);
                }
                if (action instanceof JarAction) {
                    source = ((JarAction)action).getSourceFile(patchlocation);
                }
                Path ohFile = null;
                if (action instanceof JarActionEntity) {
                    String jarTouched = action.getParentFilePath(oracleHomePath);
                    ohFile = WrapperFactory.getNioServiceWrapper().getPath(jarTouched, new String[0]);
                } else {
                    String[] touchfile;
                    if (targetFiles == null || targetFiles.isEmpty() || (touchfile = (String[])targetFiles.get(0)) == null || touchfile.length <= 1 || touchfile[1].equals("")) continue;
                    ohFile = WrapperFactory.getNioServiceWrapper().getPath(touchfile[1], new String[0]);
                }
                patchFilesMap.put(ohFile, WrapperFactory.getNioServiceWrapper().getPath(source, new String[0]));
            }
        }
        if (patchObject.isSparseCopy() && (result = OPatchEnv.getMSIDCustomResults().get(patchObject.getPatchUniqID())) != null) {
            for (String file : result.getAddedFiles()) {
                patchFilesMap.put(WrapperFactory.getNioServiceWrapper().getPath(file, new String[0]), WrapperFactory.getNioServiceWrapper().getPath("", new String[0]));
            }
            for (String file : result.getRemoveFiles()) {
                patchFilesMap.put(WrapperFactory.getNioServiceWrapper().getPath(file, new String[0]), WrapperFactory.getNioServiceWrapper().getPath("", new String[0]));
            }
        }
        return patchFilesMap;
    }

    public void commit() throws ExitTwoPhaseException, Exception {
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: TwoPhasePatching::commit()");
        try {
            this.initialize();
            PhaseTwoExecutor exec = new PhaseTwoExecutor();
            exec.execute(this.coh);
            IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
            readServices.destroy();
            if (!OPatchEnv.isNextGen()) {
                this.attachHome(this.oh, null);
            }
        }
        catch (Exception e2) {
            if (e2 instanceof ExitTwoPhaseException) {
                throw (ExitTwoPhaseException)e2;
            }
            throw e2;
        }
        OLogger.justlog(OLogger.INFO, "EXITING METHOD: TwoPhasePatching::commit()");
    }

    private String casPrepare(String oh, PatchObject[] rollbackPatches, PatchObject[] applyPatches) {
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: TwoPhasePatching::casPrepare(String oh, PatchObject[] rollbackPatches, PatchObject[] applyPatches)");
        CASFileServices cas = new CASFileServices();
        String branchKey = "";
        String sohPath = "";
        try {
            boolean isDBHome;
            branchKey = OPatchEnv.getBranchKey();
            OLogger.justlog(OLogger.INFO, "casPrepare::enable CAS/buildCasStore.");
            try {
                cas.build();
            }
            catch (Throwable t) {
                OLogger.printlnOnLog("BuildCasStore has issue: " + t.getMessage());
                OLogger.printStackTrace(t);
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                throw re;
            }
            String soh = this.coh.getCASStoragePath() + File.separator + branchKey;
            sohPath = oh + File.separator + soh;
            OLogger.justlog(OLogger.INFO, "casPrepare::destroy previous shadow OH");
            cas.destroy();
            Map<Path, String> copy = TwoPhasePatchingHelper.getBaseCopy(oh);
            Map<Path, String> rCopies = TwoPhasePatchingHelper.getCopiedFiles(oh, rollbackPatches);
            TwoPhasePatchingHelper.validateBlacklistFiles(rCopies.values());
            Map<Path, String> aCopies = TwoPhasePatchingHelper.getCopiedFiles(oh, applyPatches);
            TwoPhasePatchingHelper.validateBlacklistFiles(aCopies.values());
            HashMap<Path, String> rLibCopies = new HashMap<Path, String>();
            boolean isSnowballPatching = OPatchEnv.isSnowBall();
            if (OPatchEnv.isNextGen()) {
                Iterator<Map.Entry<Path, String>> refCopies = TwoPhasePatchingHelper.getReferencedFiles(oh, rollbackPatches);
                for (Map.Entry entry : refCopies.entrySet()) {
                    copy.put((Path)entry.getKey(), (String)entry.getValue());
                }
                if (rollbackPatches != null && rollbackPatches.length != 0) {
                    RegenerateLib rrLib = new RegenerateLib(rollbackPatches, oh);
                    rLibCopies.putAll(rrLib.getuRLibFiles(isSnowballPatching, false));
                }
                if (applyPatches != null && applyPatches.length != 0) {
                    RegenerateLib arLib = new RegenerateLib(applyPatches, oh);
                    rLibCopies.putAll(arLib.getuRLibFiles(isSnowballPatching, true));
                }
                for (Map.Entry entry : rLibCopies.entrySet()) {
                    copy.put((Path)entry.getKey(), (String)entry.getValue());
                }
            }
            for (Map.Entry<Path, String> entry : rCopies.entrySet()) {
                copy.put((Path)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry<Path, String> entry : aCopies.entrySet()) {
                copy.put(entry.getKey(), entry.getValue());
            }
            TwoPhasePatchingHelper.addCopiedFilesForPatchStorage(copy, oh, rollbackPatches);
            TwoPhasePatchingHelper.addCopiedFilesForSparceCopy(copy, oh, applyPatches);
            HashMap<Path, String> hardlink = new HashMap<Path, String>();
            OLogger.justlog(OLogger.INFO, "casPrepare::copy list to shadow OH is: " + copy);
            OLogger.justlog(OLogger.INFO, "casPrepare::hardlink list to shadow OH is: " + hardlink);
            OLogger.justlog(OLogger.INFO, "casPrepare::create shadow OH, relative path is " + soh);
            boolean bl = isDBHome = OPatchEnv.isDBHome(oh) && !OPatchEnv.isFullDBCasRepo();
            if (isDBHome) {
                TwoPhasePatchingHelper.doTheCopy(copy, oh, sohPath);
            }
            cas.create(soh, copy, hardlink);
        }
        catch (Throwable t) {
            RuntimeException re = new RuntimeException(t.getMessage(), t);
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
        OLogger.justlog(OLogger.INFO, "EXITING METHOD: TwoPhasePatching::casPrepare(String oh, PatchObject[] rollbackPatches, PatchObject[] applyPatches)");
        return sohPath;
    }

    private void attachHome(String ohPath, String ohName) {
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: TwoPhasePatching::attachHome(String ohPath, String ohName)");
        OPatchSessionHelper.loadRACRelatedLibFile();
        Properties props = System.getProperties();
        props.setProperty("oracle.installer.scratchPath", "/tmp");
        try {
            IIPMAuxServices aux = IPM.INSTANCE.getAuxServices();
            if (OPatchEnv.isNextGen()) {
                aux.attachHome(ohPath, ohName, "-force -nogenerateGUID");
            } else {
                aux.attachHome(ohPath, ohName, "-force -nogenerateGUID -local");
            }
        }
        catch (Exception e2) {
            RuntimeException re = new RuntimeException(e2.getMessage(), e2);
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        props.setProperty("oracle.installer.attachHome", "false");
        OLogger.justlog(OLogger.INFO, "EXITING METHOD: TwoPhasePatching::attachHome(String ohPath, String ohName)");
    }

    private void detachHome(String ohPath, String ohName) {
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: TwoPhasePatching::detachHome(String ohPath, String ohName)");
        OPatchSessionHelper.loadRACRelatedLibFile();
        Properties props = System.getProperties();
        props.setProperty("oracle.installer.scratchPath", "/tmp");
        try {
            IIPMAuxServices aux = IPM.INSTANCE.getAuxServices();
            if (OPatchEnv.isNextGen()) {
                aux.detachHome(ohPath, ohName, "-force");
            } else {
                aux.detachHome(ohPath, ohName, "-force -local");
            }
        }
        catch (Exception e2) {
            RuntimeException re = new RuntimeException(e2.getMessage(), e2);
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        props.setProperty("oracle.installer.detachHome", "false");
        OLogger.justlog(OLogger.INFO, "EXITING METHOD: TwoPhasePatching::detachHome(String ohPath, String ohName)");
    }
}

