/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.wrappers;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.opatch.OPatchEnv;
import oracle.opatch.wrappers.CommonApiWrapper;
import oracle.opatch.wrappers.NextGenApiWrapper;
import oracle.opatch.wrappers.NioServiceWrapper;
import oracle.opatch.wrappers.WrapperException;
import oracle.opatch.wrappers.WrapperProvider;

public class WrapperFactory {
    private static final Logger _log = Logger.getLogger(WrapperFactory.class.getName());
    public static final String PROVIDER_WRAPPER_13_9_5_CLASSNAME = "oracle.opatch.wrappers.WrapperProvider1395Impl";
    public static final String PROVIDER_WRAPPER_13_9_4_CLASSNAME = "oracle.opatch.wrappers.WrapperProvider1394Impl";
    public static final String COMMON_API_MARKER_CLASS = "oracle.glcm.opatch.common.api.Patch";
    public static final String NGNIST_MARKER_CLASS = "com.oracle.cie.gdr.external.OracleHomeInventory";
    private static WrapperProvider _wrapperProvider;

    public static NioServiceWrapper getNioServiceWrapper() {
        return WrapperFactory.loadWrapperProvider().getNioServiceWrapper();
    }

    public static CommonApiWrapper getCommonApiWrapper() {
        return WrapperFactory.loadWrapperProvider().getCommonApiWrapper();
    }

    public static NextGenApiWrapper getNextGenApiWrapper() {
        return WrapperFactory.loadWrapperProvider().getNextGenApiWrapper();
    }

    public static WrapperProvider loadWrapperProvider() {
        if (_wrapperProvider == null) {
            try {
                _wrapperProvider = WrapperFactory.loadWrapperProvider(WrapperFactory.class.getClassLoader());
            }
            catch (WrapperException e2) {
                _log.log(Level.SEVERE, "Failed to load provider wrapper.", e2);
                throw new IllegalStateException("Failed to load provider wrapper.", e2);
            }
        }
        return _wrapperProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WrapperProvider loadWrapperProvider(ClassLoader classLoader) throws WrapperException {
        String className;
        String version = "0.0.0.0";
        Boolean is_ng_support_nio = false;
        String sysPropVer = System.getProperty("wrapper.provider.version");
        if (sysPropVer != null && sysPropVer.trim().length() > 0) {
            _log.info("Using wrapper provider version from system property: " + sysPropVer);
            version = sysPropVer;
        } else {
            FileSystem zipFileSystem = null;
            Logger apacheLogger = Logger.getLogger("org.apache");
            apacheLogger.setLevel(Level.WARNING);
            try {
                Path manifestPath;
                Path commonApiPath = WrapperFactory.locateClass(COMMON_API_MARKER_CLASS, classLoader);
                if (!Files.isDirectory(commonApiPath, new LinkOption[0])) {
                    zipFileSystem = FileSystems.newFileSystem(commonApiPath, null);
                    manifestPath = zipFileSystem.getPath("META-INF/MANIFEST.MF", new String[0]);
                } else {
                    manifestPath = commonApiPath.resolve("META-INF/MANIFEST.MF");
                }
                InputStream fis = Files.newInputStream(manifestPath, new OpenOption[0]);
                Manifest manifest = new Manifest(fis);
                fis.close();
                Attributes attributes = manifest.getMainAttributes();
                version = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            catch (Exception e2) {
                _log.log(Level.WARNING, "Unable to get determine fmw platform version.", e2);
            }
            finally {
                if (zipFileSystem != null) {
                    try {
                        zipFileSystem.close();
                    }
                    catch (IOException e2) {}
                }
            }
        }
        boolean isNGHome = false;
        try {
            isNGHome = WrapperFactory.isNextGenHome(OPatchEnv.getOracleHome());
        }
        catch (Throwable t) {
            isNGHome = false;
        }
        if (isNGHome) {
            try {
                Class<?> chkClass = Class.forName(NGNIST_MARKER_CLASS);
                Method methods = chkClass.getMethod("getHomeDirPath", new Class[0]);
                is_ng_support_nio = true;
            }
            catch (ClassNotFoundException e3) {
                _log.fine("com.oracle.cie.gdr.external.OracleHomeInventory not found. NGNIST not support NIO feature.");
                is_ng_support_nio = false;
            }
            catch (NoSuchMethodException e4) {
                _log.fine("com.oracle.cie.gdr.external.OracleHomeInventory.getHomeDirPath() not found. NGNIST not support NIO feature.");
                is_ng_support_nio = false;
            }
            catch (Exception e5) {
                _log.fine("NGNIST not support NIO feature.");
                is_ng_support_nio = false;
            }
        } else {
            is_ng_support_nio = true;
        }
        if (WrapperFactory.compareVersion(version, "13.9.5.0") != -1 && is_ng_support_nio.booleanValue()) {
            className = PROVIDER_WRAPPER_13_9_5_CLASSNAME;
        } else {
            _log.fine("Using 13.9.4.0.0 wrapper provider since version could not be determined.");
            className = PROVIDER_WRAPPER_13_9_4_CLASSNAME;
        }
        try {
            _log.finer("Loading FMW platform wrapper class " + className);
            return (WrapperProvider)classLoader.loadClass(className).newInstance();
        }
        catch (Exception e6) {
            throw new WrapperException("Failed to load wrapper provider: " + className, e6);
        }
    }

    private static Path locateClass(String className, ClassLoader classloader) {
        block10: {
            if (className != null && classloader != null) {
                try {
                    URL classResource = classloader.getResource(className.endsWith(".class") ? className : className.replace('.', '/') + ".class");
                    if (classResource != null) {
                        String fileComponent = classResource.getFile();
                        if (classResource.getProtocol().equals("file")) {
                            return Paths.get(classResource.toURI());
                        }
                        if (classResource.getProtocol().equals("jar")) {
                            int classSeparatorIndex = fileComponent.lastIndexOf("!");
                            if (classSeparatorIndex != -1) {
                                fileComponent = fileComponent.substring(0, classSeparatorIndex);
                            }
                            fileComponent = fileComponent.replaceAll("\\+", "%2B");
                            if (!(fileComponent = fileComponent.replaceAll("\\%", "%25")).startsWith("file:")) {
                                fileComponent = "file:" + fileComponent;
                            }
                            return Paths.get(new URI(URLDecoder.decode(fileComponent, "UTF-8")));
                        }
                    } else if (_log.isLoggable(Level.FINE)) {
                        _log.fine("Unable to locate class " + className);
                    }
                }
                catch (UnsupportedEncodingException | URISyntaxException e2) {
                    if (!_log.isLoggable(Level.FINE)) break block10;
                    _log.fine(e2.getMessage());
                }
            }
        }
        return null;
    }

    public static int compareVersion(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return -1;
        }
        String[] s1array = s1.split("\\.");
        String[] s2array = s2.split("\\.");
        try {
            for (int i2 = 0; i2 < s1array.length || i2 < s2array.length; ++i2) {
                int a2 = 0;
                int b2 = 0;
                if (i2 < s1array.length) {
                    a2 = Integer.parseInt(s1array[i2]);
                }
                if (i2 < s2array.length) {
                    b2 = Integer.parseInt(s2array[i2]);
                }
                if (a2 > b2) {
                    return 1;
                }
                if (a2 >= b2) continue;
                return -1;
            }
            return 0;
        }
        catch (NumberFormatException e2) {
            _log.fine("Common api version mismatching.");
            return -1;
        }
    }

    public static boolean isNextGenHome(String oracleHome) {
        Path installerLaunchJar = Paths.get(oracleHome, "oui/modules/installer-launch.jar");
        try {
            URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{installerLaunchJar.toUri().toURL()});
            Class<?> clazz = urlClassLoader.loadClass("com.oracle.cie.gdr.external.InventoryFactory");
            if (clazz != null) {
                return true;
            }
        }
        catch (Exception e2) {
            return false;
        }
        return false;
    }
}

