/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.cmdtranslator.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import model.BaseClass;
import model.common.AbstractBaseTarget;
import model.common.Host;
import model.common.OracleHome;
import model.db_crs.CRSCluster;
import model.db_crs.RACDBInstance;
import model.db_crs.RACDatabase;
import oracle.opatch.system.automation.jaxb.ActionType;
import oracle.opatch.system.automation.jaxb.LifecycleAction;
import oracle.opatch.system.automation.jaxb.PatchingPhase;
import oracle.opatch.system.automation.jaxb.Strategy;
import oracle.oplan.db.cmdtranslator.DBCommandUtils;
import oracle.oplan.db.engine.CRSContextPopulator;
import oracle.oplan.sdk.cmdtranslator.Command;
import oracle.oplan.sdk.cmdtranslator.CommandBuilder;
import oracle.oplan.sdk.cmdtranslator.CommandContext;
import oracle.oplan.sdk.cmdtranslator.CommandUtils;
import oracle.oplan.sdk.exec.api.ExecutionStep;
import oracle.oplan.sdk.graphlib.ConfigGraph;
import oracle.oplan.sdk.oplan.OPlan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleHomeLifecycle
extends Command {
    protected String type = "start";
    protected Strategy s = Strategy.MANUAL;
    List<String> processed = new ArrayList<String>();

    public OracleHomeLifecycle(ActionType automationAction, String type, Strategy s) {
        super(automationAction);
        this.type = type;
        this.s = s;
    }

    private static String getUUID(OracleHome oh) {
        boolean clone = false;
        if (oh.getOriginalOracleHome() != null) {
            oh = oh.getOriginalOracleHome();
            clone = true;
        }
        String str = oh.getUniqueId().replace(':', '_');
        if (clone) {
            str = str + "_clone";
        }
        return str;
    }

    public List<String> getShellCommands(CommandContext context) {
        OracleHome oh = (OracleHome)context.getTarget(OracleHome.class);
        Host host = (Host)context.getTarget(Host.class);
        ArrayList<String> cmds = new ArrayList<String>();
        Logger.getLogger(OracleHomeLifecycle.class.getName()).info("type: " + this.type);
        String uuid = OracleHomeLifecycle.getUUID(oh);
        File statefile = new File(oh.getPath(), uuid + ".stat");
        if (this.type.equalsIgnoreCase("stop")) {
            cmds.add("rm -f " + statefile.getAbsolutePath());
        }
        String cmd = "ORACLE_HOME=" + oh.getPath() + " " + oh.getPath() + "/bin/srvctl " + this.type + " home -o " + oh.getPath();
        if (OPlan.getInstance().getConfigGraph().getRootVertex() instanceof CRSCluster) {
            cmd = cmd + " -n " + host.getHostName();
        }
        if (this.type.equalsIgnoreCase("stop")) {
            cmd = cmd + " -f";
            if (oh.getHomeType().equals("rac")) {
                String version = DBCommandUtils.getRACDBVersionForCurrentHome(oh);
                if (version != null) {
                    cmd = version.startsWith("11") ? cmd + " -t TRANSACTIONAL" : cmd + " -stopoption TRANSACTIONAL";
                } else {
                    Logger.getLogger(OracleHomeLifecycle.class.getName()).info("Unable to get the DB version, so not performing stop DB home in transactional mode");
                }
            }
        }
        cmd = cmd + " -s " + statefile.getAbsolutePath();
        cmds.add(cmd);
        return cmds;
    }

    public ExecutionStep getExecutionStep(CommandContext context) {
        ExecutionStep executionStep = CommandUtils.getBasicExecutionStep((ActionType)this.automationAction, (CommandContext)context, null);
        for (String cmd : this.getShellCommands(context)) {
            executionStep.getCommand().add(new ExecutionStep.Command(cmd));
        }
        return executionStep;
    }

    private boolean skipStepforRACOneDBForCurrentContext(CommandContext context) {
        RACDBInstance racDBInstanceForCurrentContext = this.getRACOneDBInstanceForCurrentContext(context);
        return racDBInstanceForCurrentContext != null && "racone".equals(racDBInstanceForCurrentContext.getDbRAC().getDatabaseType());
    }

    private RACDBInstance getRACOneDBInstanceForCurrentContext(CommandContext context) {
        OracleHome oh = (OracleHome)context.getTarget(OracleHome.class);
        Host host = (Host)context.getTarget(Host.class);
        RACDatabase racDB = null;
        RACDBInstance racDBInstanceOnCurrentNode = null;
        block0: for (BaseClass bc : OPlan.getInstance().getConfigGraph().getSystemInstance().getEntities()) {
            if (!(bc instanceof RACDatabase)) continue;
            racDB = (RACDatabase)bc;
            for (RACDBInstance racDBInst : racDB.getDbInstances()) {
                if (!racDBInst.getRuns_from().getPath().equals(oh.getPath()) || !racDBInst.getHost().getHostName().equals(host.getName())) continue;
                racDBInstanceOnCurrentNode = racDBInst;
                continue block0;
            }
        }
        return racDBInstanceOnCurrentNode;
    }

    public List<ExecutionStep> generateExecutionSteps(ConfigGraph g, List<? extends AbstractBaseTarget> actsOnlyOnTargets) {
        ArrayList<ExecutionStep> steps = new ArrayList<ExecutionStep>();
        CRSContextPopulator contextPopulator = new CRSContextPopulator();
        if (CommandUtils.shouldShutdownRACInstance((PatchingPhase)this.getPatchingPhase())) {
            List<? extends AbstractBaseTarget> ohs = actsOnlyOnTargets;
            for (OracleHome oracleHome : ohs) {
                CommandContext context = contextPopulator.populateContext(g, (AbstractBaseTarget)oracleHome);
                if (this.skipStepforRACOneDBForCurrentContext(context)) continue;
                if (this.automationAction.isActsOnClone()) {
                    contextPopulator.fixCloneContext(context);
                    OracleHome oh = (OracleHome)context.getFirstTarget(OracleHome.class);
                    if (oh.getOriginalOracleHome() != null && oh.getOriginalOracleHome().getPath().equals(oh.getPath())) continue;
                }
                ExecutionStep step = this.getExecutionStep(context);
                if (this.s.equals((Object)Strategy.DCLI)) {
                    step.setHost(g.getLocalHost());
                }
                steps.add(step);
            }
        }
        return steps;
    }

    protected List<? extends AbstractBaseTarget> getApplicableTargets(ConfigGraph g) {
        return g.getTargets(OracleHome.class, this.automationAction.getStripe());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    implements CommandBuilder<OracleHomeLifecycle> {
        public OracleHomeLifecycle getCommand(ActionType a, Strategy s) {
            if (!(a instanceof LifecycleAction) || a.getActsOn() == null || !a.getActsOn().equals("OracleHome")) {
                return null;
            }
            OracleHomeLifecycle com = new OracleHomeLifecycle(a, a.getType(), s);
            return com;
        }
    }
}

