/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.cmdtranslator.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import model.common.AbstractBaseTarget;
import model.common.OracleHome;
import model.db_crs.RACDatabase;
import oracle.opatch.system.automation.jaxb.ActionType;
import oracle.opatch.system.automation.jaxb.CommandAction;
import oracle.opatch.system.automation.jaxb.Strategy;
import oracle.oplan.db.cmdtranslator.DBCommandUtils;
import oracle.oplan.db.cmdtranslator.SqlCommandUtils;
import oracle.oplan.db.cmdtranslator.commands.CRSCommandActionType;
import oracle.oplan.db.engine.CRSContextPopulator;
import oracle.oplan.db.patch.CRSApplicabilityTarget;
import oracle.oplan.sdk.cmdtranslator.Command;
import oracle.oplan.sdk.cmdtranslator.CommandBuilder;
import oracle.oplan.sdk.cmdtranslator.CommandContext;
import oracle.oplan.sdk.cmdtranslator.CommandUtils;
import oracle.oplan.sdk.exec.api.ExecutionStep;
import oracle.oplan.sdk.graphlib.ConfigGraph;
import oracle.oplan.sdk.oplan.OPlan;
import oracle.oplan.sdk.oplan.SystemModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLPatchUpgradeModeCommand
extends Command {
    private static String OPLAN_LOG = null;
    CommandAction automationAction;
    Logger logger = Logger.getLogger(SQLPatchUpgradeModeCommand.class.getName());

    public SQLPatchUpgradeModeCommand(CommandAction automationAction) {
        super((ActionType)automationAction);
        this.automationAction = automationAction;
    }

    protected List<ExecutionStep> generateExecutionSteps(ConfigGraph g, List<? extends AbstractBaseTarget> actsOnlyOnTargets) {
        ArrayList<ExecutionStep> steps = new ArrayList<ExecutionStep>();
        CRSContextPopulator contextPopulator = new CRSContextPopulator();
        for (AbstractBaseTarget abstractBaseTarget : actsOnlyOnTargets) {
            ExecutionStep executionStep;
            CommandContext context = contextPopulator.populateContext(g, abstractBaseTarget);
            if (this.automationAction.isActsOnClone()) {
                contextPopulator.fixCloneContext(context);
            }
            if ((executionStep = this.getExecutionStep(context)) == null) continue;
            steps.add(executionStep);
        }
        return steps;
    }

    private ExecutionStep getExecutionStep(CommandContext context) {
        OracleHome oh = (OracleHome)context.getFirstTarget(OracleHome.class);
        AbstractBaseTarget primaryTarget = context.getPrimaryTarget();
        List patches = OPlan.getInstance().getOPlanEnv().getPatchesBag().getPatchesForTargetType(CommandUtils.getApplicabilityTargetType((String)CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.rac.toString()));
        OPLAN_LOG = "$ORACLE_HOME" + File.separator + "cfgtoollogs" + File.separator + "oplan";
        boolean isSQLPatchUpgradeMode = DBCommandUtils.isSQLPatchUpgradeMode();
        ExecutionStep executionStep = null;
        ArrayList cmds = new ArrayList();
        if (DBCommandUtils.shouldExecuteSqlCommand(primaryTarget, patches, (ActionType)this.automationAction) && isSQLPatchUpgradeMode && primaryTarget instanceof RACDatabase) {
            if (DBCommandUtils.isPhysicalStandbyDatabase(primaryTarget)) {
                context = DBCommandUtils.resetContextForStandbyDB(primaryTarget);
                oh = (OracleHome)context.getFirstTarget(OracleHome.class);
                primaryTarget = context.getPrimaryTarget();
            }
            executionStep = CommandUtils.getBasicExecutionStep((ActionType)this.automationAction, (CommandContext)context, null);
            if (this.automationAction.isActsOnClone() && DBCommandUtils.isRemoteDB(primaryTarget)) {
                this.logger.info("Current step is running on remote db " + primaryTarget.getDisplayName() + ". Set acts_on_clone property to null");
                executionStep.getAutomationAction().setActsOnClone(null);
            }
            String oracleSid = SqlCommandUtils.getOracleSIDForActiveInstance(executionStep, primaryTarget);
            ArrayList<String> tempCmds = new ArrayList<String>();
            String actionType = this.automationAction.getType();
            String sqlPlusCmd = "cd $ORACLE_HOME; ORACLE_HOME=" + oh.getPath() + " ORACLE_SID=" + oracleSid + " ./bin/sqlplus / as sysdba @";
            if (CRSCommandActionType.SqlPatchDisableCluster.toString().equals(actionType)) {
                tempCmds.add("export ORACLE_HOME=" + oh.getPath());
                tempCmds.addAll(this.generateSqlPatchClusterDisableCommand(sqlPlusCmd));
            } else if (CRSCommandActionType.SqlPatchStartupUpgradeMode.toString().equals(actionType)) {
                tempCmds.addAll(this.generateDBStartupInUpgradeModeCommand(sqlPlusCmd, primaryTarget));
            } else if (CRSCommandActionType.SqlPatchEnableCluster.toString().equals(actionType)) {
                tempCmds.addAll(this.generateSqlPatchClusterEnableCommand(sqlPlusCmd));
            }
            if (tempCmds != null && !tempCmds.isEmpty()) {
                cmds.addAll(tempCmds);
            }
        }
        for (String s : cmds) {
            executionStep.getCommand().add(new ExecutionStep.Command(s));
        }
        return executionStep;
    }

    private List<String> generateSqlPatchClusterDisableCommand(String sqlPlusCmd) {
        ArrayList<String> cmds = new ArrayList<String>();
        String dataPatchfileForSetClusterFalse = OPLAN_LOG + File.separator + "dataPatchfileForSetClusterFalse.sql";
        cmds.add("mkdir -p " + OPLAN_LOG);
        cmds.add("echo 'alter system set cluster_database=false scope=spfile;' > " + dataPatchfileForSetClusterFalse);
        cmds.add("echo 'quit' >> " + dataPatchfileForSetClusterFalse);
        cmds.add(sqlPlusCmd + dataPatchfileForSetClusterFalse);
        return cmds;
    }

    private List<String> generateSqlPatchClusterEnableCommand(String sqlPlusCmd) {
        ArrayList<String> cmds = new ArrayList<String>();
        String dataPatchfileForSetClusterTrue = OPLAN_LOG + File.separator + "dataPatchfileForSetClusterTrue.sql";
        cmds.add("echo 'alter system set cluster_database=true scope=spfile;' > " + dataPatchfileForSetClusterTrue);
        cmds.add("echo 'shutdown' >> " + dataPatchfileForSetClusterTrue);
        cmds.add("echo 'quit' >> " + dataPatchfileForSetClusterTrue);
        cmds.add(sqlPlusCmd + dataPatchfileForSetClusterTrue);
        return cmds;
    }

    private List<String> generateDBStartupInUpgradeModeCommand(String sqlPlusCmd, AbstractBaseTarget db) {
        ArrayList<String> cmds = new ArrayList<String>();
        String dataPatchfileForStartupUpgrade = OPLAN_LOG + File.separator + "dataPatchfileForStartupUpgrade.sql";
        cmds.add("echo 'startup upgrade' > " + dataPatchfileForStartupUpgrade);
        if (SqlCommandUtils.isPDB(db)) {
            cmds.add("echo 'alter pluggable database all open upgrade;' >> " + dataPatchfileForStartupUpgrade);
        }
        cmds.add("echo 'quit' >> " + dataPatchfileForStartupUpgrade);
        cmds.add(sqlPlusCmd + dataPatchfileForStartupUpgrade);
        return cmds;
    }

    protected List<? extends AbstractBaseTarget> getApplicableTargets(ConfigGraph g) {
        Class type = SystemModelUtils.getClassForType((String)this.automationAction.getActsOn());
        return g.getTargets(type, this.automationAction.getStripe());
    }

    public static class Builder
    implements CommandBuilder {
        public Command getCommand(ActionType a, Strategy s) {
            if (!(a instanceof CommandAction) || !a.getType().equals(CRSCommandActionType.SqlPatchDisableCluster.toString()) && !a.getType().equals(CRSCommandActionType.SqlPatchEnableCluster.toString()) && !a.getType().equals(CRSCommandActionType.SqlPatchStartupUpgradeMode.toString())) {
                return null;
            }
            return new SQLPatchUpgradeModeCommand((CommandAction)a);
        }
    }
}

