/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.cmdtranslator.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import model.common.AbstractBaseTarget;
import model.common.OracleHome;
import model.db_crs.RACDatabase;
import oracle.opatch.system.automation.jaxb.ActionType;
import oracle.opatch.system.automation.jaxb.CommandAction;
import oracle.opatch.system.automation.jaxb.Strategy;
import oracle.oplan.db.cmdtranslator.DBCommandUtils;
import oracle.oplan.db.engine.CRSContextPopulator;
import oracle.oplan.db.patch.CRSApplicabilityTarget;
import oracle.oplan.sdk.cmdtranslator.Command;
import oracle.oplan.sdk.cmdtranslator.CommandBuilder;
import oracle.oplan.sdk.cmdtranslator.CommandContext;
import oracle.oplan.sdk.cmdtranslator.CommandUtils;
import oracle.oplan.sdk.exec.api.ExecutionStep;
import oracle.oplan.sdk.graphlib.ConfigGraph;
import oracle.oplan.sdk.oplan.OPlan;
import oracle.oplan.sdk.oplan.SystemModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpfFilePreReqCommand
extends Command {
    private static String OPLAN_LOG = null;

    public SpfFilePreReqCommand(ActionType automationAction) {
        super(automationAction);
        this.automationAction = automationAction;
    }

    protected List<ExecutionStep> generateExecutionSteps(ConfigGraph configGraph, List<? extends AbstractBaseTarget> list) {
        ArrayList<ExecutionStep> steps = new ArrayList<ExecutionStep>();
        CRSContextPopulator contextPopulator = new CRSContextPopulator();
        for (AbstractBaseTarget abstractBaseTarget : list) {
            ExecutionStep executionStep;
            CommandContext context = contextPopulator.populateContext(configGraph, abstractBaseTarget);
            if (this.automationAction.isActsOnClone()) {
                contextPopulator.fixCloneContext(context);
            }
            if ((executionStep = this.getExecutionStep(context)) == null) continue;
            steps.add(executionStep);
        }
        return steps;
    }

    private ExecutionStep getExecutionStep(CommandContext context) {
        OracleHome oh = (OracleHome)context.getFirstTarget(OracleHome.class);
        AbstractBaseTarget primaryTarget = context.getPrimaryTarget();
        boolean isSQLPatchUpgradeMode = DBCommandUtils.isSQLPatchUpgradeMode();
        ExecutionStep executionStep = null;
        List patches = OPlan.getInstance().getOPlanEnv().getPatchesBag().getPatchesForTargetType(CommandUtils.getApplicabilityTargetType((String)CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.rac.toString()));
        if (DBCommandUtils.shouldExecuteSqlCommand(primaryTarget, patches, this.automationAction) && isSQLPatchUpgradeMode && primaryTarget instanceof RACDatabase) {
            executionStep = CommandUtils.getBasicExecutionStep((ActionType)this.automationAction, (CommandContext)context, null);
            ArrayList<String> cmds = new ArrayList<String>();
            cmds.add("export ORACLE_HOME=" + oh.getPath());
            OPLAN_LOG = "$ORACLE_HOME" + File.separator + "cfgtoollogs" + File.separator + "oplan";
            cmds.add("mkdir -p -m 775 " + OPLAN_LOG);
            String spfQueryFile = OPLAN_LOG + File.separator + "spfquery.sql";
            this.makeSpoolCommand(cmds, spfQueryFile);
            String sqlPlusCmd = "cd $ORACLE_HOME; ORACLE_HOME=" + oh.getPath() + " ORACLE_SID=" + DBCommandUtils.getOracleSID(executionStep, primaryTarget) + " ./bin/sqlplus / as sysdba @";
            cmds.add(sqlPlusCmd + spfQueryFile);
            this.makeShellFileContentToSearchContent(cmds, OPLAN_LOG + File.separator + "checkSpfFile");
            cmds.add("chmod +x " + OPLAN_LOG + File.separator + "checkSpfFile");
            cmds.add(OPLAN_LOG + File.separator + "checkSpfFile");
            for (String cmd : cmds) {
                executionStep.getCommand().add(new ExecutionStep.Command(cmd));
            }
        }
        return executionStep;
    }

    public void makeShellFileContentToSearchContent(List<String> cmd, String fileLoc) {
        cmd.add("echo '#!/bin/bash' > " + fileLoc);
        cmd.add("echo 'CAT_VAL=`cat " + OPLAN_LOG + File.separator + "spf.txt`' >> " + fileLoc);
        cmd.add("echo 'if [ $CAT_VAL = \"SPFILE\" ]; then' >> " + fileLoc);
        cmd.add("echo '   exit 0' >> " + fileLoc);
        cmd.add("echo 'else' >> " + fileLoc);
        cmd.add("echo '  echo ' Datapatch pre check exiting with failure status, as database is not using Spfile.'' >> " + fileLoc);
        cmd.add("echo '   exit 2' >> " + fileLoc);
        cmd.add("echo 'fi' >> " + fileLoc);
    }

    private void makeSpoolCommand(List<String> cmds, String fileLoc) {
        cmds.add("echo 'SET HEADING OFF' > " + fileLoc);
        cmds.add("echo 'SET SERVEROUTPUT OFF' >> " + fileLoc);
        cmds.add("echo 'SPOOL " + OPLAN_LOG + File.separator + "spf.txt' >> " + fileLoc);
        cmds.add("echo \"SELECT DECODE(value, NULL, 'PFILE', 'SPFILE') \\\"Init File Type\\\" FROM sys.v_\\$parameter WHERE name = 'spfile';\" >> " + fileLoc);
        cmds.add("echo 'SPOOL OFF' >> " + fileLoc);
        cmds.add("echo 'quit' >> " + fileLoc);
    }

    protected List<? extends AbstractBaseTarget> getApplicableTargets(ConfigGraph configGraph) {
        Class type = SystemModelUtils.getClassForType((String)this.automationAction.getActsOn());
        return configGraph.getTargets(type, this.automationAction.getStripe());
    }

    public static class Builder
    implements CommandBuilder {
        public Command getCommand(ActionType a, Strategy s) {
            if (!(a instanceof CommandAction) || !a.getType().equals("SPFilePreReqForUpgradeMode")) {
                return null;
            }
            return new SpfFilePreReqCommand(a);
        }
    }
}

