/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.cmdtranslator.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import model.common.AbstractBaseTarget;
import model.common.Host;
import model.common.OracleHome;
import model.db_crs.RACDBInstance;
import model.db_crs.RACDatabase;
import model.db_crs.SIDatabase;
import model.patchmodel.CompositePatch;
import model.patchmodel.GenericPatch;
import model.patchmodel.OPatchSingleton;
import oracle.opatch.system.automation.jaxb.ActionType;
import oracle.opatch.system.automation.jaxb.ApplySqlAction;
import oracle.opatch.system.automation.jaxb.SqlCommandType;
import oracle.opatch.system.automation.jaxb.Strategy;
import oracle.oplan.db.cmdtranslator.DBCommandUtils;
import oracle.oplan.db.cmdtranslator.commands.SqlPatchCommand;
import oracle.oplan.db.cookies.CRSMakeCloneHome;
import oracle.oplan.db.engine.CRSContextPopulator;
import oracle.oplan.db.patch.CRSApplicabilityTarget;
import oracle.oplan.sdk.ExecutionMode;
import oracle.oplan.sdk.OPlanException;
import oracle.oplan.sdk.cmdtranslator.Command;
import oracle.oplan.sdk.cmdtranslator.CommandBuilder;
import oracle.oplan.sdk.cmdtranslator.CommandContext;
import oracle.oplan.sdk.cmdtranslator.CommandUtils;
import oracle.oplan.sdk.exec.api.ExecutionStep;
import oracle.oplan.sdk.graphlib.ConfigGraph;
import oracle.oplan.sdk.oplan.OPlan;
import oracle.oplan.sdk.oplan.SystemModelUtils;
import oracle.oplan.sdk.oplan.VariableResolver;
import oracle.oplan.sdk.patch.Patchmd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlCommand
extends Command {
    private static String applyType = "apply";
    private static String rollbackType = "rollback";
    private static String switchbackType = "switchback";
    private static String restoreType = "restore";
    private static String streamsType = "Streams";
    private static String startDGBrokerType = "startDGBroker";
    private static String OPLAN_LOG = null;
    Logger logger = Logger.getLogger(SqlCommand.class.getName());
    ApplySqlAction sqlAutomationAction;
    boolean firstSqlCommand = true;

    public SqlCommand(ApplySqlAction automationAction) {
        super((ActionType)automationAction);
        this.sqlAutomationAction = automationAction;
    }

    public ExecutionStep getExecutionStep(CommandContext context) {
        AbstractBaseTarget primaryTarget = context.getPrimaryTarget();
        OracleHome oh = (OracleHome)context.getFirstTarget(OracleHome.class);
        this.firstSqlCommand = true;
        if (applyType.equalsIgnoreCase(this.sqlAutomationAction.getType()) || rollbackType.equalsIgnoreCase(this.sqlAutomationAction.getType()) || switchbackType.equalsIgnoreCase(this.sqlAutomationAction.getType()) || restoreType.equalsIgnoreCase(this.sqlAutomationAction.getType())) {
            List patches = OPlan.getInstance().getOPlanEnv().getPatchesBag().getPatchesForTargetType(CommandUtils.getApplicabilityTargetType((String)CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.rac.toString()));
            boolean isPatchmdExist = false;
            String wrapperSqlPath = null;
            if (DBCommandUtils.shouldExecuteSqlCommand(primaryTarget, patches, (ActionType)this.sqlAutomationAction)) {
                if (DBCommandUtils.isPhysicalStandbyDatabase(primaryTarget)) {
                    context = DBCommandUtils.resetContextForStandbyDB(primaryTarget);
                }
                ExecutionStep executionStep = CommandUtils.getBasicExecutionStep((ActionType)this.sqlAutomationAction, (CommandContext)context, null);
                if (this.automationAction.isActsOnClone() && DBCommandUtils.isRemoteDB(context.getPrimaryTarget())) {
                    this.logger.info("Current step is running on remote db " + context.getPrimaryTarget().getDisplayName() + ". Set acts_on_clone property to null");
                    executionStep.getAutomationAction().setActsOnClone(null);
                }
                List sortedPatches = CommandUtils.sortPatchesById((List)patches);
                for (GenericPatch patch : sortedPatches) {
                    if (!(patch instanceof OPatchSingleton) && !(patch instanceof CompositePatch)) continue;
                    String patchmdXMLContent = null;
                    if (patch instanceof OPatchSingleton) {
                        OPatchSingleton opatchPatch = (OPatchSingleton)patch;
                        patchmdXMLContent = opatchPatch.getPatchMDxml();
                        if (null != opatchPatch.getWrapperSqlPath() && !"".equals(opatchPatch.getWrapperSqlPath())) {
                            wrapperSqlPath = "@sqlpatch" + File.separator + opatchPatch.getWrapperSqlPath();
                        }
                    } else {
                        CompositePatch comPatch = (CompositePatch)patch;
                        patchmdXMLContent = comPatch.getPatchMDxml();
                    }
                    if (patchmdXMLContent != null && patchmdXMLContent.length() > 0) {
                        isPatchmdExist = true;
                        try {
                            Patchmd patchmd = new Patchmd(patchmdXMLContent);
                            String sqlcmd = null;
                            if (applyType.equalsIgnoreCase(this.sqlAutomationAction.getType())) {
                                sqlcmd = this.buildSqlCmd(patchmd.getApplySQLPlusCommand());
                            } else if (rollbackType.equalsIgnoreCase(this.sqlAutomationAction.getType())) {
                                sqlcmd = this.buildSqlCmd(patchmd.getRollbackSQLPlusCommand());
                            } else if (switchbackType.equalsIgnoreCase(this.sqlAutomationAction.getType())) {
                                sqlcmd = this.buildSwitchbackCmd(context, patchmd.getRollbackSQLPlusCommand());
                                if (sqlcmd == null) {
                                    sqlcmd = this.buildSqlCmd(patchmd.getRollbackSQLPlusCommand());
                                }
                            } else if (restoreType.equalsIgnoreCase(this.sqlAutomationAction.getType())) {
                                sqlcmd = this.buildRestoreCmd(context, patchmd.getApplySQLPlusCommand());
                            }
                            ArrayList cmds = new ArrayList();
                            if ((primaryTarget instanceof SIDatabase || primaryTarget instanceof RACDatabase) && primaryTarget instanceof RACDatabase) {
                                for (String s : cmds) {
                                    executionStep.getCommand().add(new ExecutionStep.Command(s));
                                }
                            }
                            if (!this.IsStandaloneExecutionMode()) {
                                ExecutionStep.Command exeStepCmd = new ExecutionStep.Command(this.wrapSqlSteps(sqlcmd, context));
                                executionStep.getCommand().add(exeStepCmd);
                                continue;
                            }
                            String cmd = this.getSqlPlusStepCommand(executionStep, context);
                            executionStep.getCommand().add(new ExecutionStep.Command(cmd));
                            ExecutionStep.Command exeStepCmd = new ExecutionStep.Command(sqlcmd, ExecutionStep.Command.CommandType.SQL);
                            executionStep.getCommand().add(exeStepCmd);
                        }
                        catch (Patchmd.PatchmdParsingException e) {
                            this.logger.log(Level.WARNING, "PatchmdParsingException occurred in SqlCommand.getExecutionStep()", e);
                        }
                        continue;
                    }
                    if (wrapperSqlPath == null) continue;
                    String sqlcmd = null;
                    if (applyType.equalsIgnoreCase(this.sqlAutomationAction.getType()) || restoreType.equalsIgnoreCase(this.sqlAutomationAction.getType())) {
                        sqlcmd = wrapperSqlPath + File.separator + "postinstall.sql";
                    } else if (rollbackType.equalsIgnoreCase(this.sqlAutomationAction.getType()) || switchbackType.equalsIgnoreCase(this.sqlAutomationAction.getType())) {
                        sqlcmd = wrapperSqlPath + File.separator + "postdeinstall.sql";
                    }
                    if (!this.IsStandaloneExecutionMode()) {
                        ExecutionStep.Command exeStepCmd = new ExecutionStep.Command(this.wrapSqlSteps(sqlcmd, context));
                        executionStep.getCommand().add(exeStepCmd);
                        continue;
                    }
                    String cmd = this.getSqlPlusStepCommand(executionStep, context);
                    executionStep.getCommand().add(new ExecutionStep.Command(cmd));
                    ExecutionStep.Command exeStepCmd = new ExecutionStep.Command(sqlcmd, ExecutionStep.Command.CommandType.SQL);
                    executionStep.getCommand().add(exeStepCmd);
                }
                if (isPatchmdExist || null != wrapperSqlPath) {
                    if (!this.IsStandaloneExecutionMode()) {
                        executionStep.getCommand().add(new ExecutionStep.Command(this.wrapSqlSteps("EXIT;", context)));
                        executionStep.getCommand().add(new ExecutionStep.Command(this.getSqlPlusStep(executionStep, context, true)));
                    }
                    ArrayList cmds = new ArrayList();
                    if ((primaryTarget instanceof SIDatabase || primaryTarget instanceof RACDatabase) && primaryTarget instanceof RACDatabase) {
                        for (String s : cmds) {
                            executionStep.getCommand().add(new ExecutionStep.Command(s));
                        }
                    }
                } else {
                    return null;
                }
                return executionStep;
            }
        } else {
            ExecutionStep executionStep = null;
            if (startDGBrokerType.equalsIgnoreCase(this.sqlAutomationAction.getType())) {
                if (!DBCommandUtils.isDataGuardConfig(primaryTarget) || !DBCommandUtils.isUsingBroker(primaryTarget)) {
                    return executionStep;
                }
                if (DBCommandUtils.isPhysicalStandbyDatabase(primaryTarget)) {
                    context = DBCommandUtils.resetContextForStandbyDB(primaryTarget);
                }
            }
            if (!this.IsStandaloneExecutionMode()) {
                executionStep = CommandUtils.getBasicExecutionStep((ActionType)this.sqlAutomationAction, (CommandContext)context, null);
                executionStep.getCommand().addAll(this.getWrapSqlCommand(context));
                executionStep.getCommand().add(new ExecutionStep.Command(this.wrapSqlSteps("EXIT;", context)));
                executionStep.getCommand().add(new ExecutionStep.Command(this.getSqlPlusStep(executionStep, context, true)));
            } else {
                executionStep = this.getSqlPlusStep(context);
                executionStep.getCommand().addAll(this.getSqlCommand(context));
            }
            return executionStep;
        }
        return null;
    }

    private String wrapSqlSteps(String cmd, String tmpSqlFile) {
        String wrapedStep;
        if (this.firstSqlCommand) {
            wrapedStep = "echo \"" + cmd + "\" > " + tmpSqlFile;
            this.firstSqlCommand = false;
        } else {
            wrapedStep = "echo \"" + cmd + "\" >> " + tmpSqlFile;
        }
        return wrapedStep;
    }

    private String wrapSqlSteps(String cmd, CommandContext context) {
        String tmpSqlFile = this.getTmpSqlFile(context);
        if (cmd.contains("${Uppercase_ORACLE_SID}")) {
            cmd = cmd.replaceAll("\\$\\{Uppercase_ORACLE_SID\\}", this.getOracleSID(context).toUpperCase());
        }
        return this.wrapSqlSteps(cmd, tmpSqlFile);
    }

    private String getTmpSqlFile(CommandContext context) {
        OracleHome oh = (OracleHome)context.getFirstTarget(OracleHome.class);
        String ohName = oh.getName() == null ? "" : oh.getName().replace(" ", "");
        String user = oh.getOwner();
        String tmpSqlFile = "/tmp/" + ohName + "_" + user + ".sql";
        return tmpSqlFile;
    }

    private boolean IsStandaloneExecutionMode() {
        return ExecutionMode.STANDALONE.equals((Object)OPlan.getInstance().getOPlanEnv().getExecutionMode());
    }

    private String getSqlPlusStep(ExecutionStep executionStep, CommandContext context, boolean flag) {
        String cmd = this.getSqlPlusStepCommand(executionStep, context);
        if (!this.IsStandaloneExecutionMode() && flag) {
            String tmpSqlFile = this.getTmpSqlFile(context);
            cmd = cmd + " @" + tmpSqlFile;
        }
        return cmd;
    }

    private ExecutionStep getSqlPlusStep(CommandContext context) {
        ExecutionStep executionStep = CommandUtils.getBasicExecutionStep((ActionType)this.sqlAutomationAction, (CommandContext)context, null);
        String cmd = this.getSqlPlusStepCommand(executionStep, context);
        executionStep.getCommand().add(new ExecutionStep.Command(cmd));
        return executionStep;
    }

    private String getSqlPlusStepCommand(ExecutionStep executionStep, CommandContext context) {
        String cmd = null;
        OracleHome oh = (OracleHome)context.getFirstTarget(OracleHome.class);
        AbstractBaseTarget primaryTarget = context.getPrimaryTarget();
        String scriptLocationRoot = this.getScriptLocationRoot(context);
        String oracleHomePath = this.getOracleHomePath(context);
        String OracleSid = DBCommandUtils.getOracleSID(executionStep, primaryTarget);
        if (!(primaryTarget instanceof SIDatabase || primaryTarget instanceof RACDatabase || primaryTarget instanceof RACDBInstance)) {
            throw new OPlanException("SqlCommand action can act only on RACDatabase, SIDatabase, but found: " + primaryTarget.getClass().getName());
        }
        cmd = "cd " + scriptLocationRoot + " ; ORACLE_HOME=" + oracleHomePath + " ORACLE_SID=" + OracleSid + " " + oh.getPath() + "/bin/sqlplus / as " + this.sqlAutomationAction.getConnectAs();
        return cmd;
    }

    private List<ExecutionStep.Command> getSqlCommand(CommandContext context) {
        ArrayList<ExecutionStep.Command> cmdList = new ArrayList<ExecutionStep.Command>();
        for (oracle.opatch.system.automation.jaxb.SqlCommand sc : this.sqlAutomationAction.getSqlCommand()) {
            String rep_sqlcmd = VariableResolver.replaceContextProperties((String)sc.getCommand().trim(), (CommandContext)context);
            ExecutionStep.Command sqlcmd = new ExecutionStep.Command(rep_sqlcmd, ExecutionStep.Command.CommandType.SQL);
            if (sc.getErrorHandling() != null) {
                sqlcmd.setErrorMessage(sc.getErrorHandling().getFatalError());
            }
            cmdList.add(sqlcmd);
        }
        return cmdList;
    }

    private List<ExecutionStep.Command> getWrapSqlCommand(CommandContext context) {
        ArrayList<ExecutionStep.Command> cmdList = new ArrayList<ExecutionStep.Command>();
        String tmpSqlFile = this.getTmpSqlFile(context);
        for (oracle.opatch.system.automation.jaxb.SqlCommand sc : this.sqlAutomationAction.getSqlCommand()) {
            String rep_sqlcmd = VariableResolver.replaceContextProperties((String)sc.getCommand().trim(), (CommandContext)context);
            if (rep_sqlcmd.contains("&{Uppercase_ORACLE_SID}")) {
                rep_sqlcmd = rep_sqlcmd.replaceAll("\\$\\{Uppercase_ORACLE_SID\\}", this.getOracleSID(context).toUpperCase());
            }
            if (rep_sqlcmd.contains("\n")) {
                rep_sqlcmd = rep_sqlcmd.replaceAll("\n", " ");
                rep_sqlcmd = rep_sqlcmd.replaceAll("[ ]+", " ");
            }
            ExecutionStep.Command sqlcmd = new ExecutionStep.Command(this.wrapSqlSteps(rep_sqlcmd, tmpSqlFile));
            if (sc.getErrorHandling() != null) {
                sqlcmd.setErrorMessage(sc.getErrorHandling().getFatalError());
            }
            cmdList.add(sqlcmd);
        }
        return cmdList;
    }

    private String getOracleHomePath(CommandContext context) {
        if (switchbackType.equalsIgnoreCase(this.sqlAutomationAction.getType())) {
            SqlCommandType type = null;
            for (oracle.opatch.system.automation.jaxb.SqlCommand cmd : this.sqlAutomationAction.getSqlCommand()) {
                SqlCommandType cmdType = cmd.getType();
                if (type == null) {
                    type = cmdType;
                    continue;
                }
                if (cmdType.equals((Object)type)) continue;
                throw new IllegalArgumentException("Invalid automation xml: SQL command types under one apply-sql-action must all either be (INLINE_SOURCE and SCRIPT_IN_ORACLE_HOME) or (SCRIPT_IN_CLONED_ORACLE_HOME). Found both one of each variety in this case.");
            }
            if (SqlCommandType.SCRIPT_IN_CLONED_ORACLE_HOME.equals(type)) {
                String clonePath = this.getClonePath(context);
                return clonePath;
            }
            return ((OracleHome)context.getFirstTarget(OracleHome.class)).getPath();
        }
        return ((OracleHome)context.getFirstTarget(OracleHome.class)).getPath();
    }

    private String getScriptLocationRoot(CommandContext context) {
        SqlCommandType type = null;
        for (oracle.opatch.system.automation.jaxb.SqlCommand cmd : this.sqlAutomationAction.getSqlCommand()) {
            SqlCommandType tmp = cmd.getType();
            if (tmp.equals((Object)SqlCommandType.INLINE_SOURCE)) {
                tmp = SqlCommandType.SCRIPT_IN_ORACLE_HOME;
            }
            if (type == null) {
                type = tmp;
                continue;
            }
            if (tmp.equals((Object)type)) continue;
            throw new IllegalArgumentException("Invalid automation xml: SQL command types under one apply-sql-action must all either be (INLINE_SOURCE and SCRIPT_IN_ORACLE_HOME) or (SCRIPT_IN_CLONED_ORACLE_HOME). Found both one of each variety in this case.");
        }
        if (DBCommandUtils.isRemoteDB(context.getPrimaryTarget())) {
            type = SqlCommandType.SCRIPT_IN_ORACLE_HOME;
        }
        if (SqlCommandType.SCRIPT_IN_CLONED_ORACLE_HOME.equals((Object)type)) {
            String clonePath = this.getClonePath(context);
            return clonePath;
        }
        return ((OracleHome)context.getFirstTarget(OracleHome.class)).getPath();
    }

    private String getOracleSID(CommandContext context) {
        AbstractBaseTarget primaryTarget = context.getPrimaryTarget();
        if (primaryTarget instanceof RACDatabase) {
            RACDatabase racDB = (RACDatabase)primaryTarget;
            return racDB.getDatabaseName();
        }
        if (primaryTarget instanceof SIDatabase) {
            SIDatabase siDB = (SIDatabase)primaryTarget;
            return siDB.getDatabaseName();
        }
        throw new OPlanException("SqlCommand action can act only on RACDatabase, SIDatabase, but found: " + primaryTarget.getClass().getName());
    }

    protected List<ExecutionStep> generateExecutionSteps(ConfigGraph g, List<? extends AbstractBaseTarget> actsOnlyOnTargets) {
        ArrayList<ExecutionStep> steps = new ArrayList<ExecutionStep>();
        CRSContextPopulator contextPopulator = new CRSContextPopulator();
        for (AbstractBaseTarget abstractBaseTarget : actsOnlyOnTargets) {
            ExecutionStep executionStep;
            RACDBInstance dbInst;
            CommandContext context = contextPopulator.populateContext(g, abstractBaseTarget);
            if ((!CommandUtils.isSkipTargetCookieSet((Command)this, (AbstractBaseTarget)abstractBaseTarget) || !this.sqlAutomationAction.getType().equals("savePDBState") && !this.sqlAutomationAction.getType().equals("discardPDBState")) && this.sqlAutomationAction.isActsOnClone()) {
                contextPopulator.fixCloneContext(context);
            }
            if (abstractBaseTarget instanceof RACDBInstance && "racone".equals((dbInst = (RACDBInstance)abstractBaseTarget).getDbRAC().getDatabaseType()) && "no".equals(dbInst.getIsRunning()) || (executionStep = this.getExecutionStep(context)) == null) continue;
            steps.add(executionStep);
        }
        return steps;
    }

    protected List<? extends AbstractBaseTarget> getApplicableTargets(ConfigGraph g) {
        Class type = SystemModelUtils.getClassForType((String)this.automationAction.getActsOn());
        return g.getTargets(type, this.automationAction.getStripe());
    }

    private String buildSqlCmd(String sqlScript) {
        if (sqlScript == null) {
            this.logger.log(Level.WARNING, "SqlCommand.buildSqlCmd(): Sql command is empty.");
            return "";
        }
        return sqlScript.replaceFirst("\\$ORACLE_HOME\\/", "@");
    }

    private String buildSwitchbackCmd(CommandContext context, String sqlScript) {
        String patchType = null;
        if (sqlScript.contains("catexa")) {
            patchType = "EXA";
        } else if (sqlScript.contains("catpsu")) {
            patchType = "PSU";
        } else if (sqlScript.contains("catcpu")) {
            patchType = "CPU";
        }
        if (patchType == null) {
            return null;
        }
        String repSqlcmd = null;
        for (oracle.opatch.system.automation.jaxb.SqlCommand sc : this.sqlAutomationAction.getSqlCommand()) {
            String sqlcmd = sc.getCommand().trim();
            System.out.println("sqlcmd: " + sqlcmd);
            repSqlcmd = VariableResolver.replaceContextProperties((String)sqlcmd.replaceFirst("\\$\\{PATCH_TYPE\\}", patchType), (CommandContext)context);
        }
        return repSqlcmd;
    }

    private String buildRestoreCmd(CommandContext context, String sqlScript) {
        if (sqlScript == null) {
            this.logger.log(Level.WARNING, "SqlCommand.buildSqlCmd(): Sql command is empty.");
            return "";
        }
        String clonePath = this.getClonePath(context);
        return sqlScript.replaceFirst("\\$ORACLE_HOME", "@" + clonePath);
    }

    private String getClonePath(CommandContext context) {
        OracleHome oh = (OracleHome)context.getFirstTarget(OracleHome.class);
        AbstractBaseTarget db = context.getPrimaryTarget();
        String clonePath = null;
        if (db instanceof RACDatabase) {
            RACDatabase racDB = (RACDatabase)db;
            clonePath = ((CRSMakeCloneHome)OPlan.getInstance().getMakeCloneHome()).getClonePathforRAC(racDB, oh);
        } else if (db instanceof SIDatabase) {
            SIDatabase siDB = (SIDatabase)db;
            clonePath = ((CRSMakeCloneHome)OPlan.getInstance().getMakeCloneHome()).getClonePathforSIDB(siDB, oh);
        }
        return clonePath;
    }

    private void getStartSqlUpgradeModeStep(OracleHome oh, List<String> cmds, ExecutionStep executionStep, CommandContext context, boolean isPDB) {
        OPLAN_LOG = oh.getPath() + File.separator + "cfgtoollogs" + File.separator + "oplan";
        String dataPatchfileForSetClusterFalse = OPLAN_LOG + File.separator + "dataPatchfileForSetClusterFalse.sql";
        cmds.add("echo 'alter system set cluster_database=false scope=spfile;' > " + dataPatchfileForSetClusterFalse);
        cmds.add("echo 'quit' >> " + dataPatchfileForSetClusterFalse);
        String sqlPlusCmd = this.getSqlPlusStepCommand(executionStep, context);
        cmds.add(sqlPlusCmd + dataPatchfileForSetClusterFalse);
        List hosts = context.getTargets(Host.class);
        for (Host host : hosts) {
            this.getStopStartHomeCommand(oh, "stop", cmds, host.getHostName());
        }
        String dataPatchfileForStartupUpgrade = OPLAN_LOG + File.separator + "dataPatchfileForStartupUpgrade.sql";
        cmds.add("echo 'startup upgrade' > " + dataPatchfileForStartupUpgrade);
        if (isPDB) {
            cmds.add("echo 'alter pluggable database all open upgrade;' >> " + dataPatchfileForStartupUpgrade);
        }
        cmds.add("echo 'quit' >> " + dataPatchfileForStartupUpgrade);
        cmds.add(sqlPlusCmd + dataPatchfileForStartupUpgrade);
    }

    private void getExitSqlUpgradeModeStep(OracleHome oh, List<String> cmds, ExecutionStep executionStep, CommandContext context, boolean isPDB) {
        OPLAN_LOG = oh.getPath() + File.separator + "cfgtoollogs" + File.separator + "oplan";
        String sqlPlusCmd = this.getSqlPlusStepCommand(executionStep, context);
        String dataPatchfileForSetClusterTrue = OPLAN_LOG + File.separator + "dataPatchfileForSetClusterTrue.sql";
        cmds.add("echo 'alter system set cluster_database=true scope=spfile;' > " + dataPatchfileForSetClusterTrue);
        cmds.add("echo 'shutdown' >> " + dataPatchfileForSetClusterTrue);
        cmds.add("echo 'quit' >> " + dataPatchfileForSetClusterTrue);
        cmds.add(sqlPlusCmd + dataPatchfileForSetClusterTrue);
        List hosts = context.getTargets(Host.class);
        for (Host host : hosts) {
            this.getStopStartHomeCommand(oh, "start", cmds, host.getHostName());
        }
    }

    private static String getUUID(OracleHome oh) {
        boolean clone = false;
        if (oh.getOriginalOracleHome() != null) {
            oh = oh.getOriginalOracleHome();
            clone = true;
        }
        String str = oh.getUniqueId().replace(':', '_');
        if (clone) {
            str = str + "_clone";
        }
        return str;
    }

    private void getStopStartHomeCommand(OracleHome oh, String type, List<String> cmds, String hostName) {
        String uuid = SqlCommand.getUUID(oh);
        String staFileLoc = oh.getPath() + File.separator + "cfgtoollogs" + File.separator + "oplan" + File.separator + "statfile" + File.separator + hostName;
        cmds.add("mkdir -p " + staFileLoc);
        File statefile = new File(staFileLoc, uuid + "_" + hostName + ".stat");
        String cmd = "cd " + oh.getPath() + "; ORACLE_HOME=" + oh.getPath() + " ./bin/srvctl " + type + " home -o " + oh.getPath() + " -n " + hostName;
        if (type.equalsIgnoreCase("stop")) {
            cmd = cmd + " -f";
            if (oh.getHomeType().equals("rac")) {
                String version = DBCommandUtils.getRACDBVersionForCurrentHome(oh);
                if (version != null) {
                    cmd = version.startsWith("11") ? cmd + " -t TRANSACTIONAL" : cmd + " -stopoption TRANSACTIONAL";
                } else {
                    Logger.getLogger(SqlPatchCommand.class.getName()).info("Unable to get the DB version, so not performing stop DB home in transactional mode");
                }
            }
        }
        cmd = cmd + " -s " + statefile.getAbsolutePath();
        cmds.add(cmd);
        if (type.equalsIgnoreCase("start")) {
            cmds.add("rm -rf " + staFileLoc);
        }
    }

    public boolean shouldIncludeStepInExecutionMode(ExecutionMode exeMode) {
        return !ExecutionMode.OPATCH.equals((Object)exeMode) || !streamsType.equalsIgnoreCase(this.sqlAutomationAction.getType());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    implements CommandBuilder<SqlCommand> {
        public SqlCommand getCommand(ActionType a, Strategy s) {
            if (!(a instanceof ApplySqlAction)) {
                return null;
            }
            return new SqlCommand((ApplySqlAction)a);
        }
    }
}

