/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.cmdtranslator.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import model.common.AbstractBaseTarget;
import model.common.OracleHome;
import oracle.opatch.system.automation.jaxb.ActionType;
import oracle.opatch.system.automation.jaxb.CommandAction;
import oracle.opatch.system.automation.jaxb.DeploymentSubType;
import oracle.opatch.system.automation.jaxb.Strategy;
import oracle.oplan.db.cmdtranslator.commands.CRSCommandActionType;
import oracle.oplan.sdk.cmdtranslator.CommandBuilder;
import oracle.oplan.sdk.cmdtranslator.CommandContext;
import oracle.oplan.sdk.cmdtranslator.commands.SimpleShellCommand;
import oracle.oplan.sdk.exec.api.ExecutionStep;
import oracle.oplan.sdk.graphlib.ConfigGraph;
import oracle.oplan.sdk.oplan.OPlan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StopCrsCommand
extends SimpleShellCommand {
    Logger logger = Logger.getLogger(StopCrsCommand.class.getName());
    CommandAction automationAction;

    public StopCrsCommand(CommandAction automationAction) {
        super((ActionType)automationAction);
        this.automationAction = automationAction;
    }

    public List<ExecutionStep> generateExecutionSteps(ConfigGraph configGraph, List<? extends AbstractBaseTarget> actsOnlyOnTargets) {
        List<Object> executionSteps = new ArrayList<ExecutionStep>();
        if (this.isNonRollingDeploymentMode() && (executionSteps = super.generateExecutionSteps(configGraph, actsOnlyOnTargets)).size() > 1) {
            executionSteps.remove(0);
        }
        return executionSteps;
    }

    public List<String> getShellCommands(CommandContext context) {
        this.logger.log(Level.FINE, "Generating stopcrs command.");
        OracleHome oh = (OracleHome)context.getFirstTarget(OracleHome.class);
        String crsHome = oh.getPath();
        this.logger.log(Level.FINE, "OracleHome path = " + crsHome);
        String cmd = crsHome + "/bin/crsctl stop crs";
        return Collections.singletonList(cmd);
    }

    private boolean isNonRollingDeploymentMode() {
        String runtimeDeploymentSubType = OPlan.getInstance().getOPlanEnv().getProperty("runtimeDeploymentSubType");
        String autoDeploymentSubType = OPlan.getInstance().getOPlanEnv().getProperty("autoDeploymentSubType");
        return runtimeDeploymentSubType != null ? DeploymentSubType.NON_ROLLING_UPGRADE.toString().equalsIgnoreCase(runtimeDeploymentSubType) : DeploymentSubType.NON_ROLLING_UPGRADE.toString().equalsIgnoreCase(autoDeploymentSubType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    implements CommandBuilder<StopCrsCommand> {
        public StopCrsCommand getCommand(ActionType a, Strategy s) {
            if (!(a instanceof CommandAction) || !a.getType().equals(CRSCommandActionType.StopCRS.toString())) {
                return null;
            }
            StopCrsCommand com = new StopCrsCommand((CommandAction)a);
            return com;
        }
    }
}

