/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.cmdtranslator.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import model.common.AbstractBaseTarget;
import model.common.Host;
import model.common.OracleHome;
import model.db_crs.RACDBInstance;
import model.db_crs.SIDatabase;
import oracle.opatch.system.automation.jaxb.ActionType;
import oracle.opatch.system.automation.jaxb.CommandAction;
import oracle.opatch.system.automation.jaxb.PatchingPhase;
import oracle.opatch.system.automation.jaxb.Strategy;
import oracle.oplan.db.cmdtranslator.commands.CRSCommandActionType;
import oracle.oplan.db.engine.CRSContextPopulator;
import oracle.oplan.sdk.ExecutionMode;
import oracle.oplan.sdk.OPlanException;
import oracle.oplan.sdk.cmdtranslator.Command;
import oracle.oplan.sdk.cmdtranslator.CommandBuilder;
import oracle.oplan.sdk.cmdtranslator.CommandContext;
import oracle.oplan.sdk.cmdtranslator.CommandUtils;
import oracle.oplan.sdk.exec.api.ExecutionStep;
import oracle.oplan.sdk.graphlib.ConfigGraph;
import oracle.oplan.sdk.oplan.SystemModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StopStartDbConsole
extends Command {
    private final CRSCommandActionType type;
    private final Strategy strat;

    public StopStartDbConsole(ActionType automationAction, CRSCommandActionType type, Strategy strat) {
        super(automationAction);
        assert (CRSCommandActionType.StartDbConsole.equals((Object)type) || CRSCommandActionType.StopDbConsole.equals((Object)type));
        this.type = type;
        this.strat = strat;
    }

    private String getCommandForHost(String dbName, OracleHome oh) {
        String cmd = "if [ -d $(echo " + oh.getPath() + "/oc4j/j2ee/OC4J_DBConsole_" + ((Host)oh.getHosts().get(0)).getHostName() + "*_" + dbName + ") -a -d $(echo " + oh.getPath() + "/" + ((Host)oh.getHosts().get(0)).getHostName() + "*_" + dbName + ") ]; then  export ORACLE_UNQNAME=" + dbName + "; " + oh.getPath() + "/bin/emctl " + (CRSCommandActionType.StartDbConsole.equals((Object)this.type) ? "start" : "stop") + " dbconsole; else echo 'dbconsole not configured, hence skipping this step.'; fi";
        return cmd;
    }

    protected List<ExecutionStep> generateExecutionSteps(ConfigGraph g, List<? extends AbstractBaseTarget> actsOnlyOnTargets) {
        if (CommandUtils.shouldShutdownRACInstance((PatchingPhase)this.getPatchingPhase())) {
            if (Strategy.DCLI.equals((Object)this.strat)) {
                return this.generateDCLIExecutionSteps(g, actsOnlyOnTargets);
            }
            return this.generateNormalExecutionSteps(g, actsOnlyOnTargets);
        }
        return Collections.emptyList();
    }

    protected List<ExecutionStep> generateNormalExecutionSteps(ConfigGraph g, List<? extends AbstractBaseTarget> actsOnlyOnTargets) {
        ArrayList<ExecutionStep> steps = new ArrayList<ExecutionStep>();
        for (AbstractBaseTarget abstractBaseTarget : actsOnlyOnTargets) {
            if (!this.isValiedTarget(abstractBaseTarget)) {
                throw new OPlanException("StopStartDbConsole action can act only on RACDBInstance, but found: " + abstractBaseTarget.getClass().getName());
            }
            CommandContext cc = this.getCommandContext(abstractBaseTarget, g);
            ExecutionStep es = CommandUtils.getBasicExecutionStep((ActionType)this.automationAction, (CommandContext)cc, null);
            String cmd = this.getCommandForTarget(abstractBaseTarget, cc, es);
            es.getCommand().add(new ExecutionStep.Command(cmd));
            steps.add(es);
        }
        return steps;
    }

    private String getDBName(AbstractBaseTarget abt) {
        if (abt instanceof RACDBInstance) {
            RACDBInstance racDB = (RACDBInstance)abt;
            return racDB.getDbRAC().getDatabaseName();
        }
        if (abt instanceof SIDatabase) {
            SIDatabase siDB = (SIDatabase)abt;
            return siDB.getDatabaseName();
        }
        throw new OPlanException("StopStartDbConsole action can act only on RACDBInstance and SIDatabase, but found: " + abt.getClass().getName());
    }

    private boolean isValiedTarget(AbstractBaseTarget abt) {
        return abt instanceof RACDBInstance || abt instanceof SIDatabase;
    }

    protected List<ExecutionStep> generateDCLIExecutionSteps(ConfigGraph g, List<? extends AbstractBaseTarget> actsOnlyOnTargets) {
        HashMap<AbstractBaseTarget, ExecutionStep> db2step = new HashMap<AbstractBaseTarget, ExecutionStep>();
        ArrayList<ExecutionStep> steps = new ArrayList<ExecutionStep>();
        for (AbstractBaseTarget abstractBaseTarget : actsOnlyOnTargets) {
            ExecutionStep es;
            if (!this.isValiedTarget(abstractBaseTarget)) {
                throw new OPlanException("StopStartDbConsole action can act only on RACDBInstance, but found: " + abstractBaseTarget.getClass().getName());
            }
            CommandContext cc = this.getCommandContext(abstractBaseTarget, g);
            AbstractBaseTarget mapObj = abstractBaseTarget;
            if (abstractBaseTarget instanceof RACDBInstance) {
                RACDBInstance inst = (RACDBInstance)abstractBaseTarget;
                mapObj = inst.getDbRAC();
            }
            ExecutionStep executionStep = es = (es = (ExecutionStep)db2step.get(mapObj)) != null ? es : CommandUtils.getBasicExecutionStep((ActionType)this.automationAction, (CommandContext)cc, null);
            if (!steps.contains(es)) {
                steps.add(es);
            }
            String cmd = this.getCommandForTarget(abstractBaseTarget, cc, es);
            es.getCommand().add(new ExecutionStep.Command(cmd));
            if (db2step.get(mapObj) != null) continue;
            db2step.put(mapObj, es);
        }
        return steps;
    }

    private CommandContext getCommandContext(AbstractBaseTarget abt, ConfigGraph g) {
        CRSContextPopulator contextPopulator = new CRSContextPopulator();
        CommandContext cc = contextPopulator.populateContext(g, abt);
        if (this.automationAction.isActsOnClone()) {
            contextPopulator.fixCloneContext(cc);
        }
        return cc;
    }

    private String getCommandForTarget(AbstractBaseTarget abt, CommandContext cc, ExecutionStep es) {
        String dbName = this.getDBName(abt);
        String cmd = this.getCommandForHost(dbName, (OracleHome)cc.getFirstTarget(OracleHome.class));
        if (Strategy.DCLI.equals((Object)this.strat)) {
            cmd = CommandUtils.dcliPrefix((String)cmd, (List)cc.getTargets(Host.class), (String)es.getUser().getValue());
        }
        return cmd;
    }

    protected List<? extends AbstractBaseTarget> getApplicableTargets(ConfigGraph g) {
        Class type = SystemModelUtils.getClassForType((String)this.automationAction.getActsOn());
        return g.getTargets(type, this.automationAction.getStripe());
    }

    protected boolean includeTargetByVersion(ConfigGraph configGraph, AbstractBaseTarget abstractBaseTarget, ExecutionMode executionMode) {
        return true;
    }

    public static class Builder
    implements CommandBuilder {
        public Command getCommand(ActionType a, Strategy s) {
            if (a instanceof CommandAction && (a.getType().equals(CRSCommandActionType.StartDbConsole.toString()) || a.getType().equals(CRSCommandActionType.StopDbConsole.toString()))) {
                return new StopStartDbConsole(a, CRSCommandActionType.valueOf(a.getType()), s);
            }
            return null;
        }
    }
}

